crossref intab color standard method identif extinct select clr
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.file		 tmag.prg
!.syntax
!  @@ tmag measurements color std method [Ident?] [zero,extn,col] [Add_selec] [colr]
!.purpose        T-MAG photometric package
!		 compute a photmetric transformation
!.input		 meas.tbl is created by TMAG/MES then TMAG/MERG (and TMAG/EXPT)
!      columns:	:MAGNITUDE 
!		:airm	(manually from the frame)
!		:filter (manually)
!.output:	:stdmag 
!		:dmag  
!		:extn  
!.parameters
! 		 meas:	tab. with the measurements
!		 color:	B, V, R, I or FILE: color to be
!		        processed. Other will be ignored for the reduction
!  		        (which is done color by color) 
!		 std:	table containing the std magnitudes (landolt.tbl)
!		 meth:           Zero Pt    Extinction    Colour term
!		        A:       computed  Assumed=std/P6 assumed:def/p6
!			R:       computed     computed    assumed:def/p6
!			K:	 computed  Assumed:std/p6    computed    
!			C:       computed     computed       computed
!			Z:	Assumed/P6   Assumed/P6     Assumed/P6
!		 zero,ext,col:	ZP, extincion and colortern to be used
!                      (if nil, use default) 
!		 Id_found:	Are the star already identified? Y/N
!		 Add_select:	Add sel. to KEEP, like
!                               	seq.ge.10.and.seq.le.20
!				use "new" for a reset, eg changing filter.
!                colr:  color to be used for the color reduction, def R-I
!
!.usage
!	measure the std stars with
!		@@ tmag_mes in_cat tblPrefix stdTable
!	merge the measurements tables with
!	        @@ tmag_merge.prg input.cat output.tbl tab_prefix 
!	if needed, correct for the exposure time with
!		@@ tmag_exptime output.tbl 
!	compute the solution with tmag
!	check the results with 
!	        @@ tmag_plot table color mode(A)
!	edit the results with
!	        @@ tmag_edit
!       rerun   @@ tmag for new solution
!-----------------------------------------------------------------------
!.version	Thu Aug 31 06:08:24 2000 amag comp
!               Wed Jul  2 02:21:36 1997 running
!.author	ORH@IfA
!----------------------------------------------------------------------
defi/par p1 ?? c "measurement table"
if p1 .eq. "??" then
   $head -28 $MID_WORK/tmag.prg
   return/exit
endif
defi/par p2 FILE C "color?"
defi/par p3 MID_WORK:landolt.tbl c "standard table"
defi/par p4 R c "Solution method? Assumed extin./Regre.lin./Colour?"
defi/par p5 N c "Stars already identified?"
defi/par p6 nil,nil,nil C "zero,extinction,colour? def: nil"
defi/par p7 none c "additional selection?"
defi/par p8 R-I C "color to be used for the color reduction"
writ/out "------------------------------------------------------------------------------"
!
!-- some variables
!
defi/loc mes_len/i/1/1 0
defi/loc std_len/i/1/1 0
defi/loc w_l1/i/1/1 0
defi/loc w_l2/i/1/1 0
defi/loc w_c/c/1/12 " "
defi/loc w_c1/c/1/12 " "
defi/loc w_c2/c/1/12 " "
defi/loc w/r/1/2 0.,0.

defi/loc i/i/1/1 0
defi/loc j/i/1/1 0
defi/loc glo_filt/c/1/1 "-"
defi/loc fra_filt/c/1/1 "-"

!
!
!---PARAMETERS CONV.------------------------------
!
defi/loc intab/c/1/72 {p1}
@@ tmag_checkfile {intab} .tbl check
intab = outputc

defi/loc stdtab/c/1/72 {p3}
@@ tmag_checkfile {stdtab} .tbl check
stdtab = outputc

writ/key method/c/1/1 {p4}
method = M$UPPER(method)

writ/key st_idt/c/1/1 {p5}
st_idt = M$UPPER("{st_idt}")

writ/key wexcl/c/1/24 {p6}
i = m$index(wexcl,",")
if i .eq. 0 then
   writ/out "***ERROR*** this: >{wexcl}< is supposed to be something like"
   writ/out "           extin,color e.g. 0.125,-.19 or 0.2,nil "
   return
endif

writ/key wselect/c/1/72 {p7}

i = i-1
j = i+2
defi/loc zero_tmp/c/1/12 {wexcl(1:{i})}
wexcl = wexcl({j}:)//"                 "

i = m$index(wexcl,",")
i = i-1
j = i+2
defi/loc extn_tmp/c/1/12 {wexcl(1:{i})}
defi/loc colr_tmp/c/1/12 {wexcl({j}:)}


defi/loc clridx/c/1/3 {p8}
if "{clridx(2:2)}" .ne. "-" then
   writ/out "***ERROR*** this: >{clridx}< is supposed to be something like"
   writ/out "            filter-filter, e.g.  R-I "
   return
else
   writ/out "index = *{clridx}*"
endif


copy/tab {stdtab} w_std !- you never know what can happen...

mes_len = {{intab},TBLCONTR(4)}
std_len = {w_std.tbl,TBLCONTR(4)}
!
!--- DEFAULT VALUES OF EXTN AND COLR TERMS
!
wri/key extn_V/r/1/1 0.125
wri/key extn_B/r/1/1 0.214
wri/key extn_R/r/1/1 0.091
wri/key extn_I/r/1/1 0.051
wri/key extn_W/r/1/1 0.108 !broad VR


wri/key clr_V/r/1/1 0.
wri/key clr_B/r/1/1 0.
wri/key clr_R/r/1/1 -.117
wri/key clr_I/r/1/1 0.
wri/key clr_W/r/1/1 0.
!
!- WHICH FILTER? --------------------------------------------------
!
if p2 .eq. "FILE" then
   i = m$index(p1,"B") 
   if i .ne. 0  writ/key glo_filt B

   i = m$index(p1,"VR") 
   if i .ne. 0  writ/key glo_filt W ! this is the broad VR filter

   i = m$index(p1,"V") 
   if i .ne. 0  writ/key glo_filt V

   i = m$index(p1,"R")
   if i .ne. 0  writ/key glo_filt R

   i = m$index(p1,"I")
   if i .ne. 0 writ/key glo_filt I

   method = "C"
   writ/out "*info* method set to C"
else !-- I assume that I all the colors are toguther, everything will
     !   be reduced at the same time...
   writ/key glo_filt {p2}
   glo_filt = M$UPPER(glo_filt)
   !-- change default extinction:
   if extn_tmp .ne. "nil"  extn_{glo_filt} = {extn_tmp}
   if colr_tmp .ne. "nil"  clr_{glo_filt} = {colr_tmp}
endif

writ/out "*info* filter >{glo_filt}<"

!
!- INIT TABLE IF STARS NOT YET IDENTITIED --------------------
!

if St_Idt .ne. "Y" then
   !-- MEAS.TAB.
   j = m$existc(intab,":select")
   if j .gt. 0 then
      writ/out " "
      writ/out "***WARNING*** I have been here before -  "
      writ/out "              do you want to reset the table? "
      w_c = "proceed"
      inqui/key w_c  "              proceed, or Ctrl-C"
      w_c = M$UPPER(w_c)
      if w_c .eq. "NO" goto select:
   
      dele/col {intab} :select
   endif

   writ/out "*info* creating/updating the following working columns:"
   writ/out "  Table: {p1}"
   writ/out "  Columns: :DMAG, :STDMAG, :STDCOL, :STDMAG,"
   writ/out "           :EXTN, :ZERO, :SELECT"

   j = m$existc(intab,":dmag")
   if j .lt. 0 then
      crea/col {intab} :dmag ? F8.3 R*4
   else
      comp/tab {intab} :dmag = -9999.
   endif

   j = m$existc(intab,":stdmag")
   if j .lt. 0 then
      crea/col {intab} :stdmag ? F8.3 R*4
   else
      comp/tab {intab} :stdmag = -9999.
   endif

   j = m$existc(intab,":stdcol")
   if j .lt. 0 then
      crea/col {intab} :stdcol ? F8.3 R*4
   else
      comp/tab {intab} :stdcol = -9999.
   endif

   j = m$existc(intab,":stdmag")
   if j .lt. 0 then
      comp/tab {intab} :stdmag = -1.
   else
      comp/tab {intab} :stdmag = -9999.
   endif

   j = m$existc(intab,":extn")
   if j .lt. 0 then
      crea/col {intab} :extn ? F8.3 R*4
   else
      comp/tab {intab} :extn = -9999.
   endif

   j = m$existc(intab,":zero")
   if j .lt. 0 then
      crea/col {intab} :zero ? F8.3 R*4
   else
      comp/tab {intab} :zero = -9999.
   endif

   j = m$existc(intab,":zero")
   if j .lt. 0 then
      comp/tab {intab} :zero = -1.
   else
      comp/tab {intab} :zero = -9999.
   endif

   !--- STD TABLE
   sele/tab {stdtab} all
   writ/out "*info*Number of standard stars in ref. table:"
   sele/tab {stdtab} :ident .ne. ""


   writ/out "*info* I will identify the stars from {p1} in {p3}"
   writ/out "   meas std  ident      fitr"

   !
   !--- IDENTIFICATION LOOP ---------------------------------------------------
   !
   comp/tab {intab} :stdstatus = 1 ! pre-amag comp.

   do i = 1 {mes_len}  			!-- loop on measurements
      fra_filt = "{{intab},:FILTER,@{i}}"	!-filter of the frame

      w_c = "{{intab},:ident,@{i}}"
      w_l1 = M$LEN(w_c)
      w_c1 = w_c(1:{w_l1})


      !-  IDENTIFY THE STAR----------------
      sel/tab {intab} all
      do j = 1 {std_len} 			!- loop the standards
	 w_c = "{w_std.tbl,:ident,@{j}}"
	 w_l2 = M$LEN(w_c)
	 w_c2 = w_c(1:{w_l2})
	 if "{w_c1}" .eq. "{w_c2}" then
	    !-- STAR IDENTIFIED
found_it:
!           writ/out ">{{intab},:ident,@{i}}< >{w_std.tbl,:ident,@{j}}<"
!           writ/out ">{w_c1}< {w_l1}   >{w_c2}< {w_l2}   "
	    write/out "--- {i} {j} {w_std.tbl,:ident,@{j}} {fra_filt}*"
	    {intab},:stdmag,@{i} = {w_std.tbl,:{fra_filt},@{j}}

	    {intab},:stdcol,@{i} = {w_std.tbl,:{clridx(1:1)},@{j}}-{w_std.tbl,:{clridx(3:3)},@{j}}

	    goto end_in			!-- jumps out
	 endif
      enddo
      writ/out "   ??? Star >{w_c1}< not found in standard table {p3}"
      {intab},:stdmag,@{i} = -100.
end_in:					!-- jumps here when the * is identified
   enddo				!-- end of identification loop
endif                                   !-- end of star not yet identified? 

!
!-- Blah blah
!
if method .eq. "A"  writ/out "*info* Extinction   set to: {extn_{glo_filt}}"
if method .eq. "A" .or. method .eq. "R"  writ/out "*info* Colour corr. set to: {clr_{glo_filt}}"

!
!-- SELECTION --------------------------------------------------
!


select:


j = m$existc(intab,":select")

!- reset in case of change of filter
if wselect .eq. "new" then 
   if j .gt. 0 dele/col {intab} :select
   wselect = "none"
   !-- reset stdstatus: -9999: bad id, 0=previously rejected, 1:0K
   !   keep -9999, reset 0 and 1 to 1
   sele/tab {intab} :stdstatus .lt. 0. 
   comp/tab {intab} :stdstatus = 1 - 1000*sel
   sele/tab {intab} all
   j = 0
endif

if j .gt. 0 then
   !-- THE :SELECT COL. EXISTS
   if wselect .eq. "none" then 
      !- NO ADDITIONAL SELECTION: take new edition into account 
      sele/tab {intab}  :stdstatus.gt.0.  .and. :select.eq.1
   else
      !- ADDITIONAL SELECTION:
      sele/tab {intab} :stdstatus.gt.0. .and. {wselect}  
      sele/tab {intab} sel .eq. 1 .and. :select .eq. 1
   endif   
   comp/tab {intab} :select = sel
else
   !-- :SELECT DOES NOT EXIST
   crea/col {intab} :select ? ? I4
   if wselect .eq. "none" then 
      sele/tab {intab} :filter.eq."{glo_filt}" .and. :stdstatus.gt.0. 
   else !- ADDITIONAL SELECTION:
      sele/tab {intab} :filter.eq."{glo_filt}" .and. :stdstatus.gt.0. .and. {wselect} 
   endif
   comp/tab {intab} :select = sel
endif



sele/tab {intab} :select.eq.1 

!
!--- TEST: ENOUGH POINTS??? ----------------------------------------
!
j = {{intab},tblcontr(10)}

if method .eq. "R" .and. j .le. 2 then
   writ/out "*SORRY* Only >{j}< remaining data point."
   writ/out "        cannot estimate the extinction with that..."
   writ/out "        Try option   method=A, possibly with   extin=something"
   return/exit
endif
if method .eq. "K" .and. j .eq. 3 then
   writ/out "*SORRY* Only >{j}< remaining data point."
   writ/out "        cannot estimate the  colour terms with that..."
   writ/out "        Try option   method=R"
   return/exit
endif
if method .eq. "C" .and. j .le. 2 then      
   writ/out "*SORRY* Only >{j}< remaining data point."
   writ/out "        cannot estimate the extinc. and colour terms with that..."
   writ/out "        Try option   method=A, possibly with   extin=something"
   return/exit
endif


!
!- PHOTOMETRIC REDUCTION------------------------------------------------
!

!- ASSUME EVERYTHING, DON'T COMPUTE ANYTHING

if method .eq. "Z" then
   comp/tab {intab} :dmag = :stdmag - (:magnitude + {zero_tmp}-{extn_{glo_filt}}*:airm + {clr_{glo_filt}}*:stdcol)

   sele/tab {intab} :select .gt. 0.  

   writ/key zero/r/1/2 {zero_tmp},0.
   writ/key extn/r/1/2 {extn_{glo_filt}},0.
   writ/key colr/r/1/2 {clr_{glo_filt}},0.

   defi/loc flag_z/c/1/8 pre-set
   defi/loc flag_e/c/1/8 pre-set
   defi/loc flag_c/c/1/8 pre-set
endif



!- JUST THE ZERO PT

if method .eq. "A" then
   comp/tab {intab} :dmag = :stdmag - :magnitude
   comp/tab {intab} :zero = :dmag + {extn_{glo_filt}}*:airm -{clr_{glo_filt}}*:stdcol

   sele/tab {intab} :select .gt. 0.  
   stat/tab {intab} :zero

   writ/key zero/r/1/2 {outputr(3)},{outputr(4)}
   writ/key extn/r/1/2 {extn_{glo_filt}},0.
   writ/key colr/r/1/2 {clr_{glo_filt}},0.

   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 pre-set
   defi/loc flag_c/c/1/8 pre-set
endif

!- ZERO POINT AND EXTINCTION

if method .eq. "R" then
   comp/tab {intab} :dmag = :stdmag - (:magnitude +{clr_{glo_filt}} *:stdcol)
   sele/tab {intab} :select .gt. 0.  
   regr/lin {intab} :dmag :airm
   writ/key zero/r/1/2 {outputd(1)},{outputr(3)}
   writ/key extn/r/1/2 {outputd(2)},{outputr(4)}
   extn(1) = -1.*extn(1)
   writ/key colr/r/1/2 {clr_{glo_filt}},0.

   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 computed
   defi/loc flag_c/c/1/8 pre-set
endif

!- ZERO POINT AND COLOR

if method .eq. "K" then
   comp/tab {intab} :dmag = :stdmag - (:magnitude - {extn_{glo_filt}}*:airm)
   sele/tab {intab} :select .gt. 0.  
   regr/lin {intab} :dmag :stdcol
   writ/key zero/r/1/2 {outputd(1)},{outputr(3)}
   writ/key colr/r/1/2 {outputd(2)},{outputr(4)}
   writ/key extn/r/1/2 {extn_{glo_filt}},0.

   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 pre-set
   defi/loc flag_c/c/1/8 computed
endif

!- ZERO POINT AND EXTINCTION AND COLOR

if method .eq. "C" then
   comp/tab {intab} :dmag = :stdmag - :magnitude
   sele/tab {intab} :select .gt. 0.  
   regr/lin {intab} :dmag :airm,:stdcol
   writ/key zero/r/1/2 {outputd(1)},{outputr(3)}
   writ/key extn/r/1/2 {outputd(2)},{outputr(4)}
   writ/key colr/r/1/2 {outputd(3)},{outputr(5)}
   extn(1) = -1.*extn(1)
   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 computed
   defi/loc flag_c/c/1/8 computed
endif

!- DM_TEST = MEASURED-COMPUTED
comp/tab {intab} :dm_test =  :magnitude+ ({zero(1)}) -({extn(1)}*:airm)
comp/tab {intab} :dm_test =  :dm_test + ({colr(1)}*:stdcol)- :stdmag
!comp/tab {intab} :rms = :dm_test**2
sele/tab {intab} :select .eq. 1 


@@ tmag_plot int={intab} col={p2} plo=f x=:airm y=:dm_test 

!writ/out "--------------------------------------------------"
!writ/out "RMS:
!sele/tab {intab} :select .gt. 0. 
!stat/tab {intab} :rms
!writ/out "--------------------------------------------------"
set/form f6.3
writ/out "|   MAG = mag_instrum. + zero - extn*airmass + colr*({clridx})"
writ/out "|  zero = {zero(1)} +/- {zero(2)}    ({flag_z})"
writ/out "|  extn = {extn(1)} +/- {extn(2)}    ({flag_e})"
writ/out "|  colr = {colr(1)} +/- {colr(2)}    ({flag_c})"


if {zero(2)} .ge. .2 then
   writ/out "*warning* large RMS. Are you sure you normalized the"
   writ/out "          images before measuring them? If not, normalize"
   writ/out "          the table with tmag/exptime "
endif
writ/des {intab} ph_zero{p2}/r/1/2 {zero(1)},{zero(2)}
writ/dhe {intab} ph_zero{p2} "{p2}-band photometric zeropt and error"
writ/des {intab} ph_extn{p2}/r/1/2 {extn(1)},{extn(2)}
writ/dhe {intab} ph_extn{p2} "{p2}-band photometric extn and error"
writ/des {intab} ph_colr{p2}/r/1/2 {colr(1)},{colr(2)}
writ/dhe {intab} ph_colr{p2} "{p2}-band colr correction and error"
writ/des {intab} ph_flag{p2}/c/1/30 "Z-{flag_z}/E-{flag_e}/C-{flag_c}"
writ/dhe {intab} ph_flag{p2} "{p2}-band photometry flags"
sele/tab {intab} :select .eq. 1 
writ/des {intab} ph_std{p2}/i/1/1 {{intab},tblcontr(10)}
writ/dhe {intab} ph_std{p2} "Nr of std used for {p2} reduction"
writ/des {intab} ph_idx{p2}/c/1/3 {clridx}
writ/dhe {intab} ph_idx{p2} "Color idx used for {p2} reduction"
set/form

writ/out "-----------------------------------------------------------------tmag/phot end"

return
