!+++++++++++++++
!.syntax       @@ tmag_edit table Delete? selection
!.purpose      T-MAG photometric package
!	       identify and delete some standard stars from a tmag table
!.parameters
!    table:    input table
!    delete:   D: delete the star (by changing its stdmag to -stdmag)
!	       N: just identifiy the star
!    select:   Additional selection to DELETE
!---------------
defi/par p1 ? ? "table "
if p1 .eq. "??" then
   $ head -10 $MID_WORK/tmag_edit.prg
   return
endif
defi/par p2 N ? "Delete? D/N"
defi/par p3 nil C "additional condition"

@@ tmag_checkfile {p1} .tbl check extn
defi/loc intab/c/1/72 {outputc}

defi/loc i/i/1/1 0
defi/loc iw/i/1/1 0
defi/loc w/r/1/2 0.,0.
defi/loc dmin/r/1/1 9999999999.
defi/loc imin/i/1/1 0
defi/loc w1/r/1/1 0.

set/grap color=1

get/gcur w_del ? 1

defi/loc wx/r/1/3 {w_del.tbl,:X_axis,@1},0.,0.
defi/loc wy/r/1/3 {w_del.tbl,:Y_axis,@1},0.,0.
wx(2) = wx(1)-.1
wx(3) = wx(1)+.1
wy(2) = wy(1)-.05
wy(3) = wy(1)+.05

!-- additional selection:
if p3 .ne. "nil" then
  sele/tab {intab} {p3}
  comp/tab {intab} :w_selb = sel
else
  comp/tab {intab} :w_selb = 1
endif

!-- compute distance to selected point
comp/tab {intab} :dist = (:w - {wx(1)})**2 + (:dm_test - {wy(1)})**2

!-- loop to find closest point

do i = 1 {{intab},tblcontr(10)}
   if {{intab},:dist,@{i}} .le. {dmin} .and. {{intab},:w_selb,@{i}} .eq.  1 then
      dmin =   {{intab},:dist,@{i}} 
      imin =   i
   endif
enddo

!- select found point
sele/tab {intab} seq .eq. {imin}

!-- plot the selected stars:
set/grap color=2
over/tab {p1} {tmagplx} {tmagply}
set/grap color=1	 !-- restore black

writ/out "selected for deletion:"
read/tab {p1} :ident :frame :stdmag :airm :dm_test
writ/out
writ/out "***** re-run to delete other stars"

if p2 .eq. "D" then
  sele/tab {intab} seq .eq. {i}
  comp/tab {p1} :w_selb = -2*sel +1
!!! for tmagold  comp/tab {p1} :stdmag = :stdmag* :w_selb
  {intab},:stdstatus,@{imin} = 0.
  writ/out "***** re-run tmag.prg with option IDENT=Y to get a new solution"
else
  writ/out "***** star just identified"
  writ/out "*****  rerun with P2=D to actually delete the star"
endif

!sele/tab {p1} :w_sel.eq.1




