!------------------------------------------------------------------------------
!@@ tmag_merge.prg input.cat output.tbl tab_prefix color
!                                       name struct.
!
! merge the photometric table corresponding to a catalogue of frames
! type  xxxv0000.bdf or xxxb0000.bdf, and fll the filter and airmass for
! tmag.prg
!
! table prefix: to add to the image names in the cat.
! name struc: how to extract the image name from the table names in cat
! color code:
!     - a 1-char letter   B V ... to set that filter
!     - nil for a guess
!     - mykey(1:1) or so for the table name
!
!------------------------------------------------------------------------------
define/par p1 ? c "catalog/image name: "
if p1 .eq. "??" then
   writ/out "@@ tmag_merge.prg input.cat output.tbl full_tab_prefix"
   return
endif
define/par p2 Tmag.tbl c "output table? .tbl"
define/par p3 null c "table prefix?"
define/par p4 nil c "Color code"
!
! DEFINITION OF THE VARIABLES
!
@@ tmag_checkfile {p2} .tbl nocheck 
defi/loc outtab/c/1/72 {outputc}

define/local catal/i/1/2 0,0

defi/loc i/i/1/1 0
defi/loc catflag/i/1/1 0
defi/loc len/i/1/1 0
defi/loc c1/i/1/1 0
defi/loc c2/i/1/1 0
defi/loc r/i/1/1 0
defi/loc t/r/1/1 0.
defi/loc res/r/1/1 0.
defi/loc w/r/1/2 0.,0.
defi/loc name/c/1/72 " "
defi/loc prefix/c/1/20 {p3}
defi/loc struc/c/1/10 (1:)
defi/loc incat/c/1/72 {p1}

if prefix .eq. "null" then
  prefix = "      "
  struc = "(1:)"
else
  if prefix(1:1) .eq. "(" then
    struc = prefix
    prefix = " "
  endif
endif

defi/loc mykey/c/1/20 " "
defi/loc my2key/c/1/20 " "

!
! CHECK IF WE HAVE A CATALOG OR A SINGLE FRAME
!
len = m$len(incat)
c1  = len-2
c2  = len
if "{incat({c1}:{c2})}" .eq. "cat" then 
   catflag = 1
else ; if "{incat({c1}:{c2})}" .eq. "tbl" then
   catflag = 0
   cre/tcat w_cat {p1}
   incat = "w_cat.cat"
else
   writ/out "what should I do with that? give me a .tbl or a .cat"
endif; endif

!----------------------------------------------------------------------
! start the loop
!----------------------------------------------------------------------
cat_loop:

   !- LOOP BUSINESS

   store/frame mykey {incat} 1 finito

   len = m$len(mykey)
   c1 =  1 ! len-7
   c2 = len-4    
   my2key = mykey({c1}:{c2})

   !- STARTS THE REAL WORK

!- create the columns

!cre/col {prefix}{my2key} :airm ? f10.5 r*4
cre/col {prefix}{my2key} :filter ? A1 C*1
cre/col {prefix}{my2key} :frame ? A20 C*20
cre/col {prefix}{my2key} :fr_id ? A72 C*72
cre/col {prefix}{my2key} :epoch f13.5 R*8

!- fills them

writ/out "frame = {mykey{struc}}"

!r = m$existd("{mykey{struc}}","o_airm")
!if r .eq. 1 then
!   comp/tab {prefix}{my2key} :airm  = {{mykey{struc}},o_airm}
!else
!   comp/tab {prefix}{my2key} :airm  = .999
!endif

!--- try to guess the color

comp/tab  {prefix}{my2key} :filter = "R"

if "{P4}" .eq. "nil" then
   if "{mykey(3:3)}" .eq. "b" comp/tab  {prefix}{my2key} :filter = "B"
   if "{mykey(3:3)}" .eq. "v" comp/tab  {prefix}{my2key} :filter = "V"
   if "{mykey(3:3)}" .eq. "r" comp/tab  {prefix}{my2key} :filter = "R"
   if "{mykey(3:3)}" .eq. "i" comp/tab  {prefix}{my2key} :filter = "I"
   if "{mykey(2:2)}" .eq. "B" comp/tab  {prefix}{my2key} :filter = "B"
   if "{mykey(2:2)}" .eq. "V" comp/tab  {prefix}{my2key} :filter = "V"
   if "{mykey(2:2)}" .eq. "R" comp/tab  {prefix}{my2key} :filter = "R"
   if "{mykey(2:2)}" .eq. "I" comp/tab  {prefix}{my2key} :filter = "I"
   if "{mykey(1:1)}" .eq. "B" comp/tab  {prefix}{my2key} :filter = "B"
   if "{mykey(1:1)}" .eq. "V" comp/tab  {prefix}{my2key} :filter = "V"
   if "{mykey(1:1)}" .eq. "R" comp/tab  {prefix}{my2key} :filter = "R"
   if "{mykey(1:1)}" .eq. "I" comp/tab  {prefix}{my2key} :filter = "I"
   if "{mykey(4:4)}" .eq. "U" comp/tab  {prefix}{my2key} :filter = "B"
   if "{mykey(4:4)}" .eq. "B" comp/tab  {prefix}{my2key} :filter = "B"
   if "{mykey(4:4)}" .eq. "V" comp/tab  {prefix}{my2key} :filter = "V"
   if "{mykey(4:4)}" .eq. "R" comp/tab  {prefix}{my2key} :filter = "R"
   if "{mykey(4:4)}" .eq. "I" comp/tab  {prefix}{my2key} :filter = "I"
   !if "{p3(2:2)}" .eq. "b" comp/tab  {prefix}{my2key} :filter = "B"
   !if "{p3(2:2)}" .eq. "v" comp/tab  {prefix}{my2key} :filter = "V"
   !if "{p3(2:2)}" .eq. "r" comp/tab  {prefix}{my2key} :filter = "R"
   !if "{p3(2:2)}" .eq. "i" comp/tab  {prefix}{my2key} :filter = "I"
   if "{outtab(2:2)}" .eq. "b" comp/tab  {prefix}{my2key} :filter = "B"
   if "{outtab(2:2)}" .eq. "v" comp/tab  {prefix}{my2key} :filter = "V"
   if "{outtab(2:2)}" .eq. "r" comp/tab  {prefix}{my2key} :filter = "R"
   if "{outtab(2:2)}" .eq. "i" comp/tab  {prefix}{my2key} :filter = "I"
endif
if "{P4(1:2)}" .eq. "my" then
   comp/tab {prefix}{my2key} :filter = "{{p4}}"
endif
!- epoch

set/form f13.5,f13.5
comp/tab  {prefix}{my2key} :frame = "{mykey{struc}}"
comp/tab  {prefix}{my2key} :fr_id = "{{mykey{struc}},IDENT}"

r = m$existd("{mykey{struc}}","JD")
if r .eq. 1 then
   comp/tab  {prefix}{my2key} :epoch = "{{mykey{struc}},JD}"
else
!   comp/tab  {prefix}{my2key} :epoch = "-999"
   comp/tab  {prefix}{my2key} :epoch = {{mykey{struc}},O_TIME(4)}
endif
set/form

!
!- merge the tables
!
if {catal} .gt. 1 then
  merge/tab w_old.tbl  {prefix}{my2key} {outtab}
else 
   $ cp  {prefix}{my2key}.tbl {outtab}
!!writ/out "only one table; no new table created"
!!outtab = "{prefix}{my2key}.tbl"
endif

read/tab {outtab} :frame  :standard ! :ident
$cp {outtab} w_old.tbl
writ/out "table {prefix}{my2key}.tbl"
writ/out "    incorporated into {outtab}"


goto cat_loop  !- end of the loop
finito:        !- end of the catalog

c1 = m$existc("{outtab}",":ident")

if c1 .gt. 0 dele/col {outtab} :ident
comp/tab {outtab} :ident = :standard


writ/out "result stored in {outtab}"


