!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  WFI automatic measurement
!  @(#) $Id: WFIamag_mesAuto.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.usage
!  @@ WFIamag_mesAuto fits
!     fits: a WFI raw frame, eg  WFI_Imag.123.fits
!
!.purpose
!  pseudo pipeline for WFI photometric fields
!
!  It will read the frame in, then measure the 8 subframes
!
!.version 2003-10-24 first working version
!.history
!

!--- configuration parameters
!    uncomment one of the following blocks:
!--- for the 2p2m
defi/loc zpArchive/c/1/72 /data/E2P2OPS/pipeline_database/WFI

!--- local implementation
!!!defi/loc zpArchive/c/1/72 .

crea/gra 
crea/dis ? 450,950


writ/key WFIzp/c/1/72 {zpArchive}/WFIzp

defi/loc inima/c/1/72 
defi/loc i/i/1/1 0
defi/loc j/i/1/1 0

defi/loc filters/c/1/5 "UBVRI"
defi/loc colors/i/1/5 1,4,3,2,6
defi/loc plotflag/i/1/1 1
defi/loc w/r/1/3 0.,0.,0.
defi/loc ep/r/1/2 0.,0.
defi/loc archf/c/1/72 xxx

!
!-- read FITS in
!

i = m$index(p1,".fits")
inima = "{p1(:{i})}"

again:
i = m$index(inima,".")
if i .gt. 0 then
   inima({i}:{i}) = "_"
   goto again
endif

i = m$exist("{inima}0001.bdf")
if i .eq. 0 then
   writ/out "[WFIamag/auto] *info* reading file {inima} in Midas"
   indi/mfi {p1} {inima}
endif

archf = "{{inima}0000.bdf,ARCFILE}"
@@ amag_checkfile {archf} .fits nocheck naked
archf = "zp.{outputc}"

!
!-- Measure the sub-images
!

set/grap yaxis=22,26


do i = 1 8
  writ/out "[WFIamag/auto] *info* processing frame {i}"
  @@ WFIamag_mes {inima}{i}     !- measure
  @@ amag_checkfile t_{inima}{i}.tbl .tbl softcheck
  if outputi .eq. 1 then
    @@ amag_exptime t_{inima}{i}  !- correct exp.time
    @@ WFIamag_oneZero t_{inima}{i}
    $ mv  t_{inima}{i}.tbl {zpArchive}/{archf}_{i}.tbl
  endif
  !!  $ rm {inima}{i}.bdf
enddo

theend:
!
!-- plot the individual zero points
!
writ/out "[WFIamag/auto] *info* plotting ZPs"

sele/tab {WFIzp} all | $ cat - > /dev/null
sort/tab {WFIzp} :epoch(-)
stat/tab {WFIzp} :epoch  | $ cat - > /dev/null
ep(1) = outputr(1)-.1
ep(2) = outputr(2)+.5

defi/loc chofx/r/1/8 10,45,80,115,115,80,45,10
defi/loc chofy/r/1/8 65,65,65,65,5,5,5,5

do i = 1 8 ! loop on chips
   writ/out "               chip {i}"
   set/grap pmode=1 color=1 ltype=1 stype=1 ssize=3
   if i .eq. 1 then
      plot/axe {ep(1)},{ep(2)} 22.8,25.7 -28,-55,{chofx({i})},{chofy({i})}
   else
      over/axe {ep(1)},{ep(2)} 22.8,25.7 -28,-55,{chofx({i})},{chofy({i})}
   endif
   set/form i1
   labe/gra "-{i}-" {ep(1)},25.4 ? 2 1

   do j = 1 5 ! loop on filters
      !- select the ZP for considered chip and filter
      sele/tab {WFIzp} :chip .eq. {i} .and. :FILTER .eq. "{filters({j}:{j})}" | $ cat - > /dev/null
      if {{WFIzp}.tbl,tblcontr(10)} .gt. 0 then !- if there is something to plot, plot it.
        set/grap color={colors({j})} ltype=1 stype=1 ssize=3

        over/tab {WFIzp} :epoch :zp
	copy/tab {WFIzp} wzp
	sele/tab wzp seq.eq.1 | $ cat - > /dev/null
	set/grap stype=18 ssize=1
	over/tab wzp :epoch :zp

      endif

enddo
enddo

set/grap color=1
labe/gra "WFI ZPs" 150,110,mm ? 3 1

set/grap color={colors(1)}
labe/gra "U" 150,90,mm ? 1 1
set/grap color={colors(2)}
labe/gra "B" 153,90,mm ? 1 1
set/grap color={colors(3)}
labe/gra "V" 156,90,mm ? 1 1
set/grap color={colors(4)}
labe/gra "R" 159,90,mm ? 1 1
set/grap color={colors(5)}
labe/gra "I" 161,90,mm ? 1 1

sele/tab {WFIzp} all | $ cat - > /dev/null
w = {{WFIzp}.tbl,:epoch,@1} 
w(2) = (w(1)-m$nint(w(1)-.5))*24.
i = w(2)
j = (w(2)-i)*60.
set/for i1

set/grap color=1
labe/gra "Last measurement:" 150,70,mm ? 1 1
labe/gra "{i}:{j} UT" 150,65,mm ? 1 1

labe/gra "x= Mod.JDay -52900." 150.,50,mm ? 1 1

!- save table in ascii
sele/tab {WFIzp} all
assi/prin file {zpArchive}/WFIzp.dat
prin/tab {WFIzp} ? ? ? 130
assi/prin

writ/out "[WFIamag/auto] *info* done."
$ echo "==============================================================================" >> t_{inima}zp
$ cat  t_{inima}zp
$ echo "[WFIamag/auto] result in >> t_{inima}zp << and in E2P2OPS/pipeline_database/WFI"

!---oOo---
