!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  WFI automatic measurements
!
!  @(#) $Id: WFIamag_oneZero.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.usage
!  @@ WFIamag_oneZero tab
!     tab: a t_xxx.tbl measured with WFIamag_mes.prg
!.note
!  the table should contain only one filter and one chip
!
!.purpose
!  average the zero points from one CCD subframe
!  and store result for plot by WFIamag_mesAuto
!
!.output  
!  {WFIzp}.tbl: one line is added
!
!.version 2003-10-22 ohainaut creation
!.history
!
!------------------------------------------------------------------------------
defi/par p1 ? ? "input table"

defi/loc intab/c/1/72 xxx
@@ amag_checkfile {p1} .tbl check naked
intab = outputc

defi/loc outfile/c/1/71 xxx
defi/loc filt/c/1/1 X
defi/loc ifilt/i/1/1 0
defi/loc mZ/r/1/1 0
defi/loc mZs/r/1/1 0
defi/loc nZ/i/1/1 0
defi/loc i/i/1/1 0

!-- typical values of ZP
defi/loc typZU/r/1/8 0.,0.,0.,0.,0.,0.,0.,0.
defi/loc typZB/r/1/8 24.67,24.75,24.50,24.72,24.65,24.78,24.70,24.53
defi/loc typZV/r/1/8 24.17,24.27,24.03,24.20,24.20,24.25,24.18,24.06
defi/loc typZR/r/1/8 24.51,24.60,24.37,24.58,24.54,24.60,24.52,24.42
defi/loc typZI/r/1/8 23.30,23.47,23.24,23.53,23.48,23.50,23.43,23.32



!- conversion filter name -> number
filt = "{{intab}.tbl,:filter,@1}"
if filt .eq. "U" ifilt = 1
if filt .eq. "B" ifilt = 2
if filt .eq. "V" ifilt = 3
if filt .eq. "R" ifilt = 4
if filt .eq. "I" ifilt = 5

!- standard lasilla extinctions 
defi/loc stdExt/r/1/5 0.35,0.22,0.13,0.09,0.07
comp/tab {intab}.tbl :wZ = :{filt} - :MAGNITUDE + {stdExt({ifilt})}*:airm

stat/tab {intab}.tbl :wZ  | $ cat - > /dev/null
mZ = {outputr(3)}
mZs = {outputr(4)}
nZ = {outputi(2)}

set/for f20.10,f20.10

!-- is the output table already created?
i = m$exist("{WFIzp}.tbl")

if i .eq. 0 then !- no, create it.
   crea/tab {WFIzp} 1 1
   crea/col {WFIzp} :epoch "MJD-52900" F20.10 R*8
   comp/tab {WFIzp} :tab = "{intab}"
   comp/tab {WFIzp} :filter = "{filt}"
   comp/tab {WFIzp} :ffilter = "{{intab}.tbl,:ffilter,@1}"
   comp/tab {WFIzp} :epoch = {{intab}.tbl,:epoch,@1} -52900.
   comp/tab {WFIzp} :ZP = {mZ}
   comp/tab {WFIzp} :ZPs = {mZs}
   comp/tab {WFIzp} :nZ = {nZ}
   comp/tab {WFIzp} :chip = {{intab}.tbl,:chip,@1}

else !- yes, add one line

   sele/tab {WFIzp} all
   i = {{WFIzp}.tbl,tblcontr(4)}
   crea/row {WFIzp} @{i} 1
   i = i+1
   {WFIzp}.tbl,:epoch,@{i} = {{intab}.tbl,:epoch,@1} -52900.
   {WFIzp}.tbl,:tab,@{i} = "{intab}"
   {WFIzp}.tbl,:filter,@{i} = "{filt}"
   {WFIzp}.tbl,:ffilter,@{i} = "{{intab}.tbl,:ffilter,@1}"
   {WFIzp}.tbl,:ZP,@{i} = mZ
   {WFIzp}.tbl,:ZPs,@{i} = mZs
   {WFIzp}.tbl,:nZ,@{i} = {nZ}
   {WFIzp}.tbl,:chip,@{i} = {{intab}.tbl,:chip,@1}

endif
SET/FOR i1 f10.3

i = m$len(intab) -5
outfile = "{intab(:{i})}"

i = m$exist("{outfile}_zp")
if i .eq. 0 then
  $ touch {outfile}_zp
  $ echo "==============================================================================" >> {outfile}_zp
  $ echo "ZERO POINT QUICK LOOK RESULT" >> {outfile}_zp
  $ echo " Zero point / dispersion (and typical value) are listed below" >> {outfile}_zp
  $ echo " " >> {outfile}_zp
  $ echo " Frame                = {intab}" >> {outfile}_zp
  $ echo " Epoch                = MJD -52900.0 = {{intab}.tbl,:epoch,@1}" >> {outfile}_zp
  $ echo " Filter               = {{intab}.tbl,:ffilter,@1}" >> {outfile}_zp
  $ echo " Standard Extinction  = {stdExt({ifilt})}" >> {outfile}_zp
  $ echo " Airmass (lasilla std)= {{intab}.tbl,:airm,@1}" >> {outfile}_zp
  $ echo " " >> {outfile}_zp
endif
$ echo " CCD number             = {{intab}.tbl,:chip,@1}" >> {outfile}_zp
$ echo "    No of stars measured= {nZ}" >> {outfile}_zp
$ echo "                    zp = {mZ} +/- {mZs}  ({typZ{filt}({{intab}.tbl,:chip,@1})})" >> {outfile}_zp
set/for
!---oOo---





