!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_exptime.prg,v 1.3 2003/10/26 06:27:17 ohainaut Exp $
!
! .version Wed Jan 10 03:09:36 2001 orh first recorded version
! .history 
! 1996 orh creation
!
!------------------------------------------------------------------------------
defi/par p1 ? ? "table "
if "{p1}" .eq. "???" then
wr/o "					      T M A G   Photometric Package  "
wr/o "									     "
wr/o " AMAG/EXPTIME or @@ amag_exptime "
wr/o "									     "
wr/o ".syntax								     "
wr/o "		AMAG/EXPTIME intab [exptime]				     "
wr/o ".purpose								     "
wr/o "		computes the exp-time normalized instrumental magnitudes     "
wr/o "		mag = mag_mes + 2.5log(t)   "
wr/o "									     "
wr/o ".parameters						     "
wr/o "		intab: input table, obtained with amag_mes or tmag_mes	     "
wr/o "			or amag_objmes					     "
wr/o "		exptime: if not give, the program looks for a column "
wr/o "			:exp_time, 			     "
wr/o "			if :exp_time not present, looks for the 	     "
wr/o "			o_time(7) descriptor of the original image.	     "
wr/o "			If exptime is given, it is used, over-riding         "
wr/o "			automatic methods				     "
wr/o "									     "
wr/o "-----------------------------------------------------------------------------"
 return
endif
defi/par p2 NIL ? "expt"
defi/loc i/i/1/1 0
defi/loc w/r/1/2 0.,0.

defi/loc intab/c/1/72 {p1}

@@ tmag_checkfile {intab} .tbl check
intab = outputc

! does the :exp_time col exist?
i = m$existc("{intab}",":exp_time")

! if no, let's create it"
if i .eq. -1 crea/col {intab} :exp_time

! if no - and if we need it, let's fill it
if i .eq. -1 .and. p2 .eq. "NIL" then
      do i = 1  {{intab},tblcontr(4)}
         {intab},:exp_time,@{i}  = {{{intab},:frame,@{i}},o_time(7)}
      enddo
endif

! does mag_mes exist (i.e. have we been here before?)
i = m$existc("{intab}",":mag_mes")
if i .eq. -1 then
 writ/out "[amag/exptime] *info*  original magnitudes kept in :mag_mes"
 comp/tab {intab} :mag_mes = :MAGNITUDE
else
 writ/out "[amag/exptime] *info*  "
 writ/out "     Original magnitudes are already in :mag_mes"
 writ/out "     It is likely that you have already run this command."
 writ/out "     Re-running it will re-compute the normalized mags from the"
 writ/out "     original instrumental mags, which is no problem."
endif
 
if p2 .ne. "NIL" then
    comp/tab {intab} :exp_time  = {p2}
endif

comp/tab {intab} :MAGNITUDE = :mag_mes + 2.5*log10(:exp_time)
writ/out "[amag/exptime] DONE :magnitude contains the time-normalized instrumental mags"
