!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_kill.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.syntax
!  @@ amag_kill intab
! or
!  AMAG/KILL intab
!
!  intab: measurement table
!
!.purpose
!  interactivelly select a region of stars to be deleted on a 
!  plot produced by AMAG/PLOT
!
!.version 2003-10-22 creation from amag_edit
!.history
!
!------------------------------------------------------------------------------
defi/par p1 ? ? "table "
if p1 .eq. "???" then
wri/ou "  T m a g   Photometric Package"
wri/ou "  @(#) $Id: amag_kill.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $"
wri/ou ""
wri/ou ".syntax       @@ amag_edit table"
wri/ou ".purpose      T-MAG photometric package"
wri/ou "	      identify and delete some standard stars from a tmag table"
wri/ou "              Click lower-left and upper-right corners of the region"
wri/ou " "
wri/ou ".parameters"
wri/ou "    table:    input table"
return/exit
endif
!---------
defi/par p2 D ? "Delete? D/N"
defi/par p3 nil C "additional condition"


wr/o "------------------------------------------------------------ amag/kill"
@@ amag_checkfile {p1} .tbl check extn
defi/loc intab/c/1/72 {outputc}

defi/loc i/i/1/1 0
defi/loc iw/i/1/1 0
defi/loc w/r/1/2 0.,0.
defi/loc dmin/r/1/1 9999999999.
defi/loc imin/i/1/1 0
defi/loc w1/r/1/1 0.

set/grap color=1

!- measure region to kill
get/gcur w_del ? 2

sort/tab w_del :x_axis
defi/loc wx/r/1/2 {w_del.tbl,:X_axis,@1},{w_del.tbl,:X_axis,@2}
sort/tab w_del :y_axis
defi/loc wy/r/1/2 {w_del.tbl,:Y_axis,@1},{w_del.tbl,:Y_axis,@2}

!- temporary table for marking the deleted region on plot
crea/tab w_delplot 2 5
comp/tab w_delplot :x = 0.
comp/tab w_delplot :y = 0.
w_delplot.tbl,:x,@1 = wx(1)
w_delplot.tbl,:y,@1 = wy(1)
w_delplot.tbl,:x,@2 = wx(1)
w_delplot.tbl,:y,@2 = wy(2)
w_delplot.tbl,:x,@3 = wx(2)
w_delplot.tbl,:y,@3 = wy(2)
w_delplot.tbl,:x,@4 = wx(2)
w_delplot.tbl,:y,@4 = wy(1)
w_delplot.tbl,:x,@5 = wx(1)
w_delplot.tbl,:y,@5 = wy(1)

set/grap stype=0 ltype=1 color=2
over/tab w_delplot :x :y
set/grap ltype=0 stype=1 color=2


!-- additional selection:
if p3 .ne. "nil" then
  sele/tab {intab} {p3}  | $ cat - > /dev/null
  comp/tab {intab} :w_selb = sel
else
  comp/tab {intab} :w_selb = 1
endif


!-- select region to kill

sele/tab {intab} :select .eq. 1 | $ cat - > /dev/null
sele/tab {intab} sel.eq.1 .and. :w_selb .eq. 1 | $ cat - > /dev/null
sele/tab {intab} sel.eq.1 .and. {tmagplx}.ge.{wx(1)} .and. {tmagplx}.le.{wx(2)} | $ cat - > /dev/null
sele/tab {intab} sel.eq.1 .and. {tmagply}.ge.{wy(1)} .and. {tmagply}.le.{wy(2)} | $ cat - > /dev/null

!-- plot the selected stars:
set/grap color=2
over/tab {p1} {tmagplx} {tmagply}
set/grap color=1	 !-- restore black

writ/out "[amag/kill] *info* Stars selected for deletion:"
read/tab {p1} :ident :frame :stdmag :airm :dm_test
writ/out

if p2 .eq. "D" then
  comp/tab {p1} :w_selb = -2*sel +1
  !!! for tmagold  comp/tab {p1} :stdmag = :stdmag* :w_selb

  comp/tab {p1} :stdstatus = :stdstatus * (:w_selb +1)/2

  writ/out "[amag/kill] *INFO* Stars removed from solution"
  writ/out "                   Re-run amag.prg with option IDENT=Y "
  writ/out "                   to get a new solution"
else
  writ/out "[amag/kill] *info* Star just identified"
  writ/out "                   rerun with P2=D to actually delete the star"
endif
wr/o "--------------------------------------------------------5  amag/kill end"

!---oOo---



