!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_merge.prg,v 1.5 2003/10/26 08:51:27 ohainaut Exp $
!
!.version 2003-10-21T06:09:50 Tue improved cat handling
!
!.history 
! Sat Mar 10 23:42:11 2001 orh cleaned code
! 2000 moved from tmag to amag
!
define/par p1 ? c "catalog/image name: "
if p1 .eq. "???" then
wr/o "			        		T M A G   Photometric Package "
wr/o "	AMAG/MERGE or @@ amag_merge "
wr/o " "
wr/o " .syntax								     "
wr/o "	  AMAG/MERGE in_cat.cat out_tab.tbl prefix           		     "
wr/o " "
wr/o " .example                                                              "
wr/o "    AMAG/MERGE myImg.cat t_std.tbl t_                                  "
wr/o "                                     			     "
wr/o " .purpose                                    			     "
wr/o "		merge the measurement tables obtained on the images from     "
wr/o "		a catalogue into one large table"
wr/o " 									     "
wr/o " .parameters							     "
wr/o " 		in_cat: the catalogue that contains the measured images	     "
wr/o " 		out_tab: the table that will contain all the measurements    "
wr/o " 		prefix: the prefix that was used to name the table during the"
wr/o "               measurements. Usually t_ or tm_ 		     "
wr/o " 									     "
wr/o "-----------------------------------------------------------------------------"
return
endif
define/par p2 t_std.tbl c "output table? .tbl"
define/par p3 t_ c "table prefix?"
!
! DEFINITION OF THE VARIABLES
!
@@ tmag_checkfile {p2} .tbl nocheck 
defi/loc outtab/c/1/72 {outputc}

define/local catal/i/1/2 0,0

defi/loc i/i/1/1 0
defi/loc catflag/i/1/1 0
defi/loc len/i/1/1 0
defi/loc c1/i/1/1 0
defi/loc c2/i/1/1 0
defi/loc r/i/1/1 0
defi/loc t/r/1/1 0.
defi/loc res/r/1/1 0.
defi/loc w/r/1/2 0.,0.
defi/loc name/c/1/72 " "
defi/loc prefix/c/1/20 {p3}
defi/loc struc/c/1/10 (1:)
defi/loc incat/c/1/72 {p1}
defi/loc newtab/i/1/1 1


if prefix .eq. "null" then
  prefix = " "
  struc = "(1:)"
else
  if prefix(1:1) .eq. "(" then
    struc = prefix
    prefix = " "
  endif
endif

defi/loc mykey/c/1/72 " "
defi/loc my2key/c/1/72 " "

!
! CHECK IF WE HAVE A CATALOG OR A SINGLE FRAME
!
len = m$len(incat)
c1  = len-2
c2  = len
if "{incat({c1}:{c2})}" .eq. "cat" then 
   catflag = 1
else ; if "{incat({c1}:{c2})}" .eq. "tbl" then
    writ/out "I'm expecting a cat, not a single table"
    writ/out "you don't need to run this on a single table"
    return
else
   writ/out "what should I do with that? give me a .cat"
   return
endif; endif

!----------------------------------------------------------------------
! start the loop
!----------------------------------------------------------------------
cat_loop:

   !- LOOP BUSINESS

   store/frame mykey {incat} 1 finito

   len = m$len(mykey)
   c1 =  1 ! len-7
   c2 = len-4    
   my2key = mykey({c1}:{c2})

   !- STARTS THE REAL WORK

!
!- merge the tables
!

i = m$exist("{prefix}{my2key}.tbl")

@@ amag_checkfile {prefix}{my2key}.tbl .tbl softcheck extn
if outputi .eq. 1 then

  if {newtab} .eq. 0 then
    merge/tab w_old.tbl  {prefix}{my2key}.tbl {outtab}
  else 
     $ cp  {prefix}{my2key}.tbl {outtab}
    newtab = 0
  endif
  
  
  !! read/tab {outtab} :frame  :standard ! :ident
  
  $cp {outtab} w_old.tbl
  writ/out "table {prefix}{my2key}.tbl incorporated into {outtab}"
  
else
  writ/out "table {prefix}{my2key}.tbl does not exist - skip"
endif

goto cat_loop  !- end of the loop
finito:        !- end of the catalog

c1 = m$existc("{outtab}",":ident")

if c1 .gt. 0 dele/col {outtab} :ident
comp/tab {outtab} :ident = :standard


writ/out "result stored in {outtab}; {{outtab},tblcontr(10)} lines"


!---oOo---