crossref intab filter plo_fl x y scalex frame all
!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_plot.prg,v 1.3 2003/10/26 08:51:27 ohainaut Exp $
!
!.version		  Sat Dec 29 16:02:05 2001 improved labels"
!.history
!
!
defi/par p1 ? c "measurement table"
if p1 .eq. "???" then
wr/o "			        		T M A G   Photometric Package "
wr/o " 								      "
wr/o "AMAG/PLOT mes.tbl color plot_fl  X Y sc frame_diff? all_frames?	      "
wr/o "									      "
wr/o ".purpose	plot the residual of a tmag photometric reduction	      "
wr/o ".parameters							      "
wr/o "	 intab	table containing the measurements			      "
wr/o "	 color	BVRI							      "
wr/o "	 plo_fl	where to plot						      "
wr/o "		       F: full frame					      "
wr/o "		       1,2,3,4: small, in a quadrant. label should be first   "
wr/o "		       A: plots EVERYTHING!!!				      "
wr/o "	 X 		columns to be plotted as X			      "
wr/o "			:airm, :stdmag, :stdcol, :epoch, :xcen, :ycen or      "
wr/o "			label: no plot, just info on the table		      "
wr/o "	 Y		columns to be plotted as Y; only :dm_mag at this point"
wr/o "	 scalex	x1,x2: x plotted from x1 to x2				      "
wr/o "	 frame_diff	Y: different symbol is used for each image	      "
wr/o "	 all		Y: plot deleted stars N: only active stars	      "
wr/o "									      "
wr/o "parameter crossref: intab filter plo_fl x y scalex frame all            "
   return
endif
defi/par p2 R C "color"
defi/par p3 F C "Full/1/2/3/4"
defi/par p4 :airm C "X?"
defi/par p5 :dm_test C "Y?"
defi/par p6 nil C "Xscaling?"
defi/par p7 N C "symbolic differentiation of the images?"
defi/par p8 N C "all the images Y (or only the active ones N)?"
wri/out "--------------------------------------------------------------------amag/plot"

!! wri/out "{p1} {p2} {p3} {p4} {p5} {p6} {p7} {p8}"

defi/loc i/i/1/1 0
writ/key jpos/i/1/1 1
writ/key icol/i/1/1 0
writ/key isym/i/1/1 2
defi/loc w/r/1/2 0.,0.

set/grap
@@ amag_checkfile {p1} .tbl check
defi/loc intab/c/1/72 {outputc}

defi/loc filter/c/1/1 {p2}
filter = M$UPPER(filter)

defi/loc plo_fl/c/1/1 {p3}
plo_fl = M$UPPER(plo_fl)
wri/out "[amag/plot] *info* mode={plo_fl}"

defi/loc xplot/c/1/32 {p4}
xplot = M$UPPER(xplot)

defi/loc yplot/c/1/32 {p5}
yplot = M$UPPER(yplot)

writ/key scalex/c/1/32 {p6}

writ/key dif_fr/c/1/1 {p7}
dif_fr = M$UPPER(dif_fr)

writ/key all_fr/c/1/1 {p8}
all_fr = M$UPPER(all_fr)

!-- these are used by amag_edit:
writ/key tmagplx/c/1/72 {p4}
writ/key tmagply/c/1/72 {p5}


!------------------------------------------------------------------------------
!-- what is X
!------------------------------------------------------------------------------


if p4 .eq. ":stdmag" then

   comp/tab {intab} :w = abs(:stdmag)  
   sele/tab {intab} :select .eq. 1  | $ cat - > /dev/null
   stat/tab {intab} :w  | $ cat - > /dev/null
   if dif_fr .eq. "N" then
      w(1) = outputr(1)-.5
   else
      w(1) = outputr(1)-2.
   endif
   w(2) = outputr(2)+.5
   defi/loc wc1/c/1/72 {w(1)},{w(2)}
   defi/loc xlab/c/1/72 "Standard magnitude {p2}"

else; if p4 .eq. ":airm" then

   if dif_fr .eq. "N" then
      defi/loc wc1/c/1/72 .9,3
   else
      defi/loc wc1/c/1/72 .2,3
   endif
   comp/tab {intab} :w = :airm
   defi/loc xlab/c/1/72 "Airmass"  


else; if p4 .eq. ":v_r" .or.  p4 .eq. ":stdcol" then

  stat/tab {intab} :stdcol
  w(1) = outputr(1) -.2
  w(2) = outputr(2) +.2  
  
  defi/loc wc1/c/1/72 {w(1)},{w(2)}
  comp/tab {intab} :w = :stdcol
  
  defi/loc xlab/c/1/72 "Standard Colour {{intab},ph_idx{p2}}"

else; if p4 .eq. ":xcen"  then

  stat/tab {intab} :xcen  | $ cat - > /dev/null
  
  defi/loc wc1/c/1/72 {outputr(1)},{outputr(2)}

  comp/tab {intab} :w = :xcen
  defi/loc xlab/c/1/72 "X [{{intab},ph_idx{p2}}]"

else; if p4 .eq. ":ycen"  then

  stat/tab {intab} :ycen  | $ cat - > /dev/null
  
  defi/loc wc1/c/1/72 {outputr(1)},{outputr(2)}

  comp/tab {intab} :w = :ycen
  defi/loc xlab/c/1/72 "Y [{{intab},ph_idx{p2}}]"

else; if p4 .eq. ":epoch" .or. p4 .eq. "time" then

  i = m$existc(intab,":w")
  if i .gt. 0  dele/col {intab} :w
  stat/tab {intab} :epoch  | $ cat - > /dev/null

  comp/tab {intab} :w = :wepoch

  set/form f15.5,f15.5
  sele/tab {intab} :select .eq. 1 | $ cat - > /dev/null
  stat/tab {intab} :wepoch  | $ cat - > /dev/null
  outputr(1) = outputr(1)-.1
  outputr(2) = outputr(2)+.1
  defi/loc wc1/c/1/72 "{outputr(1)},{outputr(2)}"
  writ/out "[amag/plot] *info* min max {outputr(1)},{outputr(2)}"
  set/form
  defi/loc xlab/c/1/72 "Epoch (frac JD)"

  writ/key tmagplx/c/1/72 :wepoch

else; if p4 .eq. "label" then
  set/grap pmode=-1
  set/form f7.3,f7.3 i1

  plot/axe 0,1,10,10 0,1,1,1  -148,-15,15,3 
  labe/gra "Table: {intab}"       0.,.8 ? 2 1

  i = m$existd(intab,"ph_zero{p2}")

  if i .gt. 0 then
    labe/gra "Filter: {p2}" 0.,.5 ? 3 1
    if wselect(1:4) .ne. "none" then
      labe/gra "Selection: {wselect}" 0.,0.2 ? 2 1
    endif
    labe/gra "Zero: {{intab},ph_zero{p2}(1)} +/- {{intab},ph_zero{p2}(2)}" 0.4,.8 ? 2 1
    labe/gra "Extn: {{intab},ph_extn{p2}(1)} +/- {{intab},ph_extn{p2}(2)}" 0.4,.6 ? 2 1
    labe/gra "Colr: {{intab},ph_colr{p2}(1)} +/- {{intab},ph_colr{p2}(2)}" 0.4,.4 ? 2 1
    labe/gra "Index: {{intab},ph_idx{p2}}"     0.7,.8 ? 1.5 1
    labe/gra "Flags: {{intab},ph_flag{p2}}"    0.7,.6 ? 1.5 1
    labe/gra "Standards: {{intab},ph_std{p2}} stars"  0.7,.4 ? 1.5 1
  else
    i = m$existd(intab,"ph_zero")
    if i .gt. 0 then
    !-medium version
      labe/gra "Filter: {p2}" 0.,.82 ? 1 1
      labe/gra "Zero: {{intab},ph_zero(1)} +/- {{intab},ph_zero(2)}" 0.,.67 ? 1 1
      labe/gra "Extn: {{intab},ph_extn(1)} +/- {{intab},ph_extn(2)}" 0.,.52 ? 1 1
      labe/gra "Colr: {{intab},ph_colr(1)} +/- {{intab},ph_colr(2)}" 0.,.37 ? 1 1
      labe/gra "Flags: {{intab},ph_flag}"                            0.,.22 ? 1 1
      labe/gra "Standards: {{intab},ph_std} stars"                   0.,.07 ? 1 1
    else   
      i = m$existd(intab,"zero")
      if i .gt. 0 then
      !-old version
  	labe/gra "Zero: {{intab},zero(1)} +/- {{intab},zero(2)}"     0.,.67 ? 1 1
  	labe/gra "Extn: {{intab},extn(1)} +/- {{intab},extn(2)}"     0.,.52 ? 1 1
  	labe/gra "Colr: {{intab},colr(1)} +/- {{intab},colr(2)}"     0.,.37 ? 1 1
      else
  	writ/out "[amag/plot] *WARNING* no photometric descriptor???"
  	return
      endif
    endif
  endif

  set/grap pmode=1
  set/form 
  return
else
  writ/out "[amag/plot] ***ERROR*** I cannot deal with X= >{p4}< "
  return/exit
endif; endif; endif; endif; endif; endif; endif

!------------------------------------------------------------------------------
!-- manual setting of scale X
!------------------------------------------------------------------------------

if p6 .ne. "nil"  then
   dele/key wc1
   defi/loc  wc1/c/1/72 {p6}
endif

!------------------------------------------------------------------------------!
!-- Y
!------------------------------------------------------------------------------!

if p5 .eq. ":dm_test" then 
   if all_fr .eq. "Y"  then
   !- all the stars
      sele/tab {intab} :stdmag .ge. -99.  | $ cat - > /dev/null
               !- non-idt stars set to -100
   else
   !- only the active stars
      sele/tab {intab} :select .eq. 1  | $ cat - > /dev/null
   endif

   stat/tab {intab} {p5}  | $ cat - > /dev/null
   defi/loc maxplot/r/1/1 .15
   if outputr(1) .le. -{maxplot} .or. outputr(2) .ge. {maxplot} then
      outputr(1) = outputr(1)-.1
      outputr(2) = outputr(2)+.1
      defi/loc wc2/c/1/72 {outputr(1)},{outputr(2)}
   else
      defi/loc wc2/c/1/72 -{maxplot},{maxplot}
   endif
   if plo_fl .eq. "F" then
      defi/loc ylab/c/1/72 ":dm_test (measured - modeled {p2} mag.)"
      set/grap ssize=1
   else
      defi/loc ylab/c/1/72 "(O-C) {p2} mag."
      set/grap ssize=1.5 
   endif
endif

!------------------------------------------------------------------------------!
!-- start plot
!------------------------------------------------------------------------------!

if plo_fl .eq. "F" then
  plot/axe {wc1} {wc2} ? "{xlab}" "{ylab}"
else; if plo_fl .eq. "0" then
   write/out
else; if plo_fl .eq. "1" then
   over/axes {wc1} {wc2}  -65,-40,20,80 "{xlab}" "{ylab}"
else; if plo_fl .eq. "2" then
   over/axes {wc1} {wc2}  -65,-40,110,80 "{xlab}" "{ylab}"
else; if plo_fl .eq. "3" then
   over/axes {wc1} {wc2}  -65,-40,20,30 "{xlab}" "{ylab}"
else; if plo_fl .eq. "4" then
   over/axes {wc1} {wc2}  -65,-40,110,30 "{xlab}" "{ylab}"
else; if plo_fl .eq. "A" then 
   !- DO THEM ALL!
   @@ amag_plot {intab} {filter} 0 label {yplot} {scalex} {dif_fr} {all_fr}
   @@ amag_plot {intab} {filter} 1 :epoch {yplot} {scalex} {dif_fr} {all_fr}
   @@ amag_plot {intab} {filter} 2 :airm {yplot} {scalex} {dif_fr} {all_fr}
   @@ amag_plot {intab} {filter} 3 :stdmag {yplot} {scalex} {dif_fr} {all_fr}
   @@ amag_plot {intab} {filter} 4 :stdcol {yplot} {scalex} {dif_fr} {all_fr}
   goto the_end
else
   writ/out "[amag/plot] *ERROR* plo_fl is supposed to be F, 0, 1, 2, 3 or 4"
   return/exit
endif; endif; endif; endif; endif; endif; endif



!-- plot the zero line
set/grap color=2 stype=0 ltype=1  | $ cat - > /dev/null
jpos = m$exist("wline.tbl")
if jpos .ne. 1 then
   crea/tab wline 3 3
   crea/col wline :x
   crea/col wline :y
   writ/tab wline :x @1 -1.
   writ/tab wline :y @1 0.
   writ/tab wline :x @2 20000.
   writ/tab wline :y @2 0.
endif

over/tab wline :x :y
set/grap color=1 stype=1 ltype=0 


defi/loc catal/i/1/2 0,0
defi/loc mykey/c/1/40 toto
defi/loc my2key/c/1/40  toto23424


if dif_fr .ne. "N" then
!-- diffentiate frames
cat_loop:
  do i = 1 {{intab},tblcontr(4)}
     writ/key mykey  {{intab},:frame,@{i}}
     if mykey .ne. my2key then    
	@@ amag_plot,symbol {mykey}
	sele/tab {intab} :frame .eq. "{mykey}"  | $ cat - > /dev/null
	over/tab {intab} :w {p5}
	my2key = mykey
     endif
  enddo
else
!-- do not diffentiate frames
  sele/tab {intab} :select .gt. 0.  | $ cat - > /dev/null
  over/tab {intab} :w {p5}
  if all_fr .eq. "Y" then
    !- plot the inactive stars in red
    sele/tab {intab} :select .le. 0.  | $ cat - > /dev/null
    set/grap color=2
    over/tab {intab} :w {p5}
    set/grap color=1
  endif
endif


set/grap color=1

if plo_fl .eq. "F" labe/gra "Table: {p1}" 15,8,mm 0 1.5 1
the_end:
writ/out "-----------------------------------------------------------------amag/plot end" 

RETURN

!------------------------------------------------------------------------------
ENTRY symbol
!------------------------------------------------------------------------------


jpos = jpos+4
if jpos .gt. 50 return

if icol .le. 6 then
  icol = icol + 1
else
  icol = 1	
  isym = isym+1
endif

set/grap color={icol} stype={isym}
over/sym {isym} 3,{jpos},mm 
labe/gra {p1} 5,{jpos},mm ? .5 1
RETURN

! -oOo-


