!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  EFOSC automatic measurement
!  @(#) $Id: EFOSCamag_mesAuto.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.usage
!  @@ EFOSCamag_mesAuto fits
!     fits: a EFOSC raw frame, eg  EFOSC.2003-12-31T01:02:03.456.fits
!
!.purpose
!  pseudo pipeline for EFOSC photometric fields
!
!  It will read the frame in, then measure the frames
!
!.version from EFOSC
!.history
! 2003-11-24 adapted for EMMI
! 2003-10-24 first WFI working version

!--- configuration parameters
!    uncomment one of the following blocks:
!--- for the telescope
defi/loc zpArchive/c/1/72 /data/E3P6OPS/pipeline_database/EFOSC/Photometry
!! defi/loc zpArchive/c/1/72 /data/NTTOPS/pipeline_database/EMMI/Photometry
!! defi/loc zpArchive/c/1/72 /data/E3P6OPS/pipeline_database/EFOSC/Photometry
!! defi/loc zpArchive/c/1/72 /data/NTTOPS/pipeline_database/SUSI/Photometry
!! defi/loc zpArchive/c/1/72 /data/E2P2OPS/pipeline_database/WFI

!--- local implementation
!!!defi/loc zpArchive/c/1/72 .

crea/gra 
crea/dis ? 450,950

writ/key EFOSCzp/c/1/72 {zpArchive}/EFOSCzp

defi/loc inima/c/1/72 
defi/loc i/i/1/1 0
defi/loc j/i/1/1 0

defi/loc filters/c/1/5 "UBVRI"
defi/loc colors/i/1/5 1,4,3,2,6
defi/loc plotflag/i/1/1 1
defi/loc w/r/1/3 0.,0.,0.
defi/loc ep/r/1/2 0.,0.
defi/loc archf/c/1/72 xxx

!
!-- read FITS in
!


if "{p1(1:5)}" .eq.  "EFOSC" then
    @@ amag_checkfile {p1} .fits nocheck naked
    i = m$index(outputc,"_") +1
    inima = "ef_{outputc({i}:)}"
    outputc = inima
    i = m$index(outputc,".") 
    if i .gt. 0 then
       i = i-1
       j = i+2
       inima = "{outputc(:{i})}_{outputc({j}:)}"
    else
       inima = "{outputc}_0"
    endif
else 
    writ/out "[EFOSCamag/auto] *ERROR* this program is meant to deal with"
    writ/out "                untouched raw EFOSC images. Use AMAG/MES instead"
    writ/out "                for other data"
    return/exit
endif

i = m$exist("{inima}.bdf")
if i .eq. 0 then
   writ/out "[EFOSCamag/auto] *info* reading file {inima} in Midas"
   indi/fits {p1} {inima}.bdf
endif


i = m$existd(inima,ARCFILE)
if i .eq. 1 then
   archf = "{{inima},ARCFILE}"
   @@ amag_checkfile {archf} .fits nocheck naked
   archf = "zp.{outputc}"
else
   archf = "zp.EFOSC.{{inima},ESO.TPL.START}"
endif


!
!-- Measure the sub-images
!

do i = 1 1  ! only 1 chip for EFOSC
  writ/out "[EFOSCamag/auto] *info* processing frame {i}"
  @@ amag_mesAuto {inima} 0.157 AUTO 1    !- measure
  @@ amag_checkfile t_{inima}.tbl .tbl softcheck
  if outputi .eq. 1 then
    @@ amag_exptime t_{inima}  !- correct exp.time
    @@ amag_oneZero t_{inima} EFOSC
    $ mv  t_{inima}.tbl {zpArchive}/{archf}.tbl
  endif
enddo

theend:

!
!-- plot the individual zero points
!
writ/out "[EFOSCamag/auto] *info* plotting ZPs"

sele/tab {EFOSCzp} seq .eq. {{EFOSCzp}.tbl,TBLCONTR(10)}
copy/tab {EFOSCzp} wtab

sele/tab {EFOSCzp} all  | $ cat - > /dev/null
sort/tab {EFOSCzp} :epoch(-)
stat/tab {EFOSCzp} :epoch  | $ cat - > /dev/null
ep(1) = outputr(1)-.1
ep(2) = outputr(2)+ (outputr(2)-outputr(1))/10.


defi/loc chofx/r/1/8 10  !- start of the plots for each subchips 
defi/loc chofy/r/1/8 10  !   /8 for compatibility with WFI

do i = 1 1 ! loop on chips
   writ/out "               chip {i}"
   set/grap pmode=1 color=1 ltype=1 stype=1 ssize=3
   if i .eq. 1 then
      plot/axe {ep(1)},{ep(2)} 23.5,26.5 -120,-110,{chofx({i})},{chofy({i})}
   else
      over/axe {ep(1)},{ep(2)} 23.5,26.5 -120,-110,{chofx({i})},{chofy({i})}
   endif
   set/form i1
   labe/gra "-{i}-" {ep(1)},26.2 ? 2 1

   do j = 1 5 ! loop on filters
      !- select the ZP for considered chip and filter
      sele/tab {EFOSCzp} :chip .eq. {i} .and. :FILTER .eq. "{filters({j}:{j})}" | $ cat - > /dev/null
     if {{EFOSCzp}.tbl,tblcontr(10)} .gt. 0 then !- if there is something to plot, plot it.

        set/grap color={colors({j})} ltype=0 stype=1 ssize=2
        over/tab {EFOSCzp} :epoch :zp

      endif

   enddo

  sele/tab {EFOSCzp} all

  set/grap stype=9 ssize=3 color=1
  over/tab wtab :epoch :zp

enddo

set/grap color=1
labe/gra "EFOSC ZPs" 135,110,mm ? 3 1

set/grap color={colors(1)}
labe/gra "U" 140,90,mm ? 1 1
set/grap color={colors(2)}
labe/gra "B" 143,90,mm ? 1 1
set/grap color={colors(3)}
labe/gra "V" 146,90,mm ? 1 1
set/grap color={colors(4)}
labe/gra "R" 149,90,mm ? 1 1
set/grap color={colors(5)}
labe/gra "I" 151,90,mm ? 1 1

sele/tab {EFOSCzp} all | $ cat - > /dev/null
w = {wtab.tbl,:epoch,@1} 
w(2) = (w(1)-m$nint(w(1)-.5))*24.
i = w(2)
j = (w(2)-i)*60.
set/for i1

set/grap color=1
labe/gra "Last measurement:" 135,70,mm ? 1 1
labe/gra "{i}:{j} UT" 135,65,mm ? 1 1
labe/gra "Filter: {wtab.tbl,:ffilter,@1} " 135,60,mm ? 1 1
set/for i1 f6.3
labe/gra "Bin: {wtab.tbl,:binx,@1} " 135,55,mm ? 1 1
labe/gra "ZP: {wtab.tbl,:zp,@1} +/- {wtab.tbl,:zps,@1} " 135,50,mm ? 1 1
labe/gra "mes. on {wtab.tbl,:nZ,@1} stars" 135,45,mm ? 1 1

set/for

labe/gra "x= Mod.JDay -52900." 120.,5,mm ? 1 1

!- save table in ascii
sele/tab {EFOSCzp} all
assi/prin file {zpArchive}/EFOSCzp.dat
prin/tab {EFOSCzp} ? ? ? 130
assi/prin

writ/out "[EFOSCamag/auto] *info* done."
$ echo "==============================================================================" >> t_{inima}_zp
$ cat  t_{inima}_zp
$ echo "[EFOSCamag/auto] result in >> t_{inima}_zp << and in E3P6OPS/pipeline_database/EFOSC"

!---oOo---
