!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  EMMI automatic measurement
!  @(#) $Id: EMMIamag_mesAuto.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.usage
!  @@ EMMIamag_mesAuto fits
!     fits: a EMMI raw frame, eg  EMMI.2003-12-31T01:02:03.456.fits
!
!.purpose
!  pseudo pipeline for EMMI photometric fields
!
!  It will read the frame in, then measure the 2 subframes
!
!.version 2004-08-05 deals with VLT APR2004 format for emmir chip
!.history
! 2004-04-29 standardized plot with efosc
! 2003-11-24 adapted for EMMI
! 2003-10-24 first WFI working version

!--- configuration parameters
!    uncomment one of the following blocks:
!--- for the telescope
defi/loc zpArchive/c/1/72 /data/NTTOPS/pipeline_database/EMMI/Photometry
!! defi/loc zpArchive/c/1/72 /data/E3P6OPS/pipeline_database/EFOSC/Photometry
!! defi/loc zpArchive/c/1/72 /data/NTTOPS/pipeline_database/SUSI/Photometry
!! defi/loc zpArchive/c/1/72 /data/E2P2OPS/pipeline_database/WFI

!--- local implementation
!!!defi/loc zpArchive/c/1/72 .

crea/gra 
crea/dis ? 450,950

writ/key EMMIzp/c/1/72 {zpArchive}/EMMIzp

defi/loc inima/c/1/72 
defi/loc i/i/1/1 0
defi/loc j/i/1/1 0

defi/loc filters/c/1/5 "UBVRI"
defi/loc colors/i/1/5 1,4,3,2,6
defi/loc plotflag/i/1/1 1
defi/loc w/r/1/3 0.,0.,0.
defi/loc ep/r/1/2 0.,0.
defi/loc archf/c/1/72 xxx

!
!-- read FITS in
!


if "{p1(1:5)}" .eq. "ONTT." then 
    inima = "eR_{p1(14:15)}T{p1(17:18)}{p1(20:21)}{p1(23:24)}_"
else if "{p1(1:5)}" .eq. "EMMI." then
    inima = "eR_{p1(14:15)}T{p1(17:18)}{p1(20:21)}{p1(23:24)}_"
else 
    writ/out "[EMMIamag/auto] *ERROR* this program is meant to deal with"
    writ/out "                untouched raw EMMI images. Use AMAG/MES instead"
    writ/out "                for other data"
    writ/out "   -- I ll just make the ZP plot"
    goto theend
endif

i = m$exist("{inima}0001.bdf")
if i .eq. 0 then
   writ/out "[EMMIamag/auto] *info* reading file {inima} in Midas"

   $ rm -f wEMMI_*bdf
   indi/mfits {p1} wEMMI_

   i = m$exist("wEMMI_0004.bdf")

   if i .eq. 1 then
      ! deal with 2 chips and 4 amplifiers in 4 frames
      aver/ima {inima}0001 = wEMMI_0001,wEMMI_0002 M 0 average
      aver/ima {inima}0002 = wEMMI_0003,wEMMI_0004 M 0 average
   else 
      ! deal with 2 chips and 4 amplifiers in 2 frames
      $ mv wEMMI_0001.bdf {inima}0001.bdf
      $ mv wEMMI_0002.bdf {inima}0002.bdf
   endif
   $ mv wEMMI_0000.bdf {inima}0000.bdf
   $ rm -f wEMMI_000?.bdf
endif

archf = "{{inima}0000,ARCFILE}"
@@ amag_checkfile {archf} .fits nocheck naked
archf = "zp.{outputc}"


!
!-- Measure the sub-images
!

!dbg!goto theend


!-- reads the position angle and takes it into account
defi/loc posang/i/1/1 0
posang = 180 - ({{inima}0000.bdf,ESO.ADA.POSANG})


do i = 1 2 
  writ/out "[EMMIamag/auto] *info* processing frame {i}"

$ echo "  @@ amag_mesAuto {inima}{i} 0.1665 {posang} 1    !- measure"

  @@ amag_mesAuto {inima}{i} 0.1665 {posang} 1    !- measure




  @@ amag_checkfile t_{inima}{i}.tbl .tbl softcheck
  if outputi .eq. 1 then
    @@ amag_exptime t_{inima}{i}  !- correct exp.time
    @@ amag_oneZero t_{inima}{i} EMMI
    $ mv  t_{inima}{i}.tbl {zpArchive}/{archf}_{i}.tbl
  endif
  !!  $ rm {inima}{i}.bdf
enddo

theend:
!
!-- plot the individual zero points
!
writ/out "[EMMIamag/auto] *info* plotting ZPs"

sele/tab {EMMIzp} seq .eq. {{EMMIzp}.tbl,TBLCONTR(10)}
copy/tab {EMMIzp} wtab


sele/tab {EMMIzp} all | $ cat - > /dev/null
sort/tab {EMMIzp} :epoch(-)
stat/tab {EMMIzp} :epoch  | $ cat - > /dev/null
ep(1) = outputr(1)-.1
ep(2) = outputr(2)+5


defi/loc chofx/r/1/8 75,10  !- start of the plots for each subchips 
defi/loc chofy/r/1/8 10,10  !   /8 for compatibility with WFI

do i = 1 2 ! loop on chips
   writ/out "               chip {i}"
   set/grap pmode=1 color=1 ltype=1 stype=1 ssize=3
   if i .eq. 1 then
      plot/axe {ep(1)},{ep(2)} 22.8,26.5 -56,-110,{chofx({i})},{chofy({i})}
   else
      over/axe {ep(1)},{ep(2)} 22.8,26.5 -56,-110,{chofx({i})},{chofy({i})}
   endif
   set/form i1
   labe/gra "-{i}-" {ep(1)},26.2 ? 2 1

   do j = 1 5 ! loop on filters
      !- select the ZP for considered chip and filter
      sele/tab {EMMIzp} :chip .eq. {i} .and. :FILTER .eq. "{filters({j}:{j})}" | $ cat - > /dev/null
     if {{EMMIzp}.tbl,tblcontr(10)} .gt. 0 then !- if there is something to plot, plot it.

        set/grap color={colors({j})} ltype=0 stype=1 ssize=2
        over/tab {EMMIzp} :epoch :zp

      endif

   enddo

  sele/tab {EMMIzp} all

  !- plot large symbol on last measurement
  set/grap stype=9 ssize=3 color=1
  over/tab wtab :epoch :zp


enddo

set/grap color=1
labe/gra "EMMI ZPs" 135,110,mm ? 3 1

set/grap color={colors(1)}
labe/gra "U" 140,90,mm ? 1 1
set/grap color={colors(2)}
labe/gra "B" 143,90,mm ? 1 1
set/grap color={colors(3)}
labe/gra "V" 146,90,mm ? 1 1
set/grap color={colors(4)}
labe/gra "R" 149,90,mm ? 1 1
set/grap color={colors(5)}
labe/gra "I" 151,90,mm ? 1 1

sele/tab {EMMIzp} all | $ cat - > /dev/null
w = {{EMMIzp}.tbl,:epoch,@1} 
w(2) = (w(1)-m$nint(w(1)-.5))*24.
i = w(2)
j = (w(2)-i)*60.
set/for i2

set/grap color=1
labe/gra "Last measurement:" 135,70,mm ? 1 1
labe/gra "{i}:{j} UT" 135,65,mm ? 1 1
labe/gra "Filter: {wtab.tbl,:ffilter,@1} " 135,60,mm ? 1 1
set/for i1 f6.3
labe/gra "Bin: {wtab.tbl,:binx,@1} " 135,55,mm ? 1 1
labe/gra "ZP: {wtab.tbl,:zp,@1} +/- {wtab.tbl,:zps,@1} " 135,50,mm ? 1 1
labe/gra "mes. on {wtab.tbl,:nZ,@1} stars" 135,45,mm ? 1 1

set/for

labe/gra "x= Mod.JDay -52900." 120.,5,mm ? 1 1


!- save table in ascii
sele/tab {EMMIzp} all
assi/prin file {zpArchive}/EMMIzp.dat
prin/tab {EMMIzp} ? ? ? 130
assi/prin

writ/out "[EMMIamag/auto] *info* done."
$ echo "==============================================================================" >> t_{inima}zp
$ cat  t_{inima}zp
$ echo "[EMMIamag/auto] result in >> t_{inima}zp << and in NTTOPS/pipeline_database/EMMI"

!---oOo---
