!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  SUSI automatic measurement
!  @(#) $Id: SUSIamag_mesAuto.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.usage
!  @@ SUSIamag_mesAuto fits
!     fits: a SUSI raw frame, eg  SUSI_Imag.123.fits
!
!.purpose
!  pseudo pipeline for SUSI photometric fields
!
!  It will read the frame in, then measure the 8 subframes
!
!.version 2004-02-24 oh improved label of graps
!.history
!2003-10-24 ohainaut first working version

!--- configuration parameters
!    uncomment one of the following blocks:
!--- for the 2p2m
defi/loc zpArchive/c/1/72 /data/NTTOPS/pipeline_database/SUSI/Photometry

!--- local implementation
!!!defi/loc zpArchive/c/1/72 .

crea/gra 
crea/dis ? 450,950

writ/key SUSIzp/c/1/72 {zpArchive}/SUSIzp

defi/loc inima/c/1/72 
defi/loc i/i/1/1 0
defi/loc j/i/1/1 0

defi/loc filters/c/1/5 "UBVRI"
defi/loc colors/i/1/5 1,4,3,2,6
defi/loc plotflag/i/1/1 1
defi/loc w/r/1/3 0.,0.,0.
defi/loc ep/r/1/2 0.,0.
defi/loc archf/c/1/72 xxx

!
!-- read FITS in
!


if "{p1(1:5)}" .eq. "ONTT." then 
    inima = "su_{p1(14:15)}T{p1(17:18)}{p1(20:21)}{p1(23:24)}_"
else if "{p1(1:5)}" .eq. "SUSI2" then
    inima = "su_{p1(15:16)}T{p1(18:19)}{p1(21:22)}{p1(24:25)}_"
else 
    writ/out "[SUSIamag/auto] *ERROR* this program is meant to deal with"
    writ/out "                untouched raw SuSI2 images. Use AMAG/MES instead"
    writ/out "                for other data"
    return/exit
endif

i = m$exist("{inima}0001.bdf")
if i .eq. 0 then
   writ/out "[SUSIamag/auto] *info* reading file {inima} in Midas"
   indi/mfi {p1} {inima}
endif

archf = "{{inima}0000.bdf,ARCFILE}"
@@ amag_checkfile {archf} .fits nocheck naked
archf = "zp.{outputc}"

!
!-- Measure the sub-images
!

do i = 1 2
  writ/out "[SUSIamag/auto] *info* processing frame {i}"
  @@ amag_mesAuto {inima}{i} 0.0805 AUTO -1    !- measure
  @@ amag_checkfile t_{inima}{i}.tbl .tbl softcheck
  if outputi .eq. 1 then
    @@ amag_exptime t_{inima}{i}  !- correct exp.time
    @@ amag_oneZero t_{inima}{i} SUSI
    $ mv  t_{inima}{i}.tbl {zpArchive}/{archf}_{i}.tbl
  endif
enddo

theend:

!
!-- plot the individual zero points
!
writ/out "[SUSIamag/auto] *info* plotting ZPs"

sele/tab {SUSIzp} seq .eq. {{SUSIzp}.tbl,TBLCONTR(10)}
copy/tab {SUSIzp} wtab

sele/tab {SUSIzp} all | $ cat - > /dev/null
sort/tab {SUSIzp} :epoch(-)
stat/tab {SUSIzp} :epoch  | $ cat - > /dev/null
ep(1) = outputr(1)-.1
ep(2) = outputr(2)+ (outputr(2)-outputr(1))/10.


defi/loc chofx/r/1/8 10,75  !- start of the plots for each subchips 
defi/loc chofy/r/1/8 10,10  !   /8 for compatibility with WFI

do i = 1 2 ! loop on chips
   writ/out "               chip {i}"
   set/grap pmode=1 color=1 ltype=1 stype=1 ssize=3
   if i .eq. 1 then
      plot/axe {ep(1)},{ep(2)} 22.8,26.5 -56,-110,{chofx({i})},{chofy({i})}
   else
      over/axe {ep(1)},{ep(2)} 22.8,26.5 -56,-110,{chofx({i})},{chofy({i})}
   endif
   set/form i1
   labe/gra "-{i}-" {ep(1)},26.2 ? 2 1

   do j = 1 5 ! loop on filters
      !- select the ZP for considered chip and filter
      sele/tab {SUSIzp} :chip .eq. {i} .and. :FILTER .eq. "{filters({j}:{j})}" | $ cat - > /dev/null
     if {{SUSIzp}.tbl,tblcontr(10)} .gt. 0 then !- if there is something to plot, plot it.

        set/grap color={colors({j})} ltype=0 stype=1 ssize=2
        over/tab {SUSIzp} :epoch :zp

      endif
   enddo

  sele/tab {SUSIzp} all

  set/grap stype=9 ssize=3 color=1
  over/tab wtab :epoch :zp

enddo

set/grap color=1
labe/gra "SUSI ZPs" 140,110,mm ? 3 1

set/grap color={colors(1)}
labe/gra "U" 140,90,mm ? 1 1
set/grap color={colors(2)}
labe/gra "B" 143,90,mm ? 1 1
set/grap color={colors(3)}
labe/gra "V" 146,90,mm ? 1 1
set/grap color={colors(4)}
labe/gra "R" 149,90,mm ? 1 1
set/grap color={colors(5)}
labe/gra "I" 151,90,mm ? 1 1

sele/tab {SUSIzp} all | $ cat - > /dev/null
w = {wtab.tbl,:epoch,@1} 
w(2) = (w(1)-m$nint(w(1)-.5))*24.
i = w(2)
j = (w(2)-i)*60.
set/for i1


set/grap color=1
labe/gra "Last measurement:" 135,70,mm ? 1 1
labe/gra "{i}:{j} UT" 135,65,mm ? 1 1
labe/gra "Filter: {wtab.tbl,:ffilter,@1} " 135,60,mm ? 1 1
set/for i1 f6.3
labe/gra "Bin: {wtab.tbl,:binx,@1} " 135,55,mm ? 1 1
labe/gra "ZP: {wtab.tbl,:zp,@1} +/- {wtab.tbl,:zps,@1} " 135,50,mm ? 1 1
labe/gra "mes. on {wtab.tbl,:nZ,@1} stars" 135,45,mm ? 1 1
set/form

labe/gra "x= Mod.JDay -52900." 120.,5,mm ? 1 1

!- save table in ascii
sele/tab {SUSIzp} all
assi/prin file {zpArchive}/SUSIzp.dat
prin/tab {SUSIzp} ? ? ? 130
assi/prin

writ/out "[SUSIamag/auto] *info* done."
$ echo "==============================================================================" >> t_{inima}zp
$ cat  t_{inima}zp
$ echo "[SUSIamag/auto] result in >> t_{inima}zp << and in NTTOPS/pipeline_database/SUSI"

!---oOo---
