!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_edit.prg,v 1.2 2003/10/26 06:27:17 ohainaut Exp $
!
!.version 2003-11-22 added undelete
!.history
!  1994 created
!
defi/par p1 ? ? "table "
if p1 .eq. "???" then
wri/ou "  T m a g   Photometric Package"
wri/ou "  @(#) $Id: amag_edit.prg,v 1.2 2003/10/26 06:27:17 ohainaut Exp $"
wri/ou ""
wri/ou ".syntax       @@ tmag_edit table Delete? selection"
wri/ou ".purpose      T-MAG photometric package"
wri/ou "	       identify and delete some standard stars from a tmag table"
wri/ou ".parameters"
wri/ou "    table:    input table"
wri/ou "    delete:   D: delete the star (by changing its stdmag to -stdmag)"
wri/ou "	      N: just identifiy the star (default)"
wri/ou "              U: undelete last"
wri/ou "    select:   Additional selection to DELETE"
return/exit
endif
!---------
defi/par p2 N ? "Delete? D/N"
defi/par p3 nil C "additional condition"

@@ amag_checkfile {p1} .tbl check extn
defi/loc intab/c/1/72 {outputc}

defi/loc i/i/1/1 0
defi/loc iw/i/1/1 0
defi/loc w/r/1/2 0.,0.
defi/loc dmin/r/1/1 9999999999.
defi/loc imin/i/1/1 0
defi/loc w1/r/1/1 0.

set/grap color=1

!-- undelete
if p2 .eq. "U" then
  comp/tab {intab} :stdstatus = :stdstatus * (:w_selb +1)/2
  sele/tab {intab} :w_selb .eq. 1
  writ/out "[amag/edit] *INFO* Following stars have been restored"
  writ/out "                   Re-run amag.prg with option IDENT=Y "
  writ/out "                   to get a new solution"
  read/tab {intab} :ident :frame :stdmag :airm :dm_test
  return/exit
endif


!- get the star to delete
get/gcur w_del ? 1
defi/loc wx/r/1/3 {w_del.tbl,:X_axis,@1},0.,0.
defi/loc wy/r/1/3 {w_del.tbl,:Y_axis,@1},0.,0.
wx(2) = wx(1)-.1
wx(3) = wx(1)+.1
wy(2) = wy(1)-.05
wy(3) = wy(1)+.05

!-- additional selection:
if p3 .ne. "nil" then
  sele/tab {intab} {p3}
  comp/tab {intab} :w_selb = sel
else
  comp/tab {intab} :w_selb = 1
endif

!-- compute distance to selected point
comp/tab {intab} :dist = (:w - {wx(1)})**2 + (:dm_test - {wy(1)})**2

!-- loop to find closest point

do i = 1 {{intab},tblcontr(10)}
   if {{intab},:dist,@{i}} .le. {dmin} .and. {{intab},:w_selb,@{i}} .eq.  1 then
      dmin =   {{intab},:dist,@{i}} 
      imin =   i
   endif
enddo

!- select found point
sele/tab {intab} seq .eq. {imin}

!-- plot the selected stars:
set/grap color=2
over/tab {intab} {tmagplx} {tmagply}
set/grap color=1	 !-- restore black

writ/out "[amag/edit] *info* Star selected for deletion:"
read/tab {intab} :ident :frame :stdmag :airm :dm_test
writ/out
writ/out "***** re-run to delete other stars"

if p2 .eq. "D" then
  sele/tab {intab} seq .eq. {i}
  comp/tab {intab} :w_selb = -2*sel +1
!!! for tmagold  comp/tab {intab} :stdmag = :stdmag* :w_selb
  {intab},:stdstatus,@{imin} = 0.
  writ/out "***** re-run tmag.prg with option IDENT=Y to get a new solution"
else
  writ/out "***** star just identified"
  writ/out "*****  rerun with P2=D to actually delete the star"
endif

!---oOo---