!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_kload.prg,v 1.3 2003/10/26 06:27:17 ohainaut Exp $
!
!
! KLOAD.PRG
! 
! This is a copy of the KLOAD command for Tmag to be standalone.
!
! @@ kload ima [low,high]
! kload/image ima [low,high]
!
! load the image, setting the cuts to low*mean_level,high*mean_level.
! Very quick, thanks to the use of FAST/STAT on  small parts of the image
!
!.version	Sat Jan 12 17:33:51 2002
!------------------------------------------------------------------------------

defi/par p1 ? c "image? "
defi/par p2 1.,10. ? "contrast factors? <0 for force "
defi/par p3 def c "option1"
defi/par p4 def c "option2"
defi/par p5 V c "verbose/quiet"

defi/loc npix/i/1/2 0,0
defi/loc i/i/1/2 0,0
defi/loc cut/r/1/2 0.,0.
defi/loc cont/r/1/2 'p2'
defi/loc name/c/1/72 " "
defi/loc w/r/1/6 0. ALL
defi/loc mean/r/1/1 0.
defi/loc sigma/r/1/1 0.
defi/loc op1/c/1/20 " "
defi/loc op2/c/1/20 " "
defi/loc res/i/1/1 0
defi/loc corner/i/1/1 0
defi/loc boxsiz/i/1/1 15
defi/loc inima/c/1/72 {p1}

if p3 .ne. "def" op1 = p3
if p4 .ne. "def" op2 = p4

	    
i = m$index(inima,"fits")
if i .gt. 0 then
   @@ cintape_ntt {inima}
   inima = outputc
endif


res = M$existd(inima,"kload")
if res .eq. 0 .or.  cont(1) .le. 0 then
!-- image never measure before
  w =  {{inima},npix(1)}
  if {{inima},npix(2)}) .lt. w comp/key  w =  {{inima},npix(2)}

  if w .ge. 2050 then ! most likely emmi red MIT
     corner = 800
  else

  if w .ge. 512 then
      corner = 200
  else
      if w .ge. 128 then
	 corner = 20
      else
         if w .ge. 15 then
	    corner = 5
	    boxsiz = 3
         else
      	    if w .ge. 1 then
	       !--- mini image, let's do it now
	       stat/ima {inima} opt=rn
	       mean = outputr(3)
	       sigma = outputr(4)
	       writ/des {inima} kload/r/1/2 {mean},{sigma}
	       goto display
	    else
	       !--- pb: dim = 0
	       writ/out "[amag/kload] ***error**** I cannot deal with that image"
	       return/exit
	    endif
         endif
      endif
  endif 
  endif


  $rm -f w_kload.tbl
  crea/tab w_kload  2 4
  crea/col w_kload :mean R*4 "adu" f10.6
  crea/col w_kload :sigma R*4 "adu" f10.6

  set/form f9.3
  copy/dk {inima} npix npix

  write/out "[amag/kload] Statistic 1 "

  w(1) = corner
  w(2) = corner
  w(3) = corner+boxsiz
  w(4) = corner+boxsiz 
  stat {inima} [@{w(1)},@{w(2)}:@{w(3)},@{w(4)}] ? ? SN
  w_kload.tbl,:mean,@1 =  {outputr(3)}
  w_kload.tbl,:sigma,@1 = {outputr(4)}

  w(1) = 'npix(1)' -corner-boxsiz
  w(2) = 'npix(2)' -corner-boxsiz
  w(3) = 'npix(1)' -corner
  w(4) = 'npix(2)' -corner
  write/out "          2"
  stat {inima} [@{w(1)},@{w(2)}:@{w(3)},@{w(4)}] ? ? SN
  w_kload.tbl,:mean,@2 =  {outputr(3)}
  w_kload.tbl,:sigma,@2 = {outputr(4)}

  w(1) = npix/2.+corner
  w(2) = 'npix(2)' -corner-boxsiz
  w(3) = npix/2.+corner+boxsiz
  w(4) = 'npix(2)' -corner
  write/out "          3"
  stat {inima} [@{w(1)},@{w(2)}:@{w(3)},@{w(4)}] ? ? SN
  w_kload.tbl,:mean,@3 =  {outputr(3)}
  w_kload.tbl,:sigma,@3 = {outputr(4)}

  w(1) = 'npix(1)' -corner-boxsiz
  w(2) = corner
  w(3) = 'npix(1)' -corner
  w(4) = corner+boxsiz
  write/out "          4"
  stat {inima} [@{w(1)},@{w(2)}:@{w(3)},@{w(4)}] ? ? SN
  w_kload.tbl,:mean,@4 =  {outputr(3)}
  w_kload.tbl,:sigma,@4 = {outputr(4)}

  
!  stat/tab w_kload :mean
!  mean = outputr(3)
!  stat/tab w_kload :sigma
!  sigma = outputr(3)
 
  sort/tab w_kload :mean
  mean = {w_kload.tbl,:mean,@2}

  sort/tab w_kload :sigma
  sigma  = {w_kload.tbl,:sigma,@2}


  writ/des {inima} kload/r/1/2 {mean},{sigma}

else
  mean = {{inima},kload(1)}
  sigma = {{inima},kload(2)}
endif

display:
if cont(1) .le. 0. cont(1) = -cont(1)
if cont(2) .le. 0. cont(2) = -cont(2)

cut(1) = mean-sigma*cont(1)
cut(2) = mean+sigma*cont(2)

write/out "[amag/kload] *info*
write/out "    Statistics:       Mean:{mean} Sig:  {sigma}"
write/out "    Contrast factors: Low: {cont(1)}    High: {cont(2)} "
write/out "    Cuts              Low: {cut(1)} High: {cut(2)} "


if p3 .ne. "NOLOAD" then
  clea/cha ov
  load/ima {inima} cuts={cut(1)},{cut(2)} {op1} {op2}

  if p5 .eq. "Q" then
     disp/lut off
  else
     label/disp "{{inima},ident}" 30,10 ? ? 2
  endif
else
  writ/des {inima} lhcuts/r/1/2 {cut(1)},{cut(2)}
endif

set/form
