!------------------------------------------------------------------------
!  T m a g   Photometric Package
!  @(#) $Id: amag_mesAuto.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
! @@ amag_mesAuto std_frames.cat pixScale angle orientation
!
!.note
!   semi-automatically measure stars
!   modified from amag_mes for WFI/SuSI/EMMI quick look tool
!
!.author 	ohainaut
!
!.version 2003-12-04 added EFOSC
!.history
! 2003-11-23 added EMMI
! 2003-11-21 record bin
! 2003-10-26 ohainaut WFI+SuSI 
! 2003-10-21T23:29:14 Tue  ohainaut WFI; learns centering and remembers it
! Wed Jan 10 03:09:36 2001 orh first recorded version
! 2000 orh creation
!----------------------------------------------------------------------
defi/par p1 {idimemc} ? "image?
if "{p1}" .eq. "???" then
wr/o "			          		T M A G   Photometric Package "
wr/o " amag/mesAuto  or  @@ amag_mesAuto                                      "
wr/o "                                                                        "
wr/o ".syntax                                                                 "
wr/o "		AMAG/MESAuto image [pixScale posAng orientation]           "
wr/o ".purpose                                                                "
wr/o "          measures the standard stars on one La Silla image.            "
wr/o "                                                                        "
wr/o ".parameters                                                            "
wr/o "   	image: input image (expects .bdf)                            "
wr/o "          pixScale, in arcsec                                          "
wr/o "          posAng, of top of CCD, East of North, or AUTO
wr/o "          orientation: +1 if E left of N, -1 if E right of N"
wr/o ".usage                                                                 "
wr/o "          The image will be loaded."
wr/o "          Click on one cross, and on the corresponding star "
wr/o "          The prg will then compute the offset between the object and"
wr/o "          the catalogue, and measure all the stars in the catalogue"
wr/o "                                                                        "
wr/o ".notes                                                                  "
wr/o "          - the coordinates are expected to be found in O_POS           "
wr/o "          - is posAng = AUTO, the angle is read in ESO.ADA.POSANG       "
wr/o "          - the program knows only about Landolt's std in UBVRI         "
wr/o "          - the program looks for the filter in FILTER or in            "
wr/o "              ESO.INS.FILT1.NAME                                        "
wr/o "          - the prg tries to get the airmass from                       "
wr/o "             ESO.TEL.AIRM.START and ...END (averages them)             "
wr/o "             or O_AIRM                                                  "
wr/o "          - the epoch is optained from o_time(4), and the exposure time "
wr/o "            from o_time(7)                                              "
wr/o "                                                                        "
wr/o "-----------------------------------------------------------------------------"
return
endif
defi/par p2 .24 N "pixel scale?"
defi/par p3 0. c "posang value/AUTO"
defi/par p4 1. N "orient 1: E =left of N, -1: E right of N"


defi/loc center/r/1/2 0.,0.
defi/loc i/i/1/1 0

defi/loc main_det/r/1/1 0.
defi/loc ax/d/1/1 0.
defi/loc bx/d/1/1 0.
defi/loc cx/d/1/1 0.
defi/loc ay/d/1/1 0.
defi/loc by/d/1/1 0.
defi/loc cy/d/1/1 0.
writ/key scale/d/1/2 0. all

defi/loc sx/r/1/3 0.,0.,0.
defi/loc sy/r/1/3 0.,0.,0.
defi/loc gx/r/1/3 0.,0.,0.
defi/loc gy/r/1/3 0.,0.,0.

defi/loc w/r/1/1 0.
defi/loc rms/r/1/3 0.,0.,0.

defi/loc iflag/i/1/1 0

defi/loc orient/i/1/1 {p4}

!
!-- INPUT IMAGE
!

@@ amag_checkfile {p1} .bdf check naked
defi/loc inima/c/1/72 {outputc}
defi/loc inimsh/c/1/72 {outputc}
i = m$len(inima)-1
inimsh = "{inima(:{i})}0.bdf"
i = i+1

!- in case of multiple chips, get the #
defi/loc chip/i/1/1 0
chip = {inima({i}:{i})}

!- special case of single chips
if "{inima(1:3)}" .eq. "ef_" then
     inimsh = "{inima}.bdf"
     chip = 1
endif 


!- check that extension 0 = main header, is present

@@ amag_checkfile {inimsh} .bdf softcheck 
if outputi(1) .eq. 0 then
   !-- extension 0 not present - let's hope for the best...
   writ/out "[amag/mesAuto] *WARNING* {inimsh} not present - let's hope it works"
   inimsh = "{inima}.bdf"
endif

!- do we need to load the image?
clea/lut
if "{inima}" .ne. "{idimemc}" then
   if "{inima(1:3)}" .eq. "eR_" then ! to deal with part 2 of emmi
       load {inima} sc=-4 cu=300,20000
   else if  "{inima(1:3)}" .eq. "ef_" then !
       load {inima} sc=fu cu=f,i
   else 
       load {inima} sc=-4 cu=f,ihap
   endif
else
  writ/out "[amag/mesAuto] *info* image {inima} already loaded"
endif


!- reads the coord from header

wri/key wra/d/1/1 0.
wri/key wdec/d/1/1 0.

wra = {{inimsh},o_pos(1)}
wdec = {{inimsh},o_pos(2)}
!dbg! writ/out "coord: {wra} {wdec}"


if "{P3}" .eq. "AUTO" then
        i = m$existd("{inimsh}","ESO.ADA.POSANG")
	if  i .eq. 1 then
	    defi/loc posang/r/1/1 {{inimsh},ESO.ADA.POSANG}
	else
	    defi/loc posang/r/1/1 0.
        endif
  
else
   defi/loc posang/r/1/1 {p3}
endif
!dbg! writ/out "Position Angle: {posang}"

!
!-- GET THE STARS 
!

set/for f8.6
defi/loc pixsc/r/1/1 {p2}

defi/loc rad/i/1/1 0.
rad = {{inima},npix(1)}*pixsc/60.*2.   !  *.7

defi/loc intab/c/1/72 LandLoc.tbl

!- to ensure that AMAG is defined:
set/cont tmag | $ cat - > /dev/null

$ cp {AMAG}/Landolt.tbl {intab}
sele/tab {intab} all


writ/key determi/r/1/1 0.



!-- crude estimate of the astrometric solution
wri/out "{inimsh}"
i = m$existd(inimsh,"ESO.INS.ID")
if i .eq. 0 then
  writ/out "[amag/mesAuto] *ERROR* ESO.INS.ID not present..."
  writ/out "              This program is for on-line quick look only"
  writ/out "              You may want to use generic AMAG/MES"
  return/exit
endif


!- do we have centers already defined?
i = m$existk("centerx")
if i .eq. 0 then  
  if "{{inimsh},ESO.INS.ID(1:3)}" .eq. "WFI" then
     !- wfi
     @@ WFIamag_defCenter
  else if "{{inimsh},ESO.INS.ID(1:4)}" .eq. "SUSI" then
     !-- SUSI
     @@ SUSIamag_defCenter
  else if "{{inimsh},ESO.INS.ID(1:4)}" .eq. "EMMI" then
     !-- EMMI
     @@ EMMIamag_defCenter
  else if "{{inimsh},ESO.INS.ID(1:5)}" .eq. "EFOSC" then
     !-- EFOSC2
     @@ EFOSCamag_defCenter
  else 
     writ/out "[amag/mesAuto] *ERROR* implemented only for WFI, SUSI, EMMI, EFOSC2"
     return/exit
  endif
  writ/key centerx/r/1/8 -9999. all
  writ/key centery/r/1/8 -9999. all
endif



if centerx({chip}) .le. -999 then ! load default and set manual
    centerx({chip}) = centerx0({chip}) 
    centery({chip}) = centery0({chip}) 
    iflag = 1
endif

center(1) = centerx({chip})
center(2) = centery({chip})
  

recenter:
! jumps back here after manual centering

!DBG! 
writ/out "DBG center {center(1)} {center(2)}"

centerx({chip}) = center(1)  !- store the centers for next use
centery({chip}) = center(2)

comp/tab {intab} :xcen = -({orient})*cos({posang})*(:r_a-{wra}) 
comp/tab {intab} :xcen = :xcen - sin({posang})*(:dec-({wdec}))
comp/tab {intab} :xcen = :xcen*3600.*cos({wdec})
comp/tab {intab} :xcens = :xcen
comp/tab {intab} :xcen = {center(1)}+:xcens/{pixsc}

comp/tab {intab} :ycen = -({orient})*sin({posang})*(:r_a - {wra}) 
comp/tab {intab} :ycen = :ycen+ cos({posang})*(:dec-({wdec}))
comp/tab {intab} :ycen = :ycen*3600.
comp/tab {intab} :ycens = :ycen
comp/tab {intab} :ycen = {center(2)}+:ycens/{pixsc}

writ/out "[amag/mesAuto] *info* Loading the stars on display"
cle/ch ov
sel/tab  {intab} all  | $ cat > /dev/null
load/tab {intab} :xcen :ycen ? 6 10 3  | $ cat - > /dev/null
comp/tab {intab} :dist = sqrt(:xcen**2 + :ycen**2)



!--- interactive selection of the star

if iflag .eq. 1 then
  writ/out
  writ/out "[amag/mesAuto] *ACTION*--> For 1 star, click the cross, then the image"
  writ/out "                          If no star visible, just exit"
  writ/out
  
  $ rm -f wjunk_center.tbl
  get/cur wjunk_center p4=2,1
  if m$exist("wjunk_center.tbl") .eq. 0 then
     writ/out "[amag/mesAuto] You were supposed to select 2 points in total"
     writ/out "              **EXIT**"
     return
  endif
  if {wjunk_center.tbl,tblcontr(10)} .ne. 2 then
     writ/out "[amag/mesAuto] You were supposed to select 2 points in total"
     writ/out "              **EXIT**"
     return/exit
  else
    wri/out "thanks-"
  endif
  
  
  center(1) = center(1)- {wjunk_center,:x_coord,@1} +{wjunk_center,:x_coord,@2}
  center(2) = center(2)- {wjunk_center,:y_coord,@1} +{wjunk_center,:y_coord,@2}
  
  iflag = 0
  goto recenter
endif

!- prepare for detection of the stars

w = 15./pixsc
if w .ge. 100 w = 99

!!w = 30./pixsc
!!w = 99
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}
dra/rec {intab} F  | $ cat - > /dev/null

!- select only the stars that are visible

w = {{inima},start(1)}+ 50.
sele/tab {intab} :xstart .ge. {w}   | $ cat > /dev/null
w = {{inima},start(2)}+ 50.
sele/tab {intab} sel.eq.1 .and. :ystart .ge. {w}  | $cat > /dev/null
w = {{inima},start(1)}+ {{inima},npix(1)}*{{inima},step(1)} -50
sele/tab {intab} sel.eq.1 .and. :xend .le. {w}  | $ cat > /dev/null
w = {{inima},start(2)}+ {{inima},npix(2)}*{{inima},step(2)} -50
sele/tab {intab} sel.eq.1 .and. :yend .le. {w}  | $ cat > /dev/null

if {{intab},tblcontr(10)} .eq. 0 then
  writ/out "[amag/mesAuto] *WARNING* no star in frame - we EXIT"
  return
endif

copy/tab {intab} w.tbl !- keep the valid stars
copy/tab w.tbl {intab}


!- detection of the stars with center/moment

comp/tab {intab} :standard = :ident
cent/mom {inima},{intab} {intab}

!-- check the success of detection, and eliminate the failed detections

sele/tab {intab} :status .eq. 0  | $ cat - > /dev/null
           !- centering successful.

if {{intab},tblcontr(10)} .eq. 0 then
  writ/out "[amag/mesAuto] *WARNING* no star found in frame - we EXIT"
  return
endif

w = {{intab},tblcontr(10)} / {{intab},tblcontr(4)}
writ/out "[amag/mesAuto] *info* Fraction of stars successfully found: {w}"
if w .le. 0.3 then
    writ/out "[amag/mesAuto] *WARNING* too few stars were found - we EXIT"
    return
    !-- at some point, we should go back to manual mode here
endif

copy/tab {intab} w.tbl  !- eliminate the failed ones.
copy/tab w.tbl {intab}

load/tab {intab} :xcen :ycen ? 6 10 4  | $ cat - > /dev/null


!- re-compute the new boxes with measured center

w = 10./pixsc ! 10arcsec
if w .ge. 100 w = 99  ! safety to avoid window larger than 200pix
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}

!- check for saturation

stat/ima {inima} {intab} opt=MNYN outta={intab},A
sele/tab {intab} :max .le. 60000.  | $ cat - > /dev/null
if {{intab},tblcontr(10)} .eq. 0 then
  writ/out "[amag/mesAuto] *WARNING* all stars are saturated - we EXIT"
  return
endif
copy/tab {intab} w.tbl  !- eliminate the failed ones.
copy/tab w.tbl {intab}


!- Photometry

defi/loc diapspec/c/1/72  "{w},@15,@10" !"@30,@5,@5"

writ/out "DEBUG {diapspec}"

magn/cir {inima},{intab} {intab} {diapspec} ? 1,2. 2,1,1,1
name/col {intab} :magnitude f8.3


draw/cir {intab} F

w = w+30
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}
draw/cir {intab} F 

w = w+100
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}
draw/cir {intab} F


!-------- airmass

i = m$existd(inimsh,"ESO.TEL.AIRM.START")
if i .eq. 1 then
  comp/tab {intab} :AIRM = ({{inimsh},ESO.TEL.AIRM.START}+{{inimsh},ESO.TEL.AIRM.END})/2.
else
  i = m$existd(inimsh,"o_airm")
  if i .eq. 1 then
    comp/tab {intab} :AIRM = {{inimsh},o_airm}
  else 
    comp/tab {intab} :AIRM = .9999999
  endif
endif
wri/out "DEBUG {inimsh}"
!---------- filter
crea/col {intab} :filter C*1
if "{{inimsh},ESO.INS.ID(1:3)}" .eq. "WFI" then
       comp/tab {intab} :ffilter = "{{inimsh},ESO.INS.FILT1.NAME}"
       comp/tab {intab} :filter = "{{inimsh},ESO.INS.FILT1.NAME(4:4)}"
else if "{{inimsh},ESO.INS.ID(1:4)}" .eq. "SUSI" then
       comp/tab {intab} :ffilter = "{{inimsh},ESO.INS.FILT1.NAME}"
       comp/tab {intab} :filter = "{{inimsh},ESO.INS.FILT1.NAME(1:1)}"
else if "{{inimsh},ESO.INS.ID(1:4)}" .eq. "EMMI" then
       comp/tab {intab} :ffilter = "{{inimsh},ESO.INS.FILT2.NAME}"
       comp/tab {intab} :filter = "{{inimsh},ESO.INS.FILT2.NAME(1:1)}"
else if "{{inimsh},ESO.INS.ID(1:5)}" .eq. "EFOSC" then
       comp/tab {intab} :ffilter = "{{inimsh},ESO.INS.FILT1.NAME}"
       if "{{inimsh},ESO.INS.FILT1.NAME}" .eq. "i#705" then
          comp/tab {intab} :filter = "I"
       else
          comp/tab {intab} :filter = "{{inimsh},ESO.INS.FILT1.NAME(1:1)}"
       endif
else
     wri/out "you should not be here"
     return/end
endif

!-------- chip
comp/tab {intab} :chip = {chip}

comp/tab {intab} :binx = {{inima},step(1)}
comp/tab {intab} :biny = {{inima},step(2)}

!-------- exptime

comp/tab {intab} :exp_time = {{inimsh},o_time(7)}

!-------- epoch
set/form f20.10,f20.10
comp/tab  {intab} :epoch = {{inimsh},O_TIME(4)}

!-------
comp/tab  {intab} :frame = "{inima}"
comp/tab  {intab} :fr_id = "{{inimsh},ESO.OBS.TARG.NAME}"

!------
comp/tab {intab} :stdstatus = 1-1000*:status

$ mv {intab} t_{inima}.tbl
read/tab  t_{inima} :standard :MAGNITUDE :filter

writ/out "[amag/mesAuto] exit"
return !!!!!!!!!!!!!!1

!---oOo---
