!------------------------------------------------------------------------------
!  T m a g   Photometric Package
!  Instrument automatic measurements
!
!  @(#) $Id: amag_oneZero.prg,v 1.1 2003/10/26 06:27:17 ohainaut Exp $
!
!.usage
!  @@ amag_oneZero tab instrument
!     tab: a t_xxx.tbl measured with <INSTRUMENT>amag_mes.prg
!     instrument: the name of the instrument. Currently supported:
!		WFI SUSI EMMI
!
!.note
!  the table should contain only one filter and one chip
!
!.purpose
!  average the zero points from one CCD subframe
!  and store result for plot by amag_mesAuto
!
!.output  
!  {<INS>zp}.tbl: one line is added
!
!.version 2003-12-04 added EFOSC
!.history
! 2003-11-28 added EMMI
! 2003-11-21 unification WFI/SUSI
! 2003-10-22 ohainaut creation
!------------------------------------------------------------------------------
defi/par p1 ? ? "input table"
defi/par p2 SUSI C "Instrument"

defi/loc intab/c/1/72 xxx
@@ amag_checkfile {p1} .tbl check naked
intab = outputc

defi/loc outfile/c/1/71 xxx
defi/loc filt/c/1/1 X
defi/loc ifilt/i/1/1 0
defi/loc mZ/r/1/1 0
defi/loc mZs/r/1/1 0
defi/loc nZ/i/1/1 0
defi/loc i/i/1/1 0
defi/loc j/i/1/1 0
defi/loc INS/c/1/72 {p2}

!-- typical values of ZP for SuSI2
if INS .eq. "SUSI" then
   defi/loc typZU/r/1/8 23.52,23.52
   defi/loc typZB/r/1/8 25.46,25.46
   defi/loc typZV/r/1/8 25.74,25.74
   defi/loc typZR/r/1/8 25.61,25.61
   defi/loc typZI/r/1/8 24.61,24.61
else if INS .eq. "WFI" then
   defi/loc typZU/r/1/8 0.,0.,0.,0.,0.,0.,0.,0.
   defi/loc typZB/r/1/8 24.67,24.75,24.50,24.72,24.65,24.78,24.70,24.53
   defi/loc typZV/r/1/8 24.17,24.27,24.03,24.20,24.20,24.25,24.18,24.06
   defi/loc typZR/r/1/8 24.51,24.60,24.37,24.58,24.54,24.60,24.52,24.42
   defi/loc typZI/r/1/8 23.30,23.47,23.24,23.53,23.48,23.50,23.43,23.32
else if INS .eq. "EMMI" then
   defi/loc typZU/r/1/8 0 all
   defi/loc typZB/r/1/8 0 all 
   defi/loc typZV/r/1/8 0 all
   defi/loc typZR/r/1/8 0 all
   defi/loc typZI/r/1/8 0 all
else if INS .eq. "EFOSC" then
   defi/loc typZU/r/1/8 0 all
   defi/loc typZB/r/1/8 0 all 
   defi/loc typZV/r/1/8 0 all
   defi/loc typZR/r/1/8 0 all
   defi/loc typZI/r/1/8 0 all
else
   writ/out "[amag/oneZero] ERROR: instrument {INS} not supported"
   return/exit
endif


!- conversion filter name -> number
filt = "{{intab}.tbl,:filter,@1}"
if filt .eq. "U" ifilt = 1
if filt .eq. "B" ifilt = 2
if filt .eq. "V" ifilt = 3
if filt .eq. "R" ifilt = 4
if filt .eq. "I" ifilt = 5

!- standard lasilla extinctions 
defi/loc stdExt/r/1/5 0.35,0.22,0.13,0.09,0.07
comp/tab {intab}.tbl :wZ = :{filt} - :MAGNITUDE + {stdExt({ifilt})}*:airm

stat/tab {intab}.tbl :wZ  | $ cat - > /dev/null
mZ = {outputr(3)}
mZs = {outputr(4)}
nZ = {outputi(2)}

set/for f20.10,f20.10

!-- is the output table already created?
i = m$exist("{{INS}zp}.tbl")

if i .eq. 0 then !- no, create it.
   crea/tab {{INS}zp} 1 1
   crea/col {{INS}zp} :epoch "MJD-52900" F20.10 R*8
   comp/tab {{INS}zp} :tab = "{intab}"
   comp/tab {{INS}zp} :filter = "{filt}"
   comp/tab {{INS}zp} :ffilter = "{{intab}.tbl,:ffilter,@1}"
   comp/tab {{INS}zp} :epoch = {{intab}.tbl,:epoch,@1} -52900.
   comp/tab {{INS}zp} :ZP = {mZ}
   comp/tab {{INS}zp} :ZPs = {mZs}
   comp/tab {{INS}zp} :nZ = {nZ}
   comp/tab {{INS}zp} :chip = {{intab}.tbl,:chip,@1}
   comp/tab {{INS}zp} :binx = {{intab}.tbl,:binx,@1}
   comp/tab {{INS}zp} :biny = {{intab}.tbl,:biny,@1}

else !- yes, add one line

   sele/tab {{INS}zp} all
   i = {{{INS}zp}.tbl,tblcontr(4)}
   crea/row {{INS}zp} @{i} 1
   i = i+1
   {{INS}zp}.tbl,:epoch,@{i} = {{intab}.tbl,:epoch,@1} -52900.
   {{INS}zp}.tbl,:tab,@{i} = "{intab}"
   {{INS}zp}.tbl,:filter,@{i} = "{filt}"
   {{INS}zp}.tbl,:ffilter,@{i} = "{{intab}.tbl,:ffilter,@1}"
   {{INS}zp}.tbl,:ZP,@{i} = mZ
   {{INS}zp}.tbl,:ZPs,@{i} = mZs
   {{INS}zp}.tbl,:nZ,@{i} = {nZ}
   {{INS}zp}.tbl,:chip,@{i} = {{intab}.tbl,:chip,@1}
   {{INS}zp}.tbl,:binx,@{i} = {{intab}.tbl,:binx,@1}
   {{INS}zp}.tbl,:biny,@{i} = {{intab}.tbl,:biny,@1}

endif
SET/FOR i1 f10.3

i = m$len(intab) -4
j = m$len(intab) -1 
if "{intab({i}:{j})}" .eq. "_000" then ! this is the multiple chip format _000x
   i = i-1
   outfile = "{intab(:{i})}"
else
   outfile = intab
endif
i = m$exist("{outfile}_zp")
if i .eq. 0 then
  $ touch {outfile}_zp
  wri/out "[amag/oneZero] created summary file {outfile}_zp"
  $ echo "==============================================================================" >> {outfile}_zp
  $ echo "{INS}: ZERO POINT QUICK LOOK RESULT" >> {outfile}_zp
  $ echo " Zero point / dispersion (and typical value) are listed below" >> {outfile}_zp
  $ echo " " >> {outfile}_zp
  $ echo " Frame                = {intab}" >> {outfile}_zp
  $ echo " Bin                  = {{intab}.tbl,:binx,@1}x{{intab}.tbl,:biny,@1}" >> {outfile}_zp
  $ echo " Epoch                = MJD = JD -2400000.5 = {{intab}.tbl,:epoch,@1}" >> {outfile}_zp
  $ echo " Filter               = {{intab}.tbl,:ffilter,@1}" >> {outfile}_zp
  $ echo " Standard Extinction  = {stdExt({ifilt})}" >> {outfile}_zp
  $ echo " Airmass (lasilla std)= {{intab}.tbl,:airm,@1}" >> {outfile}_zp
  $ echo " " >> {outfile}_zp
else
  wri/out "[amag/oneZero] Summary file {outfile}_zp already exists"
endif
$ echo " CCD number             = {{intab}.tbl,:chip,@1}" >> {outfile}_zp
$ echo "    No of stars measured= {nZ}" >> {outfile}_zp
$ echo "                    zp = {mZ} +/- {mZs}  ({typZ{filt}({{intab}.tbl,:chip,@1})})" >> {outfile}_zp
set/for
!---oOo---





