#!/scisoft/bin/wish

if { $argc != 2 } {
   error "Usage: amag_GUI.tcl <command2midas> <MIDAS session>"
}
set midsess [lindex $argv 1]
set comtomid [lindex $argv 0]


#==============================================================================
proc sendMidas { } { 
    global midcom midsess comtomid
    exec  $comtomid $midsess $midcom
}
proc setCol { } {
     global table filter optZ optE optC defZ defE defC color addSel addSelFlag
    if { $filter == "U" } { set color "U-B" }
    if { $filter == "B" } { set color "B-V" }
    if { $filter == "V" } { set color "V-R" }
    if { $filter == "R" } { set color "V-R" }
    if { $filter == "I" } { set color "R-I" }
    if { $filter == "J" } { set color "J-K" }
    if { $filter == "H" } { set color "J-K" }
    if { $filter == "K" } { set color "J-K" }
}
proc resetSolve { } {
     global midcom midsess comtomid
     global table filter optZ optE optC defZ defE defC color addSel addSelFlag
     setCol
     set midcom  "@@ amag $table $filter ? $optZ$optE$optC N $defZ,$defE,$defC new $color"
     sendMidas
}
proc solve { } {
     global midcom midsess comtomid
     global table filter optZ optE optC defZ defE defC color addSel addSelFlag
     setCol
    if { $addSelFlag } {
       set midcom  "@@ amag $table $filter ? $optZ$optE$optC Y $defZ,$defE,$defC $addSel $color"
    } else {
       set midcom  "@@ amag $table $filter ? $optZ$optE$optC Y $defZ,$defE,$defC ? $color"
    }
     sendMidas
}
#==============================================================================

   global midcom midsess comtomid
   global table filter optZ optE optC defZ defE defC color addSel addSelFlag

   set defZ "nil"
   set defE "nil"
   set defC "nil"
   set optZ 1
   set optE 0
   set optC 0

   set filter "R"
   set table "std.tbl"

   set addSel "none"
   set addSelFlag 0

#- top menu
   frame .mbar -relief raised -bd 2 
   pack .mbar  -side top -fill x
   .mbar config -bg #7890d5

   menubutton .mbar.file -text File -underline 0 -menu .mbar.file.menu
   pack .mbar.file -side left
   .mbar.file config     -bg #7890d5

   menu .mbar.file.menu 
   .mbar.file.menu add command -label exit -command exit

   
   tk_menuBar .mbar .mbar.file
   focus .mbar



#- title
frame .amag
pack .amag

label .amag.title -text "Midas Phot: T-Mag" \
    -font -*-helvetica-*-r-*-*-18-*-*-*-*-*-*-*\
    -fg blue
pack .amag.title

#- entry

frame       .amag.table
label       .amag.table.tabtxt -text "Input table:"
entry       .amag.table.table  -textvariable table
pack .amag.table.tabtxt -side left
pack .amag.table.table -side right
pack .amag.table -fill both

frame       .amag.entry
label       .amag.entry.filtxt -text "Filter:"
radiobutton .amag.entry.u -text "U" -variable filter -value "U"
radiobutton .amag.entry.b -text "B" -variable filter -value "B"
radiobutton .amag.entry.v -text "V" -variable filter -value "V"
radiobutton .amag.entry.r -text "R" -variable filter -value "R"
radiobutton .amag.entry.i -text "I" -variable filter -value "I"
radiobutton .amag.entry.j -text "J" -variable filter -value "J"
radiobutton .amag.entry.h -text "H" -variable filter -value "H"
radiobutton .amag.entry.k -text "K" -variable filter -value "K"
pack  .amag.entry.filtxt -side left
pack  .amag.entry.k .amag.entry.h .amag.entry.j .amag.entry.i .amag.entry.r .amag.entry.v .amag.entry.b .amag.entry.u  -side right
pack .amag.entry -fill both

#- method

frame  .amag.param
label .amag.param.mettxt -text "Method:"
checkbutton .amag.param.z -text "ZP" -variable optZ
checkbutton .amag.param.e -text "Extn" -variable optE
checkbutton .amag.param.c -text "Color" -variable optC
pack .amag.param.mettxt -side left
pack .amag.param.c .amag.param.e .amag.param.z -side right
pack .amag.param -fill both


#- default values

frame .amag.def
label .amag.def.deftxt -text "Defaults:"
label .amag.def.ztxt -text "ZP="
entry .amag.def.z  -textvariable defZ -width 7
label .amag.def.etxt -text "extn="
entry .amag.def.e  -textvariable defE -width 7
label .amag.def.ctxt -text "col="
entry .amag.def.c  -textvariable defC -width 7
pack .amag.def.deftxt -side left
pack .amag.def.c  .amag.def.ctxt .amag.def.e .amag.def.etxt .amag.def.z .amag.def.ztxt -side right
pack .amag.def -fill both

#- solve

frame .amag.solve
label .amag.solve.title -text "Solve:"
button .amag.solve.reset -text "New/Reset & Solve" -command resetSolve
button .amag.solve.solve -text "Solve" -command solve
checkbutton .amag.solve.addselflag -text "Add.Select.:" -variable addSelFlag
entry .amag.solve.addsel -textvariable addSel -width 10
pack .amag.solve.title -side left
pack  .amag.solve.solve .amag.solve.addsel .amag.solve.addselflag .amag.solve.reset -side right
pack .amag.solve -fill both


frame .amag.plot
label .amag.plot.title  -text "Plot:" 
button .amag.plot.all    -text "All" -command {set midcom "@@ amag_plot $table $filter A"; sendMidas}
button .amag.plot.stdmag -text "Std.Mag" -command {set midcom "@@ amag_plot $table $filter F :stdmag"; sendMidas}
button .amag.plot.stdcol -text "Color" -command {set midcom "@@ amag_plot $table $filter F :stdcol"; sendMidas}
button .amag.plot.airm   -text "Airm" -command {set midcom "@@ amag_plot $table $filter F :airm"; sendMidas}
button .amag.plot.epoch  -text "Epoch" -command {set midcom "@@ amag_plot $table $filter F :epoch"; sendMidas}
button .amag.plot.xcen   -text "X" -command {set midcom "@@ amag_plot $table $filter F :xcen"; sendMidas}
button .amag.plot.ycen   -text "Y" -command {set midcom "@@ amag_plot $table $filter F :ycen"; sendMidas}
pack .amag.plot.title -side left
pack      .amag.plot.ycen .amag.plot.xcen .amag.plot.airm  .amag.plot.epoch .amag.plot.stdcol .amag.plot.stdmag .amag.plot.all -side right
pack .amag.plot -fill both

frame .amag.edit
label .amag.edit.title -text "Edit:"
button .amag.edit.ident -text "Ident. 1 pt" -command {set midcom "@@ amag_edit $table N"; sendMidas}
button .amag.edit.editu -text "UnDel. 1 pt" -command {set midcom "@@ amag_edit $table U"; sendMidas}
button .amag.edit.edit -text "Del. 1 pt" -command {set midcom "@@ amag_edit $table D"; sendMidas}
button .amag.edit.killu -text "UnDel. region" -command {set midcom "@@ amag_kill $table U"; sendMidas}
button .amag.edit.kill -text "Del. region" -command {set midcom "@@ amag_kill $table D"; sendMidas}
pack .amag.edit.title -side left
pack .amag.edit.ident .amag.edit.edit .amag.edit.kill -side right
pack .amag.edit -fill both

frame .amag.com
entry .amag.com.com -width 60 -textvariable midcom
pack .amag.com.com -side right 
pack .amag.com -fill both

#---




