# PURPOSE:      calChecker configuration file for long-term (maintenance/technical) calibrations 
# AUTHOR:       Reinhard Hanuschik, ESO-DFO
# MAINTAINER:   <your name>
# INSTRUMENT:   GIRAFFE
# VERSION:      1.0 -- May 2009
# NOTE:		This file is called ..._classification.h for convenience only; it does not come
#		in OCA syntax but in simple DFOS syntax.

# ===========================================================================================
# 1. Classification of technical calibrations
# We grep for the defined pattern in the daily raw data reports (see below)
# name: 	free tag to define type of calibration (single word, must be unique!)
# 		name = HRULER (no further fields): get a horizontal ruler in the result table, for better overview
# validity:	in days, follows the definition in the calibration plan
# rule:		use '&' for AND and "...|..." for OR ):
# 		e.g.:	I_spec&FLAT	means 'find entries with "I_spec" AND "FLAT"'
# 		    ARC&"543.3|881.7" 	means 'find entries with "ARC" AND ("543.3" OR "881.7") '
# description:	free text to clearly describe (to PSO) what data this are; to be enclosed by &&...&&

##TECHNICAL	name		VAL	rule				description
# ===========================================================================================
#TECHNICAL      DETECTOR_MON    30 	CALIB&LAMP,FLAT,DETCHECK&64	&&detector monitoring template&&
#TECHNICAL      DARK    	30 	CALIB&DARK&3			&&monthly set of 3 darks, 3600 sec each&&
#TECHNICAL      ARGUS_STD_EFFIC 30 	CALIB&STD,OzPoz&Argus&H651.5B	&&efficiency monitoring; STD,OzPoz in six settings&&
#TECHNICAL	HRULER
#TECHNICAL      ARGUS_HC_ARCLAMP    7 	CALIB&LAMP,WAVE&Argus&H525.8B	&&HC for ARCLAMP (Argus fibres); DPR.TYPE=LAMP,WAVE INS.EXP.MODE=H525.8B&&
#TECHNICAL      IFU1_HC_ARCLAMP     7  	CALIB&LAMP,WAVE&IFU1&H525.8B	&&HC for ARCLAMP (IFU1 fibres); DPR.TYPE=LAMP,WAVE INS.EXP.MODE=H525.8B&&
#TECHNICAL      IFU2_HC_ARCLAMP     7  	CALIB&LAMP,WAVE&IFU2&H525.8B	&&HC for ARCLAMP (IFU2 fibres); DPR.TYPE=LAMP,WAVE INS.EXP.MODE=H525.8B&&
##TECHNICAL      Medusa1_HC_LAMP  3  	CALIB&LAMP,WAVE&Medusa1&H525.8B	&&HC for Medusa1 fibre system; DPR.TYPE=LAMP,WAVE INS.EXP.MODE=H525.8B&&
##TECHNICAL      Medusa2_HC_LAMP  3  	CALIB&LAMP,WAVE&Medusa2&H525.8B	&&HC for Medusa2 fibre system; DPR.TYPE=LAMP,WAVE INS.EXP.MODE=H525.8B&&

#TECHNICAL      ARGUS_HC_FFLAMP    7 	CALIB&LAMP,FLAT&Argus&L543.1	&&HC for FLATLAMP (Argus fibres); DPR.TYPE=LAMP,FLAT INS.EXP.MODE=L543.1&&
#TECHNICAL      IFU1_HC_FFLAMP     7  	CALIB&LAMP,FLAT&IFU1&L543.1	&&HC for FLATLAMP (IFU1 fibres); DPR.TYPE=LAMP,FLAT INS.EXP.MODE=L543.1&&
#TECHNICAL      IFU2_HC_FFLAMP     7  	CALIB&LAMP,FLAT&IFU2&L543.1	&&HC for FLATLAMP (IFU2 fibres); DPR.TYPE=LAMP,FLAT INS.EXP.MODE=L543.1&&

##TECHNICAL	HRULER

##TECHNICAL      SIMLAMP_TEST 	 2  	CALIB&LAMP,HAL&Medusa1&H525.8B &&dummy entry for testing&&
# ===========================================================================================

# Flagging: if last entry in data reports is found to be 
#	less than $AGE1 old: 	 green
# 	between $AGE1 and $AGE2: yellow
#	more than $AGE2 old:	 red
# AGE1 = VAL-30%
# AGE2 = VAL+30%
