NAME    
	ingestProducts - ingest product files into archive

SYNOPSIS
	ingestProducts -d <DATE> [-m <MODE>] [-option_value]

OPTIONS
        -h 	short help
	-v	tool version
	-f	call fitsverify and exit
	-U	ingest updated products (for PHOENIX IDPs only)

PARAMETERS
	-m 	<MODE>:       CALIB or SCIENCE
        -d 	<DATE>:       DFO date (e.g. 2004-07-30)

CONFIGURATION FILE
        - $DFO_CONFIG_DIR/config.ingestProducts

NOTES
	The tool ingests product files into the archive (NGAS). 
	MODE=CALIB: product files in $DFO_CAL_DIR/<DATE> 
	MODE=SCIENCE: nothing for normal DFOS
	            product files in $DFO_SCI_DIR/<DATE> for PHOENIX   

	The PRO.CATG values of the ingested files can be specified with the configuration file.
	The option '-f' can be called to identify mcalibs with fitsverify issues. Those pro.catg's
	need a pipeline ticket to get fixed. 

EXAMPLES
        ingestProducts -d 2005-11-27 -m CALIB
        ingestProducts -d 2013-11-27 -m SCIENCE (with PHOENIX enabled system only)
	ingestProducts -d 2015-03-07 -m CALIB -f (call fitsverify and exit)

