NAME
	phoenix - process science data

SYNOPSIS
	phoenix -d <date> 	process all ABs from specified date
	phoenix -m <month>	process all ABs from specified month
	phoenix -r <run_ID>	process all ABs from specified run (DEEP mode)

OPTIONS
	-h[elp] 	short help
	-v[ersion] 	version
    switches:
	-C		prepare ABs but do not execute
	-P		prepare and process ABs but do not move
	-M		move already processed ABs and finish (complement to -P)
    further options:
	-n		no clean-up done upon move (-M): useful for setting up a new system
	-p		process only part of the available ABs (the ones configured under SETUP) 
	-x		no clean-up of \$DFO_AB_DIR/HISTO: useful for MCALIB mode
	-X		call the tool in MCALIB mode (requires additional configuration)
	-a		process only the specified AB (only in DEEP mode)

PARAMETERS
	-d[ate]  <DATE>:  format YYYY-MM-DD
	-m[onth] <MONTH>: format YYYY-MM
	-r[un]   <RUNID>: e.g. 094.D-0116B, no brackets
	-a[b]	 <AB>:    deep AB name (extension dpc)

INPUTS
	normal mode: pre-existing SCIENCE ABs (mild modifications can be done with pgi) if before 2020-12-01 
		     after 2020-12-01: no such input, SCIENCE ABs get created (if no reprocessing project, otherwise that
		     date has no relevance

OUTPUTS
	full processing (not possible for MUSE): all fits files, logs, QC plots
	renamed and stored under $DFO_SCI_DIR (or $DFO_CAL_DIR for MCALIB projects)/$DFO_LOG_DIR/$DFO_PLT_DIR 
	ready for IDP or MCALIB ingestion
   steps:
	-C: prepare ABs - download from qcweb source, massage (if pgi configured), prepare the job files
	-P: same, plus execution of AB and QC jobs; stop with products in $DFS_PRODUCT
	-M: move products from $DFS_PRODUCT to $DFO_SCI_DIR and finish 
	no step: full chain (-P and -M in one go)

	-X: can be combined with any of [-C|-P|-M] and needs to be called by month.

	-p: same as above, for a filtered subset of ABs; the difference is then: no updated statistics, no storage of cascadeMonitor
	    that option can be combined with any of -C|-P|-M

	LOG, STATs

WORKFLOW
	Directories are divided by $RELEASE which is configured in config.phoenix .
	Normal mode (SCIENCE):
	a) before 2020-12-01: SCIENCE ABs are downloaded from qcweb; filtering is applied if configured (for setups, raw_types);
           after 2020-12-01: SCIENCE ABs get created;
	b) createJob is called, with two cascades: SCIENCE and QCSCIENCE (requires parallel executable QC jobs); -C stops here
	c) both cascades are executed; -P stops here; before execution, a rawDownload and an mcalibDownload file are executed
	d) if configured, certification is called, then moveP (-M enters here); products are renamed; standard distribution 
	   of logs and plots; export to qcweb
	e) finishNight to cleanup; call phoenixMonitor 

	MCALIB mode:
	a) CALIB ABs are created, with local OCA rules; filtering is applied if configured (for setups, raw_types);
	b) createJob is called, with two cascades: CALIB and QCCALIB (requires parallel executable QC jobs); -C stops here
	c) both cascades are executed; -P stops here; before execution, a set of rawDownload files is executed
	d) moveP is called (-M enters here); products are renamed; standard distribution of logs and plots; export to qcweb
	e) finishNight to cleanup; call phoenixMonitor 

	If option -p is set, there are no updated statistics, and no storage of cascadeMonitor.

	Basic statistics are stored in PHOENIX_DAILY_<release>. Tool logs are in $DFO_MON_DIR/AUTODAILY. Process status is on the histoMonitor.

CONFIGURATION FILE
	config.phoenix
	- MCAL_CONFIG: marks an MCALIB project, points to special config file config.phoenix_mcal
	- DEEP_CONFIG: marks a DEEP project, points to special config file config.phoenix_deep

EXAMPLES: a) IDP
	phoenix -d 2008-03-02 	 process all configured SCIENCE ABs for that date
	phoenix -d 2008-03-02 -p process all configured SCIENCE ABs for that date, but no statistics update (to avoid spoiling of existing stats)
	phoenix -m 2008-03	 do the same for the whole month
	phoenix -m 2008-03 -C 	 prepare ABs for processing (flags -C|-P are propagated to dates)
	phoenix -d 2011-12-12 -P prepare and execute ABs incl. QC reports 
	phoenix -d 2011-12-12 -M distribute IDPs to final directories, prepare ingestion
	phoenix -d 2015-12-12 -M -n 
				 same, but without cleaning up the MCAL directories (not to be used in operations)
	b) MCALIB
	phoenix -m 2008-02 -X	 full MCALIB production for one month
	phoenix -m 2008-02 -X -C [-x] prepare all ABs and jobs for one month, MCALIB mode (-x: keep content of \$DFO_AB_DIR/HISTO)
	phoenix -m 2008-02 -X -P [-x] prepare and execute ABs incl. QC reports, MCALIB mode (-x: keep content of \$DFO_AB_DIR/HISTO)
	phoenix -m 2008-02 -X -M distribute MCALIBs to final directories, prepare ingestion
	phoenix -d 2008-02-01 -X same, but only for that date, exceptional

	c) DEEP
	phoenix -r 094.D-0116B -C	prepare all ABs and jobs for this run, DEEP mode
	phoenix -r 094.D-0116B -P	prepare and execute ABs incl. QC reports, DEEP mode
	phoenix -r 094.D-0116B -M	review results, distribute IDPs to final directories, prepare ingestion
	phoenix -r 094.D-0116B -a MUSE.2014-09-26T04:36:11.913_dpc.ab [-C|-P]
					work on the specified AB only (IDP for this target only)
	
