! DOCU_NAME     bias.prg 
! 
! DOCU_VERSION	1.0 -- adapted from UVES (May 2003) <br>
! DOCU_VERSION	1.1 -- P3 replaced by DISPLAY variable Y/N (2006-04-18)
!
! DOCU_SYNTAX	MIDAS
!
! DOCU_RAWTYPE	BIAS
! 
! DOCU_CALL     processQC -a ab_name
! 
! DOCU_PURPOSE  compares raw and product BIAS files 
! DOCU_PURPOSE  for FLAMES/GIRAFFE QC assessment; the plots are later reviewed
! DOCU_PURPOSE	within certifyProducts. The first plot (bias1.gif) is stored
! DOCU_PURPOSE	in $DFO_PLT_DIR.
! 
! DOCU_PROCINPUT first raw BIAS from AB; MASTER_BIAS product; <br>
! DOCU_PROCINPUT BAD_PIXEL_MAP
!
! DOCU_QC1TABLE giraffe_bias
! 
! DOCU_TRENDPLOT trend_report_BIAS_HC.html
! DOCU_TRENDPLOT ../FULL/trend_report_BIASFULL.html
!
! DOCU_QC1PAGE  bias_qc1.html
!
! DOCU_QC1PLOTS	NAME	bias1.gif
! DOCU_QC1PLOTS	DESCR	bias1.gif	<b>box1:</b> comparison master (red) <-> raw (black); 
! DOCU_QC1PLOTS	DESCR	bias1.gif	upper panel: middle row and middle column, full pixel range, in ADU;
! DOCU_QC1PLOTS	DESCR	bias1.gif	lower panel: middle row and middle column, central 100 pixels, in ADU <br>
! DOCU_QC1PLOTS	DESCR	bias1.gif	<b>box 2:</b> structure description; all columns (top) and all rows (bottom) are collapsed and displayed; <br>
! DOCU_QC1PLOTS	DESCR	bias1.gif	<b>box 3:</b> histogram: all pixel values in log frequency histogram; raw: black, master: red (note: was the other way round before 2009-07-21); there should be a dominant peak with Gaussian shape (which translates to parabola shape in this log freq diagram), and the parabola for the master should be narrower than the one for the raw file.<br>
! DOCU_QC1PLOTS	DESCR	bias1.gif	<b>top panel:</b> name of analyzed master bias frame<br>
! DOCU_QC1PLOTS	DESCR	bias1.gif	<b>bottom panel:</b> some QC1 parameters (median_master; raw RON, master RON, expected RON=raw/sqrt(5), structure parameters)<br>
! 
! DOCU_QC1PLOTS	NAME	bias2.png
! DOCU_QC1PLOTS	DESCR	bias2.png	full display of raw frame (box: area to be displayed in bias4.png)<br>
! DOCU_QC1PLOTS	NAME	bias3.png
! DOCU_QC1PLOTS	DESCR	bias3.png	full display of master frame (box: area to be displayed in bias5.png)<br>
! DOCU_QC1PLOTS	NAME	bias4.png
! DOCU_QC1PLOTS	DESCR	bias4.png	closeup display of raw frame (box: 100x100 pixel window used to derive RON)<br>
! DOCU_QC1PLOTS	NAME	bias5.png
! DOCU_QC1PLOTS	DESCR	bias5.png	closeup display of master frame (box: 100x100 pixel window used to derive RON)<br>
! 
! DOCU_QC1PARAM QC1 parameters written into QC1 table:<br>
! DOCU_QC1PARAM	<b>QC1db names</b>: datancom | median_master | sigma_raw | sigma_master | struct_row | struct_col <br>
! DOCU_QC1PARAM	<b>FITS key names</b>: DATANCOM | (bias.prg) | OUT1.RON.RAW | OUT1.RON.MASTER | (bias.prg) | (bias.prg) <br>
! DOCU_QC1PARAM QC1 params created by pipeline: all <br>
!
! DOCU_ALGORITHM Description of algorithms:<br>
! DOCU_ALGORITHM <b>sigma_master:</b> statistics (std_dev) in central window X1024..1124, Y1998..2098 (MIDAS: stat/ima, bins=1, outputr(4)) <br>
! DOCU_ALGORITHM <b>sigma_raw:</b> statistics (std_dev) in central window X1024..1124, Y1998..2098 (MIDAS: stat/ima, bins=1, outputr(4))  <br>
! DOCU_ALGORITHM <b>median_master:</b> statistics (median) of full frame (MIDAS: stat/ima, bins=0.1, exc=100,300) <br>
! DOCU_ALGORITHM <b>struct_row/col:</b> average/row or col; statistics with exc=mean+/-2 ADU; struct_row/col is the std_dev 
! 
! DOCU_CERTIF	Reasons for rejection:<br> - unusually high bias level or RON level (unless representative); <br>
! DOCU_CERTIF	- unusual structure (compare panel 2 plots with older/reference version);<br>
! DOCU_CERTIF	- non-Gaussian shape of histogram;<br>
! DOCU_CERTIF	- DATANCOM lower than usual (5), especially if N=5 version nearby in time<br>
! DOCU_CERTIF	The closeup displays are useful to check for patterns (pick noise) which should not be there.
!
! DOCU_COMMENTS Some QC parameters are calculated by the pipeline.<br>
! DOCU_COMMENTS  All pipeline-provided QC1 parameters are documented in the pipeline users manual (as of issue 2, 2007-12-28)

! ----------------------------------------------------------------

set/midas f_update=no   !to avoid overwriting of FITS headers by MIDAS
dfo/on
!reset/disp >/dev/null
init/display p5=RGB
load/lut heat

write/out " "
write/out "==================================================="
write/out "BIAS QC checks for GIRAFFE started." 
write/out " "

def/par P1 ? C/1/20 "date (e.g. 2003-05-02) ? "
def/par P2 ? C/1/40 "MASTER_BIAS file (e.g. r.GIRAF.2003-04-15T01:39:35.555_tpl_0000.fits ) ?"
def/par P3 N C/1/1  "Display graphics (Y/N) ?"

write/out "Date: {P1}"
write/out "File: {P2}"
write/out "Display graphics: {P3}"
write/out "==================================================="
write/out " "

del/disp >null
del/graphic >null

$echo $DFO_TREND_DIR | write/key TREND_DIR/c/1/40
$echo $DFO_RAW_DIR   | write/key RAW_DIR/c/1/40 
$echo $DFO_PROC_DIR  | write/key PROG_DIR/c/1/40 	
$echo $TMP_DIR       | write/key TMP_DIR/c/1/30

write/key raw1/c/1/50
write/key help/c/1/50

def/loc LL/i/1/1
def/loc qc1_ingest/c/1/40 	qc1_bias.dat

def/loc mean_master/r/1/1
def/loc median_master/r/1/1
def/loc upper_master/r/1/1 0.
def/loc lower_master/r/1/1 0.
def/loc upper_master1/r/1/1 0.
def/loc lower_master1/r/1/1 0.

def/loc mean_raw/r/1/1
def/loc mode_raw/r/1/1
def/loc upper_raw/r/1/1 0.
def/loc lower_raw/r/1/1 0.

def/loc bpm_file/c/1/50		!name of badpix file
def/loc bpm_npix/i/1/1		!number of bad pixels
def/loc RON_MASTER_EXP/r/1/1
def/loc min/r/1/1
def/loc max/r/1/1

write/key STRUCTX/r/1/1
write/key STRUCTY/r/1/1
write/key DATANCOM/I/1/1

! ========================================================================
! --- Initialize
! ========================================================================

set/format I1 F6.3

! find first raw file, indisk
@@ {PROG_DIR}/gen_qc.prg,INI BIAS {P2} {P1}
write/descr raw1.bdf START 1,1

write/out " "
write/out "-- indisking MASTER_BIAS file ..."
indisk/mfits {P2} >null
$mv toto0001.bdf mbias.bdf

! get parameters from FITS header
set/midas output=yes
$ {PROG_DIR}/qc1_reader.sh {P2} 
@@ tmp_get_key.prg

$echo {P2} | sed "s/0000.fits/0001.fits/" | write/key bpm_file
$echo "`dfits {bpm_file} | fitsort -d pro.bpm.npix` -999" | awk '{print $2}' | write/key bpm_npix
set/midas output=no

! creating collapsed files for structure analysis
average/row avg_row = mbias
average/col avg_col = mbias

! turned off 2008-04-02: provided by giraf 2.5.1
! calculating STRUCTX, STRUCTY: we restrict somewhat the range to avoid the bad column
! dominating the value; 2 is about 2x the sigma
!stat/ima avg_col
!min = outputr(3)-2
!max = outputr(3)+2
!stat/ima avg_col exc={min},{max}
!STRUCTY = outputr(4)

!stat/ima avg_row
!min = outputr(3)-2
!max = outputr(3)+2
!stat/ima avg_row exc={min},{max}
!STRUCTX = outputr(4)

! ========================================================================
! ------------ displays ------------------
! ========================================================================

stat/ima {P2} + bins=.1 exc=100,300
mean_master = outputr(3)
upper_master = mean_master+5
lower_master = mean_master-5
median_master = outputr(8)

stat/ima raw1.bdf + bins=1 exc=100,300
mean_raw = outputr(3)
upper_raw = mean_raw+5
lower_raw = mean_raw-5

stat/ima raw1 [@{CENTX1},@{CENTY1}:@{CENTX2},@{CENTY2}] bins=1 exc=100,300
RON_MASTER_EXP = RON_RAW/m$sqrt(5)

if P3 .eq. "N" then
	goto GRAPHICS
endif

@@ {PROG_DIR}/gen_qc.prg,DISPLAY1 {lower_raw} {upper_raw} BIAS

set/midas output=no
copy/disp postscript prflag=N,S prmode=PC8NZP
$mv screen*.ima {P2}_1.ima

! load master_bias (same ranges as raw1 for better comparison)
@@ {PROG_DIR}/gen_qc.prg,DISPLAY5 {lower_raw} {upper_raw} {P2}

set/midas output=no
copy/disp postscript prflag=N,S prmode=PC8NZP
$mv screen*.ima {P2}_2.ima

! load raw1 closeup
@@ {PROG_DIR}/gen_qc.prg,DISPLAY6 {lower_raw} {upper_raw} raw1

set/midas output=no
copy/disp postscript prflag=N,S prmode=PC8NZP
$mv screen*.ima {P2}_3.ima

! load master closeup
@@ {PROG_DIR}/gen_qc.prg,DISPLAY7 {lower_raw} {upper_raw} mbias

set/midas output=no
copy/disp postscript prflag=N,S prmode=PC8NZP
$mv screen*.ima {P2}_4.ima

GRAPHICS:
! ========================================================================
! --- graph: TITLE 
! ========================================================================

if P3 .eq. "Y" then
        cre/grap 0 640,430,0,800
else
        assign/grap null
endif

@@ {PROG_DIR}/gen_qc.prg,TITLE {P1} {raw1}.fits {P2} MASTER_BIAS master

! ========================================================================
! --- boxes
! ========================================================================

write/out " "
write/out "-- Boxes ..."
write/out "   1. First raw file and mbias (marked by red line in DISPLAY1)"
set/midas output=no

! plot middle row (raw1)
upper_raw = mean_raw*1.1
lower_raw = mean_raw/1.1

set/grap xaxis=-50,2250 yaxis={lower_raw},{upper_raw}
set/grap xform=auto yform=auto color=1 font=1

over/axes ? ? -40,-35,15,65 " " "ADU"
over/row raw1 @{YHALF}
set/grap color=2
over/row mbias @{YHALF}
set/grap color=1

label/grap "1. comparison master <-> raw" 0,38,mm ? 1.5 1
label/grap "middle row" 10,32,mm ? 1.2 1

! middle column
set/grap yform=none color=1
set/grap xaxis=-50,4200
over/axes ? ? -40,-35,55,65 " " ""
label/grap "middle mcol" 10,32,mm ? 1.2 1
over/col raw1 @{XHALF}
set/grap color=2
over/col mbias @{XHALF}
set/grap color=1

! plot lower row
set/grap yform=auto xaxis={CENTX1},{CENTX2},50,10
over/axes ? ? -40,-35,15,25 "X" "ADU"
set/grap color=1
over/row raw1 @{YHALF}
set/grap color=2
over/row mbias @{YHALF}
set/grap color=1
label/grap "expansion in X" 5,32,mm ? 1.3 1

set/grap yform=none xaxis={CENTY1},{CENTY2},50,10
over/axes ? ? -40,-35,55,25 "Y" ""
set/grap color=1
over/col raw1 @{XHALF}
set/grap color=2
over/col mbias @{XHALF}
set/grap color=1
label/grap "expansion in Y" 5,32,mm ? 1.3 1

! ========================================================================
! --- 2. structure / collapse
! ========================================================================

set/midas output=y
write/out " "
write/out "   2. Structure"
set/midas output=no

upper_raw = mean_raw*1.02
lower_raw = mean_raw/1.02

set/grap xaxis=-50,2250 yaxis={lower_raw},{upper_raw} color=1 yform=auto
over/axes ? ? -35,-35,105,65 " " " "

over avg_row
label/grap "2. structure (mast)" -6,38,mm ? 1.5 1
label/grap "row: X" 20,32,mm ? 1.5 1

set/grap xaxis=-50,4200
over/axes ? ? -35,-35,105,25 "Y" ""
over avg_col
label/grap "col: Y" 20,32,mm ? 1.5 1

! ========================================================================
! --- 3. Histogram
! ========================================================================

set/midas output=y
write/out " "
write/out "   3. Histogram"
set/midas output=no

upper_raw = mean_raw*1.2
lower_raw = mean_raw/1.2
set/grap yform=auto xaxis={lower_raw},{upper_raw},20,10 yaxis=0,7
over/axes ? ? -31,-35,153,65 "px values" "log freq"

stat/ima raw1 + bins=1.2 exc={lower_raw},{upper_raw}
set/grap color=1
over/histo raw1 ? ? LOG
set/grap color=2
over/histo mbias ? ? LOG
set/grap color=1
label/grap "3. histogram" 0,38,mm ? 1.5 1

! ========================================================================
! --- output on plot -------------------------------------------
! ========================================================================

set/midas output=y

! dummy plot to set origin to left corner
set/grap color=0
over/axes ? ? -32,-5,5,9 "Y" " "
set/grap color=1
set/format J1 T6.1

label/grap "no. raw files: {DATANCOM}"  0,3,mm ? 2.5 1
label/grap "median_m: {median_master}"  0,-1,mm ? 2.5 1
label/grap "bpm_npix: {bpm_npix}"       0,-4,mm ? 2.5 1
over/line 1 40,5,mm 40,-7,mm

set/format J1 T6.3
label/grap "read noise: [ADU]"  45,3,mm ? 2.5 1
label/grap "raw:"               45,-1,mm ? 2.3 1
label/grap "master:"            45,-4,mm ? 2.3 1
label/grap "exp:"               45,-7,mm ? 2.3 1
label/grap "{RON_RAW}"          62,-1,mm ? 2.3 1
label/grap "{RON_MASTER}"       62,-4,mm ? 2.3 1
label/grap "{RON_MASTER_EXP}"   62,-7,mm ? 2.3 1
over/line 1 82,5,mm 82,-7,mm

label/grap "structure:"         85,3,mm ? 2.5 1
label/grap "row:"               85,-1,mm ? 2.5 1
label/grap "col:"               85,-5,mm ? 2.5 1
label/grap "{STRUCTX}"          95,-1,mm ? 2.5 1
label/grap "{STRUCTY}"          95,-5,mm ? 2.5 1
over/line 1 110,5,mm 110,-7,mm

! ========================================================================
! --- insert into QC1 database
! ========================================================================

set/midas output=yes
set/format F13.7
write/out "qc1Ingest " >hilf
write/out "-table giraffe_bias -pipefile {PIPEFILE} " >>hilf
write/out "-arcfile {ARCFILE} -origfile {ORIGFILE} -mjd_obs {MJD} -tpl_start {TPL_START} " >>hilf
set/format I1 F7.3
write/out "-civil_date {P1} -datancom {DATANCOM} " >>hilf
write/out "-median_master {median_master} " >>hilf
write/out "-sigma_raw {RON_RAW} -sigma_master {RON_MASTER} " >>hilf
write/out "-struct_row {STRUCTX} -struct_col {STRUCTY} " >>hilf
write/out "-bpm_npix {bpm_npix} -det_read_speed {READ_SPEED} " >>hilf
$tr -d "\n" <hilf | $sed "s/^.*/&\&/" | $tr "&" "\n" >hilf2
$sed "s/-999[0-9.]*/NULL/g" hilf2 | $sed "s/Norm/norm/" >{TMP_DIR}/qc1Ingest.sh
$chmod 700 {TMP_DIR}/qc1Ingest.sh
${TMP_DIR}/qc1Ingest.sh
$cat {TMP_DIR}/qc1Ingest.sh >> {TREND_DIR}/{qc1_ingest}

set/midas output=no
set/format I1 F5.3

! ========================================================================
! --- store .plt file, prepare for printing
! ========================================================================

if P3 .eq. "Y" then
        copy/grap postscript
        $mv postscript.ps {P2}.ps
        $mv graph_wnd0*.plt {P2}.plt
        $convert -rotate 90 {P2}.ps {P2}.gif
else
        $mv postscript.ps test.ps
        $mv null*.plt {P2}.plt
        $convert -rotate 90 {P2}.ps {P2}.gif
endif

! ========================================================================
! --- clean up and end
! ========================================================================

$rm -f *bdf tmp_get_key* Mid* hilf hilf2 null screen* *tbl *bdf *cat
bye
