NAME    
	productExplorer - explore the calib database for data products

SYNOPSIS
	productExplorer [option_value]

OPTIONS
        -h[elp]    short help
        -v[ersion] tool version

PARAMETERS
	-d[ate] <DATE>	: e.g. 2007-10-15 (dfos convention)
	-D[ate] <DATE2>	: second DATE (optional, to span a time range)
	-i[nstr]	: instrument (optional, default: $DFO_INSTRUMENT)
	-p[ro_catg]	: pro_catg (optional, default: any)
	-s[etup]	: setup string (optional, default: any]

	-S[tatic_mode]	: searches for static calibration, only in connection with -p 

OUTPUTS
	$DFO_MON_DIR/productExplorer.html; 
	download file $TMP_DIR/mcalibDownload, deletion file $TMP_DIR/mcalibDelete

CONFIGURATION FILE
	NONE

EXAMPLES
        productExplorer -d 2007-10-15	displays all products for that date and $DFO_INSTRUMENT
	productExplorer -d 2007-10-15 -D 2007-10-17
					same, time range as specified
	productExplorer -d 2007-10-15 -i ISAAC
					all products for that date and ISAAC
	productExplorer -d 2007-10-15 -p MASTER_BIAS
					all MASTER_BIAS frames 
	productExplorer -d 2007-10-15 -s U_BESSEL
					all products with this string in their filename (setup part)
	productExplorer -S -p FLUX_STANDARDS
					displays all static mcalibs with pro.catg FLUX_STANDARDS 

NOTES
	You can launch downloads using ngasClient with the download file. These files will download into
	$DFO_CAL_DIR/DOWNLOADS.
	You can edit $TMP_DIR/mcalibDelete to delete product files by invoking dpDelete.
	Toggle between 'Hide/Display VIRTUAL'.
	Read 'info for static files' if you have used option -S. For this option, you must choose a pro.catg since the database doesn't know what a static file is.
