#! /opt/python/bin/python
# PURPOSE:  Massage <INST>.RLS file into createCalibMap compatible format
# AUTHOR:  John Pritchard, ESO-DMO
# VERSION:  1.0 -- Oct 2011: first release including
#           1.1 -- Oct 2011: Added -v & -h command line options
#	    1.1.1- new path to python under SL63 (2014-03-11)
# PARAMETERS:  none
# OPTIONS:     none
# COMMENTS:    the tool works on stdout

_VERSION_ = "1.1.1"

# =====================================================================================
# 0. initialization
# 0.1 import modules
# =====================================================================================

import logging
import sys
import os

# =====================================================================================
# 0.2 parse options
# =====================================================================================

## See http://docs.python.org/library/getopt.html
import getopt

# =====================================================================================
# 0.3 usage
# =====================================================================================
def usage():
    execName=os.path.basename(sys.argv[0])
    print('NAME')
    print('        %s - Massage OCA rules into createCalibMap friendly format.' %(execName))
    print('\nSYNOPSIS')
    print('        <commands> | %s > <INST>.RLS' %(execName))
    print('\nOPTIONS')
    print('        -h: short help')
    print('        -v: tool version')
    print('\nPARAMETERS')
    print('        None')
    print('\nOUTPUTS')
    print('        Output written to stdout.')
    print('\nCONFIGURATION FILE')
    print('        None')
    print('\nEXAMPLE')
    print('        gcc -E "${DFO_INSTRUMENT}.h" | grep -v "^#" | grep -v "^$" | dfosRLSmassage.py > ${DFO_INSTRUMENT}.RLS')
    print('\nNOTES') 
    print('        This script is normally used embedded in the compilation line of the')
    print('        <INST>_<OCA>.h files into the <INST>.RLS file within createAB and')
    print('        createCalibMap.')


# =====================================================================================
# 0.4 version
# =====================================================================================
def printVersion():
    print('%s' %(str(_VERSION_)))

# =====================================================================================
# 1.0 Massage
# =====================================================================================
def main():
  try:
    opts, args = getopt.getopt(sys.argv[1:], "hv", ["help", "version="])
  except getopt.GetoptError, err:
    # print help information and exit:
    print str(err) # will print something like "option -a not recognized"
    usage()
    sys.exit(2)
  output = None
  verbose = False
  for o, a in opts:
    if o == "-v":
      printVersion()
      sys.exit()
    elif o in ("-h", "--help"):
      usage()
      sys.exit()
    else:
      assert False, "unhandled option"

  IF_STR = "if"
  IF_OPEN = "{"
  IF_CLOSE = "}"
  ACTION_STR = "action"
  ACTION_OPEN = "{"
  ACTION_CLOSE = "}"
  ACTION_SELECT_STR = "select"
  ACTION_SELECT_CLOSE = ";"

  in_if=False
  in_action=False
  in_action_select=False
  w_nline=True
  for line in sys.stdin:
    w_nline=True
    if line.strip()[0:len(IF_STR)] == IF_STR :
      in_if=True
      nline=line.strip()
      in_if1st=True
    if line.strip()[0:len(ACTION_STR)] == ACTION_STR :
      in_action=True
      nline=line.strip()
      in_action1st=True
      actionStarted=False
      nACTION_OPENs = line.count(ACTION_OPEN) - line.count(ACTION_CLOSE)

    if in_if :
## In a classification IF...      
      if line.rfind(IF_OPEN) >= 0:
        if not in_if1st :
          nline=nline + ' ' + line[0:line.rfind(IF_OPEN)].strip() + '\n' + line[line.rfind(IF_OPEN):].rstrip()
        in_if=False
      else:
        if not in_if1st :
          nline=nline+' '+line.strip()
        w_nline=False
      in_if1st=False

    elif in_action :
## In an association ACTION...
      if line.count(ACTION_OPEN) > 0 :
        actionStarted=True
      nACTION_OPENs = nACTION_OPENs + line.count(ACTION_OPEN) - line.count(ACTION_CLOSE)
      if line.strip().find(ACTION_SELECT_STR) >= 0 :
        in_action_select=True
        nline=line.rstrip()
        w_nline=False
        in_action_select1st=True
      if in_action_select :
## In the SELECT section of an association action...
        if line.find(ACTION_SELECT_CLOSE) >= 0:
          if not in_action_select1st :
            if not line.strip()[0:len(ACTION_SELECT_CLOSE)] == ACTION_SELECT_CLOSE :
              nline=nline + ' ' + line[0:line.find(ACTION_SELECT_CLOSE)-1].strip()
            nline=nline + '\n' + '  ' + line[line.find(ACTION_SELECT_CLOSE):].rstrip()
          in_action_select=False
          w_nline=True
        else:
          if not in_action_select1st :
            nline=nline+' '+line.strip()
            w_nline=False
        in_action_select1st=False
      else:
        if actionStarted and nACTION_OPENs == 0 :
          in_action=False
          if line[0:1] == ACTION_CLOSE :
            nline=line.rstrip()
          else:
            nline=nline + ' ' + line[0:line.find(ACTION_CLOSE)-1].strip() + '\n' + ACTION_CLOSE + '\n' + line[line.find(ACTION_CLOSE):]
        else:
          nline=line.rstrip()
      in_action1st=False
    else:
      nline=line
      
    if w_nline :
      print nline.rstrip()

if __name__ == "__main__":
    main()

