NAME    
	verifyAB - verify validity of SCIENCE ABs for Raw2Master calSelector associations
		   testing associations with local or database OCA rules

SYNOPSIS
	verifyAB -d <date> [-P] | [-option_value] | -f <file>|CONFIG|LIST [-l <filelist> [-o <OCA RLS file> [-i [-D]]]

OPTIONS
        -h 	this help
	-v	tool version

	-H	calSelector help
	-V	calSelector version
	-D	calSelector running in debug mode
	-R	force calSelector to Raw2Raw mode
	-i 	ignore_certified: tool ignores 'certified' flag when in R2R mode
	-M	do not replace M. names with ORIGFILE names in XML and TXT output

PARAMETERS
a) Verify mode: verify validity of SCIENCE ABs for date
   [possible parameters: -d -P -D -R]
	-d <date> [-P [-D] -R]
		   check calSelector associations against ABs, for all
	           science ABs for that date; -P: do this for ABs in $DFO_AB_DIR

b) Test mode: test associations and run regression tests, with local or database OCA rules;
   check the results in $DFO_AB_DIR/CALSELECTOR/SDIFF.html. 
   [possible parameters: -f -l -o -D -R -i]

        -f <dp_id> [-o <OCA RLS file> [-i [-D] | -R ]]
        -f CONFIG [-o <OCA RLS file> [-i [-D] -R ]]
        -f LIST -l <filelist> [-o <OCA RLS file> [-i [-D] | -R ]]

        -f <dp_id>: enter raw dp_id (ARCFILE) and compare AB and calSelector associations

        -f CONFIG: get dp_id from the config file \$DFO_CONFIG_DIR/CALSELECTOR/config.calselManager;
                   dialog for dp_id selection

        -f LIST -l <pathname of filelist>
                   calSelector associations on specified filelist for regression tests;
                   all dp_ids are exposed to the OCA rules in a loop

        -o <pathname to OCA RLS file>
                   use specified local OCA file instead of database OCA file (optional, for testing)

CONFIGURATION FILE
        - $DFO_CONFIG_DIR/CALSELECTOR/CSConfiguration.properties
	- $DFO_CONFIG_DIR/CALSELECTOR/config.verifyAB (optional)

NOTES
	The tool combines routine verification of science ABs in the DFOS workflow, and the
	verification of CALSELECTOR OCA rules by exposing them to reference/test ABs. 

EXAMPLES
        verifyAB -d 2011-11-27	verify all science ABs for that date (in $DFO_LOG_DIR)
        verifyAB -d 2011-11-27 -R
				same, force calSelector to Raw2Raw mode
	verifyAB -d 2014-12-12 -P
				same, ABs in $DFO_AB_DIR

	verifyAB -f GIRAF.2004-04-02T07:37:51.890
				verify the associations for that dp_id
	verifyAB -f GIRAF.2004-04-02T07:37:51.890 -R
				same, for Raw2Raw mode
	verifyAB -f CONFIG	start a dialog and select reference dp_id for verification
	verifyAB -f LIST -l $CONFIG_DIR/CALSELECTOR/2008-04-01/reference_file_list.txt
				verify all dp_ids in the specified filelist in a loop
	verifyAB -f GIRAF.2004-04-02T07:37:51.890 -o $DFO_CONFIG_DIR/CALSELECTOR/2008-04-01/OCA_modified.RLS
				verify that dp_id using a local OCA ruleset
	verifyAB -f GIRAF.2004-04-02T07:37:51.890 -i
				verify that dp_id; if incomplete, the tool is free to associate raw files ignoring the certified flag
	verifyAB -f GIRAF.2004-04-02T07:37:51.890 -D
				verify that dp_id with calSelector running in DEBUG mode 
