# configuration for qc_mstplt.py
# INSTRUMENT	VIMOS
# RAW_TYPE	BIAS
# RAW_MATCH_KEY	DET.READ.CLOCK=225kHz,1port,LG
# new detectors, July 2010

# to access environment variables within this configuration module:
import os

#########################################################################
# 1. data type, format
#########################################################################

# PRO.CATG of master frame
# needed to idenfiy the master frame and to distiguish it from other pipeline product
# from the same AB
catg_master = 'MASTER_BIAS'

# allowed extension numbers
# list here the extensions in the raw frames you want to display, qc_mstplt.py loops over them;
# extension number 0 refers to the primary header unit;
# e.g. VIMOS: allow_ext = ( 0, )
# e.g. KMOS: allow_ext = ( 1, 2, 3 )
allow_ext = ( 0, )

# optional: map extension in raw frames to extensions in products
# this is only relevant if products contain data extensions and additional extensions;
# KMOS:
# allow_ext = ( 1, 3, 5 )
# VIMOS:
# raw_to_pro_ext = ( 0, )
# if not set, qc_mstplt.py assumes raw_to_pro_ext == allow_ext

# center rows/columns (first row/column is 0)
# used by qc_mstplt.py to plot cuts through raw/master frames
centcol, centrow = 1023, 1023

# center range for expansion plots (first row/column is 0)
# used to enlarge the central area in separate plots
xcentrange = (974, 1074)
ycentrange = (974, 1074)

# area definition for histogram statistics
# define the whole frame or any subframe
stat_xrange = (0,2048)
stat_yrange = (0,2440)

#########################################################################
# 2. information to be printed in figure head
#########################################################################

# plot type, e.g. BIAS, DARK, LAMP_FLAT, ...
# this text is written as info in the upper left part of each plot
plot_type = 'BIAS'

# list of parameters to be written in second line of plot header
# (keyname, header_key)
#parameters = []	# empty list
parameters = [('CLOCK', 'HIERARCH ESO DET READ CLOCK'), 
	      ('QUAD', 'HIERARCH ESO OCS CON QUAD') ]

#########################################################################
# 3. manipulate raw/master frames before plotting
#########################################################################

# pre and over scan
# these are chopped from the raw frames before plotting them
prescan = 50
overscan = 50

# user-defined function to normalise master and reference frames;
# this function returns the data part without any change
def norm_mst(fitsHDU, ext=0):
	return fitsHDU[ext].data

# this function multiplies the data part (image) with the DIT
#def norm_mst(fitsHDU, ext=0):
#	dit = fitsHDU[ext].header['HIERARCH ESO DET DIT']
#	return dit * fitsHDU[ext].data

# user-defined function to normalise raw frames
def norm_raw(fitsHDU, ext=0):
	return fitsHDU[ext].data

# if raw data are cubes, one plane of the cube can be chosen
#def norm_raw(fitsHDU, ext=0):
#	return fitsHDU[ext].data[0,:,:]

#########################################################################
# 4. reference frames
#########################################################################

# directory for reference frames
# this directory must exist but can be empty
cal_dir = os.environ.get('DFO_CAL_DIR')
ref_dir = cal_dir + '/REF_FRAMES'
#ref_dir = '/data24/vimos/calib/REF_FRAMES'

# method for comparison of master with reference
# can be 'div' or 'sub'
comp_method = 'sub'

# start of file names of reference frames
ref_root_name = 'VI_MBIA'

# match keys for finding match between recent product and reference
ref_match_keys = ('HIERARCH ESO OCS CON QUAD', 'HIERARCH ESO DET READ CLOCK')

#########################################################################
# 5. define what is plotted by qc_mstplt
#########################################################################

# Plot 1: cut in x direction
# All supported data types: plot1_data = ('first_raw', 'last_raw', 'master', 'reference')
plot1_data = ('first_raw', 'master')

# only master:
#plot1_data = ('master',)

# To overwrite default scaling of y axis use e.g. plot1_yrange = (100,200)
plot1_yrange = ()

# Plot 2: cut in y direction
plot2_data = ('first_raw', 'master')
plot2_yrange = ()

# Plot 3: histogram of raw/master
# Possible values: ('first_raw'|'last_raw'|'master', 'fit'|'nofit')
plot3_data = [ ('master', 'nofit'),
	       ('master', 'fit'),
	       ('first_raw', 'nofit') ]

# logarithmic y axis: True|False
histo_log = True

# x axis scaling is defined via multiple of the stddev of the input image; define multiple here
histo_range = 5.0
# step size of binning; to overwrite default insert a value > 0 here
histo_step = 1.0
#histo_step = 10  # automated binning

# Plot 4: cut in x direction using xcentrange
# same syntax as for Plot 1/2, choices can be different
plot4_data = ('first_raw', 'master')
plot4_yrange = ()

# Plot 5: cut in y direction using ycentrange
plot5_data = ('first_raw', 'master')
plot5_yrange = ()

# Plot 6: either averages of columns and rows
#         or (new with v2.0) 2D image
# plot6_type = 'col_row_avg' | 'image'
# if plot6_type is 'image':
# 	plot6_data = 'first_raw' | 'last_raw' | 'master' | 'reference'
#	# display full frame or only central part (as defined with xcentrange, ycentrange):
#	plot6_area = 'full' | 'centre'
#	# cut values for image:
#	plot6_cuts = ()		# set cuts to min/max of image
#	plot6_cuts = (2,)	# set cuts to avg +/- 2 * sigma
#	plot6_cuts = (0,1)	# lower cut = 0, upper = 1
#	# recommended as default: plot6_cuts = (1,)
plot6_type = 'image'
plot6_data = 'master'
plot6_area = 'full'
plot6_cuts = (198,200)

# Plots 7-9: pre-defined, only created if reference frame is found
#            master vs. reference: cuts and histogram

#########################################################################
# 6. OPTIONAL: overwrite default colour definitions
#########################################################################

# colour definitions
#col_raw1 = '0.00'               # 1st raw frame
#col_raw2 = '0.40'               # last raw frame
#col_mst = 'r'                   # cuts through master frames
#col_ref = 'g'                   # reference frame
#col_histo = 'g'                 # histogram fit
#col_row = (0.00, 0.00, 1.00)    # row average
#col_col = (0.00, 0.50, 1.00)    # column average

#########################################################################
# 7. special configuration for qc_genplt.py
#########################################################################

# Plot 1/2: cuts in x/y direction
#plot12_config=[('raw', 0, '1st raw', '0.00'), ('pro', 'MASTER_BIAS', 'master', 'r'), ('ref', 'MASTER_BIAS', 'reference', 'g')]
plot12_config=[('raw', 1, '2nd raw', '0.00'), ('pro', 'MASTER_BIAS', 'master', 'r'), ('ref', 'MASTER_BIAS', 'reference', 'g')]

# Plot 3: histogram
#plot3_config=[('raw', 0, 'raw', '0.00'), ('pro', 'MASTER_BIAS', 'mst', 'r'), ('profit', 'MASTER_BIAS', 'mst fit', 'g')]
plot3_config=[('raw', 1, 'raw', '0.00'), ('pro', 'MASTER_BIAS', 'mst', 'r'), ('profit', 'MASTER_BIAS', 'mst fit', 'g')]

# Plot 4/5: cuts in x/y direction of central area
#plot45_config=[('raw', 0, '1st raw', '0.00'), ('pro', 'MASTER_BIAS', 'master', 'r'), ('ref', 'MASTER_BIAS', 'reference', 'g')]
plot45_config=[('raw', 1, '2nd raw', '0.00'), ('pro', 'MASTER_BIAS', 'master', 'r'), ('ref', 'MASTER_BIAS', 'reference', 'g')]

# Plot 6: averages of columns and rows
plot6_config=[('pro', 'MASTER_BIAS', 'mst', '0.00')]

