subroutine crosssec
	use constants
	use parameter
	implicit none
	real*8,external	:: qcontpah
        integer,external :: Cmax

        real*8    :: wabsgr(mml) =0 
        real*8    :: qabsgr(mml)=0 

	real*8,allocatable	:: qamrn_ac(:,:)	!2dim array cross section absorption carbon (size,wavelength)
	real*8,allocatable	:: qsmrn_ac(:,:)	!2dim array cross section scattering carbon (size,wavelength)
	real*8,allocatable	:: qamrn_si(:,:)	!2dim array cross section absorption silicate (size,wavelength)
	real*8,allocatable	:: qsmrn_si(:,:)	!2dim array cross section scattering silicate (size,wavelength)

	real*8,allocatable	:: qamrn_gr(:,:)	!2dim array cross section absorption graphite (size,wavelength)
	real*8,allocatable	:: qsmrn_gr(:,:)	!2dim array cross section scattering graphite (size,wavelength)

	real*8,allocatable	:: gmrn_ac(:,:)	!2dim array g-factor carbon (size,wavelength)
	real*8,allocatable	:: gmrn_si(:,:)	!2dim array g-factor silicate (size,wavelength)
	real*8,allocatable	:: gmrn_gr(:,:)	!2dim array g-factor graphite (size,wavelength)
	real*8,allocatable 	:: ahc(:)		!array number grains carbon in interval [a(l),a(l+1)]
	real*8,allocatable 	:: ahsi(:)		!array number grains silicate in interval [a(l),a(l+1)]
	real*8	:: w_mie		! .. where Mie  becomes inaccurate
	real*8 	:: e_mie		! .. where Mie  becomes inaccurate
	real*8	:: en1C
	real*8 	:: en1SI
	real*8	:: bpl
	real*8	:: dbpldt
	real*8	:: gam_res(nuib)
	real*8	:: area_res(nuib)
	real*8	:: s_res(nuib)
	real*8	:: wel_pah(nuib)
	real*8	:: fr_pah(nuib)
	real*8	:: rdampf
	real*8	:: rstern
	real*8	:: Tevap, stefan
	real*8	:: welcut
	integer	:: kbump,kuv, kuvmm,kuvmml, kx
	real*8	:: qagr
	real*8	:: qagrUV
	real*8	:: qpahUV, Eo
	real*4	:: prob   ! for MRW (Robitaille Eq.24)
	integer	:: iX
	
	integer :: kjot,kblau,klyc,mmm	
	integer	:: kmrnuv
	integer	:: L		!why new runparameter ????
	real*8	:: dumm, dummc, dummsi
        character :: char
	integer	:: idum,ntt, icompute_y

	real*8	:: ddirthet
	real*8	:: fak, eismass, totmass
        real*8  :: rheis, geweis, fSiaC, volc, volsi, voleis, volvac
        real*8  :: rhp, vp, vsi, vac, vvac  ! 1gramm porous grain
!
! ================================================================
!  PAH Resonanzen
!    1    2    3    4    5    6    7    8    9   10   11  12  13  14  15  16  17
!   43   50   58   65   70   74   79   85   92   99  106 118 124 130 136 142 153
! 23.1 21.1 18.2 16.4 15.7 15.1 14.3 13.6 12.7 12.0 11.3 8.6 7.7 7.0 6.2 5.2 3.3

      data wel_pah / 23.09d-4,  21.09d-4,  18.19d-4, 16.5d-4,   &
     &                15.7d-4,  15.09d-4,  14.29d-4, 13.59d-4,  &
     &                12.7d-4,  11.95d-4,  11.28d-4,  8.59d-4, 7.7d-4, &
     &                 7.0d-4,    6.2d-4,   5.1d-4,   3.3d-4, 2.175d-5  /
     
! original parameters for N1808 as in AA377, 735 2001
      data gam_res /  3.0D12,  3D12,  3d12,  3.d12,        &
     &                2.0d12,  3d12,  5d12,  4d12,         &
     &                3.5d12,  7d12,  4d12,  6d12,  22d12, &
     &                5.9d12, 14d12, 12d12, 20d12, 1.8d15 /

      data area_res / 2.0d-26, 2.0d-26, 1.0d-26,  0.5d-26, &
     &                0.3d-26, 0.3d-26, 0.9d-26,  3.7d-26, &
     &                2.8d-25, 1.2d-25, 3.6d-25,  3.5d-25, 5.5d-25, &
     &                1.25d-25, 2.1d-25, 1.1d-26, 1.2d-25, 8d-23 /
!
! ISM setting: A&A 561, A82 (2014)
!      data gam_res /  10.0D12,  10D12,  10d12,  10.d12,  
!     &                5.0d12,  4d12,  5d12,  4d12, 
!     &                3.5d12,  7d12,  4d12,  6d12,  22d12, 
!     &                5.9d12, 14d12, 20d12, 20d12, 1.8d15 / 
!      data area_res / 2.0d-26, 2.0d-26, 3.0d-26, 5d-26, 
!     &                0.3d-26, 0.3d-26, 0.9d-26, 3.7d-26, 
!     &                2.8d-25, 1.2d-25, 5.2d-25,  3.5d-25, 5.5d-25, 
!     &                1.25d-25, 1.5d-25, 1.1d-26, 0.925d-25, 8d-23 /
!   ---------------------------------------------------------------------------
!
      if(jgas .eq. 1)   then
         write(6,*) ' ---------------------------------- '
         write(6,*) ' Reading gas crosssection'
         write(6,*) ' ---------------------------------- '
         open(unit=33, file='input/d.qGas', form='formatted')
         rewind 33
         do k=1,4
            read(33,*)
         enddo
         do k=1,mgas
            read(33,*),wel_gas(k),dumm,dumm,dumm,dumm,dumm,dumm,&
  &                   dumm,dumm,K_gas(k)
!           convert micron to cm
            wel_gas(k) = wel_gas(k)*1e-4
         enddo
         close(33)
      endif

!
! -------------------------------------------------------
!  Einlesen der Q's (von Qext.f) fuer Radien amrn(L) fuer aC und Si.
!  Es wird Qsca = Qsca * (1 - g) gesetzt und dann isotrope Streuung
!  angenommen.

        if (input%structure.eq.4.or. input%structure.eq.7.or.jmrn.eq.1) then
           jmrn = 1 
           write(6,*) ' --------------------------------- '
           print*,    '  *** Fluffy grains  ***'
        endif

!
         if(jmrn .eq. 2) then
            jmrn = 0
           print*, ' reset jmrn=0 reading efficiencies form file d.q.aCSiGr'
           print*, ' (for the moment just for Peter, to be modified later)'
         end if

!
! -------------------
!
           if (jmrn .eq. 0) then
! obsolete:  open(unit=3, file='input/d.q.lang.stp', form='formatted')
             write(6,*) ' ---------------------------------- '
             write(6,*) ' *** Staub eff. von d.q.aCSiGr'
             open(unit=3, file='input/d.q.aCSiGr', form='formatted')
             mm = mml
             lr = lrl
           end if
          if(jmrn .eq. 1) then
            write(6,*) '  *** Staub eff. von  d.qXreal '
 	    open(unit=3, file='input/d.qXreal', form='formatted')
            mm = mmr
            lr = lrr
           end if

         if(jmrn .eq. 3) then
            write(6,*) ' ---------------------------------- '
            write(6,*) '                  zur Zeit auch von    d.q.gra '
	    open(unit=3, file='input/d.q.gra', form='formatted')
            mm = mmg
            lr = lrl
           if(jpah .ne.0) stop ' ** requires interpolation of qamrn_gr '
         end if

         if (jmrn .eq. 4) then
            write(6,*) ' ---------------------------------- '
            write(6,*) '  TESTING ENDRIKS CROSS-SECTIONS    '
            mm = 3066
            lr = 1
           open(unit=3, file='input/DustProp.out', form='formatted')
           if(jpah .ne.0) stop ' ** requires interpolation of qamrn_gr '
       endif


             allocate(K_abs_si(mm))
             allocate(K_sca_si(mm))
             allocate(K_abs_ac(mm))
             allocate(K_sca_ac(mm))
             allocate(K_abs_pah(mm))
       	     allocate(qamrn_ac(lr,mm))
             allocate(qsmrn_ac(lr,mm))
             allocate(qamrn_si(lr,mm))
             allocate(qsmrn_si(lr,mm))
             allocate(qamrn_gr(lr,mm))
             allocate(qsmrn_gr(lr,mm))
             allocate(gmrn_ac(lr,mm))
             allocate(gmrn_si(lr,mm))
             allocate(gmrn_gr(lr,mm))
             allocate(qpah(mm))
             allocate(welmrn(mm))
             allocate(frmrn(mm))
             allocate(fr3mrn(mm))
             allocate(dfrmrn(mm))
             allocate(amrn(lr))
             allocate(ahc(lr))
             allocate(ahsi(lr))
             allocate(g_ac_mrn(mm))
             allocate(g_si_mrn(mm))
             K_abs_si = 0d0
             K_sca_si = 0d0
             K_abs_ac = 0d0
             K_sca_ac = 0d0
             qamrn_ac = 0d0
             qsmrn_ac = 0d0
             qamrn_si = 0d0
             qsmrn_si = 0d0
             qamrn_gr = 0d0
             qsmrn_gr = 0d0
             gmrn_ac  = 0d0
             gmrn_si  = 0d0
             gmrn_gr  = 0d0
             qpah     = 0d0
             welmrn   = 0d0
             frmrn    = 0d0
             fr3mrn   = 0d0
             dfrmrn   = 0d0
             amrn     = 0d0
             ahc      = 0d0
             ahsi     = 0d0
             g_ac_mrn = 0d0
             g_si_mrn = 0d0

! ----------------------------------------------
!  d.q.aCSiGr:
! 
    if(jmrn .eq.0) then
      rewind 3
      read(3,*)  mmm, ntt
      read(3,*)  (amrn(L), L=1,lr)
      if(mmm .ne. mm)  then 
            print*, '  mm   = ', mm
            print*, ' mmm  = ', mmm
            stop 'mm .ne. mmm'
      endif
      if  (ntt .ne. lr) then 
            print*, '  lr   = ', lr
            print*, '  ntt  = ', ntt
           stop ' change parameter lr=ntt'
      endif
      do  70  L = 1, lr
        do  k = 1, mm
        read(3,*) welmrn(k), dumm, qamrn_ac(L,k), qsmrn_ac(L,k), &
&   gmrn_ac(L,k), qamrn_si(L,k), qsmrn_si(L,k), gmrn_si(L,k),    &
&   qamrn_gr(L,k), qsmrn_gr(L,k), gmrn_gr(l,k)
        end do
   70 continue

       wabsgr      = welmrn
        do  k      = 1, mm
         qabsgr(k) = qamrn_gr(1,k)
       end do

       call locat(wabsgr, mm, 0.55d-4, kvis)
       print*, ' *** Test d.qXaCSiGr: wabsgr(kvis) = 0.55d-4 ?', welmrn(kvis), kvis

    endif
! ----------------------------------------------
!  d.qReal:
! 
      if(jmrn .eq. 1) then
      read(3,*)  mmm, ntt
      if(mmm .ne. mm)  then 
            print*, '  mm   = ', mm
            print*, ' mmm  = ', mmm
            stop 'mm .ne. mmm'
      endif
      if  (ntt .ne. lr) then 
            print*, '  lr   = ', lr
            print*, '  ntt  = ', ntt
           stop ' change parameter lr=ntt'
      endif
          read(3,*)  rheis, dummc, dummsi, dumm, dumm,geweis, fSiaC
          if(rhsi.ne.dummsi .or.rhc.ne.dummc) then
           print*, 'rhc,rhsi in parameter file not the same as in d.q file'
           print*, ' change rhc, rhsi accodringly'
                                                 stop
          endif 
         read(3,*)  volc, volsi, voleis, volvac
         write(6,*) '      relative Volumenanteile von : aC, Si, Eis, Vac, tot'
         write(6,'(1x,5f10.2)') volc, volsi, voleis, volvac, &
&                            volc+ volsi+ voleis+ volvac

         read(3,*)  (amrn(L), L=1,lr)
         if (ntt .ne. lr) stop
         if (mmm .ne. mm) stop

         do   L = 1, lr
          do  k = 1, mm
            read(3,*) welmrn(k),dumm,qamrn_ac(L,k),qsmrn_ac(L,k),gmrn_ac(L,k)
                      qamrn_si(L,k) = 0d0 
                      qsmrn_si(L,k) = 0d0
                      gmrn_si(L,k) = 1.
         end do
         end do
       call locat(welmrn, mm, 0.55d-4, kvis)
!    print*, ' *** Test d.qXreal: welmrn(kvis) = 0.55d-4 ?', welmrn(kvis), kvis
!
!  relative weights  in 1g Staub: aC, Si, Eis'
!   fSiaC  = simass / acmass (cosmic abundance: 1.41 .. 1.8)
!   geweis = Masse(Eis) / Masse(aC+Si)  = 1d-6 (hier ohne Eis)
!   volvac = Volumenanteil des Vakuum bezogen auf gesamt Volumen (from input) 
!   Volume of porous Grain of mass mp= 1 [gramm-dust]: Vp = Vsi+Vc+Vvac. 
!   Mean density of porous dust grain in 1 gramm of mass is : 
!   rhp = mp/Vp = 1g/vp and  mp = acmass + simass
!
        totmass = (abuc*wmolc + abusi*wmolsi)  * (1. + geweis)  + abuc*wmolc*abuvsg 

        aCmass  = abuc   * wmolc  / totmass
        Simass  = abusi  * wmolsi / totmass
        Eismass = geweis * (acmass + simass) 
        vsgmass = abuc*wmolc* abuvsg/totmass
        totmass = acmass+simass+eismass+vsgmass
        if(totmass .ne. 1 ) then
         write(6,'(a40,1f7.2)') '*** relative must be =1  but     totmass = ', totmass
         stop
        endif

        if (voleis .ne.0)  stop ' not checked yet'

        if (abs (fsiaC - (simass/acmass)) .ge. 0.1 .and. iblack.ne.1) then 
         write(6,*) ' Check fSiaC '
         write(6,'(1p5e10.2)') fsiaC, (simass/acmass), simass, acmass, totmass
         stop
        endif

        VaC  = acmass/rhc
        VSi  = Simass/rhsi
        Vvac = volvac/(1-volvac) * (VaC + VSi)
        Vp   = Vac+ VSi + Vvac
        rhp     = (acmass+ simass)/ Vp   ! density of porous grain


        print*, '      In 1 gramm of dust there is: '
        print*, '      totmass  [1gr-Dust]: acmass, simass, vsgmass, pahmass'
        write(6,'(23x,1p4e10.2)') acmass, simass, vsgmass, pahmass
        print*, '      Volume fraction of: Vporous, Vac, VSi, Vvac '
        write(6,'(23x,1p4e10.2)') Vp, Vac, VSi, Vvac
        write(6,'(a30, f7.2)') '       Density of porous grain = ', rhp

!  Einlesen von graphite Qabs (qabsgr) and interpolate to welmrn of
!  fluffy grains. This is required for PAH cross sections below UV

      open(unit=30, file='input/d.q.aCSiGr', form='formatted')
      rewind 30
      read(30,*)  mmm, ntt
      read(30,*)  (dumm, L=1,lrl)
      if(mmm .ne. mml)  then 
            print*, ' mml   = ', mml
            print*, ' mmm  = ', mmm
            stop 'mmm .ne. mml'
      endif
      if  (ntt .ne. lrl) then 
            print*, '  lrl   = ', lrl
            print*, '  ntt  = ', ntt
           stop ' change parameter lr=ntt'
      endif


        do  k = 1, mml
        read(30,*) wabsgr(k), dumm, dumm, dumm, dumm, dumm, dumm, dumm, &
&              qabsgr(k), dumm, dumm       
        end do
      close(30)




!     interpolate qabsgr to MRN wavelength grid  of fluffy particles
       do k = 1, mm
        call locat(wabsgr,mml,welmrn(k),j)
        if(j .ge. 1)   then
          fak  = (1/welmrn(k) - 1/wabsgr(j)) / (1/wabsgr(j+1) - 1/wabsgr(j))
          qamrn_gr(1,k) = qabsgr(j)+(qabsgr(j+1) - qabsgr(j))*fak
       else
          qamrn_gr(1,k) = 0
        endif
       end do
!      interpol:ok
!      write(36,'(1p2e11.3)') (wabsgr(k), qabsgr(k), k=1,mml)
!      write(37,'(1p2e11.3)') (welmrn(k), qamrn_gr(1,k), k=1,mm)
      endif      ! end reading composite grains
! ----------------------------------------------
!  Just for TESTING EFFECTIVE OPTICAL DEPTH W/ ENDRIK'S CROSS-SECTIONS!
if (jmrn .eq. 4) then

!open (unit=3, file=input/dustprop.out, form=formatted)
read(3,*) char,char,char,char,char,char,char!,dumm,dumm,dumm,dumm,dumm,dumm
do k=1,mm !loop over file reading cross-sections
   read(3,*) dumm,welmrn(k),qsmrn_ac(1,k),K_abs_ac(k),K_sca_ac(k),g_ac_mrn(k),dumm,dumm
enddo
        close (unit=3)

 welmrn = welmrn * 1d-4
 K_sca_ac = K_sca_ac*1d-4
 K_sca_ac = K_sca_ac * qsmrn_ac(1,:)
 g_ac_mrn = g_ac_mrn * 1d-3
 qsmrn_ac=0d0
 K_abs_si = 0d0
 K_sca_si = 0d0
 gmrn_ac = 1d0
 gmrn_si = 1d0
 g_si_mrn = 1d0
 qamrn_si = 0d0
 qsmrn_si = 0d0
 g_si_mrn = 1d0
 qpah = 0d0
 K_abs_pah = 0d0
end if

!
! ==============================================================
! reduction of scattering by g faktor: this reduction effectively
! ignores forward scattered component, leaving only the isotropic part
! of scattering. Therefore, it is not appropriate when treating
! anisotropic scattering.
      do  k = 1, mm
       frmrn(k)  = clicht / welmrn(k)
       fr3mrn(k) = frmrn(k)**3
      if (i_iso .eq. 0) then 
       do  L = 1, lr
         qsmrn_ac(L,k) = (1d0 - gmrn_ac(L,k)) * qsmrn_ac(L,k)
         qsmrn_si(L,k) = (1d0 - gmrn_si(L,k)) * qsmrn_si(L,k)
       end do
      endif
      end do


      if(iblack .eq. 1)   then
      print *, '  ***   iblack=1  Q_sca = 0,  Qabs = 1   ***'
      do  L = 1, lr
      do  k = 1, mm
       if(wel(k) .le. wel(kvis)) qamrn_ac(L,k)  = 1d0
       if(wel(k) .ge. wel(kvis)) qamrn_ac(L,k)  = wel(kvis)/wel(k)
       if(wel(k) .le. wel(kvis)) qamrn_si(L,k)  = 1d0
       if(wel(k) .ge. wel(kvis)) qamrn_si(L,k)  = wel(kvis)/wel(k)
       qsmrn_ac(L,k)  = 0.
       qsmrn_si(L,k)  = 0.
       gmrn_ac(L,k)  = 1.
       gmrn_si(L,k)  = 1.
      end do
      end do
      end if

      do  k = 2, mm-1
      dfrmrn(k)  = 5d-1 * (frmrn(k+1) - frmrn(k-1))
      end do
      dfrmrn(1)  = 5d-1 * (frmrn(2)  - frmrn(1))
      dfrmrn(mm) = 5d-1 * (frmrn(mm) - frmrn(mm-1))

!   ---------------------------------------------------------------------------
! reduction of grain absorbtion efficiencies as calculated by Mie
! similar to Fig.5 of Smith and Dwek (97). Grain of radius arad and
! photon energie E > E_mie (keV) =>  qpah reduced ~1/fr.
!
if (jmrn .ne. 4) then
      do  l   = 1, lr
        arad  = amrn(l)
         if(arad .le.  10d-8)                        E_mie = 0.1
         if(arad .le.  50d-8 .and. arad .gt. 10d-8)  E_mie = 0.4 
         if(arad .le. 300d-8 .and. arad .gt. 50d-8)  E_mie = 1.
         if(arad .le. 1d-5   .and. arad .gt. 300d-8) E_mie = 2.
         if(arad .le. 2d-5   .and. arad .gt. 1d-5)   E_mie = 4.
         if(arad .le. 1d-4   .and. arad .gt. 2d-5)   E_mie = 7.
         if(arad .gt. 1d-4)  E_mie = 10.
         w_mie = clicht/(1d3*E_mie*eVolt/hwirk)
         if (welmrn(mm) .le. 100d-8) then
         if (l .eq. 1) then
          print*, ' *** Reduction of abs efficiencies ~1/nu for wel < 136AA' 
          print*, '  arad      w_mie      welmrn(iX)     iX '
         end if
         call locat(welmrn, mm, w_mie, iX)
!	iX=5
         if (l .eq. 1 .or. l .eq. lr) &
&          write(*,'(3ES10.2E1, I11)') arad, w_mie, welmrn(iX), iX
         do  k = 1, mm
          if(welmrn(k) .le. welmrn(iX)) then
           qamrn_ac(l,k) = qamrn_ac(l,k) * welmrn(k)/welmrn(iX)
           qamrn_si(l,k) = qamrn_si(l,k) * welmrn(k)/welmrn(iX)
          end if
         end do  
         end if
         end do  



!      print*, amrn(5), '  Q_test.tab'
!      open(unit=16, file='Q_test.tab', form='formatted')
!      do  k = 1, mm
!       write(16,'(1p3e10.2)') welmrn(k), qamrn_ac(5,k), qamrn_si(5,k)
!      end do 
!      close(16)
!  
!   ahc(L) = geom. Querschnitt aller C-Koerner pro 1 g Staub, analog ahsi(L), ahv

      print*, ' Abundance of carbon [2.4d-4] and silicon [3.1d-5]'
      write(6,'(1p2e10.2)') abuc, abusi

      en1C = 0. 
      do  L = Lac, Lec 
      en1C = en1C + amrn(L)**(3d0-qmrn)
      end do
      en1C = 3d0/pi4/rhc / en1C * aCmass


      en1Si = 0.
      do  L = Lasi, Lesi 
      en1Si = en1Si + amrn(L)**(3d0-qmrn)
      end do
      en1Si = 3d0/pi4/rhsi / en1Si * Simass

! --- fluffy grains

      if (jmrn .eq.1) then 
          en1Si  = 0.d0
          en1C = 0. 
          do  L = Lac, Lec 
          en1C = en1C + amrn(L)**(3d0-qmrn)
          end do
          en1C = 3d0/pi4/rhp / en1C   *totmass

! test:    print*, ' *** Reset for composite rgains: '
!          print*, '  en1C, en1si, rhsi, acmass, Simass'
!          print*, en1C, en1si, rhp, acmass, Simass
      endif

!
! a2 for geometrical cross section and qrmn already reduced by 1 above
! n(a) da = a^-(qmrn) da. 

      do  L = Lac, Lec
      ahc(L) = en1C * pi * amrn(L)**(2d0-qmrn)
      if(ibug.eq.1) print*, 'ahc =', ahc(l), amrn(l), en1C
      end do

      do  L = Lasi, Lesi
      ahsi(L) = en1Si * pi * amrn(L)**(2d0-qmrn)
      end do

!   ---------------------------------------------------------------------------
!   Massenkoeff [cm^2 pro g Staub] für Freq frmrn(k) aus d.q.lang.stp   
!   K_abs_ac(k) = Abs-Querschnitt [cm**2] aller C-Körner pro g Staub (aC+Si)
!   also average g factor over grain distributon.

      g_ac_mrn = 0.
      g_si_mrn = 0.
      do  k = 1, mm
        K_abs_ac(k) = 0.
        K_sca_ac(k) = 0.
        do  L = Lac, Lec
        K_abs_ac(k) = K_abs_ac(k) + ahc(L) * qamrn_ac(L,k) 
        K_sca_ac(k) = K_sca_ac(k) + ahc(L) * qsmrn_ac(L,k) 
        g_ac_mrn(k) = g_ac_mrn(k) + ahc(L) * qsmrn_ac(L,k) * gmrn_ac(L,k) !g-factor times scattering weight
        end do
        g_ac_mrn(k) = g_ac_mrn(k)/K_sca_ac(k) !divide g-factor
      end do

      do  k = 1, mm
        K_abs_si(k) = 0.
        K_sca_si(k) = 0.
        do  L = Lasi, Lesi 
        K_abs_si(k) = K_abs_si(k) + ahsi(L) * qamrn_si(L,k) 
        K_sca_si(k) = K_sca_si(k) + ahsi(L) * qsmrn_si(L,k) 
        g_si_mrn(k) = g_si_mrn(k) + ahsi(L) * qsmrn_si(L,k) * gmrn_si(L,k) !g-factor times scattering weight
        end do
        g_si_mrn(k) = g_si_mrn(k)/K_sca_si(k) !divide g-factor
      end do

if(input%structure .eq. 4 .or. input%structure .eq. 7) g_si_mrn = 1. !reset to one, overwrite NaNs from divide by zero.

      k = kvis
!      if(ibug .ge. 2) then
       write(6,*) ' welmrn_V   K_abs_ac  K_sca_ac  K_abs_si  K_sca_si  K_total'
       write(6,'(1p6e10.2)') welmrn(k), K_abs_ac(k), K_sca_ac(k), &
& K_abs_si(k), K_sca_si(k), K_abs_ac(k)+K_sca_ac(k)+K_abs_si(k)+K_sca_si(k)

!      print out extinction bezgl. frmrn
       open(unit=16, file='output/Kappa.tab', form='formatted')
       write(16,*) 'wel      K_abs_ac   K_sca_ac  K_abs_si  K_sca_si  K_tot'
       do  k = 1, mm
       write(16,'(1p6e10.2)') welmrn(k), K_abs_ac(k), K_sca_ac(k), &
& K_abs_si(k), K_sca_si(k), K_abs_ac(k)+K_sca_ac(k)+K_abs_si(k)+K_sca_si(k)
      end do 
      close(16)




!      endif

!   ---------------------------------------------------------------------------
!   Massenkoeff [cm^2 pro g Staub] fuer PAHs.  Vorbereitung

      Eo     = 5.d0
      zhpah  = hydpah * zcpah
      xatom  = zcpah + zhpah                         !Zahl der Atome in PAH 
      Ecr    = 0.1 * zcpah * Eo * eVolt
      arad   = sqrt(zcpah/1.2) * 1d-8

! New welcut folloiwng: Salama, Bakes Alamandola, Tielens, 1996, ApJ458, 621
      welcut = 1./(3.804/sqrt(0.4*zcpah) +1.) * 1d-4
      if(welcut .lt. 0.55d-4)   welcut = 0.5501d-4

      do  j = 1, nuib
      fr_pah(j)       = clicht / wel_pah(j)
      end do 

!  The following PAH bands depend on No of H atoms

      s_res( 8) = zhpah *gam_res( 8)*clicht*area_res( 8)/wel_pah( 8)**2
      s_res( 9) = zhpah *gam_res( 9)*clicht*area_res( 9)/wel_pah( 9)**2
      s_res(10) = zhpah *gam_res(10)*clicht*area_res(10)/wel_pah(10)**2
      s_res(11) = zhpah *gam_res(11)*clicht*area_res(11)/wel_pah(11)**2
      s_res(12) = zhpah *gam_res(12)*clicht*area_res(12)/wel_pah(12)**2
      s_res(14) = zhpah *gam_res(14)*clicht*area_res(14)/wel_pah(14)**2
      s_res(17) = zhpah *gam_res(17)*clicht*area_res(17)/wel_pah(17)**2 

!  The following PAH bands depend on No of C atoms

      s_res( 1) = zcpah *gam_res( 1)*clicht*area_res( 1)/wel_pah( 1)**2
      s_res( 2) = zcpah *gam_res( 2)*clicht*area_res( 2)/wel_pah( 2)**2
      s_res( 3) = zcpah *gam_res( 3)*clicht*area_res( 3)/wel_pah( 3)**2
      s_res( 4) = zcpah *gam_res( 4)*clicht*area_res( 4)/wel_pah( 4)**2
      s_res( 5) = zcpah *gam_res( 5)*clicht*area_res( 5)/wel_pah( 5)**2
      s_res( 6) = zcpah *gam_res( 6)*clicht*area_res( 6)/wel_pah( 6)**2
      s_res( 7) = zcpah *gam_res( 7)*clicht*area_res( 7)/wel_pah( 7)**2
      s_res(13) = zcpah *gam_res(13)*clicht*area_res(13)/wel_pah(13)**2
      s_res(15) = zcpah *gam_res(15)*clicht*area_res(15)/wel_pah(15)**2
      s_res(16) = zcpah *gam_res(16)*clicht*area_res(16)/wel_pah(16)**2
      s_res(18) = zcpah *gam_res(18)*clicht*area_res(18)/wel_pah(18)**2
   endif

! ------------------------------------------------
!   Interpoliere K_abs_ac(k),K_abs_si(k) mit Freqs frmrn(k) aus d.q.lang.stp
!   auf die Frequenzen fd(k) vom Staub
!   siga = abs cross section cm**2 per g of dust for frequencies fd(k) of dust
!   sigs = cross section for scattering, reduced by (1 - g)
!   sige = siga + sigs

      do  34  k = 1, nd
      call locat(frmrn, mm, fd(k), j)
      if(j .eq. mm)  then
        print*, frmrn(1), frmrn(mm),fd(k), k
        print*, welmrn(1), welmrn(mm),welmud(k), k
        stop 'Frequenzgitter fd: j=mm'  
      end if
      if(j .eq.  0)  stop 'Frequenzgitter fd: j=0'  

      if(j .ge. 1)   then
         fak         = (fd(k) - frmrn(j)) / (frmrn(j+1) - frmrn(j))
         C_abs_si(k) = K_abs_si(j) + (K_abs_si(j+1) - K_abs_si(j)) * fak
         C_sca_si(k) = K_sca_si(j) + (K_sca_si(j+1) - K_sca_si(j)) * fak
         C_abs_ac(k) = K_abs_ac(j) + (K_abs_ac(j+1) - K_abs_ac(j)) * fak
         C_sca_ac(k) = K_sca_ac(j) + (K_sca_ac(j+1) - K_sca_ac(j)) * fak
         g_ac(k)     = g_ac_mrn(j) + (g_ac_mrn(j+1) - g_ac_mrn(j)) * fak
         g_si(k)     = g_si_mrn(j) + (g_si_mrn(j+1) - g_si_mrn(j)) * fak
      else
         C_abs_si(k) = K_abs_si(j+1) * fr(k) / frmrn(j+1)
         C_sca_si(k) = K_sca_si(j+1) * fr(k) / frmrn(j+1)
         C_abs_ac(k) = K_abs_ac(j+1) * fr(k) / frmrn(j+1)
         C_sca_ac(k) = K_sca_ac(j+1) * fr(k) / frmrn(j+1)
         g_ac(k)     = g_ac_mrn(j+1) * fr(k) / frmrn(k+1)
         g_si(k)     = g_si_mrn(j+1) * fr(k) / frmrn(k+1)
      end if

      if(i_iso .eq. 2) then
         g_ac(k) = 0.
         g_si(k) = 0.
      endif
      C_ext_si(k) = C_abs_si(k) + C_sca_si(k)
      C_ext_ac(k) = C_abs_ac(k) + C_sca_ac(k)
      call locat(wel_gas,mgas,clicht/fd(k),j)
      if(j .ge. 1)   then
         fak         = (clicht/fd(k) - wel_gas(j)) / (wel_gas(j+1) - wel_gas(j))
         C_gas(k) = K_gas(j)+(K_gas(j+1) - K_gas(j))*fak
      else
         C_gas(k) = 0
      endif
! anpassung gas an Staub: Einheiten bleiben [gramm]-Staub im ISM
      C_gas(k) = c_gas(k)*1./(wmolc*abuc+wmolsi*abusi)
 34   continue

        iabs_max = Cmax(C_abs_si,C_abs_ac)

!   PAH Massenkoeff [cm^2 pro g Staub]  fr Freq fr(k) bez. Staub
      qpahUV = zcpah * C_PAH_UV / pi / arad**2
      E_mie = 100.
      w_mie = clicht/(E_mie*eVolt/hwirk)
      call locat (weld, nd, w_mie, kX)
      call locat (weld, nd, 0.167d-4, kuv)
      kuv = kuv+1
      call locat (welmrn, mm, 0.167d-4, kuvmm)
      call locat (wabsgr, mml, 0.167d-4, kuvmml)
      call locat (weld, nd, 0.2175d-4, kbump)
      kbump = kbump+1  ! fits better for jmrn=0

      fak  = ((1/0.167d-4)       - 1/wabsgr(kuvmml)) / &
&             (1/wabsgr(kuvmml+1)- 1/wabsgr(kuvmml))
      qagrUV = qabsgr(kuvmml) + (qabsgr(kuvmml+1) - qabsgr(kuvmml)) * fak


! check wavelength interpolation:
if(ibug.ge.1) then
  write(6,'(a,1p3e10.2)') 'kbump 2.175d-5 ', weld(kbump-1),weld(kbump),      &
&                                            weld(kbump+1)
  write(6,'(a,1p3e10.2)') 'weld  1.67d-5  : ', weld(kuv-1),weld(kuv),        &
&                                              weld(kuv+1)
 write(6,'(a,1p3e10.2)') 'welmrn 1.67d-5 ', welmrn(kuvmm-1), welmrn(kuvmm),  &
&                                           welmrn(kuvmm+1)
 write(6,'(a,1p3e10.2)') 'wabsgr 1.67d-5 ', wabsgr(kuvmml-1), wabsgr(kuvmml),& 
&                                           wabsgr(kuvmml+1)
  print*, ' wabsgr(kuvmml) qamrn_gr(kuvmml), qaabsgr(kuvmm+1), qagrUV '
  write(6,'(1p4e10.2)') wabsgr(kuvmml),qabsgr(kuvmml),qabsgr(kuvmml+1),qagrUV 
    endif

!   Abs coefficient per C-atom of PAH.  Eq(16), Schutte et al 1993, ApJ 415, 397
!         qpahd(k) = qpahd(k) + qcontpah(weld(k))
!   NIR continuum term for ionised particles by Mattioda et al. 2005,
!   apj 629, 1183. Assume gion=0.5

      do  k = 1, nd
          qagr     = 0.
          qpahd(k) = 0.
        if(weld(k) .ge. welcut) then
          do  j    = 1, nuib-1
          qpahd(k) = qpahd(k) + s_res(j) * fd(k)**2 /( pi**2 * &
&           (fd(k)**2 - fr_pah(j)**2)**2 + fd(k)**2 * gam_res(j)**2/4d0 )
          end do 
          qpahd(k)  = qpahd(k) +zcpah*3.5/2.*10.**(-19.-1.45*weld(k)*1d4) 
         else
! 2175 AA  bump
            j        = nuib
          qpahd(k) = qpahd(k) + s_res(j) * fd(k)**2 /( pi**2 * &
&           (fd(k)**2 - fr_pah(j)**2)**2 + fd(k)**2 * gam_res(j)**2/4d0 )

       endif

! old cross section :
! if(weld(k) .le. welcut)  qpahd(k) = qpahd(k) + zcpah * C_PAH_UV
!   UV and X-rays:  qpah ~ qac(1,k) E < 100eV


        if(weld(k) .lt. wabsgr(kuvmml)) then 
           call locat(wabsgr, mml, weld(k), j)
           if(j .eq. mml)  then
            print*, wabsgr(1), wabsgr(mm),weld(k), k
            stop 'Frequenzgitter fd: j=mm'  
           end if
           if(j .eq.  0)  stop 'Frequenzgitter fd: j=0'  
           if(j .ge. 1)   then
             fak  = (1/weld(k) - 1/wabsgr(j)) / (1/wabsgr(j+1) - 1/wabsgr(j))
             qagr = qabsgr(j) + (qabsgr(j+1) - qabsgr(j)) * fak
           else
             qagr = qabsgr(j+1) * wabsgr(j+1) / weld(k)
           end if
           qpahd(k)  = qpahd(kuv) * qagr/qagrUV
         end if
        end do 

!       write(26,*) 'weld     qgrd    qpahd '
!       write(26,'(1p3e11.3)') (weld(k), qagr, qpahd(k), k=1,nd) 

      do  k = 1, nd
         qpahd(k)      = qpahd(k) / pi / arad**2
         C_abs_pah(k)  = pi*arad**2 * qpahd(k) * pahmass/(wmolc*zcpah*protm) 
         if (jmrn .eq. 4) C_abs_pah(k)  = 0d0
        end do

! Extinctions curve bezgl. weld
      open(unit=26, file='output/L.Extin_wd', form='formatted')
      rewind(26)
       write(26,*) 'weld        C_ext_ac   C_sca_ac   g_ac     C_ext_si   C_sca_si   g_si     C_abs_pah   C_gas'
      do  k = 1, nd
       write(26,'(1p9e11.3)') weld(k), C_ext_ac(k),C_sca_ac(k),&
& g_ac(k), C_ext_si(k),C_sca_si(k),g_si(k),C_abs_pah(k),C_gas(k)
      end do
      close(26)
!
!  ----------- -------------------------------
!   Qpah bez frmrn(k) fr subroutine enth
!
      call locat (welmrn, mm, w_mie,    kX)
      call locat (welmrn, mm, 0.167d-4, kuv)
      if(welmrn(kuv) .ge.0.2d-4) kuv= kuv+1
      call locat (welmrn, mm, 0.2175d-4, kbump)
     if(ibug.ge.1) then
      print*, '  welmrn ranges:  welmrn(kbump) '
      write(6,'(19x, 1p3e11.3)') welmrn(kbump-1), welmrn(kbump), welmrn(kbump+1)
      print*, '  welmrn ranges:  welmrn(kbump) '
      write(6,'(19x, 1p3e11.3)') welmrn(kuv-1), welmrn(kuv), welmrn(kuv+1)
      print*, 'qagrUV qamrn_gr' 
      write(6,'(1p3e11.3)') qagrUV, qamrn_gr(1,kuv)
     end if
     qagrUV = qamrn_gr(1,kuv)

       do  k = 1, mm
        qpah(k) = 0.
       if(welmrn(k) .ge. welcut) then 
          do  j = 1, nuib-1
          qpah(k) = qpah(k) + s_res(j)  * frmrn(k)**2 / &
&  (pi**2 * (frmrn(k)**2-fr_pah(j)**2)**2 + frmrn(k)**2 * gam_res(j)**2/4d0)
          end do 

!         qpah(k) = qpah(k) + qcontpah(welmrn(k))
!   NIR continuum term for ionised particles by Mattioda et al. 2005,
!   apj 629, 1183. Assume gion=0.5

         qpah(k)  = qpah(k) +zcpah*3.5/2.*10.**(-19.-1.45*welmrn(k)*1d4) 

       else
! 2175 AA  bump
              j  = nuib
         qpah(k) = qpah(k) + s_res(j) * frmrn(k)**2 / ( pi**2 * (frmrn(k)**2- &
     &             frmrn(kbump)**2)**2 + frmrn(k)**2 * gam_res(j)**2/4d0)

        endif

 ! bezgl. fmrn: PAH in UV and X-rays:  qpah(k) ~ qamrn_ac(1,1)
         if(welmrn(k) .lt. welmrn(kuv)) qpah(k) = qpah(kuv) * qamrn_gr(1,k)/qamrn_gr(1,kuv)

       end do    

!       write(27,*) 'welmrn     qgr    qpah '
!       write(27,'(1p3e11.3)') (welmrn(k), qamrn_gr(1,k), qpah(k), k=1,mm)

      do  k = 1, mm
         qpah(k)      = qpah(k) / pi / arad**2
         K_abs_pah(k) = pi*arad**2 * qpah(k) * pahmass/(wmolc*zcpah*protm)
       end do    


! Extinctions curve bezgl. welmrn
      open(unit=26, file='output/L.Extin_mrn', form='formatted')
      rewind(26)
       write(26,*) 'welmrn    K_ext_ac   K_ext_si   K_abs_pah'
      do  k = 1, mm
       write(26,'(1p4e11.3)') welmrn(k), K_abs_ac(k)+K_sca_ac(k),& 
     &                                     K_abs_si(k)+K_sca_si(k), &
     &   pi*arad**2 * qpah(k) * pahmass/(wmolc*zcpah*protm)
      end do
      close(26)

      call locat(weld, nd, 5.5d-5, ivisd)
      if(abs(welmud(ivisd)-0.55) .ge. 0.01) then
        print*, "  *** Check :  welmud(ivisd) ne 0.55mic ok? ***"
        print*, "  welmud(ivisd), ivisd, +/-1"
      write(6,'(1p3e10.2)')   welmud(ivisd), welmud(ivisd+1) , welmud(ivisd-1)
      if(abs(welmud(ivisd)-0.55) .ge. abs(welmud(ivisd+1)-0.55)) ivisd=ivisd+1
      if(abs(welmud(ivisd)-0.55) .ge. abs(welmud(ivisd-1)-0.55)) ivisd=ivisd-1
      print*, " Better?: welmud(ivisd), ivisd, +/-1"
      write(6,'(1p3e10.2)')  welmud(ivisd), welmud(ivisd+1) , welmud(ivisd-1) 
       endif

      Cext_V = C_ext_si(ivisd) + C_ext_ac(ivisd) + C_abs_pah(ivisd)

      print 148, welmud(ivisd), &
&      C_abs_ac(ivisd),C_sca_ac(ivisd), C_ext_ac(ivisd), &
&      C_abs_si(ivisd), C_sca_si(ivisd), C_ext_si(ivisd),&
&      C_abs_ac(ivisd)+ C_abs_si(ivisd), C_sca_ac(ivisd)+C_sca_si(ivisd), &
&      C_ext_ac(ivisd)+ C_ext_si(ivisd),&
&      Cext_V, C_abs_pah(ivisd)
 148  format( 2x, 'Bei', f8.4, 'mu: siga, sigs, sige von aC =',  3f9.1 / &
&      35x, 'von Si =', 3f9.1 / 35x, 'von aC+Si =', 3f9.1 / &
&      35x, 'Cext   =', f9.1, 5x, 'vsg=', f9.1)
 



!   ---------------------------------------------------------------------------
!
! dust evaporation at ca.:
!
      Tevap  = 1000d0
      rdampf = sqrt(Lquelle/amrn(lasi)) * (4.d0/Tevap)**3.
      rstern = sqrt(Lquelle/Tstar**4/pi4/sigma)
!      rinner = dgw/20.
!      rinner = max(rdampf,rstar)
      print *
      print *, ' rstern,   rinner,   rdampf,   dgw/8'
      write(6,'(1p4e10.2)') rstern,  rinner, rdampf, dgw/8.
      print *,' '
!
!   ----------------------------------------------------------------------
!   Fr ntg Werte von T die Integrale:  
!   QB  = \int Q_nu B_nu(T) dnu   und   QsB  = \int Q_nu dB_nu(T)/dT dnu

      do  45 j = 1, ntg
      Td(j)    = 5d-1 * 1.02d0**(j-1)
      QBsi(j)  = 0.
      QsBsi(j) = 0.
      QBc(j)   = 0.
      QsBc(j)  = 0.
      C_planck(j) = 0    
      C_ross(j)   = 0    

      do  k    = 1, nd
      QBsi(j)  = QBsi(j)  + C_abs_si(k) *    bpl(fd(k), fd3(k), Td(j)) * dfd(k)
      QsBsi(j) = QsBsi(j) + C_abs_si(k) * dbpldt(fd(k), fd3(k), Td(j)) * dfd(k)
      QBc(j)   = QBc(j)   + C_abs_ac(k)  *    bpl(fd(k), fd3(k), Td(j)) * dfd(k)
      QsBc(j)  = QsBc(j)  + C_abs_ac(k)  * dbpldt(fd(k), fd3(k), Td(j)) * dfd(k)
      C_planck(j) = C_planck(j)+    bpl(fd(k), fd3(k), Td(j))*dfd(k) * (C_abs_ac(k) + C_abs_si(k))
      C_ross(j)   = C_ross(j)  + dbpldt(fd(k), fd3(k), Td(j))*dfd(k) / (C_ext_ac(k) + C_ext_si(k))
      end do

      stefan      = sigma/pi * Td(j)**4
      C_planck(j) =  C_planck(j)/ stefan
      C_ross(j)   = 4.d0*sigma/pi * Td(j)**3 / C_ross(j)
      if(Td(j) .lt.8.d0 .and. C_ross(j).gt.C_planck(j)) C_ross(j) = C_planck(j)
 45   continue



! Planck and Rosseland mean :
      if(ibug.eq.2) then
      open(unit=26, file='output/L.Rosseland', form='formatted')
      rewind(26)
      write(26,*) 'T    C_ross   C_planck'
      do  j = 1, ntg
       write(26,'(1p3e10.2)') Td(j), C_ross(j), C_planck(j)
      end do
      close(26)
      end if


!
! ---------------------------------------------
!

      do  46  j = 1, ntg
      sumQsBsi(j,1) =  C_abs_si(1) * dbpldt(fd(1),fd3(1),Td(j)) * dfd(1)
      sumQsBc(j,1)  =  C_abs_ac(1) * dbpldt(fd(1),fd3(1),Td(j)) * dfd(1)

      do  k = 2, nd
      fak = dbpldt(fd(k),fd3(k),Td(j))
      sumQsBsi(j,k) = sumQsBsi(j,k-1) + C_abs_si(k) * fak *dfd(k)
      sumQsBc(j,k)  = sumQsBc(j,k-1)  + C_abs_ac(k) * fak *dfd(k)
      end do
 46   continue
!
! Berechnung von y zur diffusion (Robitaille 2010, Eq.24)
!
     icompute_y = 0 
     if(icompute_y .eq. 1) then
      i=1
      prob = 0
      do while (2*prob<1.)
         prob = 0
         do k = 1,n_mrw*10
            prob = prob + (-1)**(k+1)*(i*1./10/n_mrw)**((1.*k)**2.)
         enddo
         if (int(2*prob*n_mrw).ge.1) then
            y_mrw(int(2*prob*n_mrw)) = i*1./10/n_mrw
         else
            y_mrw(1) = i*1./10/n_mrw
         endif

         i = i + 1
      end do
 
!      do k=int(prob*n_mrw),n_mrw
!         y_mrw(k) = i*1./n_mrw
!      enddo

       do k=1,n_mrw
         write(16,*)  y_mrw(k)
       enddo

      else
          open(unit=3, file='./input/yDiffEq25.tab', form='formatted')
          rewind 3
          read(3,*) char
          read(3,*) (y_mrw(i),  i=1,n_mrw)
      endif

!
! ----------
!
      if(iQuelle .eq. 0) &
     & print 140, LQuelle, int(Tstar), amrn(Lac), amrn(Lec), nf, epak
 140  format('  1. Qsca ist mit Faktor (1-g) multipliziert' /&
     & '  2. Zentralstern: L=', 1pe10.2, ', T=', i6,  / &
     & '  3. Staubradius [cm]: a-(C)=', 1pe9.2, '  a+(C)=', e9.2 / &
     & '  4. nf=', i6, ' Frequenzpakete mit konst Energie epak=', e10.3)

      if(iQuelle .eq. 1) &
     & print 141, LQuelle, specind, frmin, frmax, amrn(Lac), amrn(Lasi), nf, epak
 141  format(' ***  Qsca ist mit Faktor (1-g) multipliziert' /&
     & '  2. AGN mit L=', 1pe10.2, ' alpha=', 0pf5.2, ' Freq Bereich=', 1p2e9.2/&
     & '  3. Staubradius a(C)=', 1pe9.2, '  a(Si)=', e9.2 / &
     & '  4. nf=', i6, ' Frequenzpakete mit konst Energie epak=', e10.3)

      if(iQuelle .eq. 2) &
     & print 142, LQuelle, amrn(Lac), amrn(Lasi), nf, epak
 142  format(' ***  Qsca ist mit Faktor (1-g) multipliziert' /&
     & '  2. Beliebiges eingabe spektrum (frgrid.tab) mit L=', 1pe10.2  /&
     & '  3. Staubradius a(C)=', 1pe9.2, '  a(Si)=', e9.2 / &
     & '  4. nf=', i6, ' Frequenzpakete mit konst Energie epak=', e10.3)


!   --------------------------------------------------------------------------
      print 130, ntg, Td(1), Td(ntg)
 130  format('  5. Integrale Q*B(T), Q*dB/dT und Summe Q*dB/dT*dfr fuer' / '&
 	&     ntg =',i4, ' T-Werte zwischen', f6.1, ' und', f10.1, 'K')

      print 155, nthet
 155  format('  6. cos(theta) = 0:  Aufsicht.', i3,' Beobachtungsrichtungen mit cos(theta):')

      do  jth = 1, nthet
      ddirthet = (dirthet(jth) + dirthet(jth+1)) / 2
      print 156, ddirthet
 156  format(f20.3)
      end do

end subroutine crosssec
