
subroutine Wstaub
!
! Legt Wellenlaengen und Frequenzen bez. Staub fest  
! fd(k),    k=1,2,...,nd       
!
use constants
use parameter
	implicit none
	integer,parameter	:: jeinf=98
	integer			:: jein
	integer			:: jaus
!	integer			:: krit
	integer			:: kdrit
	integer			:: kmax
	integer			:: kd
	real*8			:: weinf(jeinf)
	real*8			:: wd(nd)
	real*8			:: dwlog
	real*8			:: w
	real*8			:: w1
	real*8			:: w2

! Einzufuegende wellenlaengen (95) im MIR in microns:
weinf =[ 200.d0, 100.d0, 60.d0,  25.0d0, &
     &  23.2d0, 23.1d0, 23.0d0, 22.0d0, 21.2d0, 21.1d0, &
     &  21.0d0, 20.0d0, 19.5d0, 19.0d0, 18.3d0,&
     &  18.2d0, 18.1d0, 16.5d0, 16.4d0, 16.3d0, 15.8d0, 15.7d0,&
     &  15.6d0, 15.2d0, 15.1d0, 15.0d0, 14.4d0, 14.3d0, 14.2d0,& 
     &  13.7d0, 13.6d0, 13.5d0, 13.0d0, 12.9d0, 12.8d0, 12.7d0,&
     &  12.1d0, 12.0d0, 11.9d0, 11.5d0, 11.4d0, 11.3d0, 11.2d0,&
     &  11.1d0, 11.0d0, 10.8d0, 10.6d0, 10.4d0, 10.2d0, 10.0d0,&
     &   9.9d0,  9.8d0,  9.7d0,  9.6d0,  9.5d0,  9.4d0,  9.2d0,&
     &   9.0d0,  8.8d0,  8.7d0,  8.6d0,  8.5d0,  8.4d0,  8.2d0,& 
     &   8.0d0,  7.9d0,  7.8d0,  7.7d0,  7.6d0,  7.5d0,  7.3d0,&
     &   7.1d0,  7.0d0,  6.9d0,  6.8d0,  6.6d0,  6.4d0,  6.3d0,&
     &   6.2d0,  6.1d0,  6.0d0,  5.8d0,  5.5d0,  5.3d0,  5.2d0,&
     &   5.1d0,  5.0d0,  4.5d0,  4.0d0,  3.5d0,  3.4d0,  3.3d0,&
     &   3.2d0,  3.1d0,  3.0d0,  2.5d0,  2.2d0,  2.0d0 ]



      do  10  k = 1,nd
       wd(k)   = 0d0
 10    end do

      do  11  k = nf,1, -1
       jd(k)    = -1
       wd(k)    = welmu(k)
 11   end do

      do  12  k = 1, jeinf
       wd(nf+k) = weinf(k)
 12   end do

! sort wel array, dann neue wel einfuegen und bei evtl.
! gleicher wellenlaengen aussortieren:
       call asort(nd,wd)
       call locat(wd, nd , 2.d0, krit)
       call locat(wd, nd, max(welmu(1),25.d0), kmax)
       kmax = kmax +1
            jaus = 0
      do 13 k = krit, kmax
         if (wd(k-1) .eq. wd(k)) then
             wd(k) = -1.
             jaus = jaus + 1 
          end if
 13    end do
      jein =  jeinf - jaus
      print*, ' Im MIR wurden ', jein, ' wellenlaengen eingefuegt'
      call asort(nd,wd)

!     FIR emission:
      w1=27.d0
      w2=1300.d0
      dwlog = (log10(w2) - log10(w1))/(nfdif-jein-1)
      do  14  k = 1, nfdif-jein
       wd(k)= 10.**(dwlog*(k-1)+log10(w1))
       if (wd(k) .eq.  60.d0) wd(nf+jein+k) =  60.1d0
       if (wd(k) .eq. 100.d0) wd(nf+jein+k) = 100.1d0
       if (wd(k) .eq. 200.d0) wd(nf+jein+k) = 200.1d0
 14   end do

      call asort(nd,wd)


! zum testen:
!      do  k = nd,1, -1
!       print*, k, wd(k)   
!      end do


! Wellenlaengen in absteigender Reihenfolge und belegen der restlichen 
! arrays:  weld, fd, fd3, dfd
      do  15  k = 1, nd
       welmud(k)= wd(nd-k+1)
       weld(k)  = 1d-4 * welmud(k) 
       fd(k)    = clicht / weld(k)
       fd3(k)   = fd(k)**3

 15   end do

      do  16  k = 2, nd-1
       if(k .gt. 1 .and. k .lt. nd)  dfd(k) = 5d-1 * (fd(k+1) - fd(k-1))
 16    end do
      dfd(1)  = 5d-1*(fd(2)  - fd(1))
      dfd(nd) = 5d-1*(fd(nd) - fd(nd-1))

      if(ibug.ge. 2) then
       print 220, (k, welmud(k), fd(k), dfd(k), k=1, 2)
       print 221, (k, welmud(k), fd(k), dfd(k), k=nd-1,nd)
      end if
 221  format(' Die 3 kleinsten  wellenl. [mu] bez. STAUB:' / 16x, 'welmud      fd(k)       dfd(k)' / (5x, i8, 1p3e11.3))
 220  format(' Die 3 groesseten wellenl. [mu] bez. STAUB:' / 16x, 'welmud      fd(k)       dfd(k)' / (5x, i8, 1p3e11.3))


!
!   Die Wellenlänge k bez. Stern (welmu) hat bez. Staub die Nummer jd(k)
!
      call locat(welmu, nf , 2.d0, krit) 
      call locat(welmud, nd , 2.d0, kdrit) ! auch in bahnpah.f 

       do  17  k  = krit+1, nf
          jd(k)  = k + nfdif
 17      end do

      do  19  k  = 1, krit
          w      = welmu(k)
      do  18  kd = 1, kdrit 
       if (abs(w -welmud(kd))/w .lt. 1d-6) then
         jd(k)    = kd
!         print*, welmu(k), welmud(kd), jd(k), kd
       end if
 18   end do
      if (abs(welmu(k)-welmud(jd(k)))/welmu(k) .ge. 1d-6) then
      print*, welmud(jd(k)),abs(welmu(k)-welmud(jd(k)))/welmu(k),jd(k),k
      stop
      end if
 19   end do



! ----
!
       Return
end subroutine Wstaub

!
! --------------------------------------------------------------------------------------------------------
!

real*8 function qcontpah(wel)

!   Absoption coefficient for emission per C-atom of PAH.  A smoothed
!   version of Eq(16) of Schutte et al. ApJ 415, 397 (1993)]

      implicit none
      real*8,intent(in)	:: wel
      real*8		:: a = 4.3d-20
      real*8		:: welmax = 15d-4
     
      qcontpah = a / (1d4 * wel)**1.24
      if(wel .ge. welmax)   then
      return
      else 
      qcontpah = qcontpah * (wel/welmax)**4
      end if

      return
end function qcontpah
