module constants
     implicit none
     save    ! stellt sicher, dass der Inhalt in den Speicherplaetzen
             ! zwischen den einzelnen Einbindevorgaengen in den
             ! einzelnen Programmeinheiten unveraendert bleibt


     	! mathematical constants
integer, parameter      :: structure    = 2    ! 1= sphere 2=disk-spirale  3=clumpen
real*8, parameter 	:: pi 		= 4d0*atan(1d0) !pi
real*8, parameter 	:: pi4 		= 4.0*pi	!4pi
real*8, parameter 	:: pi43 	= pi4/3.0	!4/3pi
     	! physical constants
real*8, parameter 	:: hwirk 	= 6.6262d-27	!plancksches Wirkungsquantum
real*8, parameter 	:: clicht 	= 2.997925d10	!Lightspeed
real*8, parameter 	:: protm 	= 1.672d-24	!Mass of Proton
real*8, parameter 	:: boltz	= 1.38062d-16	!Boltzman constant
real*8, parameter 	:: Grav   	= 6.6730000d-08	!Gravit. Konst.
real*8, parameter 	:: sigma	= 5.669563d-5	!Stefan Boltzman constant
real*8, parameter 	:: evolt	= 1.602d-12	!conversin electron Volt Joule
real*8, parameter 	:: wmolc	= 12.		!Molecular mass of Carbon
real*8, parameter 	:: rhc		= 2.5		!density Carbon 
real*8, parameter 	:: wmolsi	= 168.		!Molecular mass of Silikat 
real*8, parameter 	:: rhsi		= 2.5		!density silicate 
	! astronomical constants
real*8, parameter 	:: au		= 1.5d13	!conversion AU ->m
real*8, parameter 	:: pc 		= 3.085d18	!conversion PC ->m
real*8, parameter 	:: Lsun         = 3.85d33
real*8, parameter 	:: Msun         = 1.989d33
real*8, parameter 	:: alpha	= 1d-3	        !Turbulenz parameter
real*8, parameter       :: rsmax        = au
real*8, parameter       :: gamin        = 0.5
real*8, parameter       :: gamout       = -1.
	! program constants
integer, parameter 	:: ntg		= 512		! 768 gibt 1MKelvin
integer, parameter 	:: nthet	= 9		!number differnt angle theta
integer, parameter 	:: nf		= 255 !8192 !249999 od. 2048 #frequencies of source
!integer, parameter 	:: nf		= 248 ! iQuelle=4: SN1a templates 
integer, parameter 	:: nfdif	= 256	  !150 number of frequencies for dust grid
integer, parameter 	:: nd		= nf+nfdif	!total numbr freq. (dust + source)
integer, parameter 	:: naw		= 30000000	!16800000
!
integer, parameter 	:: mml		= 881		!# freq in d.qXray(=d.q.lang.stp <0.03mu)
integer, parameter 	:: mmg		= 218		!number of frequnecies in d.q.gra
integer, parameter 	:: mmr		= 308		!number of frequnecies in d.qXshort, d.qXreal
integer,parameter       :: mgas=881             !number frequencies gas


integer,parameter       :: n_mrw = 1000         ! dimension of y_mrw
real*4                  :: y_mrw(n_mrw)         ! Robitaille 2010, Eq.24

integer, parameter 	:: nuib		= 18		!array size of ir_res
integer, parameter 	:: mpabs        = naw         ! Maximale PAH absorbtionen
integer, parameter 	:: lrr		= 17		! grain sizes in d.qXreal 17
integer, parameter 	:: lrl		= 12		! grain sizes in d.qXshort 12
real*8           	:: cc3= 8d0			! Symmetry parameter
real*8, parameter	:: specind  	= -7d-1 	! Spektralindex AGN fuer iQuelle=1
real*8, parameter	:: frmax    	= 6.8d18	! Hoechste Freq fuer AGN <6.8d18(28keV)
real*8, parameter	:: frmin    	= 1.035d14      ! Niedrigste Frequenz fuer AGN, hier 3 mu	

integer, parameter	:: jcontpah	= 1 
integer, parameter	:: material     = 0
real*8, parameter	:: C_PAH_UV	= 3d-18
real*8, parameter	:: abuc         = 2.0d-4        ! default 2d-4
real*8, parameter	:: abusi        = 3.1d-5


! adiditonal from pah.com
integer,parameter       :: mmek         = 35
integer,parameter       :: nnTvsg       = 75

! adiditonal for SN1a
integer, parameter :: ntSN1a=90
end module constants

!
! ----------------------------------------------------------------------------------------------
!

module parameter
use constants
	implicit none
	save
        type input_type
                integer  :: structure
                integer  :: parameter
                real*8   :: p(15)
                character(50) :: dust_prop
        end type input_type
        type sca_store
                integer :: jf
                integer :: lp
                real*8  :: x
                real*8  :: y
                real*8  :: z
        end type sca_store
        real*4,external  :: get_random
        integer,allocatable     :: iter_ac(:,:)
        integer,allocatable     :: iter_si(:,:)
!waiting to be ready to test read in and allocation of dimensions
        integer 	:: nx           !scheibe =300    
        integer 	:: ny
        integer 	:: nz        !scheibe =33
        integer 	:: nx1
        integer 	:: ny1
        integer 	:: nz1
      	real*4 	:: sumQsBc(ntg,nd)=0
      	real*4 	:: sumQsBsi(ntg,nd)=0
      	real*8,allocatable	:: Tsi(:)
      	real*8,allocatable	:: Tc(:)
	real*8,allocatable	:: amrn(:)		!array radius grains
	real*8	:: C_abs_si(nd)		!absorption koefficient silicate bezgl. fd
	real*8	:: C_sca_si(nd)=0	!scattering koefficient silicate   "
	real*8	:: C_abs_ac(nd)=0	!absorption koefficient carbon     "
	real*8	:: C_sca_ac(nd)=0	!scattering koefficient carbon     "
	real*8	:: C_ext_ac(nd)=0	!extinction koefficient carbon     "
	real*8	:: C_ext_si(nd)=0	!extinction koefficient silicate   "
	real*8	:: C_abs_pah(nd)=0       !absobtion  koefficient of PAH     "
        real*8  :: C_gas(nd)=0
        real*8  :: Tmax=0 
	real*8	:: zufall
        integer,allocatable :: netsum(:,:,:)	
	real*8	:: a1r
	real*8	:: x1r
        real*8  :: rho_clump
	real*8	:: LQuelle
	real*8	:: epak
	real*8	:: Tstar, Rstar, Mstar
	real*8	:: dist
	real*8	:: kugelsym
	integer	:: klump 
	integer	:: nklump
	integer	:: ibug, iblack
	integer	:: nzyk
	integer	:: iQuelle
	integer	:: iexpGW1
	real*8	:: dGW
	integer	:: jhaufen
	integer	:: nst
	real*8	:: L_Haufen
	real*8	:: T_Haufen
	integer	:: LaC
	integer	:: LeC
	integer	:: LaSi
	integer	:: LeSI
        integer :: i_iso  !aniso scat (0=g, 1=H-G)
        integer :: i_write      ! write out scatters, 1 = yes
	integer	:: jvsg
	integer	:: jpah,jgas, nuwpah, iXnopah
        real*8  :: qmrn         = 3.5d0
	real*8	:: abuvsg
	real*8	:: abupah
	real*8	:: zcpah, Ecr
	real*8	:: hydpah
	real*8	:: aCmass 
	real*8	:: Simass 
	real*8	:: vsgmass
	real*8	:: pahmass, pahnum
	real*8	:: fr(nf)=0
	real*8	:: dfr(nf)=0
	real*8	:: wel(nf)=0
	real*8	:: welmu(nf)=0
	integer	:: jd(nf)=0
        integer :: ivnzyk(nf)=0, nSNzyk(ntSN1a,nf)=0  ! iQuelle=3, 4,5
	real*8	:: weld(nd)=0
	real*8	:: welmud(nd)=0
	real*8	:: fd(nd)=0
	real*8	:: fd3(nd)=0
	real*8	:: dfd(nd)=0
	real*8	:: dirthet(nthet+1)=0
	real*8	:: cc4(nthet)=0
        integer,allocatable :: netz(:,:,:)
	integer	:: isumuw

	integer*8,allocatable	:: nabsc(:) !Lucy method may require INTEGER*8, especially for high nzyk! test!
	integer*8,allocatable	:: nabssi(:)
	integer,allocatable	:: iabs(:)
	integer,allocatable	:: isca(:)
	integer,allocatable     :: iabspah(:)
        integer,allocatable     :: sca_freq(:,:),sca_UW(:,:) !arrays for storing scattering events
        type(sca_store),allocatable :: sca_trace(:,:) !array storing scattering events, dimension (200, #threads)
        integer*8,allocatable     :: sum_sca_freq(:,:) !stores sum of all scatters up to index frequency
        integer,allocatable     :: sca_buffer(:,:) !buffers scattering data before writing to file, stores (jf, lp)
        type(sca_store),allocatable :: sca_buffer_aniso(:) !buffers scattering data, stores jf, lp, and d
        integer :: buffer_int !stores index of sca_buffer, needed again in Toutput - for large nzyk and high optical depth, may need integer*8
        integer :: iabsgas
        integer :: iabs_max !used by Lucy method. Stores freq. index for which total absorption mass-coefficient is at maximum
	real*8,allocatable	:: dicht(:)
	real*8	:: Cext_V
	real*8	:: rinner,router, cl_mass
	real*8	:: QBsi(ntg)=0, QBc(ntg)=0	
	real*8	:: C_planck(ntg)=0, C_ross(ntg)=0
	real*8	:: Td(ntg)=0		
	real*8	:: QsBsi(ntg)=0, QsBc(ntg)=0
	integer	:: iphd(nd,nthet) = 0
	integer	:: iphs(nd,nthet) = 0
        real*8 ::  tau_eff(nd,nthet) = 0
        real*8 ::  Z_ndthet(nthet) = 0
        integer :: iphd0(nd,3) = 0 !x=0,y=0,z=0 planes
        integer :: iphs0(nd,3) = 0
!        integer :: iphdz0(nd) = 0
!        integer :: iphsz0(nd) = 0
        integer :: iphdmax(nd,3) = 0 !x=xmax,y=ymax,z=zmax planes
        integer :: iphsmax(nd,3) = 0
        real*8  :: ang_section0(3), ang_sectionmax(3)!angular areas of x,y,z=0 and x,y,z=max planes (respectively) as seen from the star
        real*8  :: Z_nd0(3), Z_ndmax(3), tau_eff0(nd,3), tau_effmax(nd,3)
        real*8,allocatable :: x(:)		
        real*8,allocatable :: y(:)
        real*8,allocatable :: z(:)
	integer  :: ipahlp(mpabs), ipahfr(mpabs)
	integer*2,allocatable :: inopah(:)	
	integer	:: old_random
        integer :: iter_luci, itdisk
        integer :: n_luci
        integer :: idim3
        real*8  :: xorg
        real*8  :: yorg
        real*8  :: zorg
        integer :: iUWnopah=0              ! Summe aller UW mit X-ray Vernichtung von PAH
        integer :: ispah=0              ! Summe aller von PAH  absorbierten Packete
        integer :: iwp=0                ! Summe der in einem UWr von PAH absorbierten Packete

        integer :: jmrn = 0  !determines which d.q. file to read, 0=MRN (lang.stp), 1=fluffy (Xreal), 2 = Xrays(Xshort)
        integer :: mm
        integer :: lr
        real*8,allocatable      :: g_ac_mrn(:)          !average g-factor for carbon (wavelength) for frmrn
        real*8,allocatable      :: g_si_mrn(:)          !average g-factor for silicate (wavelength) "  "
        real*8                  :: g_ac(nd)             !average g-factor for carbon (wavelength) dust
        real*8                  :: g_si(nd)             ! "         "         silicate    "
	real*8,allocatable	:: K_abs_si(:)		!absorption koefficient silicate bezgl. frmrn
	real*8,allocatable	:: K_sca_si(:)		!scattering koefficient silicate  "
	real*8,allocatable	:: K_abs_ac(:)		!absorption koefficient carbon    "
	real*8,allocatable	:: K_sca_ac(:)		!scattering koefficient carbon	  "
	real*8,allocatable	:: K_abs_pah(:)	!absorption koefficient PAH       "
        real*8  :: K_gas(mgas)=0
        real*8  :: wel_gas(mgas)=0

        real*8 :: tempuw(mpabs)=0, pwuw(mpabs)=0

!additional from pah.com
        real*8,allocatable  :: qpah(:), welmrn(:), frmrn(:), fr3mrn(:), dfrmrn(:) !allocate mm in crosssec

        real* 8 :: tbb, cc2, cc2c, cc2si,  arad, ahv, &
        zhpah, sumevap, qextvis, BruchMat

        real*8  :: qpahd(nd) 

        real*8  :: att(nnTvsg,nnTvsg+1)=0, bt(nnTvsg,nnTvsg)=0, un(nnTvsg)=0, &
        dun(nnTvsg)=0, dtun(nnTvsg)=0, tem(nnTvsg)=0, pw(nnTvsg)=0, xatom

        integer :: ir_res(nuib)=0, krit, ivisd, kvis, lp_zu_iwp(mpabs)=0, &
        letztd(nthet)=0, letzts(nthet)=0

	integer	:: jth
        integer :: jf,lp
	integer	:: i,k,j
        integer :: izyk, ilpi, iav, kTabs, nphot
!        real*8  :: Hscale(nx)=0, csound(nx)=0, 
        real*8  :: rhomin
        real*8,allocatable :: Hscale(:)
        real*8,allocatable :: csound(:)
	real*8 :: Lacc = 0d0

! Temperatur azimuthal gemittelt, Dichte und z bei iz,lrmid
        integer :: nmid, nzUW, nUWzmax
        real*8,allocatable   :: rmid(:),Tmid(:),Ttop(:), zvert(:)
        real*8,allocatable   :: tauzmid(:)
        real*8,allocatable   :: Temz(:,:), rhoz(:,:)
        integer,allocatable  :: isotr(:)  ! top der Schicht bei tauz>5
        integer,allocatable  :: ibotr(:)  ! top der Schicht bei tauz=1
        integer,allocatable  :: itopr(:)  ! top der Schicht bei tauz>0.1
        integer,allocatable  :: nUWTz(:,:)  ! #UW bei Abstand rmid, zz

        type(input_type)     :: input

end module parameter


!
! -----------------------------------------------
!

module type_module
        type float_vector
                real*8  :: x
                real*8  :: y
                real*8  :: z
        end type float_vector
        type int_vector
                integer :: x
                integer :: y
                integer :: z
        end type int_vector
        type init_type
                integer         :: nx
                integer         :: ny
                integer         :: nz
                real*8          :: dgw
                real*8          :: epak
                integer         :: ntg
                integer         :: nd
                integer         :: nthet
                integer         :: nf
                integer         :: nzyk
                real*8          :: SImass
                real*8          :: ACmass
                integer         :: n_precalc
                integer         :: iter
                integer         :: idim3
        end type init_type
end module type_module

module source_parameter
	real*8	:: xalt
	real*8	:: quant
end module source_parameter

!
! -----------------------------------------------
!

module view_subroutines
type initial
        integer         :: imx
        integer         :: imy
        integer         :: ixsub
        integer         :: iysub
        integer         :: nsubpixel
        integer         :: nx_new
        integer         :: ny_new
        integer         :: nz_new
        real*8          :: distance
        real*8          :: minI_x
        real*8          :: minI_y
        real*8          :: maxI_x
        real*8          :: maxI_y
        real*8          :: IMC(3)
        real*8          :: IMC_x
        real*8          :: IMC_y
        real*8          :: stepp
        real*8          :: norm_x(3)=0
        real*8          :: norm_y(3)=0
        real*8          :: xd
        real*8          :: yd
        real*8          :: zd
        real*8          :: tau_max
        real*8          :: scatter_scale
        integer         :: i_freq
        integer         :: sca_start
        integer         :: sca_end
end type initial

contains

subroutine send_ray(image_emission,image_scatter,nUW_new,sumnUW_new,Tsi_old,Tac_old,dicht_old,vek_new,init,isca_old,rsca)
use constants
use parameter

implicit none
integer,intent(in)              :: nUW_new(:,:,:)
integer,intent(in)              :: sumnUW_new(:,:,:)
real*8,intent(in)               :: Tsi_old(:)
real*8,intent(in)               :: Tac_old(:)
real*8,intent(in)               :: dicht_old(:)
integer,intent(in)              :: vek_new(:)
real*8,intent(in)              :: isca_old(:)
type(initial),intent(in)        :: init
real*8,intent(inout)            :: image_emission(:,:)
real*8,intent(inout)            :: image_scatter(:,:)



real*8			:: a_xy,a_xz,a_yz,a
real*8                  :: tau,delta_tau,delta_tau_sca
real*8                  :: delta_tau_si, delta_tau_ac, delta_tau_pah
real*8                  :: emission_ac,emission_si,emission_pah,scatter
real*8                  :: help
real*8                  :: m_ac,m_si
real*8                  :: planck_si,planck_ac, Bpw_pah
real*8                  :: radius_star
real*8                  :: temp_star
real*8                  :: planck_star
real*8                  :: bpl
real*8                  :: temp_si,temp_ac
real*8			:: hx,hy,hz,hx1,hx2,hy1,hy2,hz1,hz2		!help
real*8                  :: pix_x
real*8                  :: pix_y
real*8                  :: pix_MC(3)


!also defined in main program
integer                 :: hUW
integer                 :: iux,iuy,iuz
integer                 :: ix,iy,iz
integer                 :: lp_new
real*8			:: xs,ys,zs		!start
real*8			:: xe,ye,ze		!end

!transfer through init
real*8                  :: minI_x,minI_y,maxI_x,maxI_y
integer                 :: imx,imy
integer                 :: ixsub,iysub
integer                 :: nsubpixel
real*8                  :: IMC(3),IMC_x,IMC_y
real*8                  :: distance
real*8                  :: norm_x(3),norm_y(3)
real*8                  :: xd,yd,zd
integer                 :: nx_new,ny_new,nz_new
real*8                  :: stepp
real*8                  :: tau_max
real*8                  :: scatter_scale
integer                 :: i_freq, jUWpah, jpah_loc,i_loc, j_loc
integer                 :: sca_start,sca_end,rsca

! load inital values

        jpah_loc = jpah

        minI_x  = init%minI_x
        minI_y  = init%minI_y
        maxI_x  = init%maxI_x
        maxI_y  = init%maxI_y
        imx     = init%imx
        imy     = init%imy
        ixsub   = init%ixsub
        iysub   = init%iysub
        IMC     = init%IMC
        IMC_x   = init%IMC_x
        IMC_y   = init%IMC_y
        distance= init%distance
        norm_x  = init%norm_x
        norm_y  = init%norm_y
        xd      = init%xd
        yd      = init%yd
        zd      = init%zd
        nx_new  = init%nx_new
        ny_new  = init%ny_new
        nz_new  = init%nz_new
        stepp   = init%stepp
        tau_max = init%tau_max
        scatter_scale = init%scatter_scale
        sca_start = init%sca_start
        sca_end = init%sca_end
        i_freq  = init%i_freq
        nsubpixel = init%nsubpixel

        pix_x = minI_x+(1d0*imx+(1d0*ixsub+0.5d0)/(1d0*nsubpixel))*stepp
        pix_y = minI_y+(1d0*imy+(1d0*iysub+0.5d0)/(1d0*nsubpixel))*stepp
        pix_MC=IMC+(pix_x-IMC_x)*norm_x+(pix_y-IMC_y)*norm_y
        hx=(1d0+sign(1d0,xd))/2d0*nx_new
	hy=(1d0+sign(1d0,yd))/2d0*ny_new
	hz=(1d0+sign(1d0,zd))/2d0*nz_new
        hx1=0d0
        hy1=0d0
        hz1=0d0
        hx2=nx_new
        hy2=ny_new
        hz2=nz_new
	a_xy=(hz-pix_MC(3))/zd
 	a_xz=(hy-pix_MC(2))/yd
	a_yz=(hx-pix_MC(1))/xd
        a=0
	xs=pix_MC(1)+a_xy*(xd)
	ys=pix_MC(2)+a_xy*(yd)
        if (xs.ge.hx1.and.xs.le.hx2.and.ys.ge.hy1.and.ys.le.hy2.and.abs(1/a_xy).gt.0) a=a_xy
	xs=pix_MC(1)+a_xz*(xd)
	zs=pix_MC(3)+a_xz*(zd)
        if (xs.ge.hx1.and.xs.le.hx2.and.zs.ge.hz1.and.zs.le.hz2.and.abs(1/a_xz).gt.0) a=a_xz
	ys=pix_MC(2)+a_yz*(yd)
	zs=pix_MC(3)+a_yz*(zd) 
        if (ys.ge.hy1.and.ys.le.hy2.and.zs.ge.hz1.and.zs.le.hz2.and.abs(1/a_yz).gt.0) a=a_yz
	xs=pix_MC(1)+a*(xd)
	ys=pix_MC(2)+a*(yd)
	zs=pix_MC(3)+a*(zd)
        xe=0
        ye=0
        ze=0
        ix=int(xs)+1
        iy=int(ys)+1
        iz=int(zs)+1
        if (xs.lt.-1d-10) ix=0
        if (ys.lt.-1d-10) iy=0
        if (zs.lt.-1d-10) iz=0
        if (xs.eq.nx_new) ix=nx_new
        if (ys.eq.ny_new) iy=ny_new
        if (zs.eq.nz_new) iz=nz_new
        if (xs.gt.nx_new) ix=0
        if (ys.gt.ny_new) iy=0
        if (zs.gt.nz_new) iz=0  
        if (ix.ge.1.and.iy.ge.1.and.iz.ge.1) then 
                iux=int((xs-(ix-1))*nUW_new(ix,iy,iz))+1
                iuy=int((ys-(iy-1))*nUW_new(ix,iy,iz))+1
                iuz=int((zs-(iz-1))*nUW_new(ix,iy,iz))+1
                if (iux.lt.1) iux=1
                if (iuy.lt.1) iuy=1
                if (iuz.lt.1) iuz=1
                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz)
        endif

!        print*,nUW_new(ix,iy,iz),ix,iy,iz
!        write(*,fmt='(8i5,4F7.2)'),imx,imy,ix,iy,iz,iux,iuy,iuz,xs,ys,zs,a
        tau = 0.d0
      	emission_si  = 0.
        emission_ac  = 0.
        scatter = 0.
	do while (((ix.le.nx_new).and.(iy.le.ny_new).and.(iz.le.nz_new)) &
             .and. ((ix.ge.1).and.(iy.ge.1).and.(iz.ge.1)).and.(tau.lt.tau_max))
        	emission_pah = 0.
                hx=(ix-1)+(1d0*iux-(1+sign(1d0,xd))/2)/nUW_new(ix,iy,iz)
		hy=(iy-1)+(1d0*iuy-(1+sign(1d0,yd))/2)/nUW_new(ix,iy,iz)
		hz=(iz-1)+(1d0*iuz-(1+sign(1d0,zd))/2)/nUW_new(ix,iy,iz)
                hx1=ix-1+(1d0*iux-1)/nUW_new(ix,iy,iz)
                hy1=iy-1+(1d0*iuy-1)/nUW_new(ix,iy,iz)
                hz1=iz-1+(1d0*iuz-1)/nUW_new(ix,iy,iz)
        	hx2=ix-1+(1d0*iux)/nUW_new(ix,iy,iz)
        	hy2=iy-1+(1d0*iuy)/nUW_new(ix,iy,iz)
        	hz2=iz-1+(1d0*iuz)/nUW_new(ix,iy,iz)
        	a_xy=(hz-zs)/zd
         	a_xz=(hy-ys)/yd
        	a_yz=(hx-xs)/xd
                a=0
        	xe=xs+a_xy*(xd)
                ye=ys+a_xy*(yd)
                if (xe.ge.hx1-1d-10.and.xe.le.hx2+1d-10.and.ye.ge.hy1-1d-10.and.ye.le.hy2+1d-10.and.abs(1d0/a_xy).gt.0) a=a_xy
               
 xe=xs+a_xz*(xd)
                ze=zs+a_xz*(zd)
                if (xe.ge.hx1-1d-10.and.xe.le.hx2+1d-10.and.ze.ge.hz1-1d-10.and.ze.le.hz2+1d-10.and.abs(1d0/a_xz).gt.0) a=a_xz
                ye=ys+a_yz*(yd)
                ze=zs+a_yz*(zd) 
                if (ye.ge.hy1-1d-10.and.ye.le.hy2+1d-10.and.ze.ge.hz1-1d-10.and.ze.le.hz2+1d-10.and.abs(1d0/a_yz).gt.0) a=a_yz
!                print*,a_xy,a_xz,a_yz
                xe=xs+a*xd
                ye=ys+a*yd
                ze=zs+a*zd
                hUW=nUW_new(ix,iy,iz)
                lp_new=sumnUW_new(ix,iy,iz)-hUW**3+hUW**2*(iux-1)+hUW*(iuy-1)+iuz
!                print*,lp_new,vek_new(lp_new)
                if (Tsi_old(vek_new(lp_new)).lt.0) then 
! Falls Tsi <0 dann Stern:
! star is so small that it doesn't increase the optical depth
                        delta_tau_si  = 0d0              
                        delta_tau_ac  = 0d0
                        delta_tau_pah = 0d0
                        delta_tau     = 0d0
                        delta_tau_sca = 0d0
                        temp_star = -Tsi_old(vek_new(lp_new))
                        radius_star = -Tac_old(vek_new(lp_new))
                        planck_star = bpl(frmrn(i_freq),frmrn(i_freq)**3d0,temp_star)
                        if (idim3 .ne. 1) then 
                        emission_si = pi*(radius_star)**2d0/(distance**2d0)*planck_star/cc3*&
&                               abs(a)*stepp**2*nUW_new(ix,iy,iz)**3/(nsubpixel**2d0)
                                help=help+abs(a)*stepp**2*nUW_new(ix,iy,iz)**3/(nsubpixel**2d0)/cc3
                        else
                        emission_si = pi*(radius_star)**2d0/(distance**2d0)*planck_star*&
&                               abs(a)*stepp**2*nUW_new(ix,iy,iz)**3/(nsubpixel**2d0)
                        endif
                        emission_si = emission_si*exp(-tau)
                        emission_ac = 0d0
                        
                        if(rsca .eq. 1) then!--------------SCATTERING---------
                        if(i_iso .gt. 0) then
                        if(isca_old(lp_new) .ne. 0) then
                        scatter = isca_old(lp_new)*exp(-tau)*abs(a)*scatter_scale*stepp*stepp*exp(-delta_tau/2.)*&
&                              nUW_new(ix,iy,iz)**3/(nsubpixel**2)
                        else
                           scatter = 0.
                        endif
                        else
                           if(isca_old(vek_new(lp_new)) .ne. 0) then
                        scatter = isca_old(vek_new(lp_new))*exp(-tau)*abs(a)*scatter_scale*stepp*stepp*exp(-delta_tau/2.)*&
&                              nUW_new(ix,iy,iz)**3/(nsubpixel**2)
                        else
                           scatter = 0.
                        endif
                        endif
                        if(isnan(scatter)) stop 'isNan'
                        endif!-------------END SCATTERING--------
!                        print*,tau
!                        emission_si = 0d0
                else 
                        temp_si=Tsi_old(vek_new(lp_new))
                        temp_ac=Tac_old(vek_new(lp_new))

! Staubmasse einer Zelle:
!                        m_si = abs(a)*stepp**2d0*dgw**3d0*dicht_old(vek_new(lp_new))*Simass
!                        m_ac = abs(a)*stepp**2d0*dgw**3d0*dicht_old(vek_new(lp_new))*aCmass

!
!hier einbau PAH delta_tau, fals kein lp fefunden wird?
!                        if (i_freq .ne. 0) then
                        delta_tau_si =k_abs_si(i_freq) *abs(a)*dgw*dicht_old(vek_new(lp_new))
                        delta_tau_ac =k_abs_ac(i_freq) *abs(a)*dgw*dicht_old(vek_new(lp_new))
                        delta_tau_pah=k_abs_pah(i_freq)*abs(a)*dgw*dicht_old(vek_new(lp_new))
                        delta_tau    = delta_tau_si + delta_tau_ac
!                        endif

! Gibt es PAH emission und in welchen UW (yes -> jpah_loc=1 )
                        juwpah=0
                        do j_loc =1, nuwpah
                           if(ipahlp(j_loc).eq. vek_new(lp_new)) juwpah = j_loc
                        enddo
                        if(nuwpah .eq.0) then 
                               jpah_loc = 0
                        else 
                          if(juwpah .eq. nuwpah .and. ipahlp(nuwpah).ne.vek_new(lp_new)) then
                               jpah_loc = 0
                               print*, 'juwpah, nuwpah, ipahlp(nuwpah), vek_new(lp_new)'
                               print*,  juwpah, nuwpah, ipahlp(nuwpah), vek_new(lp_new)
                               stop ' mist juwpah'
                          else
                               jpah_loc = 1
                          endif
                        endif

                        if(jpah_loc .ne. 0 .and. juwpah.ne.0) then
                           Bpw_pah  = 0.
                           do i_loc   = 1,nntvsg 
                              Bpw_pah = Bpw_pah + &
pwuw((jUWpah-1)*nnTvsg+i_loc)*bpl(frmrn(i_freq),frmrn(i_freq)**3d0,tempuw((jUWpah-1)*nnTvsg+i_loc))
                           enddo
                         emission_pah = (Bpw_pah*(1-exp(-delta_tau_pah)))*(stepp*dgw)**2d0/(distance**2d0)/(nsubpixel**2d0)
                         emission_pah = emission_pah*exp(-tau)
                        endif                        
!                      write(6,'(1p2e12.3)') (tem(j*nnTvsg+i), pw(j*nnTvsg+i), i=1,nntvsg)



                        delta_tau_sca = (k_sca_si(i_freq)+k_sca_ac(i_freq))*abs(a)*dgw*dicht_old(vek_new(lp_new))

                        planck_si = bpl(frmrn(i_freq),frmrn(i_freq)**3d0,temp_si)
                        planck_ac = bpl(frmrn(i_freq),frmrn(i_freq)**3,temp_ac)

                        emission_si  = (planck_si*(1-exp(-delta_tau_si)))*(stepp*dgw)**2d0/(distance**2d0)/(nsubpixel**2d0)
                        emission_si  = emission_si*exp(-tau)
                        emission_ac  = (planck_ac*(1-exp(-delta_tau_ac)))*(stepp*dgw)**2d0/(distance**2d0)/(nsubpixel**2d0)
                        emission_ac  = emission_ac*exp(-tau)

                        if(rsca .eq. 1) then!--------------SCATTERING---------
                        if(i_iso .gt. 0) then
                        if(isca_old(lp_new) .ne. 0) then
                        scatter = isca_old(lp_new)*exp(-tau)*abs(a)*scatter_scale*stepp*stepp*exp(-delta_tau/2.)*&
&                              nUW_new(ix,iy,iz)**3/(nsubpixel**2)
                        else
                           scatter = 0.
                        endif
                        else
                           if(isca_old(vek_new(lp_new)) .ne. 0) then
                        scatter = isca_old(vek_new(lp_new))*exp(-tau)*abs(a)*scatter_scale*stepp*stepp*exp(-delta_tau/2.)*&
&                              nUW_new(ix,iy,iz)**3/(nsubpixel**2)
                        else
                           scatter = 0.
                        endif
                        endif
                        endif!-------------END SCATTERING--------
                       ! endif

!emission_pah = 0.

! hier einbau PAH emission
                endif 

                       image_emission(imx+1,imy+1)=image_emission(imx+1,imy+1)+emission_si+emission_ac+emission_pah
                       if(rsca .eq. 1) then!scattering
                       if(isnan(scatter)) stop 'NaN scatter'                       
                       image_scatter(imx+1,imy+1) = image_scatter(imx+1,imy+1)+scatter
                       endif!scattering endif

                tau = tau + delta_tau + delta_tau_sca
! keine Streuung!                tau = tau + delta_tau 
                if (-1d0.eq.-sign(1d0,xd).and.abs(xe-hx1).lt.1d-10.and.xd.ne.0) iux=iux-1
                if (-1d0.eq.-sign(1d0,yd).and.abs(ye-hy1).lt.1d-10.and.yd.ne.0) iuy=iuy-1
                if (-1d0.eq.-sign(1d0,zd).and.abs(ze-hz1).lt.1d-10.and.zd.ne.0) iuz=iuz-1
                if (+1d0.eq.-sign(1d0,xd).and.abs(xe-hx2).lt.1d-10.and.xd.ne.0) iux=iux+1
                if (+1d0.eq.-sign(1d0,yd).and.abs(ye-hy2).lt.1d-10.and.yd.ne.0) iuy=iuy+1
                if (+1d0.eq.-sign(1d0,zd).and.abs(ze-hz2).lt.1d-10.and.zd.ne.0) iuz=iuz+1
!                print*,ix,iy,iz,iux,iuy,iuz,a
!                if (a.eq.0) pause
                if (iux.lt.1) then
                        ix=ix-1
                        if (ix.ge.1.and.ix.le.nx_new) then
                                iux=int((xe-(ix-1))*nUW_new(ix,iy,iz))+1
                                iuy=int((ye-(iy-1))*nUW_new(ix,iy,iz))+1
                                iuz=int((ze-(iz-1))*nUW_new(ix,iy,iz))+1
                                if (iux.lt.1) iux=1
                                if (iuy.lt.1) iuy=1
                                if (iuz.lt.1) iuz=1  
                                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz)
                        endif
                else   if (iuy.lt.1) then 
                        iy=iy-1
                        if (iy.ge.1.and.iy.le.ny_new) then
                                iux=int((xe-(ix-1))*nUW_new(ix,iy,iz))+1
                                iuy=int((ye-(iy-1))*nUW_new(ix,iy,iz))+1
                                iuz=int((ze-(iz-1))*nUW_new(ix,iy,iz))+1  
                                if (iux.lt.1) iux=1
                                if (iuy.lt.1) iuy=1
                                if (iuz.lt.1) iuz=1
                                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz)
                        endif
                else   if (iuz.lt.1) then
                        iz=iz-1
                        if (iz.ge.1.and.iz.le.nz_new) then
                                iux=int((xe-(ix-1))*nUW_new(ix,iy,iz))+1
                                iuy=int((ye-(iy-1))*nUW_new(ix,iy,iz))+1
                                iuz=int((ze-(iz-1))*nUW_new(ix,iy,iz))+1
                                if (iux.lt.1) iux=1
                                if (iuy.lt.1) iuy=1
                                if (iuz.lt.1) iuz=1
                                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz)
                        endif
                else   if (iux.gt.nUW_new(ix,iy,iz)) then 
                        ix=ix+1
                        if (ix.ge.1.and.ix.le.nx_new) then
                                iux=int((xe-(ix-1))*nUW_new(ix,iy,iz))+1
                                iuy=int((ye-(iy-1))*nUW_new(ix,iy,iz))+1
                                iuz=int((ze-(iz-1))*nUW_new(ix,iy,iz))+1
                                if (iux.lt.1) iux=1
                                if (iuy.lt.1) iuy=1
                                if (iuz.lt.1) iuz=1
                                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz)  
                        endif
                else   if (iuy.gt.nUW_new(ix,iy,iz)) then
                        iy=iy+1
                        if (iy.ge.1.and.iy.le.ny_new) then
                                iux=int((xe-(ix-1))*nUW_new(ix,iy,iz))+1
                                iuy=int((ye-(iy-1))*nUW_new(ix,iy,iz))+1
                                iuz=int((ze-(iz-1))*nUW_new(ix,iy,iz))+1
                                if (iux.lt.1) iux=1
                                if (iuy.lt.1) iuy=1
                                if (iuz.lt.1) iuz=1 
                                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz)    
                        endif
                else   if (iuz.gt.nUW_new(ix,iy,iz)) then
                        iz=iz+1
                        if (iz.ge.1.and.iz.le.nz_new) then
                                iux=int((xe-(ix-1))/nUW_new(ix,iy,iz))+1
                                iuy=int((ye-(iy-1))/nUW_new(ix,iy,iz))+1
                                iuz=int((ze-(iz-1))/nUW_new(ix,iy,iz))+1  
                                if (iux.lt.1) iux=1
                                if (iuy.lt.1) iuy=1
                                if (iuz.lt.1) iuz=1
                                if (iux.gt.nUW_new(ix,iy,iz)) iux=nUW_new(ix,iy,iz)
                                if (iuy.gt.nUW_new(ix,iy,iz)) iuy=nUW_new(ix,iy,iz)
                                if (iuz.gt.nUW_new(ix,iy,iz)) iuz=nUW_new(ix,iy,iz) 
                        endif
                endif
                xs=xe
                ys=ye
                zs=ze

        enddo

end subroutine send_ray
end module view_subroutines




