subroutine simple_cluster(init,iter)
!---simple routine to build a homogeneous cluster
!---with a single star either with or without a
!---circumstellar shell.
use parameter
use constants
use type_module

implicit none

type(init_type) :: init
integer :: iter,nstar=1
integer :: starpos(3),ntz
real*8  :: starcentre(3),rrs,distmod
real*8	:: xx2,xx
real*8	:: yy2,yy
real*8	:: zz2,zz		
real*8	:: dl
real*8	:: rr,rr2
integer	:: ii, jj, kk,ntsum

if(idim3 .ne. 1) stop 'only available in 3d'

!parameters
if (ibug>0) then 
   print*,' **Simple cluster density distribution'
   print*,' 6 parameter:'
   print'(A,d8.2)','   p(01) -- cloud density               ',input%p(1)
   print'(A,d8.2)','   p(02) -- density profile             ',input%p(2)
   print'(A,d8.2)','   p(03) -- shell density               ',input%p(3)
   print'(A,d8.2)','   p(04) -- shell density profile       ',input%p(4)
   print'(A,d8.2)','   p(05) -- cell subdivision around star',input%p(5)
   print'(A,d8.2)','   p(06) -- star x-position             ',input%p(6)
!   print'(A,e8.2)','   p(06) -- shell inner radius [cm]     ',input%p(7)
!   print'(A,e8.2)','   p(07) -- shell outer radius [cm]     ',input%p(8)
!   print'(A,e8.2)','   p(08) --          ',input%p(8)
!   print'(A,e8.2)','   p(09) --     ',input%p(9)
!   print'(A,e8.2)','   p(10) --    ',input%p(10)

end if 

if (input%parameter.ne.6) then 
   print*,'Incorrect number of parameter'
   stop
endif

!determine position of star
starpos(1) = int(input%p(6))
starpos(2) = ny/2 +1
starpos(3) = nz/2 +1
starcentre(1) = x(starpos(1)) + dgw/2.
starcentre(2)= yorg
starcentre(3)= zorg
!rinner = input%p(7)
!router = input%p(8)

print*,'position of star at [i,j,k]',starpos,'or [x,y,z]',starcentre,' cm'

call read_struct(init,iter)

!!$a1r = input%p(1)
!!$x1r = input%p(2)
!!$
!!$!setup grid
!!$iexpgw1 = input%p(5)
!!$
!!$        do i=1,nx
!!$        do j=1,ny
!!$        do k=1,nz
!!$           netz(i,j,k) = 1
!!$           distmod = (i-starpos(1))**2 + (j-starpos(2))**2. + (k-starpos(3))**2.!(i-0.5-starpos(1))**2. + (j-0.5-starpos(2))**2. + (k-0.5-starpos(3))**2. !see if this improves resolution
!!$           distmod = sqrt(distmod)
!!$          ! if(i .eq. starpos(1) .and. j .eq. starpos(2) .and. k .eq. starpos(3)) netz(i,j,k) = iexpgw1
!!$!              if (distmod.le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6)
!!$!              if (distmod.le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5)
!!$!              if (distmod.le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4)
!!$              if (distmod.le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3)
!!$ !             if (distmod.le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2)
!!$ !             if (distmod.le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1)
!!$              if (distmod.lt.1) netz(i,j,k) = 2**(iexpgw1)
!!$        enddo
!!$        enddo
!!$        enddo
!!$
!!$        isumuw = 0.
!!$        do i = 1, nx
!!$           do  j = 1, ny
!!$              do  k = 1, nz
!!$                 isumuw        = isumuw + netz(i,j,k)**3
!!$                 netsum(i,j,k) = isumuw
!!$              end do
!!$           end do
!!$        end do
!!$        print *, ' 7. Summe aller Unterwuerfel =', isumuw
!!$        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'
!!$
!!$        do jth = 1, nthet
!!$           cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
!!$        end do
!!$
!!$call allocspace(isumuw)
!!$
!!$do i = 1, isumuw
!!$   dicht(i)    = 0.
!!$end do
!!$
!!$!set density
!!$        do i = 1, isumuw
!!$           dicht(i)    = 0.
!!$        end do
!!$        cl_mass = 0.
!!$        do i = 1, nx
!!$        do j = 1, ny
!!$        do k = 1, nz
!!$           ntz = netz(i,j,k)
!!$           dl  = dGW / ntz
!!$           do ii = 1, ntz
!!$           do jj = 1, ntz
!!$           do kk = 1, ntz
!!$              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
!!$              if(lp .gt. isumuw) print*,netsum(i,j,k),ntz,i,j,k,ii,jj,kk,lp
!!$              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
!!$              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
!!$              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
!!$              rr     = sqrt(xx2 + yy2 + zz2)
!!$!              if (rr .ge. rinner .and. rr .le. router) then 
!!$                 dicht(lp) = a1r / rr**x1r
!!$!                 if (ntz .gt. 1) then
!!$                    xx2    = (x(i) + ((ii - 5d-1) * dl) - starcentre(1))**2
!!$                    yy2    = (y(j) + ((jj - 5d-1) * dl) - starcentre(2))**2
!!$                    zz2    = (z(k) + ((kk - 5d-1) * dl) - starcentre(3))**2
!!$                    rrs    = sqrt(xx2 + yy2 + zz2)
!!$                    if (input%p(3) .gt. 0 .and. rrs .le. router)then ! .and. rrs .ge. rinner) then
!!$                       dicht(lp) = input%p(3) / rrs**input%p(4)
!!$                       if (dicht(lp) .lt. (a1r / rr**x1r)) dicht(lp) = a1r / rr**x1r
!!$                    endif
!!$                    if (rrs .lt. rinner) dicht(lp) = 0
!!$!                    if (rrs .lt. rinner) print*,rrs,i,j,k,ii,jj,kk,lp,dicht(lp)
!!$                ! endif
!!$                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
!!$!              endif
!!$           end do
!!$           end do
!!$           end do
!!$        end do
!!$        end do
!!$        end do

!reset origin to star for photon launching
xorg = starcentre(1)
yorg = starcentre(2)
zorg = starcentre(3)

print*,'photons will be launched from:', xorg,yorg,zorg

open(unit=22, file='output/space_centre.txt', form='formatted')

write(22,198)
198  format(/ 3x, 'x',3x,'y',3x,'z',3x,'xx',3x,'yy',3x,'zz',3x,'rho',3x,'Tc',3x,'Tsi',3x,'lp')
i=starpos(1)
j=starpos(2)
k=starpos(3)
ntz = netz(starpos(1),starpos(2),starpos(3))
ntsum = netsum(starpos(1),starpos(2),starpos(3))
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = ntsum - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              write(22,199) i,j,k,ii,jj,kk,dicht(lp),Tc(lp),Tsi(lp),lp
           enddo
           enddo
           enddo
199 format(6i4,3e10.2,i8)
end subroutine simple_cluster

subroutine gap_disc(init)

! Subroutine to model a large disc with a gap
! e.g. transitional disc. Written to model
! HD169142 in particular. 

use type_module
use constants
use parameter

implicit none

        type(init_type) :: init
        real*8  :: tauVrsmax,  aheight, beta, gam
	real*8	:: cl_mass1, fakcon, Hscal, cs, Height, mu
        real*8  :: rr, rrr, tauV_mid, temp_mid, dum
        real*8  :: xx2, yy2, zz2, xx, yy,zz, dl, dr, dz
        real*8  :: x1, x2, y1,y2
        real*8  :: dl1, zz1, fak
        real*8  :: surf, surfr, zmin, ell, protmu
        real*8  :: dichtz, dichtzmin,  dichtzmin1, tauz0, dtauz
        real*8  :: halo_mass
        real*8  :: tauz01,rho0
        real*8  :: xmid0(2000), Tmid0(2000)
        real*8  :: tauVmin, routfein
        real*8, allocatable  :: ztop(:)    ! Scheibenhoehe ztop(rho.ne.0) 
        real*8, allocatable  :: zbottom(:) ! Scheibenhoehe zbottom(tau=1) 
        real*8, allocatable  :: tauzvert(:) ! tau(z) bei Rmid

	integer	:: im, nmid0, isot, ileseTmid
	integer	:: ii,jj,kk, iz, iorg, jorg, korg,kmirror
	integer	:: ntz, ntz1, nuwz, itop,ibottom, l, i1au

!---parameters
if (ibug>0) then 
   print*,' **HD169142 type transitional disc'
   print*,'  parameter:'
   print'(A,d8.2)','   p(01) -- Outer edge of inner disc/halo          ',input%p(1)
   print'(A,d8.2)','   p(02) -- Inner edge of outer disc               ',input%p(2)
   print'(A,d8.2)','   p(03) -- Inner halo density                     ',input%p(3)
   print'(A,d8.2)','   p(04) -- Inner halo density profile             ',input%p(4)
   print'(A,d8.2)','   p(05) -- Outer disc tau_vert @ 1AU              ',input%p(5)
   print'(A,d8.2)','   p(06) -- Outer disc surface density gradient    ',input%p(6)
   print'(A,d8.2)','   p(07) -- Minimum density cut off                ',input%p(7)
   print'(A,d8.2)','   p(08) -- Disc height                            ',input%p(8)
   print'(A,d8.2)','   p(09) -- Stellar Mass                           ',input%p(9)
endif

if (input%parameter.ne.9) then 
   print*,'Incorrect number of parameter'
   stop
endif

!---testing, ignore
        tauVrsmax = input%p(5)
        protmu = 2.33 * protm
        aheight = input%p(8)
        Mstar = input%p(9) * Msun
        fakcon = boltz * tstar /(grav*mstar*protmu)
        rstar = sqrt(LQuelle/pi4/sigma/Tstar**4)
!        surf    = tauV_mid /Cext_v


!---center of disc:
            call locat (x, nx, xorg, iorg)
            call locat (y, ny, yorg, jorg)
            call locat (z, nz, zorg, korg)
            iorg = iorg+1
            jorg = jorg+1
            korg = korg+1
       if(x(iorg).ne.xorg.or.y(jorg).ne.yorg.or.z(korg).ne.zorg) then
           print*, ' *** Star position at: '
           print*, ' iorg   x(iorg)  xorg'
           write(6,'(i6,1p2e10.2)') iorg, x(iorg), xorg
           write(6,'(i6,1p2e10.2)') jorg, y(jorg), yorg
           write(6,'(i6,1p2e10.2)') korg, z(korg), zorg
           print*, '*** Check out ! ***'
           print*, ' ' 
        endif


!---grid - first set all to 1
routfein = 30.*au

        do i=1,nx
           do j=1,ny
              do k=1,nz
                 netz(i,j,k) = 1
                 rr = i*i + j*j + k*k
                 rr = sqrt(rr)
                 rr = rr*dgw
!work on idim3=0 case for the moment


!---resolve inner rim - fine sampling 
!---needed to reproduce shape of inner
!---disc/halo properly

                 if(rr .le. rinner*1.1) netz(i,j,k) = 20 !needs to be enough to resolve inner rim properly i.e. lots
                 if(rr .gt.rinner*1.1 .and. rr .le. input%p(1)*1.1) netz(i,j,k) = 10 !internal structure of inner regions must be reproduced
                 if(i .eq. 1 .and. j .eq. 1 .and. k .eq. 1) netz(i,j,k) = 20



!---outer disc - finest sampling
!---needed at inner edge of
!---disc and at surface to resolve
!---photosphere properly and maintain
!---shape correctly

                 if(rr .gt. input%p(1) .and. rr .le. input%p(2)) netz(i,j,k) = 5 !need to reproduce shape of inner rim
                 if(rr .ge. input%p(2) .and. rr .le. routfein) netz(i,j,k) = 5

              enddo
           enddo
        enddo


!---grid set? ok, count cells and alloc

        isumuw = 0.
        do i = 1, nx
           do  j = 1, ny
              do  k = 1, nz
                 isumuw        = isumuw + netz(i,j,k)**3
                 netsum(i,j,k) = isumuw
              end do
           end do
        end do
        print *, ' 7. Summe aller Unterwuerfel =', isumuw
        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

call allocspace(isumuw)

        do jth = 1, nthet
           cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
        end do

do i = 1, isumuw
   dicht(i)    = 0.
end do

!---grid done, now for the densities

!---simple sphere for quick test purposes (find r_sub etc)
        cl_mass = 0.
        halo_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              if(lp .gt. isumuw) print*,netsum(i,j,k),ntz,i,j,k,ii,jj,kk,lp
              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
              rr     = sqrt(xx2 + yy2)
              if (rr .le. router) then 
                 if(rr .le. input%p(1)) then
                    rr = rr**2 + zz2
                    rr = sqrt(rr)
                    if(rr .le. input%p(1).and. rr .ge. rinner) then
                       dicht(lp) = input%p(3)*(rr**input%p(4))
                       halo_mass = halo_mass + dicht(lp)*cc3*(dGW/ntz)**3
                    endif
                 endif
                 if (rr .ge. input%p(2)) then
                    tauV_mid = tauVrsmax *(rr/au)**(-1) !calc tauV at rr
                    surf = tauV_mid / Cext_V !convert to surface density
                    temp_mid = tstar*(fakcon*rstar**4*(aheight/14d0)**2/rr**3)**(1./7.)
                    Hscal = sqrt(boltz*temp_mid*rr**3/(grav*Mstar*protmu))
                    Height = aheight * Hscal
                    rho0 = sqrt(2/pi) * surf / Hscal
                    dicht(lp) = rho0 * exp(-zz2/(2.*(Hscal**2.)))
                    if(dicht(lp) .lt. input%p(7)) dicht(lp) = 0.0
                    if(k .eq. 50 .and. i .eq. 235 .and. j .eq. 1) print*,'z=50, x= 235, y=1, density=',dicht(lp)
                 endif
!                 if (ntz .gt. 1) then
!                    xx2    = (x(i) + ((ii - 5d-1) * dl) - starcentre(1))**2
!                    yy2    = (y(j) + ((jj - 5d-1) * dl) - starcentre(2))**2
!                    zz2    = (z(k) + ((kk - 5d-1) * dl) - starcentre(3))**2
!                    rrs    = sqrt(xx2 + yy2 + zz2)
!                    if (input%p(3) .gt. 0 .and. rrs .le. router)then ! .and. rrs .ge. rinner) then
!                       dicht(lp) = input%p(3) / rrs**input%p(4)
!                       if (dicht(lp) .lt. (a1r / rr**x1r)) dicht(lp) = a1r / rr**x1r
!                    endif
!                    if (rrs .lt. rinner) dicht(lp) = 0
!                    if (rrs .lt. rinner) print*,rrs,i,j,k,ii,jj,kk,lp,dicht(lp)
                ! endif
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
              endif
           end do
           end do
           end do
        end do
        end do
        end do

!---inner disc/halo
!---disc - r^-1 profile, optically thick
!---halo - optically thin, spatially extended

print*,'Dust mass in halo = ',halo_mass/Msun,'Msun'

!---outer disc
!---initial density set by exp(-z^2/H^2)
!---and converted from surface density
!---profile (r^-1)

end subroutine gap_disc

subroutine VYCMA

! Model clumpy and filamentary structure around a central
! source such as seen around VY CMa

use type_module
use constants
use parameter

implicit none
real*8   :: rr2d

if(idim3 .ne. 1) stop 'only available in 3d'

!---parameters
if (ibug>0) then 
   print*,' **VY CMa type structure'
   print*,' 6 parameter:'
   print'(A,d8.2)','   p(01) -- cloud density               ',input%p(1)
   print'(A,d8.2)','   p(02) -- density profile             ',input%p(2)
endif

if (input%parameter.ne.6) then 
   print*,'Incorrect number of parameter'
   stop
endif

!---setup grid

        do i=1,nx
           do j=1,ny
              do k=1,nz
                 netz(i,j,k) = 1
!                 zz = z(k)
!                 xx = x(i)
!                 yy = y(j)
!                 phi = atan(zz/xx) !check fortran angle conventions
!                 theta = atan(yy/xx)
!                 rr2d = sqrt(zz**2 + xx**2) 
                 !determine position and see if it corresponds to a feature?
              enddo
           enddo
        enddo



!---count cells & allocate memory

        isumuw = 0.
        do i = 1, nx
           do  j = 1, ny
              do  k = 1, nz
                 isumuw        = isumuw + netz(i,j,k)**3
                 netsum(i,j,k) = isumuw
              end do
           end do
        end do
        print *, ' 7. Summe aller Unterwuerfel =', isumuw
        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

        do jth = 1, nthet
           cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
        end do

        call allocspace(isumuw)

!---set densities
        do i = 1, isumuw
           dicht(i)    = 0.
        end do


end subroutine VYCMA

subroutine cav_disc(init)

! Subroutine to model a large disc with a gap
! e.g. transitional disc. Written to model
! HD169142 in particular. 

use type_module
use constants
use parameter

implicit none

        type(init_type) :: init
        real*8  :: tauVrsmax,  aheight, beta, gam
	real*8	:: cl_mass1, fakcon, Hscal, cs, Height, mu
        real*8  :: rr, rrr, tauV_mid, temp_mid, dum
        real*8  :: xx2, yy2, zz2, xx, yy,zz, dl, dr, dz
        real*8  :: x1, x2, y1,y2
        real*8  :: dl1, zz1, fak
        real*8  :: surf, surfr, zmin, ell, protmu
        real*8  :: dichtz, dichtzmin,  dichtzmin1, tauz0, dtauz
        real*8  :: halo_mass
        real*8  :: tauz01,rho0
        real*8  :: xmid0(2000), Tmid0(2000)
        real*8  :: tauVmin, routfein
        real*8, allocatable  :: ztop(:)    ! Scheibenhoehe ztop(rho.ne.0) 
        real*8, allocatable  :: zbottom(:) ! Scheibenhoehe zbottom(tau=1) 
        real*8, allocatable  :: tauzvert(:) ! tau(z) bei Rmid
        real*8  :: Rc,r_cav,r_gap,h_c,sigma_c,gamma,del_cav,sigma_acc,h

	integer	:: im, nmid0, isot, ileseTmid
	integer	:: ii,jj,kk, iz, iorg, jorg, korg,kmirror
	integer	:: ntz, ntz1, nuwz, itop,ibottom, l, i1au

!---parameters
if (ibug>0) then 
   print*,' **HD169142 type transitional disc'
   print*,'  parameter:'
   print'(A,d8.2)','   p(01) -- Outer edge of inner disc/halo          ',input%p(1)
   print'(A,d8.2)','   p(02) -- Inner edge of outer disc               ',input%p(2)
   print'(A,d8.2)','   p(03) -- Inner halo density                     ',input%p(3)
   print'(A,d8.2)','   p(04) -- Inner halo density profile             ',input%p(4)
   print'(A,d8.2)','   p(05) -- Outer disc tau_vert @ 1AU              ',input%p(5)
   print'(A,d8.2)','   p(06) -- Outer disc surface density gradient    ',input%p(6)
   print'(A,d8.2)','   p(07) -- Minimum density cut off                ',input%p(7)
   print'(A,d8.2)','   p(08) -- Disc height                            ',input%p(8)
   print'(A,d8.2)','   p(09) -- Stellar Mass                           ',input%p(9)
endif

!if (input%parameter.ne.9) then 
!   print*,'Incorrect number of parameter'
!   stop
!endif

!---testing, ignore
        tauVrsmax = input%p(5)
        protmu = 2.33 * protm
        aheight = input%p(8)
        Mstar = input%p(9) * Msun
        fakcon = boltz * tstar /(grav*mstar*protmu)
        rstar = sqrt(LQuelle/pi4/sigma/Tstar**4)
!        surf    = tauV_mid /Cext_v

R_cav = 72.*au
R_gap = 20.*au
gamma = -0.40
Rc = 106.*au
sigma_c = 10**(-1.23)
h_c = 0.04
del_cav = 10**(-0.86)

!---center of disc:
            call locat (x, nx, xorg, iorg)
            call locat (y, ny, yorg, jorg)
            call locat (z, nz, zorg, korg)
            iorg = iorg+1
            jorg = jorg+1
            korg = korg+1
       if(x(iorg).ne.xorg.or.y(jorg).ne.yorg.or.z(korg).ne.zorg) then
           print*, ' *** Star position at: '
           print*, ' iorg   x(iorg)  xorg'
           write(6,'(i6,1p2e10.2)') iorg, x(iorg), xorg
           write(6,'(i6,1p2e10.2)') jorg, y(jorg), yorg
           write(6,'(i6,1p2e10.2)') korg, z(korg), zorg
           print*, '*** Check out ! ***'
           print*, ' ' 
        endif


!---grid - first set all to 1
routfein = 30.*au

        do i=1,nx
           do j=1,ny
              do k=1,nz
                 netz(i,j,k) = 1
                 !rr = i*i + j*j + k*k
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx2    = (x(i) -xorg)**2
              yy2    = (y(j) -yorg)**2
              zz2    = (z(k) -zorg)**2
              rr     = sqrt(xx2 + yy2 + zz2)
                 !rr = sqrt(rr)
                 !rr = rr*dgw
!work on idim3=0 case for the moment


!---resolve inner rim - fine sampling 
!---needed to reproduce shape of inner
!---disc/halo properly

                 if(rr .le. r_gap .and. k .le. 3) netz(i,j,k) = 20 !needs to be enough to resolve inner rim properly i.e. lots
                 if(rr .gt.r_gap .and. rr .le. 50.*au .and. k .le. 6) netz(i,j,k) = 10 !internal structure of inner regions must be reproduced
                 if(rr .gt. 50.*au .and. rr .le. 100.*au .and. k .le. 8) netz(i,j,k) = 5
                 !if(i .eq. 1 .and. j .eq. 1 .and. k .eq. 1) netz(i,j,k) = 20



!---outer disc - finest sampling
!---needed at inner edge of
!---disc and at surface to resolve
!---photosphere properly and maintain
!---shape correctly

!                 if(rr .gt. input%p(1) .and. rr .le. input%p(2)) netz(i,j,k) = 5 !need to reproduce shape of inner rim
!                 if(rr .ge. input%p(2) .and. rr .le. routfein) netz(i,j,k) = 5

              enddo
           enddo
        enddo


!---grid set? ok, count cells and alloc

        isumuw = 0.
        do i = 1, nx
           do  j = 1, ny
              do  k = 1, nz
                 isumuw        = isumuw + netz(i,j,k)**3
                 netsum(i,j,k) = isumuw
              end do
           end do
        end do
        print *, ' 7. Summe aller Unterwuerfel =', isumuw
        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

call allocspace(isumuw)

        do jth = 1, nthet
           cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
        end do

do i = 1, isumuw
   dicht(i)    = 0.
end do

!---grid done, now for the densities

!---simple sphere for quick test purposes (find r_sub etc)
        cl_mass = 0.
        halo_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              if(lp .gt. isumuw) print*,netsum(i,j,k),ntz,i,j,k,ii,jj,kk,lp
              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
              rr     = sqrt(xx2 + yy2)
              sigma_acc = sigma_c*((rr/Rc)**gamma)*exp(-(rr/Rc)**(2-gamma))
              if (rr .ge. r_cav) then 
                 surf = sigma_acc
                 h = h_c * Rc * ((rr/Rc)**(1.2))
                 rho0 = sqrt(2/pi) * surf / H
                 dicht(lp) = rho0 * exp(-zz2/(2.*(H**2.)))
              endif
              if (rr .lt. r_cav .and. rr .ge. r_gap) then
                 surf = sigma_acc * del_cav
                 h = h_c * Rc * ((rr/Rc)**(1.2))
                 rho0 = sqrt(2/pi) * surf / H
                 dicht(lp) = rho0 * exp(-zz2/(2.*(H**2.)))
              endif

                 !if(rr .le. input%p(1)) then
                    !rr = rr**2 + zz2
                    !rr = sqrt(rr)
                  !  if(rr .le. input%p(1).and. rr .ge. rinner) then
                  !     dicht(lp) = input%p(3)*(rr**input%p(4))
                 !      halo_mass = halo_mass + dicht(lp)*cc3*(dGW/ntz)**3
                   ! endif
                 !endif
!!$                 if (rr .ge. input%p(2)) then
!!$                    tauV_mid = tauVrsmax *(rr/au)**(-1) !calc tauV at rr
!!$                    surf = tauV_mid / Cext_V !convert to surface density
!!$                    temp_mid = tstar*(fakcon*rstar**4*(aheight/14d0)**2/rr**3)**(1./7.)
!!$                    Hscal = sqrt(boltz*temp_mid*rr**3/(grav*Mstar*protmu))
!!$                    Height = aheight * Hscal
!!$                    rho0 = sqrt(2/pi) * surf / Hscal
!!$                    dicht(lp) = rho0 * exp(-zz2/(2.*(Hscal**2.)))
!!$                    if(dicht(lp) .lt. input%p(7)) dicht(lp) = 0.0
!!$                    if(k .eq. 50 .and. i .eq. 235 .and. j .eq. 1) print*,'z=50, x= 235, y=1, density=',dicht(lp)
!!$                 endif
!                 if (ntz .gt. 1) then
!                    xx2    = (x(i) + ((ii - 5d-1) * dl) - starcentre(1))**2
!                    yy2    = (y(j) + ((jj - 5d-1) * dl) - starcentre(2))**2
!                    zz2    = (z(k) + ((kk - 5d-1) * dl) - starcentre(3))**2
!                    rrs    = sqrt(xx2 + yy2 + zz2)
!                    if (input%p(3) .gt. 0 .and. rrs .le. router)then ! .and. rrs .ge. rinner) then
!                       dicht(lp) = input%p(3) / rrs**input%p(4)
!                       if (dicht(lp) .lt. (a1r / rr**x1r)) dicht(lp) = a1r / rr**x1r
!                    endif
!                    if (rrs .lt. rinner) dicht(lp) = 0
!                    if (rrs .lt. rinner) print*,rrs,i,j,k,ii,jj,kk,lp,dicht(lp)
                ! endif
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
!              endif
           end do
           end do
           end do
        end do
        end do
        end do

!---inner disc/halo
!---disc - r^-1 profile, optically thick
!---halo - optically thin, spatially extended

print*,'Dust mass in halo = ',halo_mass/Msun,'Msun'

!---outer disc
!---initial density set by exp(-z^2/H^2)
!---and converted from surface density
!---profile (r^-1)

end subroutine cav_disc

subroutine var_disc(init)
use type_module
use constants
use parameter

implicit none

        type(init_type) :: init
        real*8  :: tauVrsmax,  aheight, beta, gam
	real*8	:: cl_mass1, fakcon, Hscal, cs, Height, mu
        real*8  :: rr, rrr, tauV_mid, temp_mid, dum
        real*8  :: xx2, yy2, zz2, xx, yy,zz, dl, dr, dz
        real*8  :: x1, x2, y1,y2
        real*8  :: dl1, zz1, fak
        real*8  :: surf, surfr, zmin, ell, protmu
        real*8  :: dichtz, dichtzmin,  dichtzmin1, tauz0, dtauz
        real*8  :: halo_mass
        real*8  :: tauz01,rho0
        real*8  :: xmid0(2000), Tmid0(2000)
        real*8  :: tauVmin, routfein, Hmax
        real*8, allocatable  :: ztop(:)    ! Scheibenhoehe ztop(rho.ne.0) 
        real*8, allocatable  :: zbottom(:) ! Scheibenhoehe zbottom(tau=1) 
        real*8, allocatable  :: tauzvert(:) ! tau(z) bei Rmid
        real*8  :: Rc,r_cav,r_gap,h_c,sigma_c,gamma,del_cav,sigma_acc,h

	integer	:: im, nmid0, isot, ileseTmid
	integer	:: ii,jj,kk, iz, iorg, jorg, korg,kmirror
	integer	:: ntz, ntz1, nuwz, itop,ibottom, l, i1au

!---parameters
if (ibug>0) then 
   print*,' **Inner disc only'
   print*,'  parameter:'
!   print'(A,d8.2)','   p(01) -- Outer edge of inner disc/halo          ',input%p(1)
!   print'(A,d8.2)','   p(02) -- Inner edge of outer disc               ',input%p(2)
!   print'(A,d8.2)','   p(03) -- Inner halo density                     ',input%p(3)
   print'(A,d8.2)','   p(04) -- Accretion luminosity Lacc/L* [0.1]     ',input%p(4)
   print'(A,d8.2)','   p(05) -- Disc tau_vert @ 1AU [10^4]             ',input%p(5)
   print'(A,d8.2)','   p(06) -- Disc surface density gradient          ',input%p(6)
   print'(A,d8.2)','   p(07) -- Minimum density cut off  [1d-28]       ',input%p(7)
   print'(A,d8.2)','   p(08) -- Disc height modifier [4.5]             ',input%p(8)
   print'(A,d8.2)','   p(09) -- Stellar Mass   [0.75]                  ',input%p(9)
endif

!if (input%parameter.ne.9) then 
!   print*,'Incorrect number of parameter'
!   stop
!endif

!---testing, ignore
        tauVrsmax = input%p(5)
        protmu = 2.33 * protm
        aheight = input%p(8)
        Mstar = input%p(9) * Msun
        fakcon = boltz * tstar /(grav*mstar*protmu)
        rstar = sqrt(LQuelle/pi4/sigma/Tstar**4)
!        surf    = tauV_mid /Cext_v
        print*,Cext_v

        Lacc = input%p(4)
!R_cav = 72.*au
!R_gap = 20.*au
!gamma = -0.40
!Rc = 106.*au
!sigma_c = 10**(-1.23)
!h_c = 0.04
!del_cav = 10**(-0.86)

!---center of disc:
            call locat (x, nx, xorg, iorg)
            call locat (y, ny, yorg, jorg)
            call locat (z, nz, zorg, korg)
            iorg = iorg+1
            jorg = jorg+1
            korg = korg+1
       if(x(iorg).ne.xorg.or.y(jorg).ne.yorg.or.z(korg).ne.zorg) then
           print*, ' *** Star position at: '
           print*, ' iorg   x(iorg)  xorg'
           write(6,'(i6,1p2e10.2)') iorg, x(iorg), xorg
           write(6,'(i6,1p2e10.2)') jorg, y(jorg), yorg
           write(6,'(i6,1p2e10.2)') korg, z(korg), zorg
           print*, '*** Check out ! ***'
           print*, ' ' 
        endif


!---grid - first set all to 1
routfein = 0.75*au

        do i=1,nx
           do j=1,ny
              do k=1,nz
                 netz(i,j,k) = 1
                 !rr = i*i + j*j + k*k
 !             lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx2    = (x(i) -xorg)**2
              yy2    = (y(j) -yorg)**2
              zz2    = (z(k) -zorg)**2
              rr     = sqrt(xx2 + yy2)! + zz2)
                 !rr = sqrt(rr)
                 !rr = rr*dgw
!work on idim3=0 case for the moment


!---resolve inner rim - fine sampling 
!---needed to reproduce shape of inner
!---disc/halo properly

                 if(rr .le. rinner .and. rr .gt. 5d12 .and. k .le. 3) netz(i,j,k) = 10 !needs to be enough to resolve inner rim properly i.e. lots
                 if(rr .gt.rinner .and. rr .le. routfein .and. k .le. 6) netz(i,j,k) = 5 !internal structure of inner regions must be reproduced
                 !if(rr .gt. 50.*au .and. rr .le. 100.*au .and. k .le. 8) netz(i,j,k) = 5
                 !if(i .eq. 1 .and. j .eq. 1 .and. k .eq. 1) netz(i,j,k) = 20



!---outer disc - finest sampling
!---needed at inner edge of
!---disc and at surface to resolve
!---photosphere properly and maintain
!---shape correctly

!                 if(rr .gt. input%p(1) .and. rr .le. input%p(2)) netz(i,j,k) = 5 !need to reproduce shape of inner rim
!                 if(rr .ge. input%p(2) .and. rr .le. routfein) netz(i,j,k) = 5

              enddo
           enddo
        enddo


!---grid set? ok, count cells and alloc

        isumuw = 0.
        do i = 1, nx
           do  j = 1, ny
              do  k = 1, nz
                 isumuw        = isumuw + netz(i,j,k)**3
                 netsum(i,j,k) = isumuw
              end do
           end do
        end do
        print *, ' 7. Summe aller Unterwuerfel =', isumuw
        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

call allocspace(isumuw)

        do jth = 1, nthet
           cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
        end do

do i = 1, isumuw
   dicht(i)    = 0.
end do

!---grid done, now for the densities

!---simple sphere for quick test purposes (find r_sub etc)
        cl_mass = 0.
        halo_mass = 0.
        Hmax = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              if(lp .gt. isumuw) print*,netsum(i,j,k),ntz,i,j,k,ii,jj,kk,lp
              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
              rr     = sqrt(xx2 + yy2)
              if(rr .ge. rinner .and. rr .le. router) then
                    tauV_mid = tauVrsmax * ((rr/au)**(0.5)) !calc tauV at rr
                    surf = tauV_mid / Cext_V !convert to surface density
                    temp_mid = tstar*(fakcon*rstar**4*(aheight/14d0)**2/rr**3)**(1./7.)
                    Hscal = sqrt(boltz*temp_mid*rr**3/(grav*Mstar*protmu))
                    Height = aheight * Hscal
                    rho0 = sqrt(2/pi) * surf / Hscal
                    dicht(lp) = rho0 * exp(-zz2/(2.*(Hscal**2.)))
                    if(dicht(lp) .lt. input%p(7)) dicht(lp) = 0.0   
                    if(Hscal .gt. Hmax) Hmax = Hscal
              endif
!!$              sigma_acc = sigma_c*((rr/Rc)**gamma)*exp(-(rr/Rc)**(2-gamma))
!!$              if (rr .ge. r_cav) then 
!!$                 surf = sigma_acc
!!$                 h = h_c * Rc * ((rr/Rc)**(1.2))
!!$                 rho0 = sqrt(2/pi) * surf / H
!!$                 dicht(lp) = rho0 * exp(-zz2/(2.*(H**2.)))
!!$              endif
!!$              if (rr .lt. r_cav .and. rr .ge. r_gap) then
!!$                 surf = sigma_acc * del_cav
!!$                 h = h_c * Rc * ((rr/Rc)**(1.2))
!!$                 rho0 = sqrt(2/pi) * surf / H
!!$                 dicht(lp) = rho0 * exp(-zz2/(2.*(H**2.)))
!!$              endif

                 !if(rr .le. input%p(1)) then
                    !rr = rr**2 + zz2
                    !rr = sqrt(rr)
                  !  if(rr .le. input%p(1).and. rr .ge. rinner) then
                  !     dicht(lp) = input%p(3)*(rr**input%p(4))
                 !      halo_mass = halo_mass + dicht(lp)*cc3*(dGW/ntz)**3
                   ! endif
                 !endif
!!$                 if (rr .ge. input%p(2)) then
!!$                    tauV_mid = tauVrsmax *(rr/au)**(0.5) !calc tauV at rr
!!$                    surf = tauV_mid / Cext_V !convert to surface density
!!$                    temp_mid = tstar*(fakcon*rstar**4*(aheight/14d0)**2/rr**3)**(1./7.)
!!$                    Hscal = sqrt(boltz*temp_mid*rr**3/(grav*Mstar*protmu))
!!$                    Height = aheight * Hscal
!!$                    rho0 = sqrt(2/pi) * surf / Hscal
!!$                    dicht(lp) = rho0 * exp(-zz2/(2.*(Hscal**2.)))
!!$                    if(dicht(lp) .lt. input%p(7)) dicht(lp) = 0.0
!!$                    if(k .eq. 50 .and. i .eq. 235 .and. j .eq. 1) print*,'z=50, x= 235, y=1, density=',dicht(lp)
!!$                 endif
!                 if (ntz .gt. 1) then
!                    xx2    = (x(i) + ((ii - 5d-1) * dl) - starcentre(1))**2
!                    yy2    = (y(j) + ((jj - 5d-1) * dl) - starcentre(2))**2
!                    zz2    = (z(k) + ((kk - 5d-1) * dl) - starcentre(3))**2
!                    rrs    = sqrt(xx2 + yy2 + zz2)
!                    if (input%p(3) .gt. 0 .and. rrs .le. router)then ! .and. rrs .ge. rinner) then
!                       dicht(lp) = input%p(3) / rrs**input%p(4)
!                       if (dicht(lp) .lt. (a1r / rr**x1r)) dicht(lp) = a1r / rr**x1r
!                    endif
!                    if (rrs .lt. rinner) dicht(lp) = 0
!                    if (rrs .lt. rinner) print*,rrs,i,j,k,ii,jj,kk,lp,dicht(lp)
                ! endif
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
!              endif
           end do
           end do
           end do
        end do
        end do
        end do

print*,'Max. scale height = ',Hmax

end subroutine var_disc


subroutine M17shell(init)

use type_module
use constants
use parameter

implicit none

type(init_type) :: init
integer :: nstar=1
integer :: starpos(3),ntz
real*8  :: starcentre(3),rrs,distmod
real*8	:: xx2,xx
real*8	:: yy2,yy
real*8	:: zz2,zz		
real*8	:: dl,dgw2
real*8	:: rr,rr2
integer	:: ii, jj, kk,ntsum

if(idim3 .ne. 1) stop 'only available in 3d'

!parameters
if (ibug>0) then 
   print*,' **Single star with thin spherical shell'
   print*,' 3 parameter:'
   print'(A,d8.2)','   p(01) -- shell density               ',input%p(1)
   print'(A,d8.2)','   p(02) -- density profile             ',input%p(2)
   print'(A,d8.2)','   p(05) -- cell subdivision at Rin     ',input%p(3)
!   print'(A,d8.2)','   p(06) -- star x-position             ',input%p(4)
!   print'(A,e8.2)','   p(06) -- shell inner radius [cm]     ',input%p(7)
!   print'(A,e8.2)','   p(07) -- shell outer radius [cm]     ',input%p(8)
!   print'(A,e8.2)','   p(08) --          ',input%p(8)
!   print'(A,e8.2)','   p(09) --     ',input%p(9)
!   print'(A,e8.2)','   p(10) --    ',input%p(10)

end if 

if (input%parameter.ne.3) then 
   print*,'Incorrect number of parameter'
   stop
endif

print*,'position of star at [x,y,z]',xorg,yorg,zorg,' cm'
print*,cc3

a1r = input%p(1)
x1r = input%p(2)

!setup grid
iexpgw1 = input%p(3)
if(iexpgw1 .lt. 0) stop 'iexpgw1 < 0 cannot have negative cell division'
dgw2 = dgw/2.

        do i=1,nx
        do j=1,ny
        do k=1,nz
           netz(i,j,k) = 1
           rr = (x(i)+dgw2 - xorg)**2 + (y(j)+dgw2 - yorg)**2 + (z(k)+dgw2 - zorg)**2
           rr = sqrt(rr)
!           if( j .eq. 4 .and. k .eq. 4) print*,rr
           if( rr .gt. (rinner-dgw2).and. iexpgw1 .gt. 0) netz(i,j,k) = 2**(iexpgw1) ! .and. rr .le. (rinner+dgw2)
           if( rr .gt. (rinner+dgw2).and. iexpgw1 .ge. 1) netz(i,j,k) = 2**(iexpgw1-1) ! .and. rr .le. (rinner+dgw+dgw2)
           if( rr .gt. (rinner+dgw+dgw2) .and. iexpgw1 .ge. 2) netz(i,j,k) = 2**(iexpgw1-2) !.and. rr .le. (rinner+(2*dgw)+dgw2)
           if( rr .gt. (rinner+(2*dgw)+dgw2).and. iexpgw1 .ge. 3) netz(i,j,k) = 2**(iexpgw1-3) ! .and. rr .le. (rinner+(3*dgw)+dgw2)
           if( rr .gt. (rinner+(3*dgw)+dgw2).and. iexpgw1 .ge. 4) netz(i,j,k) = 2**(iexpgw1-4) !  .and. rr .le. (rinner+(4*dgw)+dgw2)
!           if(netz(i,j,k) .eq. 0) print*,i,j,k,rr
        enddo
        enddo
        enddo

        isumuw = 0.
        do i = 1, nx
           do  j = 1, ny
              do  k = 1, nz
                 isumuw        = isumuw + netz(i,j,k)**3
                 netsum(i,j,k) = isumuw
              end do
           end do
        end do
        print *, ' 7. Summe aller Unterwuerfel =', isumuw
        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

        do jth = 1, nthet
           cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
        end do

call allocspace(isumuw)

do i = 1, isumuw
   dicht(i)    = 0.
end do

!set density
        cl_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              if(lp .gt. isumuw) print*,netsum(i,j,k),ntz,i,j,k,ii,jj,kk,lp
              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
              rr     = sqrt(xx2 + yy2 + zz2)
              if (rr .ge. rinner .and. rr .le. router) then 
                 dicht(lp) = a1r / (rr**x1r)
!                 if(ntz .eq. 1) print*,lp,i,j,k,ii,jj,kk,rr,dicht(lp),'check gridding!'
              endif
              cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
           end do
           end do
           end do
        end do
        end do
        end do

end subroutine M17shell


!!$subroutine M17clumps(init)
!!$!generates density for a spherical shell consisting
!!$!of a diffuse halo and dense clumps
!!$
!!$
!!$use type_module
!!$use constants
!!$use parameter
!!$
!!$implicit none
!!$
!!$type(init_type) :: init
!!$type(float_vector),allocatable :: clumps
!!$integer :: nstar=1
!!$integer :: starpos(3),ntz
!!$real*8  :: starcentre(3),rrs,distmod
!!$real*8	:: xx2,xx,masslim
!!$real*8	:: yy2,yy
!!$real*8	:: zz2,zz		
!!$real*8	:: dl,dgw2
!!$real*8	:: rr,rr2,dichttemp
!!$real*8,allocatable :: rrc
!!$integer	:: ii, jj, kk,ntsum,iclump
!!$
!!$if(idim3 .ne. 1) stop 'only available in 3d'
!!$
!!$!parameters
!!$if (ibug>0) then 
!!$   print*,' **Single star with clumpy spherical shell'
!!$   print*,' 3 parameter:'
!!$   print'(A,d8.2)','   p(01) -- max shell mass              ',input%p(1)
!!$   print'(A,d8.2)','   p(02) -- density profile             ',input%p(2)
!!$   print'(A,d8.2)','   p(03) -- cell subdivision in clump   ',input%p(3)
!!$   print'(A,d8.2)','   p(04) -- number of clumps            ',input%p(4)
!!$   print'(A,e8.2)','   p(05) -- halo density                ',input%p(5)
!!$   print'(A,e8.2)','   p(06) -- max clump density           ',input%p(6)
!!$   print'(A,e8.2)','   p(07) -- clump density profile       ',input%p(7)
!!$!   print'(A,e8.2)','   p(09) --     ',input%p(9)
!!$!   print'(A,e8.2)','   p(10) --    ',input%p(10)
!!$
!!$end if 
!!$
!!$if (input%parameter.ne.7) then 
!!$   print*,'Incorrect number of parameter'
!!$   stop
!!$endif
!!$
!!$print*,'position of star at [x,y,z]',xorg,yorg,zorg,' cm'
!!$print*,cc3
!!$
!!$!a1r = 
!!$a1r = input%p(5)
!!$x1r = input%p(2)
!!$iexpgw1 = input%p(3)
!!$netz = 1
!!$masslim = input%p(1)
!!$nclump = input%p(4)
!!$allocate(clumps(nclump))
!!$allocate(rrc(nclump))
!!$!generate some clumps and setup grid
!!$do iclump = 1,nclump
!!$111 continue
!!$   call random_num(ran,0)
!!$   r = ran*(router - rinner) + rinner!(ran*(input%p(3)**input%p(8) - input%p(2)**input%p(8)))**(1./input%p(8)) + input%p(2)
!!$   call random_num(ran,0)
!!$   phi = 2 * pi * ran
!!$   call random_num(ran,0)
!!$   costheta = (-1.+2.*ran)
!!$   !theta = pi/2.+input%p(4)/180.*pi*(-1.+2.*ran)
!!$   zz = r*costheta + zorg
!!$   xx = xorg+r*sqrt(1.-costheta**2) * cos(phi) 
!!$   yy = yorg+r*sqrt(1.-costheta**2) * sin(phi)
!!$   if (yy .gt. y(ny+1) .or. zz .gt. z(nz+1) .or. xx .gt. x(nx+1) .or. (xx .or. yy .or. zz) .lt. 0) goto 111
!!$   i = int(xx/dgw) +1
!!$   j = int(yy/dgw) +1
!!$   k = int(zz/dgw) +1
!!$   clumps(iclump)%x = xx
!!$   clumps(iclump)%y = yy
!!$   clumps(iclump)%z = zz
!!$   do ii = i-1,i+1
!!$      do jj = j-1,j+1
!!$         do kk = k-1,k+1
!!$            if(ii .eq. i .and. jj .eq. j .and. kk .eq. k .and. netz(ii,jj,kk) .ne. iexpgw1) then
!!$               netz(ii,jj,kk) = iexpgw1
!!$            elseif(netz(ii,jj,kk) .eq. 1) then
!!$               netz(ii,jj,kk) = int(iexpgw1 / 2)
!!$            endif
!!$         enddo
!!$      enddo
!!$   enddo
!!$enddo
!!$
!!$isumuw = 0.
!!$do i = 1, nx
!!$   do  j = 1, ny
!!$      do  k = 1, nz
!!$         isumuw        = isumuw + netz(i,j,k)**3
!!$         netsum(i,j,k) = isumuw
!!$      end do
!!$   end do
!!$end do
!!$print *, ' 7. Summe aller Unterwuerfel =', isumuw
!!$if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'
!!$
!!$do jth = 1, nthet
!!$   cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
!!$end do
!!$
!!$call allocspace(isumuw)
!!$
!!$do i = 1, isumuw
!!$   dicht(i)    = 0.
!!$end do
!!$
!!$!set density
!!$        cl_mass = 0.
!!$        do i = 1, nx
!!$        do j = 1, ny
!!$        do k = 1, nz
!!$           ntz = netz(i,j,k)
!!$           dl  = dGW / ntz
!!$           do ii = 1, ntz
!!$           do jj = 1, ntz
!!$           do kk = 1, ntz
!!$              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
!!$              if(lp .gt. isumuw) print*,netsum(i,j,k),ntz,i,j,k,ii,jj,kk,lp
!!$              xx    = (x(i) + (ii - 5d-1) * dl)
!!$              yy    = (y(j) + (jj - 5d-1) * dl)
!!$              zz    = (z(k) + (kk - 5d-1) * dl)
!!$              xx2 = (xx-xorg)*(xx-xorg)
!!$              yy2 = (yy-yorg)*(yy-yorg)
!!$              zz2 = (zz-zorg)*(zz-zorg)
!!$              rr     = sqrt(xx2 + yy2 + zz2)
!!$              if (rr .ge. rinner .and. rr .le. router) then 
!!$                 dicht(lp) = a1r / (rr**x1r)
!!$                 if(ntz .gt. 1) then !find closest clump and set density accordingly
!!$                    !array search
!!$                    do iclump = 1,nclump
!!$                       rrc(iclump) =  ((xx - clumps(iclump)%x)**2) + ((yy - clumps(iclump)%y)**2)&
!!$& + ((zz - clumps(iclump)%z)**2)
!!$                    enddo
!!$                    dichttemp = (input%p(6) ** x1r)/((minval(rrc))**input%p(7))
!!$                    if (dichttemp .gt. dicht(lp)) dicht(lp = dichttemp
!!$                 endif
!!$!                 if(ntz .eq. 1) print*,lp,i,j,k,ii,jj,kk,rr,dicht(lp),'check gridding!'
!!$              endif
!!$              cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
!!$           end do
!!$           end do
!!$           end do
!!$        end do
!!$        end do
!!$        end do
!!$
!!$dicht = dicht/(clmass/masslim) !rescale densities to ensure correct dust mass
!!$
!!$deallocate(clumps)
!!$deallocate(rrc)
!!$end subroutine M17clumps


subroutine clumpycloud(init)
use type_module
use constants
use parameter

implicit none

type(init_type) :: init
type(float_vector),allocatable :: clumps(:)
!integer :: nstar=1,starpos(3),
integer :: ntz
integer :: clump_t(nx,ny,nz)
real*8	:: r,r1,r2,r3,theta,phi,costheta,r_clump,f_fac,duw
integer :: idim=0,iklump,nclump,clump_type,a,b,c,d,e
real*8  :: starcentre(3),rrs,distmod,opening_angle
real*8	:: xx2,xx,masslim
real*8	:: yy2,yy,rrp1
real*8	:: zz2,zz,rrm1		
real*8	:: dl,dgw2,ran
real*8	:: rr,rr2,dichttemp,totmass,mass_fac
real*8,allocatable :: rrc(:)
integer	:: ii, jj, kk,ntsum,iclump


!----------------------------------------------------------
!- Generates a cuboid filled with dust. Dust can be 
!- distributed either homogeneously or in clumps. Clumps
!- can take 3 forms: 1) Entire GW filled with dust (blocks)
!- 2) Spherical cloud of constant density and fixed radius
!- 3) Pressure constrained clouds. Cases 1 & 2 have sharp
!- edges while case 3 produces smooth dust. Can also 
!- specify a density ratio for a diffuse dust phase (1&2) 
!- which is interpreted as a minimum density in case 3.
!- The source can be place in an arbitrary x-cell but is
!- located in the middle of the yz plane.
!-
!- parameters required: 
!- iexpgw1
!- type of clumps (blocks, spheres, pressure constrained)
!- density of second phase (ratio)
!- filing factor/R_C
!- seed
!- nclump
!- star xposition
!- total mass
!---------------------------------------------------------

         print*,' **clumpy cloud density distribution'
         print*,' 8 parameter '
         print*,' p(1) star x-position (cell number)',input%p(1)
         print*,' p(2) Density ratio                ',input%p(2)
         print*,' p(3) iexpgw1                      ',input%p(3)
         print*,' p(4) total dust mass              ',input%p(4)
         print*,' p(5) number of clumps             ',input%p(5) !set to -1 for homogeneous case
         print*,' p(6) filling factor               ',input%p(6)
         print*,' p(7) clump type: 0=block,1=sphere,2=pressure constrained   ',input%p(7) !set to -1 for spherical shell
         print*,' p(8) random seed           ',input%p(8)
         if (input%parameter.ne.8) then
           print*,'wrong number of parameter'
           stop
         endif

         a1r = input%p(1)
         x1r = input%p(2)
        iexpgw1 = input%p(3)
        totmass = input%p(4)*Msun
        nclump  = input%p(5)
        f_fac   = input%p(6)
        clump_type = int(input%p(7)) !input%p(8)
        idim = int(input%p(8))

        r_clump = pi*4d0*nclump
        r_clump = 1d0/r_clump
        r_clump = r_clump * 3d0 * f_fac * (x(nx)*y(ny)*z(nz))
        r_clump = r_clump**(1d0/3d0)
        print*,'Clump radius is ',r_clump,' cm '

!        if (dgw/iexpgw1 .gt. r_clump) stop 'clumps not well resolved, increase iexpgw1'
!        print*,'1'
        allocate(clumps(nclump))
        allocate(rrc(nclump))
        clumps(:)%x=0d0
        clumps(:)%y=0d0
        clumps(:)%z=0d0
        rrc=0d0

do i = 1, nx
do j = 1, ny
do k = 1, nz
   netz(i,j,k) = 1
end do
end do
end do

!Clumps should be uniformly distributed in cartesian co-ordinates

do iklump=1,int(input%p(5))
   call random_num(ran,idim)
   xx = ran*x(nx)

   call random_num(ran,idim)
   yy = y(ny) * ran

   call random_num(ran,idim)
   zz = (z(nz)*ran)

   i = int(xx/dgw)+1
   j = int(yy/dgw)+1
   k = int(zz/dgw)+1
   rr = sqrt((xx-xorg)**2 + (yy-yorg)**2)
   r3 = sqrt((xx-xorg)**2 + (yy-yorg)**2 + (zz-zorg)**2)
   clump_t(i,j,k) = clump_t(i,j,k) + 1 !allow for multiple clumps in same place -> higher density
   clumps(iklump)%x = xx
   clumps(iklump)%y = yy
   clumps(iklump)%z = zz
   if( clump_type .gt. 0) then
   do ii = i-1,i+1
      do jj = j-1,j+1
         do kk = k-1,k+1
            if (ii.gt.0 .and.jj.gt. 0 .and.kk.gt. 0 .and.ii.le.nx.and.ny.le.ny.and.kk.le.nz) netz(ii,jj,kk) = int(iexpgw1/2)
         enddo
      enddo
   enddo
   endif
   netz(i,j,k) = iexpgw1
end do

isumuw = 0.
do i = 1, nx
do j = 1, ny
do k = 1, nz
   isumuw        = isumuw + netz(i,j,k)**3
   netsum(i,j,k) = isumuw
end do
end do
end do

!if (ibug>0) 
print *, ' 6. Summe aller Unterwuerfel =', isumuw

call allocspace(isumuw)
!        print*,'5'
dicht = 0d0
cl_mass= 0d0

!print*, 'Number of unique clumps = ',count(clump_t.gt.0)
!print*, 'Number of higher mass clumps = ',count(clump_t.gt.1)

print*,'i      Number of clumps generated i times or more'
do i=1,11
   print*,i-1,count(clump_t.gt.i-1)
enddo

do i = 1,nx
   do j = 1,ny
      do k = 1,nz
         ntz = netz(i,j,k)
         duw = dgw/ntz
         if (nclump .gt. 0) then
            if (clump_t(i,j,k) .gt. 0) then !clump centred here

               do ii = 1,ntz
                  do jj = 1,ntz
                     do kk = 1,ntz
                        xx = x(i) + (ii-0.5)*duw -xorg
                        yy = y(j) + (jj-0.5)*duw -yorg
                        zz = z(k) + (kk-0.5)*duw -zorg
                        r3 = sqrt(xx**2 + yy**2 + zz**2)
                        rr = ((ii-0.5)*duw - dgw/2.)**2 + ((jj-0.5)*duw - dgw/2.)**2 + ((kk-0.5)*duw - dgw/2.)**2
                        rr = sqrt(rr)
                        lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
                        dicht(lp) = clump_t(i,j,k)!1!/(1+((rr*rr/(r_clump*r_clump))))
                        if(clump_type .eq. 1 .and. rr .gt. r_clump) then 
                            dicht(lp) = 0d0
                         elseif(clump_type .eq.2) then !pressure constrained formula needed
                            dicht(lp) = clump_t(i,j,k)/(1+((rr*rr/(r_clump*r_clump))))
                         endif
                         if (dicht(lp) .lt. x1r) dicht(lp) = x1r
                        cl_mass = cl_mass + dicht(lp) * duw**3
                     enddo
                  enddo
               enddo

         elseif (clump_t(i,j,k) .ne. 1) then !clump not centred in cell
            if(clump_type .gt. 0) then !spherical clouds
               do ii = 1,ntz
                  do jj = 1,ntz
                     do kk = 1,ntz
                        xx = x(i) + (ii-0.5)*duw
                        yy = y(j) + (jj-0.5)*duw
                        zz = z(k) + (kk-0.5)*duw
                        r3 = sqrt(xx**2 + yy**2 + zz**2)
                        do iklump = 1,nclump
                           rrc(iklump) = ((clumps(iklump)%x - xx)**2 +  &
&                                         (clumps(iklump)%y - yy)**2 +  &
&                                         (clumps(iklump)%z - zz)**2)

                        if (clump_type .eq.2) rrc(iklump) = rrc(iklump)/&
&                          (dble(clump_t(int((clumps(iklump)%x)/dgw)+1, &
&                                        int((clumps(iklump)%y)/dgw)+1, &
&                                        int((clumps(iklump)%z)/dgw)+1)))
                        enddo
                        rr = minval(rrc) !find nearest clumps
                        if ( clump_type .eq.2) then
                           e = minloc(rrc,1)
                           b = (int((clumps(e)%x)/dgw)+1)
                           c = (int((clumps(e)%y)/dgw)+1)
                           d = (int((clumps(e)%z)/dgw)+1)
                           a = clump_t( b , c , d ) 
                           rr = rr * (dble(a))
                        endif
                        rr = sqrt(rr)
                        lp = netsum(i,j,k) -ntz**3 +ntz**2*(ii - 1) + &
&                                                    ntz * (jj - 1) + kk

                        if(clump_type .eq.2 .or. rr .lt. r_clump) dicht(lp) =&
&       clump_t(int((clumps(minloc(rrc,1))%x)/dgw)+1, &
&               int((clumps(minloc(rrc,1))%y)/dgw)+1, &
&               int((clumps(minloc(rrc,1))%z)/dgw)+1)
                        if(clump_type .eq. 2) dicht(lp) = &
&                           dicht(lp)/(1+((rr*rr/(r_clump*r_clump))))
                        if (dicht(lp) .lt. x1r) dicht(lp) = x1r
                        cl_mass = cl_mass + dicht(lp) * duw**3
                     enddo
                  enddo
               enddo
            else !blocky clumps, must be second phase
               do ii = 1,ntz
                  do jj = 1,ntz
                     do kk = 1,ntz
                        !xx = x(i) + (ii-0.5)*duw
                        !yy = y(j) + (jj-0.5)*duw
                        !zz = z(k) + (kk-0.5)*duw
                        lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
                        if (dicht(lp) .lt. x1r) dicht(lp) = x1r
                        cl_mass = cl_mass + dicht(lp) * duw**3
                     enddo
                  enddo
               enddo
            endif
         endif
            else !homogeneous case
               do ii = 1,ntz
                  do jj = 1,ntz
                     do kk = 1,ntz
                        !xx = x(i) + (ii-0.5)*duw -xorg
                        !yy = y(j) + (jj-0.5)*duw -yorg
                        !zz = z(k) + (kk-0.5)*duw -zorg
                        !r3 = sqrt(xx**2 + yy**2 + zz**2)
                        !rr2 = sqrt(xx**2 + yy**2)
                        lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
                        dicht(lp) = 1
                        cl_mass = cl_mass + dicht(lp) * duw**3
                     enddo
                  enddo
               enddo
            endif
      enddo
   enddo
enddo

!        print*,'6'
!renormalise total mass to input value.
mass_fac = totmass/cl_mass
dicht = dicht*mass_fac
 cl_mass = cl_mass * mass_fac

!set xorg to correct location for launching photons
xorg = x(int(a1r)) + dgw/2.
!        print*,'7'

deallocate(clumps)
deallocate(rrc)

!print*,'clumps end',x

end subroutine clumpycloud
!
! ---------------------------------------------
!


subroutine space_2phase_torus(init)
use parameter
use constants
use type_module

implicit none 
type(init_type)         :: init
real*8	:: xx,yy,zz,xx2,yy2,zz2,rr,dl
integer	:: kk,ii,jj,ntz

integer :: clump_t(nx,ny,nz)
real*8  :: clump_x(nx,ny,nz)
real*8  :: clump_y(nx,ny,nz)
real*8  :: clump_z(nx,ny,nz)
real*8	:: r,r1,r2,r3,theta,phi,costheta,r_clump,clump_profile
integer :: idim,iklump
real*8  :: ran,temp1,temp2
real*8  :: density_clump,density_2phase
integer :: ninteg
real*8  :: integ
integer :: memory

!initialize random number sequenze
idim = 0
iexpGW1=3
!   ---------------------------------------------------------------------------
!   Dichteverteilung mit Klumpung. 

   print*,' **clumpy torus density distribution'
   print*,' 8 parameter:'
   print'(A,1pe11.2)','   p(1) -- Av Cloud                    ',input%p(1)
   print'(A,1pe11.2)','   p(2) -- cTinner                     ',input%p(2)
   print'(A,1pe11.2)','   p(3) -- TOR end     [cm]            ',input%p(3)
   print'(A,1pe11.2)','   p(4) -- TOR opening angle [DEG]     ',input%p(4)
   print'(A,1pe11.2)','   p(5) -- TOR number clouds           ',input%p(5)
   print'(A,1pe11.2)','   p(6) -- TOR max size clouds [DGW]   ',input%p(6)
   print'(A,1pe11.2)','   p(7) -- Total Av 2phase medium      ',input%p(7)
   print'(A,1pe11.2,A)',' p(8) -- 2phase density profile r**(-',input%p(8),')'

rinner = rinner


! *** clump_profile: 
! Klumpen werden zufaellig in r-verteilt wenn clump_profile =0 dann
! gibt es mehr Klumpen innen als aussen weil der Raum in dem Klumpen
! Verteilt werden kleiner ist. Bei clump_profile =2 haben wir gleich
! viele Klumpen pro Volumen innen wie aussen im Torus.

if (input%parameter.ne.9) then
   if (input%parameter.eq.8) then 
      clump_profile = 2.
   else
      print*,'Incorrect number of parameter'
      stop
   end if
else
   print'(A,1pe11.2)','   p(9) -- TOR cloud profile 2(uniform)',input%p(9)
   clump_profile = input%p(9)
endif

ninteg = max(nx,ny,nz)*iexpGW1*100
integ = 0
do i=1,ninteg
   r = (router-rinner)*i*1./ninteg+rinner
   integ = integ + (r/rinner)**(-input%p(8))*(router-rinner)/ninteg
end do
density_2phase = 1./C_abs_ac(ivisd)/integ*input%p(7)
density_clump = input%p(1)*1./C_abs_ac(ivisd)/dgw/input%p(6)

! Setting netz to zero
do i = 1, nx
do j = 1, ny
do k = 1, nz
   netz(i,j,k) = 1
   xx = (i-0.5)*dgw
   yy = (j-0.5)*dgw
   zz = (k-0.5)*dgw
   rr = sqrt((xx-xorg)**2+(yy-yorg)**2+(zz-zorg)**2)
   if (abs(rr-rinner).le.2.1*dgw) then 
      netz(i,j,k) = iexpGW1
   end if
end do
end do
end do
! TOR region
do iklump=1,int(input%p(5))
   call random_num(ran,idim)
   r = (ran*(router**clump_profile - rinner**clump_profile))**(1./clump_profile) + rinner
   !r = (ran*(router**2. - rinner**2.))**(1./2.) + rinner

   !r = (ran*(router - rinner)) + rinner
   call random_num(ran,idim)
   phi = 2 * pi * ran
   call random_num(ran,idim)
   ! costheta = (-1.+2.*ran)*(1.-cos(input%p(4)/180.*pi))
   theta = pi/2.+input%p(4)/180.*pi*(-1.+2.*ran)
   costheta = cos(theta)
   xx = xorg+r*sqrt(1.-costheta**2) * cos(phi) 
   yy = yorg+r*sqrt(1.-costheta**2) * sin(phi)
   zz = zorg+r*costheta
   i = int(xx/dgw)+1
   j = int(yy/dgw)+1
   k = int(zz/dgw)+1
   rr = sqrt((xx-xorg)**2 + (yy-yorg)**2)
   r3 = sqrt((xx-xorg)**2 + (yy-yorg)**2 + (zz-zorg)**2)
   do ii=-int(input%p(6)-1),int(input%p(6)-1)
   do jj=-int(input%p(6)-1),int(input%p(6)-1)
   do kk=-int(input%p(6)-1),int(input%p(6)-1)
      if (i+ii.ge.1.and.i+ii.le.nx.and.j+jj.ge.1.and.j+jj.le.ny.and.k+kk.ge.1.and.k+kk.le.nz) then 
         temp1 = sqrt((ii)**2.+(jj)**2.+(kk)**2.)
         temp2 = sqrt((clump_x(i+ii,j+jj,k+kk)-(i+ii-0.5))**2.+&
              (clump_y(i+ii,j+jj,k+kk)-(j+jj-0.5))**2.+&
              (clump_z(i+ii,j+jj,k+kk)-(k+kk-0.5))**2.)
         netz(i+ii,j+jj,k+kk) = iexpGW1
         if ((temp1.lt.temp2).or.&
              (clump_x(i+ii,j+jj,k+kk)+&
              clump_y(i+ii,j+jj,k+kk)+&
              clump_z(i+ii,j+jj,k+kk)<1e-9)) then 
            clump_x(i+ii,j+jj,k+kk) = i-0.5
            clump_y(i+ii,j+jj,k+kk) = j-0.5
            clump_z(i+ii,j+jj,k+kk) = k-0.5
            !   - TOR - cloud:
            clump_t(i+ii,j+jj,k+kk) = 1 
         end if
      end if
   end do
end do
end do
end do

isumuw = 0.
do i = 1, nx
do  j = 1, ny
do  k = 1, nz
   isumuw        = isumuw + netz(i,j,k)**3
   netsum(i,j,k) = isumuw
end do
end do
end do
if (ibug>0) print *, ' 6. Summe aller Unterwuerfel =', isumuw
!allocate(dicht(netsum(nx,ny,nz)))
memory = memory + netsum(nx,ny,nz)*8
!allocate(inopah(netsum(nx,ny,nz)))
memory = memory + netsum(nx,ny,nz)*8

call allocspace(isumuw)

do i = 1, isumuw
   dicht(i)    = 0.
end do
cl_mass = 0.
do i=1,nx
do j=1,ny
do k=1,nz
   do ii=1,netz(i,j,k)
   do jj=1,netz(i,j,k)
   do kk=1,netz(i,j,k)
      ntz = netz(i,j,k)
      lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
      xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
      yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
      zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
      r = sqrt(xx2+yy2)
      !r3 = sqrt(xx2+yy2+zz2)
      r3 = sqrt((x(i)+0.5*dgw-xorg)**2+(y(j)+0.5*dgw-yorg)**2+(z(k)+0.5*dgw-zorg)**2)
      if ((r3.ge.rinner).and.(r3.le.router).and.(abs(sqrt(zz2))<r3*sin(input%p(4)/180.*pi))) then 
         if (dicht(lp).eq.0) then
            dicht(lp) = density_2phase*(r3/rinner)**(-input%p(8))
         end if 
      endif
      if (netz(i,j,k).gt.1) then       
         r_clump = sqrt(((i-1.+1.*(ii-0.5)/ntz)-clump_x(i,j,k))**2+&
              ((j-1.+1.*(jj-0.5)/ntz)-clump_y(i,j,k))**2+&
              ((k-1.+1.*(kk-0.5)/ntz)-clump_z(i,j,k))**2)
         if ((lp.gt.0).and.(r_clump.ge.0).and.&
              (r_clump.lt.(input%p(6)))) then
            dicht(lp) = dicht(lp)   +  density_clump 
            cl_mass = cl_mass + dicht(lp)*(dgw/ntz)**3
         endif
      endif
   enddo
   enddo
   enddo
enddo
enddo
enddo

end subroutine space_2phase_torus


!
! ----------------------------------------------
!
subroutine dicke_scheibeTz(init,iter)
!
! Dichte Verteilung aus vertikalen Temperatur Profil einer
! Keppler Scheibe mit vertikalen Druckgradienten.
! Zur Pruefen dass die Streung  Temerpatur  entlang der z-achse
! hinreichend klein.


use type_module
use parameter
use constants
implicit none
        type(init_type) :: init
        character(50) :: cdum
        integer :: iter, isot, ibottom, itop, i1au, i5au
	integer	:: iz, izold, itclmass, l, ll, iles,check,check1,check2
	integer	:: ntz, ii,jj,kk, llold, k1, k2, i1, i2
	real*8	:: fakcon, protmu, temp_mid, tauV_mid
        real*8  :: x1, x2, y1,y2, fak, fak0, fakrho, tauVrsmax
        real*8  :: xx2, yy2, zz2, xx, yy,zz, tt, dl
        real*8  :: rr, rrr, dz, dichtz, dtauz, tauz0, tauVmin
	real*8	:: cl_mass1, Hscal, cs, Height, mu, aheight
        real*8  :: surf, surfr   !Surface density old, new
        real*8  :: rhotemp,dpdr,dpdr1,dpr1,rhotemp1

        real*8  :: ztop(nmid)    ! Scheibenhoehe ztop(rho.ne.0) 
        real*8  :: zbottom(nmid) ! Scheibenhoehe zbottom(tau=1) 
        real*8  :: v2thetr(nmid),vthet,dPr !extras for radial forces
        real*8  :: tauzvert(nzUW) ! tau(z) bei Rmid
        character*30    :: file
!
! ------------------------------------------------------ 
!
     if(input%structure.ne.4)  return

        iles =0
       if(iter.eq.8) then
        iles    = 1
       else
         iles    = 0
       end if

        tauVmin = 0.8
        mu      = 2.33
        protmu  = protm
        aheight = input%p(2)

! ------------------------------------------------------
! Einlesen der azimuth gemittelten Temp. vom file L.Tzm:
!
      if(iles .eq.1) then
       print*, '! Einlesen der azimuth gemittelten Temp. vom file L.Tzm: ', nmid,nzUW
        open(unit=3, file='./output/L.Tzm_8', form='formatted')
        rewind(3)
        read(3,*) cdum
        print*,   cdum

          do l    = 1, nmid*nzUW
!           read(3,*, end=89) ll, iz,  ibottom, itop, rr,zz, tt, dichtz, tauz0,j

           read(3,*, end=89) ll, iz,  rr, zz, isot, ibottom, itop, dichtz, tt,tauz0,j, jj
           itopr(ll)    = itop
           ibotr(ll)    = ibottom
           isotr(ll)    = isot !max(ibottom-2,1)
           rmid(ll)     = rr
           rhoz(iz,ll)  = dichtz
           Temz(iz,ll)  = tt
           nUWTz(iz,ll) = j
         end do
  89     continue

         write(6,'(a,i6,1x,i6)') ' # UW mit Temperaturen:    (read)  = ', l, nmid*nzUW
         write(6,'(a, i5)') '     Anzahl UW entlang x der midplane  = ', nmid
         write(6,'(a, i5)') '     Anzahl UW entlang z -Achse        = ', nzUW
         print*, ' !       end: einlesen vom file: L.Tzm  DONE'



         do i =1,nmid
          if(rhoz(1,i).lt.1.d-40 .and.i.gt.1) then
           itopr(i)    = itopr(i-1)
           ibotr(i)    = ibotr(i-1)
           isotr(i)    = isotr(i-1)
           do iz =1,nzUW
           if(temz(iz,i-1) .gt.0) then
             rhoz(iz,i) = rhoz(iz,i-1)
             temz(iz,i) = temz(iz,i-1)
! if(i.eq.32)  print*, iz,i, rhoz(iz,i), temz(iz,i),rhoz(iz,i-1), temz(iz,i-1)
             k = iz
          end if
            temz(iz,i) = temz(k,i)
           end do
          end if
         end do

        end if


!
! -------------------------------------------------
!
      call nlocat(rmid, nmid, au, i1au)
      tt = 5.*au
      call nlocat(rmid, nmid, tt, i5au)

! 
! Replace bei Tmid=0 oder Tmid<50K im aussen Bereich (R>5AU) 
!

       do i        = 1, nmid
        if(temz(1,i).eq.0) then
!         if(temz(1,i).eq.0 .or. i.ge.i5au) then
          k = 1

! 1a)    Tmidplane =0 => ersetzte durch T>0 innerhalb der isothermen Schicht:
         do while(temz(k,i) .eq.0 .and. k.le.isotr(i))
           k = k+1
         end do

! 1b)    Tmidplane =0  => ersetzte durch interpolation ~1/r**(3/7.)
          if(i.gt.1.and.temz(k,i).eq.0)  then
!           write(6,'(2i5,1p2e10.2, a20)') i,k, temz(k,i), &
!&          temz(1,i-1)*(rmid(i-1)/rmid(i))**(3./7.), ' Tmid intpol'

           do iz = 1 , k
            temz(k,i)=temz(1,i-1)*(rmid(i-1)/rmid(i))**(3./7.)
            end do
         end if

! 2)    Tmidplane < 50K und R>5AU => ersetzte durch interpolation ~1/r**(3/7.)
          if(i.gt.i5au.and.temz(k,i).le.50.) &
&          temz(k,i)=temz(1,i-1)*(rmid(i-1)/rmid(i))**(3/7.)
            do iz = 1 , k
              temz(iz,i) = temz(k,i)
            end do
         endif

         if(temz(1,i) .eq.0) print*, i, rmid(i), temz(1,i), 'Tmidplane=0 ? '
! 3) Falls irgednwo noch T(iz)=0 ersetzte durch T(iz-1); Tmid ist nun ungleich 0
            do iz = 1, nzUW
             if(temz(iz,i).eq.0) then
               k = iz
               do while(temz(k,i) .eq.0 .and. k.gt.1)
                k = k-1
               end do
               do kk = k, iz
                 temz(kk,i) = temz(k,i)
               end do
              endif
             end do          
         end do
!       end "manipulation" der Temperaturen
! ---------------------------------------------------------
! Test einlesen: Sum(rhoz) vgl. mit space:
! Check Sauelendichte bei 1AU
!
        if(iles .gt.0) then
        fak = 0
        do i        = 1, nmid -1
        do iz       = 1, nzUW -1
         if(temz(iz,i).eq.0) then 
          print*, iz,i, temz(iz,i), 'check: T=0 -- kann eigentlich nicht sein?'
         end if
         fak       = fak + rhoz(iz,i) * (zvert(iz+1)-zvert(iz)) & 
&                                     * (rmid(i+1)-rmid(i))

!            if(ibug.ge.2.and.i .eq.32.and. rhoz(iz,i) .gt.0) then
!             write(6, '(2i5,1p2e12.4,1x,2e12.3,1x,i6)')  i, iz, rmid(i),  & 
!&          zvert(iz),  rhoz(iz,i), Temz(iz,i),  nUWTz(iz,i)
!          endif

        end do
        end do
        write(6,'(a20,1p1e10.3)')  'gelesen: Sum(rhoz) = ', fak
              tauz0     = 0
!
       do iz           = 1, nzUW-1
              dl       = zvert(iz+1)-zvert(iz)
              dtauz    = Cext_V *dl*rhoz(iz,i1au)
              tauz0    = tauz0 + dtauz
       end do
     write(6,'(a50,1p2e10.2)') ' gelesen Saulendichte [g-DUST/cm^2] r(1AU): ', &
&       rmid(i1au)/au, 2.*tauz0/Cext_V  
       end if
!      check einlesen : ende


! -------------------------------------------------------------------------------------
!  Berechnung der neuen Dichte: 
! -------------------------------------------------------------------------------------

        tauVrsmax  = input%p(1)
        do i        = 1, nmid
          rr        = rmid(i)
         if(rr.lt.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamin
         if(rr.ge.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamout

          surf      = tauV_mid /Cext_v !surface density
          fakcon    = protmu/boltz * Grav*Mstar/rr**3. ! 'constants' for calculating pressure gradient
! midplane:
          iz         = 1
          zz         = zvert(iz)
          temp_mid   = Temz(iz,i)
          Hscal      = sqrt(boltz*Temp_mid*rr**3 / (grav*Mstar*protmu)) !scale height H
          rhoz(iz,i) = surf/Hscal*sqrt(2.d0/pi) *  &
&                      exp(-(zz**2.)/2.d0/Hscal**2.)  !midplane density as per (3) in ralf's paper
! z> midplane:
          do iz     = 2, nzUW
           zz       = zvert(iz)
           dz       = zvert(iz) - zvert(iz-1)

           if(i.gt.i5au.and.temp_mid.le.50.) then
            rhoz(iz,i) = surf/Hscal*sqrt(2.d0/pi) *  &
&                        exp(-(zz**2.)/2.d0/Hscal**2.)  
            else

            rhoz(iz,i) = abs(-fakcon*rhoz(iz-1,i)* zvert(iz-1)* dz/Temz(iz,i) &
&                            +rhoz(iz-1,i)* Temz(iz-1,i)/Temz(iz,i)) !new density

           endif

! recovery for rho if iz>iz-1 bei mehr als 5%:
          if(rhoz(iz,i).gt.1.05*rhoz(iz-1,i)) then
            rhoz(iz,i) = rhoz(iz-1,i) * exp(-(zvert(iz-1)/zz)**2) 
            if(rhoz(iz,i).gt.1.05*rhoz(iz-1,i)) then
              rhoz(iz,i) = surf/Hscal*sqrt(2.d0/pi) *  &
&                         exp(-(zz**2.)/2.d0/Hscal**2.)  
             end if
          end if

          if(rhoz(iz,i) .lt.rhomin) rhoz(iz,i) = 0. !check for low densities

          if (rhoz(iz,i).gt.1.05*rhoz(iz-1,i)) then
           write(6,'(4i4, 1p4e9.2,a20)') i, iz,isotr(i), itopr(i), &
&            rr,zz, temp_mid, rhoz(iz,i), ' !rho: iz>iz-1'
          end if

!          if(i.eq.32) write(6,'(4i4, 1p4e9.2,a20)') &
!&  i, iz,isotr(i), itopr(i), rr,zz, temz(iz,i), rhoz(iz,i)

      if(isnan(rhoz(iz,i))) then
       write(6,'(4i4, 1p4e9.2,a10)') i, iz, &
&       isotr(i), itopr(i), rr,zz, temz(iz,i), rhoz(iz,i), 'NaN'
        write(6,'(1p5e10.2)') rhoz(iz-1,i), rhoz(iz,i), fakcon, &
     & -fakcon*rhoz(iz-1,i)* zvert(iz-1)* dz/Temz(iz,i), & 
     & rhoz(iz-1,i)* Temz(iz-1,i)/Temz(iz,i)
       stop 'rhoz NaN'
      endif

          end do
          end do

!----------------------------------------------------------------------
!--Calculate new density for radial forces ----------------------------
!----------------------------------------------------------------------

print*,'Starting radial forces'

! calculate equilibrium mid-plane rotational velocities
        iz = 1
        dPr       = (rhoz(iz,2)*Temz(iz,2)-rhoz(iz,1)*temz(iz,1))/(rmid(2)-rmid(1)) !gradient
        dPr       = dPr * boltz / protmu !take mean and include constants
        v2thetr(1)= dPr/rhoz(iz,1) + Grav*Mstar/((rmid(1))**2) !centripetal acceleration v^2_theta/r

        do i        = 2, nmid-1 !edges treated separately
          rr        = rmid(i)
          iz        = 1
!          fakcon    = protmu/boltz * Grav*Mstar/rr**3. ! 'constants' for calculating pressure gradient
          dPr       = (rhoz(iz,i)*Temz(iz,i)-rhoz(iz,i-1)*temz(iz,i-1))/(rmid(i)-rmid(i-1)) + &
&                     (rhoz(iz,i+1)*Temz(iz,i+1)-rhoz(iz,i)*temz(iz,i))/(rmid(i+1)-rmid(i))
          dPr       = dPr/2 * boltz / protmu !take mean and include constants
          v2thetr(i)= dPr/rhoz(iz,i) + Grav*Mstar/(rr**2) !centripetal acceleration v^2_theta/r
        enddo

        iz = 1
        dPr       = (rhoz(iz,nmid)*Temz(iz,nmid)-rhoz(iz,nmid-1)*temz(iz,nmid-1))/(rmid(nmid)-rmid(nmid-1))
        dPr       = dPr * boltz / protmu !take mean and include constants
        v2thetr(nmid)= dPr/rhoz(iz,nmid) + Grav*Mstar/((rmid(nmid-1))**2) !centripetal acceleration v^2_theta/r

! now iterate through disc modifying density to satisfy equilibrium
!     do i = nmid-1,1 !iterate over radii, not sure whether to include outermost radius - it might introduce spurious results?
!            rr = rmid(i)
!            vthet = v2thetr(i)
!            vthet = vthet - (grav*mstar/rr**2) ! better to put this here?
!        do iz = 2, nzUW !can ignore midplane
!            dpr = (rhoz(iz,i+1)*Temz(iz,i+1)-rhoz(iz,i)*temz(iz,i))/(rmid(i+1)-rmid(i)) !gradient
!            dPr = dPr * boltz / protmu !take mean and include constants
!            rhoz(iz,i) = abs(dpr / (vthet))! - (grav*mstar/rr**2)))
!          if(rhoz(iz,i) .lt.rhomin) rhoz(iz,i) = 0. !check for low densities
!        enddo
!     enddo


!trying different method, think the maths was wrong above

!!$        do i = nmid-1,1,-1
!!$           if(rmid(i+1) .lt. router) then
!!$           rr = rmid(i)
!!$           vthet = v2thetr(i)
!!$           vthet = vthet - (grav*mstar/rr**2)
!!$           if(vthet .eq. 0) print*,i,vthet
!!$           do iz = 2,nzUW
!!$              if(rhoz(iz,i+1) .gt. 0) then !breaks when density = 0
!!$              dpr = (temz(iz,i+1)-temz(iz,i))
!!$              dpr = dpr *boltz
!!$              dpr = (rmid(i+1)-rr)*protmu/dpr
!!$              fakrho = dpr*vthet
!!$              rhotemp = rhoz(iz,i+1)/(fakrho+1)
!!$              if(rhotemp .lt. rhomin) print*,i,iz,dpr,vthet,fakrho,(temz(iz,i+1)-temz(iz,i)),rhoz(iz,i+1),rhotemp
!!$              if( rhotemp .lt. rhomin) rhotemp = 0.
!!$
!!$              rhoz(iz,i) = rhotemp
!!$              endif
!!$           enddo
!!$           endif
!!$        enddo

        do i = nmid-1,1,-1
!           if(rmid(i+1) .lt. router) then
           rr = rmid(i)
           vthet = v2thetr(i)
           vthet = vthet - (grav*mstar/rr**2)
           if(vthet .eq. 0) print*,i,vthet
           do iz = 2,nzUW
!!$              dpdr = rhoz(iz,i+1)*temz(iz,i+1) - rhoz(iz,i)*temz(iz,i)
!!$              dpdr = dpdr/(rmid(i+1)-rr)
!!$              dpdr = dpdr*boltz/protmu
!!$              dpdr1 = rhoz(iz,i)*temz(iz,i) - rhoz(iz,i-1)*temz(iz,i-1)
!!$              dpdr1 = dpdr1/(rr-rmid(i-1))
!!$              dpdr1 = dpdr1*boltz/protmu

!              if(rhoz(iz,i+1) .gt. 0) then !breaks when density = 0
              dpr = rmid(i+1) - rr
              dpr = dpr*protmu*vthet/boltz
              dpr = dpr - (temz(iz,i+1)-temz(iz,i))
              dpr = dpr/temz(iz,i)

!              write(6,'(2i10,1p8e16.3)'),i,iz,vthet,dpdr,vthet - dpdr/rhoz(iz,i),dpdr1,vthet - dpdr1/rhoz(iz,i),&
!&vthet - (dpdr + dpdr1)/(2*rhoz(iz,i)),(vthet - (dpdr + dpdr1)/(2*rhoz(iz,i)))/(grav*mstar/rr**2),dpr
 !----------Extra-experimental based on Ralf's version--------------!
!              if(dpr .le. -1) print*,i,iz,(rmid(i+1) - rr), !how to prevent negative densities?
!              fakrho = dpr*vthet
              rhotemp = rhoz(iz,i+1)*(1-dpr)
!              if(temz(iz,i+1) .le. temz(iz,i)) print*,i,iz,(temz(iz,i+1)-temz(iz,i)),vthet,dpr
              if (dpr .le. -1) then
                 check = check + 1
              elseif (dpr .gt. 1) then
                 check1 = check1 + 1
!                 print*,' '
!                 print*,i,iz,dpr,vthet,(rmid(i+1)-rr),(rmid(i+1)-rr)*protmu*vthet/boltz,&
!&(temz(iz,i+1)-temz(iz,i)),temz(iz,i),rhoz(iz,i+1),rhotemp
!                 print*,' '
              else 
                 check2 = check2+1
              endif
!              if(rhotemp .lt. rhomin) print*,i,iz,dpr,vthet,(rmid(i+1)-rr),(rmid(i+1)-rr)*protmu*vthet/boltz,&
!&(temz(iz,i+1)-temz(iz,i)),temz(iz,i),rhoz(iz,i+1),rhotemp
!              if( rhotemp .lt. rhomin) rhotemp = 0.
              if(i .ge. 2) then !test effect of including both gradients
                 dpr1 = rr-rmid(i-1)
                 dpr1 = dpr1*protmu*vthet/boltz
                 dpr1 = dpr1 - (temz(iz,i)-temz(iz,i-1))
                 dpr1 = dpr1/temz(iz,i)
                 rhotemp1 = rhoz(iz,i-1)/(1-dpr1)!-1)
!                 if (rhotemp1 .lt. 0) print*, i, iz, dpr1,vthet, (temz(iz,i)-temz(iz,i-1)),rhotemp1
                 rhotemp = rhotemp + rhotemp1
                 rhotemp = rhotemp/2
              endif
              if(rhotemp .lt. 0) then !interpolate density based on surface density gradient
!                 print*,i,iz,rr,'rho<0'
                 if (i .lt. i1au) rhotemp = rhoz(iz,i+1) * (rr/rmid(i+1))**(0.5)
                 if (i .ge. i1au) rhotemp = rhoz(iz,i+1) * (rr/rmid(i+1))**(-1)
              endif
              if (rhotemp .gt. 1.05*rhoz(iz-1,i)) then !check density for z-direction
!                 print*,i,iz,'rho>rho(iz-1)'
                 rhotemp = rhoz(iz-1,i) * exp(-(zvert(iz-1)/zz)**2) 
              endif
!              if(rhotemp .lt. rhomin) rhotemp = 0.
              rhoz(iz,i) = rhotemp
!              endif

!----------End extra-experimental---------------------------------!

!!$!              if(dpr .le. -1) print*,i,iz,(rmid(i+1) - rr), !how to prevent negative densities?
!!$!              fakrho = dpr*vthet
!!$              rhotemp = rhoz(iz,i+1)/(dpr+1)
!!$!              if(temz(iz,i+1) .le. temz(iz,i)) print*,i,iz,(temz(iz,i+1)-temz(iz,i)),vthet,dpr
!!$              if (dpr .le. -1) then
!!$                 check = check + 1
!!$              elseif (dpr .gt. 1) then
!!$                 check1 = check1 + 1
!!$                 print*,' '
!!$                 print*,i,iz,dpr,vthet,(rmid(i+1)-rr),(rmid(i+1)-rr)*protmu*vthet/boltz,&
!!$&(temz(iz,i+1)-temz(iz,i)),temz(iz,i),rhoz(iz,i+1),rhotemp
!!$                 print*,' '
!!$              else 
!!$                 check2 = check2+1
!!$              endif
!!$              if(rhotemp .lt. rhomin) print*,i,iz,dpr,vthet,(rmid(i+1)-rr),(rmid(i+1)-rr)*protmu*vthet/boltz,&
!!$&(temz(iz,i+1)-temz(iz,i)),temz(iz,i),rhoz(iz,i+1),rhotemp
!!$!              if( rhotemp .lt. rhomin) rhotemp = 0.
!!$
!!$              rhoz(iz,i) = rhotemp
!!$              endif
           enddo
!           endif
        enddo

!print*,check,check1,check2

!!$        do i = 2,nmid!,1,-1
!!$!           if(rmid(i+1) .lt. router) then
!!$           rr = rmid(i)
!!$           vthet = v2thetr(i)
!!$           vthet = vthet - (grav*mstar/rr**2)
!!$           if(vthet .eq. 0) print*,i,vthet
!!$           do iz = 2,nzUW
!!$              dpr = (temz(iz,i)-temz(iz,i-1))
!!$              dpr = dpr *boltz
!!$              dpr = (rr-rmid(i-1))*protmu/dpr
!!$              fakrho = dpr*vthet
!!$              rhotemp = rhoz(iz,i-1)/(fakrho+1)
!!$              print*,i,iz,dpr,vthet,fakrho,(temz(iz,i)-temz(iz,i-1)),rhoz(iz,i-1),rhotemp
!!$              if( rhotemp .lt. rhomin) rhotemp = 0.
!!$
!!$              rhoz(iz,i) = rhotemp
!!$           enddo
!!$!           endif
!!$        enddo

do i = 1,nmid-1
   do iz = 2,nzuw
      if(rhoz(iz,i).lt. rhomin) rhoz(iz,i) = 0.
   enddo
enddo



!  Neue Dichten sind gesetzt nun noch richtige Normierung
! ------------------------------------------------------- 
! Normierung der Surface density nur der Scheibe mit nUWTZ wie aus space
! norm = tauz0/tauz0(vert(1)
      do  i         = 1, nmid
        tauz0       = 0.
        dtauz       = 0.
            iz      = nzUW
            dl      = zvert(iz)-zvert(iz-1)
            dtauz   = Cext_V *dl*rhoz(iz,i)
            tauz0   = tauz0 + dtauz
        do iz       = nzUW-1, 1, -1
            dl      = zvert(iz+1)-zvert(iz)
            dtauz   = Cext_V *dl*rhoz(iz,i)
            tauz0   = tauz0 + dtauz
        end do
        fak         = tauzmid(i)/tauz0
!        if(abs(fak-1.).ge.0.9) write(6,'(i4, 1p2e10.3)') i,rmid(i), fak
        if(isnan(fak))  then
            write(6,'(i4, 1p2e10.3)') i,rmid(i), fak
            stop 'fak NaN'
        end if
        tauz0       = 0.
        dtauz       = 0.
        iz      = nzUW
        rhoz(iz,i) = rhoz(iz,i) * fak
        dl      = zvert(iz)-zvert(iz-1)
        dtauz   = Cext_V *dl*rhoz(iz,i)
        tauz0   = tauz0 + dtauz
        do iz       = nzUW-1, 1, -1
            rhoz(iz,i) = rhoz(iz,i) * fak
            dl      = zvert(iz+1)-zvert(iz)
            dtauz   = Cext_V *dl*rhoz(iz,i)
            tauz0   = tauz0 + dtauz
!if(i.eq.32) write(6,'(2i4,1p5e10.2)') i, iz, zvert(iz), dl, rhoz(iz,i), dtauz, tauz0
       end do
      end do

!
! -------------------
! Ruecksetzten von nUWTz und  check  Sum(rhoz), sufr, Saulendichte(1AU) 
! mit Normierung wie in space?
!
        surfr     = 0
        fak       = 0
        do i      = 1, nmid -1
        surfr     = surfr    + rhoz(1,i)  *(rmid(i+1)-rmid(i))
        do iz     = 1, nzUW -1
              fak = fak + rhoz(iz,i) * &
&               (zvert(iz+1)-zvert(iz))*(rmid(i+1)-rmid(i))        
        end do
        end do
        tauV_mid  = surfr*Cext_V
        write( 6,'(a40,1p1e10.2)') ' neu midplane Tau(2D)    = ', tauV_mid
        write(6,'(a40,1p1e10.3)')  ' neu Sum(rhoz) = ', fak


!
! ----------------------------------------------------
! Berechnung der Dichte/Masse im vorgegebenen Gitter:
!
        cl_mass1 = cl_mass
        itclmass = 0
99      continue
        itclmass = itclmass + 1

        cl_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz

           do kk = 1, ntz
      lp  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
      dicht(lp) = 0
              xx  = (x(i) + (ii - 5d-1) * dl-xorg)
              yy  = (y(j) + (jj - 5d-1) * dl-yorg)

              zz  = (z(k) + (kk - 5d-1) * dl-zorg)
              xx2 = xx*xx
              yy2 = yy*yy
              zz2 = zz*zz
              rr  = sqrt(xx2 + yy2)
              rrr = sqrt(xx2 + yy2 + zz2)
! dichte from 2d Gitter stored in 3D grid
          if(rr .ge. rinner .and. rr .le. router) then
             call  locat(rmid,  nmid, rr, l) !nlocat geht daneben !
             if(l.lt.1)    l = 1
             if(l.gt.nmid) l = nmid
             call nlocat(zvert, nzUW, zz, iz)
             fak =   rhoz(iz,l)

             if(l.gt.1 .and.l.lt.nmid) then
               if(rr .lt. rmid(l) .and. rhoz(iz,l-1) .gt.rhomin) then
                x1 = rmid(l-1)
                x2 = rmid(l)
                y1 = rhoz(iz,l-1)
                y2 = rhoz(iz,l)
               fak =  (y1-y2)/(x1-x2) * (rr-x1) + y1
               end if
               if(rr .gt. rmid(l) .and. rhoz(iz,l+1) .gt.rhomin) then
                x1 = rmid(l)
                x2 = rmid(l+1)
                y1 = rhoz(iz,l)
                y2 = rhoz(iz,l+1)
               fak =  (y1-y2)/(x1-x2) * (rr-x1) + y1
               endif
             end if
! Dichte nur der Scheibe 
            dicht(lp) = fak

            if (isnan(dicht(lp))) then
             write(6,'(2i4,1p7e9.2, a9)') l,iz, x1, x2, y1, y2, rr, rmid(l), dicht(lp), ' Nan '
             stop
            end if  
          end if

! -------------------
! Dichte der Scheibe nun + Staubhuelle:
! 
       if(rrr .ge. rinner .and. rrr .le. router) then
             dicht(lp) = dicht(lp) +  rhomin
       end if


          cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3

           end do
           end do
           end do
        end do
        end do 
        end do

!
!
! ----------------------------------------------------------
! Hoehe der Extinktionsschicht ztop, zbottom

         if(iter .eq.1) file = 'output/L.dichte_1'
         if(iter .eq.2) file = 'output/L.dichte_2'
         if(iter .eq.3) file = 'output/L.dichte_3'
         if(iter .eq.4) file = 'output/L.dichte_4'
         if(iter .eq.5) file = 'output/L.dichte_5'
         if(iter .eq.6) file = 'output/L.dichte_6'
         if(iter .eq.7) file = 'output/L.dichte_7'
         if(iter .eq.8) file = 'output/L.dichte_8'
         if(iter .eq.9) file = 'output/L.dichte_9'
         if(iter .eq.10) file = 'output/L.dichte_10'
         if(iter .eq.11) file = 'output/L.dichte_11'
         if(iter .gt.11) stop ' iter >11 not foreseen'
         open(unit=36, file=file, form='formatted')
         rewind(36)
         write(36,*) '# i  iz ibot itop   rr       zz       Temz     rhoz     tauz   nUW'

         if(iter .eq.1) file = 'output/L.ztop_1'
         if(iter .eq.2) file = 'output/L.ztop_2'
         if(iter .eq.3) file = 'output/L.ztop_3'
         if(iter .eq.4) file = 'output/L.ztop_4'
         if(iter .eq.5) file = 'output/L.ztop_5'
         if(iter .eq.6) file = 'output/L.ztop_6'
         if(iter .eq.7) file = 'output/L.ztop_7'
         if(iter .eq.8) file = 'output/L.ztop_8'
         if(iter .eq.9) file = 'output/L.ztop_9'
         if(iter .eq.10) file = 'output/L.ztop_10'
         if(iter .eq.11) file = 'output/L.ztop_11'
         if(iter .gt.11) stop ' iter >11 not foreseen'

         open(unit=26, file=file, form='formatted')
         rewind(26)
         write(26,*) '# i iso ibot #ext  rmid     tauzmid  ziso     zbottom  ztop     tautop-1  tautop'

!
! tau bei jeden radius in vertikaler Richtung:
!
      do  i            = 1, nmid
          itop         = 1
          ibottom      = 1
          dtauz        = 0.
          iz           = nzUW
          dl           = zvert(iz)-zvert(iz-1)
          dtauz        = Cext_V *dl*rhoz(iz,i)
          tauz0        = dtauz
          tauzvert(iz) = tauz0            
       do iz           = nzUW-1, 1, -1
          dl           = zvert(iz+1)-zvert(iz)
          dtauz        = Cext_V *dl*rhoz(iz,i)
          tauz0        = tauz0 + dtauz
          tauzvert(iz) = tauz0
!if(i.eq.32) write(6,'(2i4,1p5e10.2)') i, iz, zvert(iz), dl, rhoz(iz,i), dtauz, tauzvert(iz)
          if(tauz0 .gt.0.02 .and.itop.eq.1) itop = iz
!          print*,i,iz,dtauz,tauz0,rhoz(iz,i),dl,zvert(iz),itop
       end do
!       print*,i,itop,' 1'

! tauzmid: total tau(z) bei allen Rmid 
          tauzmid(i)  = tauzvert(1)

! Top & Bottom der Extinktionsschicht ztop
        if(itop .ge.nzUW) itop  = nzUW-1
        if(itop .lt.1)    itop  =  1
!       print*,i,itop,' 2'
                          dtauz = 1.
        call nlocat(tauzvert, nzUW, dtauz, ibottom)
        if(ibottom .gt.itop) ibottom = itop
        ztop(i)    = zvert(itop)
        iz         = ibottom

       if(tauzvert(itop) .eq.0) &
&      print*, ' i, itop, ibot, tauz(ibot) = ', i, iz, itop, ibottom, tauzvert(iz)

!       print*,i,itop,' 3'
        if(iz.gt.1 .and.iz.lt.nzUW) then
           if(tauzvert(iz) .le.1) then 
                zbottom(i) = (zvert(iz-1)-zvert(iz))       / &
&                            (tauzvert(iz-1)-tauzvert(iz)) *&
&                            (dtauz-tauzvert(iz-1))   + zvert(iz-1)

                tauV_mid   = (tauzvert(iz-1)-tauzvert(iz)) / &
&                            (zvert(iz-1)-zvert(iz))       * &
&                            (zbottom(i)-zvert(iz-1)) +  tauzvert(iz-1)

              else

                zbottom(i) = (zvert(iz+1)    - zvert(iz))    / &
&                            (tauzvert(iz+1) - tauzvert(iz)) *&
&                            (dtauz-tauzvert(iz))   + zvert(iz)

                tauV_mid   = (tauzvert(iz+1)- tauzvert(iz))  / &
&                            (zvert(iz+1)   - zvert(iz))     * &
&                            (zbottom(i)    - zvert(iz)) +  tauzvert(iz)

               end if
             else
                 zbottom(i) = zvert(ibottom)
                 tauV_mid   = dtauz
             end if

! isotr: top der isotermen Schicht bei tauz>5 
            dtauz      = 10.
            call nlocat(tauzvert, nzUW, dtauz, isot)
            if(tauzvert(isot) .lt.dtauz) isot = isot-1
            if(isot .ge.ibottom)      isot = ibottom -1
            if(isot.lt.2)             isot = 2


            itopr(i)  = itop
            ibotr(i)  = ibottom
            isotr(i)  = isot
            if(itop .eq. 1) print*,i,iz,tauzvert(iz),tauzmid(i)

! test: tau(zbottom) ~ 1. ?
        if(abs(tauV_mid-1.) .ge.0.1) then 
 write(6,'(4i4,3x,1p7e9.2, a10)') i,  isotr(i), ibotr(i), &
(itopr(i)-ibotr(i)), rmid(i), tauzvert(1),  zvert(isotr(i)), &
zbottom(i), ztop(i), tauzvert(itop), tauzvert(ibottom), ' =dtau=1?'
        endif
             

write(26,'(4i4,3x,1p7e9.2)') i,  isotr(i), ibotr(i), (itopr(i)-ibotr(i)),  &
& rmid(i), tauzvert(1),  zvert(isotr(i)), zbottom(i), ztop(i), &
& tauzvert(itop-1), tauzvert(itop)

if(tauzvert(itop) .gt. tauVmin) write(6,'(3i4,3x,1p6e10.2, a20)') &
& i, iz, (itop-ibottom),  rmid(i), tauzmid(i), &
& zbottom(i),ztop(i), tauzvert(itop-1), tauzvert(itop), ' tau>tauVmin '

if(i.eq.i1au) write(6,'(a40,1p2e10.2)') &
& '   ** Saulendichte [g-DUST/cm^2] bei r(1AU)~  ', rmid(i1au), 2.*tauzmid(i1au)/Cext_V 




            if(isnan(tauV_mid)) then
write(26,'(4i4,3x,1p7e9.2)') i,  isotr(i), ibotr(i), (itopr(i)-ibotr(i)),  &
& rmid(i), tauzvert(1),  zvert(isotr(i)), zbottom(i), ztop(i), &
& tauzvert(itop-1), tauzvert(itop)
                stop ' tauV_mid = NaN' 
            end if
         
         do iz = nzUW, 1, -1
!         if(rhoz(iz,i).ge.rhomin) &
!&
          write(36,'(4i4, 3x, 1p5e9.2, i5)') i, iz,  ibotr(i), itopr(i), &
&          rmid(i),zvert(iz), Temz(iz,i), rhoz(iz,i), tauzvert(iz), nUWTz(iz,i)
       end do
       end do
      close(36)
      close(26)

! ---------------------------------------------

 write(6,'(a40,1p3e10.3)') '    cl_mass: new, old, new/old =  ', &
&         cl_mass/Msun, cl_mass1/Msun, cl_mass/cl_mass1

 write(6,'(a50, 1p1e10.2)') ' ** end dicke_scheibeTz: computed bis rhomin =', rhomin
return

end subroutine dicke_scheibeTz

