subroutine Toutput(iter)
use parameter
use constants
implicit none
	integer		:: nix(200)
!	integer		:: letztd(nthet)
!	integer		:: letzts(nthet)
	integer		:: jsumfr
	integer		:: isumabs,isumsca,isumNr
	integer		:: ii,i1,ii1, i2
	integer		:: jj,j1,jj1
	integer		:: kk,k0, k1,k2, kk1
	integer		:: ntz, l, m, iter
        integer         :: isot, itop
	real*8		:: tauV, dtauV
	real*8		:: dl, dl1	
	real*8		:: EabsSIz,EabsCz
	real*8		:: rr, suml, UWmass, fak
	real*8		:: x1,x2, y1, y2
	real*8		:: xx,yy,zz, rtest, tt
	real*8		:: xx2,yy2,zz2,tempx
	real*8		:: tauz0, dtauz,taumax,r_eff
	integer		:: ix,iy,iz,iux,iuy,iuz,iorg,jorg,korg,size
        character*30    :: filepah, filepahit, file, filetaueff,rowfmt
        real*8,allocatable  :: TemzOrg(:,:)  !# Temp. = f(z, R) ohne Mittelung
        integer,allocatable :: noabsTz(:,:)  !# UW ohne abs. bei: zz,rmid
        integer,allocatable :: noabsmid(:), noabstop(:) ! # UW ohne abs midplane/top
        integer         :: freq_lines(nf),ntsum
        integer         :: iread,jread,jstop,nbuffer=0

!
! -------------------------------------------------------
!

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  Gesamtleuchtkraft der Wolke durch Sternemission
        
     suml    = 0.
     do  jth = 1, nthet
     do   k = 1, nd
     suml  = suml + iphd(k,jth)
     end do
        do   k = 1, nf
        suml  = suml + iphs(k,jth)
        end do
     end do
     suml  = cc3 * epak * suml

     write(6,*)  ' *** Luminosity: input,    output,  ratio '
     write(6,'(16x, 1p3e10.2)')  Lquelle, suml, Lquelle/suml
     write(6,'(a19, f8.2, 1p1e10.2)')  '     cc3, epak =  ',  cc3, epak
!  Zahl der Absorption und Streuungen der vom Zentralstern emittierten Pakete
!        
     isumabs = 0
     isumsca = 0

     do  j = 1, 20
     nix(j) = 0
     end do

     do  i = 1, isumuw
      isumabs = isumabs + iabs(i)
      isumsca = isumsca + isca(i)
     do  j = 1, 20
      if(iabs(i) .eq. j-1)   nix(j) = nix(j) + 1
     end do
     end do

     print 270,  suml, isumabs, isumsca, nf*nzyk
270  format(6x,' L_stern=', 1pe12.3,  '  Zabs, Zsca=', 2i9, '  ZPakete=', 2i10)
     write(6,*) '      j     nix(j)'
     print 271,  (j-1, nix(j), j=1, 20)
	271  format(2i10)

!   ---------------------------------------------------------------------------
!     if(jhaufen .eq. 1)   call Bahnhaufen(sumQsBc, sumQsBsi)
!   ---------------------------------------------------------------------------
!  letztd(jth) = höchste Frequenz im Gitter fd(nd), bei der Wolke in 
!  Richtung jth noch abstrahlt.  Analog letzts(jth) für Gitter fr(nf)
     
     do  jth = 1, nthet
        letztd(jth)=0
        do   k = 1, nd
        if(iphd(k,jth) .gt. 0)      letztd(jth) = k
        end do
        letzts(jth)=0
        do   k = 1, nf
        if(iphs(k,jth) .gt. 0)   letzts(jth) = k
        end do
     end do

r_eff = y(ny)*z(nz)
r_eff = r_eff/pi
r_eff = sqrt(r_eff)

!---Calculate angular area of each face of cuboid as seen 
!---from star assuming that the projected location of the 
!---star is in the centre of each face.

if(idim3 .eq. 1) then
!calculate x,y,z=0 cases only for 3D models

! for x,y,z=0

ang_section0(1) = (sin(atan(yorg/xorg))) * (sin(atan(zorg/xorg)))
ang_section0(2) = (sin(atan(xorg/yorg))) * (sin(atan(zorg/yorg)))
ang_section0(3) = (sin(atan(xorg/zorg))) * (sin(atan(yorg/zorg)))
ang_section0 = 4*asin(ang_section0) !angular area of rectangular detector
ang_section0 = ang_section0/pi4 !fraction of angular area of sphere


!use to calculate effective tau and extinction--
Z_nd0 = nzyk * ang_section0

do k = 1,nf
   tau_eff0(k,1) = -1d0 * log(iphs0(k,1)/Z_nd0(1))
   tau_eff0(k,2) = -1d0 * log(iphs0(k,2)/Z_nd0(2))
   tau_eff0(k,3) = -1d0 * log(iphs0(k,3)/Z_nd0(3))
enddo

ang_section0 = pi4 * ang_section0 * dist**2 !move to distance dist
ang_section0 = 1d23/ang_section0 !convert to Jy
else
ang_section0 = 0.
endif

! for x,y,z=max

ang_sectionmax(1) = (sin(atan(yorg/(x(nx)-xorg)))) * (sin(atan(zorg/(x(nx)-xorg))))
ang_sectionmax(2) = (sin(atan(xorg/(y(ny)-yorg)))) * (sin(atan(zorg/(y(ny)-yorg))))
ang_sectionmax(3) = (sin(atan(xorg/(z(nz)-zorg)))) * (sin(atan(yorg/(z(nz)-zorg))))
ang_sectionmax = 4*asin(ang_sectionmax) !angular area of rectangular detector
ang_sectionmax = ang_sectionmax/pi4 !fraction of angular area of sphere

Z_ndmax = nzyk * ang_sectionmax

do k = 1,nf
   tau_effmax(k,1) = -1d0 * log(iphsmax(k,1)/Z_ndmax(1))
   tau_effmax(k,2) = -1d0 * log(iphsmax(k,2)/Z_ndmax(2))
   tau_effmax(k,3) = -1d0 * log(iphsmax(k,3)/Z_ndmax(3))
enddo

ang_sectionmax = pi4 * ang_sectionmax * dist**2 !move to distance dist
ang_sectionmax = 1d23/ang_sectionmax !convert to Jy

!now for ntheta directions

do jth=1,nthet
   Z_ndthet(jth) = nzyk * (dirthet(jth+1) - dirthet(jth)) / cc3  
enddo

do k = 1,nf
   do jth = 1,nthet
      tau_eff(k,jth) = -1d0 * log(iphs(k,jth)/Z_ndthet(jth))
   enddo
enddo

!   ---------------------------------------------------------------------------
         filepah   = 'output/pah.out_spektrum.inp'
         write(6,*) 'write:   output/pah.out_spektrum.inp'
         open(unit=3, file=filepah, form='unformatted')
         rewind(3)
         write(3) dirthet, wel, welmu, dfr, weld, welmud, fd, dfd, cc4, &
    &             epak, jsumfr, jd, iphd, iphs, letztd, letzts, krit, kugelsym,&
    &             iphd0,iphs0,iphdmax,iphsmax,ang_section0,ang_sectionmax,idim3
         close(unit=3)
!   ---------------------------------------------------------------------------

!write out effective extinction curves

filetaueff = 'output/L.taueff'

open(unit=3,file=filetaueff,form='formatted')
rewind(3)
write(3,*) 'Effective optical depths as measured in planes:'
if (idim3 .eq. 1) then
write(3,*) 'lambda[mu]     x = 0     y=0         z = 0      x=xmax      y=ymax      z=zmax'
do k = 1,nf
write(3,'(7(1p5e11.3))') welmu(k), (tau_eff0(k,jth),jth=1,3),(tau_effmax(k,jth),jth=1,3)
enddo
else
write(3,*) 'lambda[mu]      x=xmax      y=ymax      z=zmax'
do k = 1,nf
write(3,'(4(1p5e11.3))') welmu(k), tau_effmax(k,1), tau_effmax(k,2), tau_effmax(k,3)
enddo
endif
close(unit=3)

filetaueff = 'output/L.taueff_theta'
WRITE(rowfmt,'(A,I4,A)') '(',nthet,'(1p5e11.3))'
open(unit=3,file=filetaueff,form='formatted')
rewind(3)
write(3,*) 'Effective optical depths as measured in angles:'
write(3,*) 'lambda[mu]  theta1     theta2     theta3   ...'
do k = 1,nf
write(3,FMT=rowfmt) welmu(k),(tau_eff(k,jth),jth=1,nthet) !'(',nthet,'(1p5e11.3))'
enddo
close(unit=3)

print*,'Effective optical depths in V band:'
print*,'x = 0: tau_eff = ',tau_eff0(ivisd-256,1)
print*,'x = max(x): tau_eff = ',tau_effmax(ivisd-256,1)
print*,'z = 0: tau_eff = ',tau_eff0(ivisd-256,3)
print*,'theta1: tau_eff = ',tau_eff(ivisd-256,1)
print*,'theta max: tau_eff = ',tau_eff(ivisd-256,nthet)

!   ---------------------------------------------------------------------------
!   Temperaturen je UW (Tsi(lp), Tc(lp)) und mittlere Temperatur Tmid der UW 
!   der mid plane (z=y=0) berechnet aus Eabscz (Tac). 
!   Ausschreiben von absorption.bin und der Midplane Temperaturen.
!   nmid = #UW der midplane, Azimuthale Mittelung des vertikalen
!   Profils 



      if(input%structure.eq.4) then

          allocate(noabsTz(nzUW,nmid))
          allocate(TemzOrg(nzUW,nmid))
          allocate(noabsmid(nmid))
          allocate(noabstop(nmid))
          noabstz=0
          temzOrg=0
          noabsmid=0
          noabstop=0

!$omp parallel do private(i)
           do   i          = 1, nmid
            noabsmid(i)    = 0
            noabstop(i)    = 0
            Tmid(i)        = 0
            Ttop(i)        = 0
!$omp parallel do private(ii)
            do ii          = 1,nzUW
             TemzOrg(ii,i) = 0
             Temz(ii,i)    = 0
             noabsTz(ii,i) = 0
             nUWTz(ii,i)   = 0
            end do
!omp end parallel do
            end do
!omp end parallel do

         if(iter .eq.1)  filepahit = 'output/pah.out_spektrum_1.inp'
         if(iter .eq.2)  filepahit = 'output/pah.out_spektrum_2.inp'
         if(iter .eq.3)  filepahit = 'output/pah.out_spektrum_3.inp'
         if(iter .eq.4)  filepahit = 'output/pah.out_spektrum_4.inp'
         if(iter .eq.5)  filepahit = 'output/pah.out_spektrum_5.inp'
         if(iter .eq.6)  filepahit = 'output/pah.out_spektrum_6.inp'
         if(iter .eq.7)  filepahit = 'output/pah.out_spektrum_7.inp'
         if(iter .eq.8)  filepahit = 'output/pah.out_spektrum_8.inp'
         if(iter .eq.9)  filepahit = 'output/pah.out_spektrum_9.inp'
         if(iter .eq.10) filepahit = 'output/pah.out_spektrum_10.inp'
         if(iter .eq.11) filepahit = 'output/pah.out_spektrum_11.inp'
         open(unit=4,file=filepahit, form='unformatted')
         rewind(4)
         write(4) dirthet, wel, welmu, dfr, weld, welmud, fd, dfd, cc4, &
    &             epak, jsumfr, jd, iphd, iphs, letztd, letzts, krit, kugelsym
         close(unit=4)
         if(iter .eq.1) file = 'output/L.Tzm_1'
         if(iter .eq.2) file = 'output/L.Tzm_2'
         if(iter .eq.3) file = 'output/L.Tzm_3'
         if(iter .eq.4) file = 'output/L.Tzm_4'
         if(iter .eq.5) file = 'output/L.Tzm_5'
         if(iter .eq.6) file = 'output/L.Tzm_6'
         if(iter .eq.7) file = 'output/L.Tzm_7'
         if(iter .eq.8) file = 'output/L.Tzm_8'
         if(iter .eq.9) file = 'output/L.Tzm_9'
         if(iter .eq.10) file = 'output/L.Tzm_10'
         if(iter .eq.11) file = 'output/L.Tzm_11'
         if(iter .gt.11) stop ' iter >11 not foreseen'
         open(unit=25, file=file, form='formatted')
         rewind 25
         write(25,*) '# i   iz rmid       z         imid ibot itop    rhoz    Tz        tauz      nUWTz   noabsTz'

!         open(unit=36, file='output/L.Tall', form='formatted')
!         rewind 36
!         write(36,*) 'l, iz, lp, rr, rmid(l), zvert(iz), tc(lp)'
        end if
!
! Berechnung der azimuth. gemittelten Temperaturen: vertikal und in der midplane: 
!

     do   i = 1, nx
     do   j = 1, ny
     do   k = 1, nz

       ntz  = netz(i,j,k)
       dl   = dGW / ntz

       do  ii  = 1, ntz
       do  jj  = 1, ntz
       do  kk  = 1, ntz

        lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
        UWmass = (dGW / netz(i,j,k))**3 * dicht(lp)          !Masse des UW
        taumax = dl * dicht(lp) * (C_abs_si(iabs_max) + C_abs_ac(iabs_max))


! for fast check:
!if(dicht(lp).gt.0) then
!    nabsc(lp)   = i*j*k/ntz
!    nabssi(lp)  = i*j*k/ntz
!    if(rr.eq.rinner) print*, ' fast check'
! endif

   !need correction for Lucy scaling in low-limit optical depth cells in here
       if(nabssi(lp) .ge. 1)   then
            if(taumax .le.1e-2) then
            Eabssiz = dble(nabssi(lp))/(1000./taumax) * epak /(pi4 * UWmass)
            nabssi(lp) = int((nabssi(lp)/(1000/taumax)))
            else
            Eabssiz    = nabssi(lp) * epak / (pi4 * UWmass)
            endif
!         if (lp .eq. 4) print*, 'Eabssiz Si = ',Eabssiz
        call locat(QBsi, ntg, Eabssiz, l)
			if (l.lt.1)   l=1
			if (l.ge.ntg-1) l=ntg-1
        fak        = (Td(l+1) - Td(l)) / (QBsi(l+1) - QBsi(l))
        Tsi(lp) = Td(l) + fak * (Eabssiz - QBsi(l))
        if (isnan(Tsi(lp))) then
           print*,Tsi(lp),' ',l,' ',Td(l),' ',fak,' ',Eabssiz,' ',QBsi
       endif
       end if

       if(nabsc(lp) .ge.  1)   then
            if(taumax .le.1e-2) then
            Eabscz = dble(nabsc(lp))/(1000./taumax) * epak /(pi4 * UWmass)
            nabsc(lp) = int((nabsc(lp)/(1000/taumax)))
            else
            Eabscz     = nabsc(lp)  * epak / (pi4 * UWmass)
            endif
!         if (lp .eq. 4) print*, 'Eabscz aC = ',Eabscz,', epak = ',epak
        call locat(QBc, ntg, Eabscz, l)
			if (l.lt.1)   l=1
			if (l.ge.ntg-1) l=ntg-1
        fak        = (Td(l+1) - Td(l)) / (QBc(l+1) - QBc(l)) 
        Tc(lp)     = Td(l) + fak * (Eabscz - QBc(l))
       end if 

! zur Berechnung der midplane Temperatur und des 
! vertikalen Temperatur Profils, beide azimuthal gemittelt:
         if(input%structure.eq.4) then
                xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
                yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
                zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
                zz     = z(k)  + (kk - 5d-1) * dl-zorg
                rr     = sqrt(xx2 + yy2) 
           if(rr.ge.rinner.and.rr.le.router) then
                call  locat(rmid,  nmid, rr, l) !nlocat geht daneben !
                if(l.lt.1)    l = 1
                if(l.gt.nmid) l = nmid
                call nlocat(zvert, nzUW, zz, iz)

!              setzen Anzahl der UW in x,y Ebene 
                nUWTz(iz,l)  =  nUWTz(iz,l) + 1

!  Absorbierte Photonen
                 if(nabsc(lp).lt.1) noabsTz(iz,l) = noabsTz(iz,l)+ 1
                 if(nabsc(lp).ge.1) Temz(iz,l)    = Temz(iz,l) + Eabscz 

! zum testen:
         if((abs(zvert(iz)-zz)/zz-1.) .ge. 1e-4) then
           write(6,'(1p4e10.2, 2x,a20)') rr, rmid(l)/rr, zz, &
&           zvert(iz)/zz, 'check zz'
          endif

! write(36,'(2i4,i8,1p4e10.2)') l, iz, lp, rr, rmid(l), zvert(iz), tc(lp)

end if
end if
! ende rinner < r < router:

end do
end do
end do
end do
end do
end do
!close(36)


    if(input%structure.eq.4) then
! Berechnung vertikales Temperatur Profil:
      do  i             = 1, nmid
      do  iz            = 1, nzUW
!       if(nUWTz(iz,i).lt. noabsTz(iz,i)) then 
!        print*, 'nUWTz<noabs ?', nUWTz(iz,i), noabsTz(iz,i), iz, i
!       end if

       if(Temz(iz,i) .ge. 1. .and.nUWTz(iz,i) .ge.1)   then
        Eabscz     = Temz(iz,i)/float(nUWTz(iz,i))
        call locat(QBc, ntg, Eabscz, l)
			if (l.lt.1)   l=1
			if (l.ge.ntg) l=ntg-1
        fak         = (Td(l+1) - Td(l)) / (QBc(l+1) - QBc(l))
        Temz(iz,i)  =  Td(l)   + fak * (Eabscz - QBc(l))
       endif
      end do 
      end do

!
! Temperatur Profile Tmid, Ttop und Temz werden durch gewichtete Mittlung
! geglaettet:
! 0) Sicherungskope der variablen Temz auf temzOrg vor Mittelung:

!$omp parallel do private(i)
           do   i          = 1, nmid
!$omp parallel do private(ii)
            do ii          = 1,nzUW
             TemzOrg(ii,i) = Temz(ii,i) 
            end do
!omp end parallel do
            end do
!omp end parallel do
!
! ------------------------------------------------
! falls bei rinner nUWTz = 0 ersetzte Temz(iz,1)
        do iz        = 1, nzUW
         if(temz(iz,1).eq.0 .and.nUWTz(iz,1).eq.0) then
          temz(iz,1) = temz(iz,2)
         end if
! ersetzte durch Temp. in vertikaler Richtung bei i=1
          if(temz(iz,1).eq.0 .and.nUWTz(iz,1).eq.0) then
           k = iz
           do while(temz(k,1).eq.0 .and.k.lt.nzUW)
             k = k+1
           end do
           do kk = iz, k
              temz(kk,1) = temz(k,1)
            end do
          end if
! ersetzte durch Temp. in vertikaler Richtung bei i=2
          if(temz(iz,1).eq.0 .and.nUWTz(iz,1).eq.0) then
           k = iz
           do while(temz(k,2).eq.0 .and.k.lt.nzUW)
             k = k+1
           end do
            do kk = iz, k
              temz(kk,1) = temz(k,2)
            end do
           end if

         if(temz(1,1).eq.0 .and.nUWTz(1,1).eq.0) then
          print*, ' kann eigentlich nicht sein'
          print*, iz, nUWTZ(iz,1), temz(iz,1), temz(iz,2)
         endif
        end do
        print*, ' '

       do i        = 1, nmid
        tauz0       = 0.
        dtauz       = 0.
        iz          = nzUW
        dl          = zvert(iz)-zvert(iz-1)
        dtauz       = Cext_V *dl*rhoz(iz,i)
        tauz0       = max(tauz0  + dtauz, 1.e-40)
        if(rhoz(iz,i) .gt.rhomin) &
&         write(25,'(2i4,1p2e11.3,1x,3i4,3e10.2,1x,2i5)') & 
&  i, iz, rmid(i), zvert(iz),  isotr(i), ibotr(i), itopr(i), &
& rhoz(iz,i),  Temz(iz,i), tauz0, nUWTz(iz,i), noabsTz(iz,i)

        do iz       = nzUW-1, 1, -1
            dl      = zvert(iz+1)-zvert(iz)
            dtauz   = Cext_V *dl*rhoz(iz,i)
        tauz0       = max(tauz0  + dtauz, 1.e-40)
        if(rhoz(iz,i) .gt.rhomin) &
&       write(25,'(2i4,1p2e11.3,1x,3i4,3e10.2,1x,2i5)') & 
&  i, iz, rmid(i), zvert(iz),  isotr(i), ibotr(i), itopr(i), &
& rhoz(iz,i),  Temz(iz,i), tauz0, nUWTz(iz,i), noabsTz(iz,i)
         end do
         end do
       close(unit=25)
end if
!
! -------------------------------------------------
! null setzen:
        if (iter.ne.itdisk) then 
         print*, ' *   Null setzten der Variablen: iabspah,isca,iabs'
         iwp    = 0
         ispah  = 0
!$omp parallel do private(i1,i2)
         do i1 = 1,isumuw!naw
                iabspah(i1) = 0
                isca(i1) = 0
                iabs(i1) = 0
         end do 
         do i1 = 1,nd
         do i2 = 1,nthet
                iphd(i1,i2) = 0
                iphs(i1,i2) = 0
         end do
         end do
!omp end parallel do

!$omp parallel do private(i1)
         do i1 = 1,mpabs
                ipahlp(i1) = 0
                ipahfr(i1) = 0
         end do
!omp end parallel do

        end if

!    ende zum ausschreiben der Temperaturen
!   ---------------------------------------------------------------------------
!   Ausdruck: Temperaturen zu allen Hoehen z entlang x=0 od. y=0:

     if(input%structure.eq.4) then
      open(unit=2, file='output/L.Tem', form='formatted')
      rewind 2
      write(2,*), '# l  iz        rr       zz        TemzOrg   Temz      Tc '
!     entlang x:
           j = 1
           jj= 1
      do   i = 1, nx
      do   k = 1, nz
       ntz   = netz(i,j,k)
       dl    = dGW / ntz
       do ii = 1, ntz
       do kk = 1, ntz
       lp    = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
       xx2   = (x(i) + (ii - 5d-1) * dl-xorg)**2
       yy2   = (y(j) + (jj - 5d-1) * dl-yorg)**2
       zz    = z(k)  + (kk - 5d-1) * dl-zorg
       rr    = sqrt(xx2 + yy2)  
       if(rr.ge.rinner.and.rr.le.router) then
          call  locat(rmid,  nmid, rr, l) !nlocat geht daneben !
          if(l.lt.1)    l = 1
          if(l.gt.nmid) l = nmid
          call nlocat(zvert, nzUW, zz, iz)
        if(dicht(lp).gt.0) write(2,'(2i4,5x,1p5e10.2)') l, iz, rr, zz, &
&                          temzOrg(iz,l), temz(iz,l), Tc(lp)
        end if
       end do
       end do
       end do
       end do
!     entlang y:
          i  = 1
          ii = 1
      do   j = 1, ny
      do   k = 1, nz
       ntz   = netz(i,j,k)
       dl    = dGW / ntz
       do jj = 1, ntz
       do kk = 1, ntz
       lp    = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
       xx2   = (x(i) + (ii - 5d-1) * dl-xorg)**2
       yy2   = (y(j) + (jj - 5d-1) * dl-yorg)**2
       zz    = z(k)  + (kk - 5d-1) * dl-zorg
       rr    = sqrt(xx2 + yy2)  
       if(rr.ge.rinner.and.rr.le.router) then
          call  locat(rmid,  nmid, rr, l) !nlocat geht daneben !
          if(l.lt.1)    l = 1
          if(l.gt.nmid) l = nmid
          call nlocat(zvert, nzUW, zz, iz)
        if(dicht(lp).gt.0) write(2,'(2i4,5x, 1p5e10.2)') l, iz, rr, zz, &
&                          temzOrg(iz,l), temz(iz,l), Tc(lp)
        end if
       end do
       end do
       end do
       end do
      end if
      close(unit=2)
!      stop ' *** End test ohne averaging result file:  L.Tem '

!  ----------------------------------------------
!   Ausdruck: cut along orgin: temp. und tau's:
!
     open(unit=2, file='output/L.Ttau', form='formatted')
     rewind 2
     write(2,*) ' Cut along origin '
     write(2,164)
164  format(/ 14x, 'x', 8x, 'rhox', 5x, 'TSi', 10x, 'iSiabs',2x, 'TaC', 8x, 'iaCabs', 2x,'tauVx', 7x, 'isca', 6x, 'lp')

        tauV = 0.
        j1   = 1
        k1   = 1
        if (idim3.eq.1) then  
           j1 = ny/2 + 1
           k1 = nz/2 + 1
           jj1=netz(1,j1,k1)/2+1
           kk1=netz(1,j1,k1)/2+1
        else
           jj1 = 1
           kk1 = 1
        endif
     do  i  = 1, nx
     do  ii = 1, netz(i,j1,k1)
     xx = x(i) + (ii-1) * dGW / netz(i,j1,k1)
     lp = netsum(i,j1,k1) -  netz(i,j1,k1)**3 + netz(i,j1,k1)**2 * (ii - 1)+ netz(i,j1,k1) * (jj1 - 1) + kk1
     dtauV   = Cext_V * dicht(lp) * dGW / netz(i,j1,k1)

     write(2,138) i,ii, xx, dicht(lp), Tsi(lp), nabssi(lp), Tc(lp), nabsc(lp), tauV, isca(lp), lp
138  format(2i4,1pe11.3, 2e10.2,1x,i9,1x,1e10.2,1x,i9,1e10.2,1x,i8,i8)
     tauV  = tauV + dtauV
     end do
     end do
     xx = nx * dGW
     write(2,136) i, xx, tauV
136  format(i4, 1pe15.3, 11x, 1p1e12.3)

 

     write(2,167)
167  format(/ 14x, 'y', 8x, 'rhoy', 5x, 'TSi', 10x, 'iSiabs',2x, 'TaC', 8x, 'iaCabs', 2x,'tauVy', 7x, 'isca', 6x, 'lp')

        tauV = 0.
        i1   = 1
        k1   = 1
        if (idim3.eq.1) then  
           i1 = nx/2 + 1
           k1 = nz/2 + 1
           ii1=netz(i1,1,k1)/2+1
           kk1=netz(i1,1,k1)/2+1
        else
           ii1 = 1
           kk1 = 1
        endif

     do  j  = 1, ny
     do  jj = 1, netz(i1,j,k1)
     yy = y(j) + (jj-1) * dGW / netz(i1,j,k1)
     lp = netsum(i1,j,k1) - netz(i1,j,k1)**3 + netz(i1,j,k1)**2 * (ii1 - 1) +     netz(i1,j,k1) * (jj - 1) + kk1
     dtauV   = Cext_V * dicht(lp) * dGW / netz(i1,j,k1)

     write(2,138) j,jj, yy, dicht(lp), Tsi(lp), nabssi(lp), Tc(lp), nabsc(lp), tauV, isca(lp), lp
     tauV  = tauV + dtauV
     end do
     end do
     yy = ny * dGW
     write(2,136) j, yy, tauV

     write(2,168)
168  format(/ 1x, 'x=rinner:    z', 8x, 'rhoz', 5x, 'TSi', 10x, 'iSiabs',2x, 'TaC', 8x, 'iaCabs', 2x,'tauVz', 7x, 'isca', 6x, 'lp')


! along z -axis at r=rinner:
        tauV = 0.
        if (idim3.eq.1) then  
           i1 = nx/2 + 1
           j1 = ny/2 + 1
           ii1=netz(i1,j1,1)/2+1
           jj1=netz(i1,j1,1)/2+1
        else
           ii1 = 1
           jj1 = 1
        endif
!        rtest = rinner + xorg
        rtest = xorg
        call locat (x, nx, rtest, i1)
        i1 = i1 + 1
        if(i1 .gt. nx)  i1 = nx
     do  k  = 1, nz
     do  kk = 1, netz(i1,j1,k)
     zz = z(k) + (kk-1) * dGW / netz(i1,j1,k)
     lp = netsum(i1,j1,k) - netz(i1,j1,k)**3 + netz(i1,j1,k)**2 * (ii1 - 1) +   netz(i1,j1,k) * (jj1 - 1) + kk
     dtauV   = Cext_V * dicht(lp) * dGW / netz(i1,j1,k)

     write(2,138) k,kk, zz, dicht(lp), Tsi(lp), nabssi(lp), Tc(lp), nabsc(lp), tauV, isca(lp), lp
     tauV  = tauV + dtauV
     end do
     end do
     zz = nz * dGW
     write(2,136) k, zz, tauV

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     print *, '    Zahl der Absorptionen im innersten UW =', iabs(1)
     close(unit=2)

         if(iter .eq.1) file = 'output/grid_1.bin'
         if(iter .eq.2) file = 'output/grid_2.bin'
         if(iter .eq.3) file = 'output/grid_3.bin'
         if(iter .eq.4) file = 'output/grid_4.bin'
         if(iter .eq.5) file = 'output/grid_5.bin'
         if(iter .eq.6) file = 'output/grid_6.bin'
         if(iter .eq.7) file = 'output/grid_7.bin'
         if(iter .eq.8) file = 'output/grid_8.bin'
         if(iter .eq.9) file = 'output/grid_9.bin'
         if(iter .eq.10) file = 'output/grid_10.bin'
         if(iter .eq.11) file = 'output/grid_11.bin'
         if(iter .gt.11) stop ' iter >11 not foreseen'
        if(iter .gt.1) open(unit=22, file=file, form='unformatted')
        file = 'output/grid.bin'
        open(unit=23, file=file, form='unformatted')
     	rewind 22
     	rewind 23
     	        if(iter .gt.1) write(22),netsum(nx,ny,nz)
     	                       write(23),netsum(nx,ny,nz)
                               write(22),dgw,rinner,router
                               write(23),dgw,rinner,router

	do ix=1,nx
	do iy=1,ny
	do iz=1,nz
	    if(iter .gt.1) write(22),ix,iy,iz,netz(ix,iy,iz)
	  	           write(23),ix,iy,iz,netz(ix,iy,iz)
	end do	
	end do
	end do
             if(iter .gt.1) close(unit=22)
                            close(unit=23)
     if (idim3.ne.1) then 
        ix=1
        iy=1
        iz=1
        iux=1
        iuy=1
        iuz=1
      else
        ix=int(xorg/dgw)+1!nx/2+1
        iy=int(yorg/dgw)+1!ny/2+1
        iz=int(zorg/dgw)+1!nz/2+1
        iux=int((xorg-dgw*(ix-1))/(dgw/netz(ix,iy,iz)))+1!netz(ix,iy,iz)/2+1
        iuy=int((yorg-dgw*(iy-1))/(dgw/netz(ix,iy,iz)))+1!netz(ix,iy,iz)/2+1
        iuz=int((zorg-dgw*(iz-1))/(dgw/netz(ix,iy,iz)))+1!netz(ix,iy,iz)/2+1
     endif
     lp = netsum(ix,iy,iz) - netz(ix,iy,iz)**3 + netz(ix,iy,iz)**2 * (iux-1) + netz(ix,iy,iz) * (iuy-1) + (iuz-1) + 1
     Tsi(lp)=-Tstar
!radius star see Unsoeld p. 174 
     Tc(lp)=-sqrt(Lquelle/Tstar**4/pi4/sigma)
	print*,lp,ix,iy,iz,iux,iuy,iuz


         if(iter .eq.1) file = 'output/absorbtion_1.bin'
         if(iter .eq.2) file = 'output/absorbtion_2.bin'
         if(iter .eq.3) file = 'output/absorbtion_3.bin'
         if(iter .eq.4) file = 'output/absorbtion_4.bin'
         if(iter .eq.5) file = 'output/absorbtion_5.bin'
         if(iter .eq.6) file = 'output/absorbtion_6.bin'
         if(iter .eq.7) file = 'output/absorbtion_7.bin'
         if(iter .eq.8) file = 'output/absorbtion_8.bin'
         if(iter .eq.9) file = 'output/absorbtion_9.bin'
         if(iter .eq.10) file = 'output/absorbtion_10.bin'
         if(iter .eq.11) file = 'output/absorbtion_11.bin'
         if(iter .gt.11) stop ' iter >11 not foreseen'
         if(iter .gt.1) open(unit=22, file=file, form='unformatted')
         file = 'output/absorbtion.bin'
         open(unit=23, file=file, form='unformatted')
        rewind 22
        rewind 23
	do ix=1,nx
	do iy=1,ny
	do iz=1,nz
           ntz = netz(ix,iy,iz)
           dl  = dGW / ntz

		do iux=1,ntz
		do iuy=1,ntz
		do iuz=1,ntz
			lp = netsum(ix,iy,iz) - netz(ix,iy,iz)**3 + netz(ix,iy,iz)**2 * (iux-1) + netz(ix,iy,iz) * (iuy-1) + (iuz-1) + 1
	        if(iter .gt.1) write(22),lp,ix,iy,iz,iux,iuy,iuz,Tsi(lp),Tc(lp),dicht(lp)
	write(23),lp,ix,iy,iz,iux,iuy,iuz,Tsi(lp),Tc(lp),dicht(lp)
	     	end do
		end do
		end do
	end do	
	end do
	end do
             if(iter .gt.1) close(unit=22)
     close(unit=23)

if(input%structure .eq. 8) then
   open(unit=22, file='output/star_temps.txt',form='formatted')

   ix=input%P(6)
   iy=ny/2 + 1
   iz=nz/2 + 1
   
   write(22,298)
298 format(/ 3x, 'x',3x,'y',3x,'z',3x,'xx',3x,'yy',3x,'zz',3x,'rho',3x,'Tc',3x,'Tsi',3x,'lp')
   ntz = netz(ix,iy,iz)
   ntsum = netsum(ix,iy,iz)
   do ii = 1, ntz
      do jj = 1, ntz
         do kk = 1, ntz
            lp     = ntsum - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
            write(22,299) ix,iy,iz,ii,jj,kk,dicht(lp),Tc(lp),Tsi(lp),lp
         enddo
      enddo
   enddo
299 format(6i4,3e10.2,i8)
endif


print*, '    ***  end subroutine Toutput'
                  end subroutine Toutput

subroutine Sca_output(iter)
use parameter
use constants
implicit none

        integer,allocatable :: scatters(:,:), sum_sca_freq_block(:),sca_pos(:)
        type(sca_store),allocatable :: anisoscatters(:)
        integer         :: freq_lines(nf),isumsca
        integer         :: iread,jread,jstop,nbuffer=0
        integer         :: tempf,tempW,blocks,iblock,iter
	integer		:: ix,iy,iz,iux,iuy,iuz
        integer*8       :: filepos !need long int or large number of scatters causes overflow
        real*8          :: tempx

isumsca = 0
     do  i = 1, isumuw
      isumsca = isumsca + isca(i)
     end do

!----------SORT SCATTERING OUTPUT FILE BY FREQUENCY-------------

if (i_iso .le. 0) then !isotropic/(1-g) scattering

OPEN(unit=23, file='output/scatters_temp.bin', form='unformatted', status='OLD', access = 'stream')
rewind 23
!read file through once to add up number of scatters per frequency
allocate(sum_sca_freq(nd,2))
sum_sca_freq(:,:) = 0
do jread = 1,isumsca

   read(23) tempf,tempW
   sum_sca_freq(tempf,1) = sum_sca_freq(tempf,1) + 1
enddo
rewind 23
tempf = 0
!now insert do loop to add up scatters per freq. then write look-up table to file
do jread = 1, nd
   tempf = tempf + sum_sca_freq(jread,1)
   sum_sca_freq(jread,2) = tempf
enddo

!check total adds up!
if (isumsca .ne. sum_sca_freq(nd,2)) stop 'sum of scatters incorrect'


open(unit=24, file='output/sum_scatters.txt', form='formatted', status='replace')

!write scatters
do jread = 1,nd
write(24,169),jread,sum_sca_freq(jread,1),sum_sca_freq(jread,2)
169 FORMAT (i4, 2x, i12, 2x, i16)
enddo
close(unit=24)

!write out large file of zeros to store results in
tempf = 0
tempx = 0.
open(unit = 25, file = 'output/scatters.bin', form = 'unformatted', status = 'replace', access = 'stream')
do jread = 1, isumsca
   write(25) tempf
enddo

!read in blocks of scatters

if (isumsca .lt. 26214400) then !less than 26214400 scatters, only need to read one block
   jstop = isumsca
   blocks = 1
else !more than 2621440 scatters, need to read several blocks
   jstop = 26214400
   blocks = (isumsca/26214400) + 1
endif


allocate(sca_pos(nd))
filepos = 1
sca_pos = 0

!print*,'blocks = ',blocks

do iblock = 1,blocks !loops over required number of 200MB blocks
   print*,'starting block ',iblock
   if ((iblock .eq. blocks) .and. (blocks .gt. 1)) jstop=isumsca-((blocks-1)*jstop) !prevents end of file error in final iteration through loop
   allocate(scatters(jstop,2)) !allocates up to 200MB for reading in file - will repeat reading if necessary

   scatters = 0
   print*,'array allocated'
   do jread=1,jstop !read each 200MB block
      read(23) scatters(jread,1),scatters(jread,2)
   enddo
   print*,'block ',iblock,' read'
!sort block of scatters
   call heapsort2(scatters,jstop,2)

!write sorted scatters to file in correct positions
print*,'block sorted'
   do jread = jstop,1,-1
      if (scatters(jread,1) .eq. 1) then !if jf = 1 has scatters, would get array out of bounds errors with 'else' case
         filepos = 1+(sca_pos(scatters(jread,1))*4)
      else
         filepos = (sum_sca_freq((scatters(jread,1)-1),2) + sca_pos(scatters(jread,1))) !find position by adding cumulative scatters at frequency of interest and number of scatters written so far at that frequency
         filepos = 1 + filepos*4 !convert position to bytes
      endif
      sca_pos(scatters(jread,1)) = sca_pos(scatters(jread,1)) + 1 !increment number of scatters written at frequency of interest
      write(25,POS=filepos),scatters(jread,2) !write lp number of scatter
   end do
print*,'block written'
deallocate(scatters)
end do

!------------------ANISOTROPIC SCATTERING---------------------------------!
elseif(i_iso .gt. 0) then !aniso case, needs directions too!
OPEN(unit=23, file='output/scatters_temp.bin', form='unformatted', status='OLD', access = 'stream')
rewind 23
!read file through once to add up number of scatters per frequency
allocate(sum_sca_freq(nd,2))
sum_sca_freq(:,:) = 0
do jread = 1,isumsca
   read(23) tempf,tempW,tempx,tempx,tempx
   sum_sca_freq(tempf,1) = sum_sca_freq(tempf,1) + 1
enddo
rewind 23
tempf = 0
!now insert do loop to add up scatters per freq. then write look-up table to file
do jread = 1, nd
   tempf = tempf + sum_sca_freq(jread,1)
   sum_sca_freq(jread,2) = tempf
enddo

!check total adds up!
if (isumsca .ne. sum_sca_freq(nd,2)) stop 'sum of scatters incorrect'

open(unit=24, file='output/sum_scatters.txt', form='formatted', status='replace')

!write scatters
do jread = 1,nd
write(24,169),jread,sum_sca_freq(jread,1),sum_sca_freq(jread,2)
!169 FORMAT (i4, 2x, i12, 2x, i16)
enddo
close(unit=24)

!write out large file of zeros to store results in
tempf = 0
tempx = 0.
open(unit = 25, file = 'output/scatters.bin', form = 'unformatted', status = 'replace', access = 'stream')
do jread = 1, isumsca
   write(25) tempf,tempx,tempx,tempx
enddo

!read in blocks of scatters

if (isumsca .lt. 2621440) then !less than 26214400 scatters, only need to read one block
   jstop = isumsca
   blocks = 1
else !more than 2621440 scatters, need to read several blocks
   jstop = 2621440
   blocks = (isumsca/2621440) + 1
endif

!allocate(sum_sca_freq_block(nd))
allocate(sca_pos(nd))
filepos = 1
sca_pos = 0


do iblock = 1,blocks !loops over required number of 200MB blocks
   print*,'starting block ',iblock

   if ((iblock .eq. blocks) .and. (blocks .gt. 1)) jstop=isumsca-((blocks-1)*jstop) !prevents end of file error in final iteration through loop
   allocate(anisoscatters(jstop)) !allocates up to 200MB for reading in file - will repeat reading if necessary
   anisoscatters%jf=0
   anisoscatters%lp=0
   anisoscatters%x=0
   anisoscatters%y=0
   anisoscatters%z=0
   print*,'array allocated'
   do jread=1,jstop !read each 200MB block
      read(23) anisoscatters(jread)%jf,anisoscatters(jread)%lp,anisoscatters(jread)%x,anisoscatters(jread)%y,anisoscatters(jread)%z
   enddo
   print*,'block ',iblock,' read'
!sort block of scatters
   call heapsort_sca(anisoscatters,jstop)

!write sorted scatters to file in correct positions
print*,'block sorted'
   do jread = jstop,1,-1
      if (anisoscatters(jread)%jf .eq. 1) then !if jf = 1 has scatters, would get array out of bounds errors with 'else' case
         filepos = 1+(sca_pos(anisoscatters(jread)%jf)*28)
      else
         filepos = (sum_sca_freq((anisoscatters(jread)%jf-1),2) + sca_pos(anisoscatters(jread)%jf)) !find position by adding cumulative scatters at frequency of interest and number of scatters written so far at that frequency
         filepos = 1 + filepos*28 !convert position to bytes
      endif
      sca_pos(anisoscatters(jread)%jf) = sca_pos(anisoscatters(jread)%jf) + 1 !increment number of scatters written at frequency of interest
      if (anisoscatters(jread)%lp .gt. isumuw) then
         print*,'lp incorrect'
         stop
      endif
      write(25,POS=filepos),anisoscatters(jread)%lp,anisoscatters(jread)%x,anisoscatters(jread)%y,anisoscatters(jread)%z !write lp and direction of scatter
   end do
print*,'block written'
!print*,sum(sca_pos)
deallocate(anisoscatters)
end do
endif

close(unit=23)

close(unit=25)
deallocate(sca_pos)
deallocate(sum_sca_freq)

print*, '    ***  end subroutine Sca_output'
                  end subroutine Sca_output
