      subroutine Bahnpah(init)

!     Emission der PAH.  Annahme: PAH absorbieren nur Sternstrahlung,
!     keine Staubstrahlung.  Zunächst werden nur die vom Stern
!     ausgesandten N' Pakete verfolgt, die vom MRN-Staub absorbiert
!     wurden.  Am Ende hat man Gleichgewichtskonfiguration.  Es
!     verbleiben N" = nzyk*nf - N' Pakete für die PAH, berechnet in
!     Bahnpah.  In Zelle v gebe es n PAH Arbsorptionen.  Man berechnet
!     dazu P(T) , und Zelle v ist dann eine neue, vom Stern verschiedene
!     Quelle für die Wolke.  iwp = Zahl der UW mit PAH-Absorption Der
!     i-te UW mit PAH-Absorption hat lp = lp_zu_iwp(i). 
!     PAH Verdampfung: 
!         kritische Energie:   Ecr=0.1*Nc*Eo (mit Eo ~ 5eV)
!     1a: i) innerhalb der K"uhlungszeit kommt absorbiert PAH
!          X-ray
!         ii) Bei Scheiben: vcr > vturb (eq.23 in SK2010)
!     1b) innerhalb einer K"uhlungs-Zeit~1sec, die absorbierte Energie,
!     aller Photonen Ea > pahnum*Ecr. 
!     2: Vorsicht nur wegen cpu: die Anzahl der vom PAH absorbierten
!     Photonen kleiner ist als 1% (?) aller Absorbtionen (im UW).
!     3: Falls PAH im UW verdampfen oder unwichtig sind (inopah=1)
!     wird photon als Sternphoton betrachtet mit Richtung gegeben
!     durch Stern und Mittelpkt. des UW.  Hinweis: Frequenzen: jf
!     bezgl Staub und jjf begzl. Stern.  Setzte jjf =0 um zu
!     kennzeichnen das PAH absorbtion vorliegt also Packet nicht vom
!     Stern kommt.
! -----------------------------------------------------------------------
!
use type_module
use constants
use parameter
use omp_lib
implicit none
      type(init_type)    :: init
      type(float_vector) :: a,a_uw, d,get_direction
      real*8             :: sumQBkT, Revpm,Revpx,Revpy,Revpz
      real*8             :: QBkT(nd), Bpw(nd)
      real*8             :: ran1,ran2
      real*8             :: UWmass, dUW,abstand,abs_xy,Ea,fak,Ngamdes
      real*8             :: ephot
      real*8,external    :: bpl
      integer            :: nphot_wolke, neva, nevaX
      integer            :: mi,mj,mk,mii,mjj,mkk
      integer            :: ii,jj,kk,netzijk,ll,lpr, lpi
      integer            :: jjf,ivv, nn
      integer            :: jjf_loc,jf_loc, jpah_loc, jsca
      integer*2          :: sxa, sya, sza


! -----------
      print*, ' '
      print*, ' -------------------------------- '
      print*, ' ***  Bahnpah: Reemission der PAH ' 
      print*, ' -------------------------------- '
      open(unit=20, file='./output/pah_lpTpw.out', form='formatted')
      open(unit=25, file='./output/Lpah.info', form='formatted')
      open(unit=30, file='./output/Lpah.wo',   form='formatted')
      open(unit=22, file='./output/Lpah.eva',  form='formatted')
      open(unit=23, file='./output/Lpah.emis', form='formatted')
!      open(unit=24, file='./output/Lpah.negl', form='formatted')
!      write(24,211)
      write(30,211)
      write(22,211)
      write(23,211)

 211  format('  E         x         y         z         Dis    iabspah  iabs')
   221    format(1p5e9.2, 1x, i9,1x,i9, 1x, 2e10.2)

!
! ------------------------------------
! Sortieren der pah absorptionen nach lp


       if(mpabs .ge. 1000000) print*,' start asort'
       call asort_i(mpabs,ipahlp,ipahfr)
!        zum testen: index UW, abs-frequenz
         if(ibug .ge.3) then
            do   izyk        = 1, iwp
              lp             = lp_zu_iwp(izyk)
              call locat_i(ipahlp,mpabs,lp, ilpi)  
              do iav         = 1, iabspah(lp)
               if(iabspah(lp) .gt. 1) print*,   lp, iav, ipahfr(ilpi+iav), ilpi
              end do
             end do
          endif
            do   izyk        = 1, iwp
              lp             = lp_zu_iwp(izyk)
            end do
        if(mpabs .ge. 1000000) print*,' end asort'

!
! ------------------------------------
!
       jpah   = 0  ! Packete werden nicht mehr durch PAH absorbiert
       neva   = 0
       arad   = sqrt(zcpah/1.2) * 1d-8
       xatom  = zcpah + zhpah                         !Zahl der Atome in PAH

!  Schleife über alle UW mit PAH-Absorption

      Revpm   = 0.
      Revpx   = 0.
      Revpy   = 0.
      Revpz   = 0.
      nUWpah  = 0          ! number of UW with PAH emission
      nphot_wolke = 0      ! number of photons die wolke verlassen
!
! fur alle iwp = Durchnumerierung der Zellen mit Abs durch PAHs
!

print*, ! fur alle iwp = Durchnumerierung der Zellen mit Abs durch PAHs', iwp
     do  48   izyk = 1, iwp
              lp    = lp_zu_iwp(izyk)
!             Packete von PAH absorbiert aus UW: ipahlp(ilpi):
              call locat_i(ipahlp,mpabs,lp, ilpi)  
       if(mod(izyk,iwp/10) .eq.0) &
     &                print*, '    * Bahnpah:UW mit PAH abs =', izyk, ' von: ', iwp, lp,ilpi
       if(izyk.eq. 1) print*, '    * Bahnpah:UW mit PAH abs =', izyk, ' von: ', iwp, lp,ilpi

!print*, '    * Bahnpah:UW mit PAH abs =', izyk, ' von: ', iwp, lp,ilpi,iabspah(lp)
       if(iabspah(lp) .lt. 1) goto 48
!   ---------------------------------------------------------------------------
!   Vom PAH emittiertes Paket startet vom GW (mi,mj,mk) und UW (mii,mjj,mkj)
      do   i = 1, nx
      do   j = 1, ny
      do   k = 1, nz
         if(netsum(i,j,k) .ge. lp)   then
         mi = i
         mj = j
         mk = k
         go to 6
         end if
      end do
      end do
      end do
 6    continue
      netzijk = netz(mi,mj,mk)
      do  ii = 1, netzijk
      do  jj = 1, netzijk
      do  kk = 1, netzijk
        ll  = netzijk**2 * (ii - 1) + netzijk * (jj - 1) + kk
        lpr = netsum(mi,mj,mk) - netzijk**3 + ll
          if(lpr .eq. lp)   then
          mii = ii
          mjj = jj
          mkk = kk
          go to 7
          end if
      end do
      end do
      end do
 7    continue


! Anzahl der PAHs im UW:
      UWmass = dicht(lp) * (dgw/netzijk)**3
      pahnum = pahmass * UWmass / (12d0*zcpah + zhpah) / protm

!   AP des Pakets hat die Koordinaten a (type)
      dUW  = dGW / netzijk
      a%x  = x(mi) + (mii - 0.5) * dUW
      a%y  = y(mj) + (mjj - 0.5) * dUW
      a%z  = z(mk) + (mkk - 0.5) * dUW
      a_uw = a                               ! damit PAH  unten auch bei "a" startet
      abstand = sqrt((a%x-xorg)**2 + (a%y-yorg)**2 + (a%z-zorg)**2)
      abs_xy  = sqrt((a%x-xorg)**2 + (a%y-yorg)**2)


!   ---------------------------------------------------------------------------
!   PAHs: 
! 1: a,b -Verdampfung: 
! Ea = Gesamte von PAHs absorbierte Energie aller Photonen
! 2: wgen cpu: PAH emission zu berechnen?
! 3: Berechne P(T) der PAH nach Absorption von iabspah(lp) Paketen in pah
!   Radius des UW, wo PAHs verdampfen, [Einheit: Seitenlänge des innersten UW]
!   Falls zu viele PAH verdampfen Rechnung evtl. wiederholen und dabei in sub 
!   grid in manchen UW PAHs entfernen.


       Ea             = epak * iabspah(lp)
 
!     Ausschrieben wo PAH Anregungen vorliegen:
      write(30,221) Ea, a%x-xorg, a%y-yorg, a%z-zorg, abstand, &
&                   iabspah(lp),iabs(lp), Ecr*pahnum, pahnum

!
! 1a: X-ray Verdampfung durch inopah gesetzt in space





! 1b:  Verdampfung wegen gesamt energie
       if(Ea .ge. Ecr*pahnum .and.inopah(lp) .eq.0) then
          write(22,221) Ea, a%x-xorg, a%y-yorg, a%z-zorg, abstand, &
&                       iabspah(lp),iabs(lp), Ecr*pahnum, pahnum
          inopah(lp)   = 1
          neva  = neva + 1
       end if
! 3: PAH emission:
        if(inopah(lp).eq.0)  then 
          Revpm   = max(Revpm,abstand)
          Revpx   = max(Revpx,abs(a%x-xorg))
          Revpy   = max(Revpy,abs(a%y-yorg))
          Revpz   = max(Revpz,abs(a%z-zorg))
          nUWpah  = nUWpah + 1

           call pahpw
 
          write(20,'(2i12)') -lp,-lp
          write(20,'(1p2e12.4)') (tem(i), max(pw(i),1d-40), i=1,nnTvsg)

! Zur Frequenz jf der Reemission durch PAH 
          QBkT(1) = 0.
          do  k = 1, nd
           Bpw(k) = ( bpl(fd(k),fd3(k),tem(1)) * pw(1)  & 
&          + bpl(fd(k),fd3(k),tem(nnTvsg)) * pw(nnTvsg) ) / 2d0
           do  j = 2, nnTvsg - 1
             Bpw(k) = Bpw(k) + bpl(fd(k),fd3(k),tem(j)) * pw(j)
           end do
          fak = Bpw(k) * C_abs_pah(k) * dfd(k)
          if(k .ge. 2)   QBkT(k) = QBkT(k-1) + fak
          if(k .ge. 50 .and. fak/QBkT(k) .le. 1d-6)   then
             sumQBkT = QBkT(k)
             go to 4
          end if
         end do
 4      continue
        write(23,221) Ea, a%x-xorg, a%y-yorg, a%z-zorg, abstand, &
&                   iabspah(lp),iabs(lp), Ecr*pahnum,  pahnum
       endif

! --------------------------------------------
!   Reemission der iabspah(lp) Pakete aus dem UW
!   Anfangsrichtung und zugehöriger Einheitsvektor:
! 1.)    inopah(lp) = 0: PAH emission Berechnung  vom Zufallsgenerator
! 2.)    inopah(lp) = 1: Behandlung wie Sternphoton
!      jf_loc bezgl. Gitter vom Staub
!     jjf_loc bezgl. Gitter vom Stern
!    
!$omp parallel do firstprivate(a,d,k,jf_loc,jjf_loc,ran1,ran2,fak)
      do  47  ivv = 1, iabspah(lp)
       if(inopah(lp) .eq. 0) then 
!
! 1.)  PAH emission
! 1a   Richtung
                        if (old_random.eq.1) then 
                                call random_number(ran1)
                                call random_number(ran2)
                        else
                                ran1 = get_random(omp_get_thread_num())
                                ran2 = get_random(omp_get_thread_num())
                        endif 
			d = get_direction(ran1,ran2) 

! 1b:  Zur Frequenz jf der Reemission durch PAH vom Zufallsgenerator
        if (old_random.eq.1) then 
               call random_number(ran1)
        else
               ran1 = get_random(omp_get_thread_num())
        endif

       do  k = 1, nd
         if(QBkT(k)/sumQBkT .ge. ran1) then
         jf_loc  = k
         go to 12
         end if
       end do
       jf_loc   = nd
 12    continue
!  Packet nicht vom Stern bei jjf=0:
       jjf_loc  = 0

      else
!
! 2.) Sternphoton keine PAH emission ruecksaetzen von iabs(lp) um 1 packet
!     Richtiger einbau Frequenzgitter bezgl Stern (nicht Staub)
!
        a    = a_uw
        fak  = sqrt((a%x -xorg)**2+(a%y-yorg)**2+(a%z-zorg)**2)
        d%x  =   (a%x -xorg) / fak
        d%y  =   (a%y -yorg) / fak
        d%z  =   (a%z -zorg) / fak
        if(abs(d%x) .lt. 1d-10)   d%x = 1d-10
        if(abs(d%y) .lt. 1d-10)   d%y = 1d-10
        if(abs(d%z) .lt. 1d-10)   d%z = 1d-10
! hier zuruecksetzten so dass packet vom stern ausgestrahlt wird.
        a%x  =   xorg
        a%y  =   yorg
        a%z  =   zorg

!  !$omp atomic
!        iabs(lp) = iabs(lp) - 1
!
!      jf_loc bezgl. Gitter vom Staub
!     jjf_loc bezgl. Gitter vom Stern

        jf_loc = ipahfr(ilpi+ivv) !Nr der Freq im UW lp, bei der Abs stattfindet

        call locat_i(jd,nf,jf_loc,jjf_loc)       
        if (jjf_loc.lt.1)  jjf_loc = 1
        if (jjf_loc.gt.nf) jjf_loc = nf


        if (jjf_loc.gt.1 .and. jjf_loc.lt.nf) then
         if (jf_loc.ne.jd(jjf_loc))  jjf_loc = jjf_loc + 1
         if (jf_loc.ne.jd(jjf_loc))  jjf_loc = jjf_loc - 2
         if (jf_loc.ne.jd(jjf_loc))  call locat_i(jd,nf,jf_loc,jjf_loc)       
        end if

        if (jf_loc.ne.jd(jjf_loc)) & 
&       print*,welmud(jf_loc), welmu(jjf_loc), jjf_loc, jf_loc, jd(jjf_loc), ': jjf.ne.jf'


!-------

      end if

! ----


        if (jjf_loc.gt.nf) stop 'jjf to large  correct absorption'
        if (jjf_loc.lt.0) then
             print*, 'jjf_loc, jf_loc = ', jjf_loc, jf_loc
!             stop 'jjf <1 kann nicht sein?'
             print*, 'call go_trace'
        endif

        call go_trace(init,jf_loc,jjf_loc,a,d,jsca)
!$omp atomic
        nphot_wolke = nphot_wolke + 1

 47   continue
!$omp end parallel do

 48   continue

!   ---------------------------------------------------------------------------

      print *, ''
      print *, ' In sub Bahnpah verlassen',  nphot_wolke, ' Photonen die Wolke'
      write(6,'(a26)')    ' Anzahl PAH ...        : '
      write(6,'(a26,i12)') '    aller  Anregungen  = ', ispah
      write(6,'(a26,i12)') '    UW mit Anregungen  = ', iwp
      write(6,'(a26,i12)') '    UW mit Verdampfung = ', neva
      write(6,'(a26,i12)') '    UW mit X-destruct  = ', iXnopah
      write(6,'(a26,i12)') '    UW mit Emission    = ', nUWpah


      print *, 'PAHs gerechnet bis Radius [cm]: '
      write(6,'(a12,1p1e10.2)') '     max:  ', Revpm
      write(6,'(a12,1p1e10.2)') '       x:  ', Revpx
      write(6,'(a12,1p1e10.2)') '       y:  ', Revpy
      write(6,'(a12,1p1e10.2)') '       z:  ', Revpz

      write(25,'(a26)')    ' Anzahl PAH ...        : '
      write(25,'(a26,i12)') '    aller  Anregungen  = ', ispah
      write(25,'(a26,i12)') '    UW mit Anregungen  = ', iwp
      write(25,'(a26,i12)') '    UW mit Verdampfung = ', neva
      write(25,'(a26,i12)') '    UW mit X-destruct  = ', iXnopah
      write(25,'(a26,i12)') '    UW mit Emission    = ', nUWpah

      write(25,*) 'PAHs gerechnet bis Radius [cm]: '
      write(25,'(a12,1p1e10.2)') '     max:  ', Revpm
      write(25,'(a12,1p1e10.2)') '       x:  ', Revpx
      write(25,'(a12,1p1e10.2)') '       y:  ', Revpy
      write(25,'(a12,1p1e10.2)') '       z:  ', Revpz
      print *, ' '

      close(20)
      close(21)
      close(22)
      close(23)
      close(24)
      close(25)

! zur iteration von Scheibe zuruecksetzten von jpah:
      jpah = 1

      if(nuwpah .ge. mpabs) print*, ' memory error: nuwpah > mpabs'
      if(nuwpah .ge. mpabs) write(25,*) ' memory error: nuwpah > mpabs'

      return
      end

      subroutine pahpw
!     ------------------
! Berechnet Temperaturfluktuation eines PAHs durch Photonen Anregung 
! Input : ipahfr, izyk, iav
! Globale varibale ipahfr speichert das im UW (lp) das durch PAH
! absorbierte Photonpaket [iabspah(lp)] die Frequenz kTabs hat.
! Output: Temperaturfluktuation: tem, pw(tem)
! ----------------------------------------------
!
use constants
use parameter

implicit none
integer  :: imin, imax, ipwmax, jmaxpw, iterpw
real*8   :: Tfak, Tfak1,Tevap, dTemp, sumx, sum, sumpw, pwmax  
real*8   :: xx(nnTvsg)
real*8   ::  zphabs
!   Abschätzung der Temparatur für erste Einteilung von tem(i)

      if(ibug .ge. 3)  write(6,920) xatom, arad, nnTvsg
  920 format(/' ***   PAHs  ***' / &
      ' No of atoms =', 1pe10.2, ' PAH radius [cm]=', e10.2, &
      i6,' enthalpy bins')

      Tevap       = 2.5d3
      Tfak1       = 1d-12
      tem(1)      = 6d0
      tem(nnTvsg) = 6d3

! ----------------------------------------------------------------------------
      jmaxpw = 10
      do  40  iterpw = 1, jmaxpw

!  Festlegung der Temperatur-Intervalle

      dTemp  = (tem(nnTvsg) - tem(1)) / float(nnTvsg-1)
      do  i  = 2, nnTvsg
      tem(i) = tem(1) + (i-1)* dTemp
      end do

!  Berechnung der Enthalpie U(T)

      call enth

!  Schleife über alle iabspah(lp) Absorptionen im UW lp

      iav = 0
 1    continue

      do iav = 1, iabspah(lp)
       ktabs = ipahfr(ilpi+iav) ! Freq-Nr. im UW lp bei der Abs stattfindet
       call transmat
      end do

! ----------------------------------------------------------------------------
!   Berechnung des Zustandsvsktors, zuerst des nicht normierten 
!   xx(f) = pw(f)/pw(1), dann des normierten pw  ((Gl.(2.11) - (2.16)).

      xx(1)       = 1d0
      sumx        = xx(1)
      do 110  jf  = 2, nnTvsg

       sum         = 0.
       do  105  k   = 1, jf-1
       if(bt(jf,k)*xx(k) .lt. 0.) stop '** sub vsg ** :  bt * x < 0 '
       sum        = sum + bt(jf,k) * xx(k)
 105   continue

       xx(jf)     = sum  / att(jf-1,jf)
       sumx       = sumx + xx(jf)
 110  continue

      sumevap     = 0.
      sumpw       = 0.
      do  120  jf = 1, nnTvsg
      pw(jf)      = xx(jf) / sumx
      sumpw       = sumpw + pw(jf)
      if(tem(jf) .gt. Tevap)   sumevap = sumevap + pw(jf)
 120  continue

! ----------------------------------------------------------------------------
!  Bestimmung des Maximum pwmax vom Vektor pw und der Temperaturen, wo pw(i)
!  um Faktor Tfak1 = 1d12 abgefallen ist gegenüber pwmax.

      pwmax   = 0.
      ipwmax  = 0
      do  61  i = 3, nnTvsg
      if(pw(i) .le. pwmax)   go to 61
      ipwmax  = i
      pwmax = pw(i)
  61  continue

      imin = 1
      do  62  i = ipwmax-1, 2, -1
      if(pw(i) .ge. Tfak1*pwmax)   go to 62
      imin = i
      go to 2
  62  continue

   2  continue
      imax = nnTvsg
      do  63  i = ipwmax+1, nnTvsg
      if(pw(i) .ge. Tfak1*pwmax)   go to 63
      imax = i
      go to 3
  63  continue
   3  continue

!      i1 = 1
!      if(iabspah(lp) .ge. 1)  print 265, 
!     $ iterpw,    i1,      ipwmax,      nnTvsg,      imin,      imax,
!     $         tem(1), tem(ipwmax), tem(nnTvsg), tem(imin), tem(imax), 
!     $          pw(1),  pw(ipwmax),  pw(nnTvsg),  pw(imin),  pw(imax),
!     $ izyk, iav, iabspah(lp)
! 265  format(i3, 5i10 / ' T  =', 0p5f10.1 / , ' pw =', 1p5e10.2, 3i4)

! ----------------------------------------------------------------------------
!  Eventuell neue Einteilung des Temperaturgitters

      if(iterpw .eq. jmaxpw)   go to 4
      if(pw(nnTvsg) .lt. 1d-6 .and. pw(1) .lt. 1d-6) go to 4
      if(pw(nnTvsg) .lt. 1d-6 .and. pw(1) .ge. 1d-6 .and. tem(1).lt.3.1) go to 4

      Tfak = 1.25
      if(imin .eq. 1)       tem(1)      = max(3.1d0, tem(1) / Tfak)
      if(imin .gt. 1)       tem(1)      = tem(imin)

      if(imax .lt. nnTvsg)  tem(nnTvsg) = tem(imax)
      if(imax .eq. nnTvsg)  then
         if (pw(imax) .eq. 0.d0) Tfak=2.
         tem(nnTvsg) = tem(nnTvsg) * Tfak
      end if


!      write(6,265) jmaxpw, iterpw, ipwmax,  nnTvsg, imin,      imax,  &
!              tem(1), tem(ipwmax), tem(nnTvsg), tem(imin), tem(imax), & 
!               pw(1),  pw(ipwmax),  pw(nnTvsg),  pw(imin),  pw(imax)
 40   continue
 4    continue
! ----------------------------------------------------------------------------
!      fevap  = 1d-8
!      if(sumevap .gt. fevap)   inopah(lp) = 1

!      write(6,*) ' end of pw iteration'
!      write(6,265) jmaxpw, iterpw,         ipwmax,     &
!        nnTvsg,      imin,      imax, &
!        tem(1), tem(ipwmax), tem(nnTvsg), tem(imin), tem(imax),  &
!        pw(1),  pw(ipwmax),  pw(nnTvsg),  pw(imin),  pw(imax)
 265  format(i3, 5i10 / ' T  =', 0p5f10.1 / , ' pw =', 1p5e10.2)

      return
      end

!
! -----------------------------
!

subroutine transmat


use constants
use parameter

implicit none
integer  :: ji, jj
real*8   :: ephot, zphot, zphabs
real*8   :: at(nnTvsg,nnTvsg+1)



!   Calculates transition Matrix 'at':  A(f,i) = A(final,initial)
!   For heating  f > i, for cooling  i > f = i-1.
!   Set transition matrix to zero

      if(iav .eq. 1)   then                !at und bt werden zu Null gesetzt
        do  30  i = 1, nnTvsg
        do  30  j = 1, nnTvsg
        at(i,j) = 0.
        bt(i,j) = 0.
 30     continue

!  --------------------------------------------------------------------------
!   Cooling from f+1 -> f.  This is the diagonal line above the main diagonal
!  --------------------------------------------------------------------------

        do 10 jf = 1, nnTvsg-1
        at(jf,jf+1) = dtun(jf+1) / dun(jf+1)
        if(at(jf,jf+1) .lt. 0.) go to 999
  10    continue
      end if

!  --------------------------------------------------------------------------
!   Heizung  i -> f  Element unterhalb der Hauptdiagonalen
!  --------------------------------------------------------------------------

      ephot  = hwirk * fd(kTabs)        !Energie eines Photons
      zphot  = epak / ephot             !Zahl aller absorbierten Photonen
      zphabs = zphot / pahnum

if (pahnum.eq.0) then
    print*,'hmm gar keine pah da'
    print*, 'Energy [eV] =', ephot/eVolt, ' zphabs= ', zphabs, 'pahnum = ', pahnum 
endif




      do  20  ji = 1, nnTvsg - 1
      call locat(un, nnTvsg, un(ji)+ephot, jf)
        if(jf .gt. nnTvsg)    stop 'jf > nnTvsg'
        if(jf .lt. ji)    then
!        print 200, ji, jf, un(ji), un(jf), un(ji)+ephot
 200    format('ji, jf=', 2i4,' un(ji), un(jf), un(ji)+ephot=', 1p3e10.3)
        jf = ji + 1
!        stop 'transmat:  jf < ji or jf > ji'
        end if

      at(jf,ji) = at(jf,ji) + zphabs
 20   continue

      if(iav .lt. iabspah(lp))   return

      do  i = 1, nnTvsg
      do  j = 1, nnTvsg
      att(i,j) = at(i,j)
      end do
      end do

! ----------------------------------------------------------------------------
!   Main diagonal of matrix

      do  15  j = 1, nnTvsg
      do  16  k = j+1, nnTvsg
      if(j .eq. k)   go to 16
      att(j,j)  = att(j,j) - att(k,j)
 16   continue
 15   continue

! ----------------------------------------------------------------------------
!   Umschreiben der Matrix 'at' nach 'bt' (s. Gl.(2.17)).

      bt(nnTvsg,nnTvsg-1) = att(nnTvsg,nnTvsg-1)
      do  40  jj = 1, nnTvsg - 2 
      bt(nnTvsg,jj) = att(nnTvsg,jj)

      do  40  jf = nnTvsg-1, jj+1, -1 
      bt(jf,jj) = bt(jf+1,jj) + att(jf,jj)
  40  continue


       return
 999   write(6,*) ' ** Mist in transmat **'
       stop       
end subroutine transmat

!
! -----------------------------
!

subroutine enth

!   Berechnet Enthalpien un(i): Für Graphit (Gl.(3.3)) und für Si (Gl.(3.4)).
!   Enthalpie-Intervalle dun, Ableitung von un(i) nach der Zeit: dtun (Gl.(2.3))
!   igrid = 0: konstante T-Intervalle, igrid = 1: konstante U-Intervalle.


use constants
use parameter

implicit none
real*8	               :: zahler, denom, fak, ft, fts, dt, t
real*8, external       :: bpl
real*8	               :: tgitsi(4), ugitsi(4)
integer                :: igrid, iter


!
! ----------------------------------------------------------------------------
!

      data tgitsi / 0., 50., 150., 500. /
      data ugitsi / 0., 5.833d7, 9.486d8, 9.432d9 /

!
! ----------------------------------------------------------------------------
!   igrid = 1:  konstante U-Intervalle für Graphit (material = 0)
!
     igrid = 0
      if(igrid .eq. 1 .and. material .eq. 0)   then
      t          = tem(1)
      zahler     = xatom * (1d0 - 2d0/xatom) * 4.15d-22*t**3.3
      denom      = 1d0 + 6.51d-3*t + 1.5d-6*t**2 + 8.3d-7*t**2.3
      un(1)      = zahler / denom
      t          = tem(nnTvsg)
      zahler     = xatom * (1d0 - 2d0/xatom) * 4.15d-22*t**3.3
      denom      = 1d0 + 6.51d-3*t + 1.5d-6*t**2 + 8.3d-7*t**2.3
      un(nnTvsg) = zahler / denom

      do  11  i = 2, nnTvsg-1
      un(i) = un(1) + (i-1) * (un(nnTvsg)-un(1)) / float(nnTvsg-1)

      iter = 0
   3  continue
      iter = iter + 1
      zahler = xatom * (1d0 - 2d0/xatom) * 4.15d-22*t**3.3
      denom  = 1d0 + 6.51d-3*t + 1.5d-6*t**2 + 8.3d-7*t**2.3
      ft     = zahler / denom - un(i)
      fts    = denom * xatom * (1d0 - 2d0/xatom) * 3.3 * 4.15d-22*t**2.3 &
              -zahler * (6.51d-3 + 2d0*1.5d-6*t + 2.3 * 8.3d-7*t**1.3)
      fts    = fts / denom**2
      dt     = - ft / fts
      t      = t + dt
      if(abs(dt) .ge. 1d-4)   go to 3
      if(iter .eq. 25)   stop ' enth'
      tem(i) = t
 11   continue
      end if

! ----------------------------------------------------------------------------
!   igrid = 0:  konstante T-Intervalle für Graphit (material = 0)

      if(igrid .eq. 0 .and. material .eq. 0)   then
      do  12  i = 1, nnTvsg
      tem(i) = tem(1) + (i-1)*(tem(nnTvsg) - tem(1))/ float(nnTvsg-1)
      t      = tem(i)
      zahler = xatom * (1d0 - 2d0/xatom) * 4.15d-22*t**3.3
      denom  = 1d0 + 6.51d-3*t + 1.5d-6*t**2 + 8.3d-7*t**2.3
      un(i)  = zahler / denom
 12   continue
      end if

! ----------------------------------------------------------------------------
!   igrid = 1:  konstante U-Intervalle für Si (material = 1)

      if(igrid .eq. 1 .and. material .eq. 1)   then
      t          = tem(1)
      call locat (tgitsi, 4, t, j)
      if(j.eq.0)  stop 'sub enth'
      if(j.eq.1)  fak = 1.4d3/3.*t**3
      if(j.eq.2)  fak = ugitsi(j) + 2.2d4/2.3 * (t**2.3 - tgitsi(j)**2.3)
      if(j.eq.3)  fak = ugitsi(j) + 4.8d5/1.68* (t**1.68-tgitsi(j)**1.68)
      if(j.eq.4)  fak = ugitsi(j) + 3d7    * (t - tgitsi(j))
      un(1) = fak * pi4/3d0 * arad**3

      t          = tem(nnTvsg)
      call locat (tgitsi, 4, t, j)
      if(j.eq.0)  stop 'sub enth'
      if(j.eq.1)  fak = 1.4d3/3.*t**3
      if(j.eq.2)  fak = ugitsi(j) + 2.2d4/2.3 * (t**2.3 - tgitsi(j)**2.3)
      if(j.eq.3)  fak = ugitsi(j) + 4.8d5/1.68* (t**1.68-tgitsi(j)**1.68)
      if(j.eq.4)  fak = ugitsi(j) + 3d7    * (t - tgitsi(j))
      un(nnTvsg) = fak * pi4/3d0 * arad**3

      do  13  i = 2, nnTvsg-1
      un(i) = un(1) + (i-1) * (un(nnTvsg)-un(1)) / float(nnTvsg-1)
      stop 'Hier fehlt noch was'
 13   continue
      end if

! ----------------------------------------------------------------------------
!   igrid = 0:  konstante T-Intervalle für Si (material = 1)

      if(igrid .eq. 0 .and. material .eq. 1)   then
      do  14  i = 1, nnTvsg
      tem(i) = tem(1) + (i-1)*(tem(nnTvsg) - tem(1))/ float(nnTvsg-1)
      t      = tem(i)

      call locat (tgitsi, 4, t, j)
      if(j.eq.0)  stop 'sub enth'
      if(j.eq.1)  fak = 1.4d3/3.*t**3
      if(j.eq.2)  fak = ugitsi(j) + 2.2d4/2.3 * (t**2.3 - tgitsi(j)**2.3)
      if(j.eq.3)  fak = ugitsi(j) + 4.8d5/1.68* (t**1.68-tgitsi(j)**1.68)
      if(j.eq.4)  fak = ugitsi(j) + 3d7    * (t - tgitsi(j))
      un(i) = fak * pi4/3d0 * arad**3
 14   continue
      end if

! ----------------------------------------------------------------------------
!   Bestimme dun(i) und dtun(i)

      do   i = 2, nnTvsg-1
      dun(i) = 5d-1 * (un(i+1) - un(i-1))
      end do
      dun(1)      = 5d-1 * un(2)
      dun(nnTvsg) = dun(nnTvsg-1)

      do  15  i = 2, nnTvsg
      dtun(i)   = 0.
        do   k  = 1, mm
        dtun(i) = dtun(i) + dfrmrn(k)  * qpah(k) * & 
                            bpl(frmrn(k),fr3mrn(k),tem(i))
        end do
      dtun(i) = dtun(i) * pi4 * pi*arad**2
 15   continue

      return
end subroutine enth
!!!!!!!!!!!! 
       !******************************************************
       !*  Sorts two arrays in order of the first array both *
       !*  of length N in ascending order by Heapsort method *
       !* -------------------------------------------------  *
       !* INPUTS:                                            *
       !*	    N	  size of table RA, RA2              *
       !*          RA 	  integer*2 table to be sorted       *
       !*          RA2	  integer*2 table sorted as RA1      *
       !* OUTPUT:                                            *
       !*	    RA ,RA2  sorted tables                   *
       !*           RA  is now in ascending order            *
       !*                                                    *
       !* NOTE: The Heapsort method is a N Log2 N routine,   *
       !*       and can be used for very large arrays.       *
       !******************************************************        
       SUBROUTINE ASORT_i(N,RA,RA2)

       implicit none
!         real*8  RA(N), 
         integer   :: L,N,IR,I,J
         integer   :: RRA,RRA2
         integer   :: RA(N),RA2(n)
         L=N/2+1
         IR=N
         !The index L will be decremented from its initial value during the
         !"hiring" (heap creation) phase. Once it reaches 1, the index IR 
         !will be decremented from its initial value down to 1 during the
         !"retirement-and-promotion" (heap selection) phase.
 10      continue
         if(L > 1)then
           L=L-1
           RRA =RA(L)
           RRA2=RA2(L)
         else
           RRA =RA(IR)
           RRA2=RA2(IR)
           RA(IR) =RA(1)
           RA2(IR)=RA2(1)
           IR=IR-1
           if(IR.eq.1)then
             RA(1) =RRA
             RA2(1)=RRA2
             return
           end if
         end if
         I=L
         J=L+L
 20      if(J.le.IR)then
         if(J < IR)then
           if(RA(J) < RA(J+1))  J=J+1
         end if
         if(RRA   < RA(J))then
           RA(I)  = RA(J)
           RA2(I) = RA2(J)
           I=J; J = J+J
         else
           J=IR+1
         end if
         goto 20
         end if
         RA(I) = RRA
         RA2(I)= RRA2
         goto 10
end subroutine asort_i
!
!----------------------------------------------
!
subroutine locat_i(v, n, x, j)
!   Sei v ein geordneter Vektor der Lange n und x eine beliebige Zahl.
!   Wenn  v(1) < v(2) < ... < v(n),  so liegt x  im halboffenen 
!   Intervall  (v(j), v(j+1)].
!   Falls   x <= v(1):   j = 0.   Falls   v(n) < x:   j = n
!   Wenn  v(1) > v(2) > ... > v(n),  so liegt x  im halboffenen 
!   Intervall  (v(j+1), v(j)].
!   Falls   x > v(1):   j = 0.    Falls   v(n) >= x:  j = n
! Sicher gestellt dass 1 <= j <= n gilt
        implicit none
!        real*8,intent(in)	:: v(n)
        integer,intent(in)	:: v(n)
      	integer,intent(in) 	:: n
	integer,intent(in) 	:: x
	integer,intent(out) 	:: j
	integer			:: jlow,jup,jm
        jlow = 0
        jup  = n + 1

 10     continue
        if(jup-jlow .gt. 1) then
                jm = (jup + jlow) / 2
                if( (v(n).gt.v(1) ) .eqv. ( x.gt.v(jm)) ) then
                        jlow = jm
                else
                        jup  = jm
                end if
        go to 10
        end if
        if(jlow .le. 1)  jlow = 1
        if(jlow .ge. n)  jlow = n
        j = jlow

end subroutine locat_i

!
! --------------------------------------------------------------------------------------------------------
!
subroutine pahabs (a,e,jf_local,UWmass,lp_local,ran1,iiabspah)
! 
! -----------------------------------------------------------------------
! ispah zaehlt absorbtionen durch  PAHs. 
! iwp zaehlt die in einem UW absorbtionen durch  PAHs. 
! Packet wrid von PAH absorbiert im 
! UW(lp_local) mit  Frequenz(jf_local): Dann ist iiabspah=1 und wird in 
! Variablen:  ipahlp()=lp und ipahfr()=jf_local, gespeichert.
! Input: a = anfangs koordinaten, e = end koordinaten, jf_local, UWmass, 
!            jf_local = frequenz, ran1 = zufall bezgl. absorbtion 
! Output:  iiabspah =0:  keine, =1: mindestens ein Photon wird vom PAH absorbiert
!          iabspah = alle PAH absorbtionen im UW (globale variable),
! Method: *_local f. lokale variablen zur Parallelisierung.
! -----------------------------------------------------------------------
!
use type_module
use constants
use parameter
implicit none
        real*8                             :: ran1
        real*8                             :: fak
!        real*8                             :: UWmass, ephot
        real*8                             :: UWmass
        integer                            :: lp_local
        integer                            :: jf_local
        type(float_vector)                 :: a
        type(float_vector)                 :: e
        type(float_vector)                 :: m
        integer                            :: iiabspah

         if(inopah(lp_local).ne.0) stop ' kann nicht sein! '
!  ----------------------------------------------------------------------------
!  6.2  Absorption des Pakets im UW lp durch PAHs.  Paket muß vom Stern kommen.
!

        fak    = C_abs_pah(jf_local)  / (C_abs_ac(jf_local) + C_abs_si(jf_local) + C_abs_pah(jf_local))

        m%x = (a%x + e%x) / 2d0
        m%y = (a%y + e%y) / 2d0
        m%z = (a%z + e%z) / 2d0

! PAH verdampfung 
!  1x: falls PAH im UW X-ray absorbiert
          if(fak .ge. ran1)   then
            ispah             = ispah + 1              !Durchnumerierung aller PAH Absorptionen
            iabspah(lp_local) = iabspah(lp_local) + 1  !Zahl der Abs durch PAHs im UW(lp)
            if(iabspah(lp_local) .eq. 1)   then
             iwp                    = iwp + 1          ! Durchnumerierung der Zellen mit Abs durch PAHs
             lp_zu_iwp(iwp)         = lp_local         ! lp zu fortlaufender Numerierung iwp
            end if
              ipahlp(ispah) = lp_local
              ipahfr(ispah) = jf_local
              iiabspah = 1
              if(ispah .ge. mpabs) then
                print*, ispah, mpabs, ' = ispah,mpabs'
                stop ' ispah= mpabs'
              end if
           end if
end subroutine pahabs
