#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "dc.h"
#include "random_cpu.h"

rng_struct *rng_h;
extern int initialize_(int *n_ran_fortran)
{
	int id_MT;
	int n_ran;
	uint32_t seed_RN=1234;
	unsigned int ixyz;
	int izyk;
	int jf;
	int jjf;
	int i;
	int nUW;
	int hit_ac;
        int hit_si;
	int n_zero_cells_ac;
	int n_zero_cells_si;

       	rng_h = (rng_struct*) malloc(sizeof(rng_struct));
	n_ran = *n_ran_fortran;
/* initialize RNG (Mersenne Twister) more details in /lib/dcmt0.5 */
	printf("initialize %i Random Number Generators\n",n_ran);
	rng_h->n_MT = n_ran;
	rng_h->mt_vec = (mt_struct*) malloc(rng_h->n_MT*sizeof(mt_struct));
	rng_h->mem_state=(uint32_t*) malloc((rng_h->n_MT+1)*sizeof(uint32_t));
	load_MT(*rng_h);
	rng_h->state = (uint32_t*) malloc(rng_h->mem_state[rng_h->n_MT]*sizeof(uint32_t*));
	for (id_MT=0;id_MT<rng_h->n_MT;id_MT++)
	{
		init_state(seed_RN,id_MT,*rng_h);
	}
	return;
}

extern float get_random_(int *id_fortran)
{
	uint32_t id_MT;
	
	id_MT = *id_fortran;
       	return random_cpu(id_MT,*rng_h);
}

