typedef struct Rng_struct
{
	int n_MT;
	mt_struct *mt_vec;
	uint32_t *state;
	uint32_t *mem_state;
}rng_struct;

void init_state(uint32_t seed,uint32_t id_MT,rng_struct rng)
{
	int i;
	mt_struct *mt_ini;
	uint32_t *state;

	mt_ini = &rng.mt_vec[id_MT];
	state = &rng.state[rng.mem_state[id_MT]];
	for (i=0;i<mt_ini->nn;i++)
	{
		state[i] = seed;
		seed = (1812433253U * (seed ^ (seed >> 30 ))) + i + 1;
	}
	mt_ini->i = mt_ini->nn;
	for (i=0;i<mt_ini->nn;i++)
	{
		state[i] &= mt_ini->wmask;
	}
}

float random_cpu(uint32_t id_MT,rng_struct rng)
{
	mt_struct *mt_ini = (rng.mt_vec+id_MT);
	uint32_t *state = &rng.state[rng.mem_state[id_MT]];
	uint32_t uuu,lll,aa,x;
	int k,n,m,lim;

	if (mt_ini->i >=mt_ini->nn)
	{
		n = mt_ini->nn;
		m = mt_ini->mm;
		aa = mt_ini->aaa;
		uuu = mt_ini->umask;
		lll = mt_ini->lmask;
		lim = n-m;	
		for (k=0;k<lim;k++)
		{
			x=(state[k]&uuu)|(state[k+1]&lll);
			state[k] = state[k+m]^(x>>1)^(x&1U?aa:0U);
		}
		lim = n -1;
		for (;k<lim;k++)
		{
			x=(state[k]&uuu)|(state[k+1]&lll);
			state[k] = state[k+m-n]^(x>>1)^(x&1U?aa:0U);
		}
		x = (state[n-1]&uuu)|(state[0]&lll);
		state[n-1] = state[m-1]^(x>>1)^(x&1U?aa:0U);
		mt_ini->i=0;
	}
	x = state[mt_ini->i];
	mt_ini->i += 1;
	x ^= x>>mt_ini->shift0;
	x ^=(x<<mt_ini->shiftB)&mt_ini->maskB;
	x ^=(x<<mt_ini->shiftC)&mt_ini->maskC;
	x ^= x>>mt_ini->shift1;
	return ((float)x + 1.0f) / 4294967296.0f;;
}



void load_MT(rng_struct rng)
{
	int n_MT=rng.n_MT;
	mt_struct *mt_vec = rng.mt_vec;
	uint32_t *mem_state = rng.mem_state;
	uint32_t id_MT;
	FILE *fp;
	uint32_t mem_sum;
	
	mem_sum=0;
	fp=fopen("input/mt.ini","r");
	for (id_MT=0;id_MT<n_MT;id_MT++)
	{
		if (!fread(&mt_vec[id_MT],sizeof(mt_struct),1,fp))
		{
			printf("ERROR while reading MT init file\n");
			printf("(most common not enough MT generated)\n");
			exit(1);
		}
		mem_state[id_MT] = mem_sum;
		mem_sum += (mt_vec+id_MT)->nn;
	}
	mem_state[n_MT]=mem_sum;
	fclose(fp);
	return;
}
