!-------------------------------------------------------------------------------
! source.f90
!-------------------------------------------------------------------------------
! history
! originally by Ralf & Peter
! 2014 02 25 Roxana
!	removed epak = epak*0.5 for structure=2/4
!-------------------------------------------------------------------------------

subroutine source
!
! 0. BB spectrum:
! 1. power-law (AGN) spectrum
! 2. beliebiges spectrum mit frequenzgitter eingelesen von file
! 3. Beliebiges Quellspektrum zu festen Frequenz-Gitter von BB(8000K) 
! 4. comput SN1a Template Spectra from Nugent smoothed to nf=243freq.  
! 5. as 4 but reading from file: ./input/SN1aNzyk.grid
!
use constants
use parameter
use type_module
use source_parameter
	implicit none
	real*8,external	:: bpl, f1_ext, rtbis
	real*8	        :: freq(0:nf)
        integer, parameter :: itSNmax=18  !max lum Nugent light curve
        integer, parameter :: itSN=10
        integer         :: mmgrid, it
	real*8		:: sbbdfr(nf), sbb8kdfr(nf), sSNmaxdfr(nf)
	real*8		:: Tstar1, fak, sSNmax,sumbb, sumbb8k
	real*8		:: Tstar8k=8.d3
	real*8		:: fak1
	real*8 		:: guess1
	real*8 		:: guess2
	real*8		:: dum
	real*8		:: fSN1a(ntSN1a,nf), vSNzyk(ntSN1a,nf)

        character       :: dummy
        type(init_type) :: init


! ------------------------------------------------------
! 1.    Stern :nf+1 Frequenzen freq(k) bez. Stern mit nf Intervallen
!     gleicher Energie.  quant = sigma*T**4/pi/nf.  freq(0) = 0 ,
!     freq(1) aus RJ NÃ¤herung.
! 2 . Beliebiges Spektrum der Quelle falls Tstar < 0 read fr(k) von file 
! 3.  Bei AGN: frequenzen mit intervalle gleicher Enegie f. powerl law.


        freq(0)   = 0.
        ivnzyk     =  nzyk



! 0. BB spectrum:
      if (iQuelle .eq. 0) then
        freq(1)  = (1.5d0*sigma*clicht**2*Tstar**3/pi/nf/boltz)**(1./3.)/2.
        fr(1)    = 0.58d0 * freq(1)
        quant    = sigma * Tstar**4 / nf / pi
        do  k = 2, nf
         xalt    = freq(k-1)
         guess1  = freq(k-1)
         guess2  = 5d0 * freq(k-1)
         freq(k) = rtbis(f1_ext, guess1, guess2, 1d6)
         fr(k)   = (freq(k) + freq(k-1)) / 2d0 
         dfr(k)   = (freq(k) - freq(k-1)) ! using fr goes wrong 
       end do
         dfr(1)   = (freq(1) - freq(0)) 
       end if


! 1. power-law (AGN) spectrum
      if(iQuelle .eq. 1)   then
        Tstar    = 35000.
        freq(0)  = frmin
        fak      = 1d0 + specind
        fak1     = (frmax**fak - frmin**fak)/nf
        do  k    = 1, nf
         freq(k) = (k* fak1 + frmin**fak)**(1d0/fak)
         fr(k)   = (freq(k) + freq(k-1)) / 2d0 
         dfr(k)  = (freq(k) - freq(k-1)) ! using fr goes wrong 
       end do
       end if

!  2. beliebiges spectrum mit frequenzgitter eingelesen von file
      if(iQuelle .eq. 2) then 
        print*, ' ' 
        print*,' *** Read freq. grid from input file: frgrid.tab'
        open(unit=3, file='input/frgrid.tab', form='formatted')
        rewind 3
        read(3,*)  dummy, mmgrid, dum
        write(6,'(a1,i6,1p1e8.2)')   dummy, mmgrid, dum
        print*, ' ' 
        if(mmgrid.ne.nf ) stop ' *** nf is not correct!'
       do k= 1,nf
           read(3,*)  freq(k), dum
           fr(k)   = (freq(k) + freq(k-1)) / 2d0
          dfr(k)   = (freq(k) - freq(k-1)) ! using fr goes wrong 
        end do
        close (unit=3)

       end if

! ------------------
!  3. Beliebiges Quellspektrum zu festen Frequenz-Gitter von BB(8000K) 
      if (iQuelle .eq. 3) then
        print*,  ! iQuelle=3:  Festlegung Fr-Gitter zu BB(8000K) '
        Tstar1   = Tstar
        Tstar    = Tstar8k
        freq(0)  = 0.
        freq(1)  = (1.5d0*sigma*clicht**2*Tstar8k**3/pi/nf/boltz)**(1./3.)
        fr(1)    = 0.5d0 * freq(1)
        quant    = sigma * Tstar8k**4 / nf / pi
        do  k = 2, nf
         xalt    = freq(k-1)
         guess1  = freq(k-1)
         guess2  = 5d0 * freq(k-1)
         freq(k) = rtbis(f1_ext, guess1, guess2, 1d6)
         fr(k)   = (freq(k) + freq(k-1)) / 2d0
          dfr(k) = (freq(k) - freq(k-1)) ! using fr goes wrong 
        end do
         dfr(1)  = (freq(1) - freq(0)) 
        Tstar    = Tstar1

   print*, ' Tstar, Tstar1, Tstar8k  ', Tstar, Tstar1, Tstar8k
      endif


! ------------------------------------ 

! 4. SN1a Template Spectra from Nugent smoothed to nf=243 frequencies
!  using routine ./SN1aNugent/SN1a_temlpate.pro that computes
!                             frSN1a.grid and set nf=252.  
!  For testing use BPL_temlpate.pro: testfrSN1a.grid and set nf=248)
!  Input: frequency grid, fr(nf) fSN1a =flux(ntSN1a,nf) [Jy arbitrary]
!  and ntSN1a=90 time steps (days), maximum light is at day 19.
!
      if (iQuelle .eq. 4 .or. iQuelle .eq.5) then
        print*, '  *** iQuelle=4,5: SN1a templates: frSN1a.grid'
        print*, '                   time step [day] itSN = ',itSN

        if(nf .ne. 248) then
         print*, ' *** set nf=248 in modules.f90'
         stop ' source.f90 for iQuelle=4 or 5'
        end if

        open(unit=3, file='input/frSN1a.grid', form='unformatted')
        rewind 3
        read(3)  fr, dfr
        read(3)  fsn1a
        close(3)
       write(66,'(1p4e12.3)') (clicht/fr(k)*1e4,fr(k), dfr(k), &
&                             fSN1a(itSN,k), k=1,nf)


      end if
!
! -------------------------------
!

      do  k = 1, nf
       wel(k)   = clicht / fr(k)
       welmu(k) = 1d4 * wel(k)
!testing:    
!        fSN1a(itSN,k)=  bpl(fr(k), fr(k)**3, Tstar) 
      end do

! -----------
!  Get the nzyk for each frequency bin set up:
!  for iQuelle 3, 4 ok for BPL testing otherwise 
!  re-compute sbbdfr): 

      if (iQuelle .eq. 3 .or. iQuelle.eq.4) then
      if (iQuelle .eq. 3) stop ' iQuelle=3 still ok? -- check!'

        open(unit=3, file='output/Ltime.nzyk', form='formatted')
        rewind(3)
        write(3,*) '# For time interval the mean number of packets/fr  are:'
        write(3,*) '#   it     Nzyk(it)'
       sumbb8k       = 0.
       sbb8kdfr      = 0.
       sSNmax        = 0.
       sSNmaxdfr     = 0.
       do  k         = 1, nf
        sbb8kdfr(k)  =  bpl(fr(k), fr(k)**3, Tstar8k) * dfr(k)
        sumbb8k      =  sumbb8k + sbb8kdfr(k)
        sSNmaxdfr(k) =  fSN1a(itSNmax,k) * dfr(k)
        sSNmax       =  sSNmax + sSNmaxdfr(k)
       end do

       sbb8kdfr      = sbb8kdfr / sumbb8k
       sSNmaxdfr     = sSNmaxdfr/ sSNmax


      do it         = 1, ntSN1a
       sumbb         = 0. 
       sbbdfr        = 0. 
       do  k         = 1, nf
        sbbdfr(k)    =  fSN1a(it,k) * dfr(k)
!        sumbb        =  sumbb  + sbbdfr(k)
       end do
       sbbdfr        =  sbbdfr/sSNmax
       fak = 0d0
       do  k         = 1, nf
         vSNzyk(it,k)   =  sbbdfr(k)/sbb8kdfr(k)
         fak            = fak +   vSNzyk(it,k) 
        enddo
       fak              = fak/dble(nf)*dble(nzyk)
       write(3,'(i5,2x,i10)') it, idnint(fak) 
      enddo
      vSNzyk            = vSNzyk*dble(nzyk)
      close(3)
        
! Normalise to itSNmax:
! at itSNmax there are on average nzyk packets emitted for each fr


       fak                = 0d0 
        do  k             = 1, nf
        ivnzyk(k)         = idnint(vSNzyk(itSN,k))
        fak               = fak     + ivnzyk(k)
       end do
        fak               = fak/nf 
        write(6,'(a30,2i6)') '  *** Packets emitted at time step itSN =  ', itSN, nint(fak)
 
       if(ibug.ge.2)  write(6,'(i4,1f9.3, 1p2e10.2)') & 
&        (k, welmu(k), fSN1a(itsn,k), vSNzyk(itsn,k), k=1,nf)

      end if    


      if(ibug.ge. 2) then
       print 237, (k, welmu(k), fr(k), dfr(k), k=1, 2)
       print 238, (k, welmu(k), fr(k), dfr(k), k=nf-2, nf)
      end if
237  format(' Die 3 groesseten wellenl. [mu] bez. der Quelle:' / &
	&16x, 'welmu      fr(k)       dfr(k)' / (5x, i8, 1p3e11.3))
238  format(' Die 3 kleinsten wellenl. [mu] bez. der Quelle:' / &
	&16x, 'welmu      fr(k)       dfr(k)' / (5x, i8, 1p3e11.3))

!
! Energy of one packet
!

      epak = LQuelle / nf / nzyk / cc3 !/2.0
      write(6,'(a,1p1e10.2)') '  ***    epak          = ',  epak

end subroutine source
