! space.f90
! defines grid and density distribution
! some subroutines to be found in morespace.f90
! ------------------------------------------------------------------------------
! history
! originally by Ralf & Peter
! modified
! 2014 02 25 Roxana
!     adding structure=-1
!     moving definition of cc4 to the end of strcuture definition

subroutine space(init,iter)


!  Die Anzahl der UW netz(i,j,k)**3 in einem GW sollte bestimmt werden durch:
!  1. seine Dichte und und damit die  optische Tiefe dtauV in ihm,
!  2. die oT tauV vom MP des GW zum Stern auf kürzestem Weg und
!  3. die minimale oT tauVmin vom MP des GW zum Stern aller möglichen Wege

use type_module
use parameter
use constants
implicit none

type(init_type)         :: init

        real*8  :: rand, ran
	real*8	:: nws(6), lws(6)
	real*8	:: xx2,xx
	real*8	:: yy2,yy
	real*8	:: zz2,zz		
	real*8	:: cl_mref
	real*8	:: costhet
	real*8	:: dl
	real*8	:: rr,rr2
	real*8	:: dicht0
	real*8	:: dTauV
	real*8 	:: fak
	real*8	:: tauV, tau
	real*8	:: r,theta,phi, rtest
	real*8	:: theta0
	real*8	:: volfrac	
        real*8  :: x_spiral,y_spiral,a_spiral,n_spiral,dist_spiral,phi_spiral,rr_disk
        real*8  :: rd,zd,f1,hr,f2
	integer	:: lpp
	integer	:: ii, jj, kk, ii1, jj1, kk1
	integer	:: i1, is, ia, ie, j1, js, ja, je, k1, ks, ka, ke
	integer	:: iii
	integer	:: mi, mj, mk
	integer	:: lw
	integer	:: ntz
        integer :: idim
        integer :: iklump
        integer :: iter, l        
	real*8  :: Eabssiz, Eabscz, UWmass
        real*8  :: thexx, height, factor, apos, xypos
        integer :: ninteg,integ
        real*8  :: clump_profile,density_2phase,density_clump
! -------------------------------------------------------
	lws =[ 1, 3, 5, 7, 9, 11 ]
!   Eckkoordinaten der GW, gegeben durch nx,ny,nz und Seitenlänge dGW des GW.
        IF (old_random .eq. 1) THEN
           PRINT*,'using old random numbers from file input/random.old'
           open(unit=117,file='input/random.old',form='formatted')	
           rewind 117
	ELSE 
           zufall  = rand(1)
	END IF
        x(1)=0d0
        y(1)=0d0
        z(1)=0d0
        do i = 2, nx+1
           x(i) = x(i-1) + dGW 
        end do
        do i = 2, ny+1
           y(i) = y(i-1) + dGW 
        end do
        do i = 2, nz+1
           z(i) = z(i-1) + dGW 
        end do
        if (kugelsym .eq. 1)   then
           print *, ' *** Kugelsymmetrie ***'
        else
           print *, ' *** keine Kugelsymmetrie ***'
           theta0 = 5d-1 
        end if

! -----------------------------------------------------
! 1. Sphere
!
        if (input%structure.eq.1) then
         print*,' *** spherical density distribution'
         print*,' 3 parameter '
         print*,' p(1) density rho_0   [1d20]',input%p(1)
         print*,' p(2) potenz 1/r^p(2) [1]   ',input%p(2)
         print*,' p(3) iexpgw1         [3]   ',input%p(3)
         if (input%parameter.ne.3) then
           print*,'wrong number of parameter'
           stop
         endif

        a1r     = input%p(1)
        x1r     = input%p(2)
        iexpgw1 = input%p(3)

        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           netz(i,j,k) = 1
           if(idim3 .ne. 1)   then
              if (SQRT(i**2.+j**2.+k**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6)
              if (SQRT(i**2.+j**2.+k**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5)
              if (SQRT(i**2.+j**2.+k**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4)
              if (SQRT(i**2.+j**2.+k**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3)
              if (SQRT(i**2.+j**2.+k**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2)
              if (SQRT(i**2.+j**2.+k**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1)
              if (SQRT(i**2.+j**2.+k**2.).le.1) netz(i,j,k) = 2**(iexpgw1)
           else
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.1) netz(i,j,k) = 2**(iexpgw1)
           end if
        end do
        end do
        end do
!   Gesamtzahl isumuw aller UW
        isumuw = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           isumuw        = isumuw + netz(i,j,k)**3
           netsum(i,j,k) = isumuw
        end do
        end do
        end do
        write(6,*) ' ' 
        write(6,'(a33,1p1e10.2)') '7. Summe aller Unterwuerfel =  ', dfloat(isumuw)
        write(6,*) ' ' 

        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

       call allocspace(isumuw)!allocate important values.

        do i = 1, isumuw
           iabs(i)    = 0
           isca(i)    = 0
        end do

!   ---------------------------------------------------------------------------
!  Zunächst wird die Dichte überall zu Null gesetzt
        do i = 1, isumuw
           dicht(i)    = 0.
        end do
        cl_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
              rr     = sqrt(xx2 + yy2 + zz2)
              if (rr .ge. rinner .and. rr .le. router) then 
                 dicht(lp) = a1r / rr**x1r
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
              endif
           end do
           end do
           end do
        end do
        end do
        end do
        end if
!   ---------------------------------------------------------------------------
!2.   Dichteverteilung nach Pascucci et al 2004:

        if (input%structure.eq.2) then
         print*,' **disc like density distribution (Pascucci et al 2004)'
         print*,' 6 parameter:'
         print*,'   p(1) -- rho_0',input%p(1)
         print*,'   p(2) -- opening of spiral @ r_out [au]',input%p(2)
         print*,'   p(3) -- number of rotations',input%p(3)
         print*,'   p(4) -- gap start',input%p(4)
         print*,'   p(5) -- gap end',input%p(5)
         print*,'   p(6) iexpgw1         [3]   ',input%p(6)
         iexpgw1 = input%p(6)
         if (input%parameter.ne.6) then
            print*,'wrong number of parameter'
            stop
        endif
        
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           netz(i,j,k) = 1
           if(idim3 .ne. 1)   then
              if (SQRT(i**2.+j**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6-k)
              if (SQRT(i**2.+j**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5-k)
              if (SQRT(i**2.+j**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4-k)
              if (SQRT(i**2.+j**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3-k)
              if (SQRT(i**2.+j**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2-k)
              if (SQRT(i**2.+j**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1-k)
              if (SQRT(i**2.+j**2.).le.1) netz(i,j,k) = 2**(iexpgw1-k)
              if (k.eq.1) netz(i,j,k) = netz(i,j,k)*2
           else
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.1) netz(i,j,k) = 2**(iexpgw1-abs(k-nz/2))
              if (k.eq.int(nz/2.-0.45)+1) netz(i,j,k) = netz(i,j,k)*2
              if (k.eq.int(nz/2.)+1) netz(i,j,k) = netz(i,j,k)*2
              if (netz(i,j,k).ne.1) netz(i,j,k) = netz(i,j,k) + 1
           end if
           if (netz(i,j,k).lt.1) netz(i,j,k) = 1
        end do
        end do
        end do
!   Gesamtzahl isumuw aller UW
        isumuw = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           isumuw        = isumuw + netz(i,j,k)**3
           netsum(i,j,k) = isumuw
        end do
        end do
        end do
        print *, ' 6. Summe aller Unterwuerfel =', isumuw
        if (isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

       call allocspace(isumuw)!allocate important values.

        do i = 1, isumuw
           iabs(i)    = 0
           isca(i)    = 0
        end do
!
        do i = 1, isumuw
           dicht(i)    = 0.
!           dicht(i)    = 3.5d-20
        end do
        if(dicht(1) .ne. 0) print*, ' WARNING !  Zunächst wird die Dichte überall UNGLEICH Null gesetzt'
        print*, '  ' 
        cl_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx  = (x(i) + (ii - 5d-1) * dl-xorg)
              yy  = (y(j) + (jj - 5d-1) * dl-yorg)
              zz  = (z(k) + (kk - 5d-1) * dl-zorg)
              xx2 = xx**2
              yy2 = yy**2
              zz2 = zz**2
              rr  = sqrt(xx2 + yy2)
              if (rr .ge. rinner .and. rr .le. router) then
                 rd = router/2.
                 zd = router/8.
                 f1 = 1. / (rr/rd)
                 hr = zd * (rr/rd)**1.125
                 f2 = exp(-pi/4*(zz/hr)**2.)
                 dicht(lp) =  input%p(1)  * f1 * f2
                 rr_disk = sqrt(xx2+yy2)
                 n_spiral = input%p(3)
                 phi_spiral = sign(1d0,yy)*acos(xx/rr_disk)
                 if (phi_spiral.lt.0) phi_spiral = phi_spiral+2.*pi
                 phi_spiral = phi_spiral+int(rr_disk/router*n_spiral)*2.*pi
                 a_spiral = router / 2. /pi / n_spiral
                 x_spiral = a_spiral * phi_spiral * cos(phi_spiral)
                 y_spiral = a_spiral * phi_spiral * sin(phi_spiral)
                 dist_spiral = sqrt((x_spiral-xx)**2+(y_spiral-yy)**2)
                 if (rr_disk.gt.input%p(4)*au.and.rr_disk.lt.input%p(5)*au) dicht(lp) = dicht(lp)*1e-5
                 if (rr_disk.gt.input%p(5)*au.and.dist_spiral.le.input%p(2)*au*(rr_disk/router).and.phi_spiral.lt.n_spiral*2.*pi) &
& then 
                    dicht(lp) = dicht(lp)*1e-5
                 endif
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
              endif
           end do
           end do
           end do
        end do
        end do 
        end do
        endif 
!   ---------------------------------------------------------------------------
! 4.  Dichteverteilung mit Klumpung. 

        if (input%structure.eq.3.and.nklump.eq.0) then 
           print*,'nklump = 0'
           stop
        end if
        if (input%structure.eq.3.and.nklump.gt.0) then
        print*,' **clumpy torus density distribution'
        print*,' 5 parameter:'
        print*,' p(1) rho_0 background density   [5.4d-21]',input%p(1)
        print*,' p(2) potenz 1/r^p(2)              [1]    ',input%p(2)
        print*,' p(3) Opening angle (*pi radians)  [0.125]',input%p(3)
        print*,' p(4) Clump density                       ',input%p(4)
        print*,' p(5) iexpgw1 - clump cell subdivision [3]',input%p(5)

        if (input%parameter.ne.5) then
           print*,'wrong number of parameter'
           stop
        endif

        a1r     = input%p(1)
        x1r     = input%p(2)
        thexx   = input%p(3) * (4 * atan(1.))
        rho_clump = input%p(4)
        iexpgw1 = input%p(5)

        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           netz(i,j,k) = 1
        end do
        end do
        end do
!   Gesamtzahl isumuw aller UW
        print*, ' *** re-set idim =0'
        idim = 0
        do iklump=1,nklump !needs revising - r,theta,phi will do?
           call random_num(ran,idim)
           r = ran*(router - rinner) + rinner
!           xx   = ran*dgw*nx
           call random_num(ran,idim)
           phi = 2 * pi * ran
!           yy   = ran*dgw*ny
           call random_num(ran,idim)
           theta = thexx*(2*ran-1)
!           theta = pi/2.+x1r/180.*pi*(-1.+2.*ran)
!           zz   = ran*dgw*nz
           xx = xorg+r*sin(theta) * cos(phi) 
           yy = yorg+r*sin(theta) * sin(phi)
           zz = zorg+r*cos(theta)
           if (idim3.ne.1) then
              xx = abs(xx)
              yy = abs(yy)
              zz = abs(zz)
           endif
           i = int(xx/dgw)+1
           j = int(yy/dgw)+1
           k = int(zz/dgw)+1
           rr = sqrt((xx-xorg)**2 + (yy-yorg)**2 + (zz-zorg)**2)
           if (i.ge.1.and.j.ge.1.and.k.ge.1) then 
              if (rr .gt. rinner .and. (rr .lt. router .or. kugelsym .ne. 1)) then
!                 if (abs(zz-zorg).lt.sqrt((xx-xorg)**2+(yy-yorg)**2)/2.) then 
                    netz(i,j,k) = iexpGW1
!                end if
              endif
           end if
        end do
        isumuw = 0.
        do i = 1, nx
           do  j = 1, ny
              do  k = 1, nz
                 isumuw        = isumuw + netz(i,j,k)**3
                 netsum(i,j,k) = isumuw
              end do
           end do
        end do
        print *, ' 6. Summe aller Unterwuerfel =', isumuw
        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

       call allocspace(isumuw)!allocate important values.

        do i = 1, isumuw
           iabs(i)    = 0
           isca(i)    = 0
        end do
        do i = 1, isumuw
           dicht(i)    = 0.
        end do
        cl_mass = 0.
        do i=1,nx
        do j=1,ny
        do k=1,nz
           do ii=1,netz(i,j,k)
           do jj=1,netz(i,j,k)
           do kk=1,netz(i,j,k)
              ntz = netz(i,j,k)
              dl = dgw / ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx    = (x(i) + (ii - 5d-1) * dl-xorg)
              yy    = (y(j) + (jj - 5d-1) * dl-yorg)
              zz    = (z(k) + (kk - 5d-1) * dl-zorg)
              xx = (i-0.5)*dgw-xorg
              yy = (j-0.5)*dgw-yorg
              zz = (k-0.5)*dgw-zorg
              xx2  = xx**2
              yy2  = yy**2
              zz2  = zz**2
              rr   = sqrt(xx2 + yy2 + zz2)
              if (netz(i,j,k).gt.1) then    !clump   
                 rr2 = sqrt(((0.5-1.*(ii-0.5)/ntz))**2+((0.5-1.*(jj-0.5)/ntz))**2+((0.5-1.*(kk-0.5)/ntz))**2)
!                 if (rr2.ne.0.and.lp.gt.0.and.rr2.lt.0.5) then 
                    dicht(lp) = rho_clump/rr2/(rr**x1r) !a1r/rr*1./rr2 - later addclumps with density gradient
!                 endif
              else !background
                 if (rr .ge. rinner .and. rr .le. router) then 
                    dicht(lp) = a1r / rr**x1r
                 else
                    dicht(lp) = 0.
                 endif
              endif
              cl_mass = cl_mass + dicht(lp)*dl**3
           enddo
           enddo
           enddo 
        enddo
        enddo
        enddo 
        endif
! ---------------------------------------
! 5. Dichte wie in scheibe.f
        if (input%structure.eq.4) then 
         if(iter.eq.1) then
          print*, ' *** Dichte Profil wie in scheibe.f:'
          print*,' 6 parameter:'
 write(6,'(a33,1p1e9.2)') '   p(1) -- tauVmid @ 1AU    = ', input%p(1)
 write(6,'(a33,1p1e9.2)') '   p(2) -- aheight  [4.]    = ', input%p(2)
 write(6,'(a33,1p1e9.2)') '   p(3) -- Mstar    [4.d33] = ', input%p(3)
 write(6,'(a33,1p1e9.2)') '   p(4) -- Lx/Lquelle   [0] = ', input%p(4)
 write(6,'(a33,1p1e9.2)') '   p(5)  = nUWzmax     [32] = ', input%p(5) 
 write(6,'(a33,1p1e9.2)') '   p(5)  = rhomin  [1.d-20] = ', input%p(6) 
          rhomin = input%p(6) 

!       call allocspace(naw)!allocate important values.

          call dicke_scheibeTmid(init)

print*, ' no call to pahXdestruct bei mc_weiter'
!          if(jpah.eq.1.and.input%p(4).gt.0) call pahXdestruct(init)

         end if



        endif

! ---------------------------------------
! 6. Tapered disc.

       if (input%structure .eq. 5) then
         print*,' **Tapered disc density distribution'
         print*,' 4 parameter '
         print*,' p(1) density rho_0                [1d20] ',input%p(1)
         print*,' p(2) potenz 1/r^p(2)              [1]    ',input%p(2)
         print*,' p(3) Opening angle (*pi radians)  [0.125]',input%p(3)
         print*,' p(4) iexpgw1                      [3]    ',input%p(4)
         if (input%parameter.ne.4) then
           print*,'wrong number of parameter'
           stop
         endif

        a1r     = input%p(1)
        x1r     = input%p(2)
        thexx   = input%p(3) * (4 * atan(1.))
        iexpgw1 = input%p(4)
        height  = 5 * rinner

        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           netz(i,j,k) = 1
           if(idim3 .ne. 1)   then
              if (SQRT(i**2.+j**2.+k**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6)
              if (SQRT(i**2.+j**2.+k**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5)
              if (SQRT(i**2.+j**2.+k**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4)
              if (SQRT(i**2.+j**2.+k**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3)
              if (SQRT(i**2.+j**2.+k**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2)
              if (SQRT(i**2.+j**2.+k**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1)
              if (SQRT(i**2.+j**2.+k**2.).le.1) netz(i,j,k) = 2**(iexpgw1)
           else
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1)
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.+(k-0.5-nz/2.)**2.).le.1) netz(i,j,k) = 2**(iexpgw1)
           end if
        end do
        end do
        end do
!   Gesamtzahl isumuw aller UW
        isumuw = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           isumuw        = isumuw + netz(i,j,k)**3
           netsum(i,j,k) = isumuw
        end do
        end do
        end do
        write(6,*) ' ' 
        write(6,'(a33,1p1e10.2)') '7. Summe aller Unterwuerfel =  ', dfloat(isumuw)
        write(6,*) ' ' 

        if(isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

       call allocspace(isumuw)!allocate important values.

        do i = 1, isumuw
           iabs(i)    = 0
           isca(i)    = 0
        end do

!   ---------------------------------------------------------------------------
!  Zunächst wird die Dichte überall zu Null gesetzt
        do i = 1, isumuw
           dicht(i)    = 0.
        end do
        cl_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
              yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
              zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
              rr     = sqrt(xx2 + yy2 + zz2)
              factor=1.1*rinner*sin(thexx)/height 
              factor=0.5*dlog((1.+factor)/(1.-factor))
              factor=datan(height/(1.1*rinner*cos(thexx))*factor)/thexx !calculate tapering factor
              apos = tan(factor*thexx)/height
              xypos = sqrt(xx2 + yy2)
              if (rr .ge. rinner .and. rr .le. router) then 
                 if (sqrt(zz2) .gt. height*tanh(xypos*apos) ) then !check if cell is outside disc due to height or tapering and set density to zero
                     dicht(lp) = 0.
                 else
                     dicht(lp) = a1r / rr**x1r
                 endif 
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
              endif
           end do
           end do
           end do
        end do
        end do
        end do
       endif

! ---------------------------------------
!7.   Dichteverteilung nach Pascucci et al 2004:

        if (input%structure.eq.6) then
         print*,' **disc like density distribution (Pascucci et al 2004)'
         print*,' 5 parameter:'
         print*,'   p(1) -- rho_0, density at radius r_0   [?]',input%p(1)
         print*,'   p(2) -- h_0 (AU) scale height at r_0    [10]',input%p(2)
         print*,'   p(3) -- r_0 (AU)                       [100]',input%p(3)
         print*,'   p(4) -- power rho = rho_0 (r_0/r)^-p(4)  [1]',input%p(4)
!         print*,'   p(4) -- gap start',input%p(4)
!         print*,'   p(5) -- gap end',input%p(5)
         print*,'   p(5) -- iexpgw1                          [3]',input%p(5)

         if (input%parameter.ne.5) then
            print*,'wrong number of parameter'
            stop
        endif
        
        a1r = input%p(1)
        rd = input%p(3)*au !r_0
        zd = input%p(2)*au !h_0
        x1r = input%p(4)
        iexpgw1 = input%p(5)

        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           netz(i,j,k) = 1
           if(idim3 .ne. 1)   then
              if (SQRT(i**2.+j**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6-k)
              if (SQRT(i**2.+j**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5-k)
              if (SQRT(i**2.+j**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4-k)
              if (SQRT(i**2.+j**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3-k)
              if (SQRT(i**2.+j**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2-k)
              if (SQRT(i**2.+j**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1-k)
              if (SQRT(i**2.+j**2.).le.1) netz(i,j,k) = 2**(iexpgw1-k)
              if (k.eq.1) netz(i,j,k) = netz(i,j,k)*2
           else
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.7.and.iexpgw1.gt.6) netz(i,j,k) = 2**(iexpgw1-6-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.6.and.iexpgw1.gt.5) netz(i,j,k) = 2**(iexpgw1-5-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.5.and.iexpgw1.gt.4) netz(i,j,k) = 2**(iexpgw1-4-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.4.and.iexpgw1.gt.3) netz(i,j,k) = 2**(iexpgw1-3-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.3.and.iexpgw1.gt.2) netz(i,j,k) = 2**(iexpgw1-2-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.2.and.iexpgw1.gt.1) netz(i,j,k) = 2**(iexpgw1-1-abs(k-nz/2))
              if (SQRT((i-0.5-nx/2.)**2.+(j-0.5-ny/2.)**2.).le.1) netz(i,j,k) = 2**(iexpgw1-abs(k-nz/2))
              if (k.eq.int(nz/2.-0.45)+1) netz(i,j,k) = netz(i,j,k)*2
              if (k.eq.int(nz/2.)+1) netz(i,j,k) = netz(i,j,k)*2
              if (netz(i,j,k).ne.1) netz(i,j,k) = netz(i,j,k) + 1
           end if
           if (netz(i,j,k).lt.1) netz(i,j,k) = 1
        end do
        end do
        end do
!   Gesamtzahl isumuw aller UW
        isumuw = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           isumuw        = isumuw + netz(i,j,k)**3
           netsum(i,j,k) = isumuw
        end do
        end do
        end do
        print *, ' 6. Summe aller Unterwuerfel =', isumuw
        if (isumuw .ge. naw)  stop 'Zu viele Unterwuerfel'

       call allocspace(isumuw)!allocate important values.

        do i = 1, isumuw
           iabs(i)    = 0
           isca(i)    = 0
           Tsi(i) = 0
           Tc(i) = 0
           nabsc(i) = 0
           nabssi(i) = 0
        end do
!
        do i = 1, isumuw
           dicht(i)    = 0.
!           dicht(i)    = 3.5d-20
        end do
        if(dicht(1) .ne. 0) print*, ' WARNING !  Zunächst wird die Dichte überall UNGLEICH Null gesetzt'
        cl_mass = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
              lp  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
              xx  = (x(i) + (ii - 5d-1) * dl-xorg)
              yy  = (y(j) + (jj - 5d-1) * dl-yorg)
              zz  = (z(k) + (kk - 5d-1) * dl-zorg)
              xx2 = xx**2
              yy2 = yy**2
              zz2 = zz**2
              rr  = sqrt(xx2 + yy2)
              if (rr .ge. rinner .and. rr .le. router) then
                 f1 = (rd/rr)**x1r !r dependence of rho_0
                 hr = zd * ((rr/rd)**1.125) !scale height dependence
                 f2 = hr**2
                 f2 = zz2/f2
                 f2 = f2/2
                 f2 = exp(-f2)
!                 f2 = 1/(exp((1/2)*(zz2/(hr**2.))))
                 dicht(lp) =  a1r  * f1 * f2
!                 rr_disk = sqrt(xx2+yy2)
!                 n_spiral = input%p(3)
!                 phi_spiral = sign(1d0,yy)*acos(xx/rr_disk)
!                 if (phi_spiral.lt.0) phi_spiral = phi_spiral+2.*pi
!                 phi_spiral = phi_spiral+int(rr_disk/router*n_spiral)*2.*pi
!                 a_spiral = router / 2. /pi / n_spiral
!                 x_spiral = a_spiral * phi_spiral * cos(phi_spiral)
!                 y_spiral = a_spiral * phi_spiral * sin(phi_spiral)
!                 dist_spiral = sqrt((x_spiral-xx)**2+(y_spiral-yy)**2)
!                 if (rr_disk.gt.input%p(4)*au.and.rr_disk.lt.input%p(5)*au) dicht(lp) = dicht(lp)*1e-5
!                 if (rr_disk.gt.input%p(5)*au.and.dist_spiral.le.input%p(2)*au*(rr_disk/router).and.phi_spiral.lt.n_spiral*2.*pi) &
!& then 
!                    dicht(lp) = dicht(lp)*1e-5
!                 endif
                 cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
              endif
           end do
           end do
           end do
        end do
        end do 
        end do
        endif 

!----------------------------------------------------------------------------
! Clumpy AGN torus

        if(input%structure .eq. 7) then
           call space_2phase_torus(init)!,cl_mass)
           if (idim3.ne.1) stop ' only in 3D at the moment'
           iexpGW1 = 2
        endif

!----------------------------------------------------------------------------
! Molecular cloud, background with circumstellar shell

        if(input%structure .eq. 8) call simple_cluster(init,iter)

!----------------------------------------------------------------------------
! Transitional disc, e.g. HD169142

        if(input%structure .eq. 9) call var_disc(init) !temporary change for test, usually gap_disc

!----------------------------------------------------------------------------
! Read in structure from binary files (grid.bin, absorbtion.bin)

        if(input%structure .eq. 10)  call read_struct(init,iter)

!----------------------------------------------------------------------------
! Star with distant shell

        if(input%structure .eq. 11) call clumpyshell(init) !M17shell
! Star with distant clumps

        if(input%structure .eq. 12) call clumpycloud(init) !M17shell


!----------------------------------------------------------------------------
! AGN with clumpy envelope and disk

        if(input%structure .eq. 14) call space_2phase_torus_disk(init)!

!-------------------------------------------------------------------------------
! reading in data from file
!-------------------------------------------------------------------------------
if (input%structure.eq.(-1)) then
	if (input%parameter.ne.1) then
		print*,'wrong number of parameter'
		stop
	endif
	call read_datafile(init)
        
        if (input%p(1).eq.7) then
        	iexpGW1=3
		clump_profile = 2.
		ninteg = max(nx,ny,nz)*iexpGW1*100
		integ = 0
		do i=1,ninteg
		   r = (router-rinner)*i*1./ninteg+rinner
		   integ = integ + (r/rinner)**(-0)*(router-rinner)/ninteg
		end do
		density_2phase = 1./C_abs_ac(ivisd)/integ*1d1
		density_clump = 81.0*1./C_abs_ac(ivisd)/dgw/2.0
	endif
	input%structure = input%p(1)
end if

!
! ---------------------------------------------------
!   Bestimme cc4
!

do jth = 1, nthet
	cc4(jth) = cc3 * 1d23 / pi4 / dist**2 / (dirthet(jth+1) - dirthet(jth))
end do

!  --------------------------------------------------------------------------
!  ***  Ausdruck der Wolkenstruktur laengs x-Achse  ***


        print "('  8. Wolkenmasse [M_o] =', 1pe10.2, ' r_in=', e10.2,' r_out =',e10.2)", cl_mass/2d33, rinner, router

        tauV = 0.
        j1   = 1
        k1   = 1
        if (idim3.eq.1) then  
           j1 = ny/2 + 1
           k1 = nz/2 + 1
           jj1=netz(1,j1,k1)/2+1
           kk1=netz(1,j1,k1)/2+1
        else
           jj1 = 1
           kk1 = 1
        endif
        do   i = 1, nx
        do  ii = 1, netz(i,j1,k1)
              xx = x(i) + (ii-1) * dGW / netz(i,j1,k1)
              lp = netsum(i,j1,k1) -  netz(i,j1,k1)**3 + netz(i,j1,k1)**2 * (ii - 1) + netz(i,j1,k1) * (jj1 - 1) + kk1
              dtauV   = Cext_V * dicht(lp) * dGW / netz(i,j1,k1)


              if(ibug .ge. 3)   print 138, i,ii, xx, dicht(lp), tauV, dtauV, netz(i,j1,k1)

              tauV  = tauV + dtauV
           end do
        end do
        xx = nx * dGW
        if (idim3.eq.1) then
           print*, ' ** tauVx measured from Star at  xorg = xx/2 to router: '
           tauV = tauV/2.
           xx   = xx/2.
        end if

        write(6,*)  '  i      xx                        taux '
        print '(i4, 1pe15.3, 11x, 1pe15.3)', i, xx, tauV 
 138  format(2i4, 1pe11.3, 3e11.2, 1x, i8)

!
!  ---------------------------------------------------------------------------
!  ***  Ausdruck der Wolkenstruktur laengs z-Achse  ***
        tauV = 0.
        i1   = 1
        j1   = 1
        if (idim3.eq.1) then  
           i1 = nx/2 + 1
           j1 = ny/2 + 1
           ii1=netz(i1,j1,1)/2+1
           jj1=netz(i1,j1,1)/2+1
        else
           ii1 = 1
           jj1 = 1
        endif

           print*, ' ** tauVz measured through disk at ....: '
! zum Ausdruck tau = f(z) bei x=rtest= Rinner, y=0.
           open(unit=27,file='output/L.Ritauz0',form='formatted')	
           rewind(27)
           write(6,*)  ' Rinner     i   k   zz                      tauz0 '
           write(27,*) ' ** tauVz measured through disk at Rinner: '
           rtest = rinner + xorg
           rtest = xorg
           call nlocat (x, nx, rtest, i1)
           i1 = i1+1
           if(i1 .ge.nx) i1 = nx
           write(27,'(a26, 4x, 1p1e10.2,1x,i4)') ' Rinner-xorg, i1    : ', x(i1)
           write(27,*) '  k   kk    zz       dicht(lp)     tauV      dtauV    netz(i1,j1,k)'

        do  k = 1, nz
        do kk = 1, netz(i1,j1,k) 
              zz = z(k) + (kk-5d-1) * dGW / netz(i1,j1,k)
              lp = netsum(i1,j1,k) - netz(i1,j1,k)**3 + netz(i1,j1,k)**2 * (ii1 - 1) + netz(i1,j1,k) * (jj1 - 1) + kk
              dtauV   = Cext_V * dicht(lp) * dGW / netz(i1,j1,k)
                write(27,'(2i4, 1pe11.3, e11.2, 1x, 0p2f10.3, 1x, i8)') &
                k,kk, zz, dicht(lp), tauV,dtauV, netz(i1,j1,k)
              if(ibug .ge. 2 .and.dicht(lp).ge.0 .and. dtauV .gt.0)  then
                write(6,'(2i4, 1pe11.3, e11.2, 1x, 0p2f10.3, 1x, i8)') &
                k,kk, zz, dicht(lp), tauV,dtauV, netz(i1,j1,k)
              endif
              tauV  = tauV + dtauV
           end do
        end do 
        zz = nz * dGW
        print*, '  x(i1)     i1   k    zz                     tauV '

        if (idim3.eq.1) then
          print '(1p1e10.2, 2i4, 1e10.2, 11x,  1pe15.3)', x(i1), i1, k, zz, tauV/2.
        else
          print '(1p1e10.2, 2i4, 1e10.2, 11x,  1pe15.3)', x(i1), i1, k, zz, tauV
        endif


! zum Ausdruck tau = f(z) bei x=rtest= Router, y=0.
           write(6,*)  ' Router     i   k   zz                      tauz0 '
           write(27,*) ' ** tauVz measured through disk at Router: '
           rtest = Router + xorg
           call locat (x, nx, rtest, i1)
           i1 = i1 -1
           if(i1 .ge.nx .and. ibug.ge.1) i1 = nx
           write(27,'(a26, 4x, 1p1e10.2,1x,i4)') ' Router-xorg, i1    : ', rtest-xorg,i1
           write(27,*) '  k   kk    zz       dicht(lp)     tauV      dtauV    netz(i1,j1,k)'

        tauV = 0. 
        dtauV = 0.
        do  k = 1, nz
        do kk = 1, netz(i1,j1,k) 
              zz = z(k) + (kk-5d-1) * dGW / netz(i1,j1,k)
              lp = netsum(i1,j1,k) - netz(i1,j1,k)**3 + netz(i1,j1,k)**2 * (ii1 - 1) + netz(i1,j1,k) * (jj1 - 1) + kk
              dtauV   = Cext_V * dicht(lp) * dGW / netz(i1,j1,k)
                write(27,'(2i4, 1pe11.3, e11.2, 1x, 0p2f10.3, 1x, i8)') &
                k,kk, zz, dicht(lp), tauV,dtauV, netz(i1,j1,k)
              if(ibug .ge. 2 .and.dicht(lp).ge.0 .and. dtauV .gt.0)  then
                write(6,'(2i4, 1pe11.3, e11.2, 1x, 0p2f10.3, 1x, i8)') &
                k,kk, zz, dicht(lp), tauV,dtauV, netz(i1,j1,k)
              endif
              tauV  = tauV + dtauV
           end do
        end do 
        zz = nz * dGW
        print*, '  x(i1)     i1   k    zz                     tauV '
        if (idim3.eq.1) then
          print '(1p1e10.2, 2i4, 1e10.2, 11x,  1pe15.3)', rtest-xorg, i1, k, zz, tauV/2.
        else
          print '(1p1e10.2, 2i4, 1e10.2, 11x,  1pe15.3)', rtest-xorg, i1, k, zz, tauV
        endif
        close(unit=117)
        close(unit=27)
        
        return
end subroutine space

!
! --------------------------------------
!

subroutine read_struct(init,iter)

!-----------------------------------------------------------------
! Reads in structure of previous MC run from output files grid.bin
! and absorbtion.bin including dust temperatures and densities
!-----------------------------------------------------------------

use type_module
use parameter
use constants
implicit none

type(init_type)         :: init
integer                 :: ix,iy,iz,iux,iuy,iuz,ntz
integer                 :: dumx,dumy,dumz,iter,isumuw1
integer                 :: dumux,dumuy,dumuz,lp_old,check,lp_new,check2
real*8                  :: dl,Tsitemp,Tctemp,dichttemp
character*30            :: file

print*,'Reading structure from output files'


!open files for reading
        file = 'output/grid.bin'
        open(unit=22, file=file, form='unformatted')
        file = 'output/absorbtion.bin'
        open(unit=23, file=file, form='unformatted')
        rewind 22
        rewind 23


!read grid from file
        read(22),isumuw
! allocate memory
        call allocspace(isumuw)
        isumuw1 = 0
  	do ix=1,nx
	do iy=1,ny
	do iz=1,nz
		read(22) dumx,dumy,dumz,netz(dumx,dumy,dumz)
                isumuw1 = isumuw1 + netz(dumx,dumy,dumz)**3
!                if(ix .ne. dumx) print*,'xcheck',ix,dumx
!                if(iy .ne. dumy) print*,'ycheck',ix,dumy
!                if(iz .ne. dumz) print*,'zcheck',ix,dumz
                netsum(dumx,dumy,dumz) = isumuw1
	end do	
	end do
	end do

        write(6,*) ' ' 
        write(6,'(a33,1p1e10.2)') '7. Summe aller Unterwuerfel =  ', dfloat(isumuw)
        write(6,*) ' ' 

if(netsum(nx,ny,nz) .ne. isumuw) stop 'netsum error'
        cl_mass = 0d0

! set allocated memory to 0
        do i = 1,isumuw
                   Tsi(i) = 0
                   Tc(i) = 0
                   iabspah(i) = 0
                   dicht(i) = 0
                   inopah(i) = 0
        enddo
check = 0
check2 = 0
! read temperatures and densities
	do ix=1,nx
	do iy=1,ny
	do iz=1,nz
           ntz = netz(ix,iy,iz)
           dl  = dGW / ntz
		do iux=1,ntz
		do iuy=1,ntz
		do iuz=1,ntz
                    read(23) lp,dumx,dumy,dumz,dumux,dumuy,dumuz,Tsitemp,Tctemp,dichttemp!Tsi(lp),Tc(lp),dicht(lp)
                    !lp_old = netsum(dumx,dumy,dumz) - netz(dumx,dumy,dumz)**3 + netz(dumx,dumy,dumz)**2*(dumux-1)+&
!& netz(dumx,dumy,dumz)*(dumuy-1) + dumuz
                    lp_new = netsum(ix,iy,iz) - ntz**3 + ntz**2*(iux-1)+ntz*(iuy-1) + iuz
                    if (lp_new .lt. 1) print*,lp_new,netsum(ix,iy,iz),ntz,ix,iy,iz,iux,iuy,iuz
                    Tsi(lp_new) = Tsitemp
                    Tc(lp_new) = Tctemp
                    dicht(lp_new) = dichttemp
                if(ix .ne. dumx) print*,'xcheck',ix,dumx
                if(iy .ne. dumy) print*,'ycheck',ix,dumy
                if(iz .ne. dumz) print*,'zcheck',ix,dumz
                   ! if (lp_old .ne. lp) check = check + 1
                    if (lp_new .ne. lp) check2 = check2 + 1
                   ! if (lp_new .ne. lp_old) print*,'lp dif',lp_new,lp_old,ix,iy,iz,iux,iuy,iuz,dumx,dumy,dumz,dumux,dumuy,dumuz
                   ! if (lp_old .ne. lp) print*,'lp old',netz(ix,iy,iz),netz(dumx,dumy,dumz),netsum(ix,iy,iz),netsum(dumx,dumy,dumz)!lp_old,lp!,ix,iy,iz,iux,iuy,iuz,dumx,dumy,dumz,dumux,dumuy,dumuz
!                    if (lp_new .ne. lp) print*,'lp new',lp_new,lp,ix,iy,iz,iux,iuy,iuz,dumx,dumy,dumz,dumux,dumuy,dumuz
                    !sum cloud mass
                    cl_mass = cl_mass + cc3 * dicht(lp) * dl**3
	     	end do
		end do
		end do
	end do	
	end do
	end do
print*,check,check2
        print "('  8. Wolkenmasse [M_o] =', 1pe10.2, ' r_in=', e10.2,' r_out =',e10.2)", cl_mass/2d33, rinner, router
        print*, ' ' 

close(22)
close(23)

print*,'Stucture read'

!-----------------------------
! if necessary, paste printouts from space here

end subroutine read_struct



!
! -------------------------------------------------------------------------
subroutine dicke_scheibeTmid(init)

!
! Erste Festlegung der Dichte Verteilung aus midplane Temperatur f.
! Keppler Scheibe ohne vertikalen Druckgradienten
! Falls ileseTmid =0: Festlegung vom Gitter (UW) und grober Fit 
!                    der  midplane Temperatur
! Falls ileseTmid =1: midplane Temperatur vom file eingelesen.
!


use type_module
use parameter
use constants
use omp_lib

implicit none
        type(init_type) :: init
        real*8  :: tauVrsmax,  aheight, beta, gam
	real*8	:: cl_mass1, fakcon, Hscal, cs, Height, mu
        real*8  :: rr, rrr, tauV_mid, temp_mid, dum
        real*8  :: xx2, yy2, zz2, xx, yy,zz, dl, dr, dz
        real*8  :: x1, x2, y1,y2
        real*8  :: dl1, zz1, fak
        real*8  :: surf, surfr, zmin, ell, protmu
        real*8  :: dichtz, dichtzmin,  dichtzmin1, tauz0, dtauz
        real*8  :: tauz01
        real*8  :: xmid0(2000), Tmid0(2000)
        real*8  :: tauVmin, routfein
        real*8, allocatable  :: ztop(:)    ! Scheibenhoehe ztop(rho.ne.0) 
        real*8, allocatable  :: zbottom(:) ! Scheibenhoehe zbottom(tau=1) 
        real*8, allocatable  :: tauzvert(:) ! tau(z) bei Rmid

	integer	:: im, nmid0, isot, ileseTmid
	integer	:: ii,jj,kk, iz, iorg, jorg, korg,kmirror
	integer	:: ntz, ntz1, nuwz, itop,ibottom, l, i1au
!
! -------------------------------------------------------


!        ileseTmid   = 1

!$omp parallel do private(i,j,k)
        do i  = 1, nx
        do j  = 1, ny
        do k  = 1, nz
           netz(i,j,k) = 1
        end do
        end do
        end do
!omp end parallel do


        nUWzmax  = input%p(5)
        nzUW     = nz*nUWzmax

        protmu   = 2.33 *protm
        aheight  = input%p(2)
        Mstar    = input%p(3)
        beta     = 0.5d0   
        tauVrsmax = input%p(1)
        fakcon   = boltz    * tstar / (grav*mstar*protmu)


        rstar  = sqrt(LQuelle/pi4/sigma/tstar**4)  ! Stern radius
        write(6,'(a30,1p1e10.2)') '    Stern radius                      = ', rstar
        write(6,'(a40,1p2e10.2)') &
&            '   ** Saulendichte [g-DUST/cm^2] @ 1 AU = ', 2.*tauVrsmax/Cext_V
        print*, ' '
! Center of Disk:
            call locat (x, nx, xorg, iorg)
            call locat (y, ny, yorg, jorg)
            call locat (z, nz, zorg, korg)
            iorg = iorg+1
            jorg = jorg+1
            korg = korg+1
       if(x(iorg).ne.xorg.or.y(jorg).ne.yorg.or.z(korg).ne.zorg) then
           print*, ' *** Star position at: '
           print*, ' iorg   x(iorg)  xorg'
           write(6,'(i6,1p2e10.2)') iorg, x(iorg), xorg
           write(6,'(i6,1p2e10.2)') jorg, y(jorg), yorg
           write(6,'(i6,1p2e10.2)') korg, z(korg), zorg
           print*, '*** Check out ! ***'
           print*, ' ' 
        endif

        if(x(nx1).lt.xorg+router .or. y(ny1).lt.yorg+router) then
           print*, ' *** Beachte:  Initialisierung: x(nx+1) < router'
           print*, '       x(nx1)       xorg      xorg+router '
           write(6,'(7x, 1p3e10.2)') x(nx1), xorg, xorg+router
!          write(6,'(7x, 1p3e10.2)') y(ny1), yorg, yorg+router
           print*, ' *** Reduce router or increase dGW?'
           stop 
         endif
!
! --------------------------------------------
! Einlesen von der vorberechneten mid plane temperatur:
!
         if(ileseTmid .eq.1) then
          print*, ' *** Einlesen vorberechneter mid plane temperatur'
          open(9,file='input/L.finTmid', form='formatted')
          rewind(9)
          nmid0 = 0
          do i  = 1, 2000
          read(9,*, end=99) xmid0(i), Tmid0(i)
          nmid0 = nmid0 + 1
          if(ibug .ge. 2) write(6,*) xmid0(i), Tmid0(i)
          end do  
  99      continue
          if(nmid0 .ge. 2000) stop ' change dimension of xmid0, Tmid0'
          if(xmid0(1) .gt. rinner) stop ' xmid0 > rinner'
          if(xmid0(nmid0) .lt. router) stop ' xmid0 < router'
          if(ibug .eq. 1) write(6,'(a40,i8)')  &
    &     '      ./input/L.finTmid eingelesen: nmid0 = ', nmid0
         endif
!
! --------------------------------------------
! rinner:
           rr  = rinner
        if(rr.lt.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamin
        if(rr.ge.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamout
        if(ileseTmid .eq. 0) then
         temp_mid = tstar*(fakcon*rstar**4*(aheight/14d0)**2/rr**3)**(1./7.)
        else
!       get midplane temperature
         im     = 0
         call nlocat(xmid0, nmid0, rr, im)
            if(im.gt.1 .and.im.lt.nmid0) then
             temp_mid =(Tmid0(im)-Tmid0(im-1))/(xmid0(im)-xmid0(im-1))* &
&                      (rr-xmid0(im-1)) + Tmid0(im-1)
             else
               temp_mid = Tmid0(im)
             end if
        endif

        Hscal   = sqrt(boltz*temp_mid*rr**3 / (grav*Mstar*protmu))
        Height  = aheight * Hscal
        surf    = tauV_mid /Cext_v

        if(ibug .ge.1) then   
         write(6,'(a30,1p1e10.2)') 'Bei distance from star r= ', rr
         write(6,'(a30,1p1e10.2)') '    midplane Temperatur = ', temp_mid
         write(6,'(a30,1p1e10.2)') '    ztop                = ', Height

        endif
        if(ibug .ge.1) then   
         write(6,'(a30,1p1e10.2)') '    midplane Tau        = ', tauV_mid
         write(6,'(a30,1p1e10.2)') '    scale   Height      = ', Hscal
         write(6,'(a30,1p1e10.2)') '    ztop-ell            = ', Height-Hscal/2.
         write(6,'(a30,1p1e10.2)') '         ell            = ', Hscal/2.
        endif
        if(idim3.eq.1) then
         print*, '    Notwendige #GW in z(Rinner)  = ',  2*ceiling(Height/dgw), nz, '= nz'
        else
         print*, '    Notwendige #GW in z(Rinner)  = ',  ceiling(Height/dgw), nz, '= nz'
        endif


! router:
           rr  = router
        if(rr.lt.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamin
        if(rr.ge.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamout
        if(ileseTmid .eq. 0) then
         temp_mid = tstar * (fakcon * rstar**4 * (aheight/14d0)**2 / &
&                                     dmax1(rr,rinner)**3.)**(1./7.)
        else
!       get midplane temperature
        im     = 0
        call nlocat(xmid0, nmid0, rr, im)
            if(im.gt.1 .and.im.lt.nmid0) then
             temp_mid =(Tmid0(im)-Tmid0(im-1))/(xmid0(im)-xmid0(im-1))* &
&                                    (rr-xmid0(im-1)) + Tmid0(im-1)
             else
               temp_mid = Tmid0(im)
             end if
        endif


        Hscal   = sqrt(boltz*temp_mid*rr**3 / (grav*Mstar*protmu))
        Height  = aheight * Hscal
        if(ibug .ge.1) then   
         write(6,'(a30,1p1e10.2)') 'Bei distance from star r= ', rr
         write(6,'(a30,1p1e10.2)') '    midplane Temperatur = ', temp_mid
         write(6,'(a30,1p1e10.2)') '    ztop                = ', Height
        endif


        if(ibug .ge.2) then   
         write(6,'(a30,1p1e10.2)') '    midplane Tau        = ', tauV_mid
         write(6,'(a30,1p1e10.2)') '    scale   Height      = ', Hscal
         write(6,'(a30,1p1e10.2)') '    ztop-ell            = ', Height-Hscal/2.
         write(6,'(a30,1p1e10.2)') '         ell            = ', Hscal/2.
        endif
        if(idim3.eq.1) then
          print*, '    Notwendige #GW in z(Router)  = ', 2 * 2*ceiling(Hscal/dgw), nz, '= nz'
        else
          print*, '    Notwendige #GW in z(Router)  = ',  2*ceiling(Hscal/dgw), nz, '= nz'
        endif


!
! ----------------------------------------------------------------------------------
! Berechnung von notwendigen UW (netz) aus Vergleich zur Dicke der Extinktionlayer:
! Hier gibt es manchmal sampling Probleme!  Zum Testen notwendig, dass idim3=0 und 
! idm3=1 jeweils gleiche: cl_mass, tauVx haben.
! Falls nUWzmax zu gross wird ist tauVx, cl_mass manchmal verschieden...?...
! Annahme Scheiben Zentrum bei korg, berechne nUWzmax nur f. positive vertikale
! Scheibenachse (k.ge.korg) und Werte von netz(*,*,k<korg) durch Spieglung.
! 
        open(unit=36,file='output/L.Height',form='formatted')	

! Initial guess of netz: erste Unterteilung in UW:
! Berechnung tau der GW und ntz = tau/tauVmin

        routfein = 2.*au
        tauVmin  = 0.8
 write(6,'(a,2f7.2)') '     UW tauVmin bis routfein [AU]: ', &
& tauVmin, routfein/au

! print*, '   i,  j   k, tauz0   dtau        rr        zz,     ell,     ztop,    ntz, dfloat(isumuw)'
! print*, '  ntz, l,   tauz0,   zz,   rr, ell, i,j,k '


        ii = 1
        jj = 1
        isumuw  = 0
        dl     = 0
        do i  = 1, nx
        do j  = 1, ny
           xx = x(i)  +  (ii - 5d-1) * dl-xorg
           yy = y(j)  +  (jj - 5d-1) * dl-xorg
           rr = min(sqrt(xx**2+yy**2), router)
           rr = max(rr, rinner)
        if(rr.lt.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamin
        if(rr.ge.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamout

        if(ileseTmid .eq. 0) then
!        get midplane temperatur
         temp_mid = tstar * (fakcon * rstar**4 * (aheight/14d0)**2 / &
&                                     dmax1(rr,rinner)**3.)**(1./7.)
        else
         im     = 0
         call nlocat(xmid0, nmid0, rr, im)
           if(im.gt.1 .and.im.lt.nmid0) then
             temp_mid =(Tmid0(im)-Tmid0(im-1))/(xmid0(im)-xmid0(im-1))* &
&                                    (rr-xmid0(im-1)) + Tmid0(im-1)
            else
               temp_mid = Tmid0(im)
            endif
        endif
        Hscal     = sqrt(boltz*Temp_mid*rr**3 / (grav*Mstar*protmu))
        cs        = sqrt(boltz*Temp_mid/protmu)
        Height    = aheight * Hscal
        surf      = tauV_mid /Cext_v
        ell       = hscal/ 2. ! Dicke der extinktion layer
        zmin      = Height - ell
        Hscale(i) = sqrt(boltz*Temp_mid*rr**3 / (grav*Mstar*protmu))
        csound(i) = sqrt(boltz*Temp_mid/protmu)
        if(ibug .ge. 3)  write(6,*) '  rr, temp_mid'
        if(ibug .ge. 0 .and.temp_mid.le.10.) write(6,'(1p4e10.2)') rr, temp_mid


        do k           = korg, nz
           netz(i,j,k) = 1
           ntz         = 1
           ntz1        = 1
           kk          = 1

       if(rr.ge.rinner.and.rr.le.routfein) then

     !iterate sampling in tau bei z mit kk=1 und kk=ntz:
         do l = 1,3
           kk          = ntz
           dl          = dGW / ntz
           dl1         = dGW / ntz1
           zz          = z(k) + (kk - 5d-1) * dl-zorg
           zz1         = z(k) + (1. - 5d-1) * dl1-zorg
           dtauz       = 0d0
           dichtzmin   = max(surf/Hscal*sqrt(2.d0/pi) * exp(-(zz**2.)/2.d0/Hscal**2.), 1.d-30)
           dichtzmin1  = max(surf/Hscal*sqrt(2.d0/pi) * exp(-(zz1**2.)/2.d0/Hscal**2.), 1.d-30)
           tauz0        = Cext_V * dichtzmin *dl
           tauz01       = Cext_V * dichtzmin1 *dl1

              if(((k-1)*dgw<Height.and.(k-1)*dgw>zmin).or. &
&                    ( k*dgw<Height.and.(k)*dgw>zmin).or. &
&                    ((Height-zmin)/2<(k*dgw).and.(Height-zmin)/2>(k-1)*dgw) .or. &
&                    (k*dgw > Height          .and.(k-1)*dgw < zmin) .or. &
&                    (k*dgw > (Height-zmin)/2..and.(k-0.5)*dgw < zmin)) then
                 ntz    = min(ceiling(tauz0 /tauVmin), nUWzmax)
                 dtauz  = tauz0 / float(ntz)
              end if

              if(((k-1)*dgw<Height.and.(k-1)*dgw>zmin).or. &
&                    ( k*dgw<Height.and.(k)*dgw>zmin).or. &
&                    ((Height-zmin)/2<(k*dgw).and.(Height-zmin)/2>(k-1)*dgw) .or. &
&                    (k*dgw > Height          .and.(k-1)*dgw < zmin) .or. &
&                    (k*dgw > (Height-zmin)/2..and.(k-0.5)*dgw < zmin)) then
                 ntz1    = min(ceiling(tauz01 /tauVmin), nUWzmax)
              end if
!if(ntz.gt.1 .or. ntz1.gt.1 .and.dtauz .gt.0) then
! write(6, '(3i4,1f7.2, 1p4e10.2,3i4)') l, ntz, ntz1, dtauz, zz, zz1, rr, ell,i,j,k 
!endif


           ntz  = max(ntz1,ntz)
           ntz1 = ntz
          end do
! end iter tau:
        end if


                         netz(i,j,k)   = ntz
        if(ntz .gt.1)    netz(i,j,k+1) = 2
        if(rr.lt.rinner) netz(i,j,k)   = 1

        isumuw      = isumuw + netz(i,j,k)**3

        if(y(j) .eq. yorg .and. z(k).eq.zorg) then
         if(i .eq.1) write(36, *) '    i  x         1Hscale     csound   Temp_mid  (at star position)'
              Hscale(i)= sqrt(boltz*Temp_mid*rr**3 / (grav*Mstar*protmu))
              csound(i)= sqrt(boltz*Temp_mid/protmu)
              write(36, '(i6, 1p1e11.3, 3e10.2)')  i, x(i), Hscale(i), csound(i), Temp_mid
        end if

        end do
! end over vertikal direction
! --------------------
! remove subsampling in UW in vertikal direction when possible
! seems not necessary but worth to check:
! zur zeit verkleinerung von netz auskommentiert:
!        tauz0   = 0
!        do k   = nz, korg+1, -1
!          ntz  = netz(i,j,k)
!          dl   = dGW/ntz
!          zz   = z(k) + (kk - 5d-1) * dl-zorg
!          dichtz  = surf/Hscal*sqrt(2.d0/pi) * exp(-(zz**2.)/2.d0/Hscal**2.)
!          if(rr.ge.rinner .and.zz.le.Height .and.dichtz .ge.1d-30) then
!           dtauz= Cext_V * dichtz*dl
!           tauz0 = tauz0 +  dtauz
!  if(netz(i,j,k-1).gt. 2) then
!   if(tauz0.gt.1) print*, k, netz(i,j,k-1), tauz0, dtauz
!    if(tauz0.gt.1 .and. (tauz0-dtauz).ge.tauvmin) then
!      print*, 'check rm subsampling in z close to midplane'
!      write(6, '(3i4,1x,1f7.2, 2x, 1p4e10.2,1x,i4,1x,1e10.1)') &
!&     i,j,k, dtauz, tauz0, rr, zz, ell, netz(i,j,k), dfloat(isumuw)
!     netz(i,j,k-1) =  netz(i,j,k-1)/2
!    end if
!         end if
!         end do
! --------------------

        end do
        end do

      close(36)

! --------------------------------------------------------
! setze netz per hand falls notwendig


print*, ' ' 
print*, ' ---------------------'
print*, '! setze netz per hand : ' 
print*, ' ---------------------'

        ii = 1
        jj = 1
        do i  = 1, nx
        do j  = 1, ny
        do k  = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           xx = x(i)  + (ii - 5d-1) * dl-xorg
           yy = y(j)  + (jj - 5d-1) * dl-yorg
           rr = min(sqrt(xx**2+yy**2), router)

!           if(rr .gt. rinner .and. rr .lt. routfein) netz(i,j,k)=1 !.and. k .le. 3) netz(i,j,k) = 1
      if(rr .ge.8d12 .and. rr.lt.1.d13 .and. abs(k-int(zorg/dGW)).le.2) netz(i,j,k) = 10
      if(rr .ge.1.2d13 .and. rr.lt.1.5d13 .and. abs(k-int(zorg/dGW)).le.3) netz(i,j,k) = 18
 
    if(rr .ge.1.6d13 .and. k.eq.1) netz(i,j,1) = 1
    if(rr .ge.1.6d13 .and.rr.le.2.1d13) netz(i,j,k) = max(netz(i,j,k)/2,1)
    if(rr .ge.1.7d13 .and.rr.le.2.1d13) netz(i,j,k) = max(netz(i,j,k)/3,1)
    if(rr .ge.routfein .or. abs(k-int(zorg/dGW)) .gt.4) netz(i,j,k) = 1

       end do
        end do
        end do


goto 98


! noch mehr per Hand:
!
        do i  = 1, nx
        do j  = 1, ny
        do k  = 1, nz-1

         if(SQRT(i**2.+j**2.).lt.6) netz(i,j,k) = 1
 
         if(k.eq.2 .and.SQRT(i**2.+j**2.) .ge.12.) then
!  if(SQRT(i**2.+j**2.).gt.26) netz(i,j,k) = 1
         end if

        end do
        end do
        end do

! -------------------------------------------
  
 98 continue
!
! -------------------------------------------------------------
! Spieglung: vertikale Scheibenachse bei z < zorg 
! (nur getestet f. korg gerade)

        if(idim3 .eq.1) then
         if(mod(korg,2) .ne. 0) print*, "   *** Warning check Spieglung for uneven korg"
         do i  = 1, nx
         do j  = 1, ny
         do k  = 2, korg-1
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           kmirror     = nz - k + 2
!           print*, k, korg, kmirror
           netz(i,j,k) = netz(i,j,kmirror)
           nuwz        = netz(i,j,kmirror)     
           ii = 1
           jj = 1
           kk = 1
           xx = (x(i) + (ii - 5d-1) * dl-xorg)
           yy = (y(j) + (jj - 5d-1) * dl-yorg)
           rr = min(sqrt(xx**2+yy**2), router)
          if(nUWz.gt.1 .and. j.eq.jorg .and. ibug.ge.3) &
&            write(6,'(2i3,1p1e10.2, 3i4,1e10.2)') &
&                  nUWz, i, rr, kmirror, korg, k, z(kmirror)-zorg
          if(abs(zorg-z(kmirror)).ne.abs(z(k)-zorg)) then
             write(6,'(1p3e10.2)') abs(zorg-z(kmirror)), zorg-z(kmirror), (z(k)-zorg)
             stop ' ckeck zorg-z(kmirror) not ok? ..check !'
          endif
         end do
         end do
         end do
        endif
!
! --------------------------------------------------------
! nun sind alle notwendingen UW in z-Richtung berechnet und in netz gespeichert.
!   Gesamtzahl isumuw aller UW
        isumuw = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           isumuw        = isumuw + netz(i,j,k)**3
           netsum(i,j,k) = isumuw 
!           if(isumuw .ge. naw)  then
!              write(6,'(a32,1p1e12.3, 3i4)') ' Maximum # Unterwuerfel =  ', dfloat(isumuw), i,j,k
!              stop 'Zu viele Unterwuerfel'
!           endif
        end do
        end do
        end do
        write(6,*) ' ' 
        write(6,'(a33,1p1e10.3)') '7. Summe aller Unterwuerfel =  ', dfloat(isumuw)
        print*, ' '

!allocate important numbers
        call allocspace(isumuw)

! !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2D Gitter: sezten eines radialen und vertikalen Gitters zur :
! azimuthalen Mittelung der Temp., Dichte
! a) Berechnung: Anzahl Gitterpkt. nmid in r-Richtung

           nmid   = 0
           j      = 1
         do  i    = 1, nx
             ntz  = 1
             do k = 1, nz
              ntz = max(netz(i,j,k),ntz)
             end do
           dl     = dGW / ntz
           do  ii = 1, ntz
            xx    = (x(i) + (ii - 0.5) * dl - xorg)
            if(xx .ge.rinner .and. xx .le.router)   nmid   = nmid + 1
           end do
          end do
          write(6,'(a, i5)') '     Anzahl UW entlang x der midplane  = ', nmid
          write(6,'(a, i5)') '     Anzahl UW entlang z -Achse        = ', nzUW



          allocate(itopr(nmid))
          allocate(ibotr(nmid))
          allocate(isotr(nmid))
          allocate(Rmid(nmid))
          allocate(Tmid(nmid))
          allocate(Ttop(nmid))
          allocate(tauzmid(nmid))
          allocate(ztop(nmid))
          allocate(zbottom(nmid))
          allocate(zvert(nzUW))
          allocate(tauzvert(nzUW))

          allocate(nUWTz(nzUW,nmid))
          allocate(rhoz(nzUW,nmid))
          allocate(Temz(nzUW,nmid))

!$omp parallel do private(iz)
            do iz          = 1,nzUW
               zvert(iz)   = 0
               tauzvert(iz)= 0
            end do
!omp end parallel do

!$omp parallel do private(i)
           do   i            = 1, nmid
            isotr(i)         = 0
            ibotr(i)         = 0
            itopr(i)         = 0
            Rmid(i)          = 0d0
            Tmid(i)          = 0d0
            Ttop(i)          = 0d0
            tauzmid(i)       = 0d0
            ztop(i)          = 0d0
            zbottom(i)       = 0d0
!$omp parallel do private(ii)
            do ii            = 1,nzUW
               nUWTz(ii,i)   = 0
               rhoz(ii,i)    = 0
               Temz(ii,i)    = 0d0
            end do
!omp end parallel do
            end do
!omp end parallel do


! a) Setzen eines genuegend Grossen vertikales  Gitter :
           iz      = 0
           do   k  = 1, nz
            dl     = dGW / nUWzmax
            do  kk = 1, nUWzmax
                   iz     = iz + 1
             zvert(iz)    = z(k) + (kk - 5d-1) * dl - zorg
!            write(6,'(i4,1p1e10.2)') iz, zvert(iz)
           end do
          end do

! b) Setzen des radialen Gitters entlang x:
 write(6,*) '   b) setzen des radialen Gitters entlang '
 write(6,*) '         x =       Rmid: '
         nmid     = 0
         j        = 1
         do  i    = 1, nx
             ntz  = 1
             do k = 1, nz
              ntz = max(netz(i,j,k),ntz)
             enddo
           dl     = dGW / ntz
           do  ii = 1, ntz
            xx    = x(i) + (ii - 0.5) * dl - xorg
            if(xx .ge.rinner .and. xx .le.router)  then
               nmid        = nmid + 1
               Rmid(nmid)  = xx 
           endif
           enddo
          enddo

         call nlocat(rmid, nmid, au, i1au)
         write(6,'(a25,1p2e10.2)') ' rinner, rmid(1)    : ', rinner, rmid(1)
         write(6,'(a25,1p2e10.2)') ' router, rmid(nmid) : ', router, rmid(nmid)
         write(6,'(a25,1p1e10.2)') ' rmid(1AU)          = ', rmid(i1au)

! --------------------------------------------------------
! Berechnung der Dichte im vorgegebenen 2D Gitter :
!

        do i = 1, nmid
         rr = rmid(i)
         if(rr .ge. rinner .and. rr .le. router) then
         if(rr.lt.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamin
         if(rr.ge.rsmax) tauV_mid = tauVrsmax *  (rr/rsmax)**gamout

!          get midplane temperature
          if(ileseTmid .eq. 0) then
           temp_mid = tstar * (fakcon * rstar**4 * (aheight/14d0)**2 / &
&                                     dmax1(rr,rinner)**3.)**(1./7.)
          else
           im     = 0
           call nlocat(xmid0, nmid0, rr, im)
           if(im.gt.1 .and.im.lt.nmid0) then
             temp_mid =(Tmid0(im)-Tmid0(im-1))/(xmid0(im)-xmid0(im-1))* &
&                                    (rr-xmid0(im-1)) + Tmid0(im-1)
           else
               temp_mid = Tmid0(im)
           end if
         endif

         Hscal   = sqrt(boltz*temp_mid*rr**3 / (grav*Mstar*protmu))
         Height  = aheight * Hscal
         surf    = tauV_mid /Cext_v

         do k    = 1, nzUW
           zz    = zvert(k)        
           if((abs(zz)/Height-1.) .le. 1.e-2) then
             Temz(k,i)  = temp_mid
             rhoz(k,i) = surf/Hscal*sqrt(2.d0/pi) * &
&                        exp(-(zz**2.)/2.d0/Hscal**2.)
             if(rhoz(k,i) .lt.rhomin) rhoz(k,i) = 0.

           end if
if(ibug.ge.3.and.k.eq.3 .and. i.eq.2) then
! write(6,'(2i4,1p4e10.3)') k, i, rr, zz
! write(6,'(a4,1p5e10.3)') 's= ', surf, Hscal, tauV_mid, temp_mid, (abs(zz)/Height-1.) 
print*, rhoz(k,i), surf/Hscal*sqrt(2.d0/pi) * exp(-(zz**2.)/2.d0/Hscal**2.)
endif

         enddo

        endif
        enddo


! --------------------------------------------------------
! Cloud Mass:
! Setzten  der Dichte im vorgegebenen 3D Gitter :
! zur Kontrolle vergl. mit 2d Gitter
!
        cl_mass  = 0.
        cl_mass1 = 0.
        do i = 1, nx
        do j = 1, ny
        do k = 1, nz
           ntz = netz(i,j,k)
           dl  = dGW / ntz
           do ii = 1, ntz
           do jj = 1, ntz
           do kk = 1, ntz
      lp  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
      dicht(lp) = 0
      inopah(lp) = 0

                xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
                yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
                zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2
                zz     = z(k)  + (kk - 5d-1) * dl-zorg
                rr     = sqrt(xx2 + yy2) 
                rrr = sqrt(xx2 + yy2 + zz2)
! start       -> rinner < rmid < router
       if(rr.ge.rinner.and.rr.le.router) then
                call  locat(rmid,  nmid, rr, l) !nlocat geht daneben !
                if(l.lt.1)    l = 1
                if(l.gt.nmid) l = nmid
                call nlocat(zvert, nzUW, zz, iz)

!           setzen Anzahl der UW in x,y Ebene 
            nUWTz(iz,l)  =  nUWTz(iz,l) + 1

! Dichte from 2d Gitter stored in 3D grid
            fak  = rhoz(iz,l)

            if(l.gt.1 .and.l.lt.nmid) then
               if(rr .lt. rmid(l) .and.rhoz(iz,l-1).gt.0) then
                x1 = rmid(l-1)
                x2 = rmid(l)
                y1 = rhoz(iz,l-1)
                y2 = rhoz(iz,l)
                fak = (y1-y2)/(x1-x2) * (rr-x1) + y1
               endif
               if(rr .gt. rmid(l) .and.rhoz(iz,l+1).gt.0) then
                x1 = rmid(l)
                x2 = rmid(l+1)
                y1 = rhoz(iz,l)
                y2 = rhoz(iz,l+1)
                fak = (y1-y2)/(x1-x2) * (rr-x1) + y1
               endif
            endif

! Dichte nur der Scheibe 
             dicht(lp) = fak 

               if (isnan(dicht(lp))) then 
                  write(6,'(2i4,1p7e10.2)') l,iz, x1, x2, y1, y2, rr, rmid(l), dicht(lp)
                  write(6,*)  ' ******** Check NaN ******* '
               end if

if(ibug.gt.2) then
if(abs(rr/rmid(l) -1.) .ge. 1e-3) write(6,'(a4,1p3e11.3)') 'r=', rr, rmid(l), rr/rmid(l)
if(abs(zz/zvert(iz) -1.) .ge. 1e-3) write(6,'(a4,1p3e11.3)') 'z=',zz, zvert(iz), zz/zvert(iz)
               if(rr .lt. rmid(l)) then
 write(6,'(a4,1p4e11.3)') 'r-', rmid(l-1), rmid(l), rmid(l+1), rr
               else
 write(6,'(a4,1p4e11.3)') 'r+', rmid(l-1), rmid(l), rmid(l+1), rr
               end if
! write(6,'(a4,1p5e10.3)') 's= ', surf, Hscal, tauV_mid, temp_mid, (abs(zz)/Height-1.) 
 write(6,'(a5, 1p3e10.2)') 'x=', x1,x2, rr
 write(6,'(a5, 1p3e10.2)') 'y=', y1,y2, dicht(lp)
endif

if(rr.lt.rinner.and.zz.lt.rinner) write(6,'(7i4,1p5e9.2)') &
&iz,l, i,j,k,ntz, nUWTz(iz,l), rr, rmid(l),zvert(iz), zz, dicht(lp)

       endif
!      end        -> rinner < r < router
! -----------------------------------------
! Dichte der Scheibe: nun + Staubhuelle:
! 
       if(rrr .ge. rinner .and. rrr .le. router) then
             dicht(lp) = dicht(lp) +  rhomin
       end if

               cl_mass  = cl_mass  + cc3 * dicht(lp)  * (dGW/ntz)**3

           end do
           end do
           end do
        end do
        end do 
        end do

       cl_mass1 = cl_mass

print*, '  ** 3D Dichte gesetzt '


! --------------------------------------------------------
! Summe der Dichte
!
        fak = 0
        do i        = 1, nmid -1
        do iz       = 1, nzUW -1
         fak = fak + rhoz(iz,i) *(zvert(iz+1)-zvert(iz))*(rmid(i+1)-rmid(i))
            if(isnan(rhoz(iz,i))) then
             write(6, '(2i5,1p2e12.4,1x,2e12.3, i6, a10)')    i, iz, rmid(i), & 
&             zvert(iz), rhoz(iz,i), Temz(iz,i), nuWTz(iz,i), ' NaN'
           endif
        end do
        end do
        write(6,'(a20,1p1e10.3)')  ' Sum(rhoz)          = ', fak

!
! ----------------------------------------------------------
! Ausschreiben des 2 dim grids:
!
!       if(ibug .ge.2) then
         open(unit=26, file='output/L.2Dgrid', form='formatted')
         rewind(26)
         write(26,*) '#  i   iz rmid      z          rhoz     Temz     tauz     dtauz     nUWTz  '
         do i   = 1, nmid
          dtauz  = 0
           tauz0 = 0
          do iz  = nzUW-1, 1, -1
          dl           = zvert(iz+1)-zvert(iz)
          dtauz        = Cext_V *dl*rhoz(iz,i)
          tauz0        = tauz0 + dtauz
            if(rhoz(iz,i).gt.0) then
             write(26, '(2i5,1p2e10.3,1x,4e9.2, i6)') & 
&                 i, iz, rmid(i), zvert(iz),  rhoz(iz,i), Temz(iz,i), &
&                  tauz0, dtauz, nUWTz(iz,i)
            end if
          end do
          end do
!        end if
! ----------------------------------------------------------
! Ausschreiben: Hoehe der Extinktionsschicht ztop, zbottom
         open(unit=26, file='output/L.ztop_0', form='formatted')
         rewind(26)
         write(26,*) '#  i    iso  ibot  #ext  rmid    tauzmid   ziso   zbottom   ztop      tautop  nUWTz'

      surfr       = 0
      do  i      = 1, nmid-1
       if(rhoz(1,i).eq.0) print*, i, rhoz(1,i)  *(rmid(i+1)-rmid(i))
        surfr     = surfr    + rhoz(1,i)  *(rmid(i+1)-rmid(i))
      end do
      tauV_mid  = surfr*Cext_V
      write( 6,'(a30,1p1e10.2)') '    midplane Tau(2D)    = ', tauV_mid

! tau bei jeden radius in vertikaler Richtung:
write(6,*) ' am innen rand: '
write(6,*) ' iz nuW   R       zvert   rhoz     tauzvert   dtauz'
      do  i            = 1, nmid
        tauz0          = 0.
       dtauz           = 0.
       itop            = 1
       do iz           = nzUW-1, 1, -1
          dl           = zvert(iz+1)-zvert(iz)
          dtauz        = Cext_V *dl*rhoz(iz,i)
          tauz0        = tauz0 + dtauz
          tauzvert(iz) = tauz0
          if(tauz0 .gt.0.02 .and.itop.eq.1) itop = iz
if(i.eq.1 .and. rhoz(iz,i).gt.0) write(6,'(2i4,1p5e9.2)') iz,nuWTZ(iz,i),&
&                rmid(i), zvert(iz), rhoz(iz,i), tauzvert(iz), dtauz
       end do

! tauzmid: total tau(z) bei allen Rmid 
          tauzmid(i)  = tauzvert(1)

! Top & Bottom der Extinktionsschicht ztop
                 if(itop .lt.1) itop = 1
                 ztop(i)    = zvert(itop)
                 dtauz      = 1.
                 call nlocat(tauzvert, nzUW, dtauz, ibottom)
                 if(ibottom .gt.itop) ibottom = itop
                 iz         = ibottom

            if(iz.gt.1 .and.iz.lt.nzUW) then
              if(tauzvert(iz) .le.1) then 
                zbottom(i) = (zvert(iz-1)-zvert(iz))       / &
&                            (tauzvert(iz-1)-tauzvert(iz)) *&
&                            (dtauz-tauzvert(iz-1))   + zvert(iz-1)

                tauV_mid   = (tauzvert(iz-1)-tauzvert(iz)) / &
&                            (zvert(iz-1)-zvert(iz))       * &
&                            (zbottom(i)-zvert(iz-1)) +  tauzvert(iz-1)

              else

                zbottom(i) = (zvert(iz+1)    - zvert(iz))    / &
&                            (tauzvert(iz+1) - tauzvert(iz)) *&
&                            (dtauz-tauzvert(iz))   + zvert(iz)

                tauV_mid   = (tauzvert(iz+1)- tauzvert(iz))  / &
&                            (zvert(iz+1)   - zvert(iz))     * &
&                            (zbottom(i)    - zvert(iz)) +  tauzvert(iz)

               end if
             else
                 zbottom(i) = zvert(ibottom)
                 tauV_mid   = dtauz
             end if

! isotr: top der isotermen Schicht bei tauz>5 
            dtauz      = 5.
            call nlocat(tauzvert, nzUW, dtauz, isot)
            if(tauzvert(isot) .lt.5.) isot = isot-1
            if(isot .ge.ibottom)      isot = ibottom -1
            if(isot.lt.2)             isot = 2

            itopr(i)  = itop
            ibotr(i)  = ibottom
            isotr(i)  = isot

! test: tau(zbottom) ~ 1. ?
                if(abs(tauV_mid-1.) .ge.0.1) then 
                 if(tauzvert(iz) .ge.1.) then
                  write(6,'(1p6e10.2, a11)') zvert(iz-1), zbottom(i), zvert(iz), &
&                           tauzvert(iz-1), tauV_mid, tauzvert(iz), 'check dtau'
                 else
                  write(6,'(1p6e10.2,a11)') zvert(iz), zbottom(i), zvert(iz+1), &
&                           tauzvert(iz), tauV_mid, tauzvert(iz+1), 'check dtau'
                 endif
               endif
             


write(26,'(4i5,3x,1p6e9.2,i4)') i,  isotr(i), ibotr(i), (itopr(i)-ibotr(i)),  rmid(i), tauzvert(1), &
& zvert(isotr(i)), zbottom(i), ztop(i), tauzvert(itop), nUWTz(itop,i)

if(tauzvert(itop) .gt. tauVmin) write(6,'(3i4,3x,1p5e10.2, a12)') &
& i, iz, (itop-ibottom),  rmid(i), tauzmid(i), &
& zbottom(i),ztop(i), tauzvert(itop), ' check '

if(i.eq.i1au) write(6,'(a40,1p2e10.2)') &
& ' ** Saulendichte [g-DUST/cm^2] bei 1AU  ', rmid(i1au), 2.*tauzmid(i1au)/Cext_V 
      end do
      close(26)


print*, ' ***  space  done ' 

print*, ' ' 
return
end subroutine dicke_scheibeTmid

! --------------------------------------------- 



!
! -----------------------------------------------
!
subroutine clumpyshell(init)
use type_module
use constants
use parameter

implicit none

type(init_type) :: init
type(float_vector),allocatable :: clumps(:)
!integer :: nstar=1,starpos(3),
integer :: ntz
integer :: clump_t(nx,ny,nz)
real*8	:: r,r1,r2,r3,theta,phi,costheta,r_clump,clump_profile,f_fac,duw
integer :: idim=0,iklump,nclump,clump_type,a,b,c,d,e
real*8  :: starcentre(3),rrs,distmod,opening_angle,ratio
real*8	:: xx2,xx,masslim
real*8	:: yy2,yy,rrp1
real*8	:: zz2,zz,rrm1		
real*8	:: dl,dgw2,ran
real*8	:: rr,rr2,dichttemp,totmass,mass_fac
real*8,allocatable :: rrc(:)
integer	:: ii, jj, kk,ntsum,iclump



!----------------------------------------------------------
!- Generates a spherical shell filled with dust. Dust can be 
!- distributed either homogeneously or in clumps. Clumps
!- can take 3 forms: 1) Entire GW filled with dust (blocks)
!- 2) Spherical cloud of constant density and fixed radius
!- 3) Pressure constrained clouds. Cases 1 & 2 have sharp
!- edges while case 3 produces smooth dust. To do: 
!- 1)specify a density ratio for a diffuse dust phase (1&2) 
!- which is interpreted as a minimum density in case 3.
!- 2)add radial density profile of clumps.
!-
!- parameters required: 
!- iexpgw1
!- type of clumps (blocks, spheres, pressure constrained)
!- density of second phase (ratio)
!- filing factor
!- seed
!- nclump
!- star xposition
!- total mass
!---------------------------------------------------------

         print*,' **clumpy shell density distribution'
         print*,' 8 parameter '
         print*,' p(1) clump type: 0=block,1=sphere,2=pressure constrained',input%p(1)
         print*,' p(2) potenz 1/r^p(2) [1] (homogeneous shell only) ',input%p(2)
         print*,' p(3) iexpgw1         [3]   ',input%p(3)
         print*,' p(4) total shell mass      ',input%p(4)
         print*,' p(5) number of clumps      ',input%p(5) !set to -1 for homogeneous case
         print*,' p(6) shell filling factor  ',input%p(6)
         print*,' p(7) shell opening angle   ',input%p(7) !set to -1 for spherical shell
         print*,' p(8) random seed           ',input%p(8)
         if (input%parameter.ne.8) then
           print*,'wrong number of parameter'
           stop
         endif

        !a1r     = input%p(1)
        clump_type = int(input%p(1))
        x1r     = input%p(2)
        iexpgw1 = input%p(3)
        totmass = input%p(4)*Msun
        nclump  = input%p(5)
        f_fac   = input%p(6)
        clump_profile = 0 !input%p(8)
        opening_angle = input%p(7)
        opening_angle = opening_angle * pi / 180d0
        if (opening_angle .gt. 0) opening_angle = cos(opening_angle)
        print*,opening_angle
        idim = int(input%p(8))

        r_clump = pi*4d0*nclump
        r_clump = 1d0/r_clump
        r_clump = r_clump * 3d0 * f_fac * ((4/3)*pi*(router**3 - rinner**3)/cc3)
        r_clump = r_clump**(1d0/3d0)
        write(6, '(a, 1p1e9.2,1x,a)')'Clump radius is ',r_clump,' cm '

!        if (dgw/iexpgw1 .gt. r_clump) stop 'clumps not well resolved, increase iexpgw1'

        allocate(clumps(nclump))
        allocate(rrc(nclump))
        rrc=0d0
        clumps(:)%x = 0d0
        clumps(:)%y=0d0
        clumps(:)%z=0d0
        ! Setting netz to zero

clump_t = 0

do i = 1, nx
do j = 1, ny
do k = 1, nz
   netz(i,j,k) = 1
   xx = (i-0.5)*dgw
   yy = (j-0.5)*dgw
   zz = (k-0.5)*dgw
   rr = sqrt((xx-xorg)**2+(yy-yorg)**2+(zz-zorg)**2)
   rrm1 = sqrt((xx-xorg)**2+(yy-yorg)**2+(zz-dgw-zorg)**2)
   rrp1 = sqrt((xx-xorg)**2+(yy-yorg)**2+(zz+dgw-zorg)**2)
   rr2  = sqrt((xx-xorg)**2+(yy-yorg)**2)

   if (opening_angle .gt. 0 .and. rr .gt. rinner-dgw/2. .and. &
&       ( (rr2/rr .gt. opening_angle.and. rr2/rrm1 .lt. opening_angle).or. &
&       (rr2/rr .lt. opening_angle.and. rr2/rrp1 .gt. opening_angle)))then
      netz(i,j,k) = iexpgw1
   endif
end do
end do
end do
!        print*,'3'


! TOR region
do iklump=1,int(input%p(5))
   call random_num(ran,idim)
   r = ran*(router-rinner) + rinner
   call random_num(ran,idim)
   phi = 2 * pi * ran
   if (idim3 .ne. 1) phi = phi/4.
   call random_num(ran,idim)
   costheta = (-1.+2.*ran) !cos(theta)
   if (opening_angle .gt. 0) costheta = costheta*(1-opening_angle**2)  !limit angle for torus/disc - need sine to produce correct behaviour
   if (idim3 .ne. 1) costheta = abs(costheta)
   xx = xorg+r*sqrt(1.-costheta**2) * cos(phi) 
   yy = yorg+r*sqrt(1.-costheta**2) * sin(phi)
   zz = zorg+r*costheta
   i = int(xx/dgw)+1
   j = int(yy/dgw)+1
   k = int(zz/dgw)+1
   rr = sqrt((xx-xorg)**2 + (yy-yorg)**2)
   r3 = sqrt((xx-xorg)**2 + (yy-yorg)**2 + (zz-zorg)**2)
   clump_t(i,j,k) = clump_t(i,j,k) + 1 !allow for multiple clumps in same place -> higher density
   clumps(iklump)%x = xx
   clumps(iklump)%y = yy
   clumps(iklump)%z = zz
   if( clump_type .gt. 0) then
   do ii = i-1,i+1
      do jj = j-1,j+1
         do kk = k-1,k+1
            if (ii.gt.0 .and.jj.gt. 0 .and.kk.gt. 0 .and.ii.le.nx.and.ny.le.ny.and.kk.le.nz) netz(ii,jj,kk) = iexpgw1/2
         enddo
      enddo
   enddo
   endif
   netz(i,j,k) = iexpgw1
end do

isumuw = 0.
do i = 1, nx
do j = 1, ny
do k = 1, nz
   isumuw        = isumuw + netz(i,j,k)**3
   netsum(i,j,k) = isumuw
end do
end do
end do

!if (ibug>0) 
print *, ' 6. Summe aller Unterwuerfel =', isumuw

call allocspace(isumuw)

dicht = 0d0
cl_mass= 0d0


print*,'i      Number of clumps generated i times or more'
do i=1,11
   print*,i-1,count(clump_t.gt.i-1)
enddo

do i = 1,nx
   do j = 1,ny
      do k = 1,nz
         ntz = netz(i,j,k)
         duw = dgw/ntz
         if (nclump .gt. 0) then
            if (clump_t(i,j,k) .gt. 0) then !clump centred here

               do ii = 1,ntz
                  do jj = 1,ntz
                     do kk = 1,ntz
                        xx = x(i) + (ii-0.5)*duw -xorg
                        yy = y(j) + (jj-0.5)*duw -yorg
                        zz = z(k) + (kk-0.5)*duw -zorg
                        r3 = sqrt(xx**2 + yy**2 + zz**2)
                        rr2 = sqrt(xx**2 + yy**2)
                        rr = ((ii-0.5)*duw - dgw/2.)**2 + ((jj-0.5)*duw - dgw/2.)**2 + ((kk-0.5)*duw - dgw/2.)**2
                        rr = sqrt(rr)
                        lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
                        if (r3 .gt. rinner.and. r3 .lt. router) then 
                           dicht(lp) = clump_t(i,j,k)!1!/(1+((rr*rr/(r_clump*r_clump))))
                           if(clump_type .eq. 1 .and. rr .gt. r_clump) then 
                              dicht(lp) = 0d0
                           elseif(clump_type .eq.2) then !pressure constrained formula needed
                              dicht(lp) = clump_t(i,j,k)/(1+((rr*rr/(r_clump*r_clump))))
                           endif
!                           if (dicht(lp) .lt. ratio) dicht(lp) = ratio !to be completed
                        endif
                        if ((rr2/r3) .lt. opening_angle .and. opening_angle .gt. 0) dicht(lp) = 0d0
                            
                        cl_mass = cl_mass + dicht(lp) * duw**3
                     enddo
                  enddo
               enddo
            elseif (clump_t(i,j,k) .ne. 1) then !clump not centred in cell
               if(clump_type .gt. 0) then !spherical clouds
                  do ii = 1,ntz
                     do jj = 1,ntz
                        do kk = 1,ntz
                           xx = x(i) + (ii-0.5)*duw
                           yy = y(j) + (jj-0.5)*duw
                           zz = z(k) + (kk-0.5)*duw
                           r3 = sqrt(xx**2 + yy**2 + zz**2)
                           rr2 = sqrt(xx**2 + yy**2)
                           do iklump = 1,nclump
                              rrc(iklump) = ((clumps(iklump)%x - xx)**2 + (clumps(iklump)%y - yy)**2 + (clumps(iklump)%z - zz)**2)
                              if (clump_type .eq.2) rrc(iklump) = rrc(iklump)/&
& (dble(clump_t(int((clumps(iklump)%x)/dgw)+1,int((clumps(iklump)%y)/dgw)+1,&
& int((clumps(iklump)%z)/dgw)+1))) 

! have to weight toward more massive clumps to avoid strange behaviour
                           enddo
                           rr = minval(rrc) !find nearest clumps
                           if ( clump_type .eq.2) then
                              e = minloc(rrc,1)
                              b = (int((clumps(e)%x)/dgw)+1)
                              c = (int((clumps(e)%y)/dgw)+1)
                              d = (int((clumps(e)%z)/dgw)+1)
                              a = clump_t( b , c , d ) 
                              rr = rr * (dble(a))
                           endif
                           rr = sqrt(rr)
                           lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
                           if(r3 .gt. rinner .and. r3 .lt. router) then
 if (clump_type .eq.2 .or. rr .lt. r_clump) dicht(lp) = &
&  clump_t(nint((clumps(minloc(rrc,1))%x)/dgw)+1, &
& nint((clumps(minloc(rrc,1))%y)/dgw)+1,nint((clumps(minloc(rrc,1))%z)/dgw)+1)

                           endif
                           if(clump_type .eq. 2) dicht(lp) = dicht(lp)/(1+((rr*rr/(r_clump*r_clump))))
!                           if (dicht(lp) .lt. ratio) dicht(lp) = ratio
                           if ((rr2/r3) .lt. opening_angle .and. opening_angle .gt. 0) dicht(lp) = 0d0
                           cl_mass = cl_mass + dicht(lp) * duw**3
                        enddo
                     enddo
                  enddo
               else !blocky clumps, must be second phase
                  do ii = 1,ntz
                     do jj = 1,ntz
                        do kk = 1,ntz
                           !xx = x(i) + (ii-0.5)*duw
                           !yy = y(j) + (jj-0.5)*duw
                           !zz = z(k) + (kk-0.5)*duw
                           lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
!                           if (dicht(lp) .lt. ratio) dicht(lp) = ratio
                           if ((rr2/r3) .lt. opening_angle .and. opening_angle .gt. 0) dicht(lp) = 0d0
                           cl_mass = cl_mass + dicht(lp) * duw**3
                        enddo
                     enddo
                  enddo
               endif
            endif
         else !homogeneous case
            do ii = 1,ntz
               do jj = 1,ntz
                  do kk = 1,ntz
                     xx = x(i) + (ii-0.5)*duw -xorg
                     yy = y(j) + (jj-0.5)*duw -yorg
                     zz = z(k) + (kk-0.5)*duw -zorg
                     r3 = sqrt(xx**2 + yy**2 + zz**2)
                     rr2 = sqrt(xx**2 + yy**2)
                     lp = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
                     if (r3 .gt. rinner .and. r3 .lt. router) dicht(lp) = 1/(r3**x1r)
                     if((rr2/r3 .lt. opening_angle) .and. (opening_angle .gt. 0)) dicht(lp) = 0d0
                     cl_mass = cl_mass + dicht(lp) * duw**3
                  enddo
               enddo
            enddo
         endif
      enddo
   enddo
enddo


!renormalise total mass to input value.
mass_fac = totmass/cl_mass
dicht = dicht*mass_fac
cl_mass = cl_mass * mass_fac


deallocate(clumps)
deallocate(rrc)

end subroutine clumpyshell

!
! ---------------------------------------------
!

subroutine random_num(ran,idim)
implicit none
        integer,intent(inout) :: idim
        real*8,intent(inout) :: ran
        idim = 1664525 * idim + 1013904223
        if (idim .ge.0) ran = idim / (2.**32-1)
        if (idim .lt.0) ran = (2.**32+idim) / (2.**32-1)
end subroutine random_num


!
! ---------------------------------------------
!

subroutine set_dichte
use parameter
use constants
implicit none
        real*8  :: rand         ! neccessary for ifort
	real*8	:: xx, yy, zz
	real*8	:: xx2, yy2, zz2
	real*8	:: cl_mref
	real*8	:: theta, theta0, costhet
	real*8	:: dl
	real*8	:: rr
	real*8	:: dicht0
	real*8	:: dTauV
	real*8 	:: fak
	real*8	:: tauV
	real*8	:: volfrac	
	real*8	:: nws(6), lws(6)
	real*8	:: f1, f2, rd, zd,  hr
	real*8	:: height, OmegaK, sigH, tags
	integer	:: lpp
	integer	:: ic
	integer	:: ia, is, ie, i1, ii, ii1, iii
	integer	:: ja, js, je, j1, jj, jj1
	integer	:: ka, ks, ke, k1, kk, kk1
	integer	:: mi, mj, mk
	integer	:: lw
	integer	:: ntz
! ----


      print*, " **set_dichte:  not working yet !! "
      print*, "   set a1r,x1r, etc. "
      stop

      lws     = [ 1, 3, 5, 7, 9, 11 ]
      cl_mass = 0.
	IF (old_random .eq. 1) THEN
		PRINT*,'using old random numbers from file input/random.old'
		open(unit=117,file='input/random.old',form='formatted')	
		rewind 117
	ELSE 
	      	zufall  = rand(1)
	END IF

!   Dichteverteilung ohne Klumpung zur Ermittlung der Referenzmasse cl_mref
      do   i = 1, nx
      do   j = 1, ny
      do   k = 1, nz

      ntz = netz(i,j,k)
      dl  = dGW / ntz
      
      do  ii = 1, ntz
      do  jj = 1, ntz
      do  kk = 1, ntz

      lp     = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
      
      xx2    = (x(i) + (ii - 5d-1) * dl-xorg)**2
      yy2    = (y(j) + (jj - 5d-1) * dl-yorg)**2
      zz2    = (z(k) + (kk - 5d-1) * dl-zorg)**2

      rr     = sqrt(xx2 + yy2 + zz2)

      if(rr .lt. rinner .or. (rr .gt. router .and. kugelsym .eq. 1))   go to 10

! fuer Kugel:
       dicht(lp) = a1r / rr**x1r

! fuer Scheibe:
!      if (rr .gt. rinner .or. (rr .lt. router .and. kugelsym .eq. 1)) then
!              rd = (nx*dgw/2.)
!              zd = (nx*dgw/8.)
!              f1 = 1 / (rr/rd)
!              hr = zd * (rr/rd)**1.125
!              f2 = exp(-pi/4*(sqrt(zz2)/hr)**2.)
!            dicht(lp) = a1r  * f1 * f2
!       endif
      cl_mass = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
!      print*,' rinner, router, rr, dicht(lp), cl_mass, lp'
!      write(6,'(1p5e10.2,i5)') rinner, router, rr, dicht(lp), cl_mass, lp
 10   continue

      end do
      end do
      end do
      end do
      end do
      end do

!   ---------------------------------------------------------------------------
!   Dichteverteilung mit Klumpung.  Bislang nur für 1. GW
!   Klumpen sind kubisch, haben Seitenlänge lw * dl
!   Gesamtmasse und mittleres tau sollen möglichst erhalten werden.
!   nklump = Zahl der Klumpen.  Außerhalb der Klumpen ist rho = 0
!   Klumpen werden seriell mit Zufallsgenerator erzeugt.

      if(nx*ny*nz .gt. 1 .or. klump .eq. 0)   go to 12

!  Die Dichte wird erneut überall zu Null gesetzt

      cl_mref = cl_mass
      cl_mass = 0.
      dicht0  = 1d-40

      do  i = 1, isumuw
      dicht(i)    = 0.
      end do

!   nklump UW als Mittelpunkte von Klumpen ausgewählt

      do  is = 1, 6
      nws(is) = 0
      end do

      i   = 1
      j   = 1
      k   = 1
      ntz = netz(i,j,k)
      dl  = dGW / ntz

      do  30  iii = 1, nklump


	IF (old_random .eq. 1) THEN
		read(117,*)	zufall
		ii  = ntz * zufall + 1
		read(117,*)	zufall
		jj  = ntz * zufall + 1
		read(117,*)	zufall
		kk  = ntz * zufall + 1
	ELSE 
  	    	ii  = ntz * rand(0) + 1
  	    	jj  = ntz * rand(0) + 1
   	    	kk  = ntz * rand(0) + 1
	END IF
      if(ii .gt. ntz .or. jj .gt. ntz .or. kk .gt. ntz)   stop 'ii > ntz'

      lp  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
      lpp = lp

      xx2 = (x(i) + (ii - 5d-1) * dl)**2
      yy2 = (y(j) + (jj - 5d-1) * dl)**2
      zz2 = (z(k) + (kk - 5d-1) * dl)**2
      rr  = sqrt(xx2 + yy2 + zz2)

!   Keine geklumpte Materie für r < rinner  oder  r > router  bei Kugelsymmetrie

      if(rr .lt. rinner .or. (rr .gt. router .and. kugelsym .eq. 1))   go to 30

!   Dichte im Mittelpunkt des Klumpens

      if(kugelsym .eq. 1)   then
        dicht(lp) = a1r / rr**x1r
           else
        costhet   = (z(k) + (kk - 0.5) * dl) / rr
        theta     = acos(costhet)
        dicht(lp) = a1r / rr**x1r * exp(-(pi/2d0-theta) / theta0)
      end if

!   Seitenlänge lw des Klumpen in Abhängigkeit seines Abstands vom Ursprung

      lw = 2 * int(3.1d0 * rr / dGW) + 1
      lw = max( 1, lw)
      lw = min(11, lw)

      if(lw.eq.2 .or. lw.eq.4 .or. lw.eq.6 .or. lw.eq.8 .or. lw.eq.10)  stop 7

      do  is = 1, 6
      if(lw .eq. lws(is))  nws(is) = nws(is) + 1
      end do

!   Festlegung der Dichte in allen UW des Klumpens
!   Ist UW Teil mehrerer Klumpen, so hat rho den zum ersten Klumpen gehörigen 
!   Wert, d.h. falls im UW des Klumpen schon rho > 0, wird rho nicht geändert.

      ia = max(ii - lw/2,   1)
      ie = min(ii + lw/2, ntz)
      ja = max(jj - lw/2,   1)
      je = min(jj + lw/2, ntz)
      ka = max(kk - lw/2,   1)
      ke = min(kk + lw/2, ntz)

      do  mi = ia, ie
      do  mj = ja, je
      do  mk = ka, ke
 
      lp   = netsum(i,j,k) - ntz**3 + ntz**2 * (mi - 1) + ntz * (mj - 1) + mk

      if(dicht(lp) .lt. dicht0)   then

      xx2  = (x(i) + (mi - 5d-1) * dl)**2
      yy2  = (y(j) + (mj - 5d-1) * dl)**2
      zz2  = (z(k) + (mk - 5d-1) * dl)**2
      rr   = sqrt(xx2 + yy2 + zz2)

         if(kugelsym .eq. 1)   then

!   Dichte in Unterwürfeln des Klumpens gemäß Dichteprofil
           dicht(lp) = a1r / rr**x1r
!   Dichte in allen UW des Klumpens gleich der im Klumpenmittelpunkt
!           dicht(lp) = dicht(lpp)
           if(rr .gt. router)   dicht(lp) = 0.

              else

!   Dichte wird in UW des Klumpens gemäß Dichteprofil
!           costhet   = (z(k) + (kk - 0.5) * dl) / rr
!           theta     = acos(costhet)
!           dicht(lp) = a1r / rr**x1r * exp(-(pi/2d0-theta) / theta0)
!   Dichte wird in allen UW des Klumpens gleich der im Klumpen-MP gesetzt
           dicht(lp) = dicht(lpp)
         end if

      cl_mass   = cl_mass + cc3 * dicht(lp) * (dGW/ntz)**3
      end if

      end do
      end do
      end do

 30   continue

      print 243, cl_mass, cl_mref
 243  format(' cl_mass=', 1pe11.3, ' cl_ref_mass=', e11.3)

      fak     = cl_mref / cl_mass
      ic      = 0
      cl_mass = 0.

      do  i = 1, isumuw
      dicht(i) = dicht(i) * fak
      if(dicht(i) .gt. dicht0)   ic = ic + 1
      cl_mass  = cl_mass + cc3 * dicht(i) * (dGW/ntz)**3
      end do

!   Volumenanteil des mit Materie angefuellten Raumes.  Zum Raum gehoert auch der 
!   Teil, der von vornherein zu Null gesetzt ist (z.B. bei kugelsym=1 fuer
!   r > router oder fuer r < rinner).

      volfrac = real(ic) / real(netz(1,1,1)**3)
      print 241, cl_mass, cl_mref, volfrac, (nws(is), is=1,6)
 241  format('   Masse=', 1pe11.3, ' RefMasse=', e14.3, '  volfrac=', f7.4 /&
     & '   Klumpen: l1=',i5, '  l3=',i5, '  l5=',i5, '  l7=',i5, ' l9=',i5, &
     & ' l 11=',i5)
      stop 4

 12   continue
!   ---------------------------------------------------------------------------

      print 139, cl_mass/2d33, rinner
 139  format('  7. Wolkenmasse [M_o] =', 1pe10.2, '  rinner =', e10.2)

!  ---------------------------------------------------------------------------
!  ***  Ausdruck der Wolkenstruktur laengs x-Achse  ***

      tauV = 0.
      j1   = ny/2+1
      k1   = nz/2+1

      do  i = 1, nx
      jj1  = 1
      if (idim3.eq.1) jj1=netz(i,j1,k1)/2
      kk1  = 1
      if (idim3.eq.1) kk1=netz(i,j1,k1)/2

      do  ii = 1, netz(i,j1,k1)

      xx = x(i) + (ii-1) * dGW / netz(i,j1,k1)
      lp = netsum(i,j1,k1) -  netz(i,j1,k1)**3 + netz(i,j1,k1)**2 * (ii - 1) + &
     &     netz(i,j1,k1) * (jj1 - 1) + kk1
      dtauV   = Cext_V * dicht(lp) * dGW / netz(i,j1,k1)

      if(ibug .ge. 1)   print 138, i,ii, xx, dicht(lp), tauV, dtauV, netz(i,j1,k1)
      tauV  = tauV + dtauV
 138  format(2i4, 1pe11.3, 3e11.2, 1x, i8)
      end do
      end do
      xx = nx * dGW
      print*, ' i        xx                 tauvx'
      print 136, i, xx, tauV
 136  format(i4, 1pe15.3, 11x, f8.3)

!  ***  Ausdruck der Wolkenstruktur laengs z-Achse  ***


      tauV = 0.
      i1   = nx/2+1
      j1   = ny/2+1

      do  k = 1, nz
      ii1  = 1
      if (idim3.eq.1) ii1=netz(i1,j1,k)/2
      jj1  = 1
      if (idim3.eq.1) jj1=netz(i1,j1,k)/2

      do  kk = 1, netz(i1,j1,k)

      zz = z(k) + (kk-1) * dGW / netz(i1,j1,k)
      lp = netsum(i1,j1,k) - netz(i1,j1,k)**3 + netz(i1,j1,k)**2 * (ii1 - 1) + &
     &     netz(i1,j1,k) * (jj1 - 1) + kk
      dtauV   = Cext_V * dicht(lp) * dGW / netz(i1,j1,k)

      if(ibug .ge. 1)   print 138, k,kk, zz, dicht(lp), tauV, dtauv, netz(i1,j1,k)
      tauV  = tauV + dtauV
      end do
      end do
      zz = nz * dGW
      print 136, k, zz, tauV

!      pause 'Stimmen Wellenlaengen und Raumgitter?'

!   ---------------------------------------------------------------------------
!   Test der Dichteverteilung

! 11   continue

!      print *, 'i,  j,  k  ='
!      read *, i, j, k
!      print *, 'ii, jj, kk ='
!      read *, ii, jj, kk

!      xx2    = (x(i) + (ii - 5d-1) * dl)**2
!      yy2    = (y(j) + (jj - 5d-1) * dl)**2
!      zz2    = (z(k) + (kk - 5d-1) * dl)**2
!      rr     = sqrt(xx2 + yy2 + zz2)

!      ntz = netz(i,j,k)
!      dl  = dGW / ntz
!      lp  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk

!           zzz = sqrt(zz2)/dGW - 1d0/256d0
!           if(zzz .le. afak * (sqrt(xx2 + yy2)/dGW)**expfak)   then
!           print *, ' In der Scheibe'
!               else
!           print *, ' Oberhalb der Scheibe'
!           end if

!      print 280, i, j, k, ii, jj, kk, lp, dicht(lp)
! 280  format('i,j,k=', 3i3, '  ii,jj,kk =', 3i3, i9, '  rho=', 1pe9.2) 
!      if(i .ge. 1)   go to 11
	close(unit=117)
      return
end subroutine set_dichte
!
! ------------------------------------------
!
subroutine  pahXdestruct(init)

! Computes for given each UW if PAH are destroyed by X-rays or not
! Method: Eq. 23 in AA 511, A6 (2010)
! Output: UW where PAH are destroyed inopah()=1 sowie in z auch 
!         naechst unteren UW.
! -------------------------------------------------------------
use parameter
use constants
use type_module
use omp_lib
        implicit none
        integer              :: ntz, lpe, isonopah
        integer              :: ii, jj, kk, ij, i1, kmrn, l, iz
        type(init_type)      :: init
        type(float_vector)   :: e,a,d
        real*8               :: Ephot, tau, Kext, ds, getau_adlp
        real*8               :: dl, xx,yy,zz,rr,abs_xy
        real*8               :: LumX, flux, tabs, kappa, ell, hscal, cs, vcr, vturb
        real*8               :: rmaxpah, tau_search
! -----------------------------------------------------------------
!
      rmaxpah         = router
      LumX            = input%p(4) 

      tau             = 0d0
      iUWnopah        = 0
      isonopah        = 0
      iXnopah         = 0

       call locat(welmrn, mm, 1.d-7, kmrn)
       ephot  = hwirk * frmrn(kmrn)     ! Energie des einen Photonpackets.
       Kext   = K_abs_ac(kmrn)+K_abs_si(kmrn)
!&             +K_sca_ac(kmrn)+K_sca_si(kmrn)  +K_abs_pah(kmrn)

       Kappa = K_abs_pah(kmrn) /zcpah/(pahmass/(wmolc*zcpah*protm)) ! tab.2 in AA2010

       write(6,*) ' *** PAH vernachlaesigt bei: '
       write(6,'(a40,1p2e10.2)') ' r<1.05*rinner + r>rmaxpah = ', 1.05*rinner, rmaxpah
       write(6,*) ' Compute PAH destruction by X-rays'
       write(6,*) ' Energy (eV) wel    Kext   Kappa'
       write(6,'(1p4e10.2)') ephot/eVolt, welmrn(kmrn), Kext, Kappa


! Berechne tau fuer alle Wuerfel:
! Endpkt.: aus schleife ueber alle .. wie xx,yy,zz,lp:
!$OMP parallel &
!$OMP& private(i,j,k,ntz,dl,ii,jj,kk,l,iz) &
!$OMP& private(lpe,xx,yy,zz,rr,abs_xy,ij,hscal,cs,a,e,d,tau,flux,tabs,ell,vturb,vcr) &
!$OMP& reduction(+:iUWnopah) &
!$OMP& reduction(+:isonopah) &
!$OMP& reduction(+:iXnopah)
         do i = 1, nx
         if (omp_get_thread_num() .eq. 0) write (*,'(a)',advance='no') '.' !print*,' status:',i,'/',nx
         do j = 1, ny                                           
         do k = 1, nz                                           
            ntz = netz(i,j,k)                                   
            dl  = dGW / ntz 
!$OMP do                                    
            do ii = 1, ntz                                      
            do jj = 1, ntz                                      
            do kk = 1, ntz                                      
         lpe  = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk
!         if(kk .gt.1) lpunten = netsum(i,j,k) - ntz**3 + ntz**2 * (ii - 1) + ntz * (jj - 1) + kk-1
             xx    = x(i) + (ii - 5d-1) * dl-xorg                     
             yy    = y(j) + (jj - 5d-1) * dl-yorg                      
             zz    = z(k) + (kk - 5d-1) * dl-zorg                      

!nehme Kante vom UW welche in x,y am naechsten zum Stern und im UW am hoechsten liegt
!             xx    = x(i) + (ii - 0.9999) * dl-xorg                     
!             yy    = y(j) + (jj - 0.9999) * dl-yorg                      
!             zz    = z(k) + (kk - 0.0001) * dl-zorg                      

!nehme mitte vom UW
             xx    = x(i) + (ii - 0.4999) * dl-xorg                     
             yy    = y(j) + (jj - 0.4999) * dl-yorg                      
             zz    = z(k) + (kk - 0.4999) * dl-zorg                      

             rr     = min(dsqrt(xx**2 + yy**2 + zz**2), router)
             abs_xy = dsqrt(xx**2+ yy**2)                                     

! no pah bei r> rmaxpah
         inopah(lpe)     = 0
         if(rr.lt.rinner*1.05)   inopah(lpe)     = 1

         if(abs_xy.ge.rinner.and.abs_xy.le.router.and.inopah(lpe).eq.0) then

! get Skalenhoehe und csound:    
             ij     = 0
             call nlocat(x, nx, abs_xy, ij)
             if(ij.gt.nx) ij = nx
             if(ij.gt.1) then
              hscal = (hscale(ij)-hscale(ij-1))/(x(ij)-x(ij-1))*(abs_xy-x(ij-1)) + hscale(ij-1)
              cs    = (csound(ij)-csound(ij-1))/(x(ij)-x(ij-1))*(abs_xy-x(ij-1)) + csound(ij-1)
             else
               hscal = hscale(ij)
               cs    = csound(ij)
             end if
                                                                               
! Anfangspkt = Stern, Endpunkt, Richtung:
             a%x    = xorg
             a%y    = yorg
             a%z    = zorg
             e%x    = xx
             e%y    = yy
             e%z    = zz
          ds = dsqrt((a%x-e%x)*(a%x-e%x)+(a%y-e%y)*(a%y-e%y)+(a%z-e%z)*(a%z-e%z))
             d%x    = (e%x-a%x)/ds
             d%y    = (e%y-a%y)/ds
             d%z    = (e%z-a%z)/ds

! no pah in isothermal disk (tau > 5)
!                call  locat(rmid,  nmid, abs_xy, l) !nlocat geht daneben !
!                if(l.lt.1)    l = 1
!                if(l.gt.nmid) l = nmid
!                call nlocat(zvert, nzUW, zz, iz)
!                if(zz.le.zvert(isotr(l)))   then
!                   inopah(lpe)  = 1
!                   isonopah     = isonopah + 1
!                endif
! vturb:    
             ell    = Hscal/2.d0
!             ell    = ztop(l) - zbottom(l)
             vturb  = sqrt(alpha) * cs

! PAH destruction vcr > vturb
!             tau    = 2.
!             flux   = Lquelle*LumX* exp(-tau) /pi4/rr**2 
!             tabs   = 1.d0/(zcpah*Kappa*flux/ephot)
!             tabs   = min(tabs, 1.d30)
!             tabs   = max(tabs, 1.d-30)
!             vcr    = ell/tabs 
!             if(vcr .ge. vturb)  then
!                inopah(lpe)     = 1
!                iXnopah         = iXnopah + 1
!             endif

!falls PAH noch ueberleben compute tau from Star to Wuerfel: getau_adlp() takes long!
             if(inopah(lpe).eq.0) then 
              tau_search = 2./Hscal*sqrt(alpha)*cs*ephot*pi4*rr**2.
              tau_search = tau_search / (Kappa*LQuelle*LumX*zcpah)
              tau_search = -dlog(tau_search) * 1.5
              tau    = getau_adlp(init,a,d, e, lpe, Kext ,tau_search)
! factor 2 to correct for monoenergetic spectrum assuming range form 50eV=2keV
              flux   = Lquelle*LumX* exp(-tau) /pi4/rr**2 
              tabs   = 1.d0/(zcpah*Kappa*flux/ephot)
              tabs   = min(tabs, 1.d40)
              tabs   = max(tabs, 1.d-40)
              vcr    = ell/tabs
             if(vcr .ge. vturb)  then
                inopah(lpe)     = 1
                iXnopah         = iXnopah + 1
             endif

             endif
          endif           ! von if rinner<rr<router

          if(inopah(lpe).eq.1) iUWnopah  = iUWnopah + 1

          enddo
          enddo
          enddo
!$OMP end do
         enddo
         enddo
         enddo
!$omp end parallel  
           print*, ' '
           print*,'   Number of UW              : ',isumUW
           print*,'   Number of UW with inopah  : ',iUWnopah
           print*,'   Number of UW with isonopah: ',isonopah
           print*,'   Number of UW with iXnopah : ',iXnopah

end subroutine  pahXdestruct

function getau_adlp(init,a,d, ee, lpe, Kext, tau_search)

! Computes tau  at frequency Kmrn bezgl. MRN-Gitter vom Staub 
! from anfangspunkt a in direction d to endpoint given by lpe.
! Input: init, a,d,lpe, kmrn
! Output: tau
! -------------------------------------------------------------
use parameter
use constants
use type_module
use omp_lib
        implicit none
        type(init_type)       :: init
        type(float_vector)    :: a, d, e, ee
        type(int_vector)      :: iGW, s
        real*8                :: ds, Kext, taus, tau
        real*8                :: ephot, getau_adlp
        real*8                :: tau_search
        integer               :: lp_local, lpe
        integer               :: get_UW

! -------------------------------------------------------------
!
! Anfangspkt = Stern:

        lp_local = 0
        tau  = 0d0
        
        if(ibug.ge.3) then
         print*,' Anfangspunkt    : ', a%x,a%y,a%z
         print*,' Anfangspunkt    : ', ee%x,ee%y,ee%z
         print*,' Endpunkt lp : ', lpe
         print*,' Richtung    : ', d%x,d%y,d%z
        endif
 
	call check_near_border_GW(a,iGW,s,init)


!       vom Stern durch alle Wuerfel bis 'ade du schoene wolke
	do while (lp_local.ne.lpe .and. a%x.le.ee%x .and. a%y.le.ee%y .and. a%z.le.ee%z.and.tau.le.tau_search)

         if (init%idim3.ne.1) call mirror(a,d,init)

! get new Endpkt e: wo packet i-ten UW verlaest
! berechne nochmal aus (a,e) neu in welchem GW (=iGW) man sich
! befindet, dies notwedig wegen Kannten  und Ecken
      		call check_near_border_GW(a,iGW,s,init)
		call get_EP(a,e,d,iGW,s,init)

if(ibug.ge. 3) then
 print*, 's', s
 print*, 'a', a
 print*, 'e', e
 print*, 'ee', ee
 print*, 'd', d
 print*,' nxyz: ', iGW%x,iGW%y,IGW%z
 print*, 'lp: ',  lp_local, lpe
endif
         if(lp_local .eq.lpe) stop

		ds = dsqrt((a%x-e%x)*(a%x-e%x)+(a%y-e%y)*(a%y-e%y)+(a%z-e%z)*(a%z-e%z))
		iGW%x = (a%x + e%x)/2.0/init%dgw+1
		iGW%y = (a%y + e%y)/2.0/init%dgw+1
		iGW%z = (a%z + e%z)/2.0/init%dgw+1

! stelle sicher dass der GW  noch innerhalb des Models ist

		if (iGW%x<=init%nx.and.iGW%y<=init%ny.and.iGW%z<=init%nz.and.&
                    iGW%x>=1.and.iGW%y>=1.and.iGW%z>=1) then 
   		   lp_local = get_UW(a,e,init)
		   taus     = ds*dicht(lp_local)*Kext
                   tau      = tau + taus
! nehme neuen wurfel als Anfangspunkt zum naechsten UW
   	           a = e

                end if

	end do

        getau_adlp = tau
end function  getau_adlp

