subroutine space_2phase_torus_disk(init)
use parameter
use constants
use type_module

implicit none 
type(init_type)         :: init
real*8                  :: xx,yy,zz,rr,rrr,dl
real*8                  :: theta,phi,rRan,ran,costheta
real*8                  :: density2Phase,densityCloud,densityDisk,densityXrayCloud
real*8                  :: rinnerEnvelope,torOpeningAngle,profile2phase,clumpProfile
real*8                  :: tmpDicht,rd,zd,f1,hr,f2
integer                 :: ii,jj,kk,iii,jjj,kkk,ntz,idim,iy,ix,iz
integer                 :: torNClouds,icloud,nXrayClouds,iXrayClouds,iTORclouds,iSizeCloud
integer                 :: nGW1uw   = 300  ! 300
integer                 :: nGW10uw  = 10
integer                 :: nGWTORuw = 5
real*8                  :: clMassClouds,clMassDisk,clMass2Phase,clMassXrayClouds

idim = 0

clMassClouds = 0.
clMassDisk   = 0.
clMass2Phase = 0.

!   Dichteverteilung mit Klumpung. 
rinnerEnvelope   = rinner 
print*,"RinnerEnvelope = Rinner"
densityCloud     = input%p(1)
torNClouds       = input%p(2)
density2Phase    = input%p(3)
profile2Phase    = input%p(4)
densityDisk      = input%p(5)
iSizeCloud       = input%p(6)
nXrayClouds      = input%p(7)
densityXrayCloud = input%p(8)
clumpProfile     = input%p(9)
!torOpeningAngle  = input%p(11)

print*,' **clumpy torus density distribution'
print*,' 9 parameter:'
print'(A,1pe11.2)'  ,'   Rinner [cm]                            ',rinner 
print'(A,1pe11.2)'  ,'   Router [cm]                            ',router
print'(A,1pe11.2)'  ,'   p(1) -- Density Cloud                  ',densityCloud
print'(A,1pe11.2)'  ,'   p(2) -- Number clouds                  ',real(torNClouds)
print'(A,1pe11.2)'  ,'   p(3) -- Density Envelope               ',density2Phase
print'(A,1pe9.2,A)' ,'   p(4) -- 2phase density profile     r**(',profile2Phase,')'
print'(A,1pe11.2)'  ,'   p(5) -- Density of Disk                ',densityDisk;
print'(A,1pe11.2)'  ,'   p(6) -- iSize cloud: radius +1 [GW]   ',real(iSizecloud);
print'(A,1pe11.2)'  ,'   p(7) -- Number of X-ray Clouds         ',real(nXrayClouds);
print'(A,1pe11.2)'  ,'   p(8) -- Density X-ray Clouds           ',densityXrayCloud;
print'(A,1pe11.2)'  ,'   p(9) -- TOR cloud profile 2(uniform)  ',clumpProfile

if (input%parameter.ne.9) then
   print*,'Incorrect number of parameter'
   stop
endif

print*, ' ' 
print*, '   *** Innermost    1 GW set into nGW1UW ^3 = ', nGW1uw
print*, '   *** Innermost 11.1 GW set into nGW10UW^3 = ', nGW10uw

!initialize UW grid
do ii = 1, nx
   do jj = 1, ny
      do kk = 1, nz
         netz(ii,jj,kk) = 1
         xx = (ii-0.5)*dgw
         yy = (jj-0.5)*dgw
         zz = (kk-0.5)*dgw
         rr = sqrt((xx-xorg)**2+(yy-yorg)**2+(zz-zorg)**2)
         if (rr.le.11.1*dgw) then 
            netz(ii,jj,kk) = nGW10uw
         end if
         if (rr.le.1.1*dgw) then 
            netz(ii,jj,kk) = nGW1uw !most inner GW into 200x200x200 subcells
         end if
      end do
   end do
end do
!setting TOR clouds by changing n
if (nGW10uw.eq.nGWTORuw) then 
   print*,"10 innermost DGW have same nUW as TOR - This special case is not allowed !"
   stop
endif 

if (nGW1uw.eq.nGWTORuw) then 
   print*,"1  innermost DGW have same nUW as TOR - This special case is not allowed !"
   stop
endif 

if (nGWTORuw .le. 1) then 
   print*,"nGWTORuw must be larger than 1"
   stop
endif 

! TOR region
icloud = 0
iTORclouds = 0
do while ((iTORclouds.lt.torNClouds).and.(icloud.lt.100*torNClouds))
   call random_num(ran,idim)
   rRan = (ran*(router**clumpProfile - rinnerEnvelope**clumpProfile))**(1./clumpProfile) + rinnerEnvelope
   call random_num(ran,idim)
   if (idim3.eq.1) then
      phi = 2. * pi * ran   
   else
      phi = 0.0045 * pi + 0.49 * pi * ran   !0.0045 make sure to avoid edge
   endif
   call random_num(ran,idim)
!New Version sampling in costheta**2
   if (idim3.eq.1) then
      costheta = (-1.+2*ran)*abs(-1.+2*ran)
   else
      costheta = (ran**2)
   endif

   xx = xorg+rRan*sqrt(1.-costheta**2) * cos(phi) 
   yy = yorg+rRan*sqrt(1.-costheta**2) * sin(phi)
   zz = zorg+rRan*costheta
   ii = int(xx/dgw)+1
   jj = int(yy/dgw)+1
   kk = int(zz/dgw)+1
   rr = sqrt(xx*xx+yy*yy+zz*zz)
   if ((ii.le.nx).and.(ii.ge.1).and. &
&      (jj.le.ny).and.(jj.ge.1).and. &
&      (kk.le.nz).and.(kk.ge.1) ) then 
     if ((rr .ge.(isizeCloud+1.1)*dGW) .and. &
&        (netz(ii,jj,kk).ne.nGWTORuw)) then 
         iTORclouds     = iTORclouds + 1
         netz(ii,jj,kk) = nGWTORuw

      if (iSizeCloud.gt.0) then 
         do ix=-iSizeCloud,iSizeCloud
         do iy=-iSizeCloud,iSizeCloud
         do iz=-iSizeCloud,iSizeCloud
               !make sure that it does not hit the nGW1 GW
          if ( ((ii+ix).le.nx).and.((ii+ix).ge.1) .and. &
&              ((jj+iy).le.ny).and.((jj+iy).ge.1) .and. &
&              ((kk+iz).le.nz).and.((kk+iz).ge.1) .and. &
&              (netz(ii+ix,jj+iy,kk+iz).ne.nGWTORuw)) then 

              netz(ii+ix,jj+iy,kk+iz) = nGWTORuw
          endif
         end do
         end do
         end do
      endif
      endif
   endif
   icloud = icloud + 1
end do 

write(6,'(a40, 1p1e10.2)') "  Av of GW with density Cloud:",densityCloud*C_abs_ac(ivisd)*dgw
write(6,'(a40,i10,a20,i10)') "   Number of TORClouds :",iTORclouds, ", asked torNClouds : ", torNClouds

isumuw = 0.
do ii = 1, nx
   do  jj = 1, ny
      do  kk = 1, nz
         isumuw        = isumuw + netz(ii,jj,kk)**3
         netsum(ii,jj,kk) = isumuw
      end do
   end do
end do

call allocspace(isumuw)
print *, ' 7. Summe aller Unterwuerfel =', isumuw


! Initialisierung von dicht:
dicht = 0


do ii=1,nx
   do jj=1,ny
      do kk=1,nz
         ntz = netz(ii,jj,kk)
         dl = dgw/ntz
         do iii=1,ntz
            do jjj=1,ntz
               do kkk=1,ntz
                  lp = netsum(ii,jj,kk) - ntz**3 + ntz**2 * (iii - 1) + ntz * (jjj - 1) + kkk
                  xx    = (x(ii) + (iii - 5d-1) * dl-xorg)
                  yy    = (y(jj) + (jjj - 5d-1) * dl-yorg)
                  zz    = (z(kk) + (kkk - 5d-1) * dl-zorg)
                  rr    = sqrt(xx*xx+yy*yy)
                  rrr   = sqrt(xx*xx+yy*yy+zz*zz)

                  if ((rrr.gt.rinnerEnvelope).and.(rrr.lt.router)) then
                     tmpDicht = density2Phase*(rrr/rinnerEnvelope)**(profile2Phase)
                     dicht(lp) = tmpDicht
                     clMass2Phase = clMass2Phase + cc3 * tmpDicht*(dgw/ntz)**3
                     cl_mass = cl_mass + cc3 * tmpDicht*(dgw/ntz)**3
                  endif

                  if ((rr.gt.rinner).and.(rr.lt.router)) then 
                     rd = router/2.
                     zd = router/8.
                     f1 = 1. / (rr/rd)
                     hr = zd * (rr/rd)**1.125
                     f2 = exp(-pi/4*(zz/hr)**2.)
                     tmpDicht = densityDisk  * f1 * f2
                     dicht(lp) = dicht(lp) + tmpDicht
                     clMassDisk = clMassDisk + cc3 * tmpDicht*(dgw/ntz)**3
                     cl_mass = cl_mass + cc3 * tmpDicht*(dgw/ntz)**3
                  end if
                  
                  if (ntz.eq.nGWTORuw) then 
                     dicht(lp) = dicht(lp) + densityCloud
                     clMassClouds = clMassClouds + cc3 * densityCloud*(dgw/ntz)**3
                     cl_mass = cl_mass + cc3 * densityCloud*(dgw/ntz)**3
                  end if
               end do
            end do
         end do
      end do
   end do
end do

iXrayClouds = 0
iCloud = 0
! XrayRegion
do while((iXrayClouds.lt.nXrayClouds).and.(iCloud.lt.100*nXrayClouds))
   call random_num(ran,idim)
   rRan = (ran*(dgw**clumpProfile - rinner**clumpProfile))**(1./clumpProfile) + rinner
   call random_num(ran,idim)
   if (idim3.eq.1) then
      phi = 2. * pi * ran   
   else
      phi = 0.0045 * pi + 0.49 * pi * ran   !0.0045 make sure to avoid edge
   endif
   call random_num(ran,idim)
!   ran = cos(ran*pi/2.)**2   ! weight cloud distribution by cos^2
   if (idim3.eq.1) then
      costheta = (-1.+2*ran)*abs(-1.+2*ran)
   else
      costheta = (ran**2)
   endif
   xx = xorg+rRan*sqrt(1.-costheta**2) * cos(phi) 
   yy = yorg+rRan*sqrt(1.-costheta**2) * sin(phi)
   zz = zorg+rRan*costheta
   ii = int(xx/dgw)+1
   jj = int(yy/dgw)+1
   kk = int(zz/dgw)+1
   if ((ii.eq.1).and.(jj.eq.1).and.(kk.eq.1)) then 
      ntz = netz(ii,jj,kk)
      dl  = dgw/ntz
      iii = int((xx - ((ii-1)*dgw))/dl) + 1
      jjj = int((yy - ((jj-1)*dgw))/dl) + 1
      kkk = int((zz - ((kk-1)*dgw))/dl) + 1
      if (iii.lt.1) iii=1
      if (jjj.lt.1) jjj=1
      if (kkk.lt.1) kkk=1
      if (iii.gt.nGW1uw) iii=nGW1uw
      if (jjj.gt.nGW1uw) iii=nGW1uw
      if (kkk.gt.nGW1uw) iii=nGW1uw
      lp = netsum(ii,jj,kk) - ntz**3 + ntz**2 * (iii - 1) + ntz * (jjj - 1) + kkk
      dicht(lp) = dicht(lp) + densityXrayCloud
      clMassXrayClouds = clMassXrayClouds + cc3 * densityXrayCloud*(dgw/ntz)**3
      cl_mass = cl_mass + cc3 * densityXrayCloud*(dgw/ntz)**3
      iXrayclouds = iXrayClouds + 1
   end if
   iCloud = iCloud + 1
end do

write(6,'(a40, 1p1e10.2)') "  Av of X - ray Cloud:",densityXrayCloud*C_abs_ac(ivisd)*dgw/300.

write(6,'(a40,i10,a20,i10)') "   Number of Xray Clouds :",iXrayClouds, ", asked nXrayClouds : ", nXrayClouds

print*, ' ' 
write(6,'(a40, 1p1e10.2)') "   Mass in Disk   [Mo]: ", clMassDisk/Msun
write(6,'(a40, 1p1e10.2)') "   Mass in 2Phase [Mo]: ", clMass2Phase/Msun
write(6,'(a40, 1p1e10.2)') "   Mass in Clouds [Mo]: ", clMassClouds/Msun
write(6,'(a40, 1p1e10.2)') "   Mass in Xray Clouds [Mo]: ", clMassXrayClouds/Msun

end subroutine space_2phase_torus_disk
