! spectra.f90
! writing out the spectra of computed distribution
!-------------------------------------------------------------------------------
! compiling with
! gfortran spectra.f90 modules.f90 subroutines.f90 -o spectra # -L ~/programs/cfitsio/cfitsio 
! # -lcfitsio constants.o locat.o parameter.o
!./a.spec 0.1 0.2 50. zum Galetten enter breite start stop wave (mic)
!-------------------------------------------------------------------------------
! first frequency bin of the star is an approximation 
! for tau=0 better ignore and set k=2 for emis_star
!-------------------------------------------------------------------------------
! history
! 2014 01 07 original version by Ralf & Peter 
! 2014 01 14 smoothing removed by Roxana
!            re-written routine, included do loops and select cases
!            added error propagation, assuming err_iphX = sqrt(iphdX) (Poisson/Gauss)
! 2014 02 25 corrected fluxes (adding dtheta to cc4) by Roxana

program spectra
use constants
use parameter
implicit none
	real*8		:: emis_star(nd,nthet) = 0d0,err_emis_star(nd,nthet) = 0d0
	real*8		:: emis_dust(nd,nthet) = 0d0,err_emis_dust(nd,nthet) = 0d0
	real*8		:: emis_star_0(nd,3) = 0d0,err_emis_star_0(nd,3) = 0d0
	real*8		:: emis_dust_0(nd,3) = 0d0,err_emis_dust_0(nd,3) = 0d0
	real*8		:: emis_star_max(nd,3) = 0d0,err_emis_star_max(nd,3) = 0d0
	real*8		:: emis_dust_max(nd,3) = 0d0,err_emis_dust_max(nd,3) = 0d0
	real*8		:: emis(nd,nthet) = 0d0,err_emis(nd,nthet) = 0d0
	real*8		:: emis_0(nd,3)=0,emis_diff(nd,3)=0,emis_max(nd,3)=0!
	real*8		:: err_emis_0(nd,3)=0,err_emis_diff(nd,3)=0,err_emis_max(nd,3)=0
	integer		:: letzt(nthet)
	integer		:: jsumfr
	integer		:: jj
	integer		:: jstern
	integer		:: kk,kd
	integer		:: kmerk,nmerk
	integer		:: nsg
	real*8		:: ddirthet
	real*8		:: fakm,fakn,faky2,faky1,fakx2,fakx1
	real*8		:: err_fakm,err_fakn,err_faky2,err_faky1
	integer		:: kdrit
	integer		:: letztsg
	integer		:: letztmax
	integer		:: isum
	real*8		:: staub
	real*8		:: stern
	real*8		:: w
	real*8		:: wsmax,wsmaxmu
	real*8		:: lum
	character(50)   :: out_file


	open(unit=3, file='output/pah.out_spektrum.inp', form='unformatted')
	rewind 3
	read(3) dirthet, wel, welmu, dfr, weld, welmud, fd, dfd, &
		& cc4, epak, jsumfr, jd, iphd, iphs, letztd, letzts, krit, kugelsym,&
		& iphd0,iphs0,iphdmax,iphsmax,ang_section0,ang_sectionmax,idim3
	close(unit=3)
	print*, 'welmu(2)= ', welmu(2), letzts(1) 

	!check number of photons
	open(unit=3, file='output/photoncheck.out',form='formatted')
	write(3,199)
 199	format(4x,'lambda      star      dust')
	do k=1,nfdif
		write(3,203) welmud(k),0,iphd(k,1),0,iphd(k,2),0,iphd(k,3)
	enddo
	do k=1,nf
		write(3,203) welmud(k+nfdif),iphs(k,1),iphd(k+nfdif,1),iphs(k,2),&
			iphd(k+nfdif,2),iphs(k,3),iphd(k+nfdif,3)
	enddo
 203	format(2x,1pE12.4, 2x, I10, 2x, I10, 2x, I10, 2x, I10, 2x, I10, 2x, I10)
	print*, ' letztd, letzts  ', letztd, letzts
	write(6,*), '2 groesste wellenlange bezgl stern:'
	write(6,*), welmu(1), welmu(2)

!-------------------------------------------------------------------------------
! emission along theta directions
!-------------------------------------------------------------------------------

	do jth   = 1, nthet
		do k=1,nd
			emis(k,jth)      = 0
			emis_star(k,jth) = 0
			emis_dust(k,jth) = 0
			
			err_emis(k,jth)      = 0
			err_emis_star(k,jth) = 0
			err_emis_dust(k,jth) = 0
		enddo
		print*, '   Richtung:  ', jth
		
		write(out_file,'(A,I1,A)') 'output/theta_',jth,'.out'
		open(unit=3, file=out_file, form='formatted')
		rewind 3
		write(3,152) 
 152  		format(4x, 'lamda[mu]  total    star      dust')

		do  k = 1, letztd(jth)
			emis_dust(k,jth) = cc4(jth)*(dirthet(jth+1) - dirthet(jth))*iphd(k,jth)*epak/dfd(k)
			if( iphd(k,jth).eq.0 ) then 
				err_emis_dust(k,jth) = 0.0
			else
				err_emis_dust(k,jth) = emis_dust(k,jth) / sqrt(real(iphd(k,jth)))
			end if
		end do

		! first frequency bin of the star is an approximation 
		! I do not use it therefore if statement
		! for tau=0 better ignore and set k=2
		do k = 2,letzts(jth) 
!			if(welmud(jd(k)).lt.welmu(1)) then
			emis_star(jd(k),jth) = cc4(jth)*(dirthet(jth+1) - dirthet(jth))*iphs(k,jth)*epak/dfr(k)
			if( iphs(k,jth).eq.0 ) then 
				err_emis_star(k,jth) = 0.0
			else
				err_emis_star(k,jth) = emis_star(k,jth) / sqrt(real(iphs(k,jth)))
			end if
!			endif
      		end do 

		print*,'iphd(1,',jth,'):',iphd(1,jth)
		k = jd(1)
		do while (k.lt.nd)
			nmerk=1
			if (emis_star(k,jth).eq.0) then
				do while(emis_star(k+nmerk,jth).eq.0.and.k+nmerk.lt.nd-1)
					nmerk = nmerk + 1
				enddo
				faky2 = log10(emis_star(k+nmerk,jth))
				faky1 = log10(emis_star(k-1,jth))
				fakx2 = log10(welmud(k+nmerk))
				fakx1 = log10(welmud(k-1))
				fakm = (faky2 - faky1)/(fakx2-fakx1)
				fakn = (fakx2*faky1-faky2*fakx1)/(fakx2-fakx1)
				
				err_faky2 = 1.0 / ( sqrt(real(iphs(k+nmerk,jth))) * log(10.) )
				err_faky1 = 1.0 / ( sqrt(real(iphs(k-1,jth))) * log(10.) )
				err_fakm  = (err_faky2 - err_faky1)/(fakx2-fakx1)
				err_fakn = (fakx2*err_faky1-err_faky2*fakx1)/(fakx2-fakx1)
				
				do kmerk = 1,nmerk
				if (emis_star(k+nmerk,jth).ne.0.and.emis_star(k-1,jth).ne.0) then 
				    emis_star(k+kmerk-1,jth) = 10**(fakn + fakm*(log10(welmud(k+kmerk-1))))
				    err_emis_star(k+kmerk-1,jth) = &
				    & abs((err_fakn + err_fakm*(log10(welmud(k+kmerk-1)))) / &
				    & ( log(10.)*( fakn + fakm*(log10(welmud(k+kmerk-1))) ) ))
				endif
				enddo
			endif
			k = k + nmerk
			if (k.gt.nd) k = nd
		end do 

		k = 2
		do while (k.lt.nd-1)
			nmerk=1
			if (emis_dust(k,jth).eq.0) then
				do while(emis_dust(k+nmerk,jth).eq.0.and.k+nmerk.lt.nd-1)
					nmerk = nmerk + 1
				enddo
				faky2 = log10(emis_dust(k+nmerk,jth))
				faky1 = log10(emis_dust(k-1,jth))
				fakx2 = log10(welmud(k+nmerk))
				fakx1 = log10(welmud(k-1))
				fakm =(faky2 - faky1)/(fakx2-fakx1)
				fakn = (fakx2*faky1-faky2*fakx1)/(fakx2-fakx1)
				
				err_faky2 = 1.0 / ( sqrt(real(iphd(k+nmerk,jth))) * log(10.) )
				err_faky1 = 1.0 / ( sqrt(real(iphd(k-1,jth))) * log(10.) )
				err_fakm  = (err_faky2 - err_faky1)/(fakx2-fakx1)
				err_fakn = (fakx2*err_faky1-err_faky2*fakx1)/(fakx2-fakx1)
				
				do kmerk = 1,nmerk
				if (emis_dust(k+nmerk,jth).ne.0.and.emis_dust(k-1,jth).ne.0) then 
				   emis_dust(k+kmerk-1,jth) = 10**(fakn + fakm*(log10(welmud(k+kmerk-1))))
				    err_emis_dust(k+kmerk-1,jth) = &
				    & abs((err_fakn + err_fakm*(log10(welmud(k+kmerk-1)))) / &
				    &( log(10.)*( fakn + fakm*(log10(welmud(k+kmerk-1))) ) ))
				endif
				enddo
			endif
			k = k + nmerk
		end do  

		do k=1,nd 
			emis(k,jth) = emis_star(k,jth) + emis_dust(k,jth)
			err_emis(k,jth) = err_emis_star(k,jth) + err_emis_dust(k,jth)
			write(3,'(1pe12.4,A,e12.4,A,e12.4,A,e12.4,A,e12.4,A,e12.4,A,e12.4)') &
				welmud(k),' ', emis(k,jth),' ', err_emis(k,jth),' ', &
				emis_star(k,jth),' ',err_emis_star(k,jth),' ', &
				emis_dust(k,jth),' ',err_emis_dust(k,jth)
		end do
		close(unit=3)
	end do	 ! end of loop over theta

!x,y,z = max seds
	do jth=1,3
		select case(jth)
			case(1)
				write(out_file,'(A,I1,A)') 'output/sed_xmax.out'
				print*,'x=xmax'
			case(2)
				write(out_file,'(A,I1,A)') 'output/sed_ymax.out'
				print*,'y=ymax'
			case(3)
				write(out_file,'(A,I1,A)') 'output/sed_zmax.out'
				print*,'z=zmax'
		end select
		open(unit=3, file=out_file, form='formatted')
		rewind 3
		write(3,152)
		do  k = 1,nd
			emis_dust_max(k,jth) = ang_sectionmax(jth)*iphd0(k,jth)*epak/dfd(k)
		end do
		do k = 1,nf
			emis_star_max(jd(k),jth) = ang_sectionmax(jth)*iphs0(k,jth)*epak/dfr(k)
		end do
      
		k = jd(1)
		do while (k.lt.nd)
			nmerk=1
			if (emis_star_max(k,jth).eq.0) then
				do while(emis_star_max(k+nmerk,jth).eq.0.and.k+nmerk.lt.nd-1)
					nmerk = nmerk + 1
				enddo
				faky2 = log10(emis_star_max(k+nmerk,jth))
				faky1 = log10(emis_star_max(k-1,jth))
				fakx2 = log10(welmud(k+nmerk))
				fakx1 = log10(welmud(k-1))
				fakm = (faky2 - faky1)/(fakx2-fakx1)
				fakn = (fakx2*faky1-faky2*fakx1)/(fakx2-fakx1)
				do kmerk = 1,nmerk
				if (emis_star_max(k+nmerk,1).ne.0.and.emis_star_max(k-1,1).ne.0) then 
					emis_star_max(k+kmerk-1,jth) = 10**(fakn + fakm*(log10(welmud(k+kmerk-1))))
				endif
				enddo
			endif
			k = k + nmerk
			if (k.gt.nd) k = nd
		end do 

		do k=1,nd
			emis_max(k,jth) = emis_dust_max(k,jth) + emis_star_max(k,jth)
			write(3,'(1pe12.4,A,e12.4,A,e12.4,A,e12.4,A,e12.4)') welmud(k),&
			       ' ', emis_max(k,jth),' ',emis_star_max(k,jth),' ',emis_dust_max(k,jth),' ',emis_diff(k,jth)
		enddo
		close(unit=3)
		
	end do
	
!x,y,z = 0 seds	
	if(idim3 .eq. 1) then
		do jth=1,3
			select case(jth)
				case(1)
					write(out_file,'(A,I1,A)') 'output/sed_x0.out'
					print*,'x=0'
				case(2)
					write(out_file,'(A,I1,A)') 'output/sed_y0.out'
					print*,'y=0'
				case(3)
					write(out_file,'(A,I1,A)') 'output/sed_z0.out'
					print*,'z=0'
			end select
			open(unit=3, file=out_file, form='formatted')
			rewind 3
			write(3,152)
			do  k = 1,nd
				emis_dust_0(k,jth) = ang_section0(jth)*iphd0(k,jth)*epak/dfd(k)
			end do
			do k = 1,nf
				emis_star_0(jd(k),jth) = ang_section0(jth)*iphs0(k,jth)*epak/dfr(k)
			end do
	      
			k = jd(1)
			do while (k.lt.nd)
				nmerk=1
				if (emis_star_0(k,jth).eq.0) then
					do while(emis_star_0(k+nmerk,jth).eq.0.and.k+nmerk.lt.nd-1)
						nmerk = nmerk + 1
					enddo
					faky2 = log10(emis_star_0(k+nmerk,jth))
					faky1 = log10(emis_star_0(k-1,jth))
					fakx2 = log10(welmud(k+nmerk))
					fakx1 = log10(welmud(k-1))
					fakm = (faky2 - faky1)/(fakx2-fakx1)
					fakn = (fakx2*faky1-faky2*fakx1)/(fakx2-fakx1)
					do kmerk = 1,nmerk
					if (emis_star_0(k+nmerk,1).ne.0.and.emis_star_0(k-1,1).ne.0) then 
						emis_star_0(k+kmerk-1,jth) = 10**(fakn + fakm*(log10(welmud(k+kmerk-1))))
					endif
					enddo
				endif
				k = k + nmerk
				if (k.gt.nd) k = nd
			end do 

			do k=1,nd
				emis_0(k,jth) = emis_dust_0(k,jth) + emis_star_0(k,jth)
				write(3,'(1pe12.4,A,e12.4,A,e12.4,A,e12.4,A,e12.4)') welmud(k),&
				       ' ', emis_0(k,jth),' ',emis_star_0(k,jth),' ',emis_dust_0(k,jth),' ',emis_diff(k,jth)
			enddo
			close(unit=3)
		end do
	endif
end program spectra
