subroutine mirror(a,d,init,iGW)
use type_module
        implicit none
        type(float_vector),intent(inout)        :: a,d
        type(int_vector),intent(inout)        :: iGW
        type(init_type),intent(in)           :: init
	if (abs(a%x/init%dgw).le.1e-5.and.d%x.lt.0.) then 
        	d%x = -d%x
		a%x = 0.
                iGW%x = 1
	end if
	if (abs(a%y/init%dgw).le.1e-5.and.d%y.lt.0.) then 
		d%y = -d%y
		a%y = 0.
                iGW%y = 1
	end if
	if (abs(a%z/init%dgw).le.1e-5.and.d%z.lt.0.) then
		d%z = -d%z
		a%z = 0.
                iGW%z = 1
	end if
end subroutine mirror


!
! ------------------------------------------------------------------
!

real*8 function bpl(fr,fr3,t)
!   Berechnet Planck Funktion.  fr = Frequenz,   fr3 = fr**3,  t = Temperatur
      implicit none
      	real*8,parameter 	:: c1=1.474528d-47
      	real*8,parameter	:: c2=4.799438d-11
	real*8			:: x
	real*8,intent(in)	:: fr
	real*8,intent(in)	:: fr3
	real*8,intent(in)	:: t
	
      x = c2 * fr / t 

        if(x .gt. 3d2)        then
        bpl = 0.
        else if(x .lt. 1d-8)  then
        bpl = c1 * fr3 / x / (1d0 + x/2d0) 
        else
        bpl = c1 * fr3 / (exp(x)-1d0)
        end if

      return
      end 


!
! -----------------------------------------------------------------
!
      
      function planck(freq,temp)
        implicit none
        real*8                  :: planck
        real*8,intent(in)       :: freq,temp
	real*8,parameter        :: h=6.6262e-27;
	real*8,parameter        :: k=1.38062e-16;
	real*8,parameter        :: c=2.997925e10;
        real*8                  :: x
        x = freq/c
	planck = 2*h*x*x*x*c*1/(exp((h*freq)/(k*temp))-1.0);
        return
end function planck


!
! -----------------------------------------------------------------
!

!
! --------------------------------------------------------------------------------------------------------
!

subroutine locat(v, n, x, j)

!   Sei v ein geordneter Vektor der Lange n und x eine beliebige Zahl.
!   Wenn  v(1) < v(2) < ... < v(n),  so liegt x  im halboffenen 
!   Intervall  (v(j), v(j+1)].
!   Falls   x <= v(1):   j = 0.   Falls   v(n) < x:   j = n
!   Wenn  v(1) > v(2) > ... > v(n),  so liegt x  im halboffenen 
!   Intervall  (v(j+1), v(j)].
!   Falls   x > v(1):   j = 0.    Falls   v(n) >= x:  j = n

        implicit none
        real*8,intent(in)	:: v(n)
      	integer,intent(in) 	:: n
	real*8,intent(in) 	:: x
	integer,intent(out) 	:: j
	integer			:: jlow,jup,jm
        jlow = 0
        jup  = n + 1

 10     continue
        if(jup-jlow .gt. 1) then
                jm = (jup + jlow) / 2
                if( (v(n).gt.v(1) ) .eqv. ( x.gt.v(jm)) ) then
                        jlow = jm
                else
                        jup  = jm
                end if
        go to 10
        end if
        j = jlow
end subroutine 


subroutine nlocat(v, n, x, j)

!   Sei v ein geordneter Vektor der Lange n und x eine beliebige Zahl.
!   output: j bei dem v(j) am naechsten zu x liegt. 
!
        implicit none
        real*8,intent(in)	:: v(n)
      	integer,intent(in) 	:: n
	real*8,intent(in) 	:: x 
        real*8                  :: d,dm,dp
	integer,intent(out) 	:: j

        call locat(v, n, x, j)
        if(j.lt.1) j = 1
        if(j.gt.n) j = n
        dm = 1d30
        dp = 1d30
        d  = abs(v(j) - x)       
        if(j .gt.1)   dm = abs(v(j-1) - x) 
        if(j .lt.n)   dp = abs(v(j+1) - x) 
        if(dm.lt. d)   j = j-1
        if(dp.lt. d)   j = j+1
        if(d .ge. 1d30) stop ' nlocat: d> 1d30'
end subroutine 

!
! --------------------------------------------------------------------------------------------------------
!



       !*****************************************************
       !*  Sorts an array RA of length N in ascending order *
       !*                by the Heapsort method             *
       !* ------------------------------------------------- *
       !* INPUTS:                                           *
       !*	    N	  size of table RA                   *
       !*          RA	  table to be sorted                 *
       !* OUTPUT:                                           *
       !*	    RA    table sorted in ascending order    *
       !*                                                   *
       !* NOTE: The Heapsort method is a N Log2 N routine,  *
       !*       and can be used for very large arrays.      *
       !*****************************************************         
       SUBROUTINE ASORT(N,RA)
         real*8 RA(N)
         L=N/2+1
         IR=N
         !The index L will be decremented from its initial value during the
         !"hiring" (heap creation) phase. Once it reaches 1, the index IR 
         !will be decremented from its initial value down to 1 during the
         !"retirement-and-promotion" (heap selection) phase.
 10      continue
         if(L > 1)then
           L=L-1
           RRA=RA(L)
         else
           RRA=RA(IR)
           RA(IR)=RA(1)
           IR=IR-1
           if(IR.eq.1)then
             RA(1)=RRA
             return
           end if
         end if
         I=L
         J=L+L
 20      if(J.le.IR)then
         if(J < IR)then
           if(RA(J) < RA(J+1))  J=J+1
         end if
         if(RRA < RA(J))then
           RA(I)=RA(J)
           I=J; J=J+J
         else
           J=IR+1
         end if
         goto 20
         end if
         RA(I)=RRA
         goto 10
       END

!  ***************************************************************************



!
! --------------------------------------------------------------------------------------------------------
!

real*8 function rtbis(func, x1, x2, xacc)
use source_parameter
      implicit none
      real*8,intent(in) :: x1
      real*8,intent(in) :: x2
      real*8,intent(in) :: xacc   
      integer,parameter	:: jmax=40    
      integer		:: j     
      real*8		:: fmid
      real*8		:: f
      real*8		:: xmid
      real*8		:: dx         
      real*8,external	:: func


      fmid = func(x2)
      f = func(x1)
      if(f*fmid .ge. 0d0) stop 'Root must be bracketed for bisection.'
      if(f .lt. 0d0)then
        rtbis = x1
        dx    = x2 - x1
      else
        rtbis = x2
        dx    = x1 - x2
      endif
      do 11 j = 1, jmax
        dx   = dx * 5d-1
        xmid = rtbis + dx
        fmid = func(xmid)
        if(fmid .le. 0d0)   rtbis = xmid
        if(abs(dx) .lt. xacc .or. fmid .eq. 0d0) return
11    continue
      stop 'too many bisections'
      end
real*8 function f1_ext(x_f1)
      use constants
      use parameter
      use source_parameter
      implicit none
      real*8,intent(in) :: x_f1
      real*8		:: bpl
      f1_ext  = (x_f1 - xalt) * (bpl(x_f1, x_f1**3, Tstar) + bpl(xalt, xalt**3, Tstar)) - 2d0 * quant

      return
      end

!
! ----------------------------------------------------
!
real*8 function dbpldt(fr,fr3,t)

!   Berechnet Planck Funktion.  fr = Frequenz,   fr3 = fr**3,  t = Temperatur

      implicit none
      	real*8,parameter 	:: c1=1.474528d-47
      	real*8,parameter	:: c2=4.799438d-11
	real*8			:: x
	real*8,intent(in)	:: fr
	real*8,intent(in)	:: fr3
	real*8,intent(in)	:: t

      x = c2 * fr / t 

        if(x .gt. 3d2)        then
        dbpldt = 0.
        else if(x .lt. 1d-6)  then
        dbpldt = c1 * fr3 * exp(x) / t / x / (1d0 + x + x**2/3d0) 
        else
        dbpldt = c1 * fr3 * exp(x)  /t * x / (exp(x) - 1d0)**2
        end if

      return
      end
!
! ----------------------------------------------------
!

subroutine absorption_iter(init,jf_local,UWmass,ran1,ran2,lp_local)
! 6.3  Absorption im UW lp durch aC oder Si
! Frequenz der re-emission aus Temp. der vorhergehende  Iteration f. aC und Si.
!  T aus vorberechnetes Gitter, folglich wird Tsi(lp) nur noch
!  der Index vom Temp.-Gitter gespeichert: jl = int(Tsi(lp_local))
! init%n_precalc = 0   : aus Temp berechne frequenz 
! init%n_precalc .ne. 0: versuch schneller zu werden durch vorhergehendes 
!                        abspeichern der Frequenz  (kein Vorteil) 
!                 

use type_module
use constants
use parameter
        implicit none
        type(init_type) :: init
        integer         :: jf_local
        real*8          :: UWmass,ran1,ran2
        real*8          :: fak,fak2,Eabsz,QsBip,sumQsBip
        integer         :: kl,jl,lp_local,ran_tmp
        real*8          :: bpl,sumQ

	fak2 = c_abs_si(jf_local)  / (c_abs_ac(jf_local) + c_abs_si(jf_local))
	if (fak2.ge.ran1) then 
!$omp atomic
		nabssi(lp_local)=nabssi(lp_local) + 1
                jl = int(Tsi(lp_local))
                if (jl.eq.0) jl=1
                if (init%n_precalc.gt.0) then 
                        ran_tmp = int(ran2*init%n_precalc)
                        if (ran_tmp.lt.1) ran_tmp=1
                        if (ran_tmp.gt.init%n_precalc) ran_tmp=init%n_precalc
                        jf_local = iter_si(jl,ran_tmp)
                else
                        jf_local = 1
        		sumQ=c_abs_si(jf_local)*bpl(fd(jf_local),fd3(jf_local),Td(jl))*dfd(jf_local)

        		do while(ran2>=sumQ/QBsi(jl).and.jf_local.lt.nd)
                                jf_local = jf_local + 1
                                sumQ=sumQ + c_abs_si(jf_local)*bpl(fd(jf_local),fd3(jf_local),Td(jl))*dfd(jf_local)
        		end do
                        if (jf_local.gt.nd) jf_local = nd
                end if
	else
!$omp atomic
		nabsc(lp_local) = nabsc(lp_local) + 1
                jl = int(Tc(lp_local))
                if (jl.eq.0) jl=1
                if (init%n_precalc.gt.0) then 
                        ran_tmp = int(ran2*init%n_precalc)
                        if (ran_tmp.lt.1) ran_tmp=1
                        if (ran_tmp.gt.init%n_precalc) ran_tmp=init%n_precalc
                        jf_local = iter_ac(jl,ran_tmp)
                else
                        jf_local = 1
        		sumQ=c_abs_ac(jf_local)*bpl(fd(jf_local),fd3(jf_local),Td(jl))*dfd(jf_local)
        		do while(ran2>=sumQ/QBc(jl).and.jf_local.lt.nd)
                                jf_local = jf_local + 1
                		sumQ=sumQ + c_abs_ac(jf_local)*bpl(fd(jf_local),fd3(jf_local),Td(jl))*dfd(jf_local)

        		end do
                        if (jf_local.gt.nd) jf_local = nd
                end if
	end if 
end subroutine absorption_iter

!--------------------------------------------------------------------------
! Performs heapsort on 2-dimensional array of integers, sorting by first--- 
! ----------------------element only---------------------------------------
!--------------------------------------------------------------------------

subroutine Heapsort2(Arr,dim1,dim2)
implicit none
integer,intent(in) :: dim1,dim2
integer,dimension(dim1,dim2) :: Arr

integer,allocatable :: temp(:)
integer :: i,j,root,child

allocate(temp(dim2))
temp=0
i = dim1/2 + 1


do i = dim1/2 + 1, 1, -1 !construct heap
root = i
   do while (root*2 .lt. dim1) !sifts heap, comparing roots to it's children
      child = root*2
      if ((child+1 .lt. dim1) .and. (Arr(child,1) .lt. (Arr(child+1,1))))then
         child = child + 1
      end if

      if (Arr(root,1) .lt. Arr(child,1)) then
         temp = Arr(child,:)
         Arr(child,:) = Arr(root,:)
         Arr(root,:) = temp
         root = child
      else
         return
      end if
   end do

end do

do j = dim1, 1, -1 !sort heap
   temp = Arr(1,:) !remove first element of array to end as it is the largest unsorted element
   Arr(1,:) = Arr(j,:)
   Arr(j,:) = temp
   root = 1
   do while (root*2 .lt. j) !now re-build heap with remaining elements by sifting as above
      child = root*2
      if ((child+1 .lt. j) .and. (Arr(child,1) .lt. (Arr(child+1,1))))then
         child = child + 1
      end if

      if (Arr(root,1) .lt. Arr(child,1)) then
         temp = Arr(child,:)
         Arr(child,:) = Arr(root,:)
         Arr(root,:) = temp
         root = child
      else
         return
      end if
   end do
end do

end subroutine

!--------------------------------------------------------------------------
! Performs heapsort on array of type(sca_store), sorting by jf------------- 
! ----------------------element only---------------------------------------
!--------------------------------------------------------------------------

subroutine Heapsort_sca(Arr,dim1)
implicit none
        type sca_store
                integer :: jf
                integer :: lp
                real*8  :: x
                real*8  :: y
                real*8  :: z
        end type sca_store
integer,intent(in) :: dim1
type(sca_store),dimension(dim1) :: Arr

type(sca_store) :: temp
integer :: i,j,root,child

!allocate(temp)
i = dim1/2 + 1


do i = dim1/2 + 1, 1, -1 !construct heap
root = i
   do while (root*2 .lt. dim1) !sifts heap, comparing roots to it's children
      child = root*2
      if ((child+1 .lt. dim1) .and. (Arr(child)%jf .lt. (Arr(child+1)%jf)))then
         child = child + 1
      end if

      if (Arr(root)%jf .lt. Arr(child)%jf) then
         temp = Arr(child)
         Arr(child) = Arr(root)
         Arr(root) = temp
         root = child
      else
         return
      end if
   end do

end do

do j = dim1, 1, -1 !sort heap
   temp = Arr(1) !remove first element of array to end as it is the largest unsorted element
   Arr(1) = Arr(j)
   Arr(j) = temp
   root = 1
   do while (root*2 .lt. j) !now re-build heap with remaining elements by sifting as above
      child = root*2
      if ((child+1 .lt. j) .and. (Arr(child)%jf .lt. (Arr(child+1)%jf)))then
         child = child + 1
      end if

      if (Arr(root)%jf .lt. Arr(child)%jf) then
         temp = Arr(child)
         Arr(child) = Arr(root)
         Arr(root) = temp
         root = child
      else
         return
      end if
   end do
end do

end subroutine

!  ***************************************************************************

      integer function Cmax(C_si,C_aC)
!-------------------------------------------------------------------------------
!----Function to find maximum value of the sum of two vectors by brute force----
!----Vectors must be of same length!!-------------------------------------------

      use constants
      use parameter
      implicit none
      real*8,dimension(nd),intent(in) :: C_si
      real*8,dimension(nd),intent(in) :: C_aC
      real*8 :: tempo
      integer :: imax,n!,arsize

!      arsize = SIZE(C_si)
      imax = 1
      tempo = C_si(1) + C_aC(1)

      do n=2 , nd
          if (tempo .le. (C_si(n) + C_aC(n))) then
              tempo = C_si(n) +C_aC(n)
              imax = n
          endif
      enddo

      Cmax = imax

      end function


!
! --------------------------------------------------------------------------------------------------------
!

subroutine read_parameter
use parameter
use constants
	implicit none
        real*8  :: totmass
	integer :: idummy(100)
	print*, ' reading parameter'
	open(unit=25, file='input/mc.inp', form='formatted')
      	rewind 25
	500 format(20a4)

	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     idim3, ibug, iblack
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     input%structure
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     input%parameter
        do i=1,input%parameter
           read(25,*) input%p(i)
        end do
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     iQuelle, LQuelle, Tstar, dist, nzyk
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     dgw, rinner, router, kugelsym
 ! removed hardcoding of model size to limit recompiles
 ! instead read in values of nx, ny, nz from mc.inp and allocate all
 ! arrays that depend on them
        read(25,500)   (idummy(i), i=1,20)
        read(25,*),    nx, ny, nz
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     LaC, lec, lasi, lesi
	read(25,500)   (idummy(i), i=1,20)
        read(25,*)     jmrn
	read(25,500)   (idummy(i), i=1,20)
        read(25,*)     i_iso
        read(25,500)   (idummy(i), i=1,20)
!        read(25,*)    i_write !no longer needed, mc doesn't write scatters while sca does.
!	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     jpah, jvsg, jgas
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     zcpah, hydpah, abupah, abuvsg
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     klump, nklump
	read(25,500)   (idummy(i), i=1,20)
	read(25,*)     old_random, iter_luci
         n_luci = 0
!vorher als input: size of precalculated data (default=30000) for CUDA
!	read(25,*)     n_luci		
!
	close(unit=25)

        dgw        = 3.3333*rinner
        router     = 166.6667*rinner
        input%p(1) = input%p(1) * 1d18/dgw   ! densityCloud   
        input%p(5) = input%p(5) * 1d18/dgw   ! densityDisk    

     print*, '  '
     print*, ' ----------------------------------------------------'
     write(6,*)  ' *** WARNING: overwrite input to hardcoded values:'
     write(6,'(a,1p1e10.2)') ' *** dgw    = 3.3333 *rinner     =  ', dgw

     write(6,'(a,1p1e10.2)') ' *** router = 166.667*rinner     =  ', router
     write(6,'(a,1p1e10.2)') ' ***  densityCloud   *1d18/dgw   =  ',  input%p(1)
     write(6,'(a,1p1e10.2)') ' ***  densityDisk    *1d18/dgw   =  ',  input%p(5)
     print*, '  '
        if(input%structure .ne. 14) then
            print*, ' This MC version is ment to compuute AGN library only'
            stop
        endif

        if(nx*dgw .lt. 0.999*router)    then
            print*, ' nx*dgw .lt. 0.999*router, increase nx' 
            stop
        endif


! For AGN grid reset input parameters rinner=dgw and depends
! on AGN Luminosity: 


        if(input%structure .eq. 7) then
         rinner     = input%p(2) * sqrt(LQuelle/1d45) * pc
         router     = 25.* rinner
         dGW        = rinner /2.

         print*, Lquelle
         print*, rinner, router
         print*, input%p(2), input%p(3)
         print*, dgw
        endif



!   For numerical checks: dust grains are blackbodies and do not scatter
        if(iblack .eq.1) print*, &
&       ' **** I use iblack =1  also Qabs=1, Qsca=0 !!! '
        if(nzyk .ge. 115000 .and.jpah .ne. 0 ) &
&       stop ' nzyk > 116400 will likely crash PAH memory'
	if(jvsg .eq. 0)   abuvsg = 0.
      	if(jpah .eq. 0)   abupah = 0.
	dist = pc * dist
	qmrn = qmrn - 1d0
	
        if (idim3.eq.1) then 
               print*, '  *** 3dim case'
                cc3=1
                xorg=nx/2d0*dgw
                yorg=ny/2d0*dgw
                zorg=nz/2d0*dgw
        else 
               print*, '  *** axi-symmetric  case'
                cc3=8   
                xorg=0
                yorg=0
                zorg=0
        endif
        write(6,*) '     Origin of star position (xorg,yorg,zorg) at: '
        write(6,'(7x, 1p3e10.2)') xorg, yorg, zorg

!  Mass of pah, vsg, aC and Si in 1g of MRN dust
        totmass = abuc*wmolc + abusi*wmolsi  + abuc*wmolc*abuvsg 
      	aCmass  = abuc  * wmolc  / totmass
      	Simass  = abusi * wmolsi / totmass
      	vsgmass = abuc  * wmolc  * abuvsg/totmass
      	pahmass = abuc  * wmolc  * abupah/totmass

! relative totmass must be =1:
        totmass = acmass+simass+vsgmass
        if(totmass .ne. 1.) then
        print*, ' *** Mass of totmass:= 1g of MRN/Composite dust (in read_parameter)'
        print*, 'totmass, acmass, simass, vsgmass, pahmass'
        write(6,'(1p5e10.2)') totmass, acmass, simass, vsgmass, pahmass
        stop ' relative totmass must be =1 !'
        endif
	do  jth = 1, nthet+1
	      dirthet(jth) = (jth-1) * (1d0/nthet)
	end do
!	do  61  k = 1, nd
!      		do  jth = 1, nthet
!      			iphd(k,jth) = 0
!      			if(k .le. nf)   iphs(k,jth) = 0
!      		end do
! 	61   continue

!       iphd = 0
!       iphs = 0

! now need to allocate arrays and set values that depend on nx,ny,nz

       nx1 = nx+1
       ny1 = ny+1
       nz1 = nz+1
       allocate(netz(nx,ny,nz))
       allocate(netsum(nx,ny,nz))
       allocate(Hscale(nx))
       allocate(csound(nx))
       allocate(x(nx1))
       allocate(y(ny1))
       allocate(z(nz1))
       netz=0
       netsum=0
       Hscale=0
       csound=0
       x=0d0
       y=0d0
       z=0d0
!       allocate()
	
	return
end subroutine read_parameter

!
!--------------------------------------
!

subroutine read_datafile
!
! reads in data for radiative transfer modelling from data file
! used if structure = -1 in mc.ino
! input: input/dust_grid.inp, input/dust_density.inp
!        read in data: cube structure, dust density
! output: read_datafile is part of space.f90 and imports structure and 
!         physical data for MC
! 2014 01 28 originally by Roxana
! 2014 02 25 Roxana: input files formatted -> unformatted
!

use type_module
use constants
use parameter
implicit none

type(init_type)         :: init
integer                 :: ix,iy,iz,iux,iuy,iuz,ntz
integer                 :: dumx,dumy,dumz,iter
real*8                  :: dl,dichttemp=0d0

! preparations
cl_mass = 0d0
isumuw = 0

! opening file containing cube structure
! structure of file:
! xgrid(i) ygrid(i) zgrid(i) #(UW,i)
! ....
open(unit=21, file='input/dust_grid.inp', form='unformatted')
rewind 21

! opening file containing dust density
! structure of file:
! density(i) 
! ....
open(unit=22, file='input/dust_density.inp', form='unformatted')
rewind 22

do i=1,nx
do j=1,nx
do k=1,nx
	netz(i,j,k)   = 1
	netsum(i,j,k) = 0
end do
end do
end do

! reading in grid       
do i=1,nx
do j=1,ny
do k=1,nz
	read(21) dumx,dumy,dumz,netz(dumx,dumy,dumz)
	isumuw = isumuw + netz(dumx,dumy,dumz)**3
	netsum(dumx,dumy,dumz) = isumuw
end do
end do
end do

call allocspace(isumuw)

! reading in density and temperature distributions
do i=1,nx
do j=1,ny
do k=1,nz
	ntz = netz(i,j,k)
	do ix=1,ntz
	do iy=1,ntz
	do iz=1,ntz
		dl = dGW / ntz
		lp = netsum(i,j,k) - ntz**3 + ntz**2*(ix-1) + ntz*(iy-1) + iz			

		if (lp.lt.1) then 
			print*,lp,netsum(i,j,k),ntz,i,j,k,ix,iy,iz
		end if
		
		read(22) dichttemp
		dicht(lp) = dichttemp
		cl_mass = cl_mass + cc3 * dicht(lp) * dl**3
	end do
	end do
	end do
end do
end do
end do	
write(6,'(a33,1p1e10.2)') '7. Summe aller Unterwuerfel = ',dfloat(isumuw)

close(21)
close(22)

end subroutine read_datafile


!
!--------------------------------------
!
subroutine allocspace(numUW)

use parameter
use constants
use type_module
        implicit none
        integer :: numUW

        allocate(Tsi(numUW))
        allocate(Tc(numUW))
        allocate(nabsc(numUW))
        allocate(nabssi(numUW))
        allocate(iabs(numUW))
        allocate(isca(numUW))
        allocate(iabspah(numUW))
        allocate(dicht(numUW))
        allocate(inopah(numUW))

        Tsi = 0d0
        Tc = 0d0
        nabsc = 0
        nabssi = 0
        iabs = 0
        isca = 0
        iabspah = 0
        dicht = 0d0
        inopah = 0


end subroutine allocspace


