!-------------------------------------------------------------------------------
! trace.f90
!-------------------------------------------------------------------------------
! history
! originally by Ralf & Peter
! 2014 02 25 Roxana
!	deleted subroutine get_direction_init
!	has been like get_direction for structure=2/4, included factor 0.5 for emitting photons within the inner 45deg
!	replaced by get_direction
!-------------------------------------------------------------------------------

function icheck_leave(a,d,jabs,jf_local,jjf_local,init)

! Ade Du schoene Wolke
!   iphd(jf,jth) = Zahl der Pakete mit Freq jf in Richt jth, die Wolke verlassen
!   iphs(jf,jth)  wie iphd(jf,jth), aber ohne Staubabsorption
!         icheck_leave = 1 => Photon verläßt Wolke 
use type_module
use parameter
use constants
        implicit none
        type(float_vector),intent(inout)        :: a,d
        type(init_type),intent(in)              :: init
        integer                                 :: icheck_leave,jjf_local
        integer                                 :: jabs,jth_local,jf_local
	real*8,parameter                        :: near = 0.99999

        icheck_leave = 0
	if (init%idim3.ne.1) then 
	if ((a%x/init%dgw.ge.near*init%nx).or. &
&           (a%y/init%dgw.ge.near*init%ny).or. &
&           (a%z/init%dgw.ge.near*init%nz))  then 
!$omp atomic
		nphot=nphot + 1
		call locat(dirthet,(init%nthet+1),abs(d%z),jth_local)
                if(jth_local .le.0) jth_local = 1     !RS new
!neu mit jabs:
                if (jabs.gt.0 .or. jjf_local .eq.0) then
!$omp atomic
                        iphd(jf_local,jth_local) = iphd(jf_local,jth_local) + 1
                        if(a%x/init%dgw.ge.(near*init%nx)) then
!$omp atomic
                              iphdmax(jf_local,1) = iphdmax(jf_local,1) + 1
                        endif
                        if(a%y/init%dgw.ge.(near*init%ny)) then
!$omp atomic
                              iphdmax(jf_local,2) = iphdmax(jf_local,2) + 1
                        endif
                        if(a%z/init%dgw.ge.(near*init%nz)) then
!$omp atomic
                              iphdmax(jf_local,3) = iphdmax(jf_local,3) + 1
                        endif
		else 
!$omp atomic
                        iphs(jjf_local,jth_local) = iphs(jjf_local,jth_local) + 1
                        if(a%x/init%dgw.ge.(near*init%nx)) then
!$omp atomic
                              iphsmax(jjf_local,1) = iphsmax(jjf_local,1) + 1
                        endif
                        if(a%y/init%dgw.ge.(near*init%ny)) then
!$omp atomic
                              iphsmax(jjf_local,2) = iphsmax(jjf_local,2) + 1
                        endif
                        if(a%z/init%dgw.ge.(near*init%nz)) then
!$omp atomic
                              iphsmax(jjf_local,3) = iphsmax(jjf_local,3) + 1
                        endif
                end if
		icheck_leave = 1
        end if
        end if
	if (init%idim3.eq.1) then
        if ((a%x/init%dgw.ge.near*init%nx).or.(a%y/init%dgw.ge.near*init%ny).or.(a%z/init%dgw.ge.near*init%nz) &
&       .or.(a%x/init%dgw.le.(1.-near))   .or.(a%y/init%dgw.le.(1.-near))   .or.(a%z/init%dgw.le.(1.-near))) then 
!$omp atomic
		nphot=nphot + 1
		call locat(dirthet,(init%nthet+1),abs(d%z),jth_local)
                if(jth_local .le.0) jth_local = 1     !RS new
                if (jabs.gt.0 .or. jjf_local .eq.0) then
!$omp atomic
                        iphd(jf_local,jth_local) = iphd(jf_local,jth_local) + 1
                        if(a%x/init%dgw.le.(1.-near)) then
!$omp atomic
                              iphd0(jf_local,1) = iphd0(jf_local,1) + 1
                        endif
                        if(a%y/init%dgw.le.(1.-near)) then
!$omp atomic
                              iphd0(jf_local,2) = iphd0(jf_local,2) + 1
                        endif
                        if(a%z/init%dgw.le.(1.-near)) then
!$omp atomic
                              iphd0(jf_local,3) = iphd0(jf_local,3) + 1
                        endif
                        if(a%x/init%dgw.ge.(near*init%nx)) then
!$omp atomic
                              iphdmax(jf_local,1) = iphdmax(jf_local,1) + 1
                        endif
                        if(a%y/init%dgw.ge.(near*init%ny)) then
!$omp atomic
                              iphdmax(jf_local,2) = iphdmax(jf_local,2) + 1
                        endif
                        if(a%z/init%dgw.ge.(near*init%nz)) then
!$omp atomic
                              iphdmax(jf_local,3) = iphdmax(jf_local,3) + 1
                        endif
		else 
!$omp atomic
                        iphs(jjf_local,jth_local) = iphs(jjf_local,jth_local) + 1
                        if(a%x/init%dgw.le.(1.-near)) then
!$omp atomic
                              iphs0(jjf_local,1) = iphs0(jjf_local,1) + 1
                        endif
                        if(a%y/init%dgw.le.(1.-near)) then
!$omp atomic
                              iphs0(jjf_local,2) = iphs0(jjf_local,2) + 1
                        endif
                        if(a%z/init%dgw.le.(1.-near)) then
!$omp atomic
                              iphs0(jjf_local,3) = iphs0(jjf_local,3) + 1
                        endif
                        if(a%x/init%dgw.ge.(near*init%nx)) then
!$omp atomic
                              iphsmax(jjf_local,1) = iphsmax(jjf_local,1) + 1
                        endif
                        if(a%y/init%dgw.ge.(near*init%ny)) then
!$omp atomic
                              iphsmax(jjf_local,2) = iphsmax(jjf_local,2) + 1
                        endif
                        if(a%z/init%dgw.ge.(near*init%nz)) then
!$omp atomic
                              iphsmax(jjf_local,3) = iphsmax(jjf_local,3) + 1
                        endif
                end if
		icheck_leave = 1
        end if	
        end if

end function icheck_leave

!
! ----------------------------
!
function iget_mrw(lp_local,ldiff,r0)
! Check ob MRW (Robitalill2 2010) needed:
! iget_mrw=0=>no, iget_mrw=1=> Yes:= tau_MRW > 10.
!
use parameter
use constants
         implicit none
         integer           :: lp_local, iget_mrw, ldiff
         real*8            :: r0, tau_MRW
         real*8, parameter :: gdiff  = 5. ! gamma, Eq.23 Robitaille 2010

        tau_MRW   =  r0*dicht(lp_local)*c_ross(ldiff)
        if(tau_MRW .ge. gdiff) then           
           iget_mrw = 1 
        else
           iget_mrw = 0
        end if 
end function iget_mrw
!
! -----------------------------------------------------------------
!

function get_direction(ran1,ran2)
use type_module
use constants
        implicit none
	real*8                  :: mu,sinthet,phi
        real*8,intent(in)       :: ran1,ran2
        type(float_vector)      :: get_direction,e

        mu      = -1.0 + 2.0 * ran1
        sinthet = sqrt(1.0 - mu*mu)
        phi	= 2.0 * pi * ran2
        e%x    = sinthet * cos(phi)
        e%y    = sinthet * sin(phi)
        e%z    = mu
	
        if (abs(e%x).lt.1e-10)   e%x = 1e-10
        if (abs(e%y).lt.1e-10)   e%y = 1e-10
        if (abs(e%z).lt.1e-10)   e%z = 1e-10

	get_direction = e
end function get_direction
!
! -----------------------------------------------------------------
!

function get_sca_dir(ran1,ran2,d,g)
use type_module
use constants
        implicit none
	real*8                  :: mu,sinthet,phi,f,step,beta,azimuth,cosphi,sinphi,sinbeta, &
& magnid,magnid1
        real*8,intent(in)       :: ran1,ran2,g
        type(float_vector)      :: get_sca_dir,e,d

if(g .lt. 1e-20 .and. g .gt. -1e-20) then !inverted function in elseif case has singularity at g = 0
   beta = -1.0 + 2.0*ran1
elseif(g .gt. -1 .and. g .lt. 1) then !inverted function derived by explicitly solving integral of H-G phase function, then re-arranging for cos(beta). Fails at g=0
   beta = (1-g**2)/(1+g*((2*ran1) - 1))
   beta = beta*beta
   beta = 1 + g*g - beta
   beta = beta/(2*g)
else
   stop 'g outside allowed range'
endif

         azimuth = 2.0 * pi * ran2
         if (beta .ge. 1) then
            sinbeta = 0.
            beta = 1
         else
         sinbeta = sqrt(1.0 - beta*beta)
         endif

!        mu      = -1.0 + 2.0 * ran1
        mu = d%z
        sinthet = sqrt(1.0 - mu*mu)
        if(sinthet .eq. 0) then !protect against infinities/NaNs when d = [0,0,1]
           cosphi = 1.
           sinphi = 0.
        else
           cosphi = d%x/sinthet
           sinphi = d%y/sinthet
        endif
	
        !rotate old direction to new direction
        e%x = cosphi*(sinthet*beta - mu*sinbeta*cos(azimuth)) - sinphi*sinbeta*sin(azimuth)
        e%y = sinphi*(sinthet*beta - mu*sinbeta*cos(azimuth)) + cosphi*beta*sin(azimuth)
        e%z = mu*beta + sinthet*sinbeta*cos(azimuth)


!ensure vector is unit magnitude
           magnid = sqrt(e%x*e%x + e%y*e%y + e%z*e%z) 
           if(magnid .gt. (1+1e-10) .or. magnid .lt. (1-1e-10)) then
           e%x = e%x/magnid
           e%y = e%y/magnid
           e%z = e%z/magnid
           magnid = sqrt(e%x*e%x + e%y*e%y + e%z*e%z)
!           if( sqrt((e%x*e%x)+(e%y*e%y)+(e%z*e%z)) .gt. 1) print*,magnid,e,'|e| > 1'
           endif
        if (abs(e%x).lt.1e-10)   e%x = 1e-10
        if (abs(e%y).lt.1e-10)   e%y = 1e-10
        if (abs(e%z).lt.1e-10)   e%z = 1e-10
!        if(abs(e%x).gt.(1+1e-10)) stop '|x| > 1'! should never occur
!        if(abs(e%y).gt.(1+1e-10)) stop '|y| > 1'
!        if(abs(e%z).gt.(1+1e-10)) stop '|z| > 1'

	get_sca_dir = e
end function get_sca_dir



!
! ------------------------------------------------------------------
!

subroutine absorb_lucy(init,jf_local,lp_local,taumax,tauabs,UWmass)
!----subroutine for regions of low optical depth ------------------
!------allows for part of a packet to be absorbed -----------------

use type_module
use constants
use parameter
         implicit none
         type(init_type),intent(in) :: init
         integer,intent(in) :: jf_local
         integer,intent(in) :: lp_local
         real*8,intent(in) :: taumax
         real*8,intent(in) :: tauabs
         real*8,intent(in) :: UWmass
         integer :: scale,jl,kl,scaleabs
         real*8 :: fracSi,FracC,Eabsz,QsBip,sumQsBip,fak
         
         fracSi = C_abs_si(jf_local)/(C_abs_si(jf_local) + C_abs_ac(jf_local))
         fracC = C_abs_ac(jf_local)/(C_abs_si(jf_local) + C_abs_ac(jf_local))
         scale = int(1000/taumax) !sets scale factor for absorption.

         if(fracSi .gt. 1d-20) then
         scaleabs = int((scale * (1 - exp(((-1)*tauabs))) * fracSi))
!$omp atomic
         nabssi(lp_local) = nabssi(lp_local) + scaleabs
         endif



         if(fracC .gt. 1d-20) then
         scaleabs = int((scale * (1 - exp((-1)*tauabs)) * fracC))
!$omp atomic
         nabsc(lp_local) = nabsc(lp_local) + scaleabs
         endif




end subroutine absorb_lucy

!
! ------------------------------------------------------------------
!

subroutine absorption(init,jf_local,UWmass,ran1,ran2,lp_local,taumax)

! 6.3  Absorption im UW lp durch aC oder Si
! 6.3.1  Absorption durch Si und Erwärmung auf T_Si
!         und Frequenz jf der Reemission durch Silikate vom Zufallsgenerator
! 6.3.2  ...    dann analog f. aC grains

use type_module
use constants
use parameter
        implicit none
        type(init_type) :: init
        integer         :: jf_local
        real*8          :: UWmass,ran1,ran2
        real*8          :: fak,fak2,Eabsz,QsBip,sumQsBip,taumax
        integer         :: kl,jl,lp_local,scale

       if(taumax .le. 1e-2) then
           scale = int(1000/taumax)
       else
           scale = 1
       endif

! 6.3  Absorption im UW lp durch aC oder Si
	fak2 = c_abs_si(jf_local) / (c_abs_ac(jf_local) + c_abs_si(jf_local))

! 6.3.1  Absorption durch Si und Erwärmung auf T_Si und Frequenz jf der 
!        Reemission durch Silikate vom Zufallsgenerator

  if (fak2.ge.ran1) then 
!$omp atomic
 	 nabssi(lp_local)=nabssi(lp_local) + scale
	     if(taumax .le. 1e-2)then
	        Eabsz = ((dble(nabssi(lp_local))/dble(scale))-0.5)*init%epak/(4*pi*UWmass)
	     else
	        Eabsz = (nabssi(lp_local)-0.5)*init%epak/(4*pi*UWmass)
	     endif

	 call locat(QBsi,init%ntg,Eabsz,jl)
	 if (jl.lt.1) jl=1
	 if (jl.ge.init%ntg) jl=init%ntg-1
         Tsi(lp_local) = Td(jl) + &
&        (Td(jl+1)-Td(jl))/(QBsi(jl+1)-QBsi(jl))*(Eabsz-QBsi(jl))

	 fak = (Tsi(lp_local) - Td(jl)) / (Td(jl+1)-Td(jl))
 	 QsBip = QsBsi(jl) + fak*(QsBsi(jl+1) - QsBsi(jl)) 
	 kl=1
	 sumQsBip = sumQsBsi(jl,kl)+fak*(sumQsBsi((jl+1),kl) - sumQsBsi(jl,kl))

!  6.3.1.1  Frequenz jf der Reemission durch Silikate vom Zufallsgenerator
   do while (kl.le.init%nd.and.sumQsBip/QsBip.le.ran2)
	sumQsBip = sumQsBsi(jl,kl)+fak*(sumQsBsi((jl+1),kl) - sumQsBsi(jl,kl))
	jf_local = kl
	kl = kl +1
   end do


  else

! 6.3.2  Absorption durch aC und Erwärmung auf Tc

!$omp atomic
	nabsc(lp_local) = nabsc(lp_local) + scale
	     if(taumax .le. 1e-2)then
	        Eabsz = ((dble(nabsc(lp_local))/dble(scale))-0.5)*init%epak/(4*pi*UWmass)
	     else
	        Eabsz = (nabsc(lp_local)-0.5)*init%epak/(4*pi*UWmass)
	     endif

	call locat(QBc,init%ntg,Eabsz,jl)
	if (jl.lt.1) jl=1
	if (jl.ge.init%ntg) jl=init%ntg -1
	Tc(lp_local) = Td(jl) + &
&         (Td(jl+1)-Td(jl))/(QBc(jl+1)-QBc(jl))*(Eabsz-QBc(jl))
	fak = (Tc(lp_local) - Td(jl)) / (Td(jl+1)-Td(jl))
	QsBip = QsBc(jl) + fak*(QsBc(jl+1) - QsBc(jl))
	kl=1
	sumQsBip = sumQsBc(jl,kl)+fak*(sumQsBc((jl+1),kl) - sumQsBc(jl,kl))

!  6.3.2.1  Frequenz jf der Reemission durch aC vom Zufallsgenerator
    do while (kl.le.init%nd.and.sumQsBip/QsBip.le.ran2)
	sumQsBip = sumQsBc(jl,kl)+fak*(sumQsBc((jl+1),kl) - sumQsBc(jl,kl))
	jf_local = kl
	kl = kl + 1
    end do
   end if 
end subroutine absorption


!
! ----------------------
!



subroutine check_near_border_GW(a,iGW,s,init)
!
!  1.  Bestimme GW (ia,ja,ka) und (sxa,sya,sza) des AP (xa,ya,za)
!      Liegt AP auf einer Fläche x=const eines GW:  s%x = 1,  
!                                            sonst  s%x = 0
!      Liegt AP ganz nahe (< 1d-5*dGW) einer Fläche x=const eines GW,
!      so wird AP auf diese Fläche verschoben und s%x=1 gesetzt.  
!

use type_module
        implicit none
        type(float_vector)      :: a
        type(int_vector)        :: iGW,s
        type(init_type)         :: init
        real*8,parameter        :: near=1e-5
	real*8                  :: fak
	integer                 :: nfak
	
	fak = a%x / init%dgw
	nfak = nint(fak) + 1
	if (abs(a%x-init%dgw*(nfak-1)).lt.near) then 
		s%x	= 1
		iGW%x	= nfak
		a%x	= (nfak-1)*init%dgw
	else 
		s%x	= 0
		iGW%x  =  a%x/init%dgw + 1
	end if 

	fak = a%y / init%dgw
	nfak = nint(fak) + 1
	if (abs(a%y-init%dgw*(nfak-1)).lt.near) then 
		s%y	= 1
		iGW%y	= nfak
		a%y	= (nfak-1)*init%dgw
	else 
		s%y	= 0
		iGW%y  =  a%y/init%dgw + 1
	end if

	fak = a%z / init%dgw
	nfak = nint(fak) + 1
	if (abs(a%z-init%dgw*(nfak-1)).lt.near) then 
		s%z	= 1
		iGW%z	= nfak
		a%z	= (nfak-1)*init%dgw
	else 
		s%z	= 0
		iGW%z  =  a%z/init%dgw + 1
	end if

! Wgen Ecken : AP kann aber nur auf einer GW-Fläche liegen:  
! falls sxa=1, ist sya=sza=0, etc. Wenn sxa=1 und 
! AP ganz nahe (< 1d-5*dGW) einer Fläche y=const eines GW...

	if (s%x==1.and.s%y==1) s%y=0
	if (s%x==1.and.s%z==1) s%z=0
	if (s%y==1.and.s%z==1) s%z=0

end subroutine check_near_border_GW


!
! ------------------------------------------------------------------
!

subroutine get_EP(a,e,d,iGW,s,init)

!  2.    Bestimme (tx,ty,tz).  AP liegt nicht auf einer Fläche eines GW, 
!        die Bahn bleibt also noch im GW
!  Liegt AP ganz in der Nähe (< 1d-6*dUW) einer Fläche x=const eines UW,  
!  so wird AP auf diese Fläche des UW verschoben.
!  AP kann dabei nicht auf die Fläche eines GW zu liegen kommen, da sein 
!  Abstand von der nächsten Fläche eines GW größer ist als 1d-6*dUW.
!  3.    Bestimme (tx,ty,tz).  AP liegt auf Fläche eines GW
!   Bahn verläßt GW, wenn s%x = 1 und d%x < 0 (sya=1, dy<0 oder sza=1, dz<0)
!  3.1   AP liegt auf Fläche x = const eines GW, also sxa = 1
!  3.2   AP liegt auf Fläche y = const eines GW, also sya = 1
!  3.3   AP liegt auf Fläche z = const eines GW, also sza = 1
! Notation : a = AP , e = EP, d=Einheitsvektor der Richtung
!  Input:  a, init, d, iGW, s
!  Output: Endpunkt, e, in Flugrichtung im GW


use type_module
use parameter
use constants
        type(float_vector)      :: a,e,d
        type(int_vector)        :: iGW,s
        type(init_type)         :: init
	real*8                  :: dUW,tt,tx,ty,tz,fak
	integer                 :: ixyz,nfak
        real*8,parameter        :: near = 1d-5

! AP liegt nicht auf einer Fläche eines GW:

    if (s%x.eq.0.and.s%y.eq.0.and.s%z.eq.0) then 

		dUW = init%dgw / netz(iGW%x,iGW%y,iGW%z)
		fak = (a%x-(iGW%x-1)*init%dgw)/dUW
		nfak = nint(fak)
 	 if (abs(fak-nfak).lt.near) then 
			a%x = (iGW%x-1)*init%dgw+nfak*dUW
			tx = dUW / abs(d%x)

	 else
	  if(d%x.gt.0) tx = ((iGW%x-1)*init%dgw+(int(fak) + 1)*dUW-a%x)/d%x
	  if(d%x.lt.0) tx = ((iGW%x-1)*init%dgw+(int(fak))*dUW-a%x)/d%x

	end if

  	fak = (a%y-(iGW%y-1)*init%dgw)/dUW
	nfak = nint(fak)
	if (abs(fak-nfak).lt.near) then 
		a%y = (iGW%y-1)*init%dgw+nfak*dUW;
		ty = dUW / abs(d%y);

	else
		if (d%y.gt.0) ty = ((iGW%y-1)*init%dgw+(int(fak) + 1)*dUW-a%y)/d%y
		if (d%y.lt.0) ty = ((iGW%y-1)*init%dgw+(int(fak))*dUW-a%y)/d%y

        end if

	fak = (a%z-(iGW%z-1)*init%dgw)/dUW
	nfak = nint(fak)
	if (abs(fak-nfak).lt.near) then 
		a%z = (iGW%z-1)*init%dgw+nfak*dUW;
		tz = dUW / abs(d%z);

	else
		if (d%z.gt.0) tz = ((iGW%z-1)*init%dgw+(int(fak) + 1)*dUW-a%z)/d%z;
		if (d%z.lt.0) tz = ((iGW%z-1)*init%dgw+(int(fak))*dUW-a%z)/d%z;

        end if
    end if

!  3.1   AP liegt auf Fläche x = const eines GW, also sxa = 1
	if (s%x.eq.1) then 
  	 if (d%x.ge.0) then 
		dUW = init%dgw / netz(iGW%x,iGW%y,iGW%z)
          else
		dUW = init%dgw / netz(iGW%x-1,iGW%y,iGW%z)
	 end if
	 tx = dUW / abs(d%x)
	 fak = (a%y-(iGW%y-1)*init%dgw)/dUW
	 nfak = nint(fak)
	 if (d%y.gt.0) ty = ((iGW%y-1)*init%dgw+(int(fak) + 1)*dUW-a%y)/d%y
	 if (d%y.lt.0) ty = ((iGW%y-1)*init%dgw+(int(fak))*dUW-a%y)/d%y
	 if (abs(fak-nfak).lt.near) ty = dUW/abs(d%y)

	 fak = (a%z-(iGW%z-1)*init%dgw)/dUW
	 nfak = nint(fak)
	 if (d%z.gt.0) tz = ((iGW%z-1)*init%dgw+(int(fak) + 1)*dUW-a%z)/d%z
	 if (d%z.lt.0) tz = ((iGW%z-1)*init%dgw+(int(fak))*dUW-a%z)/d%z
	 if (abs(fak-nfak).lt.near) tz = dUW/abs(d%z)
	end if

! 3.2   AP liegt auf Fläche y = const eines GW, also sya = 1
        if (s%y.eq.1) then 
	 if (d%y.ge.0) then 
		dUW = init%dgw / netz(iGW%x,iGW%y,iGW%z)
         else
		dUW = init%dgw / netz(iGW%x,iGW%y-1,iGW%z)
	 end if
	 ty = dUW / abs(d%y)
	 fak = (a%x-(iGW%x-1)*init%dgw)/dUW
	 nfak = nint(fak)
	 if (d%x.gt.0) tx = ((iGW%x-1)*init%dgw+(int(fak) + 1)*dUW-a%x)/d%x
	 if (d%x.lt.0) tx = ((iGW%x-1)*init%dgw+(int(fak))*dUW-a%x)/d%x
	 if (abs(fak-nfak).lt.near) tx = dUW/abs(d%x)
	 fak = (a%z-(iGW%z-1)*init%dgw)/dUW
	 nfak = nint(fak)
	 if (d%z.gt.0) tz = ((iGW%z-1)*init%dgw+(int(fak) + 1)*dUW-a%z)/d%z
	 if (d%z.lt.0) tz = ((iGW%z-1)*init%dgw+(int(fak))*dUW-a%z)/d%z
	 if (abs(fak-nfak).lt.near) tz = dUW/abs(d%z)
        end if

!   3.3   AP liegt auf Fläche z = const eines GW, also sza = 1
	if (s%z.eq.1) then 
	 if (d%z.ge.0) then 
		dUW = init%dgw / netz(iGW%x,iGW%y,iGW%z)
         else
		dUW = init%dgw / netz(iGW%x,iGW%y,iGW%z-1)
	 end if
	 tz = dUW / abs(d%z)
	 fak = (a%x-(iGW%x-1)*init%dgw)/dUW
	 nfak = nint(fak)
	 if (d%x.gt.0) tx = ((iGW%x-1)*init%dgw+(int(fak) + 1)*dUW - a%x)/d%x
	 if (d%x.lt.0) tx = ((iGW%x-1)*init%dgw+(int(fak))*dUW - a%x)/d%x
	 if (abs(fak-nfak).lt.near) tx = dUW/abs(d%x)
	 fak = (a%y-(iGW%y-1)*init%dgw)/dUW
	 nfak = nint(fak)
	 if (d%y.gt.0) ty = ((iGW%y-1)*init%dgw+(int(fak) + 1)*dUW-a%y)/d%y
	 if (d%y.lt.0) ty = ((iGW%y-1)*init%dgw+(int(fak))*dUW-a%y)/d%y
	 if (abs(fak-nfak).lt.near) ty = dUW/abs(d%y)
	end if

!  4. Bestimme EP (xe,ye,ze)
	tt  = min(min(tx,ty),tz)
	e%x = max(0.0,a%x+d%x*tt)
	e%y = max(0.0,a%y+d%y*tt)
	e%z = max(0.0,a%z+d%z*tt)

end subroutine get_EP


!
! ------------------------------------------------------------------
!

function get_lp(iGW,iUW)
use type_module
use parameter
        implicit none
        type(int_vector)        :: iGW,iUW
        integer                 :: netz_tmp
        integer                 :: netsum_tmp
        integer                 :: get_lp
        netz_tmp = netz(iGW%x,iGW%y,iGW%z)
        netsum_tmp = netsum(iGW%x,iGW%y,iGW%z)
        get_lp = netsum_tmp - netz_tmp**3 + netz_tmp**2*(iUW%x-1) + netz_tmp*(iUW%y-1) + (iUW%z)
end function get_lp

! -----------------------------------------
function get_UW(a,e,init)
use type_module
use parameter
        implicit none
        integer                 :: get_lp
	integer                 :: get_UW
        type(float_vector)      :: a,e,xm
        type(int_vector)        :: iGW,iUW
        type(init_type)         :: init
        real*8                  :: dUW

	xm%x = (a%x+e%x)/2.0
	xm%y = (a%y+e%y)/2.0
	xm%z = (a%z+e%z)/2.0
	iGW%x =int((xm%x/init%dgw)) + 1
	iGW%y =int((xm%y/init%dgw)) + 1
	iGW%z =int((xm%z/init%dgw)) + 1
	dUW = init%dgw / netz(iGW%x,iGW%y,iGW%z)
	iUW%x = int(((xm%x-(iGW%x-1)*init%dgw) / dUW)) + 1
	iUW%y = int(((xm%y-(iGW%y-1)*init%dgw) / dUW)) + 1
	iUW%z = int(((xm%z-(iGW%z-1)*init%dgw) / dUW)) + 1
        get_UW = get_lp(iGW,iUW)
end function get_UW

!
! ------------------------------------------------------------------
!

function shift_AP(a,d,ds)
use type_module
use parameter
!
! Shift AP by distance ds in direction d
!
        implicit none
        type(float_vector)      :: a,a_old, d, shift_AP
        real*8                  :: ds
        a_old = a

        a%x = a_old%x + ds*d%x
        a%y = a_old%y + ds*d%y
        a%z = a_old%z + ds*d%z

        shift_AP = a
end function shift_AP

!
! -----------------------------------------------
!
function get_r0diff(a,iGW,init,s1)

use type_module
use parameter
use constants
        type(float_vector)      :: a,e1,d1
        type(int_vector)        :: iGW,s1
        type(init_type)         :: init
	real*8                  :: dUW,tt,tx,ty,tz,fak
	integer                 :: ixyz,nfak
        real*8                  :: ds, r0, get_r0diff
!if(isnan(a%x)) print*,'isnan(a) r0 start',a

!       s1%x = 0 
!       s1%y = 0 
!       s1%z = 0 
!
! Computes minimal distance r0 from interaction point to cell wall
! R0 is used in the diffusion approximation.
! Verwende 6 mal get_EP mit Richtungsvektoren d1=(1,0,0), d2=(-1,0,0), ...
! d6 =(0,0,-1). Und brechne zu den 6 d_i das minimum :
! r0 = min|a-e_i|, i=1,..,6. Zur sicherheit setzte s=0 bei call zu get_EP.
! ds = Weglänge vom AP (xa,ya,za) zum EP (xe,ye,ze)

!!$if((min(min(iGW%x,iGW%y),iGW%z) .lt.1)) then
!!$   print*,'r0_diff ',a,' ',s1,' ',iGW
!!$endif

        d1%x = 1 
        d1%y = 0 
        d1%z = 0

	call get_EP(a,e1,d1,iGW,s1,init)

ds1 = sqrt((a%x-e1%x)*(a%x-e1%x)+(a%y-e1%y)*(a%y-e1%y)+(a%z-e1%z)*(a%z-e1%z))

        d1%x = -1 
        d1%y = 0 
        d1%z = 0
	call get_EP(a,e1,d1,iGW,s1,init)
ds2 = sqrt((a%x-e1%x)*(a%x-e1%x)+(a%y-e1%y)*(a%y-e1%y)+(a%z-e1%z)*(a%z-e1%z))

        d1%x = 0 
        d1%y = 1
        d1%z = 0
	call get_EP(a,e1,d1,iGW,s1,init)
ds3 = sqrt((a%x-e1%x)*(a%x-e1%x)+(a%y-e1%y)*(a%y-e1%y)+(a%z-e1%z)*(a%z-e1%z))

        d1%x = 0 
        d1%y = -1 
        d1%z = 0
	call get_EP(a,e1,d1,iGW,s1,init)
ds4 = sqrt((a%x-e1%x)*(a%x-e1%x)+(a%y-e1%y)*(a%y-e1%y)+(a%z-e1%z)*(a%z-e1%z))

        d1%x = 0 
        d1%y = 0
        d1%z = 1
	call get_EP(a,e1,d1,iGW,s1,init)
ds5 = sqrt((a%x-e1%x)*(a%x-e1%x)+(a%y-e1%y)*(a%y-e1%y)+(a%z-e1%z)*(a%z-e1%z))

        d1%x = 0 
        d1%y = 0 
        d1%z = -1
	call get_EP(a,e1,d1,iGW,s1,init)
ds6 = sqrt((a%x-e1%x)*(a%x-e1%x)+(a%y-e1%y)*(a%y-e1%y)+(a%z-e1%z)*(a%z-e1%z))

        r0  = min(min(ds1, ds2), ds3)

        r0  = min(min(min(ds4, ds5), ds6), r0)

        get_r0diff = r0

!       print*, 'dUW = ', (init%dgw/netz(iGW%x,iGW%y,iGW%z))
!       write(6,'(1p6e11.3, a10)') ds1,ds2,ds3,ds4,ds5,ds6,  '= ds1..ds6'
!       print*, 'r0 = ', r0

end function get_r0diff
!
! -----------------------------------------------
!
subroutine traceopenmp(init)
!
! Berechne Start und Angangspkt. und rufe f. jedes packet go_trace auf.
! In go_trace wird der weg eines Packets durch die gesamte Wolke verfolgt.
!
use type_module
use parameter
use constants
use omp_lib
        real*8,external         :: bpl
	integer                 :: nUW,hit_ac,hit_si,n_zero_cells_ac,n_zero_cells_si
        type(init_type)         :: init
        integer                 :: isze, modprint
        integer                 :: jsca,num
        integer                 :: jjf, jjf_local,jf_local
        type(float_vector)      :: a,d
        type(float_vector)      :: get_direction
        real*8                  :: ran1,ran2

!        call omp_set_num_threads(1)

	n_zero_cells_si = 0;
	n_zero_cells_ac = 0;
	hit_si = 0;
	hit_ac = 0;
        nUW = netsum(init%nx,init%ny,init%nz)

 69     format(2x,i2,a3,1x,i2, 4x, f7.3,2x,i12,1x,i8,4x,f8.1)
        print*, ' Method: Bjorkman & Wood (2003)'
        print*, '  progress    micron     #UW_noabs    #PAH_abs  Tmax [K]'
        modprint = 10
 !       if(init%nf .ge. 2000) modprint = 30
        iabsgas = 0
        do jjf=init%nf,1,-1
           if(jjf .gt. init%nf-5) then
              write(6,69) 0, '/',modprint, & 
&             welmu(jjf), n_zero_cells_si+n_zero_cells_ac, ispah, Tmax
           else 	
             if (init%nf.gt.modprint) then 
              if (mod(jjf,init%nf/modprint).eq.0) then
               write(6,69) 1+modprint-jjf/(init%nf/modprint),'/',modprint, &
&              welmu(jjf),n_zero_cells_si+n_zero_cells_ac, ispah, Tmax
               endif
             endif
           endif

! 
! --------------------------
!$omp parallel do firstprivate(init,a,d,jf_local,jjf_local,ran1,ran2,jjf,jsca)
           do izyk=1,ivnzyk(jjf)
              jsca = 0
              a%x = xorg
              a%y = yorg
              a%z = zorg
              if (old_random.eq.1) then 
                 call random_number(ran1) ! wie rand F90 standard aber langsamer
                 call random_number(ran2) ! wenn mehr als 1 threat
              else
                 ran1 = get_random(omp_get_thread_num()) ! besser, schnellere Zufalszahl.
                 ran2 = get_random(omp_get_thread_num())
              end if
!
! Paket wird vom Stern emittiert. Bedinging abs(d) damit es in 
! Oktant abgestrahtl wird
              d = get_direction(ran1,ran2)
              if (init%idim3.ne.1) then
                 d%x = abs(d%x)
                 d%y = abs(d%y)
                 d%z = abs(d%z)
              endif
              jf_local = jd(jjf)  ! freq bezgl. staub
              jjf_local = jjf     ! freq bezgl. stern
              
              call go_trace(init,jf_local,jjf_local,a,d,jsca)

           end do
!$omp end parallel do


! ---------
! Fuer jede Zelle berechne dieAnzahl der Absorbtionen von Si und ac: hit_* 
! und entsprechend Zellen ohne absobrtionen n_zero_cells_ (falls gross ungenaues Ergebnis)
           n_zero_cells_si = 0
           n_zero_cells_ac = 0
           hit_si = 0
           hit_ac = 0
           do i=1,nUW
              hit_si = hit_si + nabssi(i)
              hit_ac = hit_ac + nabsc(i)
              if (nabssi(i).eq.0.and.dicht(i)*init%SImass.ne.0) n_zero_cells_si = n_zero_cells_si + 1
              if (nabsc(i).eq.0.and.dicht(i)*init%ACmass.ne.0)  n_zero_cells_ac = n_zero_cells_ac + 1
           end do
	end do

        print*,' Number of photons in gas: ',iabsgas
        hit_si=0
        do i=1,isumuw
          if (inopah(i).eq.1) hit_si = hit_si +1
        end do
        print*,' Number of X-ray destructions:',hit_si

end subroutine traceopenmp

!
! --------------------------------------------------------------------------------------
!
subroutine go_trace(init,jf_local,jjf_local,a,d,jsca)
!
! Behandlung eines Pakets emittiert direkt vom Stern bis 
!                               'Ade Du schöne Wolke'
! Notation: 
! a = Anfangspunkt (AP): Wenn Paket in einen neuen UW kommt liegt AP
!    erstmal auf einer seiner Seitenwaende und dannach bei dem
!    Interaktionspunkt (ds_cell).
! e = Endpunkt: EP liegt immer auf einer Wand desselben UW wie AP und
!    ergibt sich als Durchstoßpunkt der Geraden vom AP und Richtung des
!    Pakets.
! d = Richtung der Pakets (Einheitsvektor).
!
! Externals: (a-g)
! -a- check_near_border_GW():
! Bestimme GW und ob AP auf einer KAnte oder Fläche x=const eines GW 
! liegt, falls AP sehr nahe einer solchen kante/Fläche verschiebe AP 
! auf diese; setze in dem Fall s%x=1 sonst ist s%x=0.
!
! -b- icheck_leave():
! Paket verläßt Wolke bei icheck_leave=1
! Bestimme ob neuer AP außerhalb der Wolke liegt.
!
! -c- get_EP():
! Bestimmung von EP aus Bahn des Pakets von AP a und Richtung d.
! EP liegt im gleichen UW wie AP.
! EP bleibt im UW falls s%x =0, wieder verschieben von a 
!          auf Fläche eines UW falls a nahe dieser Fläche liegt 
! EP außerhalb UW falls s%x=1 und d%x <0
!
! -d- Absorption():
!  i)   Wird Paket durch aC oder Si grain absorbiert
!  ii)  Erhöhung der aC(Si)- Temperatur im UW
!  iii) Berechnung neuer Frequenz 
!
! -e- get_UW():
! Bestimmung des UW (lp, UW-Koordinaten)
! auss halber Bahn des Paketes von AP bis EP.
! Halbe Strecke  (a+e)/2 da falls a und e Punkte auf den Wuerfelkanten 
! beschreiben es zu numerischen Ungenauigkeiten kommen kann.
! Beispiel: bei 1.999999 und 3.00001 ist der richtige Wuerfel bei zwei.
!
! -f- get_lp(): 
! Bestimmung von lp aus Koordinaten des UW
!
! -g-get_direction()
! Würfle neue Richtung d
!
! -h- call mrw() : Teste ob diffusion Approximation gilt, 
!                  falls ja berechne ds_cell, jf_local 
! ------------------------------------
! Logische Reihenfolge von go_trace():
!
! 1) Bestimme Variable:
!    a)   e     = EP im UW lp_local
!    b)   ds    = Weglaenge von |a-e| 
!    c) Prüfe ob Paket noch in der Wolke ist, falls ja
!    d) UWmass= Masse des UW der auf der halben Wegstrecke
!                 von AP bis EP liegt [durch get_UW()]. 
!    e) Albedo, taus  = dicht*Kappa* ds
!
!    f) kommt es zur WW mit Gas?
!    g) Gilt diffusion Approxi., falls ja (imrw=1) setzte ds_cell=R0
! 2) Kommt es zur interaktion mit Staub?
!    Ja, falls taus > -ln(zufall) und keine WW mit Gas und
!    diff Aprox ist nicht erfuellt, dann:
!  i)   Interaktionspunkt nach Strecke:
!       ds_cell *dicht*Kappa = -ln(Zufall)
!  ii)  Albedo > Zufall: dann    Streuung
!                        sonst   Absorption
!                (uncomment the return below at "6.2  ..else"-statement 
!                 when  computing only the effective extinction curve!)
!  iii) Bestimmung neuer AP:
!       Falls ds_cell < ds dann  wird Interaktionspunkt neuer AP imselben UW
!       sonst wird EP neuer AP (und je nach Richtung geht paket in neuen UW
!  iv)  Würfle neue Richtung
!
! 3) Sonst keine Interaktion, 
!    dann fliegt Paket einfach weiter und 
!    e wird neuer AP mit gleicher Richtung, d.h. Paket verlaest den UW.
!
! 4) Prüfe ob neuer AP auf/nahe einer Fläche eines UW liegt
! -------------------
!
use parameter
use constants
use type_module
use omp_lib
        implicit none
        type(init_type)         :: init
        type(int_vector)        :: iGW,s
        type(float_vector)      :: e,a,d,d1,shift_AP
        type(float_vector)      :: get_direction,get_sca_dir

        integer                 :: icheck_leave, get_UW
        integer                 :: iiabspah, iiabsgas
        integer                 :: nabssiold, scacount,cc
        integer                 :: jjf, jjf_local,jf_local,jf_old,lp_local,lpold
        integer                 :: jabs,jsca,index, l, ltc, ltsi, imrw,num
        integer        :: ldiff ! mean temperature intervall in diff sph.
        real*8,parameter       :: near = 0.99999
        real*8         :: ds,ds_cell,taus,albedo, Ediff
        real*8         :: c_ext,c_extV,UWmass, gion, tausV, tauVtot
        real*8         :: ran1,ran2,ran3
        real*8         :: Ephot, Tm, Eabscz, Eabssiz, fak
        real*8         :: r0, get_r0diff, tau_mrw
        real*8         :: tsiold
        real*8         :: taumax
        real*8         :: tauabs,sca_ratio
        real*8         :: dUW,g_local

!
! --------------------------------
!  jf_loc bezgl. Gitter vom Staub
! jjf_loc bezgl. Gitter vom Stern
!        jf_local = jd(jjf)
!
	jabs = 0
	jsca = 0
        iiabspah=0
        iiabsgas=0
	cc=0
! Gas:
        tauVtot = 0d0
        gion    = 1.d0
!       20eV < photon energie <300eV => 50%  gas ionisiert sonste 
!        if(hwirk*fd(jf_local)/eVolt .ge. 20.)   then
!            gion = 1.d0 !0.5d0
!        else
!           gion  = 0.01d0 ! 0.d0
!        endif
! --------------
!  1.  Bestimme GW und ob AP auf einer Fläche x=const eines GW liegt

       call check_near_border_GW(a,iGW,s,init)

! --------------------------------------------------
! vom Stern durch alle Wuerfel bis 'ade du schoene wolke oder in PAH od. Gas:
! Paket verläßt Wolke bei icheck_leave=1:
! Bestimmung Endpunkt der Bahn des Pakets:
! AP liegt nicht auf Fläche eines UW-> Bahn bleibt noch im UW:s%{x,y,z}=0
! AP liegt       auf Fläche eines UW-> Bahn verläßt        UW:s%{x,y,z}=1
! a = Anfangspunkt (AP): Wenn Paket in einen neuen UW kommt liegt AP
!     erstmal auf einer seiner Seitenwaende und dannach bei dem
!     Interaktionspunkt (ds_cell).
! e = Endpunkt: EP liegt immer auf einer Wand desselben UW wie AP und ergibt
!     sich als Durchstoßpunkt der Geraden vom AP und Richtung des Pakets.
! d = Richtung der Pakets (Einheitsvektor).
! --------------------------------------------------
!
  do while(icheck_leave(a,d,jabs,jf_local,jjf_local,init).ne.1 &
&               .and.iiabspah.ne.1.and.iiabsgas.ne.1)

! sprung wegen imrw=1:
	cc = cc+1
  1000 continue


  if (init%idim3.ne.1) call mirror(a,d,init,iGW)

               	       call get_EP(a,e,d,iGW,s,init)

! 5.1   ds = Weglänge vom AP (xa,ya,za) zum EP (xe,ye,ze) im UW
	ds = sqrt((a%x-e%x)*(a%x-e%x)+(a%y-e%y)*(a%y-e%y)+(a%z-e%z)*(a%z-e%z))

!       Die Mitte des Weges vom AP zum EP hat die Koordinaten (iGW%x,..):
	iGW%x = (a%x + e%x)/2.0/init%dgw+1
	iGW%y = (a%y + e%y)/2.0/init%dgw+1
	iGW%z = (a%z + e%z)/2.0/init%dgw+1


!
! Falls Paket wirklich noch in der Wolke dann berechne:

	if (iGW%x<=init%nx.and.iGW%y<=init%ny.and.iGW%z<=init%nz.and.&
&           iGW%x>=1.and.iGW%y>=1.and.iGW%z>=1) then 

 	 lp_local = get_UW(a,e,init)
      	 UWmass = (init%dgw/netz(iGW%x,iGW%y,iGW%z))*dicht(lp_local)*&
&                 (init%dgw/netz(iGW%x,iGW%y,iGW%z))*&
&                 (init%dgw/netz(iGW%x,iGW%y,iGW%z));

! 5.2  Optische Tiefe, albedo vom AP zum EP bez. Staubfrequenz jf_local
        if (jpah.eq.0 .or. inopah(lp_local) .eq.1) then
            c_ext  = c_ext_si(jf_local) + c_ext_ac(jf_local)
            c_extV = c_ext_si(ivisd)    + c_ext_ac(ivisd)
         else
            c_ext  = c_ext_si(jf_local) + c_ext_ac(jf_local) + C_abs_pah(jf_local)
            c_extV = c_ext_si(ivisd)    + c_ext_ac(ivisd)    + C_abs_pah(ivisd)
        endif

	albedo = (c_sca_si(jf_local)+c_sca_ac(jf_local))/c_ext
	taus   = ds*dicht(lp_local)*c_ext
	tausV  = ds*dicht(lp_local)*c_extV                
        tauVtot= tauVtot + tausV
        dUW = (init%dgw/netz(iGW%x,iGW%y,iGW%z))
        taumax = dicht(lp_local) * dUW * (c_abs_si(iabs_max) + c_abs_ac(iabs_max)) !calculates optical depth along length of cell at frequency at which it is maximum
        tauabs = ds*dicht(lp_local)*(c_abs_si(jf_local) + c_abs_ac(jf_local))
        sca_ratio =  (C_sca_ac(jf_local)/(C_sca_ac(jf_local) + C_sca_Si(jf_local)))


!
! ------------
!  6.  Interaktion des Pakets im UW lp mit  Gas:
        if (jgas.eq.1) then 
          if (old_random.eq.1) then 
              call random_number(ran1)
          else
              ran1 = get_random(omp_get_thread_num())
          endif

!oberalb (tauVtot< 1) extinction layer -> gas ist teilweise ionisiert
         if (ds*dicht(lp_local)*((1.-gion)*c_gas(jf_local)).gt.-log(ran1) &
&           .and. tauVtot .lt. 1.) then
            iiabsgas=1
            iabsgas = iabsgas + 1
         endif
!unterhalb  (tauVtot> 1) extinction layer -> gas ist neutral
         if (ds*dicht(lp_local)*(c_gas(jf_local)).gt.-log(ran1) &
&           .and. tauVtot .ge. 1.) then
            iiabsgas=1
            iabsgas = iabsgas + 1
         endif
       endif
! ----- ende Gas WW
!
! Kommt es zur Wechselwirkung mit Staub?
! 6.0  MRW? Bei imrw=1 (=ja) dann goto1000 sonst:  
! 6.1  Streuung od. 6.2 Absorbtion.
! Wenn Variable zufall doppeltgenau, kommt es vor, obwohl höchst selten, 
! daß exakt zufall=1, daher Zusatzbedingung: taus .ge. 1d-9

       if (old_random.eq.1) then 
          call random_number(ran1)
        else
          ran1 = get_random(omp_get_thread_num())
       endif

            if(iiabsgas.ne.1 .and. taumax.le.1e-2 .and. taus>=1e-9)then !Lucy method
                 call absorb_lucy(init,jf_local,lp_local,taumax,tauabs,UWmass)
            endif

  if (iiabsgas.ne.1.and. taus>=-log(ran1).and.taus>=1e-9) then 


! 6.0 Diffusion approximation:
if(isnan(a%x)) print*,'isnan(a) pre MRW',a
       imrw = 0
       call mrw(lp_local,jf_local,init,iGW,UWmass,s,ds,a,d,e,imrw)
		if(isnan(a%x)) print*,'isnan(a) from MRW',a,cc
       if (imrw.eq.1) then
          if(ibug.ge.2) &
          write(6,'(3i4, 1p2e10.2, a20)') lp_local, lpold, &
&         jf_local, Tc(lp_local), Tsi(lp_local), ' =jf,Tc, Tsi'
         goto 1000
       endif

!      ds_cell ist Wegstrecke im Wuerfelelement bis zum Interaktionspunkt 
       ds_cell = -log(ran1)/dicht(lp_local)/c_ext

!  6.1 MRW gilt nicht also kommt es entweder zur Streuung oder zur
!      Absorbtion des Pakets im UW lp
         if (old_random.eq.1) then 
             call random_number(ran1)
         else
             ran1 = get_random(omp_get_thread_num())
         endif
!  6.1  Streuung 
     if (albedo>ran1) then 
   	 jsca = jsca + 1
!$omp atomic
 	 isca(lp_local) = isca(lp_local) + 1

         if(i_iso .gt. 0) then

           if(old_random.eq.1) then 
                call random_number(ran1) !beta
                call random_number(ran2) !alpha
                call random_number(ran3) !aC or Si
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
                ran3 = get_random(omp_get_thread_num())
               endif
               !check if scattering is aC or Si

            if(ran3 .gt. sca_ratio) then
               d1 = get_sca_dir(ran1,ran2,d,g_Si(jf_local))

            else
               d1 = get_sca_dir(ran1,ran2,d,g_aC(jf_local))

            endif
         endif
     else

!     Return   ! *** used for computing only the effective extinction curve

!  6.2  Absorption
	 jabs = jabs + 1
!$omp atomic
 	 iabs(lp_local) = iabs(lp_local) + 1

!
!  6.2a: Absorbtion  durch PAHs.  Paket muß vom Stern kommen.
! Varibale ifr speichert  im UW (lp) die Anzahl der absorbtion [iabs(lp)]
! des Photonpaketes durch PAH die Frequenz jf hat.
!$omp critical
         if (old_random.eq.1) then 
          call random_number(ran1)                 ! pah (yes/no)
         else
          ran1 = get_random(omp_get_thread_num())
         endif
       if(jpah .eq. 1 .and. jabs .eq. 1 .and.inopah(lp_local).eq.0) &
&        call pahabs(a,e,jf_local,UWmass,lp_local,ran1,iiabspah)



!  6.2b  Absorption im UW lp durch aC oder Si
        if (old_random.eq.1) then 
         call random_number(ran1)                 ! which aC or Si
         call random_number(ran2)                 ! which frequency
        else 
         ran1 = get_random(omp_get_thread_num())
         ran2 = get_random(omp_get_thread_num())
        endif
       jf_old = jf_local
       if (iiabspah.ne.1) then 
         if (init%iter.eq.0) &
&        call absorption(init,jf_local,UWmass,ran1,ran2,lp_local,taumax)
         if (init%iter.ne.0) &
&       call absorption_iter(init,jf_local,UWmass,ran1,ran2,lp_local)
         if (Tsi(lp_local)>Tmax) Tmax=Tsi(lp_local)
         if (Tc(lp_local)>Tmax) Tmax=Tc(lp_local)
       endif
!$omp end critical
       if(i_iso .gt. 0) then !re-emission for absorbtion
              if(old_random.eq.1) then 
                call random_number(ran1)
                call random_number(ran2)
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
               endif
               d1 = get_direction(ran1,ran2)
        endif
     end if
!    End if von 6.1 Streuung oder 6.2 Absorbtion
! Check Konvergenz der Temperaturen: in fort.66
!        if(nabssi(lp_local).ne.nabssiold .and.iabs(lp_local).gt.1) &
!&         write(66,*) nabssi(lp_local), Tsi(lp_local)
! -----------------------
! Neuer AP der Reemission/Streuung ist bei beim interaktions Punkt
! Paket bleibt im UW und wird um ds_cell verschoben, falls keine
! interaktion setzte a=e.

        if (imrw.eq.1) stop 'imrw =1 falsche logik: check goto 1000'

	if(ds_cell.lt.near*ds) then 

               if(ds_cell.lt.near)  ds_cell = near
               a = shift_AP(a,d,ds_cell)
!         print*, ds_cell, ds_cell/ds, ' Reset ds_cell: near>ds_cell'
	else  
                a = e
		if(isnan(a%x)) print*,'isnan(a) at a = e'
        end if

        if(i_iso .le. 0) then
! Neue Richtung des Pakets bei Reemission/Streuung
              if(old_random.eq.1) then 
                call random_number(ran1)
                call random_number(ran2)
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
               endif
               d = get_direction(ran1,ran2)
        else
           d = d1
        endif
	else
!        Keine Interaktion: neuer AP ist alter Endpunkt
!            if(iiabsgas.ne.1 .and. taumax.le.1e-2 .and. taus>=1e-9)then !Lucy method
!                 call absorb_lucy(init,jf_local,lp_local,taumax,tauabs,UWmass)
!            endif

		a = e;
		if(isnan(a%x)) print*,'isnan(a) at a = e 2'
	end if
! ===== End if von: Kommt es zur Wechselwirkung mit Staub?

	else 
!Paket ist nicht in Wolke setzte a=e damit es die Wolke verlaesst

		a = e;
		if(isnan(a%x)) print*,'isnan(a) at a = e 3'
                end if
! ===========   End if von: ist Paket noch in Wolke ?
!     

!  Bestimme wieder GW und ob AP auf einer Fläche x=const eines GW liegt
	call check_near_border_GW(a,iGW,s,init)

	end do
end subroutine go_trace

!
! ---------------------------------------------
!

subroutine go_scatter(init,jf_local,jjf_local,a,d,jsca)

!this subroutine is go_trace() re-written exclusively to deal with scattering
! and any absorbed photons are lost.
! Calls to MRW and Lucy method have been removed.


!
! Behandlung eines Pakets emittiert direkt vom Stern bis 
!                               'Ade Du schöne Wolke'
! Notation: 
! a = Anfangspunkt (AP): Wenn Paket in einen neuen UW kommt liegt AP
!    erstmal auf einer seiner Seitenwaende und dannach bei dem
!    Interaktionspunkt (ds_cell).
! e = Endpunkt: EP liegt immer auf einer Wand desselben UW wie AP und
!    ergibt sich als Durchstoßpunkt der Geraden vom AP und Richtung des
!    Pakets.
! d = Richtung der Pakets (Einheitsvektor).
!
! Externals: (a-g)
! -a- check_near_border_GW():
! Bestimme GW und ob AP auf einer KAnte oder Fläche x=const eines GW 
! liegt, falls AP sehr nahe einer solchen kante/Fläche verschiebe AP 
! auf diese; setze in dem Fall s%x=1 sonst ist s%x=0.
!
! -b- icheck_leave():
! Paket verläßt Wolke bei icheck_leave=1
! Bestimme ob neuer AP außerhalb der Wolke liegt.
!
! -c- get_EP():
! Bestimmung von EP aus Bahn des Pakets von AP a und Richtung d.
! EP liegt im gleichen UW wie AP.
! EP bleibt im UW falls s%x =0, wieder verschieben von a 
!          auf Fläche eines UW falls a nahe dieser Fläche liegt 
! EP außerhalb UW falls s%x=1 und d%x <0
!
! -d- Absorption():
!  i)   Wird Paket durch aC oder Si grain absorbiert
!  ii)  Erhöhung der aC(Si)- Temperatur im UW
!  iii) Berechnung neuer Frequenz 
!
! -e- get_UW():
! Bestimmung des UW (lp, UW-Koordinaten)
! auss halber Bahn des Paketes von AP bis EP.
! Halbe Strecke  (a+e)/2 da falls a und e Punkte auf den Wuerfelkanten 
! beschreiben es zu numerischen Ungenauigkeiten kommen kann.
! Beispiel: bei 1.999999 und 3.00001 ist der richtige Wuerfel bei zwei.
!
! -f- get_lp(): 
! Bestimmung von lp aus Koordinaten des UW
!
! -g-get_direction()
! Würfle neue Richtung d
!
! -h- call mrw() : Teste ob diffusion Approximation gilt, 
!                  falls ja berechne ds_cell, jf_local 
! ------------------------------------
! Logische Reihenfolge von go_trace():
!
! 1) Bestimme Variable:
!    a)   e     = EP im UW lp_local
!    b)   ds    = Weglaenge von |a-e| 
!    c) Prüfe ob Paket noch in der Wolke ist, falls ja
!    d) UWmass= Masse des UW der auf der halben Wegstrecke
!                 von AP bis EP liegt [durch get_UW()]. 
!    e) Albedo, taus  = dicht*Kappa* ds
!
!    f) kommt es zur WW mit Gas?
!    g) Gilt diffusion Approxi., falls ja (imrw=1) setzte ds_cell=R0
! 2) Kommt es zur interaktion mit Staub?
!    Ja, falls taus > -ln(zufall) und keine WW mit Gas und
!    diff Aprox ist nicht erfuellt, dann:
!  i)   Interaktionspunkt nach Strecke:
!       ds_cell *dicht*Kappa = -ln(Zufall)
!  ii)  Albedo > Zufall: dann    Streuung
!                        sonst   Absorption
!  iii) Bestimmung neuer AP:
!       Falls ds_cell < ds dann  wird Interaktionspunkt neuer AP imselben UW
!       sonst wird EP neuer AP (und je nach Richtung geht paket in neuen UW
!  iv)  Würfle neue Richtung
!
! 3) Sonst keine Interaktion, 
!    dann fliegt Paket einfach weiter und 
!    e wird neuer AP mit gleicher Richtung, d.h. Paket verlaest den UW.
!
! 4) Prüfe ob neuer AP auf/nahe einer Fläche eines UW liegt
! -------------------
!
use parameter
use constants
use type_module
use omp_lib
        implicit none
        type(init_type)         :: init
        type(int_vector)        :: iGW,s
        type(float_vector)      :: e,a,d,d1,shift_AP
        type(float_vector)      :: get_direction,get_sca_dir

        integer                 :: icheck_leave, get_UW
        integer                 :: iiabspah, iiabsgas
        integer                 :: nabssiold, scacount
        integer                 :: jjf, jjf_local,jf_local,jf_old,lp_local,lpold
        integer                 :: jabs,jsca,index, l, ltc, ltsi, imrw,num
        integer        :: ldiff ! mean temperature intervall in diff sph.
        real*8,parameter       :: near = 0.99999
        real*8         :: ds,ds_cell,taus,albedo, Ediff
        real*8         :: c_ext,c_extV,UWmass, gion, tausV, tauVtot
        real*8         :: ran1,ran2,ran3
        real*8         :: Ephot, Tm, Eabscz, Eabssiz, fak
        real*8         :: r0, get_r0diff, tau_mrw
        real*8         :: tsiold
        real*8         :: taumax
        real*8         :: tauabs,sca_ratio
        real*8         :: dUW,g_local

!
! --------------------------------
!  jf_loc bezgl. Gitter vom Staub
! jjf_loc bezgl. Gitter vom Stern
!        jf_local = jd(jjf)
!

	jabs = 0
	jsca = 0
        iiabspah=0
        iiabsgas=0

! Gas:
        tauVtot = 0d0
        gion    = 1.d0
!       20eV < photon energie <300eV => 50%  gas ionisiert sonste 
!        if(hwirk*fd(jf_local)/eVolt .ge. 20.)   then
!            gion = 1.d0 !0.5d0
!        else
!           gion  = 0.01d0 ! 0.d0
!        endif
! --------------
!  1.  Bestimme GW und ob AP auf einer Fläche x=const eines GW liegt

       call check_near_border_GW(a,iGW,s,init)

! --------------------------------------------------
! vom Stern durch alle Wuerfel bis 'ade du schoene wolke oder in PAH od. Gas:
! Paket verläßt Wolke bei icheck_leave=1:
! Bestimmung Endpunkt der Bahn des Pakets:
! AP liegt nicht auf Fläche eines UW-> Bahn bleibt noch im UW:s%{x,y,z}=0
! AP liegt       auf Fläche eines UW-> Bahn verläßt        UW:s%{x,y,z}=1
! a = Anfangspunkt (AP): Wenn Paket in einen neuen UW kommt liegt AP
!     erstmal auf einer seiner Seitenwaende und dannach bei dem
!     Interaktionspunkt (ds_cell).
! e = Endpunkt: EP liegt immer auf einer Wand desselben UW wie AP und ergibt
!     sich als Durchstoßpunkt der Geraden vom AP und Richtung des Pakets.
! d = Richtung der Pakets (Einheitsvektor).
! --------------------------------------------------
!
  do while(icheck_leave(a,d,jabs,jf_local,jjf_local,init).ne.1 &
&               .and.iiabspah.ne.1.and.iiabsgas.ne.1)

! sprung wegen imrw=1:

  1000 continue

if (init%idim3 .ne.1 .and. ((iGW%z .lt. 1) .or. (igw%y .lt. 1) .or. &
&       (igw%x .lt. 1))) then
   print*,a,' ',e,' ',d,' ',init%dgw,' ',igw,' ',imrw
endif

  if (init%idim3.ne.1) call mirror(a,d,init,iGW)

               	       call get_EP(a,e,d,iGW,s,init)

! 5.1   ds = Weglänge vom AP (xa,ya,za) zum EP (xe,ye,ze) im UW
	ds = sqrt((a%x-e%x)*(a%x-e%x)+(a%y-e%y)*(a%y-e%y)+(a%z-e%z)*(a%z-e%z))

!       Die Mitte des Weges vom AP zum EP hat die Koordinaten (iGW%x,..):
	iGW%x = (a%x + e%x)/2.0/init%dgw+1
	iGW%y = (a%y + e%y)/2.0/init%dgw+1
	iGW%z = (a%z + e%z)/2.0/init%dgw+1


!
! Falls Paket wirklich noch in der Wolke dann berechne:

	if (iGW%x<=init%nx.and.iGW%y<=init%ny.and.iGW%z<=init%nz.and.&
&           iGW%x>=1.and.iGW%y>=1.and.iGW%z>=1) then 

 	 lp_local = get_UW(a,e,init)
!   print*,lp_local,a,e,iGW,netz(iGW%x,iGW%y,iGW%z),netsum(iGW%x,iGW%y,iGW%z)
      	 UWmass = (init%dgw/netz(iGW%x,iGW%y,iGW%z))*dicht(lp_local)*&
&                 (init%dgw/netz(iGW%x,iGW%y,iGW%z))*&
&                 (init%dgw/netz(iGW%x,iGW%y,iGW%z));

! 5.2  Optische Tiefe, albedo vom AP zum EP bez. Staubfrequenz jf_local
        if (jpah.eq.0 .or. inopah(lp_local) .eq.1) then
            c_ext  = c_ext_si(jf_local) + c_ext_ac(jf_local)
            c_extV = c_ext_si(ivisd)    + c_ext_ac(ivisd)
         else
            c_ext  = c_ext_si(jf_local) + c_ext_ac(jf_local) + C_abs_pah(jf_local)
            c_extV = c_ext_si(ivisd)    + c_ext_ac(ivisd)    + C_abs_pah(ivisd)
        endif

	albedo = (c_sca_si(jf_local)+c_sca_ac(jf_local))/c_ext
	taus   = ds*dicht(lp_local)*c_ext
	tausV  = ds*dicht(lp_local)*c_extV                
        tauVtot= tauVtot + tausV
        dUW = (init%dgw/netz(iGW%x,iGW%y,iGW%z))
        taumax = dicht(lp_local) * dUW * (c_abs_si(iabs_max) + c_abs_ac(iabs_max)) !calculates optical depth along length of cell at frequency at which it is maximum
        tauabs = ds*dicht(lp_local)*(c_abs_si(jf_local) + c_abs_ac(jf_local))
        sca_ratio =  (C_sca_ac(jf_local)/(C_sca_ac(jf_local) + C_sca_Si(jf_local)))


!
! ------------
!  6.  Interaktion des Pakets im UW lp mit  Gas:
        if (jgas.eq.1) then 
          if (old_random.eq.1) then 
              call random_number(ran1)
          else
              ran1 = get_random(omp_get_thread_num())
          endif

!oberalb (tauVtot< 1) extinction layer -> gas ist teilweise ionisiert
         if (ds*dicht(lp_local)*((1.-gion)*c_gas(jf_local)).gt.-log(ran1) &
&           .and. tauVtot .lt. 1.) then
            iiabsgas=1
            iabsgas = iabsgas + 1
         endif
!unterhalb  (tauVtot> 1) extinction layer -> gas ist neutral
         if (ds*dicht(lp_local)*(c_gas(jf_local)).gt.-log(ran1) &
&           .and. tauVtot .ge. 1.) then
            iiabsgas=1
            iabsgas = iabsgas + 1
         endif
       endif
! ----- ende Gas WW
!
! Kommt es zur Wechselwirkung mit Staub?
! 6.0  MRW? Bei imrw=1 (=ja) dann goto1000 sonst:  
! 6.1  Streuung od. 6.2 Absorbtion.
! Wenn Variable zufall doppeltgenau, kommt es vor, obwohl höchst selten, 
! daß exakt zufall=1, daher Zusatzbedingung: taus .ge. 1d-9

       if (old_random.eq.1) then 
          call random_number(ran1)
        else
          ran1 = get_random(omp_get_thread_num())
       endif

!            if(iiabsgas.ne.1 .and. taumax.le.1e-2 .and. taus>=1e-9)then !Lucy method
!                 call absorb_lucy(init,jf_local,lp_local,taumax,tauabs,UWmass)
!            endif

  if (iiabsgas.ne.1.and. taus>=-log(ran1).and.taus>=1e-9) then 


! 6.0 Diffusion approximation:

       imrw = 0
!       call mrw(lp_local,jf_local,init,iGW,UWmass,s,ds,a,d,e,imrw)

!       if (imrw.eq.1) then
!          if(ibug.ge.2) &
!          write(6,'(3i4, 1p2e10.2, a20)') lp_local, lpold, &
!&         jf_local, Tc(lp_local), Tsi(lp_local), ' =jf,Tc, Tsi'
!         goto 1000
!       endif

!      ds_cell ist Wegstrecke im Wuerfelelement bis zum Interaktionspunkt 
       ds_cell = -log(ran1)/dicht(lp_local)/c_ext

!  6.1 MRW gilt nicht also kommt es entweder zur Streuung oder zur
!      Absorbtion des Pakets im UW lp
         if (old_random.eq.1) then 
             call random_number(ran1)
         else
             ran1 = get_random(omp_get_thread_num())
         endif
!  6.1  Streuung 
     if (albedo>ran1) then 
   	 jsca = jsca + 1
!$omp atomic
 	 isca(lp_local) = isca(lp_local) + 1

         if(i_iso .le. 0 .and. i_write .eq. 1) then 

         sca_freq(jsca,1+omp_get_thread_num()) = jf_local
         sca_UW(jsca,1+omp_get_thread_num()) = lp_local

         endif
         if(i_iso .gt. 0 .and. i_write .eq. 1) then

         sca_trace(jsca,1+omp_get_thread_num())%lp = lp_local
         sca_trace(jsca,1+omp_get_thread_num())%jf = jf_local
         sca_trace(jsca,1+omp_get_thread_num())%x = d%x
         sca_trace(jsca,1+omp_get_thread_num())%y = d%y
         sca_trace(jsca,1+omp_get_thread_num())%z = d%z

           if(old_random.eq.1) then 
                call random_number(ran1) !beta
                call random_number(ran2) !alpha
                call random_number(ran3) !aC or Si
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
                ran3 = get_random(omp_get_thread_num())
               endif
               !check if scattering is aC or Si

            if(ran3 .gt. sca_ratio) then
               d1 = get_sca_dir(ran1,ran2,d,g_Si(jf_local))

            else
               d1 = get_sca_dir(ran1,ran2,d,g_aC(jf_local))

            endif
         endif
         !avoid future problems with jsca>size(sca_freq) by moving copying of elements into buffer to here and end of go_trace
         ! remember to insert case of HG approx later!
         if(i_iso .le. 0 .and. jsca .eq. 200000 .and. i_write .eq. 1) then !arrays full, copy to buffer
            !$omp critical
          do num=1,jsca
            sca_buffer(num+buffer_int,1) = sca_freq(num,1+omp_get_thread_num())
            sca_buffer(num+buffer_int,2) = sca_UW(num,1+omp_get_thread_num())
          enddo
          buffer_int = buffer_int + jsca
          jsca = 0
          sca_freq(:,1+omp_get_thread_num()) = 0
          sca_UW(:,1+omp_get_thread_num()) = 0
          if(buffer_int .gt. 5242700) then
          do num = 1,buffer_int
             write(23)sca_buffer(num,1),sca_buffer(num,2)
          enddo
          buffer_int = 0
          endif
          !$omp end critical
         endif
         if(i_iso .gt. 0 .and. jsca .eq. 200 .and. i_write .eq. 1) then
         !$omp critical
          do num=1,jsca
            sca_buffer_aniso(num+buffer_int)%jf = sca_trace(num,1+omp_get_thread_num())%jf
            sca_buffer_aniso(num+buffer_int)%lp = sca_trace(num,1+omp_get_thread_num())%lp
            sca_buffer_aniso(num+buffer_int)%x = sca_trace(num,1+omp_get_thread_num())%x
            sca_buffer_aniso(num+buffer_int)%y = sca_trace(num,1+omp_get_thread_num())%y
            sca_buffer_aniso(num+buffer_int)%z = sca_trace(num,1+omp_get_thread_num())%z
            sca_trace(num,1+omp_get_thread_num())%jf = 0
            sca_trace(num,1+omp_get_thread_num())%lp = 0
            sca_trace(num,1+omp_get_thread_num())%x = 0
            sca_trace(num,1+omp_get_thread_num())%y = 0
            sca_trace(num,1+omp_get_thread_num())%z = 0
          enddo
          buffer_int = buffer_int + jsca
          jsca = 0
          if(buffer_int .gt. 5242700) then
          do num = 1,buffer_int
             write(23)sca_buffer_aniso(num)%jf,sca_buffer_aniso(num)%lp,sca_buffer_aniso(num)%x,&
                 &sca_buffer_aniso(num)%y,sca_buffer_aniso(num)%z
          enddo
          buffer_int = 0
          endif
          !$omp end critical
         endif
     else
        return
!  6.2  Absorption
	 jabs = jabs + 1
!$omp atomic
 	 iabs(lp_local) = iabs(lp_local) + 1

!
!  6.2a: Absorbtion  durch PAHs.  Paket muß vom Stern kommen.
! Varibale ifr speichert  im UW (lp) die Anzahl der absorbtion [iabs(lp)]
! des Photonpaketes durch PAH die Frequenz jf hat.
!$omp critical
         if (old_random.eq.1) then 
          call random_number(ran1)                 ! pah (yes/no)
         else
          ran1 = get_random(omp_get_thread_num())
         endif
       if(jpah .eq. 1 .and. jabs .eq. 1 .and.inopah(lp_local).eq.0) &
&        call pahabs(a,e,jf_local,UWmass,lp_local,ran1,iiabspah)

!  6.2b  Absorption im UW lp durch aC oder Si
        if (old_random.eq.1) then 
         call random_number(ran1)                 ! which aC or Si
         call random_number(ran2)                 ! which frequency
        else 
         ran1 = get_random(omp_get_thread_num())
         ran2 = get_random(omp_get_thread_num())
        endif
       jf_old = jf_local
       if (iiabspah.ne.1) then 
         if (init%iter.eq.0) &
&        call absorption(init,jf_local,UWmass,ran1,ran2,lp_local,taumax)
         if (init%iter.ne.0) &
&       call absorption_iter(init,jf_local,UWmass,ran1,ran2,lp_local)
         if (Tsi(lp_local)>Tmax) Tmax=Tsi(lp_local)
         if (Tc(lp_local)>Tmax) Tmax=Tc(lp_local)
       endif
!$omp end critical
       if(i_iso .gt. 0) then !re-emission for absorbtion
              if(old_random.eq.1) then 
                call random_number(ran1)
                call random_number(ran2)
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
               endif
               d1 = get_direction(ran1,ran2)
        endif
     end if
!    End if von 6.1 Streuung oder 6.2 Absorbtion
! Check Konvergenz der Temperaturen: in fort.66
!        if(nabssi(lp_local).ne.nabssiold .and.iabs(lp_local).gt.1) &
!&         write(66,*) nabssi(lp_local), Tsi(lp_local)
! -----------------------
! Neuer AP der Reemission/Streuung ist bei beim interaktions Punkt
! Paket bleibt im UW und wird um ds_cell verschoben, falls keine
! interaktion setzte a=e.

        if (imrw.eq.1) stop 'imrw =1 falsche logik: check goto 1000'

	if(ds_cell.lt.near*ds) then 

               if(ds_cell.lt.near)  ds_cell = near
               a = shift_AP(a,d,ds_cell)
!         print*, ds_cell, ds_cell/ds, ' Reset ds_cell: near>ds_cell'
	else  
                a = e

        end if

        if(i_iso .le. 0) then
! Neue Richtung des Pakets bei Reemission/Streuung
              if(old_random.eq.1) then 
                call random_number(ran1)
                call random_number(ran2)
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
               endif
               d = get_direction(ran1,ran2)
        else
           d = d1
        endif
	else
!        Keine Interaktion: neuer AP ist alter Endpunkt
!            if(iiabsgas.ne.1 .and. taumax.le.1e-2 .and. taus>=1e-9)then !Lucy method
!                 call absorb_lucy(init,jf_local,lp_local,taumax,tauabs,UWmass)
!            endif

		a = e;

	end if
! ===== End if von: Kommt es zur Wechselwirkung mit Staub?

	else 
!Paket ist nicht in Wolke setzte a=e damit es die Wolke verlaesst

		a = e;

                end if
! ===========   End if von: ist Paket noch in Wolke ?
!     

!  Bestimme wieder GW und ob AP auf einer Fläche x=const eines GW liegt
	call check_near_border_GW(a,iGW,s,init)

	end do
end subroutine go_scatter



subroutine tracescatter(init)
!
! Berechne Start und Angangspkt. und rufe f. jedes packet go_trace auf.
! In go_trace wird der weg eines Packets durch die gesamte Wolke verfolgt.
!
use type_module
use parameter
use constants
use omp_lib
	integer                 :: nUW,hit_ac,hit_si,n_zero_cells_ac,n_zero_cells_si
        type(init_type)         :: init
        integer                 :: isze, modprint
        integer                 :: jsca,num
        integer                 :: jjf,  jjf_local,jf_local
        type(float_vector)      :: a,d
        type(float_vector)      :: get_direction
        real*8                  :: ran1,ran2

!        call omp_set_num_threads(1)

	n_zero_cells_si = 0;
	n_zero_cells_ac = 0;
	hit_si = 0;
	hit_ac = 0;
        nUW = netsum(init%nx,init%ny,init%nz)

        print*, ' Method: Bjorkman & Wood (2003)'
        print*, '        progress        micron                        #UW_noabs            #PAH abs'
        modprint = 10
 !       if(init%nf .ge. 2000) modprint = 30
        iabsgas = 0
        if(i_iso .le. 0) then
        allocate(sca_freq(200000,omp_get_max_threads()))
        sca_freq=0
        allocate(sca_UW(200000,omp_get_max_threads()))
        sca_uw=0
!        allocate(sum_sca_freq(nd))
!        num = 12000000
        num = 5500000
        allocate(sca_buffer(num,2))
        sca_buffer=0
        elseif(i_iso .gt. 0) then
        allocate(sca_trace(200,omp_get_max_threads()))
           num = 5243000
           allocate(sca_buffer_aniso(num))
        endif
        open(unit = 23, file = 'output/scatters_temp.bin', access = 'STREAM', status = 'REPLACE', form = 'UNFORMATTED')
        rewind(23)
        do jjf=init%nf,1,-1
           if(jjf .gt. init%nf-5) then
              print*,0,'/',modprint,welmu(jjf),n_zero_cells_si+n_zero_cells_ac, ispah
           else 	
              if (init%nf.gt.modprint) then 
                 if (mod(jjf,init%nf/modprint).eq.0) then
                    print*,1+modprint-jjf/(init%nf/modprint),'/',modprint,welmu(jjf),n_zero_cells_si+n_zero_cells_ac, ispah
                 endif
              endif
           endif
!$omp parallel do firstprivate(init,a,d,jf_local,jjf_local,ran1,ran2,jjf,jsca)
           do izyk=1,ivnzyk(jjf)
              jsca = 0
              a%x = xorg
              a%y = yorg
              a%z = zorg
              if (old_random.eq.1) then 
                 call random_number(ran1) ! wie rand F90 standard aber langsamer
                 call random_number(ran2) ! wenn mehr als 1 threat
              else
                 ran1 = get_random(omp_get_thread_num()) ! besser, schnellere Zufalszahl.
                 ran2 = get_random(omp_get_thread_num())
              end if
!
! Paket wird vom Stern emittiert. Bedinging abs(d) damit es in 
! Oktant abgestrahtl wird
!
              d = get_direction(ran1,ran2)
              if (init%idim3.ne.1) then
                 d%x = abs(d%x)
                 d%y = abs(d%y)
                 d%z = abs(d%z)
              endif
              jf_local = jd(jjf)  ! freq bezgl. staub
              jjf_local = jjf     ! freq bezgl. stern

              call go_scatter(init,jf_local,jjf_local,a,d,jsca)
!$omp critical              
!              jsca = 1
              if (jsca .gt. 0) then
                 if(i_iso .le. 0 .and. i_write .eq. 1) then
                    do num=1,jsca
!                     print*,jsca
!                     sca_buffer(num+buffer_int) = sca_trace(num,1+omp_get_thread_num())
                     sca_buffer(num+buffer_int,1) = sca_freq(num,1+omp_get_thread_num())
                     sca_buffer(num+buffer_int,2) = sca_UW(num,1+omp_get_thread_num())
!                     num = num + 1
!                     print*,jsca
                  end do
                  sca_freq(:,1+omp_get_thread_num()) = 0
                  sca_UW(:,1+omp_get_thread_num()) = 0
              buffer_int = buffer_int + jsca
              if (buffer_int .ge. 5242700) then
                    do num = 1, buffer_int
                    write(23)sca_buffer(num,1),sca_buffer(num,2)
                    enddo
                    buffer_int = 0
                 endif
               elseif (i_iso .gt. 0 .and. i_write .eq. 1) then
                 do num=1,jsca
                    sca_buffer_aniso(num+buffer_int)%jf = sca_trace(num,1+omp_get_thread_num())%jf
                    sca_buffer_aniso(num+buffer_int)%lp = sca_trace(num,1+omp_get_thread_num())%lp
                    sca_buffer_aniso(num+buffer_int)%x = sca_trace(num,1+omp_get_thread_num())%x
                    sca_buffer_aniso(num+buffer_int)%y = sca_trace(num,1+omp_get_thread_num())%y
                    sca_buffer_aniso(num+buffer_int)%z = sca_trace(num,1+omp_get_thread_num())%z
                    sca_trace(num,1+omp_get_thread_num())%jf = 0
                    sca_trace(num,1+omp_get_thread_num())%lp = 0
                    sca_trace(num,1+omp_get_thread_num())%x = 0
                    sca_trace(num,1+omp_get_thread_num())%y = 0
                    sca_trace(num,1+omp_get_thread_num())%z = 0
                 end do
              buffer_int = buffer_int + jsca
              if (buffer_int .ge. 5242700) then
                 do num = 1, buffer_int
                    write(23)sca_buffer_aniso(num)%jf,sca_buffer_aniso(num)%lp,sca_buffer_aniso(num)%x,&
                         &sca_buffer_aniso(num)%y,sca_buffer_aniso(num)%z
                 enddo
                 buffer_int = 0
              endif
              endif
              endif

!!$              buffer_int = buffer_int + jsca
!!$              if (buffer_int .ge. 5242700) then
!!$                    do num = 1, buffer_int
!!$!                    write(23)sca_buffer(num)%jf,sca_buffer(num)%lp,sca_buffer(num)%x,sca_buffer(num)%y,sca_buffer(num)%z
!!$                    write(23)sca_buffer(num,1),sca_buffer(num,2)
!!$                    enddo
!!$                    buffer_int = 0
!              elseif ( izyk .eq. init%nzyk .and.  jjf .eq. 1) then
!                    do num = 1, buffer_int
!                    write(23)sca_buffer(num,1),sca_buffer(num,2)
!                    enddo
!                    buffer_int = 0
!!$              endif

!$omp end critical
           end do
!$omp end parallel do


! ---------
! Fuer jede Zelle berechne dieAnzahl der Absorbtionen von Si und ac: hit_* 
! und entsprechend Zellen ohne absobrtionen n_zero_cells_ (falls gross ungenaues Ergebnis)
           n_zero_cells_si = 0
           n_zero_cells_ac = 0
           hit_si = 0
           hit_ac = 0
           do i=1,nUW
              hit_si = hit_si + nabssi(i)
              hit_ac = hit_ac + nabsc(i)
              if (nabssi(i).eq.0.and.dicht(i)*init%SImass.ne.0) n_zero_cells_si = n_zero_cells_si + 1
              if (nabsc(i).eq.0.and.dicht(i)*init%ACmass.ne.0)  n_zero_cells_ac = n_zero_cells_ac + 1
           end do
	end do
if( buffer_int .gt. 0 .and. i_write .eq. 1) then
   if(i_iso .le. 0) then
   do num = 1, buffer_int
!      write(23)sca_buffer(num)%jf,sca_buffer(num)%lp,sca_buffer(num)%x,sca_buffer(num)%y,sca_buffer(num)%z
      write(23) sca_buffer(num,1),sca_buffer(num,2)
   enddo
   elseif(i_iso .gt.0 ) then
         do num = 1, buffer_int
            write(23)sca_buffer_aniso(num)%jf,sca_buffer_aniso(num)%lp,sca_buffer_aniso(num)%x,&
                 &sca_buffer_aniso(num)%y,sca_buffer_aniso(num)%z
!      write(23) sca_buffer(num,1),sca_buffer(num,2)
         enddo
   endif
   buffer_int = 0
endif
!        print*,sum_sca_freq(nd)
!if(i_iso.gt.0) deallocate(sum_sca_freq)
if(i_iso.gt.0)        deallocate(sca_trace)
if(i_iso.gt.0)        deallocate(sca_buffer_aniso)
if(i_iso.le.0)        deallocate(sca_freq)
if(i_iso.le.0)        deallocate(sca_UW)
if(i_iso.le.0)        deallocate(sca_buffer)
        CLOSE(unit=23)
        print*,' Number of photons in gas: ',iabsgas
        hit_si=0
        do i=1,isumuw
          if (inopah(i).eq.1) hit_si = hit_si +1
        end do
        print*,' Number of X-ray destructions:',hit_si
        

end subroutine tracescatter
!
! ------------------------------------------------------------------
!
subroutine traceopenmp_iter(init)

! Berechne Start und Anfangspkt. und rufe f. jedes packet go_trace auf.
! In go_trace wird der weg eines Packets durch die gesamte Wolke verfolgt.
!
!

use type_module
use parameter
use constants
use omp_lib
implicit none
	integer                 :: nUW,hit_ac,hit_si,n_zero_cells_ac,n_zero_cells_si
        type(init_type)         :: init
        integer                 :: isze
        integer                 :: jjf, jsca, jjf_local,jf_local
        type(float_vector)      :: a,d
        type(float_vector)      :: get_direction
        real*8                  :: ran1,ran2
        real*8                  :: sumQ_si,sumQ_ac
        real*8,external         :: bpl
        real*8                  :: Eabsz,UWmass
        integer                 :: z_si,z_ac,i1,i2,netz_tmp,iiter
        integer                 :: get_lp,ix,iy,iz,iux,iuy,iuz
        type(int_vector)        :: iGW,iUW


! Fuer n_precalc ne 0: Berechnung der emissions frequenz 
! (Frequenzen i2=jf) mit zugehoeriger Zufallszahl 
        if (init%n_precalc.gt.0) then 
        print*,'Precalutaing reemission frequency grid size:',init%ntg,init%n_precalc
        allocate(iter_ac(init%ntg,init%n_precalc))
        allocate(iter_si(init%ntg,init%n_precalc))
	do i1=1,init%ntg
       	sumQ_si=0
        sumQ_ac=0
       	z_si = 1
      	z_ac = 1
        do i2=1,init%nd
		sumQ_si=sumQ_si + c_abs_si(i2)*bpl(fd(i2),fd3(i2),Td(i1))*dfd(i2)
		do while(sumQ_si/QBsi(i1)>=z_si*1d0/init%n_precalc)
		iter_si(i1,z_si) = i2
		z_si = z_si + 1 
		end do
		sumQ_ac= sumQ_ac + c_abs_ac(i2)*bpl(fd(i2),fd3(i2),Td(i1))*dfd(i2)
		do while(sumQ_ac/QBc(i1)>=z_ac*1d0/init%n_precalc)
		iter_ac(i1,z_ac) = i2
		z_ac = z_ac + 1 
		end do
	end do
	end do
        print*,'done'
        end if


        n_zero_cells_si = 0;
	n_zero_cells_ac = 0;
	hit_si = 0;
	hit_ac = 0;
        nUW = netsum(init%nx,init%ny,init%nz)
        print*, ' Method: iterative n=',init%iter
        do iiter=1,init%iter
        iabsgas = 0
	print*,'          iteration:  ',iiter

        print*, '         izyk        nzyk      #UW_noabs'

        if(iQuelle.eq.3) then
         print*, '  do izyk=1,ivnzyk(jjf) needs ot be inserted '
         stop ' traceopenmp_iter'
        endif

           do izyk=1,ivnzyk(jjf)  ! not chekced und unten:
!alt:	do izyk=1,init%nzyk


		if (mod(izyk,init%nzyk/10).eq.0) print*,izyk,init%nzyk,n_zero_cells_si+n_zero_cells_ac
!$omp parallel do firstprivate(init,a,d,jf_local,jjf_local,ran1,ran2)
                     do jjf=1,init%nf

           	        a%x = xorg
           	        a%y = yorg
           	        a%z = zorg
                        if (old_random.eq.1) then 
                   	        call random_number(ran1)
                   	        call random_number(ran2)
                        else
                                ran1 = get_random(omp_get_thread_num())
                                ran2 = get_random(omp_get_thread_num())
                        end if
           	        d = get_direction(ran1,ran2)
                        if (init%idim3.ne.1) then
                                d%x = abs(d%x)
                                d%y = abs(d%y)
                                d%z = abs(d%z)
                        endif
                        jf_local = jd(jjf)  ! freq bezgl. staub
                        jjf_local = jjf     ! freq bezgl. stern
			call go_trace(init,jf_local,jjf_local,a,d,jsca)
		end do
!$omp end parallel do
! ---------
! Fuer jede Zelle berechne dieAnzahl der Absorbtionen von Si und ac: hit_* 
! und entsprechend Zellen ohne absobrtionen n_zero_cells_ (falls gross ungenaues Ergebnis)
		n_zero_cells_si = 0
		n_zero_cells_ac = 0
	        hit_si = 0
		hit_ac = 0
        	do i=1,nUW
			hit_si = hit_si + nabssi(i)
			hit_ac = hit_ac + nabsc(i)
			if (nabssi(i).eq.0.and.dicht(i)*init%SImass.ne.0) n_zero_cells_si = n_zero_cells_si + 1
			if (nabsc(i).eq.0.and.dicht(i)*init%ACmass.ne.0) n_zero_cells_ac = n_zero_cells_ac + 1
		end do
	end do

!
! Bei ietrative method require to compute temperature of each cell
! T aus vorberechnetes Gitter, folglich wird nur noch der Index zu:
! Tsi(lp) = j gepeichert.
!
	do  ix=1,init%nx
	do  iy=1,init%ny
	do  iz=1,init%nz
                iGW%x = ix
                iGW%y = iy
                iGW%z = iz
		netz_tmp = netz(iGW%x,iGW%y,iGW%z)
		do iux=1,netz_tmp
		do iuy=1,netz_tmp
		do iuz=1,netz_tmp
                        iUW%x = iux
                        iUW%y = iuy
                        iUW%z = iuz
        		lp = get_lp(iGW,iUW)
        		UWmass = dicht(lp) * (init%dgw/netz_tmp)**3
			Eabsz = (nabssi(lp)-0.5)*init%epak/(pi4*UWmass)
			call locat(QBsi,init%ntg,Eabsz,j)
			if (j.lt.1) j=1
			if (j.ge.init%ntg) j=init%ntg
                        Tsi(lp) = j
                        if (iiter.ne.init%iter) nabssi(lp) = 0
			Eabsz = (nabsc(lp)-0.5)*init%epak/(pi4*UWmass)
			call locat(QBc,init%ntg,Eabsz,j)
			if (j.lt.1) j=1
			if (j.ge.init%ntg) j=init%ntg
                        Tc(lp) = j
                        if (iiter.ne.init%iter) nabsc(lp) = 0
		end do
		end do
		end do
        end do
        end do
        end do

! null setzen:

        if (iiter.ne.init%iter) then 
        iwp    = 0
        ispah  = 0
!$omp parallel do private(i1,i2)
        do i1 = 1,naw
                iabspah(i1) = 0
                isca(i1) = 0
                iabs(i1) = 0
        end do 
        do i1 = 1,nd
        do i2 = 1,nthet
                iphd(i1,i2) = 0
                iphs(i1,i2) = 0
        end do
        end do
!omp end parallel do
!$omp parallel do private(i1)
        do i1 = 1,mpabs
                ipahlp(i1) = 0
                ipahfr(i1) = 0
                inopah(i1) = 0
        end do
!omp end parallel do
        end if
        end do
        print*,' Number of photons in gas: ',iabsgas
end subroutine traceopenmp_iter

!
! -----------------------------------------------------------------------
!

subroutine mrw(lp_local,jf_local,init,iGW,UWmass,s,ds,a,d,e,imrw)

!
! Modified Random Walk: Notation wie in Robitaille 2010, Eigentliches
! Paper zur MRW ist: Fleck Jr.,J.A. & Canfield E.H., 1984,
! J. Comput. Phys., 54, 508 UW hat ueber Tsi, Tc gemittelt Temperatur
! Tm Ist diffAprox erfüllt (Gl. 23)-> imrw=1, sonst 0.  diese gilt bis
! Radius R0 (in Gl.25), gegeben durch kürzesten Abstand von a
! zu den Seitenwänden des UW.  Innerhalb Kugel mit Radius R0 um a legt
! das Paket die gesamte Flugstrecke sdiff (Gl.25) durch vielfach
! Streuung/ Absorption zurück.  Innerhalb Flugstrecke sdiff übertragt
! das Paket die Energie Ediff (Gl. 26) auf Staub des UW. Aus Ediff =>
! nabssi, nabsaC wird entsprechend Verhältnis der
! Absorptionskoeffizienten erhöht um gerundeten integer Wert.
! PAH werden vernachlässigt.  Daraus ergibt sich eine neue Temp., neue
! Frequenz des Pakets. In go_trace geht es einfach weiter indem nur ein
! neuer Anfangspunkt irgendwo auf der Kugelschale mit radius R0 um 
! den alten AP  gewuerfelt wird.
!
use type_module
use constants
use parameter
use omp_lib
        implicit none
        type(init_type)    :: init
        type(float_vector) :: a, d, e, shift_AP
        type(float_vector) :: get_direction
        type(int_vector)   :: iGW, s
        real*8          :: ydiff, ranydiff, UWmass, ran, ran1, ran2
        real*8          :: ds, r0, Diff, get_r0diff, sdiff
        real*8          :: Tm, Ediff, Ediff_si, Ediff_ac
        real*8          :: fak,fak2,Eabsz,QsBip,sumQsBip
        integer         :: iget_mrw, imrw, kl,jl
        integer         :: lp_local,jf_local
        integer         :: ltsi, ltc, ldiff ! mean Temperatur Gitterpkt.im UW

!
! R0 = Radius of diffusion sphere (=min distance from AP to cell wall)

        s%x=0
        s%y=0
        s%z=0
        r0 = get_r0diff(a,iGW,init,s)



! Mittlere Temperatur des UW bei T-gitter ldiff:
!
         call locat(Td,ntg,Tsi(lp_local),ltsi)
         if (ltsi.lt.1)     ltsi = 1
	 if (ltsi.ge.ntg-1) ltsi = ntg-1
         call locat(Td,ntg,Tc(lp_local),ltc)
         if (ltc.lt.1)       ltc = 1
	 if (ltc.ge.ntg-1)   ltc = ntg-1
         
          Tm = 0d0
         if(Tsi(lp_local).gt.1 .and. Tc (lp_local).le.1) Tm = Tsi(lp_local)
         if(Tc(lp_local) .gt.1 .and. Tsi(lp_local).le.1) Tm = Tc(lp_local)
         if(Tsi(lp_local).gt.1 .and. Tsi(lp_local).gt.1) then
          Tm = (Tsi(lp_local)*c_ross(ltsi)+Tc(lp_local)*c_ross(ltc))/ &
&                            (c_ross(ltsi)+c_ross(ltc))
         endif
         call locat(Td,ntg,Tm,ldiff)
         if (ldiff.lt.1)     ldiff=1
	 if (ldiff.ge.ntg-1) ldiff=ntg-1

! Ist Diff approx  erfuelt ?
          imrw = iget_mrw(lp_local,ldiff, r0)
        
! =============================
! If Diff approx  erfuelt:
  if(imrw .eq.1) then 
 
                if(ibug.ge.2) then
print*, 'iMRW =', imrw, lp_local, ldiff,jf_local, ' before = jf'
 write(6,'(1p2e10.2,a20)') Tc(lp_local),  Tsi(lp_local), ' before =Tc, Tsi'
                endif

                if(r0 .gt. ds) then
                   call check_near_border_GW(a,iGW,s,init)
                   r0      = min(get_r0diff(a,iGW,init,s), r0)
                if(r0 .gt. ds) r0 =ds

!                if(r0 .gt. ds) then
!                   print*,  'MRW: r0>ds -reset to ds:a,e,d,ds= '  
!                    print*, a
!                    print*, d
!                    print*, e
!                    print*, ds
!                    r0 =ds
!                  endif
                  endif
!
! Energie  die vom Staub bei MRW aborbiert wird:
! diff = Diffusion constant (siehe Satz nach Gl.25): Diff
        diff = 1d0/3.d0/dicht(lp_local) /c_ross(ldiff)

! Eq.24: Zufall randiff => ydiff
         if (old_random.eq.1) then 
             call random_number(ranydiff)
         else
             ranydiff = get_random(omp_get_thread_num())
         endif
         i      = max(nint(ranydiff*n_mrw),1)
         ydiff  = y_mrw(i)*1d0
!        print*,' ydiff,i =', ydiff, i
! Eq.25: sdiff  = total flight distance within R0
         sdiff  = -dlog(ydiff) * (r0/pi)**2 /diff


! Eq.26: Ediff  = Number of epak absorbed within R0
         Ediff  = sdiff*dicht(lp_local)*C_planck(ldiff)

! Absorption im UW verteilt sich auf aC,  Si nach:
	fak2 = c_abs_si(jf_local)  / (c_abs_ac(jf_local) + c_abs_si(jf_local))
!
! Ediff [epak] (eq.26) von MRW: Die Bruchteile von Paketen werden auf 
! aC,Si durch Zufall auf/ab-runden dazu addiert und neue Frequenz
! durch die Temperaturerh"ohung durch aC oder Si berechnet.
!
     Ediff_si = fak2*Ediff
           if(old_random.eq.1) then 
              call random_number(ran)
           else
              ran = get_random(omp_get_thread_num())
           endif
           if((ceiling(Ediff_si)-Ediff_si) .lt. ran) then   
              Ediff_si = ceiling(Ediff_si)
           else
              Ediff_si = floor(Ediff_si)
           endif
      Ediff_ac = (1.-fak2)*Ediff
           if(old_random.eq.1) then 
              call random_number(ran)
           else
              ran = get_random(omp_get_thread_num())
           endif
           if((ceiling(Ediff_ac)-Ediff_ac) .lt. ran) then   
              Ediff_ac = ceiling(Ediff_ac)
           else
              Ediff_ac = floor(Ediff_ac)
           endif

!$omp atomic
 	 nabssi(lp_local) = nabssi(lp_local) + idint(Ediff_si) 
!$omp atomic
 	 nabsc(lp_local)  = nabsc(lp_local)  + idint(Ediff_ac) 

if(ibug .ge. 2) then
print*, 'nabssi(lp_local),nabssi(lp_local) + idint(Ediff_si)'
print*,  nabssi(lp_local),nabssi(lp_local) + idint(Ediff_si)
print*, 'nabsc(lp_local), nabsc(lp_local)  + idint(Ediff_ac)'
print*, nabsc(lp_local), nabsc(lp_local)  + idint(Ediff_ac)
 write(6,'(1p3e10.2,a40)') Ediff_si, Ediff_ac, Ediff, &
& ' = Esi,Eac, Ediff [epak] in MRW'
end if
! ----------------------
! 6.3 Wegen Ediff Berechnung der neuen Frequenz des Paketes
           if(old_random.eq.1) then 
              call random_number(ran1)
              call random_number(ran2)
           else
              ran1 = get_random(omp_get_thread_num())
              ran2 = get_random(omp_get_thread_num())
           endif

! 6.3.1  Absorption durch Si und Erwärmung auf T_Si und Frequenz jf der 
!        Reemission durch Silikate vom Zufallsgenerator

  if (fak2.ge.ran1) then 
	 Eabsz = (nabssi(lp_local)-0.5)*init%epak/(4*pi*UWmass)
	 call locat(QBsi,init%ntg,Eabsz,jl)
	 if (jl.lt.1) jl=1
	 if (jl.ge.init%ntg) jl=init%ntg-1
	 Tsi(lp_local) = Td(jl) + &
&              (Td(jl+1)-Td(jl))/(QBsi(jl+1)-QBsi(jl))*(Eabsz-QBsi(jl))
	 fak = (Tsi(lp_local) - Td(jl)) / (Td(jl+1)-Td(jl))
 	 QsBip = QsBsi(jl) + fak*(QsBsi(jl+1) - QsBsi(jl)) 
	 kl=1
	 sumQsBip = sumQsBsi(jl,kl)+fak*(sumQsBsi((jl+1),kl) - sumQsBsi(jl,kl))

!  6.3.1.1  Frequenz jf der Reemission durch Silikate vom Zufallsgenerator
   do while (kl.le.init%nd.and.sumQsBip/QsBip.le.ran2)
	sumQsBip = sumQsBsi(jl,kl)+fak*(sumQsBsi((jl+1),kl) - sumQsBsi(jl,kl))
	jf_local = kl
	kl = kl +1
   end do


  else

! 6.3.2  Absorption durch aC und Erwärmung auf T_aC
	Eabsz = (nabsc(lp_local)-0.5)*init%epak/(4*pi*UWmass)
	call locat(QBc,init%ntg,Eabsz,jl)
	if (jl.lt.1) jl=1
	if (jl.ge.init%ntg) jl=init%ntg -1
	Tc(lp_local) = Td(jl) + &
&            (Td(jl+1)-Td(jl))/(QBc(jl+1)-QBc(jl))*(Eabsz-QBc(jl))
	fak = (Tc(lp_local) - Td(jl)) / (Td(jl+1)-Td(jl))
	QsBip = QsBc(jl) + fak*(QsBc(jl+1) - QsBc(jl))
	kl=1
	sumQsBip = sumQsBc(jl,kl)+fak*(sumQsBc((jl+1),kl) - sumQsBc(jl,kl))

!  6.3.2.1  Frequenz jf der Reemission durch aC vom Zufallsgenerator
    do while (kl.le.init%nd.and.sumQsBip/QsBip.le.ran2)
	sumQsBip = sumQsBc(jl,kl)+fak*(sumQsBc((jl+1),kl) - sumQsBc(jl,kl))
	jf_local = kl
	kl = kl + 1
    end do
    end if   ! End Berechnung neuer Frequenz durch Silikat oder aC
! Paket wird mit neuer Richtung zum Rand der diff Sph gebeamt
              if(old_random.eq.1) then 
                call random_number(ran1)
                call random_number(ran2)
               else
                ran1 = get_random(omp_get_thread_num())
                ran2 = get_random(omp_get_thread_num())
               endif
           d = get_direction(ran1,ran2)
           a = shift_AP(a,d,r0)

   	   call check_near_border_GW(a,iGW,s,init)

   end if    ! end Diff Approx. erfuellt.

end subroutine mrw
!
! --------------------------------------------------------------------
!

