program view

! beim erzuegen der bilder rotiere image um -90deg also bei
! theta=80.  verwende: myimage, (rotate(ima,theta-90))
!

use constants
use parameter
use view_subroutines
implicit none

integer,allocatable             :: nUW(:,:,:)
integer,allocatable             :: nUW_new(:,:,:)
integer,allocatable             :: sumnUW_new(:,:,:)
integer                         :: ix,iy,iz
integer                         :: iux,iuy,iuz
integer                         :: ixnew,iynew,iznew
integer                         :: iuxnew,iuynew,iuznew
integer                         :: isumnUW
integer                         :: total_number_grids
integer                         :: nUW_read
integer                         :: lp_new,lp_old
integer                         :: hUW
integer                         :: ii
real*8,allocatable              :: Tsi_old(:)
real*8,allocatable              :: Tac_old(:)
real*8,allocatable              :: dicht_old(:)
real*8,allocatable             :: isca_old(:)
integer,allocatable             :: vek_new(:)
integer,allocatable             :: lp_lookup(:,:)
!integer,allocatable             :: frmrn_to_fd(:,:)


real*8 			:: theta
real*8 			:: phi
real*8                  :: BMC_x(8)                             !Border MC in image x-Coordinate
real*8                  :: BMC_y(8)                             !Border MC in image y-Coordinate
real*8			:: ximage(8),ximage_min,ximage_max
real*8			:: yimage(8),yimage_min,yimage_max
real*8                  :: stepp_x
real*8                  :: stepp_y
integer			:: naxes(2)
real*8,allocatable	:: image_emission(:,:)
real*8,allocatable	:: image_scatter(:,:)
real*8,allocatable      :: image_source(:,:)
real*8                  :: center_e(12,12)
real*8                  :: center_s(12,12)
character(30)		:: errtext
character(50)           :: fits_file
integer			:: status
integer                 :: sel_freq
integer                 :: stepp_freq

integer                 :: percent
real*8                  :: help
real*8			:: xs,ys,zs		!start
real*8			:: xe,ye,ze		!end
character*100           :: dummy
integer                 :: i_freq,n_freq,start_freq,end_freq


type(initial)           :: init
!transfer through init
real*8                  :: minI_x,minI_y,maxI_x,maxI_y
integer                 :: imx,imy
integer                 :: ixsub,iysub
integer                 :: nsubpixel
real*8                  :: IMC(3),IMC_x,IMC_y
real*8                  :: distance
real*8                  :: norm_x(3),norm_y(3)
real*8                  :: xd,yd,zd
real*8                  :: scax,scay,scaz !scattered ray directions
real*8                  :: cos_sca,g,fsca
integer                 :: nx_new,ny_new,nz_new
real*8                  :: stepp
real*8                  :: tau_max
real*8                  :: scatter_scale
integer                 :: output=1, istat,juwpah
integer                 :: tempi,sca_start,sca_end,rsca
integer*8               :: filepos
!
! ---------------
! 

stepp_freq=1
n_freq = mm

open(unit=25, file='input/view.inp', form='formatted')
rewind 25
read(25,*)   dummy
read(25,*)   naxes(1),  naxes(2)
read(25,*)   dummy
read(25,*)   tau_max
read(25,*)   dummy
read(25,*)   theta, phi
read(25,*)   dummy
read(25,*)   nsubpixel
read(25,*)   dummy
read(25,*)   sel_freq, start_freq, end_freq
!read switch to determine whether to read scatters?
read(25,*)   dummy
read(25,*)   rsca
read(25,*)   dummy
read(25,*)   dummy
read(25,*)   dummy
read(25,*)   dummy

close(unit=25)
theta=theta/180.*PI
phi=phi/180.*PI

print'(A,I4,A,I4)','Image size: ',naxes(1),'x',naxes(2)
print'(A,I4)','number sub pixel:', nsubpixel
print'(A,F5.2,A,F5.2,A)','viewing angle (theta,phi): (',theta,',',phi,')'
allocate(image_emission(naxes(1),naxes(2)))
allocate(image_scatter(naxes(1),naxes(2)))
image_emission=0d0
image_scatter=0d0
!allocate(image_source(naxes(1),naxes(2)))

call read_parameter
call source
call wstaub
call crosssec


      	vsgmass = abuc  * wmolc  / (abuc*wmolc + abusi*wmolsi) * abuvsg
      	pahmass = abuc  * wmolc  / (abuc*wmolc + abusi*wmolsi) * abupah	



!call omp_set_num_threads(12)
   nUWpah =0
   if(jpah .ne.0) then
     open(unit=20, file='output/pah_lpTpw.out')
     do while (nuwpah<naw)
         read(20,'(2i12)', end=10) lp,lp
         lp        = -lp
         read(20,'(1p2e12.4)', end=10) &
&        (tempuw(nuwpah*nnTvsg+i), pwuw(nuwpah*nnTvsg+i), i=1,nnTvsg)
!         print*, lp, nuwpah
         nuwpah = nuwpah+1
         ipahlp(nuwpah) = lp
      enddo
10   continue
   endif 
   if(nuwpah .ge. mpabs) stop ' memory error: nuwpah > mpabs'

if(rsca .eq. 1) then!if statement goes here
print*,'Read scattering look-up table'
allocate(sum_sca_freq(nd,2))
open(unit = 103,file = 'output/sum_scatters.txt',form = 'formatted')!, access = 'sequential')
rewind 103
do i=1,nd
!   print*,i
   read(103,*) tempi,sum_sca_freq(i,1),sum_sca_freq(i,2) !, '(i4, 2x, i6, 2x, i6)'
enddo
close(103)

!check scattering
!if (sum_sca_freq(nd,2) .ne. isumsca) stop 'sum of scatters incorrect'
print*,sum_sca_freq(nd,2)
endif!endif goes here


! test f. lp=518:
! lp = 518
! juwpah = 0
!do j =1, nuwpah
!  if(ipahlp(j).eq.lp) juwpah = j
!enddo
!print*, 'j=', juwpah, ipahlp(juwpah), lp
!write(6,'(1p2e12.3)') (tempuw((juwpah-1)*nnTvsg+i), pwuw((juwpah-1)*nnTvsg+i), i=1,nntvsg)
!stop



print*, ' Einlesen done'
! ------- 


n_freq = mm
stepp_freq = 1
if (sel_freq.gt.0) then 
        n_freq = 1
        sel_freq=sel_freq-1
endif
if (sel_freq.lt.0) then
        output=0
        stepp_freq = abs(sel_freq)
        sel_freq= start_freq
        n_freq = end_freq-start_freq
endif


if (idim3.eq.0) then
print*,'nfreq?:',n_freq
print*,'stepp freq:',stepp_freq
nx_new=2*nx 
ny_new=2*ny 
nz_new=2*nz 
allocate(sumnUW_new(nx_new,ny_new,nz_new))
allocate(nUW_new(nx_new,ny_new,nz_new))
allocate(nUW(nx_new/2,ny_new/2,nz_new/2))
sumnuw_new=0
nuw_new=0
nuw=0
print*,'spherical symetry'
open(unit=101, file='output/grid.bin', form='unformatted')
read (101) total_number_grids
do i=1,nx_new/2*ny_new/2*nz_new/2
	read(101) ix,iy,iz,nUW_read
	nUW(ix,iy,iz) = nUW_read
enddo
isumnUW=0
do ixnew=1,nx_new
do iynew=1,ny_new
do iznew=1,nz_new
        if (ixnew.le.nx_new/2) ix=nx_new/2-ixnew+1
        if (iynew.le.ny_new/2) iy=ny_new/2-iynew+1
        if (iznew.le.nz_new/2) iz=nz_new/2-iznew+1
        if (ixnew.gt.nx_new/2) ix=ixnew-nx_new/2
        if (iynew.gt.ny_new/2) iy=iynew-ny_new/2
        if (iznew.gt.nz_new/2) iz=iznew-nz_new/2
        isumnUW=isumnUW+nUW(ix,iy,iz)**3
        nUW_new(ixnew,iynew,iznew)=nUW(ix,iy,iz)
        sumnUW_new(ixnew,iynew,iznew)=isumnUW
enddo
enddo
enddo


close(101)
open(unit=102, file='output/absorbtion.bin', form='unformatted')
allocate(Tsi_old(total_number_grids))
Tsi_old=0d0
allocate(Tac_old(total_number_grids))
Tac_old=0d0
allocate(dicht_old(total_number_grids))
dicht_old=0d0
allocate(vek_new(8*total_number_grids))
vek_new=0
if(i_iso .le. 0) then !experimental to allow treatment of anisotropic scattering in axial symmetry
allocate(isca_old(total_number_grids))
isca_old=0
elseif(i_iso.gt.0)then
allocate(isca_old(8*total_number_grids))
isca_old=0
!would this be a quicker way to look-up lp_new?
allocate(lp_lookup(total_number_grids,8))
lp_lookup=0
endif

if (8d0*total_number_grids.ge.2147483647) stop !if more the 8byte integer values to big for lp_new vek
print*,'number grids:',8d0*total_number_grids
do i=1,total_number_grids
	read(102) lp_old,ix,iy,iz,iux,iuy,iuz,Tsi_old(i),Tac_old(i),dicht_old(i)
	do ii=0,7 
                ixnew = nx_new/2+(-1)**mod(ii/2**0,2)*(ix)+(1-(-1)**mod(ii/2**0,2))/2
		iynew = ny_new/2+(-1)**mod(ii/2**1,2)*(iy)+(1-(-1)**mod(ii/2**1,2))/2
		iznew = nz_new/2+(-1)**mod(ii/2**2,2)*(iz)+(1-(-1)**mod(ii/2**2,2))/2
                iuxnew=iux
                iuynew=iuy
                iuznew=iuz
                if (ixnew.le.nx_new/2) iuxnew = nUW_new(ixnew,iynew,iznew)-iux+1
		if (iynew.le.ny_new/2) iuynew = nUW_new(ixnew,iynew,iznew)-iuy+1
		if (iznew.le.nz_new/2) iuznew = nUW_new(ixnew,iynew,iznew)-iuz+1
                hUW=nUW_new(ixnew,iynew,iznew)
                lp_new=sumnUW_new(ixnew,iynew,iznew)-hUW**3+hUW**2*(iuxnew-1)+hUW*(iuynew-1)+iuznew
                vek_new(lp_new)=i
                if (i_iso .gt.0) lp_lookup(i,ii+1) = lp_new !quicker lookup?
	enddo
enddo
close(102)
endif 

if (idim3.eq.1) then 
nx_new=nx
ny_new=ny
nz_new=nz 
allocate(sumnUW_new(nx_new,ny_new,nz_new))
sumnuw_new=0
allocate(nUW_new(nx_new,ny_new,nz_new))
nuw_new=0
allocate(nUW(nx_new,ny_new,nz_new))
nuw=0

print*,'no spherical symetry'
open(unit=101, file='output/grid.bin', form='unformatted')
read (101) total_number_grids
do i=1,nx_new*ny_new*nz_new
	read(101) ix,iy,iz,nUW_read
	nUW(ix,iy,iz) = nUW_read
enddo
isumnUW=0
do ixnew=1,nx_new
do iynew=1,ny_new
do iznew=1,nz_new
        ix=ixnew
        iy=iynew
        iz=iznew
        isumnUW=isumnUW+nUW(ix,iy,iz)**3
        nUW_new(ixnew,iynew,iznew)=nUW(ix,iy,iz)
        sumnUW_new(ixnew,iynew,iznew)=isumnUW
enddo
enddo
enddo

close(101)
open(unit=102, file='output/absorbtion.bin', form='unformatted')
allocate(Tsi_old(total_number_grids))
Tsi_old=0d0
allocate(Tac_old(total_number_grids))
Tac_old=0d0
allocate(dicht_old(total_number_grids))
dicht_old=0d0
allocate(vek_new(total_number_grids))
vek_new=0
allocate(isca_old(total_number_grids))
isca_old=0

if (total_number_grids.ge.2147483647) stop !if more the 8byte integer values to big for lp_new vek
print*,'number grids:',total_number_grids,dgw
do i=1,total_number_grids
	read(102) lp_old,ix,iy,iz,iux,iuy,iuz,Tsi_old(i),Tac_old(i),dicht_old(i)
        ixnew = ix
        iynew = iy
	iznew = iz
        iuxnew=iux
        iuynew=iuy
        iuznew=iuz
        hUW=nUW_new(ixnew,iynew,iznew)
        lp_new=sumnUW_new(ixnew,iynew,iznew)-hUW**3+hUW**2*(iuxnew-1)+hUW*(iuynew-1)+iuznew
        vek_new(lp_new)=i
enddo
close(102)

endif 

if (10*maxval(nUW_new)*max(nx,ny,nz).gt.maxval(naxes)*nsubpixel) then
        print*,'number image pixels:'
        print*,maxval(nUW_new)*max(nx,ny,nz),'*',maxval(nUW_new)*max(nx,ny,nz),'necessary'
        print*,naxes(1)*nsubpixel,'*',naxes(2)*nsubpixel,'used'
        print*,'you may lose interesting information!!!!!!!!!'
endif

xd = sin(theta)*cos(phi)
yd = sin(theta)*sin(phi)
zd = cos(theta)	

if(theta .eq. pi .and. phi .eq. 0d0) then
	xd = 0d0
	yd = 0d0
	zd = -1d0
	print*,'check'
endif

norm_x(1)=cos(theta)*cos(phi)
norm_x(2)=cos(theta)*sin(phi)
norm_x(3)=-sin(theta)

norm_y(1)=-sin(phi)
norm_y(2)=cos(phi)
norm_y(3)=0
print*,'direction:',xd,yd,zd
print*,'norm_x   :',norm_x
print*,'norm_y   :',norm_y
!pause
do i=0,7
xs=nx_new/2d0-(-1)**mod(i/2**0,2)*nx_new/2d0
ys=ny_new/2d0-(-1)**mod(i/2**1,2)*ny_new/2d0
zs=nz_new/2d0-(-1)**mod(i/2**2,2)*nz_new/2d0
!print*,i+1,xs,ys,zs
BMC_x(i+1)=xs*cos(theta)*cos(phi)+ys*cos(theta)*sin(phi)-zs*sin(theta)
BMC_y(i+1)=-xs*sin(phi)+ys*cos(phi)
enddo
minI_x=MINVAL(BMC_x)
maxI_x=MAXVAL(BMC_x)
minI_y=MINVAL(BMC_y)
maxI_y=MAXVAL(BMC_y)
stepp_x=(maxI_x-minI_x)/(naxes(1)-1)
stepp_y=(maxI_y-minI_y)/(naxes(2)-1)
if (stepp_x.gt.stepp_y) then
        minI_y=minI_y-((stepp_x-stepp_y)*naxes(2))/2d0
        maxI_y=maxI_y+((stepp_x-stepp_y)*naxes(2))/2d0
        stepp_y=(maxI_y-minI_y)/(naxes(2)-1)
endif
if (stepp_y.gt.stepp_x) then
        minI_x=minI_x-((stepp_y-stepp_x)*naxes(1))/2d0
        maxI_x=maxI_x+((stepp_y-stepp_x)*naxes(1))/2d0
        stepp_x=(maxI_x-minI_x)/(naxes(1)-1)
endif
stepp=MAX(stepp_x,stepp_y)
print*,'Image size in MC-grid coordinates = ( ',stepp*naxes(1),' , ',stepp*naxes(2),' )'
IMC(1)=nx_new/2d0+1.1*sign(1d0,xd)*nx_new/2d0
IMC(2)=ny_new/2d0+1.1*sign(1d0,yd)*ny_new/2d0
IMC(3)=nz_new/2d0+1.1*sign(1d0,zd)*nz_new/2d0
IMC_x=IMC(1)*cos(theta)*cos(phi)+IMC(2)*cos(theta)*sin(phi)-IMC(3)*sin(theta)
IMC_y=-IMC(1)*sin(phi)+IMC(2)*cos(phi)
percent=0
open(unit=33, file='output/sed.out', form='formatted')
rewind 33
write(33,*) 'Wavelength    Emission    Scattering'
do i_freq=sel_freq+1,sel_freq+n_freq,stepp_freq
help=0
if(rsca .eq. 1) then!scattering - if goes here
!find frequency range in fd which corresponds to frequency selected in frmrn
   call locat(fd,nd,((frmrn(i_freq)+frmrn(i_freq-1))/2),sca_start)
   call locat(fd,nd,((frmrn(i_freq+1)+frmrn(i_freq))/2),sca_end)
!   call locat(fd,nd,((frmrn(i_freq))),sca_start)
!   call locat(fd,nd,((frmrn(i_freq+1))),sca_end)
   if(sca_end .lt. sca_start)then
      tempi = sca_start
      sca_start = sca_end
      sca_end = tempi
   endif
!   print*, 'sca_start =  ',sca_start,'fr start = ', fd(sca_start),'  sca_end =  ', sca_end,'fr end = ',&
!& fd(sca_end),'frmrn = ',frmrn(i_freq)
   if((sca_start .ge. 1) .and. (sca_end .le. nd) .and. (sca_start .ne. sca_end))then
      init%scatter_scale = epak/dist**2 / pi4 / abs(fd(sca_end)-fd(sca_start))
   else
      init%scatter_scale = 0
   endif

!print*,epak,' ',dist,' ',pi4,' ',abs(fd(sca_end)-fd(sca_start))
!print*,'scale factor   ',init%scatter_scale

if(isnan(init%scatter_scale)) stop 'scale factor isNaN'

isca_old = 0
if(sca_start .ne. sca_end) then !section needs fixing for low freq scatters
if(sca_start .lt. 1) sca_start=1
open(unit = 104,file = 'output/scatters.bin',access = 'stream',form = 'unformatted', status = 'old')
rewind 104
if((sum_sca_freq(sca_end,2) - sum_sca_freq(sca_start,2)) .gt. 0) then
   if(i_iso .le. 0) then
      do i = sum_sca_freq(sca_start,2),sum_sca_freq(sca_end,2) - 1 
         filepos = i
         filepos = 1 + 4*filepos
         read(104,POS=filepos) tempi
         isca_old(tempi) = isca_old(tempi)+1
      enddo
   elseif(i_iso.gt.0) then
      if(idim3 .eq. 1) then
      do i = sum_sca_freq(sca_start,2),sum_sca_freq(sca_end,2) - 1
         filepos = i
         filepos = 1 + 28*filepos
         if (filepos .lt. 0) then
            print*,'filepos  ',filepos,' i  ',i
            stop
         endif
         read(104,POS=filepos) tempi,scax,scay,scaz
         cos_sca = (xd*scax +yd*scay +zd*scaz) !angle between incoming direction and view direction
         if (cos_sca .gt. 1) cos_sca = 1
         if (cos_sca .lt. -1) cos_sca = -1
         g = g_si_mrn(i_freq)*K_sca_Si(i_freq) + g_ac_mrn(i_freq)*K_sca_aC(i_freq)!need to average g-factor over Si and aC by K_sca?
         g = g/(K_sca_Si(i_freq) + K_sca_aC(i_freq))
         fsca = 1-g*g !scattering phase function in this direction
         fsca = fsca /((1+ g*g -2*g*cos_sca)**1.5) !should really be integrated over, but beam has no angular diameter?
         isca_old(tempi) = isca_old(tempi) + fsca
      enddo
      elseif(idim3 .ne.1) then !experimental! 
         print*,'Warning, experimental! May not work as intended.'
        do i = sum_sca_freq(sca_start,2),sum_sca_freq(sca_end,2) - 1
         filepos = i
         filepos = 1 + 28*filepos
         if (filepos .lt. 0) then
            print*,'filepos  ',filepos,' i  ',i
            stop
         endif
         read(104,POS=filepos) tempi,scax,scay,scaz
         ii=0

! try different lookup, is it faster?
         do ii = 0,7
            j = lp_lookup(tempi,ii+1)
            cos_sca = ((xd*((-1)**mod(ii/1,2))*scax) + (yd*((-1)**mod(ii/2,2))*scay) + (zd*((-1)**mod(ii/4,2))*scaz)) !old test gave wrong octants
            !cos_sca = ( (xd*((-1)**mod((ii+3)/4,2)*scax)) +(yd*((-1)**mod((ii+1)/2,2))*scay) +(zd*((-1)**mod(ii,2)*scaz))) !angle between incoming direction and view direction
            if (cos_sca .gt. 1) cos_sca = 1
            if (cos_sca .lt. -1) cos_sca = -1
            g = g_si_mrn(i_freq)*K_sca_Si(i_freq) + g_ac_mrn(i_freq)*K_sca_aC(i_freq)!need to average g-factor over Si and aC by K_sca?
            g = g/(K_sca_Si(i_freq) + K_sca_aC(i_freq))
            fsca = 1-g*g !scattering phase function in this direction
            fsca = fsca /((1+ g*g -2*g*cos_sca)**1.5) !should really be integrated over, but beam has no angular diameter?
            if(isnan(fsca)) print*,j,ii,fsca,g,cos_sca,scax,scay,scaz,K_sca_Si(i_freq),K_sca_aC(i_freq)
            isca_old(j) = isca_old(j) + fsca
         enddo

!         do j = 1, 8*total_number_grids
!            if(vek_new(j) .eq. tempi) then
!               ii = ii+1
!               if (ii .eq. 9) stop 'ii overflow'
!!$               if (ii .eq. 1) then
!                  cos_sca = ( (xd*((-1)**mod((ii+3)/4,2)*scax)) +(yd*((-1)**mod((ii+1)/2,2))*scay) +(zd*((-1)**mod(ii,2)*scaz))) !angle between incoming direction and view direction
!                  if (cos_sca .gt. 1) cos_sca = 1
!                  if (cos_sca .lt. -1) cos_sca = -1
!                  g = g_si_mrn(i_freq)*K_sca_Si(i_freq) + g_ac_mrn(i_freq)*K_sca_aC(i_freq)!need to average g-factor over Si and aC by K_sca?
!                  g = g/(K_sca_Si(i_freq) + K_sca_aC(i_freq))
!                  fsca = 1-g*g !scattering phase function in this direction
!                  fsca = fsca /((1+ g*g -2*g*cos_sca)**1.5) !should really be integrated over, but beam has no angular diameter?
!                  isca_old(j) = isca_old(j) + fsca
!!$               elseif (ii .eq. 2) then
!!$                  cos_sca = (xd*(-1)*scax +yd*(-1)*scay +zd*scaz) !angle between incoming direction and view direction
!!$                  if (cos_sca .gt. 1) cos_sca = 1
!!$                  if (cos_sca .lt. -1) cos_sca = -1
!!$                  g = g_si_mrn(i_freq)*K_sca_Si(i_freq) + g_ac_mrn(i_freq)*K_sca_aC(i_freq)!need to average g-factor over Si and aC by K_sca?
!!$                  g = g/(K_sca_Si(i_freq) + K_sca_aC(i_freq))
!!$                  fsca = 1-g*g !scattering phase function in this direction
!!$                  fsca = fsca /((1+ g*g -2*g*cos_sca)**1.5) !should really be integrated over, but beam has no angular diameter?
!!$                  isca_old(i) = isca_old(i) + fsca
!            endif
!         enddo !lp finding loop
         enddo !file reading loop
      endif
   endif
endif
close(unit=104)
endif
endif!end of scattering - endif goes here

print*,'Done reading scatters'

! save inital values
init%minI_x = minI_x 
init%minI_y = minI_y
init%maxI_x = maxI_x
init%maxI_y = maxI_y
init%IMC = IMC
init%IMC_x = IMC_x
init%IMC_y = IMC_y
init%distance = dist
init%norm_x = norm_x
init%norm_y = norm_y
init%xd = xd
init%yd = yd
init%zd = zd
init%nx_new = nx_new
init%ny_new = ny_new
init%nz_new = nz_new
init%stepp = stepp
init%tau_max = tau_max
init%i_freq = i_freq
init%nsubpixel = nsubpixel
init%sca_start = sca_start
init%sca_end = sca_end
!print*,'check1'
!$OMP parallel do firstprivate(init) 
do imx=0,naxes(1)-1
do imy=0,naxes(2)-1
image_emission(imx+1,imy+1)=0
image_scatter(imx+1,imy+1)=0
do ixsub=0,nsubpixel-1
do iysub=0,nsubpixel-1
        init%imx = imx
        init%imy = imy
        init%ixsub = ixsub
        init%iysub = iysub
        call send_ray(image_emission,image_scatter,nUW_new,sumnUW_new,Tsi_old,Tac_old,dicht_old,vek_new,init,isca_old,rsca)
enddo 
enddo
enddo
enddo
!$OMP end parallel do
!print*,'check2'
status=0
image_emission = image_emission/1e-23
image_scatter = image_scatter/1e-23
!print*,''
if (output.ne.0) then
        write(fits_file,'(A,I3.3,A,E8.2,A)'),'output/images/test_emission_',i_freq,'-',welmrn(i_freq),'.fits'
        print*,'ds9 ',fits_file
        print*,'total Flux:',sum(image_emission)
        call deletefile(fits_file,status)
        call ftinit(104,fits_file,1,status)
        call ftphpr(104,.true.,-64,2,naxes,0,1,.true.,status)
        call ftpprd(104,1,1,naxes(1)*naxes(2),image_emission,status)
        call ftclos(104, status)
        call ftgerr(status,errtext)
        call ftfiou(104, status)

                write(fits_file,'(A,I3.3,A,E8.2,A)'),'output/images/test_scatter_',i_freq,'-',welmrn(i_freq),'.fits'
        print*,'ds9 ',fits_file
        print*,'total Flux:',sum(image_scatter)
        call deletefile(fits_file,status)
        call ftinit(104,fits_file,1,status)
        call ftphpr(104,.true.,-64,2,naxes,0,1,.true.,status)
        call ftpprd(104,1,1,naxes(1)*naxes(2),image_scatter,status)
        call ftclos(104, status)
        call ftgerr(status,errtext)
        call ftfiou(104, status)
endif
!print*,'check3'
do i = 1,10 
   do j = 1,10
      center_e(i,j) = image_emission(i+naxes(1)/2,j+naxes(2)/2)
      center_s(i,j) = image_scatter(i+naxes(1)/2,j+naxes(2)/2)
   enddo
enddo

center_e = image_emission(58:69,58:69)
center_s = image_scatter(58:69,58:69)
!print*,'check4'
if(i_freq .ne. 0) then
       print*,welmrn(i_freq)*1e4,sum(image_emission),'   ',sum(image_scatter),'   ',sum(center_e),'   ',sum(center_s)
       write(33,*),welmrn(i_freq)*1e4,' ',sum(image_emission),' ',sum(image_scatter),'   ',sum(center_e),'   ',sum(center_s)
endif
enddo

deallocate(nUW)
deallocate(sumnUW_new)
deallocate(nUW_new)
deallocate(Tsi_old)
deallocate(Tac_old)
deallocate(dicht_old)
deallocate(vek_new)
deallocate(image_emission)
deallocate(image_scatter)
deallocate(isca_old)
if(idim3 .ne. 1 .and. i_iso .gt. 0) deallocate(lp_lookup)
if(rsca .eq. 1) deallocate(sum_sca_freq)
close(unit=33)
end program view

subroutine deletefile(filename,status)

integer status,unit,blocksize
character*(*) filename

if (status .gt. 0)return

call ftgiou(unit,status)

call ftopen(unit,filename,1,blocksize,status)

if (status .eq. 0)then
!         file was opened;  so now delete it 
          call ftdelt(unit,status)
else if (status .eq. 103)then
!         file doesn't exist, so just reset status to zero and clear errors
          status=0
          call ftcmsg
else
!         there was some other error opening the file; delete the file anyway
          status=0
          call ftcmsg
          call ftdelt(unit,status)
end if

!  Free the unit number for later reuse
call ftfiou(unit, status)
end
