FUNCTION SHpupil, dim,npix,pupdiam,cobs,vig,CENTER=CENTER

; INPUTS:
;
;   dim     = number total of pixel
;
;
;   pupdiam = size in pixel of the pupil (should be same as dim when pupil covers the CCD frame)
;
;   cobs    = relative diameter of the central obsturation
;             [float, <1, fraction of pupdiam]
;
;	npix	=number of pixel per subaperture
;
;	vig		= treshold of % of pixel in the subaperture, if below then mask(subap)=0
;
; OUTPUT:
;
;   2D mask with dim=number of subaperture

 nsub=dim/npix
 if not keyword_set(center) then begin
 	xc =  dim/2-0.5 & yc =  dim/2-0.5
 	endif else begin
 	xc = center(0)*npix-0.5 & yc = center(1)*npix-0.5
 	endelse

x  = findgen(dim)#replicate(1.,dim)
y  = transpose(x)
x  = x - xc
y  = y - yc
tmp   = sqrt(x^2.+y^2.)/(pupdiam/2.)

pup   =  (tmp LE 1.) AND (tmp GE cobs)         ; 1 under the pupil, 0 elsewhere
tpup  =  total(pup)

mask=intarr(nsub,nsub)
for i=0,nsub-1 do begin
for j=0,nsub-1 do begin
	subap=pup(i*npix:(i+1)*npix-1,j*npix:(j+1)*npix-1)
	;tvscl,congrid(subap,720,720)
	a=where(subap EQ 1,cts)
	rate=cts/float(npix^2)
	if rate LT vig then mask(i,j)=0 else mask(i,j)=1
endfor
endfor

return, mask

END

