FUNCTION CHECKTILT, im,SHCONFIG=SHCONFIG,TILT=TILT

;this program checks that the maximum of each subaperture of an image lies in the 4 central pixel
;if the SH image contains a large tilt > 1 pixel then the pixel with maximum flux is outside the 4 central ones for each sub-aperture,
; in that case the program compute where is this maximum pixel (in average) and crop the image accordingly to re-centre the pixels with maximum
;value within the 4 central pixels

nsub=SHCONFIG(0) & npix=SHCONFIG(1)

subflux=fltarr(nsub,nsub) & ind=fltarr(nsub,nsub,2) & image=fltarr(nsub*npix,nsub*npix) & tilt=intarr(2)
image(*)=median(im) ; create a pseudo final image with median value ~egal to input image background

;for each subaperture compute where and what is the maxima in sub-aperture local coordinates
	for i=0,nsub-1 do begin
		for j=0,nsub-1 do begin
		sub=im(i*npix:(i+1)*npix-1,j*npix:(j+1)*npix-1)
		mx = MAX(sub, location)
		ind(i,j,*) = ARRAY_INDICES(sub,location)
		subflux(i,j)=total(sub)
		endfor
	endfor

;set a threshold to take in to account only ilumintated sub-apertures
threshold=max(subflux)-1.*stdev(subflux)
k=where(subflux GT threshold,cts)
IF k(0) GE 0 THEN k2d= ARRAY_INDICES(subflux,k) ELSE return,im ;contain indices of subaperture with enough flux

;compute in average the maxima coordinates
Xpos=mean(ind(k2d(0,*),k2d(1,*),0))-(npix)/2.+0.5 & Ypos=mean(ind(k2d(0,*),k2d(1,*),1))-(npix)/2.+0.5
;print,xpos,ypos
tilt(0)=fix(xpos) & tilt(1)=fix(ypos)

crit=(npix-1)/4

;if the maxima are outside the 4 central pixels then recentre the image
if (abs(xpos) GE crit) OR (abs(ypos) GT crit) THEN BEGIN
xs=(fix(xpos)+fix(abs(xpos)))/2. & xt=(fix(xpos)-fix(abs(xpos)))/2.
ys=(fix(ypos)+fix(abs(ypos)))/2. & yt=(fix(ypos)-fix(abs(ypos)))/2.
array=im(xs:nsub*npix+xt-1,ys:nsub*npix+yt-1)
image(xs-fix(xpos):nsub*npix-xs-1,ys-fix(ypos):nsub*npix-ys-1)=array
;print,'pass'
return,image
endif ELSE BEGIN
return,im
ENDELSE
end