PRO DEROTATOR, path,identifier,platescale,background,taglist,tagnumber,datatype,REMOVEBACK=REMOVEBACK,UNIT=UNIT,$
				MASKPARA=MASKPARA,FOCUSFACTOR=FOCUSFACTOR,SHCONFIG=SHCONFIG,FOCUSOFFSET=FOCUSOFFSET,CONFIG=CONFIG,TAGNAME=TAGNAME

;	PURPOSE:	Assess spot motion due to derotator error
;				Input data should SH data taken while rotating the derotator
;				The 2d trajectory of the spot is then plot
;				Spot position is computed from tip tilt term of slopes measurement via the procedure PENTES64

;	INPUTS: 	path: string array, list of filepath to be read, pathname should contain rotation coordinates like encoder value
;				identifier: carrater(s) preceding the rotation coordinate of the derotator
;				background: background image to be subtracted
;				platescale:	SH plate scale

;	KEYWORDS:	MASKEDGE: same as PENTES64 program
;				REMOVEBACK=1 if background subtraction should be performed ELSE REMOVEBACK=0


nfile=n_elements(path)
zaxis=fltarr(nfile)
tiptilt=fltarr(nfile,2)


for k=0,nfile-1 do begin
	read_rtc_fits,path(k),frames,taglist,tagnumber,datatype,CONFIG=CONFIG,TAGNAME=TAGNAME
	if removeback EQ 1 then frames=frames-background

	SH_pentes,frames,slopes,tiltterm,focusterm,rmsslope,meanslope,angle,MASKPARA=MASKPARA,$
				REMOVETILT=0,REMOVEFOCUS=0,FOCUSFACTOR=FOCUSFACTOR,SHCONFIG=SHCONFIG, $
				FOCUSOFFSET=FOCUSOFFSET,ROTA=0,DATATYPE=DATATYPE
	tiptilt(k,*)=tiltterm

	;looking for X axis value in the filename
 	;positionoffirst_Y=STRPOS(path(k),identifier,/reverse_search) ;detect where is the last "identifier" in the string
	;if positionoffirst_y EQ -1 then print,'carracter identifer is not matching, be careful to lower case'
 	;stringvalue=strmid(path(k),positionoffirst_Y+STRLEN(identifier),7); extract 7 digit after the last "identifier", the "-" is allowed

	;concatenation of axis values read in the filename (when axis specified), divide by 1000 to get mm
 	;if positionoffirst_Y NE -1 then zaxis(k)=long(stringvalue(0))/1000.0

endfor

;conversion to parameter given in UNIT keyword
;SHCONFIG=[r.nsub,r.npix,r.firstfoc,r.lensletfoc,r.pixsize,r.pixscale,r.fratio]
CASE UNIT of
1:	tiptilt=tiptilt*platescale*1000
2:	tiptilt=tiptilt*platescale*shconfig(6)*0.776/20.0*1000
else:  tiptilt=tiptilt
endcase

CASE UNIT of
1:	title='SPOT TRAJECTORY in milli arcseconds'
2:	title='SPOT TRAJECTORY in microns at F/#'
else:	title='SPOT TRAJECTORY in SH pixel'
endcase

;plot the results along the Z axis if specified
If (nfile GT 1)  then  begin
plot,tiptilt(*,0),tiptilt(*,1),title=title
endif

end