PRO WID_BASE_0_event, Event	;I AM NOT A SOFTWARE ENGINEER

WIDGET_CONTROL, event.id, GET_UVALUE=yval
WIDGET_CONTROL, event.top,get_uvalue=r;,/NO_COPY,/CLEAR_EVENTS
eventclass=WIDGET_INFO(event.id,/UNAME)

if eventclass EQ 'DISPLAY' THEN BEGIN		;avoid that exclusive button of class 'display' generate 2 event
	if event.select EQ 0 THEN eventclass=''
	endif

IF (TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_TIMER') AND (r.live EQ 'ON') THEN BEGIN  ;set a new event in X seconds
    WIDGET_CONTROL, event.TOP, TIMER=1.
    WIDGET_CONTROL,r.messagelog_id,set_value='LIVE MODE is ON',/append
  ENDIF


;LOAD STORED CONFIGURATION and display window according to it, set result values but keep the current IDs
if event.id EQ r.loadconfig_id then begin
	restore,'SH_processConfig.idl'
	WIDGET_CONTROL, r.imagepath_id,set_value=c.imagepath
	WIDGET_CONTROL, r.affichepente_id,set_button=c.affichepente
	WIDGET_CONTROL, r.normdisplay_id,set_button=c.normdisplay
	WIDGET_CONTROL, r.removetilt_id,set_button=c.removetilt
	WIDGET_CONTROL, r.removefocus_id,set_button=c.removefocus
	WIDGET_CONTROL, r.rota_id,set_button=c.rota
	WIDGET_CONTROL, r.removeslope_id,set_button=c.removeslope
	WIDGET_CONTROL, r.identifier_id,set_value=c.identifier
	WIDGET_CONTROL, r.tabmenu_id,SET_TAB_CURRENT=c.tab
	WIDGET_CONTROL,	r.spotx_id,set_value=string(c.spotxy(0))
	WIDGET_CONTROL,	r.spoty_id,set_value=string(c.spotxy(1))
	WIDGET_CONTROL,	r.plate_id,set_button=c.plate
	WIDGET_CONTROL, r.platexy_id,SET_DROPLIST_SELECT=c.platexy
	WIDGET_CONTROL, r.dispSH_id,set_button=0
	tronk=where(c.filelist,cts)
	if cts NE 0 then WIDGET_CONTROL,r.filelist_id,set_VALUE=strmid(c.filelist[0:tronk(cts-1)],STRPOS(c.imagepath,'\',/reverse_search)+1,40)$
			,SET_DROPLIST_SELECT =c.filenumber ; in the drop list display file without pathname and remove all null '' components
	WIDGET_CONTROL,r.messagelog_id,set_VALUE='Last configuration loaded!',/append
	WIDGET_CONTROL,r.focfactor_id,set_value=string(c.focfactor)
	WIDGET_CONTROL,r.focoffset_id,set_value=string(c.focoffset)
	WIDGET_CONTROL,r.curvx_id,set_value=c.curvxy(0)
	WIDGET_CONTROL,r.curvy_id,set_value=c.curvxy(1)
	WIDGET_CONTROL,r.curvdisp_id,set_button=c.curvdisp
	WIDGET_CONTROL,r.centrex_id,set_value=string(c.centrexy(0))
	WIDGET_CONTROL,r.centrey_id,set_value=string(c.centrexy(1))
	WIDGET_CONTROL,r.platescale_id,set_value=string(c.platescale)
	WIDGET_CONTROL,r.nsub_id,set_value=string(c.nsub)
	WIDGET_CONTROL,r.npix_id,set_value=string(c.npix)
	WIDGET_CONTROL,r.firstfoc_id,set_value=string(c.firstfoc)
	WIDGET_CONTROL,r.lensletfoc_id,set_value=string(c.lensletfoc)
	WIDGET_CONTROL,r.pixsize_id,set_value=string(c.pixsize)
	WIDGET_CONTROL,r.pixscale_id,set_value=string(c.pixscale)
	WIDGET_CONTROL,r.mask_id,set_value=string(c.mask)
	WIDGET_CONTROL,r.obstruc_id,set_value=string(c.obstruc)
	WIDGET_CONTROL,r.xpup_id,set_value=string(c.xpup,format='(F4.1)')
	WIDGET_CONTROL,r.ypup_id,set_value=string(c.ypup,format='(F4.1)')
	WIDGET_CONTROL,r.tag_id,set_VALUE=c.taglist,SET_DROPLIST_SELECT=c.tag
	WIDGET_CONTROL,r.fratio_id,SET_VALUE=string(c.fratio)
	WIDGET_CONTROL,r.sat_id,SET_VALUE=string(c.sat)
	WIDGET_CONTROL,r.fluxmap_id,SET_button=c.fluxmap
	WIDGET_CONTROL,r.coldrop_id,SET_VALUE=string(findgen(40),format='(I2)'),SET_DROPLIST_SELECT=c.coldrop
	WIDGET_CONTROL,r.tiltterm_list,SET_VALUE=['Tilt (pix):','Angle (arcm)','Pos (mm)'],SET_DROPLIST_SELECT=c.tilttype
	WIDGET_CONTROL,r.focusterm_list,SET_VALUE=['ROC:','Focus@:'],SET_DROPLIST_SELECT=c.focusroc
	WIDGET_CONTROL,r.colstretch_id,SET_VALUE=c.colstretch
	WIDGET_CONTROL,r.wfaccuracy_id,SET_VALUE=c.wfaccuracy
	WIDGET_CONTROL,r.wfaccuracybox_id,SET_VALUE=string(c.wfaccuracy)
	WIDGET_CONTROL,r.maskbox_id,SET_VALUE=string(c.mask,format='(I2)')
	WIDGET_CONTROL,r.pupdiambox_id,SET_VALUE=string(c.pupdiam,format='(F4.1)')
	a=where(c.config EQ ['PICSIGHT-FULL','HOT','AOF','MAD','PICSIGHT','CUSTOM'])
	WIDGET_CONTROL,r.configdrop_id,SET_VALUE=['PICSIGHT-FULL','HOT','AOF','MAD','PICSIGHT','CUSTOM'],SET_DROPLIST_SELECT=a
	CASE c.display of
	0: WIDGET_CONTROL,r.dispSH_id,set_button=1
	1: WIDGET_CONTROL,r.fluxmap_id,set_button=1
	2: WIDGET_CONTROL,r.dispwf_id,set_button=1
	3: WIDGET_CONTROL,r.dispref_id,set_button=1
	ENDCASE
	WIDGET_CONTROL, r.wftilt_id,set_button=c.wfremove(0) & WIDGET_CONTROL, r.wffocus_id,set_button=c.wfremove(1)
	WIDGET_CONTROL, r.wfastig_id,set_button=c.wfremove(2) &	WIDGET_CONTROL, r.wfcoma_id,set_button=c.wfremove(3)
	WIDGET_CONTROL, r.wftrefoil_id,set_button=c.wfremove(4) &WIDGET_CONTROL, r.wfspherical_id,set_button=c.wfremove(5)
	WIDGET_CONTROL, r.removewf_id,set_button=c.removewf
	WIDGET_CONTROL, r.largfoc_id,set_button=c.largfoc
	;Everything except r.XXX_id is reloaded (from struc c.to r.) in order to avoid overwriting ids with the old ones stored when pressing save config
	r.imagepath=c.imagepath & r.image=c.image & r.slopes=c.slopes
	r.affichepente=c.affichepente & r.identifier=c.identifier
	r.filelist=c.filelist & r.filenumber=c.filenumber & r.curvxy=c.curvxy
	r.normdisplay=c.normdisplay & r.fluxmap=c.fluxmap & r.fluxsub=c.fluxsub
    r.rota=c.rota & r.focfactor=c.focfactor & r.focoffset=c.focoffset
    r.removetilt=c.removetilt & r.removefocus=c.removefocus & r.focusroc=c.focusroc
    r.tiltterm=c.tiltterm & r.focusterm=c.focusterm & r.tilttype=c.tilttype
	r.fmax=c.fmax & r.spotxy=c.spotxy & r.tab=c.tab & r.largfoc=c.largfoc
	r.plate=c.plate & r.platexy=c.platexy & r.platescale=c.platescale
	r.centrexy=c.centrexy & r.curvdisp=c.curvdisp & r.xpup=c.xpup & r.ypup=c.ypup
	r.nsub=c.nsub & r.npix=c.npix & r.firstfoc=c.firstfoc & r.lensletfoc=c.lensletfoc & r.pixscale=c.pixscale & r.pixsize=c.pixsize & r.sat=c.sat
	r.mask=c.mask & r.obstruc=c.obstruc & r.fratio=c.fratio & r.config=c.config & r.taglist=c.taglist & r.tag=c.tag & r.datatype=c.datatype
	r.coldrop=c.coldrop & r.colstretch=c.colstretch & r.wfmap=c.wfmap & r.zern=c.zern & r.display=c.display
	r.wfpv=c.wfpv & r.wfrms=c.wfrms & r.wfremove=c.wfremove & r.wfaccuracy=c.wfaccuracy & r.pupdiam=c.pupdiam
	r.refwf=c.refwf & r.refslope=c.refslope & r.refpath=c.refpath & r.reftype=c.reftype & r.removeslope=c.removeslope & r.removewf=c.removewf
endif

;-----------SET CHECK BOX parameters to 0 or 1 when check boxes are activated or unactivated---------------------------
CASE event.id OF
r.affichepente_id: 		r.affichepente=event.select
r.fluxmap_id:			r.display = 1
r.dispwf_id:			r.display = 2
r.dispSH_id:			r.display = 0
r.dispref_id:			r.display = 3
r.removefocus_id:		r.removefocus=event.select
r.removetilt_id:		r.removetilt=event.select
r.rota_id:				r.rota=event.select
r.removeslope_id:		r.removeslope=event.select
r.filelist_id:			r.filenumber=event.index
r.tabmenu_id:			r.tab=event.tab
r.plate_id:				r.plate=event.select
r.platexy_id:			r.platexy=event.index
r.curvdisp_id:			r.curvdisp=event.select
r.live_id:				begin
						if r.live EQ 'OFF' THEN BEGIN
							r.live='ON' & WIDGET_CONTROL, event.TOP, TIMER=1 ;initate the loop mode when live button is pressed
						ENDIF ELSE BEGIN
						r.live='OFF'
						WIDGET_CONTROL,r.messagelog_id,set_value='LIVE MODE is OFF',/append
						ENDELSE
						end
r.configdrop_id:		begin ; configure here the correct parameter according to the data format and instrument used
						CASE event.index OF
						3:	begin
							r.config='MAD'
							r.npix=8 & r.nsub=8 & r.firstfoc=30.7 & r.lensletfoc=3.2 & r.pixsize=0.024 & r.pixscale=0.31
							r.fratio=20 & r.sat=10000 & r.obstruc=0.2 & r.xpup=4 & r.ypup=4 & r.pupdiam=8
							WIDGET_CONTROL,r.messagelog_id,set_value='Parameters set for MAD configuration',/append
							end
						1:	begin
							r.config='HOT'
							r.npix=4 & r.nsub=31 & r.firstfoc=30.7 & r.lensletfoc=3.2 & r.pixsize=0.024 & r.pixscale=0.31
							r.fratio=20 &r.sat=10000 & r.obstruc=0.14 & r.xpup=15.5 & r.ypup=15.5 & r.pupdiam=31
							WIDGET_CONTROL,r.messagelog_id,set_value='Parameters set for HOT configuration',/append
							end
						2:	begin
							r.config='AOF'
							r.npix=6 & r.nsub=40 & r.firstfoc=80 & r.lensletfoc=4.4 & r.pixsize=0.024 & r.pixscale=0.80
							r.fratio=15 & r.sat=10000  & r.obstruc=0.14 & r.xpup=20 & r.ypup=20 & r.pupdiam=40
							WIDGET_CONTROL,r.messagelog_id,set_value='Parameters set for AOF configuration',/append
							end
						4:	begin
							r.config='PICSIGHT'
							r.npix=6 & r.nsub=40 & r.firstfoc=80 & r.lensletfoc=5.4 & r.pixsize=0.024 & r.pixscale=0.8
							r.fratio=20 & r.sat=3700 & r.obstruc=0. & r.xpup=20 & r.ypup=20 & r.pupdiam=40
							WIDGET_CONTROL,r.messagelog_id,set_value='Parameters set for PICSIGHT configuration',/append
							end
						0:	begin
							r.config='PICSIGHT-FULL'
							r.npix=24 & r.nsub=40 & r.firstfoc=75. & r.lensletfoc=5.4 & r.pixsize=0.006 & r.pixscale=0.2
							r.fratio=13. & r.sat=3700 & r.obstruc=0. & r.xpup=20 & r.ypup=20 & r.pupdiam=40
							WIDGET_CONTROL,r.messagelog_id,set_value='Parameters set for PICSIGHT configuration',/append
							end
						5:	begin
							r.config='CUSTOM'
							r.npix=6 & r.nsub=40 & r.firstfoc=80 & r.lensletfoc=5.4 & r.pixsize=0.024 & r.pixscale=0.8
							r.fratio=20 & r.sat=250 & r.obstruc=0. & r.xpup=r.nsub/2. & r.ypup=r.nsub/2. & r.pupdiam=40
							WIDGET_CONTROL,r.messagelog_id,set_value='Parameters set for CUSTOM configuration',/append
							end
						ENDCASE
						;FILL CONFIGURATION TAB PARAMETERS ON CONFIGURATION LOAD (CUSTOM, MAD, HOT, AOF)
						WIDGET_CONTROL,r.nsub_id,set_value=string(r.nsub)
						WIDGET_CONTROL,r.npix_id,set_value=string(r.npix)
						WIDGET_CONTROL,r.firstfoc_id,set_value=string(r.firstfoc)
						WIDGET_CONTROL,r.lensletfoc_id,set_value=string(r.lensletfoc)
						WIDGET_CONTROL,r.pixsize_id,set_value=string(r.pixsize)
						WIDGET_CONTROL,r.pixscale_id,set_value=string(r.pixscale)
						WIDGET_CONTROL,r.fratio_id,set_value=string(r.fratio)
						WIDGET_CONTROL,r.sat_id,set_value=string(r.sat)
						WIDGET_CONTROL,r.obstruc_id,set_value=string(r.obstruc)
						WIDGET_CONTROL,r.pupdiambox_id,set_value=string(r.nsub,format='(F6.1)')
						WIDGET_CONTROL,r.xpup_id,set_value=string(r.xpup,format='(F5.1)')
						WIDGET_CONTROL,r.ypup_id,set_value=string(r.ypup,format='(F5.1)')
						end
r.tag_id:				r.tag=event.index
r.coldrop_id:			r.coldrop=event.index
r.focusterm_list:		Begin
						r.focusRoc=event.index
						if r.focusRoc EQ 1 then WIDGET_CONTROL,r.messagelog_id,set_value='You now display focus (mm) at SH focal plane entrance',/append ELSE $
												WIDGET_CONTROL,r.messagelog_id,set_value='You now display incoming  wavefront ROC (mm)',/append
						end
r.tiltterm_list:		Begin
						r.tilttype=event.index
						CASE r.tilttype of
						0:	WIDGET_CONTROL,r.messagelog_id,set_value='You now display tilt in SH pixel',/append
						2:	WIDGET_CONTROL,r.messagelog_id,set_value='You now display PSF shift (mm) at SH entrance',/append
						1:	WIDGET_CONTROL,r.messagelog_id,set_value='You now display incoming wavefront tilt in arcminutes',/append
						endcase
						end
r.removewf_id:			r.removewf=event.select
r.wftilt_id:			r.wfremove(0)=event.select
r.wffocus_id:			r.wfremove(1)=event.select
r.wfastig_id:			r.wfremove(2)=event.select
r.wfcoma_id:			r.wfremove(3)=event.select
r.wftrefoil_id:			r.wfremove(4)=event.select
r.wfspherical_id:		r.wfremove(5)=event.select
r.largfoc_id:			r.largfoc=event.select
ELSE:
ENDCASE

;-------------------SET EDIT BOX PARAMETER WHEN VALUES ARE TYPED (except path name)--------------------------------------------------
IF  (event.id EQ r.spotx_id) OR (event.id EQ r.spoty_id) $
		OR (event.id EQ r.focfactor_id) OR (event.id EQ r.curvx_id) OR (event.id EQ r.curvy_id) $
		OR (event.id EQ r.platescale_id) OR (event.id EQ r.focoffset_id) OR (event.id EQ r.centrey_id) $
		OR (event.id EQ r.centrex_id) OR (event.id EQ r.normdisplay_id) OR (event.id EQ r.colstretch_id) $
		OR (event.id EQ r.wfaccuracy_id) OR (eventclass EQ 'PUP') OR (eventclass EQ 'CONFIG') THEN BEGIN
	widget_control, event.id, get_value=value
	widget_control,event.id, set_value=value
	CASE event.id OF
		r.spotx_id:				r.spotxy(0)=value
		r.spoty_id :			r.spotxy(1)=value
		r.focfactor_id:			r.focfactor=value
		r.focoffset_id:			r.focoffset=value
		r.curvx_id:				r.curvxy(0)=value
		r.curvy_id:				r.curvxy(1)=value
		r.platescale_id:		r.platescale=value
		r.centrex_id:			r.centrexy(0)=value
		r.centrey_id:			r.centrexy(1)=value
		r.nsub_id:				r.nsub=value
		r.npix_id:				r.npix=value
		r.firstfoc_id:			r.firstfoc=value
		r.lensletfoc_id:		r.lensletfoc=value
		r.pixsize_id:			r.pixsize=value
		r.pixscale_id:			r.pixscale=value
		r.obstruc_id:			r.obstruc=value
		r.normdisplay_id:		r.normdisplay=value
		r.fratio_id:			r.fratio=value
		r.sat_id:				r.sat_id=value
		r.colstretch_id:		r.colstretch=value
		r.wfaccuracy_id:		begin
								r.wfaccuracy=value
								widget_control,r.wfaccuracybox_id, set_value=string(value,format='(F4.2)')
								end
		r.mask_id:				begin
								r.mask=value
								widget_control,r.maskbox_id, set_value=string(100-value,format='(I3)')
								WIDGET_CONTROL,r.messagelog_id,set_value='Subapertures vignetted at up to'$
									+string((100-value),format='(I3)')+'%  are supressed',/append
								end
		r.pupdiambox_id:		begin
								r.pupdiam=value
								widget_control,r.pupdiambox_id, set_value=string(r.pupdiam,format='(F4.1)')
								WIDGET_CONTROL,r.messagelog_id,set_value='Pupil diameter set to: '$
									+string(r.pupdiam,format='(F5.1)')+' subapertures',/append
								end
		r.xpup_id:				r.xpup=value
		r.ypup_id:				r.ypup=value
		ENDCASE
	IF eventclass EQ 'PUP' THEN BEGIN
		r.maskarray(0:r.nsub-1,0:r.nsub-1)=SHpupil(r.npix*r.nsub,r.npix,r.npix*r.pupdiam,r.obstruc,r.mask/100.0,CENTER=[r.xpup,r.ypup])
		WIDGET_CONTROL, r.subimage_id, GET_VALUE = subindex
		wset,subindex
		loadct,0,/silent;setting window and color
		tvscl,congrid(r.maskarray(0:r.nsub-1,0:r.nsub-1),150,150)
	ENDIF
ENDIF

;-------------------BUILD MASK IF NOT YET SET-------------------------------
IF total(r.maskarray) EQ 0 THEN r.maskarray(0:r.nsub-1,0:r.nsub-1)=SHpupil(r.npix*r.nsub,r.npix,r.npix*r.pupdiam,r.obstruc,r.mask/100.0,CENTER=[r.xpup,r.ypup])

;-------------------PROMPT FILEPATH in some case----------------------------------------------------------------------
if event.id EQ r.openimage_id THEN BEGIN
	if r.imagepath NE '' THEN path=r.imagepath ELSE path='D:\'
	r.imagepath = DIALOG_PICKFILE(FILTER=['*.fits','*.fit','*.fts','*.bmp'],path=path) 		; open window dialog box to chose the file input
	if r.imagepath EQ '' then WIDGET_CONTROL,r.messagelog_id,set_value='Please select a file '   ,/append
	WIDGET_CONTROL, r.imagepath_id,set_value=r.imagepath
endif

;update the imagepath when the drop list is used
if (event.id EQ r.filelist_id) THEN BEGIN
	r.imagepath=r.filelist(r.filenumber)
	WIDGET_CONTROL, r.imagepath_id,set_value=r.imagepath
endif

;update imagepath when a new path is typed
if (event.id EQ r.imagepath_id) THEN BEGIN
	WIDGET_CONTROL, r.imagepath_id,get_value=value
	WIDGET_CONTROL, r.imagepath_id,set_value=value
	r.imagepath=value
endif

;-----------------WHERE AND WHEN THE FILE IS READ----------------------------------------------------------------------
if eventclass EQ 'FILE' OR (r.live EQ 'ON') OR (event.id EQ r.configdrop_id) THEN BEGIN
	if r.imagepath NE '' then BEGIN
			IF (r.live EQ 'ON') OR (event.id EQ r.imreload_id) THEN BEGIN			;if live mode ON then return the file that has the largest digit after '_' and delete the others (dangerous check)
				filename=r.imagepath
				delete_live,filename
				r.imagepath=filename
				WIDGET_CONTROL, r.imagepath_id,set_value=filename
			ENDIF
			read_rtc_fits,r.imagepath,array,taglist,tagnumber,datatype,CONFIG=r.config,TAGNAME=r.taglist(r.tag)
			r.datatype=datatype
			CASE r.datatype of
			'frames':	begin
						;array=checktilt(array,SHCONFIG=[r.nsub,r.npix],tilt=tilt) ;in case of large tilt (>npix/4) crop and recentre images
						;if (abs(tilt(0)) LT (r.npix-1)/4) AND (abs(tilt(1)) LT (r.npix-1)/4) THEN BEGIN
						;	WIDGET_CONTROL,r.messagelog_id,set_value='Incident tilt angle within'+ string((r.npix-1)/4,format='(I2)')+' pixel: OK',/append
						;ENDIF ELSE BEGIN
						;	WIDGET_CONTROL,r.messagelog_id,set_value='Incident tilt angle X:'+string(tilt(0),format='(I3)')+$
						;					' pix, >'+string(tilt(0)*r.pixsize/(r.lensletfoc*0.0003),format='(F6.1)')+' arcmin',/append
						;	WIDGET_CONTROL,r.messagelog_id,set_value='Incident tilt angle Y:'+string(tilt(1),format='(I3)')+$
						;					' pix, >'+string(tilt(1)*r.pixsize/(r.lensletfoc*0.0003),format='(F6.1)')+' arcmin',/append
						;	WIDGET_CONTROL,r.messagelog_id,set_value='Sub-apertures have been shifted accordingly',/append
						;ENDELSE
							r.image(0:r.nsub*r.npix-1,0:r.nsub*r.npix-1)=array
						END
			'slopes':	r.slopes(0:r.nsub-1,0:r.nsub-1,*)=array
			ENDCASE
			r.taglist=strarr(10)
			r.taglist=taglist & r.tag=tagnumber
		 	WIDGET_CONTROL,r.tag_id,Set_value=r.taglist,SET_DROPLIST_SELECT=tagnumber
	endif else r.image=fltarr(512,512)
	WIDGET_CONTROL, r.dispSH_id,set_button=1
	r.display=0 & r.wfmap(*)=0
endif

;-----in case identifier filter is specified then search for all file of the current directory matching the filter and show it in the drop list menu
if (event.id EQ r.identifier_id) OR (event.id EQ r.imagepath_id) OR (event.id EQ r.openimage_id) THEN BEGIN
	if event.id EQ r.identifier_id THEN BEGIN
		widget_control, event.id, get_value=value
		widget_control,event.id, set_value=value
		r.identifier=value
		ENDIF
	position=STRPOS(r.imagepath,'\',/reverse_search) ; look for all file of the same directory having its name starting with the focus identifier value
	chemin=strmid(r.imagepath,0,position+1)+'*'+r.identifier+'*'
	chemin=file_search(chemin,count=count)
	WIDGET_CONTROL,r.messagelog_id,set_value=string(count,format='(I3)')+' files matching the filter in the current directory' ,/append
	if (count LT 100) AND (count GT 1) THEN BEGIN
			r.filelist[0:count-1]=[chemin(0:count-1)] & r.filelist[count:*]=strarr(100-count)
		endif
	if (count EQ 0) THEN BEGIN
			WIDGET_CONTROL,r.messagelog_id,set_value='The Filter is not matching any files',/append
			r.filelist=strarr(100)
			r.identifier=''
			endif
	if (count EQ 1) THEN r.filelist(0)=chemin
	WIDGET_CONTROL,r.filelist_id,set_VALUE=strmid(chemin,position+1,40),SET_DROPLIST_SELECT =0
	endif

;------------Display color bar-----------------------------------------------------------------------
;IF (eventclass EQ 'COL') OR  (event.id EQ r.loadconfig_id) THEN BEGIN
	WIDGET_CONTROL, r.coldraw_id, GET_VALUE = subindex
	wset,subindex & loadct,r.coldrop,/silent;setting window and color
	a=intarr(155,65)
	for i=0,154 do a(i,*)=i
	tvscl,a^r.colstretch
;ENDIF

;-------------- DISPLAY IMAGE INFO WHEN MOUSEOVER MAIN IMAGE FRAME --------------------
if (event.id EQ r.image_id) THEN begin
		xc=event.x*r.npix*r.nsub/512+1 & yc=event.y*r.npix*r.nsub/512+1
		xs=(xc-1)/r.npix & ys=(yc-1)/r.npix
		WIDGET_CONTROL, r.subXpos_id,set_value='X:       '+strtrim(string(xc/r.npix+1),1)
		WIDGET_CONTROL, r.subYpos_id,set_value='Y:       '+strtrim(string(yc/r.npix+1),1)
		WIDGET_CONTROL, r.fpos_id,set_value=string(r.image(xc-1,yc-1),format='(I)')
		WIDGET_CONTROL, r.fsub_id,set_value=string(r.fluxsub(xs,ys),format='(I)')
		WIDGET_CONTROL, r.subapX_id,set_value='X:'+string(r.slopes(xs,ys,0),format='(F7.3)')
		WIDGET_CONTROL, r.subapY_id,set_value='Y:'+string(r.slopes(xs,ys,1),format='(F7.3)')
		IF r.display EQ 0 THEN BEGIN
		;display subaperture image on mouse over of the main image frame
			WIDGET_CONTROL, r.subimage_id, GET_VALUE = subindex
			wset,subindex
			loadct,r.coldrop,/silent;setting window and color
			image=r.image(0:r.nsub*r.npix-1,0:r.nsub*r.npix-1)
			im=(image-min(image))^r.colstretch
			subim=congrid(im(r.npix*(xs):r.npix*(xs+1)-1,r.npix*(ys):r.npix*(ys+1)-1),150,150)
			im=congrid(im,512,512)
			im(0:149,0:149)=subim; dirty trick to have more or less the same color stretching between main frame and zoom frame
			tvscl,im
			loadct,3,/silent
			plots,74,74,psym=1,symsize=22,color=125,/device
		;display pixel values of the current sub-aperture in the lower rectangular image
			WIDGET_CONTROL, r.lineimage_id, GET_VALUE = index
			wset,index & loadct,0,/silent  ;set color and window
			erase,color=240
			subap=image(r.npix*(xs):r.npix*(xs+1)-1,r.npix*(ys):r.npix*(ys+1)-1)
			for i=0,r.npix-1 do xyouts,indgen(r.npix)/float(r.npix)*200+120,15+i/float(r.npix)*140,string(subap(*,i),format='(I)'),$
										CHARSIZE = 0.8,color=0,/device
		ENDIF
		IF r.display EQ 1 THEN BEGIN
			WIDGET_CONTROL, r.lineimage_id, GET_VALUE = index
			wset,index & loadct,0.,/silent ;set color and window
			plot,r.fluxsub(*,ys),xrange=[0,r.nsub],yrange=[0,max(r.fluxsub)],background=240,color=0,ytitle='Horiz. flux profile'
		ENDIF
endif

;------------ DISPLAY IMAGE INFO WHEN MOUSEOVER BOTTOM IMAGE FRAME --------------------
if (event.id EQ r.lineimage_id) AND (r.display EQ 2) THEN BEGIN
		bdr=[70.,490.]
		if (event.x GT bdr(0)) AND (event.x LT bdr(1)) then xc=fix((event.x-bdr(0))/(bdr(1)-bdr(0))*40)+1 else xc=0
		if xc NE 0 then begin
			Zernike_e,Modes=41,150,150,zcoef
			WIDGET_CONTROL, r.subimage_id, GET_VALUE = subindex
			wset,subindex
			loadct,r.coldrop,/silent;setting window and color
			tvscl,zcoef(*,*,xc)
		endif
endif

;-------LOAD REFERENCE (slopes or wavefront map)---------------------------------------
if (eventclass EQ 'REF') THEN BEGIN
		r.refpath= DIALOG_PICKFILE(FILTER='*.fits',path=path)
		r.display=3
		WIDGET_CONTROL,r.dispref_id,set_button=1
		if r.refpath NE '' then begin
			array=readfits(r.refpath)
			dim=size(array)
			IF event.id EQ r.refslope_id THEN BEGIN
				WIDGET_CONTROL,r.messagelog_id,set_value='Loaded reference slopes: '+r.refpath,/append
				r.refslope(0:dim(1)-1,0:dim(2)-1,*)=array
				r.reftype='SLOPE'
			ENDIF ELSE BEGIN
				r.refwf(0:dim(1)-1,0:dim(2)-1)=array
				r.reftype='WF'
			ENDELSE
		endif
endif

; ------COMPUTE SLOPES AND DISPLAY IMAGE or slope vector on Button event----------------------------
if  (event.id EQ r.loadconfig_id) OR (event.id EQ r.platescale_id) OR (event.id EQ r.focfactor_id) OR (event.id EQ r.focoffset_id) $
 	AND (r.imagepath NE '') OR (event.id EQ r.wfcompute_id) OR (eventclass EQ 'SLOPE') OR (eventclass EQ 'PUP') OR (eventclass EQ 'CONFIG') $
 	OR (eventclass EQ 'FILE') OR (eventclass EQ 'DISPLAY') OR (eventclass EQ 'REF')  OR (eventclass EQ 'COL') $
 	OR (r.live EQ 'ON') OR (event.id EQ r.configdrop_id) AND (r.tab NE 1) THEN BEGIN

 		im=r.image(0:r.nsub*r.npix-1,0:r.nsub*r.npix-1) & slopes=r.slopes(0:r.nsub-1,0:r.nsub-1,*) & refslope=r.refslope(0:r.nsub-1,0:r.nsub-1,*)

		;------------SLOPES COMPUTATION --------------------------------------------------
		SH_pentes,im,slopes,tiltterm,focusterm,rmsslope,meanslope,angle,MASKPARA=[r.mask,r.obstruc,r.xpup,r.ypup],$
			REMOVETILT=r.removetilt,REMOVEFOCUS=r.removefocus,REMOVEREF=r.removeslope,REFSLOPE=refslope,$
			FOCUSFACTOR=r.focfactor,ROTA=r.rota,FOCUSOFFSET=r.focoffset,SHCONFIG=[r.nsub,r.npix,r.firstfoc,r.lensletfoc,r.pixsize,r.pixscale,r.pupdiam],$
			DATATYPE=r.datatype,SUBFLUX=SUBFLUX,LARGFOC=r.largfoc,MASKARRAY=r.maskarray(0:r.nsub-1,0:r.nsub-1)
		r.slopes(0:r.nsub-1,0:r.nsub-1,*)=slopes
		r.tiltterm=tiltterm & r.fluxsub(0:r.nsub-1,0:r.nsub-1)=subflux

		;-----------PUPIL SHIFT attempt of computation
		;p=phase2ai_(phase=subflux,m=m,nbmodes=3.,pupdiam=r.pupdiam-2,largeur=r.nsub, $
		;				PMASK=[r.npix,1.,r.obstruc,r.xpup,r.ypup],/silent)
		;Zernike_e_,Modes=nbModes,r.pupdiam,r.nsub,SHpupil(r.npix*r.nsub,r.npix,r.npix*r.pupdiam,0.,1./100.0),m
		;flatpup=subflux-(p(1)*m(*,*,1)+p(2)*m(*,*,2))	; remove general gradient of flux over image
		;pupshift=(subapcentroid(flatpup)-[r.nsub/2.0-0.5,r.nsub/2.0-0.5])/r.nsub*100
		;r.fluxsub(0:r.nsub-1,0:r.nsub-1)=flatpup & subflux=flatpup

		;------------WAVEFRONT RECONSTRUCTION----------------------------------------------
		IF (event.id EQ r.wfcompute_id) THEN BEGIN
			If (r.removefocus EQ 0) AND (r.removetilt EQ 0) AND (r.rota EQ 0) THEN $
				 WIDGET_CONTROL,r.messagelog_id,set_value='WARNING: To enhance wavefront reconstruction accuracy, remove slopes tilt',/append
			;reconstruction zonal
			wfmap=WF_ZONAL(slopes,SHCONFIG=[r.nsub,r.npix,r.firstfoc,r.lensletfoc,r.pixsize,r.pixscale,r.pupdiam],PMASK=r.maskarray(0:r.nsub-1,0:r.nsub-1),ACC=r.wfaccuracy)

			;subtract refrence WF map
			IF r.removewf EQ 1 THEN wfmap=(wfmap-r.refwf(0:r.nsub-1,0:r.nsub-1))*r.maskarray(0:r.nsub-1,0:r.nsub-1)

			;modal projection of zonal reconstruction
			z=phase2ai_(phase=wfmap,modes=modes,nbmodes=41.,pupdiam=r.pupdiam,largeur=r.nsub,$
						PMASK=[r.npix,r.mask,r.obstruc,r.xpup,r.ypup],MASKARRAY=r.maskarray(0:r.nsub-1,0:r.nsub-1),/silent)
			if total(z) EQ 0 then WIDGET_CONTROL,r.messagelog_id,set_value='WARNING: Pupil outside boundaries zero zernike returned',/append
			r.zern=z(1:*)

			;removal of checked zernike from map
			wfmap=wfmap-r.wfremove(0)*r.zern(0)*modes(*,*,1)-r.wfremove(0)*r.zern(1)*modes(*,*,2)$
						-r.wfremove(1)*r.zern(2)*modes(*,*,3)-r.wfremove(2)*r.zern(3)*modes(*,*,4)$
						-r.wfremove(2)*r.zern(4)*modes(*,*,5)-r.wfremove(3)*r.zern(5)*modes(*,*,6)$
						-r.wfremove(3)*r.zern(6)*modes(*,*,7)-r.wfremove(4)*r.zern(7)*modes(*,*,8)$
						-r.wfremove(4)*r.zern(8)*modes(*,*,9)-r.wfremove(5)*r.zern(9)*modes(*,*,10)
			;set checked zernike to 0
			r.zern(0)=r.zern(0)*(1-r.wfremove(0)) & r.zern(1)=r.zern(1)*(1-r.wfremove(0))
			r.zern(2)=r.zern(2)*(1-r.wfremove(1))
			r.zern(3)=r.zern(3)*(1-r.wfremove(2)) &	r.zern(4)=r.zern(4)*(1-r.wfremove(2))
			r.zern(5)=r.zern(5)*(1-r.wfremove(3)) &	r.zern(6)=r.zern(6)*(1-r.wfremove(3))
			r.zern(7)=r.zern(7)*(1-r.wfremove(4)) &	r.zern(8)=r.zern(8)*(1-r.wfremove(4))
			r.zern(9)=r.zern(9)*(1-r.wfremove(5))

			WIDGET_CONTROL,r.zernikelog_id,set_value='Zernike Coef:'
			For i=0,40-1 do WIDGET_CONTROL,r.zernikelog_id,$
					set_value='Z'+string(i+1,format='(I2)')+':   '+ string([r.zern(i)],format='(I5)'),/append
			r.wfmap(0:r.nsub-1,0:r.nsub-1)=wfmap
			i=where(r.wfmap NE 0)
			r.wfpv=max(r.wfmap) & r.wfrms=stdev(r.wfmap(i))
			WIDGET_CONTROL,r.dispwf_id,set_button=1
			r.display=2
		ENDIF ELSE BEGIN
			IF total(r.wfmap) EQ 0 then wfmap=fltarr(r.nsub,r.nsub) ELSE wfmap=r.wfmap(0:r.nsub-1,0:r.nsub-1)
		ENDELSE

		;-------------DISPLAY ACTIONS-------------------------------------------------------
		;display  first the result from SH_pentes in the slopes boxes area

		CASE r.tilttype of ; convertion of tip tilt
		0: convert=1. ;displays are tilt values in pixel
		2: convert=r.pixsize/r.lensletfoc*r.firstfoc ;displays are spot display at SH entrance in mm
		1: convert=r.pixsize/r.lensletfoc/0.00029 ;displays are incident wavefront tilt in arcminutes
		ENDCASE
		WIDGET_CONTROL, r.tip_id,set_value='X:'+string(tiltterm(0)*convert,format='(F7.3)')
		WIDGET_CONTROL, r.tilt_id,set_value='Y:'+string(tiltterm(1)*convert,format='(F7.3)')
		if r.focusroc EQ 1 then focusterm=r.firstfoc^2/(focusterm+2*r.firstfoc) ;convert focusterm in ROC
		WIDGET_CONTROL, r.focusterm_id,set_value=string(focusterm,format='(F15.3)')+' mm'
		WIDGET_CONTROL, r.rotaterm_id,set_value=string(angle,format='(F15.3)')+' deg'
	   	r.fmax=[min(long(im)),max(long(im))]
	   	WIDGET_CONTROL, r.fluxmin_id,set_value=string(r.fmax(0),format='(I5)')
	   	WIDGET_CONTROL, r.fluxmax_id,set_value=string(r.fmax(1),format='(I5)')
		;WIDGET_CONTROL, r.pupshiftX_id,set_value='X:'+string(pupshift(0),format='(F7.2)')
		;WIDGET_CONTROL, r.pupshiftY_id,set_value='Y:'+string(pupshift(1),format='(F7.2)')
	   	if r.fmax(1) GT r.sat THEN WIDGET_CONTROL,r.messagelog_id,set_value='WARNING: SOME CCD PIXELS ARE SATURATED',/append
		if r.fmax(0) LT 0 THEN WIDGET_CONTROL,r.messagelog_id,set_value='WARNING NEGATIVE PIXEL IN THE IMAGE',/append

		;----display in the main image frame-----
		WIDGET_CONTROL, r.image_id, GET_VALUE = index  ;set which window and color table
		wset,index
		loadct,r.coldrop,/silent;setting window and color

		CASE r.display OF
		0:	tvscl,congrid((im-min(im))^r.colstretch,512,512)
		1:	tvscl,congrid(subflux^r.colstretch,512,512)
		2:	BEGIN
			tvscl,congrid(wfmap-min(wfmap),512,512,/interp,/minus_one)$
				*congrid(r.maskarray(0:r.nsub-1,0:r.nsub-1),512,512)
			WIDGET_CONTROL,r.wfrms_id,SET_VALUE=string(r.wfrms,format='(I5)')+' nm'
			WIDGET_CONTROL,r.wfpv_id,SET_VALUE=string(r.wfpv,format='(I5)')+' nm'
			IF total(r.zern) NE 0 THEN BEGIN
			WIDGET_CONTROL, r.lineimage_id, GET_VALUE = index
			wset,index & loadct,0.,/silent
			bar_plot_,r.zern,background=240,colors=findgen(50)+75,ytitle='ZERNIKE COEF.',$
				barnames=['1','2','3','4','5','6','7','8','9',' ','11',' ','13',' ','15',' ','17',' ','19',' ','21',' ','23',' ','25',' ','27',' ','29',' ','31',' ','33',' ','35',' ','37',' ','39',' ']
			ENDIF
			END
		3:	BEGIN
			IF r.reftype EQ 'SLOPE' THEN BEGIN
				tvscl,fltarr(512,512)
				slopes=r.refslope(0:r.nsub-1,0:r.nsub-1,*)
				r.affichepente=1 & WIDGET_CONTROL, r.affichepente_id,set_button=1
			ENDIF
			IF r.reftype EQ 'WF' THEN tvscl,congrid(r.refwf(0:r.nsub-1,0:r.nsub-1)-min(r.refwf(0:r.nsub-1,0:r.nsub-1)),512,512,/interp,/minus_one)$
								*congrid(r.maskarray(0:r.nsub-1,0:r.nsub-1),512,512)
			END
		ENDCASE

		;display slopes over main image
		IF r.affichepente EQ 1 THEN BEGIN
		norm=max(sqrt(slopes(*,*,0)^2+slopes(*,*,1)^2))/512.0*r.nsub*r.normdisplay
		WIDGET_CONTROL, r.image_id, GET_VALUE = index
		wset,index & loadct,2,/silent
		x=((indgen(r.nsub)*r.npix)+r.npix/2.0)*512/(r.npix*r.nsub)-0.5 & y=x
		velovect,slopes(*,*,0),slopes(*,*,1),x,y,/overplot,/device,length=norm,color=220,thick=1
		ENDIF
ENDIF

;------------------ALIGN MODE----- display cross over main image when align tab selected, print X Y position
IF r.tab EQ 1 THEN BEGIN
	r.display=1 & WIDGET_CONTROL,r.fluxmap_id,set_button=1 ;force radio button to be on display SH frame
	WIDGET_CONTROL, r.image_id, GET_VALUE = index
	subflux=fltarr(r.nsub,r.nsub)
	im=r.image(0:r.nsub*r.npix-1,0:r.nsub*r.npix-1)
	for i=0,r.nsub-1 do begin
			for j=0,r.nsub-1 do begin
			sub0=im(i*r.npix:(i+1)*r.npix-1,j*r.npix:(j+1)*r.npix-1)
    		subflux(i,j)=total(sub0)*r.maskarray(i,j)
			endfor
	endfor
	wset,index & loadct,3,/silent
	tvscl,congrid(subflux^r.colstretch,512,512)
	plots,256,256,psym=1,symsize=80,color=125,THICK=2,/device
	fit2d=gauss2dfit(subflux,alignspot)
	alignspotx=alignspot(4)+0.5-r.nsub/2. & alignspoty=alignspot(5)+0.5-r.nsub/2.
	WIDGET_CONTROL,r.alignspotX_id,SET_VALUE=string(alignspotx,format='(f5.1)')
	WIDGET_CONTROL,r.alignspotY_id,SET_VALUE=string(alignspoty,format='(f5.1)')
	loadct,2,/silent
	plots,256+alignspotx/r.nsub*512,256+alignspoty/r.nsub*512,psym=6,symsize=5,THICK=2,color=225,/device
	plots,256+alignspotx/r.nsub*512,256+alignspoty/r.nsub*512,psym=1,symsize=5,THICK=2,color=225,/device
ENDIF

;-----------------FSTOP MODE-----average subapertures within specified pupil and display
IF r.tab EQ 2 THEN BEGIN
  WIDGET_CONTROL,r.messagelog_id,set_value='Field of view tab selected',/append
	;average the flux of each pixel sub-aperture into a single subaperture
	image=r.image(0:r.nsub*r.npix-1,0:r.nsub*r.npix-1)
	subap=fltarr(r.npix,r.npix,r.nsub,r.nsub) & meansubap=fltarr(r.npix,r.npix)
	for i=0,r.nsub-1 do for j=0,r.nsub-1 do subap(*,*,i,j)=image(i*r.npix:(i+1)*r.npix-1,j*r.npix:(j+1)*r.npix-1)*r.maskarray(i,j)
	for i=0,r.npix-1 do for j=0,r.npix-1 do meansubap(i,j)=mean(subap(i,j,*,*))
	a=where(r.maskarray EQ 1,Nsubap)
	meansubap=meansubap*r.nsub^2/nsubap ;normalisation de la moyenne pour tenir compte du masque
	fstop=subapcentroid(meansubap)+[+0.5-r.npix/2.,+0.5-r.npix/2.]	;compute barycentre, middle of subap set to 0,0
	;display actions
	WIDGET_CONTROL,r.fstopX_id,SET_VALUE=string(fstop(0),format='(f6.3)')
	WIDGET_CONTROL,r.fstopY_id,SET_VALUE=string(fstop(1),format='(f6.3)')
	WIDGET_CONTROL, r.apimage_id, GET_VALUE = apindex
	wset,apindex
	loadct,r.coldrop,/silent;setting window and color
	subim=congrid(meansubap,150,150)
	im=(image-min(image))^r.colstretch
	im(0:149,0:149)=subim; dirty trick to have more or less the same color stretching between main frame and zoom frame
	tvscl,subim

	WIDGET_CONTROL, r.scrimage_id, GET_VALUE = scrindex
	wset,scrindex
	scrim=fltarr(2,2)
	scrim(0,0)=meansubap(0,0) & scrim(1,1)=meansubap(r.npix-1,r.npix-1) & scrim(0,1)=meansubap(0,r.npix-1) & scrim(1,0)=meansubap(r.npix-1,0)
	tvscl,congrid(scrim,150,150)
	fullflux=total(meansubap(r.npix/2-1:r.npix/2,r.npix/2-1:r.npix/2))/4.
	fstop(1)=(scrim(1,1)+scrim(0,1)-scrim(0,0)-scrim(1,0))/total(scrim)/2. ;diviser par deux suppose que le champ couvre la moitie du pixel du bord
	fstop(0)=(scrim(1,1)+scrim(1,0)-scrim(0,0)-scrim(0,1))/total(scrim)/2.
	WIDGET_CONTROL,r.scrX_id,SET_VALUE=string(fstop(0),format='(f6.3)')
	WIDGET_CONTROL,r.scrY_id,SET_VALUE=string(fstop(1),format='(f6.3)')
	loadct,2,/silent
	XYOUTS,[15,90,15,90],[30,30,110,110],strcompress(string(scrim,format='(f6.1)')),charsize=1.5,/device,color=100
	meansubap=fieldstop(-0.2,0.1,npix=r.npix,fill=0.80,meas=meansubap,plat=0.1,mag=25,/generate)  ;remplace la mesure par un champ genere
	;print,subapcentroid(meansubap)+[+0.5-r.npix/2.,+0.5-r.npix/2.]
	
	res=fieldstop(0.0,0.0,npix=r.npix,fill=0.91,meas=meansubap,plat=0.1,mag=25)
ENDIF

;-----------------------SAVE MENU-----------------------------------------------------
IF (eventclass EQ 'SAVE') THEN BEGIN
	savepath = DIALOG_PICKFILE(path=path,/write) 		; open window dialog box to chose a save file name
	CASE event.id OF
	r.saveslope_id:	writefits,savepath,r.slopes(0:r.nsub-1,0:r.nsub-1,*)
	r.savewf_id:	writefits,savepath,r.wfmap(0:r.nsub-1,0:r.nsub-1)
	r.saveflux_id:	writefits,savepath,r.fluxsub(0:r.nsub-1,0:r.nsub-1)
	r.saveall_id:	save,r,filename=savepath
	ENDCASE
ENDIF

;----------Clear log window when button is pressed------------------------------------
if (event.id EQ r.clearlog_id) THEN  WIDGET_CONTROL,r.messagelog_id,set_value=''

;display new configuration
WIDGET_CONTROL,r.messagelog_id,set_text_top_line=500
WIDGET_CONTROL, event.top,set_uvalue=r;,/CLEAR_EVENTS

if event.id EQ r.setup_id then begin	;enregistrement dans un fichier quand on appuie sur SET INPUT
	c=r						;passage dans une variable structure independante du programme pour eviter le conflit lors du reload avec les ids
	save,c,filename='SH_processConfig.idl'
	WIDGET_CONTROL,r.messagelog_id,set_value='Configuration saved in SH_processConfig.idl',/append
	endif

;------------------------STARTING PROGRAMS---------------------------------------
IF event.id EQ r.start_id THEN BEGIN
	tronk=where(r.filelist,cts)
	file=r.filelist[0:tronk(cts-1)]	;remove empty spaces in the r.filelist vector
	r.affichepente=0 & WIDGET_CONTROL, r.affichepente_id,set_button=r.affichepente

	;SPOT SIZE PROGRAM:
	IF r.tab EQ 3 THEN BEGIN
		WIDGET_CONTROL,r.messagelog_id,set_value='Spot size computation started:',/append
		WIDGET_CONTROL,r.messagelog_id,set_value='The spot must be moved with the SH X-Y axes, with a monomode fibre, and over 2 full pixels i.e 250 micrometers, plate scale computation option requires one more pixel',/append
		plate=r.platescale
		WIDGET_CONTROL, r.image_id, GET_VALUE = index
    wset,index & loadct,2,/silent
		spotsize, file,r.identifier,r.spotxy(0)-1,r.spotxy(1)-1,fullwidth,plate,fltarr(r.nsub,r.nsub),r.taglist,r.tag,r.datatype,$
					PLATESCALE=r.plate,platexy=r.platexy,CONFIG=r.config,TAGNAME=r.taglist(r.tag),$
					SHCONFIG=[r.nsub,r.npix,r.firstfoc,r.lensletfoc,r.pixsize,r.pixscale,r.fratio,r.pupdiam],REMOVEBACK=0

		WIDGET_CONTROL,r.messagelog_id,set_value='SPOT FWHM COMPUTATION:'+string(fullwidth),/append
		if r.plate EQ 1 then WIDGET_CONTROL,r.messagelog_id,set_value='PLATE SCALE COMPUTATION:'+string(plate),/append
		r.platescale=plate
		WIDGET_CONTROL,r.platescale_id,set_value=string(r.platescale)
	ENDIF

	;FOCUS PROGRAM:-------------PROCEDURE TO BE MODIFIED DOES NOT WORK WITH NEW DATA FORMAT-------------------------------------
	IF r.tab EQ 4 THEN BEGIN
		WIDGET_CONTROL,r.messagelog_id,set_value='Focus computation program started',/append
		WIDGET_CONTROL,r.messagelog_id,set_value='The file should be a serie of defocused SH measurements',/append
		FOCUS64, file,r.identifier,bestfocus,linearfit,r.focfactor,fltarr(r.nsub,r.nsub),REMOVEBACK=0
	    r.focfactor=linearfit(1)
		WIDGET_CONTROL,r.messagelog_id,set_value='Best focus position found at:'+string(-linearfit(0)/linearfit(1))+' mm',/append
		WIDGET_CONTROL,r.messagelog_id,set_value='Linear error in focus computation:'+string(r.focfactor)+' mm',/append
		WIDGET_CONTROL,r.focfactor_id,set_value=string(r.focfactor)

	ENDIF

	;DEROTATOR PROGRAM:-------------PROCEDURE TO BE MODIFIED DOES NOT WORK WITH NEW DATA FORMAT-------------------------------------
	IF r.tab EQ 5 THEN BEGIN
		WIDGET_CONTROL,r.messagelog_id,set_value='DEROTATOR program started',/append
		WIDGET_CONTROL,r.messagelog_id,set_value='This program plot spot trajectory starting from measurement taken by derotator',/append
		DEROTATOR,file,r.identifier,r.platescale,fltarr(r.nsub,r.nsub),r.taglist,r.tag,r.datatype,REMOVEBACK=0,UNIT=0,$
				MASKPARA=[r.mask,r.obstruc],FOCUSFACTOR=r.focfactor,SHCONFIG=[r.nsub,r.npix,r.firstfoc,r.lensletfoc,r.pixsize,r.pixscale,r.fratio,r.pupdiam],$
				FOCUSOFFSET=r.focoffset,CONFIG=r.config,TAGNAME=r.taglist(r.tag)
	ENDIF

	;Align PROGRAM:-------------PROCEDURE OK-------------------------------------
	IF r.tab EQ 1 THEN BEGIN
	WIDGET_CONTROL,r.messagelog_id,set_value='Align tab selected',/append
	;PUPIL64,file,r.identifier,r.backimage
	ENDIF

	;CURVATURE PROGRAM-------------PROCEDURE TO BE MODIFIED DOES NOT WORK WITH NEW DATA FORMAT-------------------------------------
	IF r.tab EQ 6 THEN BEGIN
	WIDGET_CONTROL,r.messagelog_id,set_value='Field curvature program started',/append
	WIDGET_CONTROL,r.messagelog_id,set_value='The input data should be SH images taken over the field of view if possible symetric around the orgin',/append
	WIDGET_CONTROL,r.messagelog_id,set_value='The program compute focus term for each fibre position',/append
	WIDGET_CONTROL,r.messagelog_id,set_value='The option Display curvature only subtract (rougthly) a general tilt over the image due to a bad alignment of the fibre XY stage with the nominal entrance focal plane',/append
	fieldcurv,file,r.curvxy(0),r.curvxy(1),coefx,coefy,fltarr(r.nsub,r.nsub),r.taglist,r.tag,r.datatype,CONFIG=r.CONFIG,TAGNAME=r.taglist(r.tag),$
			REMOVEBACK=0,FOCUSFACTOR=r.focfactor,focusoffset=r.focoffset,CURVONLY=r.curvdisp,CENTREXY=r.centrexy,$
			SHCONFIG=[r.nsub,r.npix,r.firstfoc,r.lensletfoc,r.pixsize,r.pixscale,r.fratio,r.pupdiam],MASKPARA=[r.mask,r.obstruc]

	WIDGET_CONTROL,r.messagelog_id,set_value='General tilt misalignment of X stage:'+string(coefx(1)*180/3.14)+' deg',/append
	WIDGET_CONTROL,r.messagelog_id,set_value='General tilt misalignment of Y stage:'+string(coefy(1)*180/3.14)+' deg',/append
	ENDIF
endif

END

;#########################################    WIDGET LAYOUT DEFINITION   #####################################################################
pro WID_BASE_0, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_

  ;Resolve_Routine, 'SH_process_eventcb',/COMPILE_FULL_FILE  ; Load event callback routines

  WID_BASE_0 = Widget_Base( GROUP_LEADER=wGroup, UNAME='WID_BASE_0'  $
      ,XOFFSET=5 ,YOFFSET=5 ,SCR_XSIZE=1240 ,SCR_YSIZE=725 ,TITLE='Pro'+ $
      ' Shack Hartman Process window - VERSION 3c' ,SPACE=3 ,XPAD=3 ,YPAD=3  $
      ,MBAR=WID_BASE_0_MBAR)

;----------FILE INFORMATION---------------------------------------------------------------------------------------

imagepath_label = Widget_Label(WID_BASE_0,XOFFSET=4 ,YOFFSET=10 ,/ALIGN_LEFT ,VALUE='Data Path:',FONT = "verdana*12")
imagepath_id = Widget_Text(WID_BASE_0,XOFFSET=70,YOFFSET=8 ,SCR_XSIZE=425 ,SCR_YSIZE=19,/editable,UNAME='FILE',FONT = "verdana*12")
imreload_base=WIDGET_BASE(WID_BASE_0,xoffset=480,yoffset=1, scr_xsize=80,scr_ysize=26)
imreload_id=WIDGET_BUTTON(imreload_base,value='RELOAD',xoffset=20,yoffset=5,FONT = "verdana*12",UNAME='FILE')
identifier_label = Widget_Label(WID_BASE_0,XOFFSET=4 ,YOFFSET=35,/ALIGN_LEFT ,VALUE='Data Filter:',FONT = "verdana*12")
identifier_id = Widget_Text(WID_BASE_0,XOFFSET=70,YOFFSET=33 ,SCR_XSIZE=105,SCR_YSIZE=20,/editable,FONT = "verdana*12")
filelist_id = Widget_droplist(WID_BASE_0,XOFFSET=180,YOFFSET=33,SCR_XSIZE=280,/ALIGN_RIGHT,VALUE='No filter set',UNAME='FILE',FONT = "verdana*12")
tag_id=Widget_droplist(WID_BASE_0,XOFFSET=465,YOFFSET=33,SCR_XSIZE=95,/ALIGN_RIGHT,VALUE='NO TAG',UNAME='FILE',FONT = "verdana*12")

file_menu = Widget_Button(WID_BASE_0_MBAR,/MENU,VALUE='Choose File')
openimage_id = Widget_Button(file_menu,VALUE='Open'+ ' Image Files',UNAME='FILE')
refslope_id = Widget_Button(file_menu,VALUE='Reference slopes',UNAME='REF')
refwf_id = Widget_Button(file_menu,VALUE='Reference wavefront',UNAME='REF')

save_menu = Widget_Button(WID_BASE_0_MBAR,/MENU,VALUE='Save fits')
saveslope_id = Widget_Button(save_menu,VALUE='Save slopes',UNAME='SAVE')
savewf_id = Widget_Button(save_menu,VALUE='Save wavefront',UNAME='SAVE')
saveflux_id = Widget_Button(save_menu,VALUE='Save subaperture flux',UNAME='SAVE')
saveall_id = Widget_Button(save_menu,VALUE='Save all',UNAME='SAVE')

image_id = Widget_Draw(WID_BASE_0,XOFFSET=565 ,YOFFSET=5 ,SCR_XSIZE=512 ,SCR_YSIZE=512,/motion_events)
subimage_id = Widget_Draw(WID_BASE_0,XOFFSET=1080 ,YOFFSET=520 ,SCR_XSIZE=150 ,SCR_YSIZE=150)
lineimage_id= Widget_Draw(WID_BASE_0,XOFFSET=565 ,YOFFSET=520 ,SCR_XSIZE=512 ,SCR_YSIZE=150,/motion_events)

messagelog_id=Widget_Text(WID_BASE_0,XOFFSET=4,YOFFSET=370,SCR_XSIZE=280,SCR_YSIZE=300,XSIZE=150$
		,YSIZE=220,/scroll,/wrap,FONT = "arial*12")
zernikelog_id=Widget_Text(WID_BASE_0,XOFFSET=285,YOFFSET=370,SCR_XSIZE=100,SCR_YSIZE=300,XSIZE=150$
		,YSIZE=220,/scroll,FONT = "arial*12")

;------------------DISPLAY CONFIGURATION SETTINGS--------------------------------------------------------------------------
DISP_BASE=Widget_Base(WID_BASE_0,XOFFSET=389,YOFFSET=80,TITLE='IDL',frame=1,SCR_XSIZE=172 ,SCR_YSIZE=255,COLUMN=1)
disp_label = widget_label(DISP_base,value='DISPLAY OPTIONS:',/ALIGN_CENTER,FONT = "verdana*14")
WID_BASE_1 = Widget_Base(DISP_BASE,TITLE='IDL',COLUMN=1,SCR_XSIZE=172 ,SCR_YSIZE=100,/exclusive)
dispSH_id = Widget_Button(WID_BASE_1,/ALIGN_LEFT ,VALUE='SHACK HARTMANN IMAGE',UNAME='DISPLAY',FONT = "verdana*12")
fluxmap_id=Widget_Button(WID_BASE_1,/ALIGN_LEFT ,VALUE='FLUX MAP',UNAME='DISPLAY',FONT = "verdana*12")
dispwf_id=Widget_Button(WID_BASE_1,/ALIGN_LEFT ,VALUE='WAVEFRONT MAP',UNAME='DISPLAY',FONT = "verdana*12")
dispref_id=Widget_Button(WID_BASE_1,/ALIGN_LEFT ,VALUE='REFERENCE MAP',UNAME='DISPLAY',FONT = "verdana*12")

color_base=WIDGET_BASE(DISP_BASE)
coldrop_label=widget_label(color_base,XOFFSET=3,YOFFSET=3,SCR_XSIZE=85,value='COLOR TABLE:',FONT = "verdana*12")
coldrop_id=Widget_droplist(color_base,XOFFSET=90,YOFFSET=0,SCR_XSIZE=45,/ALIGN_RIGHT,VALUE=string(indgen(40),FORMAT=('(I2)')),UNAME='COL',FONT = "verdana*12")
colstretch_label=widget_label(color_base,XOFFSET=3,YOFFSET=30,value='STRETCH:',FONT = "verdana*12")
stretch_base=WIDGET_BASE(color_base,XOFFSET=58, YOFFSET=25,xsize=110,ysize=20)
colstretch_id=CW_FSLIDER(stretch_base,scroll=0.2, minimum=0.1, maximum=1,value=1,/drag,/suppress_value,UNAME='COL')
coldraw_id = Widget_Draw(color_base,XOFFSET=5 ,YOFFSET=60 ,SCR_XSIZE=155 ,SCR_YSIZE=65)

;-----------------BITMAP--------------------------------------------------------------------------------------
;bitmap_base=Widget_Base(WID_BASE_0,XOFFSET=385,YOFFSET=265,TITLE='IDL',frame=0,SCR_XSIZE=185 ,SCR_YSIZE=100,COLUMN=1)
;bitmap_id=widget_button(bitmap_base, VALUE='calvin-1.bmp', /BITMAP)
;-----------------BOTTOM BUTTONS ------------------------------------------------------------------------------------
WID_BASE_3 = Widget_Base(WID_BASE_0, UNAME='WID_BASE_3' ,XOFFSET=0  $
      ,YOFFSET=337 ,TITLE='bottom buttons' ,/row,SCR_XSIZE=380,SCR_YSIZE=26,/ALIGN_right,xpad=10)

clearlog_id=WIDGET_BUTTON(WID_BASE_3,value='CLEAR LOG',FONT = "verdana*12")
start_id = Widget_Button(WID_BASE_3,VALUE='START',FONT = "verdana*12")
setup_id = Widget_Button(WID_BASE_3,VALUE='SAVE CONFIG',FONT = "verdana*12")
loadconfig_id = Widget_Button(WID_BASE_3,VALUE='LOAD CONFIG',FONT = "verdana*12")
live_id=WIDGET_BUTTON(WID_BASE_3,value='LIVE',FONT = "verdana*12")

;-----------------WAVEFRONT RECONSTRUCTION AREA---------------------------------------------------
WF_base= WIDGET_BASE(WID_BASE_0,xoffset=390,yoffset=370,frame=1,scr_xsize=170,scr_ysize=300)

wfconfig_base=WIDGET_BASE(WF_base,xoffset=10,yoffset=5, scr_xsize=150,scr_ysize=26)
wfcompute_id=WIDGET_BUTTON(WFconfig_BASE,value='BUILD WAVEFRONT',xoffset=20,yoffset=5,FONT = "verdana*12")

wfaccuracy_label=WIDGET_LABEL(WF_base,Value='Accuracy',xoffset=5,yoffset=45,FONT = "verdana*12")
wfaccuracybox_id=WIDGET_Text(WF_base,xoffset=128,yoffset=42,SCR_XSIZE=33,value='0.1',scr_ysize=18,FONT = "verdana*12")
accuracy_base=WIDGET_BASE(wf_base,XOFFSET=53, YOFFSET=40,xsize=95)
wfaccuracy_id=CW_FSLIDER(accuracy_base,xsize=65,scroll=0.01, minimum=0.01, maximum=0.1,value=0.1,/drag,/suppress_value)

wfdisplay_base=WIDGET_BASE(WF_base,xoffset=0,yoffset=70, scr_xsize=170,scr_ysize=50)
wfrms_label=WIDGET_LABEL(WFDISPLAY_BASE,VALUE='Wavefront RMS:', xoffset=5, yoffset=5, scr_xsize=80,scr_ysize=20,FONT = "verdana*12")
wfrms_id=WIDGET_text(WFDISPLAY_BASE, xoffset=95, yoffset=5, scr_xsize=65,scr_ysize=15,FONT = "verdana*12")
wfpv_label=WIDGET_LABEL(WFDISPLAY_BASE, VALUE='Wavefront PV:',xoffset=5, yoffset=30, scr_xsize=80,scr_ysize=20,FONT = "verdana*12")
wfpv_id=WIDGET_text(WFDISPLAY_BASE, xoffset=95, yoffset=30, scr_xsize=65,scr_ysize=15,FONT = "verdana*12")

wf_remove = Widget_Base(WF_BASE,COLUMN=1,/NONEXCLUSIVE,xoffset=0,yoffset=125,SCR_XSIZE=150 ,SCR_YSIZE=210)
removewf_id = Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove Reference map',FONT = "verdana*12")
wftilt_id= Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove tilt (Z1,Z2)',FONT = "verdana*12")
wffocus_id= Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove Focus (Z3)',FONT = "verdana*12")
wfastig_id= Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove Astig (Z4,Z5)',FONT = "verdana*12")
wfcoma_id= Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove Coma (Z6,Z7)',FONT = "verdana*12")
wftrefoil_id= Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove Trefoil (Z8,Z9)',FONT = "verdana*12")
wfspherical_id= Widget_Button(wf_remove,/ALIGN_LEFT ,VALUE='Remove spherical (Z10)',FONT = "verdana*12")

;---------------PARAMETERS INFORMATION-------------------------------------------------------------------------------
 WID_BASE_2 = Widget_Base(WID_BASE_0,XOFFSET=1080,YOFFSET=155,frame=1,SCR_XSIZE=150 ,SCR_YSIZE=360)

  subXY_id=Widget_label(WID_BASE_2,VALUE='   Subaperture #:',/align_center,yoffset=5,SCR_YSIZE=15,FONT = "verdana*12")
  subXpos_id = Widget_text(WID_BASE_2 ,xoffset=5,yoffset=20,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")
  subYpos_id = Widget_text(WID_BASE_2 ,xoffset=75,yoffset=20,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")

  subap_id = Widget_label(WID_BASE_2,VALUE='Slopes (pixels):',xoffset=5,yoffset=45,SCR_XSIZE=87,SCR_YSIZE=15,FONT = "verdana*12")
  subapX_id = Widget_text(WID_BASE_2 ,xoffset=5,yoffset=60,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")
  subapY_id = Widget_text(WID_BASE_2 ,xoffset=75,yoffset=60,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")

  tiltterm_list=Widget_droplist(WID_BASE_2,VALUE=['Tilt (pix):','Angle (arcm)','Pos (mm)'],xoffset=5,yoffset=90,SCR_XSIZE=100,SCR_YSIZE=20,UNAME='SLOPE',FONT = "verdana*12")
  tip_id = Widget_text(WID_BASE_2 ,xoffset=5,yoffset=115,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")
  tilt_id = Widget_text(WID_BASE_2 ,xoffset=75,yoffset=115,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")

  fluxsub_label=widget_label(WID_BASE_2,VALUE='Pixel Flux     Subap Flux',xoffset=5,yoffset=140,SCR_XSIZE=120,SCR_YSIZE=15,FONT = "verdana*12")
  fpos_id = Widget_text(WID_BASE_2,xoffset=5,yoffset=155,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")
  fsub_id =Widget_text(WID_BASE_2 ,xoffset=75,yoffset=155,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")

  fmax_id = Widget_label(WID_BASE_2,VALUE='Min Flux      Max Flux',xoffset=5,yoffset=180,SCR_XSIZE=120,SCR_YSIZE=15,FONT = "verdana*12")
  fluxmin_id=Widget_text(WID_BASE_2 ,xoffset=5,yoffset=195,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")
  fluxmax_id=Widget_text(WID_BASE_2 ,xoffset=75,yoffset=195,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")

  pup_label=Widget_label(WID_BASE_2,VALUE='Pupil Shift %',xoffset=5,yoffset=220,SCR_XSIZE=87,SCR_YSIZE=15,FONT = "verdana*12")
  pupshiftX_id= Widget_text(WID_BASE_2,VALUE='X',xoffset=5,yoffset=235,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")
  pupshiftY_id= Widget_text(WID_BASE_2,VALUE='Y',xoffset=75,yoffset=235,SCR_XSIZE=65,SCR_YSIZE=20,FONT = "verdana*12")

  focusterm_list=Widget_droplist(WID_BASE_2,VALUE=['ROC:','Focus@:'],xoffset=5,yoffset=265,SCR_XSIZE=80,SCR_YSIZE=20,UNAME='SLOPE',FONT = "verdana*12")
  focusterm_id= Widget_text(WID_BASE_2,xoffset=5,yoffset=290,SCR_XSIZE=115,SCR_YSIZE=20,FONT = "verdana*12")

  rotaterm_label=Widget_label(WID_BASE_2,VALUE='  Rotation (deg)',xoffset=3,yoffset=315,SCR_XSIZE=80,SCR_YSIZE=15,FONT = "verdana*12")
  rotaterm_id=Widget_text(WID_BASE_2,xoffset=5,yoffset=330,SCR_XSIZE=115,SCR_YSIZE=20,FONT = "verdana*12")

  WID_BASE_remove = Widget_Base(WID_BASE_0,COLUMN=1,/NONEXCLUSIVE,xoffset=1080,yoffset=0,SCR_XSIZE=155 ,SCR_YSIZE=120)
  affichepente_id = Widget_Button(WID_BASE_remove,/ALIGN_LEFT ,VALUE='Display Slopes',UNAME='SLOPE',FONT = "verdana*12")
  removetilt_id = Widget_Button(WID_BASE_remove,/ALIGN_LEFT ,VALUE='Remove Slope tilt',UNAME='SLOPE',FONT = "verdana*12")
  removefocus_id = Widget_Button(WID_BASE_remove,/ALIGN_LEFT ,VALUE='Remove Slope Focus+tilt',UNAME='SLOPE',FONT = "verdana*12")
  rota_id = Widget_Button(WID_BASE_remove,/ALIGN_LEFT ,VALUE='Remove Slope Rotation',UNAME='SLOPE',FONT = "verdana*12")
  removeslope_id = Widget_Button(WID_BASE_remove,/ALIGN_LEFT ,VALUE='Remove reference slopes',UNAME='SLOPE',FONT = "verdana*12")

;-----------------Slopes slider-------------------------------------------------------------------
slider_base= WIDGET_BASE(WID_BASE_0,xoffset=1090,yoffset=125,scr_xsize=150,scr_ysize=100)
normdisplay_id=CW_FSLIDER(slider_base,value=10,scroll=1,minimum=0,maximum=100,format='(I4)',$
				xsize=70,ysize=80,/suppress_value,/drag,UNAME='SLOPE')
magslop_label = widget_label(slider_base, xoffset=80, yoffset=3, VALUE='Magnify',FONT = "verdana*12")

;---------------TAB MENU SETTINGS-------------------------------------------------------------------------------------
tabmenu_id= WIDGET_TAB( WID_BASE_0,xoffset=5,yoffset=60,scr_xsize=380,scr_ysize=275,multiline=1,FONT = "verdana*12")

configtab_id=WIDGET_BASE(tabmenu_id,TITLE='CONFIG',xsize=380,ysize=250)
config_label=WIDGET_LABEL(configtab_id,xoffset=5,yoffset=08,VALUE='S&H CONFIG:',FONT = "verdana*12")
configdrop_id=Widget_droplist(configtab_id,xoffset=85,yoffset=05,SCR_XSIZE=115,/ALIGN_RIGHT,VALUE=['PICSIGHT-FULL','HOT','AOF','MAD','PICSIGHT','CUSTOM'],FONT = "verdana*12")

configpara_base=WIDGET_BASE(configtab_id,xoffset=0,yoffset=25,xsize=200,ysize=300)
	nsub_label=WIDGET_LABEL(configpara_base,VALUE='# of subapertures:',xoffset=4,yoffset=10,FONT = "verdana*12")
	nsub_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=8,/editable,scr_xsize=50,SCR_YSIZE=15,Value='   40',UNAME='CONFIG',FONT = "verdana*12")
	npix_label=WIDGET_LABEL(configpara_base,VALUE='# of pixels per subapertures:',xoffset=4,yoffset=35,FONT = "verdana*12")
	npix_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=35,/editable,scr_xsize=50,SCR_YSIZE=15,Value='   24',UNAME='CONFIG',FONT = "verdana*12")
	firstfoc_label=WIDGET_LABEL(configpara_base,VALUE='Pupil lens focal length (mm):',xoffset=4,yoffset=60,FONT = "verdana*12")
	firstfoc_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=60,/editable,scr_xsize=50,SCR_YSIZE=15,Value='   75',UNAME='CONFIG',FONT = "verdana*12")
	lensletfoc_label=WIDGET_LABEL(configpara_base,VALUE='Lenslet focal length (mm):',xoffset=4,yoffset=85,FONT = "verdana*12")
	lensletfoc_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=85,/editable,scr_xsize=50,SCR_YSIZE=15,Value='   5.4',UNAME='CONFIG',FONT = "verdana*12")
	pixsize_label=WIDGET_LABEL(configpara_base,VALUE='Pixel size (mm):',xoffset=4,yoffset=110,FONT = "verdana*12")
	pixsize_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=110,/editable,scr_xsize=50,SCR_YSIZE=15,Value=' 0.006',UNAME='CONFIG',FONT = "verdana*12")
	pixscale_label=WIDGET_LABEL(configpara_base,VALUE='Pixel scale (arcsec/pixel):',xoffset=4,yoffset=135,FONT = "verdana*12")
	pixscale_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=135,/editable,scr_xsize=50,SCR_YSIZE=15,Value='  0.2',UNAME='CONFIG',FONT = "verdana*12")
	fratio_label=WIDGET_LABEL(configpara_base,VALUE='SH entrance F#:',xoffset=4,yoffset=160,FONT = "verdana*12")
	fratio_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=160,/editable,scr_xsize=50,SCR_YSIZE=15,Value='   13',UNAME='CONFIG',FONT = "verdana*12")
	sat_label=WIDGET_LABEL(configpara_base,VALUE='CCD saturation:',xoffset=4,yoffset=185,FONT = "verdana*12")
	sat_id=WIDGET_TEXT(configpara_base,xoffset=150,yoffset=185,/editable,scr_xsize=50,SCR_YSIZE=15,Value=' 3700',UNAME='CONFIG',FONT = "verdana*12")

largfoc_base=WIDGET_BASE(configtab_id,xoffset=215,yoffset=180,xsize=150,ysize=20,/NONEXCLUSIVE,frame=0)
largfoc_id=WIDGET_BUTTON(largfoc_base,xoffset=0,yoffset=0,VALUE='Check if large defocus',FONT = "verdana*12",UNAME='SLOPE')

pupconfig_base=WIDGET_BASE(configtab_id,xoffset=215,yoffset=35,xsize=150,ysize=135,frame=0)
	pup_label=WIDGET_LABEL(pupconfig_base,xoffset=5,yoffset=5,VALUE='PUPIL PARAMETERS:',FONT = "verdana*12")
	pupdiam_label=WIDGET_LABEL(pupconfig_base,xoffset=5,yoffset=26,VALUE='Diameter:',FONT = "verdana*12")
	pupdiambox_id=WIDGET_TEXT(pupconfig_base,xoffset=70,yoffset=25,scr_xsize=55,scr_ysize=15,/editable,Value='   40',UNAME='PUP',FONT = "verdana*12")
	obstruc_label=WIDGET_LABEL(pupconfig_base,VALUE='Obstruction:',xoffset=5,yoffset=51,FONT = "verdana*12")
	obstruc_id=WIDGET_TEXT(pupconfig_base,xoffset=70,yoffset=50,/editable,scr_xsize=55,scr_ysize=15,Value='   0.',UNAME='PUP',FONT = "verdana*12")

	xpup_label=WIDGET_LABEL(pupconfig_base,xoffset=5,yoffset=76,VALUE='X:',FONT = "verdana*12")
	xpup_id=WIDGET_TEXT(pupconfig_base,xoffset=25,yoffset=75,scr_xsize=40,scr_ysize=15,/editable,Value='  20',UNAME='PUP',FONT = "verdana*12")
	ypup_label=WIDGET_LABEL(pupconfig_base,xoffset=75,yoffset=76,VALUE='Y:',FONT = "verdana*12")
	ypup_id=WIDGET_TEXT(pupconfig_base,xoffset=95,yoffset=75,scr_xsize=40,scr_ysize=15,/editable,Value='  20',UNAME='PUP',FONT = "verdana*12")

	mask_label=WIDGET_LABEL(pupconfig_base,xoffset=5,yoffset=103,VALUE='Vignet:',FONT = "verdana*12")
	mask_base=WIDGET_BASE(pupconfig_base,xoffset=40,yoffset=100,xsize=70)
	mask_id=CW_FSLIDER(mask_base,xsize=65,value=95,scroll=1,minimum=0,maximum=100,/suppress_value,UNAME='PUP')
	maskbox_id=WIDGET_TEXT(pupconfig_base,xoffset=115,yoffset=102,scr_xsize=30,scr_ysize=15,VALUE=' 5',FONT = "verdana*12")

aligntab_id=WIDGET_BASE(tabmenu_id,TITLE='ALIGN',xsize=350,ysize=250)
	cross_label=WIDGET_LABEL(aligntab_id,VALUE='Display target on:',xoffset=10,yoffset=10)
	alignspotX_id=WIDGET_TEXT(aligntab_id,xoffset=10,yoffset=30,scr_xsize=150,scr_ysize=60,FONT = "verdana*55")
	alignspotY_id=WIDGET_TEXT(aligntab_id,xoffset=200,yoffset=30,scr_xsize=150,scr_ysize=60,FONT = "verdana*55")

FSTOPtab_id=WIDGET_BASE(tabmenu_id,TITLE='FSTOP',xsize=380,ysize=250)
	apimage_id = Widget_Draw(FSTOPtab_id,XOFFSET=10 ,YOFFSET=20 ,SCR_XSIZE=150 ,SCR_YSIZE=150)
	FSTOPX_id=WIDGET_TEXT(FSTOPtab_id,xoffset=10,yoffset=180,scr_xsize=70,scr_ysize=30,FONT = "verdana*20")
	FSTOPY_id=WIDGET_TEXT(FSTOPtab_id,xoffset=90,yoffset=180,scr_xsize=70,scr_ysize=30,FONT = "verdana*20")
	scrimage_id = Widget_Draw(FSTOPtab_id,XOFFSET=200 ,YOFFSET=20 ,SCR_XSIZE=150 ,SCR_YSIZE=150)
	SCrX_id=WIDGET_TEXT(FSTOPtab_id,xoffset=200,yoffset=180,scr_xsize=70,scr_ysize=30,FONT = "verdana*20")
	SCrY_id=WIDGET_TEXT(FSTOPtab_id,xoffset=280,yoffset=180,scr_xsize=70,scr_ysize=30,FONT = "verdana*20")

spottab_id=WIDGET_BASE(tabmenu_id,TITLE='SPOT',xsize=380,ysize=200)
	spot_label=WIDGET_LABEL(spottab_id,VALUE='Reference pixel',xoffset=30,yoffset=10)
	spot_Xlabel=WIDGET_LABEL(spottab_id,VALUE='X',xoffset=3,yoffset=33)
	spotx_id=WIDGET_TEXT(spottab_id,xoffset=20,yoffset=30,xsize=5,ysize=0.5,/editable)
	spot_Xlabel=WIDGET_LABEL(spottab_id,VALUE='Y',xoffset=70,yoffset=33)
	spoty_id=WIDGET_TEXT(spottab_id,xoffset=85,yoffset=30,xsize=6,ysize=0.5,/editable)
	platebase_id=WIDGET_BASE(spottab_id,xoffset=5,yoffset=55,/nonexclusive)
	plate_id=WIDGET_BUTTON(platebase_id,VALUE='Compute Plate Scale')
	platexy_id=WIDGET_droplist(spottab_id,VALUE=['Along X direction','Along Y direction'],xoffset=5,yoffset=85,scr_Xsize=120)
	platescale_label=WIDGET_LABEL(spottab_id,VALUE='Plate scale:',xoffset=5,yoffset=120,xsize=60,ysize=15)
	platescale_id=WIDGET_TEXT(spottab_id,xoffset=70,yoffset=115,xsize=10,ysize=1,/editable)

focustab_id=WIDGET_BASE(tabmenu_id,TITLE='FOCUS',xsize=250,ysize=200)
	focfactor_label=WIDGET_LABEL(focustab_id,VALUE='Focus linear correction factor',xoffset=10,yoffset=10)
	focfactor_id=WIDGET_TEXT(focustab_id,xoffset=20,yoffset=30,xsize=5,ysize=1,/editable)
	focoffset_label=WIDGET_LABEL(focustab_id,VALUE='Offset correction (mm):',xoffset=10,yoffset=55)
	focoffset_id=WIDGET_TEXT(focustab_id,xoffset=20,yoffset=75,xsize=5,ysize=1,/editable)

derotab_id=WIDGET_BASE(tabmenu_id,TITLE='DERO',xsize=200,ysize=200)
	dero_label=WIDGET_LABEL(derotab_id,VALUE='No specific parameter for this program',xoffset=3,yoffset=33)

curvtab_id=WIDGET_BASE(tabmenu_id,TITLE='CURV',xsize=200,ysize=200)
	curvxy_label=WIDGET_LABEL(curvtab_id,VALUE='Carracters before coordinates:',xoffset=3,yoffset=10)
	curvx_label=WIDGET_LABEL(curvtab_id,VALUE='X:',xoffset=5,yoffset=30)
	curvx_id=WIDGET_TEXT(curvtab_id,xoffset=20,yoffset=25,xsize=5,ysize=0.5,/editable)
	curvy_label=WIDGET_LABEL(curvtab_id,VALUE='Y:',xoffset=85,yoffset=30)
	curvy_id=WIDGET_TEXT(curvtab_id,xoffset=100,yoffset=25,xsize=5,ysize=0.5,/editable)
	curvonly_id=WIDGET_BASE(curvtab_id,xoffset=5,yoffset=55,/nonexclusive)
	curvdisp_id=WIDGET_BUTTON(curvonly_id,VALUE='Display curvature only')
	curvonaxis_label=WIDGET_LABEL(curvtab_id,VALUE='On-axis coordinates (mm):',xoffset=3,yoffset=90)
	centrex_label=WIDGET_LABEL(curvtab_id,VALUE='X:',xoffset=5,yoffset=110,xsize=10,ysize=0.5)
	centrex_id=WIDGET_TEXT(curvtab_id,xoffset=25,yoffset=105,xsize=5,ysize=0.5,/editable)
	centrey_label=WIDGET_LABEL(curvtab_id,VALUE='Y:',xoffset=80,yoffset=110,xsize=10,ysize=0.5)
	centrey_id=WIDGET_TEXT(curvtab_id,xoffset=100,yoffset=105,xsize=5,ysize=0.5,/editable)

;-----------------PARAMETERS STRUCTURE----------------------------------------------------------
;passage des valeurs par default et des id sur le user value de la base
r={		affichepente:0,imagepath:'',imreload_id:imreload_id,$
		slopes:fltarr(50,50,2),messagelog:'',identifier:'.fits',$
		setup_id:setup_id,image_id:image_id,subimage_id:subimage_id,tiltterm:[0,0],focusterm:0,$
		imagepath_id:imagepath_id,openimage_id:openimage_id,saveslope_id:saveslope_id,savewf_id:savewf_id,$
		filelist_id:filelist_id,filelist:strarr(100),filenumber:0,saveflux_id:saveflux_id,saveall_id:saveall_id,$
		affichepente_id:affichepente_id,messagelog_id:messagelog_id,$
		refslope_id:refslope_id,refwf_id:refwf_id,refslope:fltarr(50,50,2),refwf:fltarr(50,50),refpath:'',$
		rota_id:rota_id,rota:0,rotaterm_id:rotaterm_id,wfpv_id:wfpv_id,wfpv:0,wfrms_id:wfrms_id,wfrms:0,$
		loadconfig_id:loadconfig_id,identifier_id:identifier_id,$
		start_id:start_id,clearlog_id:clearlog_id,live_id:live_id,live:'OFF', $
		fpos_id:fpos_id,fmax_id:fmax_id,fmax:long([0,0]),subapX_id:subapX_id,subapY_id:subapY_id,$
		tilttype:0,tiltterm_list:tiltterm_list,focusterm_id:focusterm_id,focusterm_list:focusterm_list,$
		normdisplay_id:normdisplay_id,normdisplay:10,$
		removetilt_id:removetilt_id,removetilt:0,removefocus_id:removefocus_id,removefocus:0,focusroc:0,$
		spotx_id:spotx_id,spoty_id:spoty_id,spotxy:[0,0],tab:0,plate_id:plate_id,plate:0,platexy_id:platexy_id,platexy:0,$
		tabmenu_id:tabmenu_id,focfactor_id:focfactor_id,focfactor:1.0,focoffset_id:focoffset_id,focoffset:0.0, $
		alignspotX_id:alignspotX_id,alignspotY_id:alignspotY_id,$
		curvx_id:curvx_id,curvy_id:curvy_id,curvxy:['X','Y'],curvdisp_id:curvdisp_id,curvdisp:0,centrex_id:centrex_id, $
		centrey_id:centrey_id,centrexy:[0,0],platescale_id:platescale_id,platescale:0.3,$
		nsub_id:nsub_id,nsub:40,npix_id:npix_id,npix:24,firstfoc_id:firstfoc_id,firstfoc:75.,$
		lensletfoc_id:lensletfoc_id,lensletfoc:5.4,pixsize_id:pixsize_id,pixsize:0.006,pixscale_id:pixscale_id,pixscale:0.2,$
		config:'PICSIGHT-FULL',configdrop_id:configdrop_id,$
		mask_id:mask_id,mask:95,maskbox_id:maskbox_id,pupdiambox_id:pupdiambox_id,pupdiam:40.,$
		obstruc_id:obstruc_id,obstruc:0.0,xpup_id:xpup_id,ypup_id:ypup_id,xpup:20,ypup:20,maskarray:intarr(100,100),$
		fratio_id:fratio_id,fratio:13,sat_id:sat_id,sat:3700,largfoc_id:largfoc_id,largfoc:0,$
		tag_id:tag_id,tag:0,taglist:strarr(10),datatype:'frames',image:fltarr(1024,1024),$
		subXpos_id:subXpos_id,subYpos_id:subYpos_id,tip_id:tip_id,tilt_id:tilt_id,fluxmin_id:fluxmin_id,fluxmax_id:fluxmax_id,$
		fluxmap_id:fluxmap_id,fluxmap:0,fluxsub:fltarr(50,50),fsub_id:fsub_id,pupshiftX_id:pupshiftX_id,pupshiftY_id:pupshiftY_id,$
		coldrop_id:coldrop_id,coldrop:8,colstretch_id:colstretch_id,colstretch:1.0,coldraw_id:coldraw_id,$
		dispwf_id:dispwf_id,wfmap:fltarr(50,50),wfcompute_id:wfcompute_id,display:0,dispSH_id:dispSH_id, lineimage_id:lineimage_id,zern:fltarr(40),$
		wftilt_id:wftilt_id,wffocus_id:wffocus_id,wfastig_id:wfastig_id,wfcoma_id:wfcoma_id,wftrefoil_id:wftrefoil_id,$
		wfspherical_id:wfspherical_id,wfremove:[0,0,0,0,0,0],wfaccuracy_id:wfaccuracy_id,wfaccuracy:0.1,wfaccuracybox_id:wfaccuracybox_id,$
		zernikelog_id:zernikelog_id,dispref_id:dispref_id,reftype:'',removeslope_id:removeslope_id,removewf_id:removewf_id,removeslope:0,removewf:0,$
		apimage_id:apimage_id,fstopx_id:fstopx_id,fstopy_id:fstopy_id,scrimage_id:scrimage_id,scrx_id:scrx_id,scry_id:scry_id}

WIDGET_CONTROL,WID_BASE_0,SET_UVALUE=r,/no_copy


  Widget_Control, /REALIZE, WID_BASE_0

  XManager, 'WID_BASE_0', WID_BASE_0, /NO_BLOCK

end
;
; Empty stub procedure used for autoloading.
;
pro SH_process_V3c, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
Device,Decomposed=0
WID_BASE_0, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
end
