PRO spotsize,path,identifier,Xc,Yc,fullwidth,plate,background,taglist,tagnumber,datatype,platescale=platescale,$
					platexy=platexy,removeback=removeback,CONFIG=CONFIG,TAGNAME=TAGNAME,SHCONFIG=SHCONFIG

;	PURPOSE:	measure spot size and eventually plate scale
;				for each position take the flux of a given pixel, make a gaussian fit of the curve and compute fullwidth and centroid
;				if platescale is set take a second adjacent pixel, do the same as for the first and measure the distance between the centroids
;				Input data should be images by moving the entrance fibre along X or Y axis in the range of 3 full SH pixels
;				Sampling should be at least 10 measurements per pixel
;
;	INPUTS: 	path: string array, list of filepath to be read, pathname should contain coordinate
;				identifier: recurent carrater(s) preceding the X or Y coordinate in the pathname like for instance X_ or Y_
;				Xc,Yc:reference pixel coordinates
;				background: background image to be subtracted

;	OUTPUT:		fullwidth: scalar containing the gaussian fullwidth
;				plate: scalar containing computed plate scale
;
;	KEYWORDS:	PLATESCALE=1 if plate scale should be computed
;				REMOVEBACK=1 if background subtraction should be performed ELSE REMOVEBACK=0
;				PLATEXY=0 if the spot is moving along the x pixel axis PLATEXY=1 if moving along y pixel axis


Xaxis=0
Yaxis1=0
Yaxis2=0
dx=0

nsub=SHCONFIG(0) & npix=SHCONFIG(1) & firstlensfocal=SHCONFIG(2) & lensletfocal=SHCONFIG(3) & pixelsize=SHCONFIG(4)*1000
fratio=SHCONFIG(6)
cube=fltarr(nsub*npix,nsub*npix,n_elements(path))

for k=0,N_elements(path)-1 do begin
	;frames=read_RTC(path(k),/average)
	read_rtc_fits,path(k),array,taglist,tagnumber,datatype,CONFIG=CONFIG,TAGNAME=TAGNAME

	if removeback EQ 1 then frames=frames-background
	cube(*,*,k)=array

	;looking for X axis value in the filename, it must be the last 4 digit
 	positionoffirst_Y=STRPOS(path(k),identifier,/reverse_search) ;detect where is the last "identifier" in the string
	if positionoffirst_y EQ -1 then print,'carracter identifer is not matching, be careful to lower case'
 	stringvalue=strmid(path(k),positionoffirst_Y+STRLEN(identifier),6); extract 6 digit after the last "identifier", the "-" is allowed

	;concatenation of axis values read in the filename (when axis specified), divide by 1000 to get mm
 	if positionoffirst_Y NE -1 then Xaxis=[Xaxis,long(stringvalue(0))/1000.0]

	;record pixel flux
	yaxis1=[yaxis1,cube(xc,yc,k)]
	if (platescale EQ 1) AND (platexy EQ 1) then yaxis2=[yaxis2,cube(xc,yc-1,k)];if spot moving along Y axis
	if (platescale EQ 1) AND (platexy EQ 0) then yaxis2=[yaxis2,cube(xc-1,yc,k)];if spoe moving along X axis
endfor

pscale=fratio*0.776/20.0 ; assuming VLT telescope in mm/arcsec

xaxis=xaxis[1:*]
yaxis1=yaxis1[1:*]
rightorder=sort(xaxis)
xaxis=xaxis([rightorder]) & yaxis1=yaxis1([rightorder])
;fit a gaussian and compute plate scale if requested
yfit1 = GAUSSFIT( Xaxis, Yaxis1, b1,NTERMS=4)
if platescale EQ 1 then begin
	yaxis2=yaxis2[1:*]
	yfit2 = GAUSSFIT( Xaxis, Yaxis2, b2,NTERMS=4)
	plate=(b2(1)-b1(1))/(pscale)
endif

;convert X axis from mm@fratio to microns at CCD level
xaxis=xaxis/(pscale*plate)*pixelsize

plot,xaxis-min(xaxis),yaxis1,psym=1,title='SPOT profile',xtitle='microns',ytitle='flux'
oplot,xaxis-min(xaxis),yfit1

if platescale EQ 1 then begin
	oplot,xaxis-min(xaxis),yaxis2,psym=1
	oplot,xaxis-min(xaxis),yfit2
endif

fullwidth=b1(2)*2*SQRT(2*ALOG(2))/(pscale*plate)*pixelsize



end