;+
;NAME:
;  FACT - compute n!
;SYNTAX:
;  n! = FACT(n)
;
;DESCRIPTION:
;  If N <= 18, FACT(N) is computed by:
;
;    N(N-1)(N-2)...(1)                    (1)
;
;  for greater values of N, FACT(N) is computed by:
;
;    exp(total(alog(1+dindgen(N))))       (2)
;
;  That is because (2) is faster than (1) (as soon as N > 4) but the choice
;  of 18 is dictated by the fact that 18! can still be stored in a double
;  without lost of precision.
;  
;ARGUMENT:
;  n - scalar integer in [0, 170]
;
;DIAGNOSTIC:
;  none
;
;SEE ALSO:
;
;HISTORY:
;
;-
FUNCTION Fact, n
    on_error, 2
    IF (n_elements(n) NE 1) THEN $
      message, "Syntax: n! = FACT(n) (n must be a scalar integer in [0, 170])"
    IF n LE 18 THEN BEGIN
        f =  1D
        FOR i = 2L, n DO f = f*i
        return, f
    END ELSE BEGIN
        return, exp(total(alog(1+dindgen(n))))
    END
END
