   ; ADD_ELEMENTS: add elements to 1-D vector.
   ; INPUT
   ;	v: original vector. If undefined, return elements
   ;	elements: elements to be added
   ; OUTPUT
   ;	Return vector with added elements. Output type same as vector type.

   FUNCTION add_elements, v, elements

	n = n_elements( v )
	if  n eq 0  then  return, elements
	if  mysize( v, /N_DIM ) gt 1  or $
		mysize( elements, /N_DIM ) gt 1  then  return, elements
	v_and_el = extend_array( v, n + n_elements( elements ) )
	v_and_el[n] = elements
	return, v_and_el
   end
