   ; ALL_MAX: find the local maxima above a fixed threshold in a given image.

   ; INPUT
   ;	image
   ;	[SX = , SY = ]: image sizes
   ;	threshold: minimum acceptable intensity for local maxima
   ; OUTPUT
   ;	x, y, i: coordinates and intensities of detected maxima
   ;	n: number of detected maxima

   PRO all_max, image, SX = sx, SY = sy, threshold, x, y, i, n

	if  n_elements( sx ) * n_elements( sy ) eq 0  then begin
	   if  mysize( image, /N_DIM ) ne 2  then  return
	   s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	endif
	ext_image = extend_array( image, sx + 2, sy + 2, X_OFF = 1, Y_OFF = 1 )
	m = bytarr( sx + 2, sy + 2 ) + 1B
	for  dx = -1, 1  do  for  dy = -1, 1  do $
;	if  abs( dx ) ne abs( dy )  then $		; 4-neighbors
	if  dx ne 0 or dy ne 0 then $			; 8-neighbors
	   m = temporary( m )  and  ext_image gt shift( ext_image, dx, dy )
    w = where( m[1:sx,1:sy] eq 1, n )
	if  n ne 0  then begin
	   i = image[w]  &  m = where( i ge threshold, n )
	endif
	if  n ne 0  then begin
	   i = i[m]  &  w = w[m]  &  x = w mod sx  &  y = w / sx
	endif
	if  n eq 1  then begin
	   x = x[0]  &  y = y[0]  &  i = i[0]
	endif
	return
   end