   ; ANGLE: compute the position angles of a set of points (x,y) respect
   ;	to the x-axis of a reference frame having the origin at (x0,y0).

   ; INPUT
   ;	x0, y0: position of origin
   ;	x, y: abscissae and ordinates of points
   ; OUTPUT
   ;	Return position angles of the points (x,y). Output angles are
   ;	measured in counter-clockwise sense in the range [0,2*pi[.

   FUNCTION angle, x0, y0, x, y

	on_error, 1
	if  n_elements( x0 ) ne 1 or n_elements( y0 ) ne 1 or $
		n_elements( x ) ne n_elements( y )  then  message, 'input data error'
	npt = n_elements( x )  &  a = fltarr( npt )
	for  n = 0L, npt - 1  do begin
	   dx = x[n] - float( x0 )  &  dy = y[n] - float( y0 )
	   if  dx eq 0 and dy eq 0  then  a[n] = 0 $
	   else if  dx eq 0	 then  a[n] = !pi/2	   $
	   else  a[n] = atan( dy / dx )
	   ; -pi/2 <= a <= pi/2
	   rot = ( (dx lt 0) or ((dx eq 0) and (dy lt 0))  )  and  1B  ; = 0, 1
	   a[n] = a[n] + rot * !pi
	   if  a[n] lt 0  then  a[n] = a[n] + 2*!pi
	   if  a[n] eq 2*!pi  then  a[n] = 0
	endfor
	if  npt eq 1  then  a = a[0]
 	return, a
   end
