   ; ARRAY_INTERSECTION: given two 2-D arrays, match position (x1,y1) of
   ; array 1 and position (x2,y2) of array 2 and determine bounds of the
   ; intersection, with respect to the reference frames of the two arrays.

   ; INPUT
   ;	array1, array2: 2-D arrays (with any size)
   ;	[X1 = ,Y1 = ]: position of reference pixel in array1 (default: max)
   ;	[X2 = ,Y2 = ]: position of reference pixel in array2 (default: max)
   ; OUTPUT
   ;	lx1, ux1, ly1, uy1: lower and upper x- and y- bounds of
   ;		intersection in array1
   ;	lx2, ux2, ly2, uy2: lower and upper x- and y- bounds of
   ;		intersection in array2



   ; INT_BOUNDS: auxiliary procedure.

   PRO int_bounds, p1, p2, size1, size2, l, u

	l = ( p1 - p2 ) > 0 < ( size1 - 1 )
	u = ( p1 + size2 - p2 - 1 ) > 0 < ( size1 - 1 )
	return
   end


   PRO array_intersection, array1, array2, $
   						   X1 = x1, Y1 = y1, X2 = x2, Y2 = y2, $
   						   lx1, ux1, ly1, uy1, lx2, ux2, ly2, uy2

	if  mysize( array1, /N_DIM ) ne 2 or $
		mysize( array2, /N_DIM ) ne 2  then  return
	s1 = mysize( array1, /DIM )  &  s2 = mysize( array2, /DIM )
	if  n_elements( x1 ) * n_elements( y1 ) * $
		n_elements( x2 ) * n_elements( y2 ) eq 0  then begin
	   m = get_max( array1 )  &  x1 = m[0]  &  y1 = m[1]
	   m = get_max( array2 )  &  x2 = m[0]  &  y2 = m[1]
	endif
	int_bounds, x1, x2, s1[0], s2[0], lx1, ux1
	int_bounds, y1, y2, s1[1], s2[1], ly1, uy1
	int_bounds, x2, x1, s2[0], s1[0], lx2, ux2
	int_bounds, y2, y1, s2[1], s1[1], ly2, uy2
	return
   end
